/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.model.meta;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.List;
import org.jupnp.model.Validatable;
import org.jupnp.model.ValidationError;
import org.jupnp.model.meta.Device;
import org.jupnp.model.types.BinHexDatatype;
import org.jupnp.util.MimeType;
import org.jupnp.util.SpecificationViolationReporter;
import org.jupnp.util.URIUtil;
import org.jupnp.util.io.IO;

public class Icon
implements Validatable {
    private final MimeType mimeType;
    private final int width;
    private final int height;
    private final int depth;
    private final URI uri;
    private final byte[] data;
    private Device device;

    public Icon(String mimeType, int width, int height, int depth, URI uri) {
        this(mimeType != null && !mimeType.isEmpty() ? MimeType.valueOf(mimeType) : null, width, height, depth, uri, null);
    }

    public Icon(String mimeType, int width, int height, int depth, URL url) throws IOException {
        this(mimeType, width, height, depth, new File(URIUtil.toURI(url)));
    }

    public Icon(String mimeType, int width, int height, int depth, File file) throws IOException {
        this(mimeType, width, height, depth, file.getName(), Files.readAllBytes(file.toPath()));
    }

    public Icon(String mimeType, int width, int height, int depth, String uniqueName, InputStream is) throws IOException {
        this(mimeType, width, height, depth, uniqueName, IO.readAllBytes(is));
    }

    public Icon(String mimeType, int width, int height, int depth, String uniqueName, byte[] data) {
        this(mimeType != null && !mimeType.isEmpty() ? MimeType.valueOf(mimeType) : null, width, height, depth, URI.create(uniqueName), data);
    }

    public Icon(String mimeType, int width, int height, int depth, String uniqueName, String binHexEncoded) {
        this(mimeType, width, height, depth, uniqueName, binHexEncoded != null && !binHexEncoded.isEmpty() ? new BinHexDatatype().valueOf(binHexEncoded) : null);
    }

    protected Icon(MimeType mimeType, int width, int height, int depth, URI uri, byte[] data) {
        this.mimeType = mimeType;
        this.width = width;
        this.height = height;
        this.depth = depth;
        this.uri = uri;
        this.data = data;
    }

    public MimeType getMimeType() {
        return this.mimeType;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getDepth() {
        return this.depth;
    }

    public URI getUri() {
        return this.uri;
    }

    public byte[] getData() {
        return this.data;
    }

    public Device getDevice() {
        return this.device;
    }

    void setDevice(Device device) {
        if (this.device != null) {
            throw new IllegalStateException("Final value has been set already, model is immutable");
        }
        this.device = device;
    }

    @Override
    public List<ValidationError> validate() {
        ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
        if (this.getMimeType() == null) {
            SpecificationViolationReporter.report(this.getDevice(), "Invalid icon, missing mime type: {}", this);
        }
        if (this.getWidth() == 0) {
            SpecificationViolationReporter.report(this.getDevice(), "Invalid icon, missing width: {}", this);
        }
        if (this.getHeight() == 0) {
            SpecificationViolationReporter.report(this.getDevice(), "Invalid icon, missing height: {}", this);
        }
        if (this.getDepth() == 0) {
            SpecificationViolationReporter.report(this.getDevice(), "Invalid icon, missing bitmap depth: {}", this);
        }
        if (this.getUri() == null) {
            errors.add(new ValidationError(this.getClass(), "uri", "URL is required"));
        } else {
            try {
                URL testURI = this.getUri().toURL();
                if (testURI == null) {
                    throw new MalformedURLException();
                }
            }
            catch (MalformedURLException e) {
                errors.add(new ValidationError(this.getClass(), "uri", "URL must be valid: " + e.getMessage()));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return errors;
    }

    public Icon deepCopy() {
        return new Icon(this.getMimeType(), this.getWidth(), this.getHeight(), this.getDepth(), this.getUri(), this.getData());
    }

    public String toString() {
        return "Icon(" + this.getWidth() + "x" + this.getHeight() + ", MIME: " + String.valueOf(this.getMimeType()) + ") " + String.valueOf(this.getUri());
    }
}

