/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.model.yaml.internal;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.fasterxml.jackson.dataformat.yaml.YAMLGenerator;
import com.fasterxml.jackson.dataformat.yaml.YAMLParser;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.model.yaml.YamlElement;
import org.openhab.core.model.yaml.YamlElementName;
import org.openhab.core.model.yaml.YamlModelListener;
import org.openhab.core.model.yaml.YamlModelRepository;
import org.openhab.core.model.yaml.internal.YamlModelWrapper;
import org.openhab.core.model.yaml.internal.items.YamlItemDTO;
import org.openhab.core.model.yaml.internal.semantics.YamlSemanticTagDTO;
import org.openhab.core.model.yaml.internal.things.YamlThingDTO;
import org.openhab.core.service.WatchService;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
@Component(immediate=true)
public class YamlModelRepositoryImpl
implements WatchService.WatchEventListener,
YamlModelRepository {
    private static final int DEFAULT_MODEL_VERSION = 1;
    private static final String VERSION = "version";
    private static final String READ_ONLY = "readOnly";
    private static final Set<String> KNOWN_ELEMENTS = Set.of(YamlModelRepositoryImpl.getElementName(YamlSemanticTagDTO.class), YamlModelRepositoryImpl.getElementName(YamlThingDTO.class), YamlModelRepositoryImpl.getElementName(YamlItemDTO.class));
    private static final String UNWANTED_EXCEPTION_TEXT = "at [Source: UNKNOWN; byte offset: #UNKNOWN] ";
    private static final List<Path> WATCHED_PATHS = Stream.of("things", "items", "tags", "yaml").map(string -> Path.of(string, new String[0])).toList();
    private final Logger logger = LoggerFactory.getLogger(YamlModelRepositoryImpl.class);
    private final WatchService watchService;
    private final Path mainWatchPath;
    private final ObjectMapper objectMapper;
    private final Map<String, List<YamlModelListener<?>>> elementListeners = new ConcurrentHashMap();
    private final Map<String, YamlModelWrapper> modelCache = new ConcurrentHashMap<String, YamlModelWrapper>();

    @Activate
    public YamlModelRepositoryImpl(@Reference(target="(watchservice.name=configWatcher)") WatchService watchService) {
        YAMLFactory yamlFactory = YAMLFactory.builder().disable(YAMLGenerator.Feature.WRITE_DOC_START_MARKER).disable(YAMLGenerator.Feature.SPLIT_LINES).enable(YAMLGenerator.Feature.INDENT_ARRAYS_WITH_INDICATOR).enable(YAMLGenerator.Feature.MINIMIZE_QUOTES).enable(YAMLParser.Feature.PARSE_BOOLEAN_LIKE_WORDS_AS_STRINGS).build();
        this.objectMapper = new ObjectMapper((JsonFactory)yamlFactory);
        this.objectMapper.findAndRegisterModules();
        this.objectMapper.setVisibility(PropertyAccessor.ALL, JsonAutoDetect.Visibility.NONE);
        this.objectMapper.setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
        this.objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        this.objectMapper.enable(new JsonGenerator.Feature[]{JsonGenerator.Feature.WRITE_BIGDECIMAL_AS_PLAIN});
        this.watchService = watchService;
        this.mainWatchPath = watchService.getWatchPath();
        watchService.registerListener((WatchService.WatchEventListener)this, WATCHED_PATHS);
        WATCHED_PATHS.forEach(watchPath -> {
            Path fullPath = this.mainWatchPath.resolve((Path)watchPath);
            if (!Files.exists(fullPath, new LinkOption[0])) {
                return;
            }
            if (!Files.isDirectory(fullPath, new LinkOption[0])) {
                this.logger.warn("Expecting '{}' to be a directory, but it's a file. Ignoring it.", (Object)fullPath);
                return;
            }
            try {
                Files.walkFileTree(fullPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(@NonNullByDefault(value={}) Path file, @NonNullByDefault(value={}) BasicFileAttributes attrs) throws IOException {
                        if (attrs.isRegularFile()) {
                            YamlModelRepositoryImpl.this.processWatchEvent(WatchService.Kind.CREATE, file);
                        }
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult visitFileFailed(@NonNullByDefault(value={}) Path file, @NonNullByDefault(value={}) IOException exc) throws IOException {
                        String message = exc.getMessage();
                        if (file.toString().equals(message)) {
                            message = exc.getClass().getSimpleName();
                        }
                        YamlModelRepositoryImpl.this.logger.warn("Failed to process {}: {}", (Object)file.toAbsolutePath(), (Object)message);
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
            catch (IOException e) {
                this.logger.warn("Could not list YAML files in '{}', models might be missing: {}", watchPath, (Object)e.getMessage());
            }
        });
    }

    @Deactivate
    public void deactivate() {
        this.watchService.unregisterListener((WatchService.WatchEventListener)this);
    }

    public synchronized void processWatchEvent(WatchService.Kind kind, Path fullPath) {
        Path relativePath = this.mainWatchPath.relativize(fullPath);
        String modelName = relativePath.toString();
        if (!modelName.endsWith(".yaml") && !modelName.endsWith(".yml")) {
            this.logger.trace("Ignored {}", (Object)fullPath);
            return;
        }
        try {
            if (kind == WatchService.Kind.DELETE) {
                this.removeModel(modelName);
            } else if (!Files.isHidden(fullPath) && Files.isReadable(fullPath) && !Files.isDirectory(fullPath, new LinkOption[0])) {
                JsonNode fileContent = this.objectMapper.readTree(fullPath.toFile());
                JsonNode versionNode = fileContent.get(VERSION);
                if (versionNode == null || !versionNode.canConvertToInt()) {
                    this.logger.warn("Version is missing or not a number in model {}. Ignoring it.", (Object)modelName);
                    this.removeModel(modelName);
                    return;
                }
                int modelVersion = versionNode.asInt();
                if (modelVersion < 1 || modelVersion > 1) {
                    this.logger.warn("Model {} has version {}, but only versions between 1 and {} are supported. Ignoring it.", new Object[]{modelName, modelVersion, 1});
                    this.removeModel(modelName);
                    return;
                }
                if (kind == WatchService.Kind.CREATE) {
                    this.logger.info("Adding YAML model {}", (Object)modelName);
                } else {
                    this.logger.info("Updating YAML model {}", (Object)modelName);
                }
                JsonNode readOnlyNode = fileContent.get(READ_ONLY);
                boolean readOnly = readOnlyNode == null || readOnlyNode.asBoolean(false);
                YamlModelWrapper model = Objects.requireNonNull(this.modelCache.computeIfAbsent(modelName, k -> new YamlModelWrapper(modelVersion, readOnly)));
                ArrayList<String> newElementNames = new ArrayList<String>();
                Iterator it = fileContent.fields();
                while (it.hasNext()) {
                    Map.Entry element = (Map.Entry)it.next();
                    String elementName = (String)element.getKey();
                    if (elementName.equals(VERSION) || elementName.equals(READ_ONLY)) continue;
                    newElementNames.add(elementName);
                    JsonNode node = (JsonNode)element.getValue();
                    if (!node.isContainerNode() || node.isArray()) {
                        this.logger.warn("Element {} in model {} is not a container object, ignoring it", (Object)elementName, (Object)modelName);
                        if (!YamlModelRepositoryImpl.getElementName(YamlSemanticTagDTO.class).equals(elementName) || !node.isArray()) continue;
                        this.logger.warn("Your YAML model {} contains custom tags with an old and now unsupported syntax. An upgrade of this model is required to upgrade to the new syntax. This can be done by running the upgrade tool.", (Object)modelName);
                        continue;
                    }
                    JsonNode newNodeElements = node;
                    JsonNode oldNodeElements = model.getNodes().get(elementName);
                    for (YamlModelListener<?> elementListener : this.getElementListeners(elementName, modelVersion)) {
                        Class<?> elementClass = elementListener.getElementClass();
                        ArrayList<String> errors = new ArrayList<String>();
                        ArrayList<String> warnings = new ArrayList<String>();
                        Map<String, ? extends YamlElement> oldElements = this.listToMap(this.parseJsonMapNode(oldNodeElements, elementClass, null, null));
                        Map<String, ? extends YamlElement> newElements = this.listToMap(this.parseJsonMapNode(newNodeElements, elementClass, errors, warnings));
                        errors.forEach(error -> this.logger.warn("YAML model {}: {}", (Object)modelName, error));
                        warnings.forEach(warning -> this.logger.info("YAML model {}: {}", (Object)modelName, warning));
                        List<YamlElement> addedElements = newElements.values().stream().filter(e -> !oldElements.containsKey(e.getId())).toList();
                        List<YamlElement> removedElements = oldElements.values().stream().filter(e -> !newElements.containsKey(e.getId())).toList();
                        List<YamlElement> updatedElements = newElements.values().stream().filter(e -> oldElements.containsKey(e.getId()) && !e.equals(oldElements.get(e.getId()))).toList();
                        if (!(!elementListener.isDeprecated() || addedElements.isEmpty() && updatedElements.isEmpty())) {
                            this.logger.warn("Element {} in model {} version {} is still supported but deprecated, please consider migrating your model to a more recent version", new Object[]{elementName, modelName, modelVersion});
                        }
                        if (!addedElements.isEmpty()) {
                            elementListener.addedModel(modelName, addedElements);
                        }
                        if (!removedElements.isEmpty()) {
                            elementListener.removedModel(modelName, removedElements);
                        }
                        if (updatedElements.isEmpty()) continue;
                        elementListener.updatedModel(modelName, updatedElements);
                    }
                    model.getNodes().put(elementName, newNodeElements);
                }
                model.getNodes().entrySet().removeIf(e -> {
                    String elementName = (String)e.getKey();
                    if (newElementNames.contains(elementName)) {
                        return false;
                    }
                    JsonNode removedNode = (JsonNode)e.getValue();
                    this.getElementListeners(elementName, modelVersion).forEach(listener -> {
                        List removedElements = this.parseJsonMapNode(removedNode, listener.getElementClass(), null, null);
                        listener.removedModel(modelName, removedElements);
                    });
                    return true;
                });
                this.checkElementNames(modelName, model);
            } else {
                this.logger.trace("Ignored {}", (Object)fullPath);
            }
        }
        catch (IOException e2) {
            this.logger.warn("Failed to process model {}: {}", (Object)modelName, (Object)e2.getMessage());
        }
    }

    private void removeModel(String modelName) {
        YamlModelWrapper removedModel = this.modelCache.remove(modelName);
        if (removedModel == null) {
            return;
        }
        this.logger.info("Removing YAML model {}", (Object)modelName);
        int version = removedModel.getVersion();
        for (Map.Entry<String, JsonNode> modelEntry : removedModel.getNodes().entrySet()) {
            String elementName = modelEntry.getKey();
            JsonNode removedMapNode = modelEntry.getValue();
            if (removedMapNode == null) continue;
            this.getElementListeners(elementName, version).forEach(listener -> {
                List removedElements = this.parseJsonMapNode(removedMapNode, listener.getElementClass(), null, null);
                listener.removedModel(modelName, removedElements);
            });
        }
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    public void addYamlModelListener(YamlModelListener<? extends YamlElement> listener) {
        Class<? extends YamlElement> elementClass = listener.getElementClass();
        String elementName = YamlModelRepositoryImpl.getElementName(elementClass);
        Objects.requireNonNull(this.elementListeners.computeIfAbsent(elementName, k -> new CopyOnWriteArrayList())).add(listener);
        this.modelCache.forEach((modelName, model) -> {
            JsonNode modelMapNode;
            int modelVersion = model.getVersion();
            if (!listener.isVersionSupported(modelVersion)) {
                return;
            }
            if (listener.isDeprecated()) {
                this.logger.warn("Element {} in model {} version {} is still supported but deprecated, please consider migrating your model to a more recent version", new Object[]{elementName, modelName, modelVersion});
            }
            if ((modelMapNode = model.getNodes().get(elementName)) == null) {
                return;
            }
            ArrayList<String> errors = new ArrayList<String>();
            ArrayList<String> warnings = new ArrayList<String>();
            List modelElements = this.parseJsonMapNode(modelMapNode, elementClass, errors, warnings);
            errors.forEach(error -> this.logger.warn("YAML model {}: {}", modelName, error));
            warnings.forEach(warning -> this.logger.info("YAML model {}: {}", modelName, warning));
            listener.addedModel((String)modelName, modelElements);
            this.checkElementNames((String)modelName, (YamlModelWrapper)model);
        });
    }

    public void removeYamlModelListener(YamlModelListener<? extends YamlElement> listener) {
        String elementName = YamlModelRepositoryImpl.getElementName(listener.getElementClass());
        this.elementListeners.computeIfPresent(elementName, (k, v) -> {
            v.remove(listener);
            return v.isEmpty() ? null : v;
        });
    }

    private void checkElementNames(String modelName, YamlModelWrapper model) {
        Set<String> elementListenerNames = this.elementListeners.keySet();
        if (elementListenerNames.containsAll(KNOWN_ELEMENTS)) {
            Set<String> modelElementNames = model.getNodes().keySet();
            modelElementNames.stream().filter(e -> !KNOWN_ELEMENTS.contains(e)).forEach(unknownElement -> this.logger.warn("Element '{}' in model {} is unknown.", unknownElement, (Object)modelName));
        }
    }

    private static String getElementName(Class<? extends YamlElement> elementClass) {
        YamlElementName annotation = elementClass.getAnnotation(YamlElementName.class);
        if (annotation == null) {
            throw new IllegalStateException("Class " + elementClass.getName() + " is missing the mandatory YamlElementName annotation. This is a bug.");
        }
        return annotation.value();
    }

    @Override
    public void addElementToModel(String modelName, YamlElement element) {
        String elementName = YamlModelRepositoryImpl.getElementName(element.getClass());
        String id = element.getId();
        YamlModelWrapper model = Objects.requireNonNull(this.modelCache.computeIfAbsent(modelName, k -> new YamlModelWrapper(1, false)));
        if (model.isReadOnly()) {
            this.logger.warn("Modifying {} is not allowed, model is marked read-only", (Object)modelName);
            return;
        }
        JsonNode mapAddedNode = this.objectMapper.valueToTree(Map.of(id, element.cloneWithoutId()));
        JsonNode modelMapNode = model.getNodes().get(elementName);
        if (modelMapNode == null) {
            model.getNodes().put(elementName, mapAddedNode);
        } else {
            JsonNode newNode = (JsonNode)this.objectMapper.convertValue((Object)element.cloneWithoutId(), JsonNode.class);
            ((ObjectNode)modelMapNode).set(id, newNode);
        }
        for (YamlModelListener<?> l : this.getElementListeners(elementName, model.getVersion())) {
            ArrayList<String> errors = new ArrayList<String>();
            ArrayList<String> warnings = new ArrayList<String>();
            List<?> newElements = this.parseJsonMapNode(mapAddedNode, l.getElementClass(), errors, warnings);
            errors.forEach(error -> this.logger.warn("YAML model {}: {}", (Object)modelName, error));
            warnings.forEach(warning -> this.logger.info("YAML model {}: {}", (Object)modelName, warning));
            if (newElements.isEmpty()) continue;
            l.addedModel(modelName, newElements);
        }
        this.writeModel(modelName);
    }

    @Override
    public void removeElementFromModel(String modelName, YamlElement element) {
        String elementName = YamlModelRepositoryImpl.getElementName(element.getClass());
        String id = element.getId();
        YamlModelWrapper model = this.modelCache.get(modelName);
        if (model == null) {
            this.logger.warn("Failed to remove {} from model {} because the model is not known.", (Object)element, (Object)modelName);
            return;
        }
        if (model.isReadOnly()) {
            this.logger.warn("Modifying {} is not allowed, model is marked read-only", (Object)modelName);
            return;
        }
        JsonNode modelMapNode = model.getNodes().get(elementName);
        if (modelMapNode == null) {
            this.logger.warn("Failed to remove {} from model {} because type {} is not known in the model.", new Object[]{element, modelName, elementName});
            return;
        }
        if (!modelMapNode.has(id)) {
            this.logger.warn("Failed to remove {} from model {} because element is not in model.", (Object)element, (Object)modelName);
            return;
        }
        ((ObjectNode)modelMapNode).remove(id);
        JsonNode mapRemovedNode = this.objectMapper.valueToTree(Map.of(id, element.cloneWithoutId()));
        for (YamlModelListener<?> l : this.getElementListeners(elementName, model.getVersion())) {
            List<?> oldElements = this.parseJsonMapNode(mapRemovedNode, l.getElementClass(), null, null);
            if (oldElements.isEmpty()) continue;
            l.removedModel(modelName, oldElements);
        }
        this.writeModel(modelName);
    }

    @Override
    public void updateElementInModel(String modelName, YamlElement element) {
        String elementName = YamlModelRepositoryImpl.getElementName(element.getClass());
        String id = element.getId();
        YamlModelWrapper model = this.modelCache.get(modelName);
        if (model == null) {
            this.logger.warn("Failed to update {} in model {} because the model is not known.", (Object)element, (Object)modelName);
            return;
        }
        if (model.isReadOnly()) {
            this.logger.warn("Modifying {} is not allowed, model is marked read-only", (Object)modelName);
            return;
        }
        JsonNode modelMapNode = model.getNodes().get(elementName);
        if (modelMapNode == null) {
            this.logger.warn("Failed to update {} in model {} because type {} is not known in the model.", new Object[]{element, modelName, elementName});
            return;
        }
        if (!modelMapNode.has(id)) {
            this.logger.warn("Failed to update {} in model {} because element is not in model.", (Object)element, (Object)modelName);
            return;
        }
        JsonNode newNode = (JsonNode)this.objectMapper.convertValue((Object)element.cloneWithoutId(), JsonNode.class);
        ((ObjectNode)modelMapNode).set(id, newNode);
        JsonNode mapUpdatedNode = this.objectMapper.valueToTree(Map.of(id, element.cloneWithoutId()));
        for (YamlModelListener<?> l : this.getElementListeners(elementName, model.getVersion())) {
            ArrayList<String> errors = new ArrayList<String>();
            ArrayList<String> warnings = new ArrayList<String>();
            List<?> newElements = this.parseJsonMapNode(mapUpdatedNode, l.getElementClass(), errors, warnings);
            errors.forEach(error -> this.logger.warn("YAML model {}: {}", (Object)modelName, error));
            warnings.forEach(warning -> this.logger.info("YAML model {}: {}", (Object)modelName, warning));
            if (newElements.isEmpty()) continue;
            l.updatedModel(modelName, newElements);
        }
        this.writeModel(modelName);
    }

    private void writeModel(String modelName) {
        YamlModelWrapper model = this.modelCache.get(modelName);
        if (model == null) {
            this.logger.warn("Failed to write model {} to disk because it is not known.", (Object)modelName);
            return;
        }
        if (model.isReadOnly()) {
            this.logger.warn("Failed to write model {} to disk because it is marked as read-only.", (Object)modelName);
            return;
        }
        JsonNodeFactory nodeFactory = this.objectMapper.getNodeFactory();
        ObjectNode rootNode = nodeFactory.objectNode();
        rootNode.put(VERSION, model.getVersion());
        rootNode.put(READ_ONLY, model.isReadOnly());
        for (Map.Entry<String, JsonNode> elementNodes : model.getNodes().entrySet()) {
            if (elementNodes.getValue() == null) continue;
            rootNode.set(elementNodes.getKey(), elementNodes.getValue());
        }
        try {
            Path outFile = this.mainWatchPath.resolve(modelName);
            String fileContent = this.objectMapper.writeValueAsString((Object)rootNode);
            if (Files.exists(outFile, new LinkOption[0]) && !Files.isWritable(outFile)) {
                this.logger.warn("Failed writing model {}: model exists but is read-only.", (Object)modelName);
                return;
            }
            Files.writeString(outFile, (CharSequence)fileContent, new OpenOption[0]);
        }
        catch (JsonProcessingException e) {
            this.logger.warn("Failed to serialize model {}: {}", (Object)modelName, (Object)e.getMessage());
        }
        catch (IOException e) {
            this.logger.warn("Failed writing model {}: {}", (Object)modelName, (Object)e.getMessage());
        }
    }

    @Override
    public void generateSyntaxFromElements(OutputStream out, List<YamlElement> elements) {
        JsonNodeFactory nodeFactory = this.objectMapper.getNodeFactory();
        ObjectNode rootNode = nodeFactory.objectNode();
        rootNode.put(VERSION, 1);
        HashMap elementsPerTypes = new HashMap();
        elements.forEach(element -> {
            String elementName = YamlModelRepositoryImpl.getElementName(element.getClass());
            ArrayList<YamlElement> elts = (ArrayList<YamlElement>)elementsPerTypes.get(elementName);
            if (elts == null) {
                elts = new ArrayList<YamlElement>();
                elementsPerTypes.put(elementName, elts);
            }
            elts.add((YamlElement)element);
        });
        elementsPerTypes.entrySet().forEach(entry -> {
            LinkedHashMap mapElts = new LinkedHashMap();
            ((List)entry.getValue()).forEach(elt -> mapElts.put(elt.getId(), elt.cloneWithoutId()));
            rootNode.set((String)entry.getKey(), this.objectMapper.valueToTree(mapElts));
        });
        try {
            this.objectMapper.writeValue(out, (Object)rootNode);
        }
        catch (IOException e) {
            this.logger.warn("Failed to serialize model: {}", (Object)e.getMessage());
        }
    }

    private List<YamlModelListener<?>> getElementListeners(String elementName) {
        return this.elementListeners.getOrDefault(elementName, List.of());
    }

    private List<YamlModelListener<?>> getElementListeners(String elementName, int version) {
        return this.getElementListeners(elementName).stream().filter(l -> l.isVersionSupported(version)).toList();
    }

    private Map<String, ? extends YamlElement> listToMap(List<? extends YamlElement> elements) {
        return elements.stream().collect(Collectors.toMap(YamlElement::getId, e -> e));
    }

    private <T extends YamlElement> List<T> parseJsonMapNode(@Nullable JsonNode mapNode, Class<T> elementClass, @Nullable List<String> errors, @Nullable List<String> warnings) {
        ArrayList<YamlElement> elements = new ArrayList<YamlElement>();
        if (mapNode != null) {
            Iterator it = mapNode.fieldNames();
            while (it.hasNext()) {
                YamlElement elt;
                block8: {
                    String id = (String)it.next();
                    elt = null;
                    JsonNode node = mapNode.get(id);
                    if (node.isEmpty()) {
                        try {
                            elt = (YamlElement)elementClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                            elt.setId(id);
                        }
                        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                            if (errors != null) {
                                errors.add("could not create new instance of %s".formatted(elementClass.getSimpleName()));
                            }
                            break block8;
                        }
                    }
                    try {
                        elt = (YamlElement)this.objectMapper.treeToValue((TreeNode)node, elementClass);
                        elt.setId(id);
                    }
                    catch (JsonProcessingException e) {
                        if (errors == null) break block8;
                        String msg = e.getMessage();
                        errors.add("could not parse element %s to %s: %s".formatted(node.toPrettyString(), elementClass.getSimpleName(), msg == null ? "" : msg.replace(UNWANTED_EXCEPTION_TEXT, "")));
                    }
                }
                if (elt == null || !elt.isValid(errors, warnings)) continue;
                elements.add(elt);
            }
        }
        return elements;
    }
}

