/* A Bison parser, made by GNU Bison 3.8.2.  */

/* Bison implementation for Yacc-like parsers in C

   Copyright (C) 1984, 1989-1990, 2000-2015, 2018-2021 Free Software Foundation,
   Inc.

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <https://www.gnu.org/licenses/>.  */

/* As a special exception, you may create a larger work that contains
   part or all of the Bison parser skeleton and distribute that work
   under terms of your choice, so long as that work isn't itself a
   parser generator using the skeleton or a modified version thereof
   as a parser skeleton.  Alternatively, if you modify or redistribute
   the parser skeleton itself, you may (at your option) remove this
   special exception, which will cause the skeleton and the resulting
   Bison output files to be licensed under the GNU General Public
   License without this special exception.

   This special exception was added by the Free Software Foundation in
   version 2.2 of Bison.  */

/* C LALR(1) parser skeleton written by Richard Stallman, by
   simplifying the original so-called "semantic" parser.  */

/* DO NOT RELY ON FEATURES THAT ARE NOT DOCUMENTED in the manual,
   especially those whose name start with YY_ or yy_.  They are
   private implementation details that can be changed or removed.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output, and Bison version.  */
#define YYBISON 30802

/* Bison version string.  */
#define YYBISON_VERSION "3.8.2"

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 0

/* Push parsers.  */
#define YYPUSH 0

/* Pull parsers.  */
#define YYPULL 1




/* First part of user prologue.  */
#line 32 "parser.y"

/** @endcond */

// local
#include "pjl_config.h"                 /* must go first */
#include "c_ast.h"
#include "c_ast_check.h"
#include "c_ast_util.h"
#include "c_keyword.h"
#include "c_lang.h"
#include "c_operator.h"
#include "c_sglob.h"
#include "c_sname.h"
#include "c_type.h"
#include "c_typedef.h"
#include "cdecl.h"
#include "cdecl_keyword.h"
#include "color.h"
#include "dump.h"
#include "did_you_mean.h"
#include "english.h"
#include "gibberish.h"
#include "help.h"
#include "lexer.h"
#include "literals.h"
#include "options.h"
#include "p_macro.h"
#include "p_token.h"
#include "print.h"
#include "set_options.h"
#include "show.h"
#include "slist.h"
#include "types.h"
#include "util.h"

/// @cond DOXYGEN_IGNORE

// standard
#include <assert.h>
#include <ctype.h>
#include <stdarg.h>
#include <stdbool.h>
#include <stddef.h>                     /* for NULL, size_t */
#include <stdio.h>
#include <stdlib.h>

// Silence these warnings for Bison-generated code.
#ifdef __GNUC__
# pragma GCC diagnostic push
# pragma GCC diagnostic ignored "-Wconversion"
# pragma GCC diagnostic ignored "-Wredundant-decls"
# pragma GCC diagnostic ignored "-Wunreachable-code"
#endif /* __GNUC__ */

// Developer aid for tracing when Bison %destructors are called.
#if 0
#define DTRACE                    EPRINTF( "%d: destructor\n", __LINE__ )
#else
#define DTRACE                    NO_OP
#endif

/// @endcond

///////////////////////////////////////////////////////////////////////////////

/**
 * Checks whether \a AST is a #K_NAME and therefore an error (if \ref
 * opt_permissive_types is `false`) or merely a warning (if \ref
 * opt_permissive_types is `true`).
 *
 * @param AST The AST to check.
 * @return Returns `true` only if \a ast is a #K_NAME and therefore an error.
 */
#define c_ast_is_name_error(AST)  l_c_ast_is_name_error( __LINE__, (AST) )

/**
 * Checks whether \a SNAME is a type.
 *
 * @param SNAME The scoped name to check.
 * @param LOC The location of \a SNAME.
 * @return Returns `true` only if \a SNAME is a type (and prints an error
 * message); otherwise `false` (and does nothing).
 */
#define c_sname_is_type(SNAME,LOC) \
  fl_c_sname_is_type( __FILE__, __LINE__, (SNAME), (LOC) )

/**
 * @defgroup parser-group Parser
 * Helper macros, data structures, variables, functions, and the grammar for
 * C/C++ declarations.
 * @{
 */

/**
 * Calls #elaborate_error_dym() with #DYM_NONE.
 *
 * @param ... Arguments passed to l_elaborate_error().
 *
 * @note This must be used _only_ after an `error` token, e.g.:
 * ```
 *  | Y_define error
 *    {
 *      elaborate_error( "name expected" );
 *    }
 * ```
 * @note A newline _is_ printed.
 *
 * @sa elaborate_error_dym()
 * @sa keyword_expected()
 * @sa punct_expected()
 */
#define elaborate_error(...) \
  elaborate_error_dym( DYM_NONE, __VA_ARGS__ )

/**
 * Calls l_elaborate_error() followed by #PARSE_ABORT().
 *
 * @param DYM_KINDS The bitwise-or of \ref dym_kind_t things possibly meant.
 * @param ... Arguments passed to l_elaborate_error().
 *
 * @note This must be used _only_ after an `error` token, e.g.:
 * ```
 *  | error
 *    {
 *      elaborate_error_dym( DYM_COMMANDS, "unexpected token" );
 *    }
 * ```
 * @note A newline _is_ printed.
 *
 * @sa elaborate_error()
 * @sa keyword_expected()
 * @sa punct_expected()
 */
#define elaborate_error_dym(DYM_KINDS,...) BLOCK( \
  l_elaborate_error( __LINE__, (DYM_KINDS), __VA_ARGS__ ); PARSE_ABORT(); )

/**
 * Executes the given statements only if \ref opt_cdecl_debug `!=`
 * #CDECL_DEBUG_NO.
 *
 * @param ... The statement(s) to execute.
 */
#define IF_CDECL_DEBUG(...) \
  BLOCK( if ( opt_cdecl_debug != CDECL_DEBUG_NO ) { __VA_ARGS__ } )

/**
 * Prints that a particular language feature is not supported by **cdecl** and
 * will be ignored.
 *
 * @param LOC The location of what's being ignored.
 * @param WHAT The string literal of what is being ignored.  It may contain a
 * `printf()` format string.
 * @param ... The `printf()` arguments, if any.
 *
 * @sa #UNSUPPORTED()
 */
#define IGNORING(LOC,WHAT,...)                      \
  print_warning( (LOC),                             \
    WHAT " not supported by " CDECL " (ignoring)\n" \
    VA_OPT( (,), __VA_ARGS__ )                      \
  )

/**
 * Checks whether the type currently being declared (`enum`, `struct`,
 * `typedef`, or `union`) is nested within some other type (`struct` or
 * `union`) and whether the current language is C: if not, prints an error
 * message.
 *
 * @remarks In debug mode, also includes the file & line where the function was
 * called from in the error message.
 *
 * @param TYPE_LOC The location of the type declaration.
 * @return Returns `true` only if the type currently being declared is either
 * not nested or the current language is C++.
 *
 * @sa l_is_nested_type_ok()
 */
#define is_nested_type_ok(TYPE_LOC) \
  l_is_nested_type_ok( __LINE__, (TYPE_LOC) )

/**
 * Calls l_keyword_expected() followed by #PARSE_ABORT().
 *
 * @param KEYWORD A keyword literal.
 *
 * @note This must be used _only_ after an `error` token, e.g.:
 * ```
 *  : Y_virtual
 *  | error
 *    {
 *      keyword_expected( L_virtual );
 *    }
 * ```
 *
 * @sa elaborate_error()
 * @sa elaborate_error_dym()
 * @sa punct_expected()
 */
#define keyword_expected(KEYWORD) BLOCK ( \
  l_keyword_expected( __LINE__, (KEYWORD) ); PARSE_ABORT(); )

/**
 * Aborts the current parse after an error message has been printed.
 *
 * @sa #PARSE_ASSERT()
 */
#define PARSE_ABORT() \
  BLOCK( parse_cleanup( /*fatal_error=*/true ); YYABORT; )

/**
 * Evaluates \a EXPR: if `false`, calls #PARSE_ABORT().
 *
 * @param EXPR The expression to evalulate.
 */
#define PARSE_ASSERT(EXPR)        BLOCK( if ( !(EXPR) ) PARSE_ABORT(); )

/**
 * Calls l_punct_expected() followed by #PARSE_ABORT().
 *
 * @param PUNCT The punctuation character that was expected.
 *
 * @note This must be used _only_ after an `error` token, e.g.:
 * ```
 *  : ','
 *  | error
 *    {
 *      punct_expected( ',' );
 *    }
 * ```
 *
 * @sa elaborate_error()
 * @sa elaborate_error_dym()
 * @sa keyword_expected()
 */
#define punct_expected(PUNCT) BLOCK( \
  l_punct_expected( __LINE__, (PUNCT) ); PARSE_ABORT(); )

/**
 * Prints that a particular language feature is not supported by **cdecl** and
 * therefore an error followed by #PARSE_ABORT().
 *
 * @param LOC The location of what's not supported.
 * @param WHAT The string literal of what is being ignored.  It may contain a
 * `printf()` format string.
 * @param ... The `printf()` arguments, if any.
 *
 * @sa #IGNORING()
 */
#define UNSUPPORTED(LOC,WHAT,...) BLOCK(  \
  print_error( (LOC),                     \
    WHAT " not supported by " CDECL "\n"  \
    VA_OPT( (,), __VA_ARGS__ )            \
  );                                      \
  PARSE_ABORT(); )

/** @} */

///////////////////////////////////////////////////////////////////////////////

/**
 * @defgroup parser-dump-group Debugging Macros
 * Macros that are used to dump a trace during parsing when \ref
 * opt_cdecl_debug is set.
 * @ingroup parser-group
 * @{
 */

/**
 * Dumps \a ALIGN.
 *
 * @param KEY The key name to print.
 * @param ALIGN The \ref c_alignas to dump.
 */
#define DUMP_ALIGN(KEY,ALIGN) IF_CDECL_DEBUG( \
  DUMP_KEY_IMPL( KEY ": " ); c_alignas_dump( &(ALIGN), stdout ); )

/**
 * Dumps an AST.
 *
 * @param KEY The key name to print.
 * @param AST The AST to dump.
 *
 * @sa #DUMP_AST_LIST()
 * @sa #DUMP_AST_PAIR()
 */
#define DUMP_AST(KEY,AST) IF_CDECL_DEBUG( \
  DUMP_KEY_IMPL( KEY ": " ); c_ast_dump( (AST), stdout ); )

/**
 * Dumps an s_list of AST.
 *
 * @param KEY The key name to print.
 * @param AST_LIST The \ref slist of AST to dump.
 *
 * @sa #DUMP_AST()
 * @sa #DUMP_AST_PAIR()
 */
#define DUMP_AST_LIST(KEY,AST_LIST) IF_CDECL_DEBUG( \
  DUMP_KEY_IMPL( KEY ": " ); c_ast_list_dump( &(AST_LIST), stdout ); )

/**
 * Dump a \ref c_ast_pair.
 *
 * @param KEY The key name to print.
 * @param ASTP The \ref c_ast_pair to dump.
 *
 * @sa #DUMP_AST()
 */
#define DUMP_AST_PAIR(KEY,ASTP) IF_CDECL_DEBUG( \
  DUMP_KEY_IMPL( KEY ": " ); c_ast_pair_dump( &(ASTP), stdout ); )

/**
 * Dumps a `bool`.
 *
 * @param KEY The key name to print.
 * @param BOOL The `bool` to dump.
 */
#define DUMP_BOOL(KEY,BOOL)  IF_CDECL_DEBUG( \
  DUMP_KEY_IMPL( KEY ": " ); bool_dump( (BOOL), stdout ); )

/**
 * Ends a dump block.
 *
 * @sa #DUMP_START()
 */
#define DUMP_END()                IF_CDECL_DEBUG( PUTS( "\n}\n\n" ); )

/**
 * Possibly dumps a comma and a newline followed by the `printf()` arguments
 * --- used for printing a key followed by a value.
 *
 * @param ... The `printf()` arguments.
 *
 * @warning This _must_ only be called inside #IF_CDECL_DEBUG().
 */
#define DUMP_KEY_IMPL(...) BLOCK(         \
  fput_sep( ",\n", &dump_comma, stdout ); \
  PRINTF( "  " __VA_ARGS__ ); )

/**
 * Dumps an integer.
 *
 * @param KEY The key name to print.
 * @param NUM The integer to dump.
 *
 * @sa #DUMP_STR()
 */
#define DUMP_INT(KEY,NUM) IF_CDECL_DEBUG( \
  DUMP_KEY_IMPL( KEY ": %d", STATIC_CAST( int, (NUM) ) ); )

/**
 * Dumps a \ref p_macro.
 *
 * @param KEY The key name to print.
 * @param MACRO The \ref p_macro to dump.
 */
#define DUMP_MACRO(KEY,MACRO) IF_CDECL_DEBUG( \
  DUMP_KEY_IMPL( KEY ": " ); p_macro_dump( (MACRO), stdout ); )

/**
 * Dumps a list of macro arguments.
 *
 * @param KEY The key name to print.
 * @param ARG_LIST The list of arguments to dump.
 */
#define DUMP_MACRO_ARG_LIST(KEY,ARG_LIST) IF_CDECL_DEBUG( \
  if ( (ARG_LIST) != NULL ) {                             \
    DUMP_KEY_IMPL( KEY ": " );                            \
    p_arg_list_dump( (ARG_LIST), /*indent=*/1, stdout );  \
  } )

/**
 * Dumps a list of \ref p_param.
 *
 * @param KEY The key name to print.
 * @param PARAM_LIST The list of \ref p_param to dump.
 */
#define DUMP_MACRO_PARAM_LIST(KEY,PARAM_LIST) IF_CDECL_DEBUG( \
  if ( (PARAM_LIST) != NULL ) {                               \
    DUMP_KEY_IMPL( KEY ": " );                                \
    p_param_list_dump( (PARAM_LIST), /*indent=*/1, stdout );  \
  } )

/**
 * Dumps a list of \ref p_token.
 *
 * @param KEY The key name to print.
 * @param TOKEN_LIST The list of \ref p_token to dump.
 */
#define DUMP_MACRO_TOKEN_LIST(KEY,TOKEN_LIST) IF_CDECL_DEBUG( \
  if ( (TOKEN_LIST) != NULL ) {                               \
    DUMP_KEY_IMPL( KEY ": " );                                \
    p_token_list_dump( (TOKEN_LIST), /*indent=*/1, stdout );  \
  } )

/**
 * Starts a dump block.
 *
 * @remarks If a production has a result, it should be dumped as the final
 * thing before the #DUMP_END() with the KEY of `$$_` followed by a suffix
 * denoting the type, e.g., `ast`.  For example:
 * ```
 *  DUMP_START( "rule",
 *              "subrule_1 subrule_2 ..." );
 *  DUMP_AST( "subrule_1", $1 );
 *  DUMP_STR( "name", $2 );
 *  DUMP_AST( "subrule_2", $3 );
 *  // ...
 *  DUMP_AST( "$$_ast", $$ );
 *  DUMP_END();
 * ```
 *
 * @param NAME The grammar production name.
 * @param RULE The grammar production rule.
 *
 * @note The dump block _must_ end with #DUMP_END().
 *
 * @sa #DUMP_END()
 */
#define DUMP_START(NAME,RULE) \
  bool dump_comma = false;    \
  IF_CDECL_DEBUG( PUTS( "{\n  rule: {\n    lhs: \"" NAME "\",\n    rhs: \"" RULE "\"\n  },\n" ); )

/**
 * Dumps a scoped name.
 *
 * @param KEY The key name to print.
 * @param SNAME The scoped name to dump.
 *
 * @sa #DUMP_SNAME_LIST()
 * @sa #DUMP_STR()
 */
#define DUMP_SNAME(KEY,SNAME) IF_CDECL_DEBUG( \
  DUMP_KEY_IMPL( KEY ": " ); c_sname_dump( &(SNAME), stdout ); )

/**
 * Dumps a list of scoped names.
 *
 * @param KEY The key name to print.
 * @param LIST The list of scoped names to dump.
 *
 * @sa #DUMP_SNAME()
 */
#define DUMP_SNAME_LIST(KEY,LIST) IF_CDECL_DEBUG( \
  DUMP_KEY_IMPL( KEY ": " ); c_sname_list_dump( &(LIST), stdout ); )

/**
 * Dumps a C string.
 *
 * @param KEY The key name to print.
 * @param STR The C string to dump.
 *
 * @sa #DUMP_INT()
 * @sa #DUMP_SNAME()
 */
#define DUMP_STR(KEY,STR) IF_CDECL_DEBUG( \
  DUMP_KEY_IMPL( KEY ": " ); fputs_quoted( (STR), '"', stdout ); )

/**
 * Dumps a \ref c_tid_t.
 *
 * @param KEY The key name to print.
 * @param TID The \ref c_tid_t to dump.
 *
 * @sa #DUMP_TYPE()
 */
#define DUMP_TID(KEY,TID) IF_CDECL_DEBUG( \
  DUMP_KEY_IMPL( KEY ": " ); c_tid_dump( (TID), stdout ); )

/**
 * Dumps a \ref c_type.
 *
 * @param KEY The key name to print.
 * @param TYPE The \ref c_type to dump.
 *
 * @sa #DUMP_TID()
 */
#define DUMP_TYPE(KEY,TYPE) IF_CDECL_DEBUG( \
  DUMP_KEY_IMPL( KEY ": " ); c_type_dump( &(TYPE), stdout ); )

/** @} */

///////////////////////////////////////////////////////////////////////////////

/**
 * @addtogroup parser-group
 * @{
 */

/**
 * Inherited attributes.
 *
 * @remarks These are grouped into a `struct` (rather than having them as
 * separate global variables) so that they can all be reset (mostly) via a
 * single assignment from `{0}`.
 *
 * @sa ia_cleanup()
 */
struct in_attr {
  c_alignas_t     align;            ///< Alignment, if any.
  unsigned        ast_depth;        ///< Parentheses nesting depth.
  bool            is_typename;      ///< C++ only: is `typename` specified?
  c_sname_t       scope_sname;      ///< C++ only: current scope name, if any.

  /**
   * Type AST stack.
   *
   * @sa ia_type_ast_peek()
   * @sa ia_type_ast_pop()
   * @sa ia_type_ast_push()
   */
  c_ast_list_t    type_ast_stack;

  /**
   * Declaration type specifier AST.
   *
   * @remarks A C/C++ declaration is of the form:
   *
   *      type-specifier declarator+
   *
   * where one or more declarators all have the same base type, e.g.:
   *
   *      int i, *p, a[2], f(double);
   *
   * This is a pointer to the base type AST (above, `int`) that is duplicated
   * for each declarator.  It's set by the first call to ia_type_ast_push().
   *
   * @sa ia_type_spec_ast()
   */
  c_ast_t const  *type_spec_ast;

  /**
   * Red-black node for temporary `typedef`.
   *
   * @remarks This is used only in the `pc99_func_or_constructor_declaration_c`
   * grammar production. It's needed because a temporary `typedef` needs to be
   * created in a mid-rule action then removed in the end-rule action and
   * there's no way to pass local variables between Bison actions, so it's
   * passed via an inherited attribute.
   */
  rb_node_t      *tdef_rb;
};
typedef struct in_attr in_attr_t;

// local functions
PJL_PRINTF_LIKE_FUNC(3)
static void l_elaborate_error( int, dym_kind_t, char const*, ... );

PJL_DISCARD
static bool print_error_token( char const* );

// local variables
static c_ast_list_t   gc_ast_list;      ///< c_ast nodes freed after parse.
static in_attr_t      in_attr;          ///< Inherited attributes.
static c_ast_list_t   typedef_ast_list; ///< List of ASTs for `typedef`s.

////////// inline functions ///////////////////////////////////////////////////

/**
 * Duplicates \a ast and adds it to \ref gc_ast_list.
 *
 * @param ast The AST to duplicate.
 * @return Returns the duplicated AST.
 *
 * @sa c_ast_new_gc()
 */
static inline c_ast_t* c_ast_dup_gc( c_ast_t const *ast ) {
  return c_ast_dup( ast, &gc_ast_list );
}

/**
 * Garbage-collects the AST nodes on \a ast_list but does _not_ free \a
 * ast_list itself.
 *
 * @param ast_list The AST list to free the nodes of.
 *
 * @sa c_ast_list_cleanup()
 * @sa c_ast_dup_gc()
 * @sa c_ast_new_gc()
 * @sa c_ast_pair_new_gc()
 */
static inline void c_ast_list_cleanup_gc( c_ast_list_t *ast_list ) {
  slist_cleanup( ast_list, POINTER_CAST( slist_free_fn_t, &c_ast_free ) );
}

/**
 * Creates a new AST and adds it to \ref gc_ast_list.
 *
 * @param kind The kind of AST to create.
 * @param loc A pointer to the token location data.
 * @return Returns a pointer to a new AST.
 *
 * @sa c_ast_dup_gc()
 * @sa c_ast_pair_new_gc()
 */
NODISCARD
static inline c_ast_t* c_ast_new_gc( c_ast_kind_t kind, c_loc_t const *loc ) {
  return c_ast_new( kind, in_attr.ast_depth, loc, &gc_ast_list );
}

/**
 * Set our mode to deciphering gibberish into English.
 */
static inline void gibberish_to_english( void ) {
  lexer_find &= ~LEXER_FIND_CDECL_KEYWORDS;
}

/**
 * Peeks at the type AST at the top of the
 * \ref in_attr.type_ast_stack "type AST inherited attribute stack".
 *
 * @return Returns said AST.
 *
 * @sa ia_type_ast_pop()
 * @sa ia_type_ast_push()
 */
NODISCARD
static inline c_ast_t* ia_type_ast_peek( void ) {
  return slist_front( &in_attr.type_ast_stack );
}

/**
 * Pops a type AST from the
 * \ref in_attr.type_ast_stack "type AST inherited attribute stack".
 *
 * @return Returns said AST.
 *
 * @sa ia_type_ast_peek()
 * @sa ia_type_ast_push()
 */
PJL_DISCARD
static inline c_ast_t* ia_type_ast_pop( void ) {
  c_ast_t *const ast = slist_pop_front( &in_attr.type_ast_stack );
  assert( ast != NULL );
  return ast;
}

/**
 * Given an AST for a type that is the "of type", return type, or "to type" of
 * a declaration, returns a duplicate of \a type_ast if necessary.
 *
 * @param type_ast The AST of a type.
 * @return If \a type_ast `==` \ref in_attr::type_spec_ast "type_spec_ast",
 * returns a duplicate of \a type_ast; otherwise returns \a type_ast.
 *
 * @sa \ref in_attr::type_spec_ast
 */
NODISCARD
static inline c_ast_t* ia_type_spec_ast( c_ast_t *type_ast ) {
  assert( type_ast != NULL );
  // Yes, == is correct here: we mean the same AST node.
  return type_ast == in_attr.type_spec_ast ?
    c_ast_dup_gc( type_ast ) : type_ast;
}

////////// local functions ////////////////////////////////////////////////////

/**
 * Prints a warning that the attribute \a keyword syntax is not supported (and
 * ignored).
 *
 * @param keyword The attribute syntax keyword, e.g., `__attribute__` or
 * `__declspec`.
 * @param keyword_loc The source location of \a keyword.
 */
static void attr_syntax_not_supported( char const *keyword,
                                       c_loc_t const *keyword_loc ) {
  assert( keyword != NULL );
  assert( keyword_loc != NULL );

  print_warning( keyword_loc,
    "\"%s\" not supported by " CDECL " (ignoring)", keyword
  );
  if ( OPT_LANG_IS( ATTRIBUTES ) )
    print_hint( "%s...%s", other_token_c( "[[" ), other_token_c( "]]" ) );
  else
    EPUTC( '\n' );
}

/**
 * A predicate function for slist_free_if() that checks whether \a ast is one
 * that can be garbage collected: if so, c_ast_free()s it.
 *
 * @param ast_node The \ref slist_node pointing to the AST to check.
 * @param data Contains the AST of the type being declared.
 * @return Returns `true` only if \a ast should be removed from the list.
 */
NODISCARD
static bool c_ast_free_if_garbage( slist_node_t *ast_node, void *data ) {
  assert( ast_node != NULL );
  c_ast_t *const ast = ast_node->data;
  assert( ast != NULL );
  c_ast_t const *const type_ast = data;
  assert( type_ast != NULL );

  if ( ast == type_ast || !c_ast_is_orphan( ast ) ) {
    assert( ast->kind != K_PLACEHOLDER );
    return false;
  }

  // We also need to ensure the AST isn't in the type_ast_stack.
  FOREACH_SLIST_NODE( type_node, &in_attr.type_ast_stack ) {
    if ( ast == type_node->data )
      return false;
  } // for

  c_ast_free( ast );
  return true;
}

/**
 * Checks whether `typename` is OK since the type's name is a qualified name.
 *
 * @param ast The AST to check.
 * @return Returns `true` only upon success.
 */
NODISCARD
bool c_ast_is_typename_ok( c_ast_t const *ast ) {
  c_ast_t const *const raw_ast = c_ast_untypedef( ast );
  if ( c_sname_count( &raw_ast->sname ) < 2 ) {
    print_error( &ast->loc, "qualified name expected after \"typename\"\n" );
    return false;
  }
  return true;
}

/**
 * If \a bit_width is &gt; 0 and \a ast is an integral type, sets \a ast's \ref
 * c_bit_field_ast::bit_width "bit_width" to \a bit_width.
 *
 * @remarks This check has to be done now in the parser rather than later in
 * the AST since we need to use the \ref c_ast::bit_field `union` member now.
 *
 * @param ast The AST whose \ref c_bit_field_ast::bit_width "bit_width" to
 * possibly set.
 * @param bit_width The bit-field width.
 * @return Returns `true` only if \a bit_width is &gt; 0 and \a ast if an
 * integral type.
 */
NODISCARD
static bool c_ast_set_bit_field_width( c_ast_t *ast, unsigned bit_width ) {
  assert( ast != NULL );

  if ( bit_width > 0 ) {
    if ( !c_ast_is_integral( ast ) ) {
      print_error( &ast->loc, "invalid bit-field type " );
      print_ast_type_aka( ast, stderr );
      EPRINTF( "; must be an integral %stype\n",
        OPT_LANG_IS( enum_BITFIELDS ) ? "or enumeration " : ""
      );
      return false;
    }
    ast->bit_field.bit_width = bit_width;
  }

  return true;
}

/**
 * Defines a type by adding it to the global set.
 *
 * @param type_ast The AST of the type to define.
 * @param decl_flags The declaration flags to use; must only be one of
 * #C_ENG_DECL, #C_GIB_TYPEDEF, or #C_GIB_USING.
 * @return Returns `true` either if the type was defined or it's equivalent to
 * an existing type; `false` if a different type already exists having the same
 * name.
 */
NODISCARD
static bool define_type( c_ast_t const *type_ast, decl_flags_t decl_flags ) {
  assert( type_ast != NULL );
  assert( is_1_bit_only_in_set( decl_flags, C_TYPE_DECL_ANY ) );

  if ( !c_type_ast_check( type_ast ) )
    return false;

  c_typedef_t *const tdef = c_typedef_add( type_ast, decl_flags )->data;

  if ( tdef->ast == type_ast ) {
    //
    // Type was added: we have to move the AST from the gc_ast_list so it won't
    // be garbage collected at the end of the parse to a separate
    // typedef_ast_list that's freed only at program termination.
    //
    // But first, garbage collect all orphaned AST nodes.  (For a non-type-
    // defining parse, this step isn't necessary since all nodes are freed at
    // the end of the parse anyway.)
    //
    slist_free_if(
      &gc_ast_list,
      &c_ast_free_if_garbage,
      CONST_CAST( void*, type_ast )
    );
    slist_push_list_back( &typedef_ast_list, &gc_ast_list );
    return true;
  }

  //
  // Type was NOT added because a previously declared type having the same name
  // was returned: check if the types are equal.
  //
  // In C, multiple typedef declarations having the same name are allowed only
  // if the types are equivalent:
  //
  //      typedef int T;
  //      typedef int T;                // OK
  //      typedef double T;             // error: types aren't equivalent
  //
  if ( c_ast_equal( type_ast, tdef->ast ) ) {
    // Update the language(s) the type is available in to include opt_lang_id.
    if ( opt_lang_id < c_lang_oldest( tdef->lang_ids ) )
      tdef->lang_ids = c_lang_and_newer( opt_lang_id );
    return true;
  }

  if ( tdef->is_predefined ) {
    print_error( &type_ast->loc,
      "\"%s\" is a predefined type starting in %s\n",
      c_sname_gibberish( &type_ast->sname ),
      c_lang_name( c_lang_oldest( tdef->lang_ids ) )
    );
  } else {
    print_error( &type_ast->loc, "type " );
    print_ast_type_aka( type_ast, stderr );
    EPUTS( " redefinition incompatible with original type \"" );
    print_type_ast( tdef, stderr );
    EPUTS( "\"\n" );
  }

  return false;
}

/**
 * Checks whether \a sname is a type.
 *
 * @param file The name of the file where this function was called from.
 * @param line The line number within \a file where this function was called
 * from.
 * @param sname The scoped name to check.
 * @param loc The location of \a sname.
 * @return Returns `true` only if \a sname is a type (and prints an error
 * message); otherwise `false` (and does nothing).
 */
NODISCARD
static bool fl_c_sname_is_type( char const *file, int line,
                                c_sname_t const *sname, c_loc_t const *loc ) {
  assert( sname != NULL );
  assert( loc != NULL );

  c_typedef_t const *const tdef = c_typedef_find_sname( sname );
  if ( tdef == NULL )
    return false;

  if ( tdef->is_predefined ) {
    fl_print_error( file, line, loc,
      "\"%s\" is a predefined type starting in %s\n",
      c_sname_gibberish( sname ),
      c_lang_name( c_lang_oldest( tdef->lang_ids ) )
    );
  } else {
    fl_print_error( file, line, loc,
      "\"%s\": previously declared as type \"",
      c_sname_gibberish( sname )
    );
    print_type_ast( tdef, stderr );
    EPUTS( "\"\n" );
  }

  return true;
}

/**
 * Cleans-up all resources used by \ref in_attr "inherited attributes".
 */
static void ia_cleanup( void ) {
  c_sname_cleanup( &in_attr.scope_sname );
  // Do _not_ pass &c_ast_free for the 2nd argument! All AST nodes were already
  // free'd from the gc_ast_list in parse_cleanup(). Just free the slist nodes.
  slist_cleanup( &in_attr.type_ast_stack, /*free_fn=*/NULL );
  in_attr = (in_attr_t){ 0 };
}

/**
 * Pushes a type AST onto the
 * \ref in_attr.type_ast_stack "type AST inherited attribute  stack".
 *
 * @remarks Additionally, if \a ast is #K_ANY_TYPE_SPECIFIER and \ref
 * in_attr::type_spec_ast "type_spec_ast" is NULL, sets \ref
 * in_attr::type_spec_ast "type_spec_ast" to \a ast.
 *
 * @param ast The AST to push.
 *
 * @sa ia_type_ast_peek()
 * @sa ia_type_ast_pop()
 */
static void ia_type_ast_push( c_ast_t *ast ) {
  assert( ast != NULL );
  slist_push_front( &in_attr.type_ast_stack, ast );
  if ( in_attr.type_spec_ast != NULL )
    return;
  if ( (ast->kind & K_ANY_TYPE_SPECIFIER) != 0 )
    in_attr.type_spec_ast = ast;
}

/**
 * Joins \a type_ast and \a decl_ast into a single AST.
 *
 * @param type_ast The type AST.
 * @param decl_ast The declaration AST.
 * @return Returns the joined AST on success or NULL on error.
 */
NODISCARD
c_ast_t* join_type_decl( c_ast_t *type_ast, c_ast_t *decl_ast ) {
  assert( type_ast != NULL );
  assert( decl_ast != NULL );

  if ( in_attr.is_typename && !c_ast_is_typename_ok( type_ast ) )
    return NULL;

  type_ast = ia_type_spec_ast( type_ast );
  c_type_t type = c_ast_take_type_any( type_ast, &T_TS_typedef );

  //
  // This is for a case like:
  //
  //      explain typedef ...
  //
  bool const is_explain_typedef = c_tid_is_any( type.stids, TS_typedef );

  if ( !is_explain_typedef &&
       type_ast->kind == K_BUILTIN && decl_ast->kind == K_BUILTIN &&
       c_sname_is_type( &decl_ast->sname, &decl_ast->loc ) ) {
    //
    // This checks for a case like:
    //
    //      typedef int T
    //      explain unsigned T          // error
    //
    // This check has to be done now in the parser rather than later in the
    // AST because once type_ast and decl_ast are joined, the fact that
    // decl_ast was a typedef is lost.
    //
    return NULL;
  }

  if ( is_explain_typedef && decl_ast->kind == K_TYPEDEF ) {
    //
    // This is for a case like:
    //
    //      explain typedef int int32_t;
    //
    // that is: explaining an existing typedef.  In order to do that, we have
    // to un-typedef it so we explain the type that it's a typedef for.
    //
    c_ast_t const *const raw_decl_ast = c_ast_untypedef( decl_ast );

    //
    // However, we also have to check whether the typedef being explained is
    // not equivalent to the existing typedef.  This is for a case like:
    //
    //      explain typedef char int32_t;
    //
    if ( !c_ast_equal( type_ast, raw_decl_ast ) ) {
      print_error( &decl_ast->loc, "type " );
      print_ast_type_aka( type_ast, stderr );
      EPUTS( " redefinition incompatible with original type " );
      print_ast_type_aka( decl_ast, stderr );
      EPUTC( '\n' );
      return NULL;
    }

    //
    // Because the raw_decl_ast for the existing type is about to be combined
    // with type_ast, duplicate raw_decl_ast first.
    //
    c_loc_t const *const orig_loc = &decl_ast->loc;
    decl_ast = c_ast_dup_gc( raw_decl_ast );
    decl_ast->loc = *orig_loc;
  }

  c_ast_t *const ast = c_ast_patch_placeholder( type_ast, decl_ast );
  c_type_t const tdef_type = c_ast_take_type_any( ast, &T_TS_typedef );
  c_type_or_eq( &type, &tdef_type );
  c_type_or_eq( &ast->type, &type );

  if ( in_attr.align.kind != C_ALIGNAS_NONE ) {
    ast->align = in_attr.align;
    if ( c_tid_is_any( type.stids, TS_typedef ) ) {
      //
      // We check for illegal aligned typedef here rather than in c_ast_check.c
      // because the "typedef-ness" needed to be removed previously before the
      // eventual call to c_ast_check().
      //
      print_error( &ast->align.loc, "typedef can not be aligned\n" );
      return NULL;
    }
  }

  if ( ast->kind == K_UDEF_CONV &&
       c_sname_local_type( &ast->sname )->btids == TB_SCOPE ) {
    //
    // User-defined conversions don't have names, but they can still have a
    // scope.  Since only classes can have them, if the scope is still
    // TB_SCOPE, change it to TB_class.
    //
    c_sname_local_data( &ast->sname )->type = C_TYPE_LIT_B( TB_class );
  }

  return ast;
}

/**
 * Checks whether \a ast is of kind #K_NAME and an error if:
 *
 *  + \ref opt_permissive_types is `false`; and:
 *  + \ref c_ast::sname is a C or C++ keyword.
 *
 * @note This function isn't normally called directly; use the
 * #c_ast_is_name_error() macro instead.
 *
 * @param line The line number within this file where this function was called
 * from.
 * @param ast The AST to check.
 * @return Returns `true` only if \a ast is a #K_NAME, \ref
 * opt_permissive_types is `false`, and \ref c_ast::sname is a C or C++
 * keyword.
 */
NODISCARD
static bool l_c_ast_is_name_error( int line, c_ast_t const *ast ) {
  assert( ast != NULL );
  if ( ast->kind != K_NAME || opt_permissive_types )
    return false;

  c_keyword_t const *const ck = c_keyword_find(
    c_sname_gibberish( &ast->sname ), LANG_ANY, C_KW_CTX_DEFAULT
  );
  if ( ck == NULL )
    return false;

  assert( !c_sname_empty( &ast->sname ) );
  fl_print_error_unknown_name( __FILE__, line, &ast->loc, &ast->sname );
  return true;
}

/**
 * A special case of l_elaborate_error() that prevents oddly worded error
 * messages where a C/C++ keyword is expected, but that keyword isn't a keyword
 * either until a later version of the language or in a different language;
 * hence, the lexer will return the keyword as the `Y_NAME` token instead of
 * the keyword token.
 *
 * For example, if l_elaborate_error() were used for the following \b cdecl
 * command when the current language is C, you'd get the following:
 * ```
 * declare f as virtual function returning void
 *              ^
 * 14: syntax error: "virtual": "virtual" expected; not a keyword until C++98
 * ```
 * because it's really this:
 * ```
 * ... "virtual" [the name]": "virtual" [the token] expected ...
 * ```
 * and that looks odd.
 *
 * @note This function isn't normally called directly; use the
 * #keyword_expected() macro instead.
 *
 * @param line The line number within this file where this function was called
 * from.
 * @param keyword A keyword literal.
 *
 * @sa l_elaborate_error()
 * @sa l_punct_expected()
 * @sa yyerror()
 */
static void l_keyword_expected( int line, char const *keyword ) {
  assert( keyword != NULL );

  dym_kind_t dym_kinds = DYM_NONE;

  char const *const error_token = printable_yytext();
  if ( error_token != NULL ) {
    if ( strcmp( error_token, keyword ) == 0 ) {
      //
      // The error token is the expected keyword which means the lexer returned
      // it as a name and not the token which likely means it's not a C/C++
      // keyword until a later version of the current language.
      //
      c_keyword_t const *const ck =
        c_keyword_find( keyword, LANG_ANY, C_KW_CTX_DEFAULT );
      if ( ck != NULL ) {
        char const *const which_lang = c_lang_which( ck->lang_ids );
        if ( which_lang[0] != '\0' ) {
          EPUTS( ": " );
          print_debug_file_line( __FILE__, line );
          EPRINTF( "\"%s\" not supported%s\n", keyword, which_lang );
          return;
        }
      }
    }

    dym_kinds = is_english_to_gibberish() ? DYM_CDECL_KEYWORDS : DYM_C_KEYWORDS;
  }

  l_elaborate_error( line, dym_kinds, "\"%s\" expected", keyword );
}

/**
 * Checks whether the type currently being declared (`enum`, `struct`,
 * `typedef`, or `union`) is nested within some other type (`struct` or
 * `union`) and whether the current language is C: if not, prints an error
 * message.
 *
 * @note It is unnecessary to check either when a `class` is being declared or
 * when a type is being declared within a `namespace` since those are not legal
 * in C anyway.
 *
 * @note This function isn't normally called directly; use the
 * #is_nested_type_ok() macro instead.
 *
 * @param line The line number within this file where this function was called
 * from.
 * @param type_loc The location of the type declaration.
 * @return Returns `true` only if the type currently being declared is either
 * not nested or the current language is C++.
 */
NODISCARD
static bool l_is_nested_type_ok( int line, c_loc_t const *type_loc ) {
  assert( type_loc != NULL );
  if ( !c_sname_empty( &in_attr.scope_sname ) &&
       !OPT_LANG_IS( NESTED_TYPES ) ) {
    fl_print_error( __FILE__, line, type_loc,
      "nested types not supported%s\n",
      C_LANG_WHICH( NESTED_TYPES )
    );
    return false;
  }
  return true;
}

/**
 * A special case of l_elaborate_error() that prevents oddly worded error
 * messages when a punctuation character is expected by not doing keyword look-
 * ups of the error token.
 *
 * For example, if l_elaborate_error() were used for the following \b cdecl
 * command, you'd get the following:
 * ```
 * explain void f(int g const)
 *                      ^
 * 29: syntax error: "const": ',' expected ("const" is a keyword)
 * ```
 * and that looks odd since, if a punctuation character was expected, it seems
 * silly to point out that the encountered token is a keyword.
 *
 * @note This function isn't normally called directly; use the
 * #punct_expected() macro instead.
 *
 * @param line The line number within this file where this function was called
 * from.
 * @param punct The punctuation character that was expected.
 *
 * @sa l_elaborate_error()
 * @sa l_keyword_expected()
 * @sa yyerror()
 */
static void l_punct_expected( int line, char punct ) {
  EPUTS( ": " );
  print_debug_file_line( __FILE__, line );
  if ( print_error_token( printable_yytext() ) )
    EPUTS( ": " );
  EPRINTF( "'%c' expected\n", punct );
}

/**
 * Cleans up individial parse data after each parse.
 *
 * @param fatal_error Must be `true` only if a fatal semantic error has
 * occurred and `YYABORT` is about to be called to bail out of parsing by
 * returning from yyparse().
 */
static void parse_cleanup( bool fatal_error ) {
  //
  // We need to reset the lexer differently depending on whether we completed a
  // parse with a fatal error.  If so, do a "hard" reset that also resets the
  // EOF flag of the lexer.
  //
  lexer_reset( /*hard_reset=*/fatal_error );

  if ( fatal_error && yytext[0] != '\n' ) {
    //
    // Generally, PARSE_ABORT() was called before getting to the '\n' at the
    // end of the line, so Flex will not have incremented yylineno: manually
    // increment yylineno here to compensate.
    //
    ++yylineno;
  }

  c_ast_list_cleanup_gc( &gc_ast_list );
  ia_cleanup();
}

/**
 * Called by Bison to print a parsing error message to standard error.
 *
 * @remarks A custom error printing function via `%%define parse.error custom`
 * and
 * [`yyreport_syntax_error()`](https://www.gnu.org/software/bison/manual/html_node/Syntax-Error-Reporting-Function.html)
 * is not done because printing a (perhaps long) list of all the possible
 * expected tokens isn't helpful.
 * @par
 * It's also more flexible to be able to call one of #elaborate_error(),
 * #keyword_expected(), or #punct_expected() at the point of the error rather
 * than having a single function try to figure out the best type of error
 * message to print.
 *
 * @note A newline is _not_ printed since the error message will be appended to
 * by l_elaborate_error().  For example, the parts of an error message are
 * printed by the functions shown:
 *
 *      42: syntax error: "int": "into" expected
 *      |--||----------||----------------------|
 *      |   |           |
 *      |   yyerror()   l_elaborate_error()
 *      |
 *      print_loc()
 *
 * @param msg The error message to print.  Bison invariably passes `syntax
 * error`.
 *
 * @sa l_elaborate_error()
 * @sa l_keyword_expected()
 * @sa l_punct_expected()
 * @sa print_loc()
 */
static void yyerror( char const *msg ) {
  assert( msg != NULL );

  c_loc_t const loc = lexer_loc();
  print_loc( &loc );

  color_start( stderr, sgr_error );
  EPUTS( msg );                         // no newline
  color_end( stderr, sgr_error );

  //
  // A syntax error has occurred, but syntax errors aren't fatal since Bison
  // tries to recover.  We'll clean-up the current parse, but YYABORT won't be
  // called so we won't bail out of parsing by returning from yyparse(); hence,
  // parsing will continue.
  //
  parse_cleanup( /*fatal_error=*/false );
}

/** @} */

///////////////////////////////////////////////////////////////////////////////

/// @cond DOXYGEN_IGNORE


#line 1333 "parser.c"

# ifndef YY_CAST
#  ifdef __cplusplus
#   define YY_CAST(Type, Val) static_cast<Type> (Val)
#   define YY_REINTERPRET_CAST(Type, Val) reinterpret_cast<Type> (Val)
#  else
#   define YY_CAST(Type, Val) ((Type) (Val))
#   define YY_REINTERPRET_CAST(Type, Val) ((Type) (Val))
#  endif
# endif
# ifndef YY_NULLPTR
#  if defined __cplusplus
#   if 201103L <= __cplusplus
#    define YY_NULLPTR nullptr
#   else
#    define YY_NULLPTR 0
#   endif
#  else
#   define YY_NULLPTR ((void*)0)
#  endif
# endif

#include  "parser.h" 
/* Symbol kind.  */
enum yysymbol_kind_t
{
  YYSYMBOL_YYEMPTY = -2,
  YYSYMBOL_YYEOF = 0,                      /* "end of file"  */
  YYSYMBOL_YYerror = 1,                    /* error  */
  YYSYMBOL_YYUNDEF = 2,                    /* "invalid token"  */
  YYSYMBOL_Y_cast = 3,                     /* Y_cast  */
  YYSYMBOL_Y_constant = 4,                 /* Y_constant  */
  YYSYMBOL_Y_declare = 5,                  /* Y_declare  */
  YYSYMBOL_Y_define = 6,                   /* Y_define  */
  YYSYMBOL_Y_dynamic = 7,                  /* Y_dynamic  */
  YYSYMBOL_Y_explain = 8,                  /* Y_explain  */
  YYSYMBOL_Y_no = 9,                       /* Y_no  */
  YYSYMBOL_Y_quit = 10,                    /* Y_quit  */
  YYSYMBOL_Y_reinterpret = 11,             /* Y_reinterpret  */
  YYSYMBOL_Y_set = 12,                     /* Y_set  */
  YYSYMBOL_Y_show = 13,                    /* Y_show  */
  YYSYMBOL_Y_aligned = 14,                 /* Y_aligned  */
  YYSYMBOL_Y_all = 15,                     /* Y_all  */
  YYSYMBOL_Y_array = 16,                   /* Y_array  */
  YYSYMBOL_Y_as = 17,                      /* Y_as  */
  YYSYMBOL_Y_binding = 18,                 /* Y_binding  */
  YYSYMBOL_Y_bit = 19,                     /* Y_bit  */
  YYSYMBOL_Y_bit_precise = 20,             /* Y_bit_precise  */
  YYSYMBOL_Y_bits = 21,                    /* Y_bits  */
  YYSYMBOL_Y_by = 22,                      /* Y_by  */
  YYSYMBOL_Y_bytes = 23,                   /* Y_bytes  */
  YYSYMBOL_Y_capturing = 24,               /* Y_capturing  */
  YYSYMBOL_Y_commands = 25,                /* Y_commands  */
  YYSYMBOL_Y_constructor = 26,             /* Y_constructor  */
  YYSYMBOL_Y_conversion = 27,              /* Y_conversion  */
  YYSYMBOL_Y_copy = 28,                    /* Y_copy  */
  YYSYMBOL_Y_defined = 29,                 /* Y_defined  */
  YYSYMBOL_Y_destructor = 30,              /* Y_destructor  */
  YYSYMBOL_Y_english = 31,                 /* Y_english  */
  YYSYMBOL_Y_evaluation = 32,              /* Y_evaluation  */
  YYSYMBOL_Y_expand = 33,                  /* Y_expand  */
  YYSYMBOL_Y_expression = 34,              /* Y_expression  */
  YYSYMBOL_Y_floating = 35,                /* Y_floating  */
  YYSYMBOL_Y_function = 36,                /* Y_function  */
  YYSYMBOL_Y_initialization = 37,          /* Y_initialization  */
  YYSYMBOL_Y_into = 38,                    /* Y_into  */
  YYSYMBOL_Y_lambda = 39,                  /* Y_lambda  */
  YYSYMBOL_Y_length = 40,                  /* Y_length  */
  YYSYMBOL_Y_linkage = 41,                 /* Y_linkage  */
  YYSYMBOL_Y_literal = 42,                 /* Y_literal  */
  YYSYMBOL_Y_macros = 43,                  /* Y_macros  */
  YYSYMBOL_Y_member = 44,                  /* Y_member  */
  YYSYMBOL_Y_non_empty = 45,               /* Y_non_empty  */
  YYSYMBOL_Y_non_member = 46,              /* Y_non_member  */
  YYSYMBOL_Y_of = 47,                      /* Y_of  */
  YYSYMBOL_Y_options = 48,                 /* Y_options  */
  YYSYMBOL_Y_point = 49,                   /* Y_point  */
  YYSYMBOL_Y_pointer = 50,                 /* Y_pointer  */
  YYSYMBOL_Y_precise = 51,                 /* Y_precise  */
  YYSYMBOL_Y_precision = 52,               /* Y_precision  */
  YYSYMBOL_Y_predefined = 53,              /* Y_predefined  */
  YYSYMBOL_Y_pure = 54,                    /* Y_pure  */
  YYSYMBOL_Y_reference = 55,               /* Y_reference  */
  YYSYMBOL_Y_returning = 56,               /* Y_returning  */
  YYSYMBOL_Y_rvalue = 57,                  /* Y_rvalue  */
  YYSYMBOL_Y_scope = 58,                   /* Y_scope  */
  YYSYMBOL_Y_structured = 59,              /* Y_structured  */
  YYSYMBOL_Y_to = 60,                      /* Y_to  */
  YYSYMBOL_Y_user = 61,                    /* Y_user  */
  YYSYMBOL_Y_user_defined = 62,            /* Y_user_defined  */
  YYSYMBOL_Y_variable = 63,                /* Y_variable  */
  YYSYMBOL_Y_wide = 64,                    /* Y_wide  */
  YYSYMBOL_Y_width = 65,                   /* Y_width  */
  YYSYMBOL_Y_PREC_LESS_THAN_upc_layout_qualifier = 66, /* Y_PREC_LESS_THAN_upc_layout_qualifier  */
  YYSYMBOL_Y_COLON_COLON = 67,             /* Y_COLON_COLON  */
  YYSYMBOL_68_ = 68,                       /* "::"  */
  YYSYMBOL_Y_COLON_COLON_STAR = 69,        /* Y_COLON_COLON_STAR  */
  YYSYMBOL_Y_PLUS_PLUS = 70,               /* "++"  */
  YYSYMBOL_Y_MINUS_MINUS = 71,             /* "--"  */
  YYSYMBOL_72_ = 72,                       /* '('  */
  YYSYMBOL_73_ = 73,                       /* ')'  */
  YYSYMBOL_74_ = 74,                       /* '['  */
  YYSYMBOL_75_ = 75,                       /* ']'  */
  YYSYMBOL_76_ = 76,                       /* '.'  */
  YYSYMBOL_Y_MINUS_GREATER = 77,           /* Y_MINUS_GREATER  */
  YYSYMBOL_78_ = 78,                       /* "->"  */
  YYSYMBOL_79_ = 79,                       /* '&'  */
  YYSYMBOL_80_ = 80,                       /* '*'  */
  YYSYMBOL_81_ = 81,                       /* '!'  */
  YYSYMBOL_Y_sizeof = 82,                  /* Y_sizeof  */
  YYSYMBOL_83_ = 83,                       /* '~'  */
  YYSYMBOL_Y_DOT_STAR = 84,                /* Y_DOT_STAR  */
  YYSYMBOL_85_ = 85,                       /* ".*"  */
  YYSYMBOL_Y_MINUS_GREATER_STAR = 86,      /* Y_MINUS_GREATER_STAR  */
  YYSYMBOL_87_ = 87,                       /* "->*"  */
  YYSYMBOL_88_ = 88,                       /* '/'  */
  YYSYMBOL_89_ = 89,                       /* '%'  */
  YYSYMBOL_90_ = 90,                       /* '-'  */
  YYSYMBOL_91_ = 91,                       /* '+'  */
  YYSYMBOL_Y_LESS_LESS = 92,               /* Y_LESS_LESS  */
  YYSYMBOL_93_ = 93,                       /* "<<"  */
  YYSYMBOL_Y_GREATER_GREATER = 94,         /* Y_GREATER_GREATER  */
  YYSYMBOL_95_ = 95,                       /* ">>"  */
  YYSYMBOL_Y_LESS_EQUAL_GREATER = 96,      /* Y_LESS_EQUAL_GREATER  */
  YYSYMBOL_97_ = 97,                       /* "<=>"  */
  YYSYMBOL_98_ = 98,                       /* '<'  */
  YYSYMBOL_99_ = 99,                       /* '>'  */
  YYSYMBOL_Y_LESS_EQUAL = 100,             /* Y_LESS_EQUAL  */
  YYSYMBOL_101_ = 101,                     /* "<="  */
  YYSYMBOL_Y_GREATER_EQUAL = 102,          /* Y_GREATER_EQUAL  */
  YYSYMBOL_103_ = 103,                     /* ">="  */
  YYSYMBOL_Y_EQUAL_EQUAL = 104,            /* Y_EQUAL_EQUAL  */
  YYSYMBOL_105_ = 105,                     /* "=="  */
  YYSYMBOL_Y_EXCLAM_EQUAL = 106,           /* Y_EXCLAM_EQUAL  */
  YYSYMBOL_Y_bit_and = 107,                /* Y_bit_and  */
  YYSYMBOL_108_ = 108,                     /* '^'  */
  YYSYMBOL_109_ = 109,                     /* '|'  */
  YYSYMBOL_Y_AMPER_AMPER = 110,            /* Y_AMPER_AMPER  */
  YYSYMBOL_Y_PIPE_PIPE = 111,              /* Y_PIPE_PIPE  */
  YYSYMBOL_Y_QMARK_COLON = 112,            /* Y_QMARK_COLON  */
  YYSYMBOL_113_ = 113,                     /* "?:"  */
  YYSYMBOL_114_ = 114,                     /* '='  */
  YYSYMBOL_Y_PERCENT_EQUAL = 115,          /* Y_PERCENT_EQUAL  */
  YYSYMBOL_116_ = 116,                     /* "%="  */
  YYSYMBOL_Y_AMPER_EQUAL = 117,            /* Y_AMPER_EQUAL  */
  YYSYMBOL_Y_STAR_EQUAL = 118,             /* Y_STAR_EQUAL  */
  YYSYMBOL_119_ = 119,                     /* "*="  */
  YYSYMBOL_Y_PLUS_EQUAL = 120,             /* Y_PLUS_EQUAL  */
  YYSYMBOL_121_ = 121,                     /* "+="  */
  YYSYMBOL_Y_MINUS_EQUAL = 122,            /* Y_MINUS_EQUAL  */
  YYSYMBOL_123_ = 123,                     /* "-="  */
  YYSYMBOL_Y_SLASH_EQUAL = 124,            /* Y_SLASH_EQUAL  */
  YYSYMBOL_125_ = 125,                     /* "/="  */
  YYSYMBOL_Y_LESS_LESS_EQUAL = 126,        /* Y_LESS_LESS_EQUAL  */
  YYSYMBOL_127_ = 127,                     /* "<<="  */
  YYSYMBOL_Y_GREATER_GREATER_EQUAL = 128,  /* Y_GREATER_GREATER_EQUAL  */
  YYSYMBOL_129_ = 129,                     /* ">>="  */
  YYSYMBOL_Y_CARET_EQUAL = 130,            /* Y_CARET_EQUAL  */
  YYSYMBOL_Y_PIPE_EQUAL = 131,             /* Y_PIPE_EQUAL  */
  YYSYMBOL_132_ = 132,                     /* ','  */
  YYSYMBOL_Y_auto_STORAGE = 133,           /* Y_auto_STORAGE  */
  YYSYMBOL_Y_break = 134,                  /* Y_break  */
  YYSYMBOL_Y_case = 135,                   /* Y_case  */
  YYSYMBOL_Y_char = 136,                   /* Y_char  */
  YYSYMBOL_Y_continue = 137,               /* Y_continue  */
  YYSYMBOL_Y_default = 138,                /* Y_default  */
  YYSYMBOL_Y_do = 139,                     /* Y_do  */
  YYSYMBOL_Y_double = 140,                 /* Y_double  */
  YYSYMBOL_Y_else = 141,                   /* Y_else  */
  YYSYMBOL_Y_extern = 142,                 /* Y_extern  */
  YYSYMBOL_Y_float = 143,                  /* Y_float  */
  YYSYMBOL_Y_for = 144,                    /* Y_for  */
  YYSYMBOL_Y_goto = 145,                   /* Y_goto  */
  YYSYMBOL_Y_if = 146,                     /* Y_if  */
  YYSYMBOL_Y_int = 147,                    /* Y_int  */
  YYSYMBOL_Y_long = 148,                   /* Y_long  */
  YYSYMBOL_Y_register = 149,               /* Y_register  */
  YYSYMBOL_Y_return = 150,                 /* Y_return  */
  YYSYMBOL_Y_short = 151,                  /* Y_short  */
  YYSYMBOL_Y_static = 152,                 /* Y_static  */
  YYSYMBOL_Y_struct = 153,                 /* Y_struct  */
  YYSYMBOL_Y_switch = 154,                 /* Y_switch  */
  YYSYMBOL_Y_typedef = 155,                /* Y_typedef  */
  YYSYMBOL_Y_union = 156,                  /* Y_union  */
  YYSYMBOL_Y_unsigned = 157,               /* Y_unsigned  */
  YYSYMBOL_Y_while = 158,                  /* Y_while  */
  YYSYMBOL_159_ = 159,                     /* '#'  */
  YYSYMBOL_Y_PRE_CONCAT = 160,             /* "##"  */
  YYSYMBOL_Y_PRE_SPACE = 161,              /* Y_PRE_SPACE  */
  YYSYMBOL_Y_PRE_define = 162,             /* Y_PRE_define  */
  YYSYMBOL_Y_PRE_elif = 163,               /* Y_PRE_elif  */
  YYSYMBOL_Y_PRE_else = 164,               /* Y_PRE_else  */
  YYSYMBOL_Y_PRE_error = 165,              /* Y_PRE_error  */
  YYSYMBOL_Y_PRE_if = 166,                 /* Y_PRE_if  */
  YYSYMBOL_Y_PRE_ifdef = 167,              /* Y_PRE_ifdef  */
  YYSYMBOL_Y_PRE_ifndef = 168,             /* Y_PRE_ifndef  */
  YYSYMBOL_Y_PRE_line = 169,               /* Y_PRE_line  */
  YYSYMBOL_Y_PRE_undef = 170,              /* Y_PRE_undef  */
  YYSYMBOL_Y_PRE___VA_ARGS__ = 171,        /* Y_PRE___VA_ARGS__  */
  YYSYMBOL_Y_PRE___VA_OPT__ = 172,         /* Y_PRE___VA_OPT__  */
  YYSYMBOL_Y_PRE_pragma = 173,             /* Y_PRE_pragma  */
  YYSYMBOL_Y_PRE_elifdef = 174,            /* Y_PRE_elifdef  */
  YYSYMBOL_Y_PRE_elifndef = 175,           /* Y_PRE_elifndef  */
  YYSYMBOL_Y_PRE_embed = 176,              /* Y_PRE_embed  */
  YYSYMBOL_Y_PRE_warning = 177,            /* Y_PRE_warning  */
  YYSYMBOL_Y_asm = 178,                    /* Y_asm  */
  YYSYMBOL_Y_const = 179,                  /* Y_const  */
  YYSYMBOL_Y_ELLIPSIS = 180,               /* "..."  */
  YYSYMBOL_Y_enum = 181,                   /* Y_enum  */
  YYSYMBOL_Y_signed = 182,                 /* Y_signed  */
  YYSYMBOL_Y_void = 183,                   /* Y_void  */
  YYSYMBOL_Y_volatile = 184,               /* Y_volatile  */
  YYSYMBOL_Y_wchar_t = 185,                /* Y_wchar_t  */
  YYSYMBOL_Y__Bool = 186,                  /* Y__Bool  */
  YYSYMBOL_Y__Complex = 187,               /* Y__Complex  */
  YYSYMBOL_Y__Imaginary = 188,             /* Y__Imaginary  */
  YYSYMBOL_Y_inline = 189,                 /* Y_inline  */
  YYSYMBOL_Y_restrict = 190,               /* Y_restrict  */
  YYSYMBOL_Y__Alignas = 191,               /* Y__Alignas  */
  YYSYMBOL_Y__Alignof = 192,               /* Y__Alignof  */
  YYSYMBOL_Y__Atomic_QUAL = 193,           /* Y__Atomic_QUAL  */
  YYSYMBOL_Y__Atomic_SPEC = 194,           /* Y__Atomic_SPEC  */
  YYSYMBOL_Y__Generic = 195,               /* Y__Generic  */
  YYSYMBOL_Y__Noreturn = 196,              /* Y__Noreturn  */
  YYSYMBOL_Y__Static_assert = 197,         /* Y__Static_assert  */
  YYSYMBOL_Y__Thread_local = 198,          /* Y__Thread_local  */
  YYSYMBOL_Y_thread = 199,                 /* Y_thread  */
  YYSYMBOL_Y_local = 200,                  /* Y_local  */
  YYSYMBOL_Y_bool = 201,                   /* Y_bool  */
  YYSYMBOL_Y_catch = 202,                  /* Y_catch  */
  YYSYMBOL_Y_class = 203,                  /* Y_class  */
  YYSYMBOL_Y_const_cast = 204,             /* Y_const_cast  */
  YYSYMBOL_Y_CONSTRUCTOR_SNAME = 205,      /* Y_CONSTRUCTOR_SNAME  */
  YYSYMBOL_Y_delete = 206,                 /* Y_delete  */
  YYSYMBOL_Y_DESTRUCTOR_SNAME = 207,       /* Y_DESTRUCTOR_SNAME  */
  YYSYMBOL_Y_dynamic_cast = 208,           /* Y_dynamic_cast  */
  YYSYMBOL_Y_explicit = 209,               /* Y_explicit  */
  YYSYMBOL_Y_false = 210,                  /* Y_false  */
  YYSYMBOL_Y_friend = 211,                 /* Y_friend  */
  YYSYMBOL_Y_mutable = 212,                /* Y_mutable  */
  YYSYMBOL_Y_namespace = 213,              /* Y_namespace  */
  YYSYMBOL_Y_new = 214,                    /* Y_new  */
  YYSYMBOL_Y_operator = 215,               /* Y_operator  */
  YYSYMBOL_Y_OPERATOR_SNAME = 216,         /* Y_OPERATOR_SNAME  */
  YYSYMBOL_Y_private = 217,                /* Y_private  */
  YYSYMBOL_Y_protected = 218,              /* Y_protected  */
  YYSYMBOL_Y_public = 219,                 /* Y_public  */
  YYSYMBOL_Y_reinterpret_cast = 220,       /* Y_reinterpret_cast  */
  YYSYMBOL_Y_static_cast = 221,            /* Y_static_cast  */
  YYSYMBOL_Y_template = 222,               /* Y_template  */
  YYSYMBOL_Y_this = 223,                   /* Y_this  */
  YYSYMBOL_Y_throw = 224,                  /* Y_throw  */
  YYSYMBOL_Y_true = 225,                   /* Y_true  */
  YYSYMBOL_Y_try = 226,                    /* Y_try  */
  YYSYMBOL_Y_typeid = 227,                 /* Y_typeid  */
  YYSYMBOL_Y_typename = 228,               /* Y_typename  */
  YYSYMBOL_Y_using = 229,                  /* Y_using  */
  YYSYMBOL_Y_virtual = 230,                /* Y_virtual  */
  YYSYMBOL_Y_char16_t = 231,               /* Y_char16_t  */
  YYSYMBOL_Y_char32_t = 232,               /* Y_char32_t  */
  YYSYMBOL_Y__BitInt = 233,                /* Y__BitInt  */
  YYSYMBOL_Y_reproducible = 234,           /* Y_reproducible  */
  YYSYMBOL_Y_typeof = 235,                 /* Y_typeof  */
  YYSYMBOL_Y_typeof_unqual = 236,          /* Y_typeof_unqual  */
  YYSYMBOL_Y_unsequenced = 237,            /* Y_unsequenced  */
  YYSYMBOL_Y_ATTR_BEGIN = 238,             /* Y_ATTR_BEGIN  */
  YYSYMBOL_Y_auto_TYPE = 239,              /* Y_auto_TYPE  */
  YYSYMBOL_Y_alignas = 240,                /* Y_alignas  */
  YYSYMBOL_Y_alignof = 241,                /* Y_alignof  */
  YYSYMBOL_Y_carries = 242,                /* Y_carries  */
  YYSYMBOL_Y_dependency = 243,             /* Y_dependency  */
  YYSYMBOL_Y_carries_dependency = 244,     /* Y_carries_dependency  */
  YYSYMBOL_Y_constexpr = 245,              /* Y_constexpr  */
  YYSYMBOL_Y_decltype = 246,               /* Y_decltype  */
  YYSYMBOL_Y_except = 247,                 /* Y_except  */
  YYSYMBOL_Y_final = 248,                  /* Y_final  */
  YYSYMBOL_Y_noexcept = 249,               /* Y_noexcept  */
  YYSYMBOL_Y_nullptr = 250,                /* Y_nullptr  */
  YYSYMBOL_Y_override = 251,               /* Y_override  */
  YYSYMBOL_Y_static_assert = 252,          /* Y_static_assert  */
  YYSYMBOL_Y_thread_local = 253,           /* Y_thread_local  */
  YYSYMBOL_Y_deprecated = 254,             /* Y_deprecated  */
  YYSYMBOL_Y_auto_STRUCTURED_BINDING = 255, /* Y_auto_STRUCTURED_BINDING  */
  YYSYMBOL_Y_discard = 256,                /* Y_discard  */
  YYSYMBOL_Y_maybe_unused = 257,           /* Y_maybe_unused  */
  YYSYMBOL_Y_maybe = 258,                  /* Y_maybe  */
  YYSYMBOL_Y_unused = 259,                 /* Y_unused  */
  YYSYMBOL_Y_nodiscard = 260,              /* Y_nodiscard  */
  YYSYMBOL_Y_noreturn = 261,               /* Y_noreturn  */
  YYSYMBOL_Y_char8_t = 262,                /* Y_char8_t  */
  YYSYMBOL_Y_concept = 263,                /* Y_concept  */
  YYSYMBOL_Y_consteval = 264,              /* Y_consteval  */
  YYSYMBOL_Y_constinit = 265,              /* Y_constinit  */
  YYSYMBOL_Y_co_await = 266,               /* Y_co_await  */
  YYSYMBOL_Y_co_return = 267,              /* Y_co_return  */
  YYSYMBOL_Y_co_yield = 268,               /* Y_co_yield  */
  YYSYMBOL_Y_export = 269,                 /* Y_export  */
  YYSYMBOL_Y_no_unique_address = 270,      /* Y_no_unique_address  */
  YYSYMBOL_Y_parameter = 271,              /* Y_parameter  */
  YYSYMBOL_Y_pack = 272,                   /* Y_pack  */
  YYSYMBOL_Y_requires = 273,               /* Y_requires  */
  YYSYMBOL_Y_unique = 274,                 /* Y_unique  */
  YYSYMBOL_Y_address = 275,                /* Y_address  */
  YYSYMBOL_Y_EMC__Accum = 276,             /* Y_EMC__Accum  */
  YYSYMBOL_Y_EMC__Fract = 277,             /* Y_EMC__Fract  */
  YYSYMBOL_Y_EMC__Sat = 278,               /* Y_EMC__Sat  */
  YYSYMBOL_Y_UPC_relaxed = 279,            /* Y_UPC_relaxed  */
  YYSYMBOL_Y_UPC_shared = 280,             /* Y_UPC_shared  */
  YYSYMBOL_Y_UPC_strict = 281,             /* Y_UPC_strict  */
  YYSYMBOL_Y_GNU___attribute__ = 282,      /* Y_GNU___attribute__  */
  YYSYMBOL_Y_GNU___restrict = 283,         /* Y_GNU___restrict  */
  YYSYMBOL_Y_Apple___block = 284,          /* Y_Apple___block  */
  YYSYMBOL_Y_Apple_block = 285,            /* Y_Apple_block  */
  YYSYMBOL_Y_MSC___cdecl = 286,            /* Y_MSC___cdecl  */
  YYSYMBOL_Y_MSC___clrcall = 287,          /* Y_MSC___clrcall  */
  YYSYMBOL_Y_MSC___declspec = 288,         /* Y_MSC___declspec  */
  YYSYMBOL_Y_MSC___fastcall = 289,         /* Y_MSC___fastcall  */
  YYSYMBOL_Y_MSC___stdcall = 290,          /* Y_MSC___stdcall  */
  YYSYMBOL_Y_MSC___thiscall = 291,         /* Y_MSC___thiscall  */
  YYSYMBOL_Y_MSC___vectorcall = 292,       /* Y_MSC___vectorcall  */
  YYSYMBOL_293_ = 293,                     /* ':'  */
  YYSYMBOL_294_ = 294,                     /* ';'  */
  YYSYMBOL_295_ = 295,                     /* '{'  */
  YYSYMBOL_296_ = 296,                     /* '}'  */
  YYSYMBOL_Y_CHAR_LIT = 297,               /* Y_CHAR_LIT  */
  YYSYMBOL_Y_CONCEPT_SNAME = 298,          /* Y_CONCEPT_SNAME  */
  YYSYMBOL_Y_END = 299,                    /* Y_END  */
  YYSYMBOL_Y_ERROR = 300,                  /* Y_ERROR  */
  YYSYMBOL_Y_FLOAT_LIT = 301,              /* Y_FLOAT_LIT  */
  YYSYMBOL_Y_GLOB = 302,                   /* Y_GLOB  */
  YYSYMBOL_Y_INT_LIT = 303,                /* Y_INT_LIT  */
  YYSYMBOL_Y_NAME = 304,                   /* Y_NAME  */
  YYSYMBOL_Y_SET_OPTION = 305,             /* Y_SET_OPTION  */
  YYSYMBOL_Y_STR_LIT = 306,                /* Y_STR_LIT  */
  YYSYMBOL_Y_TYPEDEF_NAME_TDEF = 307,      /* Y_TYPEDEF_NAME_TDEF  */
  YYSYMBOL_Y_TYPEDEF_SNAME_TDEF = 308,     /* Y_TYPEDEF_SNAME_TDEF  */
  YYSYMBOL_Y_LEXER_ERROR = 309,            /* Y_LEXER_ERROR  */
  YYSYMBOL_310_ = 310,                     /* '$'  */
  YYSYMBOL_311_ = 311,                     /* '@'  */
  YYSYMBOL_312_ = 312,                     /* '`'  */
  YYSYMBOL_313_ = 313,                     /* '?'  */
  YYSYMBOL_YYACCEPT = 314,                 /* $accept  */
  YYSYMBOL_command_list = 315,             /* command_list  */
  YYSYMBOL_command = 316,                  /* command  */
  YYSYMBOL_cast_command = 317,             /* cast_command  */
  YYSYMBOL_new_style_cast_english = 318,   /* new_style_cast_english  */
  YYSYMBOL_declare_command = 319,          /* declare_command  */
  YYSYMBOL_320_1 = 320,                    /* $@1  */
  YYSYMBOL_alignas_or_width_decl_english_ast = 321, /* alignas_or_width_decl_english_ast  */
  YYSYMBOL_alignas_specifier_english = 322, /* alignas_specifier_english  */
  YYSYMBOL_aligned_english = 323,          /* aligned_english  */
  YYSYMBOL_capturing_paren_capture_decl_list_english_opt = 324, /* capturing_paren_capture_decl_list_english_opt  */
  YYSYMBOL_paren_capture_decl_list_english = 325, /* paren_capture_decl_list_english  */
  YYSYMBOL_capture_decl_list_english_opt = 326, /* capture_decl_list_english_opt  */
  YYSYMBOL_capture_decl_list_english = 327, /* capture_decl_list_english  */
  YYSYMBOL_capture_decl_english_ast = 328, /* capture_decl_english_ast  */
  YYSYMBOL_capture_default_opt = 329,      /* capture_default_opt  */
  YYSYMBOL_width_specifier_english_uint = 330, /* width_specifier_english_uint  */
  YYSYMBOL_storage_class_subset_english_type_opt = 331, /* storage_class_subset_english_type_opt  */
  YYSYMBOL_storage_class_subset_english_type = 332, /* storage_class_subset_english_type  */
  YYSYMBOL_storage_class_subset_english_stid = 333, /* storage_class_subset_english_stid  */
  YYSYMBOL_define_command = 334,           /* define_command  */
  YYSYMBOL_expand_command = 335,           /* expand_command  */
  YYSYMBOL_expand_command2 = 336,          /* expand_command2  */
  YYSYMBOL_p_extra_token_except_lparen = 337, /* p_extra_token_except_lparen  */
  YYSYMBOL_p_extra_tokens_opt = 338,       /* p_extra_tokens_opt  */
  YYSYMBOL_p_extra_tokens = 339,           /* p_extra_tokens  */
  YYSYMBOL_p_extra_token = 340,            /* p_extra_token  */
  YYSYMBOL_p_arg_list_opt = 341,           /* p_arg_list_opt  */
  YYSYMBOL_p_comma_arg_list = 342,         /* p_comma_arg_list  */
  YYSYMBOL_p_arg_list = 343,               /* p_arg_list  */
  YYSYMBOL_p_arg_tokens = 344,             /* p_arg_tokens  */
  YYSYMBOL_p_arg_token_as_list = 345,      /* p_arg_token_as_list  */
  YYSYMBOL_p_arg_token = 346,              /* p_arg_token  */
  YYSYMBOL_p_num_lit = 347,                /* p_num_lit  */
  YYSYMBOL_p_other = 348,                  /* p_other  */
  YYSYMBOL_p_punctuator = 349,             /* p_punctuator  */
  YYSYMBOL_p_arg_tokens_with_comma_opt = 350, /* p_arg_tokens_with_comma_opt  */
  YYSYMBOL_p_arg_tokens_with_comma = 351,  /* p_arg_tokens_with_comma  */
  YYSYMBOL_p_arg_token_with_comma_as_list = 352, /* p_arg_token_with_comma_as_list  */
  YYSYMBOL_p_arg_token_with_comma = 353,   /* p_arg_token_with_comma  */
  YYSYMBOL_explain_command = 354,          /* explain_command  */
  YYSYMBOL_355_2 = 355,                    /* $@2  */
  YYSYMBOL_explain = 356,                  /* explain  */
  YYSYMBOL_help_command = 357,             /* help_command  */
  YYSYMBOL_358_3 = 358,                    /* $@3  */
  YYSYMBOL_help_what_opt = 359,            /* help_what_opt  */
  YYSYMBOL_preprocessor_command = 360,     /* preprocessor_command  */
  YYSYMBOL_p_define = 361,                 /* p_define  */
  YYSYMBOL_p_paren_param_list_opt = 362,   /* p_paren_param_list_opt  */
  YYSYMBOL_p_param_list_opt = 363,         /* p_param_list_opt  */
  YYSYMBOL_p_param_list = 364,             /* p_param_list  */
  YYSYMBOL_p_param = 365,                  /* p_param  */
  YYSYMBOL_p_replace_list_opt = 366,       /* p_replace_list_opt  */
  YYSYMBOL_p_replace_list = 367,           /* p_replace_list  */
  YYSYMBOL_p_replace_token = 368,          /* p_replace_token  */
  YYSYMBOL_p_undef = 369,                  /* p_undef  */
  YYSYMBOL_quit_command = 370,             /* quit_command  */
  YYSYMBOL_scoped_command = 371,           /* scoped_command  */
  YYSYMBOL_set_command = 372,              /* set_command  */
  YYSYMBOL_set_option_list = 373,          /* set_option_list  */
  YYSYMBOL_set_option = 374,               /* set_option  */
  YYSYMBOL_set_option_value_opt = 375,     /* set_option_value_opt  */
  YYSYMBOL_show_command = 376,             /* show_command  */
  YYSYMBOL_show_format = 377,              /* show_format  */
  YYSYMBOL_show_format_exp = 378,          /* show_format_exp  */
  YYSYMBOL_show_format_opt = 379,          /* show_format_opt  */
  YYSYMBOL_show_types_opt = 380,           /* show_types_opt  */
  YYSYMBOL_predefined_or_user_types_opt = 381, /* predefined_or_user_types_opt  */
  YYSYMBOL_template_command = 382,         /* template_command  */
  YYSYMBOL_typedef_command = 383,          /* typedef_command  */
  YYSYMBOL_using_command = 384,            /* using_command  */
  YYSYMBOL_c_style_cast_expr_c = 385,      /* c_style_cast_expr_c  */
  YYSYMBOL_386_4 = 386,                    /* $@4  */
  YYSYMBOL_new_style_cast_expr_c = 387,    /* new_style_cast_expr_c  */
  YYSYMBOL_388_5 = 388,                    /* $@5  */
  YYSYMBOL_new_style_cast_c = 389,         /* new_style_cast_c  */
  YYSYMBOL_aligned_declaration_c = 390,    /* aligned_declaration_c  */
  YYSYMBOL_391_6 = 391,                    /* $@6  */
  YYSYMBOL_392_7 = 392,                    /* $@7  */
  YYSYMBOL_alignas_specifier_c = 393,      /* alignas_specifier_c  */
  YYSYMBOL_394_8 = 394,                    /* $@8  */
  YYSYMBOL_alignas = 395,                  /* alignas  */
  YYSYMBOL_asm_declaration_c = 396,        /* asm_declaration_c  */
  YYSYMBOL_scoped_declaration_c = 397,     /* scoped_declaration_c  */
  YYSYMBOL_class_struct_union_declaration_c = 398, /* class_struct_union_declaration_c  */
  YYSYMBOL_399_9 = 399,                    /* $@9  */
  YYSYMBOL_400_10 = 400,                   /* $@10  */
  YYSYMBOL_enum_declaration_c = 401,       /* enum_declaration_c  */
  YYSYMBOL_402_11 = 402,                   /* $@11  */
  YYSYMBOL_namespace_declaration_c = 403,  /* namespace_declaration_c  */
  YYSYMBOL_404_12 = 404,                   /* $@12  */
  YYSYMBOL_405_13 = 405,                   /* $@13  */
  YYSYMBOL_namespace_sname_c_exp = 406,    /* namespace_sname_c_exp  */
  YYSYMBOL_namespace_sname_c = 407,        /* namespace_sname_c  */
  YYSYMBOL_namespace_typedef_sname_c = 408, /* namespace_typedef_sname_c  */
  YYSYMBOL_brace_in_scope_declaration_c_exp = 409, /* brace_in_scope_declaration_c_exp  */
  YYSYMBOL_brace_in_scope_declaration_c_opt = 410, /* brace_in_scope_declaration_c_opt  */
  YYSYMBOL_brace_in_scope_declaration_c = 411, /* brace_in_scope_declaration_c  */
  YYSYMBOL_in_scope_declaration_c_exp = 412, /* in_scope_declaration_c_exp  */
  YYSYMBOL_lambda_declaration_c = 413,     /* lambda_declaration_c  */
  YYSYMBOL_capture_decl_list_c_opt = 414,  /* capture_decl_list_c_opt  */
  YYSYMBOL_capture_decl_list_c = 415,      /* capture_decl_list_c  */
  YYSYMBOL_capture_decl_c_ast = 416,       /* capture_decl_c_ast  */
  YYSYMBOL_lambda_return_type_c_ast_opt = 417, /* lambda_return_type_c_ast_opt  */
  YYSYMBOL_418_14 = 418,                   /* $@14  */
  YYSYMBOL_template_declaration_c = 419,   /* template_declaration_c  */
  YYSYMBOL_typed_declaration_c = 420,      /* typed_declaration_c  */
  YYSYMBOL_421_15 = 421,                   /* $@15  */
  YYSYMBOL_typedef_declaration_c = 422,    /* typedef_declaration_c  */
  YYSYMBOL_423_16 = 423,                   /* $@16  */
  YYSYMBOL_424_17 = 424,                   /* $@17  */
  YYSYMBOL_typedef_decl_list_c = 425,      /* typedef_decl_list_c  */
  YYSYMBOL_typedef_decl_c = 426,           /* typedef_decl_c  */
  YYSYMBOL_typedef_decl_c_exp = 427,       /* typedef_decl_c_exp  */
  YYSYMBOL_user_defined_conversion_declaration_c = 428, /* user_defined_conversion_declaration_c  */
  YYSYMBOL_using_declaration_c = 429,      /* using_declaration_c  */
  YYSYMBOL_using_decl_c_ast = 430,         /* using_decl_c_ast  */
  YYSYMBOL_431_18 = 431,                   /* $@18  */
  YYSYMBOL_432_19 = 432,                   /* $@19  */
  YYSYMBOL_decl_list_c_opt = 433,          /* decl_list_c_opt  */
  YYSYMBOL_decl_list_c = 434,              /* decl_list_c  */
  YYSYMBOL_decl_c = 435,                   /* decl_c  */
  YYSYMBOL_decl_c_exp = 436,               /* decl_c_exp  */
  YYSYMBOL_decl_c_astp = 437,              /* decl_c_astp  */
  YYSYMBOL_msc_calling_convention_c_astp = 438, /* msc_calling_convention_c_astp  */
  YYSYMBOL_decl2_c_astp = 439,             /* decl2_c_astp  */
  YYSYMBOL_param_pack_decl_c_ast = 440,    /* param_pack_decl_c_ast  */
  YYSYMBOL_array_decl_c_astp = 441,        /* array_decl_c_astp  */
  YYSYMBOL_array_size_c_ast = 442,         /* array_size_c_ast  */
  YYSYMBOL_block_decl_c_astp = 443,        /* block_decl_c_astp  */
  YYSYMBOL_444_20 = 444,                   /* $@20  */
  YYSYMBOL_destructor_declaration_c = 445, /* destructor_declaration_c  */
  YYSYMBOL_no_destructor_params = 446,     /* no_destructor_params  */
  YYSYMBOL_file_scope_constructor_declaration_c = 447, /* file_scope_constructor_declaration_c  */
  YYSYMBOL_file_scope_destructor_declaration_c = 448, /* file_scope_destructor_declaration_c  */
  YYSYMBOL_func_decl_c_astp = 449,         /* func_decl_c_astp  */
  YYSYMBOL_pc99_func_or_constructor_declaration_c = 450, /* pc99_func_or_constructor_declaration_c  */
  YYSYMBOL_451_21 = 451,                   /* $@21  */
  YYSYMBOL_param_list_rparen_func_qualifier_list_c_stid_opt = 452, /* param_list_rparen_func_qualifier_list_c_stid_opt  */
  YYSYMBOL_453_22 = 453,                   /* $@22  */
  YYSYMBOL_func_qualifier_list_c_stid_opt = 454, /* func_qualifier_list_c_stid_opt  */
  YYSYMBOL_func_qualifier_c_stid = 455,    /* func_qualifier_c_stid  */
  YYSYMBOL_noexcept_c_stid_opt = 456,      /* noexcept_c_stid_opt  */
  YYSYMBOL_noexcept_bool_stid_exp = 457,   /* noexcept_bool_stid_exp  */
  YYSYMBOL_trailing_return_type_c_ast_opt = 458, /* trailing_return_type_c_ast_opt  */
  YYSYMBOL_459_23 = 459,                   /* $@23  */
  YYSYMBOL_func_equals_c_stid_opt = 460,   /* func_equals_c_stid_opt  */
  YYSYMBOL_delete_reason_opt = 461,        /* delete_reason_opt  */
  YYSYMBOL_param_c_ast_list_exp = 462,     /* param_c_ast_list_exp  */
  YYSYMBOL_param_c_ast_list_opt = 463,     /* param_c_ast_list_opt  */
  YYSYMBOL_param_c_ast_list = 464,         /* param_c_ast_list  */
  YYSYMBOL_param_c_ast = 465,              /* param_c_ast  */
  YYSYMBOL_466_24 = 466,                   /* $@24  */
  YYSYMBOL_param_c_ast_exp = 467,          /* param_c_ast_exp  */
  YYSYMBOL_paren_param_c_ast_list_opt = 468, /* paren_param_c_ast_list_opt  */
  YYSYMBOL_param_list_c_lparen = 469,      /* param_list_c_lparen  */
  YYSYMBOL_param_list_rparen = 470,        /* param_list_rparen  */
  YYSYMBOL_nested_decl_c_astp = 471,       /* nested_decl_c_astp  */
  YYSYMBOL_472_25 = 472,                   /* $@25  */
  YYSYMBOL_oper_decl_c_astp = 473,         /* oper_decl_c_astp  */
  YYSYMBOL_pointer_decl_c_astp = 474,      /* pointer_decl_c_astp  */
  YYSYMBOL_475_26 = 475,                   /* $@26  */
  YYSYMBOL_pointer_type_c_ast = 476,       /* pointer_type_c_ast  */
  YYSYMBOL_pc99_pointer_decl_list_c = 477, /* pc99_pointer_decl_list_c  */
  YYSYMBOL_pc99_pointer_decl_c = 478,      /* pc99_pointer_decl_c  */
  YYSYMBOL_479_27 = 479,                   /* $@27  */
  YYSYMBOL_pc99_pointer_type_c_ast = 480,  /* pc99_pointer_type_c_ast  */
  YYSYMBOL_pointer_to_member_decl_c_astp = 481, /* pointer_to_member_decl_c_astp  */
  YYSYMBOL_482_28 = 482,                   /* $@28  */
  YYSYMBOL_pointer_to_member_type_c_ast = 483, /* pointer_to_member_type_c_ast  */
  YYSYMBOL_reference_decl_c_astp = 484,    /* reference_decl_c_astp  */
  YYSYMBOL_485_29 = 485,                   /* $@29  */
  YYSYMBOL_reference_type_c_ast = 486,     /* reference_type_c_ast  */
  YYSYMBOL_typedef_type_decl_c_ast = 487,  /* typedef_type_decl_c_ast  */
  YYSYMBOL_user_defined_conversion_decl_c_astp = 488, /* user_defined_conversion_decl_c_astp  */
  YYSYMBOL_489_30 = 489,                   /* $@30  */
  YYSYMBOL_user_defined_literal_decl_c_astp = 490, /* user_defined_literal_decl_c_astp  */
  YYSYMBOL_cast_c_astp_opt = 491,          /* cast_c_astp_opt  */
  YYSYMBOL_cast_c_astp = 492,              /* cast_c_astp  */
  YYSYMBOL_cast2_c_astp = 493,             /* cast2_c_astp  */
  YYSYMBOL_param_pack_cast_c_ast = 494,    /* param_pack_cast_c_ast  */
  YYSYMBOL_array_cast_c_astp = 495,        /* array_cast_c_astp  */
  YYSYMBOL_block_cast_c_astp = 496,        /* block_cast_c_astp  */
  YYSYMBOL_497_31 = 497,                   /* $@31  */
  YYSYMBOL_func_cast_c_astp = 498,         /* func_cast_c_astp  */
  YYSYMBOL_nested_cast_c_astp = 499,       /* nested_cast_c_astp  */
  YYSYMBOL_500_32 = 500,                   /* $@32  */
  YYSYMBOL_pointer_cast_c_astp = 501,      /* pointer_cast_c_astp  */
  YYSYMBOL_502_33 = 502,                   /* $@33  */
  YYSYMBOL_pointer_to_member_cast_c_astp = 503, /* pointer_to_member_cast_c_astp  */
  YYSYMBOL_504_34 = 504,                   /* $@34  */
  YYSYMBOL_reference_cast_c_astp = 505,    /* reference_cast_c_astp  */
  YYSYMBOL_506_35 = 506,                   /* $@35  */
  YYSYMBOL_udc_decl_c_ast_opt = 507,       /* udc_decl_c_ast_opt  */
  YYSYMBOL_udc_decl_c_ast = 508,           /* udc_decl_c_ast  */
  YYSYMBOL_pointer_udc_decl_c_ast = 509,   /* pointer_udc_decl_c_ast  */
  YYSYMBOL_510_36 = 510,                   /* $@36  */
  YYSYMBOL_pointer_to_member_udc_decl_c_ast = 511, /* pointer_to_member_udc_decl_c_ast  */
  YYSYMBOL_512_37 = 512,                   /* $@37  */
  YYSYMBOL_reference_udc_decl_c_ast = 513, /* reference_udc_decl_c_ast  */
  YYSYMBOL_514_38 = 514,                   /* $@38  */
  YYSYMBOL_type_c_ast = 515,               /* type_c_ast  */
  YYSYMBOL_type_modifier_list_c_type_opt = 516, /* type_modifier_list_c_type_opt  */
  YYSYMBOL_type_modifier_list_c_type = 517, /* type_modifier_list_c_type  */
  YYSYMBOL_type_modifier_c_type = 518,     /* type_modifier_c_type  */
  YYSYMBOL_type_modifier_base_type = 519,  /* type_modifier_base_type  */
  YYSYMBOL_east_modified_type_c_ast = 520, /* east_modified_type_c_ast  */
  YYSYMBOL_east_modifiable_type_c_ast = 521, /* east_modifiable_type_c_ast  */
  YYSYMBOL_atomic_specifier_type_c_ast = 522, /* atomic_specifier_type_c_ast  */
  YYSYMBOL_523_39 = 523,                   /* $@39  */
  YYSYMBOL_builtin_type_c_ast = 524,       /* builtin_type_c_ast  */
  YYSYMBOL_builtin_no_BitInt_c_btid = 525, /* builtin_no_BitInt_c_btid  */
  YYSYMBOL_concept_type_c_ast = 526,       /* concept_type_c_ast  */
  YYSYMBOL_structured_binding_type_c_ast = 527, /* structured_binding_type_c_ast  */
  YYSYMBOL_typedef_type_c_ast = 528,       /* typedef_type_c_ast  */
  YYSYMBOL_sub_scope_sname_c_opt = 529,    /* sub_scope_sname_c_opt  */
  YYSYMBOL_typeof_type_c_ast = 530,        /* typeof_type_c_ast  */
  YYSYMBOL_531_40 = 531,                   /* $@40  */
  YYSYMBOL_typeof = 532,                   /* typeof  */
  YYSYMBOL_enum_class_struct_union_c_ast = 533, /* enum_class_struct_union_c_ast  */
  YYSYMBOL_class_struct_union_c_ast = 534, /* class_struct_union_c_ast  */
  YYSYMBOL_enum_c_ast = 535,               /* enum_c_ast  */
  YYSYMBOL_enum_btids = 536,               /* enum_btids  */
  YYSYMBOL_enum_fixed_type_c_ast_opt = 537, /* enum_fixed_type_c_ast_opt  */
  YYSYMBOL_enum_fixed_type_c_ast = 538,    /* enum_fixed_type_c_ast  */
  YYSYMBOL_enum_fixed_type_modifier_list_btid_opt = 539, /* enum_fixed_type_modifier_list_btid_opt  */
  YYSYMBOL_enum_fixed_type_modifier_list_btid = 540, /* enum_fixed_type_modifier_list_btid  */
  YYSYMBOL_enum_fixed_type_modifier_btid = 541, /* enum_fixed_type_modifier_btid  */
  YYSYMBOL_enum_unmodified_fixed_type_c_ast = 542, /* enum_unmodified_fixed_type_c_ast  */
  YYSYMBOL_class_struct_btid_opt = 543,    /* class_struct_btid_opt  */
  YYSYMBOL_class_struct_btid = 544,        /* class_struct_btid  */
  YYSYMBOL_class_struct_union_btid = 545,  /* class_struct_union_btid  */
  YYSYMBOL_type_qualifier_list_c_stid_opt = 546, /* type_qualifier_list_c_stid_opt  */
  YYSYMBOL_type_qualifier_list_c_stid = 547, /* type_qualifier_list_c_stid  */
  YYSYMBOL_type_qualifier_c_stid = 548,    /* type_qualifier_c_stid  */
  YYSYMBOL_cv_qualifier_stid = 549,        /* cv_qualifier_stid  */
  YYSYMBOL_cv_qualifier_list_stid_opt = 550, /* cv_qualifier_list_stid_opt  */
  YYSYMBOL_restrict_qualifier_c_stid = 551, /* restrict_qualifier_c_stid  */
  YYSYMBOL_upc_layout_qualifier_c = 552,   /* upc_layout_qualifier_c  */
  YYSYMBOL_storage_class_c_type = 553,     /* storage_class_c_type  */
  YYSYMBOL__Noreturn_atid = 554,           /* _Noreturn_atid  */
  YYSYMBOL_attribute_specifier_list_c_atid_opt = 555, /* attribute_specifier_list_c_atid_opt  */
  YYSYMBOL_attribute_specifier_list_c_atid = 556, /* attribute_specifier_list_c_atid  */
  YYSYMBOL_557_41 = 557,                   /* $@41  */
  YYSYMBOL_using_opt = 558,                /* using_opt  */
  YYSYMBOL_attribute_list_c_atid_opt = 559, /* attribute_list_c_atid_opt  */
  YYSYMBOL_attribute_list_c_atid = 560,    /* attribute_list_c_atid  */
  YYSYMBOL_attribute_c_atid_exp = 561,     /* attribute_c_atid_exp  */
  YYSYMBOL_attribute_str_arg_c_opt = 562,  /* attribute_str_arg_c_opt  */
  YYSYMBOL_gnu_or_msc_attribute_specifier_list_c_opt = 563, /* gnu_or_msc_attribute_specifier_list_c_opt  */
  YYSYMBOL_gnu_or_msc_attribute_specifier_list_c = 564, /* gnu_or_msc_attribute_specifier_list_c  */
  YYSYMBOL_gnu_attribute_specifier_list_c_opt = 565, /* gnu_attribute_specifier_list_c_opt  */
  YYSYMBOL_gnu_attribute_specifier_list_c = 566, /* gnu_attribute_specifier_list_c  */
  YYSYMBOL_gnu_attribute_specifier_c = 567, /* gnu_attribute_specifier_c  */
  YYSYMBOL_568_42 = 568,                   /* $@42  */
  YYSYMBOL_gnu_attribute_list_c_opt = 569, /* gnu_attribute_list_c_opt  */
  YYSYMBOL_gnu_attribuet_list_c = 570,     /* gnu_attribuet_list_c  */
  YYSYMBOL_gnu_attribute_c_exp = 571,      /* gnu_attribute_c_exp  */
  YYSYMBOL_gnu_attribute_decl_arg_list_c_opt = 572, /* gnu_attribute_decl_arg_list_c_opt  */
  YYSYMBOL_gnu_attribute_arg_list_c_opt = 573, /* gnu_attribute_arg_list_c_opt  */
  YYSYMBOL_gnu_attribute_arg_list_c = 574, /* gnu_attribute_arg_list_c  */
  YYSYMBOL_gnu_attribute_arg_c = 575,      /* gnu_attribute_arg_c  */
  YYSYMBOL_msc_attribute_specifier_list_c = 576, /* msc_attribute_specifier_list_c  */
  YYSYMBOL_msc_attribute_specifier_c = 577, /* msc_attribute_specifier_c  */
  YYSYMBOL_578_43 = 578,                   /* $@43  */
  YYSYMBOL_msc_attribute_list_c_opt = 579, /* msc_attribute_list_c_opt  */
  YYSYMBOL_msc_attribuet_list_c = 580,     /* msc_attribuet_list_c  */
  YYSYMBOL_decl_english_ast = 581,         /* decl_english_ast  */
  YYSYMBOL_array_decl_english_ast = 582,   /* array_decl_english_ast  */
  YYSYMBOL_array_size_decl_ast = 583,      /* array_size_decl_ast  */
  YYSYMBOL_length_opt = 584,               /* length_opt  */
  YYSYMBOL_block_decl_english_ast = 585,   /* block_decl_english_ast  */
  YYSYMBOL_constructor_decl_english_ast = 586, /* constructor_decl_english_ast  */
  YYSYMBOL_destructor_decl_english_ast = 587, /* destructor_decl_english_ast  */
  YYSYMBOL_destructor_parens_opt = 588,    /* destructor_parens_opt  */
  YYSYMBOL_func_decl_english_ast = 589,    /* func_decl_english_ast  */
  YYSYMBOL_func_qualifier_english_type_opt = 590, /* func_qualifier_english_type_opt  */
  YYSYMBOL_msc_calling_convention_atid = 591, /* msc_calling_convention_atid  */
  YYSYMBOL_paren_param_decl_list_english_opt = 592, /* paren_param_decl_list_english_opt  */
  YYSYMBOL_paren_param_decl_list_english = 593, /* paren_param_decl_list_english  */
  YYSYMBOL_param_decl_list_english_opt = 594, /* param_decl_list_english_opt  */
  YYSYMBOL_param_decl_list_english = 595,  /* param_decl_list_english  */
  YYSYMBOL_decl_english_ast_exp = 596,     /* decl_english_ast_exp  */
  YYSYMBOL_ref_qualifier_english_stid_opt = 597, /* ref_qualifier_english_stid_opt  */
  YYSYMBOL_returning_english_ast_opt = 598, /* returning_english_ast_opt  */
  YYSYMBOL_returning_english_ast = 599,    /* returning_english_ast  */
  YYSYMBOL_qualified_decl_english_ast = 600, /* qualified_decl_english_ast  */
  YYSYMBOL_type_qualifier_list_english_type_opt = 601, /* type_qualifier_list_english_type_opt  */
  YYSYMBOL_type_qualifier_list_english_type = 602, /* type_qualifier_list_english_type  */
  YYSYMBOL_type_qualifier_english_type = 603, /* type_qualifier_english_type  */
  YYSYMBOL_attribute_english_atid = 604,   /* attribute_english_atid  */
  YYSYMBOL_storage_class_english_stid = 605, /* storage_class_english_stid  */
  YYSYMBOL_eval_expr_init_stid = 606,      /* eval_expr_init_stid  */
  YYSYMBOL_linkage_stid = 607,             /* linkage_stid  */
  YYSYMBOL_linkage_opt = 608,              /* linkage_opt  */
  YYSYMBOL_type_qualifier_english_stid = 609, /* type_qualifier_english_stid  */
  YYSYMBOL_upc_layout_qualifier_english = 610, /* upc_layout_qualifier_english  */
  YYSYMBOL_qualifiable_decl_english_ast = 611, /* qualifiable_decl_english_ast  */
  YYSYMBOL_pointer_decl_english_ast = 612, /* pointer_decl_english_ast  */
  YYSYMBOL_reference_decl_english_ast = 613, /* reference_decl_english_ast  */
  YYSYMBOL_reference_english_ast = 614,    /* reference_english_ast  */
  YYSYMBOL_structured_binding_decl_english_ast = 615, /* structured_binding_decl_english_ast  */
  YYSYMBOL_user_defined_literal_decl_english_ast = 616, /* user_defined_literal_decl_english_ast  */
  YYSYMBOL_var_decl_english_ast = 617,     /* var_decl_english_ast  */
  YYSYMBOL_type_english_ast = 618,         /* type_english_ast  */
  YYSYMBOL_type_modifier_list_english_type_opt = 619, /* type_modifier_list_english_type_opt  */
  YYSYMBOL_type_modifier_list_english_type = 620, /* type_modifier_list_english_type  */
  YYSYMBOL_type_modifier_english_type = 621, /* type_modifier_english_type  */
  YYSYMBOL_unmodified_type_english_ast = 622, /* unmodified_type_english_ast  */
  YYSYMBOL_builtin_type_english_ast = 623, /* builtin_type_english_ast  */
  YYSYMBOL_builtin_no_BitInt_english_btid = 624, /* builtin_no_BitInt_english_btid  */
  YYSYMBOL_BitInt_english_int = 625,       /* BitInt_english_int  */
  YYSYMBOL_BitInt_english = 626,           /* BitInt_english  */
  YYSYMBOL_concept_type_english_ast = 627, /* concept_type_english_ast  */
  YYSYMBOL_parameter_pack_english_ast = 628, /* parameter_pack_english_ast  */
  YYSYMBOL_pack_exp = 629,                 /* pack_exp  */
  YYSYMBOL_precise_opt = 630,              /* precise_opt  */
  YYSYMBOL_class_struct_union_english_ast = 631, /* class_struct_union_english_ast  */
  YYSYMBOL_enum_english_ast = 632,         /* enum_english_ast  */
  YYSYMBOL_of_type_enum_fixed_type_english_ast_opt = 633, /* of_type_enum_fixed_type_english_ast_opt  */
  YYSYMBOL_enum_fixed_type_english_ast = 634, /* enum_fixed_type_english_ast  */
  YYSYMBOL_enum_fixed_type_modifier_list_english_btid_opt = 635, /* enum_fixed_type_modifier_list_english_btid_opt  */
  YYSYMBOL_enum_fixed_type_modifier_list_english_btid = 636, /* enum_fixed_type_modifier_list_english_btid  */
  YYSYMBOL_enum_unmodified_fixed_type_english_ast = 637, /* enum_unmodified_fixed_type_english_ast  */
  YYSYMBOL_any_name = 638,                 /* any_name  */
  YYSYMBOL_any_name_exp = 639,             /* any_name_exp  */
  YYSYMBOL_any_sname_c = 640,              /* any_sname_c  */
  YYSYMBOL_any_sname_c_exp = 641,          /* any_sname_c_exp  */
  YYSYMBOL_any_sname_c_opt = 642,          /* any_sname_c_opt  */
  YYSYMBOL_any_typedef_tdef = 643,         /* any_typedef_tdef  */
  YYSYMBOL_name_ast = 644,                 /* name_ast  */
  YYSYMBOL_name_exp = 645,                 /* name_exp  */
  YYSYMBOL_name_cat = 646,                 /* name_cat  */
  YYSYMBOL_name_opt = 647,                 /* name_opt  */
  YYSYMBOL_oper_sname_c_opt = 648,         /* oper_sname_c_opt  */
  YYSYMBOL_sname_c = 649,                  /* sname_c  */
  YYSYMBOL_sname_c_ast = 650,              /* sname_c_ast  */
  YYSYMBOL_bit_field_c_uint_opt = 651,     /* bit_field_c_uint_opt  */
  YYSYMBOL_sname_c_exp = 652,              /* sname_c_exp  */
  YYSYMBOL_sname_c_opt = 653,              /* sname_c_opt  */
  YYSYMBOL_sname_english = 654,            /* sname_english  */
  YYSYMBOL_sname_english_ast = 655,        /* sname_english_ast  */
  YYSYMBOL_sname_english_exp = 656,        /* sname_english_exp  */
  YYSYMBOL_sname_english_opt = 657,        /* sname_english_opt  */
  YYSYMBOL_sname_list_c = 658,             /* sname_list_c  */
  YYSYMBOL_sname_list_english = 659,       /* sname_list_english  */
  YYSYMBOL_typedef_sname_c = 660,          /* typedef_sname_c  */
  YYSYMBOL_address_exp = 661,              /* address_exp  */
  YYSYMBOL_array_exp = 662,                /* array_exp  */
  YYSYMBOL_as_exp = 663,                   /* as_exp  */
  YYSYMBOL_as_into_to_exp = 664,           /* as_into_to_exp  */
  YYSYMBOL_as_or_to_opt = 665,             /* as_or_to_opt  */
  YYSYMBOL_auto_TYPE_exp = 666,            /* auto_TYPE_exp  */
  YYSYMBOL_binding_exp = 667,              /* binding_exp  */
  YYSYMBOL_bits_opt = 668,                 /* bits_opt  */
  YYSYMBOL_bytes_opt = 669,                /* bytes_opt  */
  YYSYMBOL_cast_exp = 670,                 /* cast_exp  */
  YYSYMBOL_char_exp = 671,                 /* char_exp  */
  YYSYMBOL_class_struct_union_btid_exp = 672, /* class_struct_union_btid_exp  */
  YYSYMBOL_colon_exp = 673,                /* colon_exp  */
  YYSYMBOL_comma_exp = 674,                /* comma_exp  */
  YYSYMBOL_conversion_exp = 675,           /* conversion_exp  */
  YYSYMBOL_c_operator = 676,               /* c_operator  */
  YYSYMBOL_default_exp = 677,              /* default_exp  */
  YYSYMBOL_defined_exp = 678,              /* defined_exp  */
  YYSYMBOL_dependency_exp = 679,           /* dependency_exp  */
  YYSYMBOL_destructor_sname = 680,         /* destructor_sname  */
  YYSYMBOL_empty_str_lit_exp = 681,        /* empty_str_lit_exp  */
  YYSYMBOL_equals_exp = 682,               /* equals_exp  */
  YYSYMBOL_extern_linkage_c_stid = 683,    /* extern_linkage_c_stid  */
  YYSYMBOL_extern_linkage_c_stid_opt = 684, /* extern_linkage_c_stid_opt  */
  YYSYMBOL_glob = 685,                     /* glob  */
  YYSYMBOL_glob_opt = 686,                 /* glob_opt  */
  YYSYMBOL_gt_exp = 687,                   /* gt_exp  */
  YYSYMBOL_inline_stid_opt = 688,          /* inline_stid_opt  */
  YYSYMBOL_int_exp = 689,                  /* int_exp  */
  YYSYMBOL_lbracket_exp = 690,             /* lbracket_exp  */
  YYSYMBOL_literal_exp = 691,              /* literal_exp  */
  YYSYMBOL_local_exp = 692,                /* local_exp  */
  YYSYMBOL_lparen_exp = 693,               /* lparen_exp  */
  YYSYMBOL_lt_exp = 694,                   /* lt_exp  */
  YYSYMBOL_member_or_non_member_opt = 695, /* member_or_non_member_opt  */
  YYSYMBOL_namespace_btid_exp = 696,       /* namespace_btid_exp  */
  YYSYMBOL_namespace_type = 697,           /* namespace_type  */
  YYSYMBOL_of_exp = 698,                   /* of_exp  */
  YYSYMBOL_of_scope_english = 699,         /* of_scope_english  */
  YYSYMBOL_of_scope_list_english = 700,    /* of_scope_list_english  */
  YYSYMBOL_of_scope_list_english_opt = 701, /* of_scope_list_english_opt  */
  YYSYMBOL_operator_exp = 702,             /* operator_exp  */
  YYSYMBOL_operator_opt = 703,             /* operator_opt  */
  YYSYMBOL_point_exp = 704,                /* point_exp  */
  YYSYMBOL_precision_opt = 705,            /* precision_opt  */
  YYSYMBOL_rbrace_exp = 706,               /* rbrace_exp  */
  YYSYMBOL_rbracket_exp = 707,             /* rbracket_exp  */
  YYSYMBOL_ref_qualifier_c_stid_opt = 708, /* ref_qualifier_c_stid_opt  */
  YYSYMBOL_reference_exp = 709,            /* reference_exp  */
  YYSYMBOL_returning = 710,                /* returning  */
  YYSYMBOL_returning_exp = 711,            /* returning_exp  */
  YYSYMBOL_rparen_exp = 712,               /* rparen_exp  */
  YYSYMBOL_scope_english_type = 713,       /* scope_english_type  */
  YYSYMBOL_scope_english_type_exp = 714,   /* scope_english_type_exp  */
  YYSYMBOL_semi_exp = 715,                 /* semi_exp  */
  YYSYMBOL_semi_opt = 716,                 /* semi_opt  */
  YYSYMBOL_semi_or_end = 717,              /* semi_or_end  */
  YYSYMBOL_static_stid_opt = 718,          /* static_stid_opt  */
  YYSYMBOL_str_lit = 719,                  /* str_lit  */
  YYSYMBOL_str_lit_exp = 720,              /* str_lit_exp  */
  YYSYMBOL_this_exp = 721,                 /* this_exp  */
  YYSYMBOL_this_stid_opt = 722,            /* this_stid_opt  */
  YYSYMBOL_to_exp = 723,                   /* to_exp  */
  YYSYMBOL_type_opt = 724,                 /* type_opt  */
  YYSYMBOL_typename_flag_opt = 725,        /* typename_flag_opt  */
  YYSYMBOL_uint_lit = 726,                 /* uint_lit  */
  YYSYMBOL_uint_lit_exp = 727,             /* uint_lit_exp  */
  YYSYMBOL_uint_lit_opt = 728,             /* uint_lit_opt  */
  YYSYMBOL_unused_exp = 729,               /* unused_exp  */
  YYSYMBOL_user_defined = 730,             /* user_defined  */
  YYSYMBOL_virtual_stid_exp = 731,         /* virtual_stid_exp  */
  YYSYMBOL_virtual_stid_opt = 732          /* virtual_stid_opt  */
};
typedef enum yysymbol_kind_t yysymbol_kind_t;




#ifdef short
# undef short
#endif

/* On compilers that do not define __PTRDIFF_MAX__ etc., make sure
   <limits.h> and (if available) <stdint.h> are included
   so that the code can choose integer types of a good width.  */

#ifndef __PTRDIFF_MAX__
# include <limits.h> /* INFRINGES ON USER NAME SPACE */
# if defined __STDC_VERSION__ && 199901 <= __STDC_VERSION__
#  include <stdint.h> /* INFRINGES ON USER NAME SPACE */
#  define YY_STDINT_H
# endif
#endif

/* Narrow types that promote to a signed type and that can represent a
   signed or unsigned integer of at least N bits.  In tables they can
   save space and decrease cache pressure.  Promoting to a signed type
   helps avoid bugs in integer arithmetic.  */

#ifdef __INT_LEAST8_MAX__
typedef __INT_LEAST8_TYPE__ yytype_int8;
#elif defined YY_STDINT_H
typedef int_least8_t yytype_int8;
#else
typedef signed char yytype_int8;
#endif

#ifdef __INT_LEAST16_MAX__
typedef __INT_LEAST16_TYPE__ yytype_int16;
#elif defined YY_STDINT_H
typedef int_least16_t yytype_int16;
#else
typedef short yytype_int16;
#endif

/* Work around bug in HP-UX 11.23, which defines these macros
   incorrectly for preprocessor constants.  This workaround can likely
   be removed in 2023, as HPE has promised support for HP-UX 11.23
   (aka HP-UX 11i v2) only through the end of 2022; see Table 2 of
   <https://h20195.www2.hpe.com/V2/getpdf.aspx/4AA4-7673ENW.pdf>.  */
#ifdef __hpux
# undef UINT_LEAST8_MAX
# undef UINT_LEAST16_MAX
# define UINT_LEAST8_MAX 255
# define UINT_LEAST16_MAX 65535
#endif

#if defined __UINT_LEAST8_MAX__ && __UINT_LEAST8_MAX__ <= __INT_MAX__
typedef __UINT_LEAST8_TYPE__ yytype_uint8;
#elif (!defined __UINT_LEAST8_MAX__ && defined YY_STDINT_H \
       && UINT_LEAST8_MAX <= INT_MAX)
typedef uint_least8_t yytype_uint8;
#elif !defined __UINT_LEAST8_MAX__ && UCHAR_MAX <= INT_MAX
typedef unsigned char yytype_uint8;
#else
typedef short yytype_uint8;
#endif

#if defined __UINT_LEAST16_MAX__ && __UINT_LEAST16_MAX__ <= __INT_MAX__
typedef __UINT_LEAST16_TYPE__ yytype_uint16;
#elif (!defined __UINT_LEAST16_MAX__ && defined YY_STDINT_H \
       && UINT_LEAST16_MAX <= INT_MAX)
typedef uint_least16_t yytype_uint16;
#elif !defined __UINT_LEAST16_MAX__ && USHRT_MAX <= INT_MAX
typedef unsigned short yytype_uint16;
#else
typedef int yytype_uint16;
#endif

#ifndef YYPTRDIFF_T
# if defined __PTRDIFF_TYPE__ && defined __PTRDIFF_MAX__
#  define YYPTRDIFF_T __PTRDIFF_TYPE__
#  define YYPTRDIFF_MAXIMUM __PTRDIFF_MAX__
# elif defined PTRDIFF_MAX
#  ifndef ptrdiff_t
#   include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  endif
#  define YYPTRDIFF_T ptrdiff_t
#  define YYPTRDIFF_MAXIMUM PTRDIFF_MAX
# else
#  define YYPTRDIFF_T long
#  define YYPTRDIFF_MAXIMUM LONG_MAX
# endif
#endif

#ifndef YYSIZE_T
# ifdef __SIZE_TYPE__
#  define YYSIZE_T __SIZE_TYPE__
# elif defined size_t
#  define YYSIZE_T size_t
# elif defined __STDC_VERSION__ && 199901 <= __STDC_VERSION__
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# else
#  define YYSIZE_T unsigned
# endif
#endif

#define YYSIZE_MAXIMUM                                  \
  YY_CAST (YYPTRDIFF_T,                                 \
           (YYPTRDIFF_MAXIMUM < YY_CAST (YYSIZE_T, -1)  \
            ? YYPTRDIFF_MAXIMUM                         \
            : YY_CAST (YYSIZE_T, -1)))

#define YYSIZEOF(X) YY_CAST (YYPTRDIFF_T, sizeof (X))


/* Stored state numbers (used for stacks). */
typedef yytype_int16 yy_state_t;

/* State numbers in computations.  */
typedef int yy_state_fast_t;

#ifndef YY_
# if defined YYENABLE_NLS && YYENABLE_NLS
#  if ENABLE_NLS
#   include <libintl.h> /* INFRINGES ON USER NAME SPACE */
#   define YY_(Msgid) dgettext ("bison-runtime", Msgid)
#  endif
# endif
# ifndef YY_
#  define YY_(Msgid) Msgid
# endif
#endif


#ifndef YY_ATTRIBUTE_PURE
# if defined __GNUC__ && 2 < __GNUC__ + (96 <= __GNUC_MINOR__)
#  define YY_ATTRIBUTE_PURE __attribute__ ((__pure__))
# else
#  define YY_ATTRIBUTE_PURE
# endif
#endif

#ifndef YY_ATTRIBUTE_UNUSED
# if defined __GNUC__ && 2 < __GNUC__ + (7 <= __GNUC_MINOR__)
#  define YY_ATTRIBUTE_UNUSED __attribute__ ((__unused__))
# else
#  define YY_ATTRIBUTE_UNUSED
# endif
#endif

/* Suppress unused-variable warnings by "using" E.  */
#if ! defined lint || defined __GNUC__
# define YY_USE(E) ((void) (E))
#else
# define YY_USE(E) /* empty */
#endif

/* Suppress an incorrect diagnostic about yylval being uninitialized.  */
#if defined __GNUC__ && ! defined __ICC && 406 <= __GNUC__ * 100 + __GNUC_MINOR__
# if __GNUC__ * 100 + __GNUC_MINOR__ < 407
#  define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN                           \
    _Pragma ("GCC diagnostic push")                                     \
    _Pragma ("GCC diagnostic ignored \"-Wuninitialized\"")
# else
#  define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN                           \
    _Pragma ("GCC diagnostic push")                                     \
    _Pragma ("GCC diagnostic ignored \"-Wuninitialized\"")              \
    _Pragma ("GCC diagnostic ignored \"-Wmaybe-uninitialized\"")
# endif
# define YY_IGNORE_MAYBE_UNINITIALIZED_END      \
    _Pragma ("GCC diagnostic pop")
#else
# define YY_INITIAL_VALUE(Value) Value
#endif
#ifndef YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_END
#endif
#ifndef YY_INITIAL_VALUE
# define YY_INITIAL_VALUE(Value) /* Nothing. */
#endif

#if defined __cplusplus && defined __GNUC__ && ! defined __ICC && 6 <= __GNUC__
# define YY_IGNORE_USELESS_CAST_BEGIN                          \
    _Pragma ("GCC diagnostic push")                            \
    _Pragma ("GCC diagnostic ignored \"-Wuseless-cast\"")
# define YY_IGNORE_USELESS_CAST_END            \
    _Pragma ("GCC diagnostic pop")
#endif
#ifndef YY_IGNORE_USELESS_CAST_BEGIN
# define YY_IGNORE_USELESS_CAST_BEGIN
# define YY_IGNORE_USELESS_CAST_END
#endif


#define YY_ASSERT(E) ((void) (0 && (E)))

#if !defined yyoverflow

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# ifdef YYSTACK_USE_ALLOCA
#  if YYSTACK_USE_ALLOCA
#   ifdef __GNUC__
#    define YYSTACK_ALLOC __builtin_alloca
#   elif defined __BUILTIN_VA_ARG_INCR
#    include <alloca.h> /* INFRINGES ON USER NAME SPACE */
#   elif defined _AIX
#    define YYSTACK_ALLOC __alloca
#   elif defined _MSC_VER
#    include <malloc.h> /* INFRINGES ON USER NAME SPACE */
#    define alloca _alloca
#   else
#    define YYSTACK_ALLOC alloca
#    if ! defined _ALLOCA_H && ! defined EXIT_SUCCESS
#     include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
      /* Use EXIT_SUCCESS as a witness for stdlib.h.  */
#     ifndef EXIT_SUCCESS
#      define EXIT_SUCCESS 0
#     endif
#    endif
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's 'empty if-body' warning.  */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (0)
#  ifndef YYSTACK_ALLOC_MAXIMUM
    /* The OS might guarantee only one guard page at the bottom of the stack,
       and a page size can be as small as 4096 bytes.  So we cannot safely
       invoke alloca (N) if N exceeds 4096.  Use a slightly smaller number
       to allow for a few compiler-allocated temporary stack slots.  */
#   define YYSTACK_ALLOC_MAXIMUM 4032 /* reasonable circa 2006 */
#  endif
# else
#  define YYSTACK_ALLOC YYMALLOC
#  define YYSTACK_FREE YYFREE
#  ifndef YYSTACK_ALLOC_MAXIMUM
#   define YYSTACK_ALLOC_MAXIMUM YYSIZE_MAXIMUM
#  endif
#  if (defined __cplusplus && ! defined EXIT_SUCCESS \
       && ! ((defined YYMALLOC || defined malloc) \
             && (defined YYFREE || defined free)))
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   ifndef EXIT_SUCCESS
#    define EXIT_SUCCESS 0
#   endif
#  endif
#  ifndef YYMALLOC
#   define YYMALLOC malloc
#   if ! defined malloc && ! defined EXIT_SUCCESS
void *malloc (YYSIZE_T); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
#  ifndef YYFREE
#   define YYFREE free
#   if ! defined free && ! defined EXIT_SUCCESS
void free (void *); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
# endif
#endif /* !defined yyoverflow */

#if (! defined yyoverflow \
     && (! defined __cplusplus \
         || (defined YYLTYPE_IS_TRIVIAL && YYLTYPE_IS_TRIVIAL \
             && defined YYSTYPE_IS_TRIVIAL && YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  yy_state_t yyss_alloc;
  YYSTYPE yyvs_alloc;
  YYLTYPE yyls_alloc;
};

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (YYSIZEOF (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (YYSIZEOF (yy_state_t) + YYSIZEOF (YYSTYPE) \
             + YYSIZEOF (YYLTYPE)) \
      + 2 * YYSTACK_GAP_MAXIMUM)

# define YYCOPY_NEEDED 1

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack_alloc, Stack)                           \
    do                                                                  \
      {                                                                 \
        YYPTRDIFF_T yynewbytes;                                         \
        YYCOPY (&yyptr->Stack_alloc, Stack, yysize);                    \
        Stack = &yyptr->Stack_alloc;                                    \
        yynewbytes = yystacksize * YYSIZEOF (*Stack) + YYSTACK_GAP_MAXIMUM; \
        yyptr += yynewbytes / YYSIZEOF (*yyptr);                        \
      }                                                                 \
    while (0)

#endif

#if defined YYCOPY_NEEDED && YYCOPY_NEEDED
/* Copy COUNT objects from SRC to DST.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if defined __GNUC__ && 1 < __GNUC__
#   define YYCOPY(Dst, Src, Count) \
      __builtin_memcpy (Dst, Src, YY_CAST (YYSIZE_T, (Count)) * sizeof (*(Src)))
#  else
#   define YYCOPY(Dst, Src, Count)              \
      do                                        \
        {                                       \
          YYPTRDIFF_T yyi;                      \
          for (yyi = 0; yyi < (Count); yyi++)   \
            (Dst)[yyi] = (Src)[yyi];            \
        }                                       \
      while (0)
#  endif
# endif
#endif /* !YYCOPY_NEEDED */

/* YYFINAL -- State number of the termination state.  */
#define YYFINAL  2
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   6540

/* YYNTOKENS -- Number of terminals.  */
#define YYNTOKENS  314
/* YYNNTS -- Number of nonterminals.  */
#define YYNNTS  419
/* YYNRULES -- Number of rules.  */
#define YYNRULES  1128
/* YYNSTATES -- Number of states.  */
#define YYNSTATES  1489

/* YYMAXUTOK -- Last valid token kind.  */
#define YYMAXUTOK   540


/* YYTRANSLATE(TOKEN-NUM) -- Symbol number corresponding to TOKEN-NUM
   as returned by yylex, with out-of-bounds checking.  */
#define YYTRANSLATE(YYX)                                \
  (0 <= (YYX) && (YYX) <= YYMAXUTOK                     \
   ? YY_CAST (yysymbol_kind_t, yytranslate[YYX])        \
   : YYSYMBOL_YYUNDEF)

/* YYTRANSLATE[TOKEN-NUM] -- Symbol number corresponding to TOKEN-NUM
   as returned by yylex.  */
static const yytype_int16 yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,    81,     2,   159,   310,    89,    79,     2,
      72,    73,    80,    91,   132,    90,    76,    88,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,   293,   294,
      98,   114,    99,   313,   311,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,    74,     2,    75,   108,     2,   312,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,   295,   109,   296,    83,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    44,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,    62,    63,    64,
      65,    66,    67,    68,    69,    70,    71,    77,    78,    82,
      84,    85,    86,    87,    92,    93,    94,    95,    96,    97,
     100,   101,   102,   103,   104,   105,   106,   107,   110,   111,
     112,   113,   115,   116,   117,   118,   119,   120,   121,   122,
     123,   124,   125,   126,   127,   128,   129,   130,   131,   133,
     134,   135,   136,   137,   138,   139,   140,   141,   142,   143,
     144,   145,   146,   147,   148,   149,   150,   151,   152,   153,
     154,   155,   156,   157,   158,   160,   161,   162,   163,   164,
     165,   166,   167,   168,   169,   170,   171,   172,   173,   174,
     175,   176,   177,   178,   179,   180,   181,   182,   183,   184,
     185,   186,   187,   188,   189,   190,   191,   192,   193,   194,
     195,   196,   197,   198,   199,   200,   201,   202,   203,   204,
     205,   206,   207,   208,   209,   210,   211,   212,   213,   214,
     215,   216,   217,   218,   219,   220,   221,   222,   223,   224,
     225,   226,   227,   228,   229,   230,   231,   232,   233,   234,
     235,   236,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   246,   247,   248,   249,   250,   251,   252,   253,   254,
     255,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   297,   298,
     299,   300,   301,   302,   303,   304,   305,   306,   307,   308,
     309
};

#if YYDEBUG
/* YYRLINE[YYN] -- Source line where rule number YYN was defined.  */
static const yytype_int16 yyrline[] =
{
       0,  1970,  1970,  1971,  1980,  1981,  1982,  1983,  1984,  1985,
    1986,  1987,  1988,  1989,  1990,  1991,  1992,  1993,  1994,  1995,
    2014,  2036,  2060,  2061,  2062,  2063,  2064,  2073,  2183,  2182,
    2246,  2281,  2313,  2323,  2325,  2340,  2370,  2382,  2400,  2409,
    2410,  2411,  2415,  2416,  2420,  2427,  2431,  2435,  2443,  2444,
    2448,  2463,  2478,  2483,  2488,  2494,  2498,  2499,  2500,  2504,
    2518,  2519,  2537,  2538,  2559,  2560,  2561,  2565,  2566,  2567,
    2568,  2569,  2570,  2571,  2575,  2576,  2577,  2578,  2579,  2580,
    2581,  2582,  2583,  2584,  2585,  2586,  2587,  2588,  2589,  2590,
    2591,  2597,  2645,  2666,  2673,  2688,  2700,  2708,  2709,  2716,
    2717,  2721,  2726,  2735,  2736,  2744,  2749,  2761,  2781,  2800,
    2822,  2829,  2837,  2842,  2861,  2873,  2882,  2887,  2891,  2897,
    2906,  2910,  2914,  2918,  2922,  2926,  2930,  2937,  2938,  2942,
    2943,  2944,  2948,  2949,  2950,  2951,  2954,  2955,  2957,  2958,
    2959,  2960,  2961,  2962,  2963,  2964,  2965,  2966,  2967,  2968,
    2969,  2970,  2971,  2972,  2973,  2974,  2975,  2976,  2977,  2978,
    2979,  2980,  2981,  2982,  2983,  2984,  2985,  2986,  2987,  2988,
    2989,  2990,  2991,  2992,  2993,  2994,  2995,  2996,  2997,  2998,
    3003,  3007,  3021,  3027,  3031,  3037,  3046,  3047,  3059,  3064,
    3069,  3074,  3079,  3084,  3089,  3094,  3099,  3104,  3114,  3123,
    3133,  3133,  3148,  3153,  3176,  3183,  3190,  3208,  3207,  3226,
    3227,  3228,  3229,  3234,  3246,  3247,  3249,  3251,  3255,  3259,
    3263,  3267,  3271,  3275,  3279,  3283,  3287,  3291,  3295,  3299,
    3306,  3347,  3348,  3352,  3362,  3366,  3379,  3394,  3399,  3404,
    3415,  3416,  3420,  3426,  3435,  3446,  3450,  3454,  3458,  3462,
    3466,  3473,  3482,  3488,  3494,  3498,  3502,  3503,  3507,  3517,
    3518,  3519,  3529,  3539,  3549,  3561,  3573,  3578,  3606,  3615,
    3616,  3617,  3631,  3632,  3642,  3643,  3647,  3648,  3652,  3653,
    3658,  3661,  3662,  3668,  3674,  3680,  3691,  3690,  3727,  3738,
    3737,  3769,  3770,  3771,  3772,  3782,  3783,  3782,  3788,  3801,
    3814,  3814,  3832,  3839,  3840,  3846,  3856,  3857,  3858,  3866,
    3871,  3865,  3923,  3922,  3962,  3966,  3961,  4037,  4038,  4039,
    4052,  4066,  4082,  4097,  4116,  4130,  4147,  4164,  4168,  4169,
    4176,  4177,  4181,  4182,  4186,  4187,  4188,  4189,  4198,  4230,
    4231,  4235,  4251,  4266,  4271,  4277,  4282,  4287,  4292,  4300,
    4301,  4301,  4321,  4330,  4330,  4340,  4346,  4339,  4361,  4362,
    4367,  4431,  4432,  4441,  4457,  4468,  4489,  4467,  4559,  4617,
    4629,  4634,  4643,  4674,  4675,  4682,  4683,  4684,  4685,  4686,
    4695,  4696,  4700,  4701,  4702,  4703,  4704,  4705,  4706,  4710,
    4714,  4715,  4719,  4730,  4741,  4776,  4781,  4787,  4793,  4799,
    4807,  4815,  4821,  4830,  4839,  4850,  4849,  4902,  4952,  4953,
    4980,  5017,  5059,  5191,  5190,  5303,  5302,  5321,  5322,  5338,
    5339,  5340,  5348,  5352,  5353,  5354,  5358,  5362,  5378,  5379,
    5380,  5387,  5389,  5389,  5441,  5448,  5449,  5450,  5454,  5462,
    5472,  5473,  5493,  5494,  5502,  5503,  5507,  5520,  5538,  5537,
    5572,  5577,  5589,  5590,  5597,  5598,  5605,  5609,  5616,  5615,
    5640,  5696,  5696,  5716,  5736,  5741,  5749,  5749,  5769,  5809,
    5809,  5829,  5869,  5868,  5892,  5907,  5926,  6016,  6015,  6061,
    6106,  6107,  6111,  6112,  6113,  6114,  6118,  6119,  6120,  6121,
    6123,  6124,  6132,  6145,  6162,  6200,  6199,  6250,  6326,  6325,
    6368,  6368,  6390,  6390,  6413,  6413,  6442,  6443,  6447,  6448,
    6449,  6450,  6454,  6454,  6472,  6472,  6490,  6490,  6517,  6569,
    6584,  6588,  6589,  6593,  6607,  6611,  6635,  6636,  6637,  6644,
    6645,  6646,  6647,  6648,  6649,  6650,  6656,  6660,  6676,  6694,
    6695,  6696,  6697,  6698,  6699,  6706,  6705,  6753,  6764,  6779,
    6780,  6781,  6782,  6783,  6784,  6785,  6786,  6787,  6791,  6792,
    6793,  6794,  6795,  6796,  6802,  6820,  6842,  6904,  6905,  6915,
    6914,  6958,  6967,  6968,  6974,  6975,  6979,  6998,  7009,  7030,
    7043,  7047,  7048,  7049,  7065,  7083,  7109,  7128,  7129,  7133,
    7149,  7153,  7154,  7155,  7156,  7160,  7161,  7162,  7168,  7169,
    7173,  7174,  7178,  7179,  7185,  7186,  7190,  7205,  7210,  7217,
    7218,  7219,  7220,  7221,  7222,  7223,  7227,  7228,  7232,  7233,
    7249,  7263,  7267,  7268,  7269,  7270,  7279,  7280,  7281,  7282,
    7283,  7284,  7285,  7286,  7287,  7288,  7289,  7290,  7291,  7292,
    7321,  7323,  7324,  7325,  7326,  7327,  7331,  7332,  7338,  7339,
    7344,  7343,  7368,  7375,  7376,  7384,  7385,  7389,  7403,  7407,
    7408,  7409,  7410,  7411,  7412,  7413,  7414,  7415,  7446,  7453,
    7454,  7462,  7463,  7467,  7468,  7472,  7473,  7477,  7478,  7483,
    7482,  7498,  7499,  7503,  7504,  7508,  7512,  7519,  7520,  7524,
    7525,  7529,  7530,  7534,  7535,  7536,  7537,  7538,  7539,  7546,
    7547,  7552,  7551,  7564,  7565,  7576,  7577,  7585,  7586,  7587,
    7593,  7608,  7632,  7636,  7642,  7648,  7656,  7657,  7664,  7686,
    7704,  7716,  7717,  7724,  7751,  7755,  7762,  7763,  7764,  7765,
    7766,  7767,  7773,  7774,  7778,  7792,  7793,  7797,  7812,  7829,
    7830,  7839,  7840,  7841,  7848,  7859,  7863,  7874,  7883,  7903,
    7904,  7908,  7924,  7928,  7929,  7930,  7934,  7935,  7936,  7937,
    7938,  7939,  7940,  7941,  7942,  7943,  7944,  7945,  7946,  7947,
    7951,  7952,  7953,  7957,  7958,  7959,  7960,  7961,  7962,  7963,
    7964,  7965,  7969,  7970,  7971,  7972,  7973,  7974,  7975,  7976,
    7978,  7979,  7980,  7981,  7982,  7983,  7984,  7985,  7986,  7990,
    7991,  7992,  8003,  8023,  8024,  8028,  8029,  8030,  8031,  8032,
    8033,  8034,  8038,  8039,  8043,  8044,  8045,  8046,  8047,  8048,
    8049,  8050,  8051,  8061,  8080,  8106,  8119,  8139,  8144,  8153,
    8162,  8203,  8226,  8231,  8248,  8270,  8290,  8291,  8295,  8311,
    8315,  8319,  8320,  8321,  8322,  8323,  8324,  8328,  8340,  8355,
    8356,  8357,  8358,  8359,  8371,  8372,  8373,  8374,  8378,  8379,
    8380,  8381,  8382,  8383,  8384,  8385,  8389,  8393,  8397,  8401,
    8408,  8409,  8410,  8414,  8428,  8446,  8455,  8456,  8463,  8464,
    8468,  8485,  8506,  8507,  8514,  8532,  8547,  8548,  8552,  8568,
    8572,  8573,  8581,  8582,  8590,  8591,  8599,  8600,  8604,  8605,
    8613,  8614,  8618,  8619,  8623,  8637,  8638,  8646,  8651,  8655,
    8656,  8660,  8662,  8671,  8696,  8718,  8732,  8751,  8752,  8766,
    8767,  8775,  8776,  8780,  8799,  8835,  8836,  8844,  8845,  8849,
    8864,  8880,  8896,  8912,  8931,  8954,  8962,  8963,  8970,  8971,
    8978,  8998,  9005,  9006,  9007,  9008,  9015,  9016,  9017,  9021,
    9022,  9029,  9030,  9037,  9038,  9039,  9043,  9044,  9048,  9049,
    9056,  9057,  9064,  9065,  9072,  9073,  9080,  9081,  9088,  9089,
    9096,  9097,  9098,  9099,  9100,  9101,  9102,  9103,  9104,  9105,
    9106,  9107,  9108,  9109,  9110,  9111,  9112,  9113,  9114,  9115,
    9116,  9117,  9118,  9119,  9120,  9121,  9122,  9123,  9124,  9125,
    9126,  9127,  9128,  9129,  9130,  9131,  9132,  9133,  9134,  9135,
    9136,  9137,  9138,  9139,  9140,  9141,  9142,  9143,  9147,  9148,
    9155,  9156,  9163,  9164,  9171,  9172,  9180,  9195,  9196,  9203,
    9204,  9211,  9212,  9216,  9231,  9232,  9236,  9237,  9244,  9245,
    9249,  9250,  9257,  9258,  9265,  9266,  9273,  9274,  9281,  9282,
    9289,  9290,  9297,  9298,  9299,  9303,  9304,  9311,  9312,  9316,
    9317,  9324,  9347,  9358,  9362,  9363,  9367,  9368,  9375,  9376,
    9380,  9381,  9387,  9388,  9392,  9393,  9400,  9401,  9408,  9409,
    9410,  9414,  9415,  9422,  9423,  9427,  9428,  9435,  9436,  9443,
    9444,  9445,  9449,  9450,  9459,  9460,  9467,  9468,  9472,  9473,
    9477,  9478,  9482,  9483,  9491,  9492,  9500,  9501,  9508,  9509,
    9513,  9514,  9521,  9522,  9526,  9527,  9531,  9547,  9548,  9555,
    9556,  9560,  9561,  9568,  9569,  9573,  9574,  9581,  9582
};
#endif

/** Accessing symbol of state STATE.  */
#define YY_ACCESSING_SYMBOL(State) YY_CAST (yysymbol_kind_t, yystos[State])

#if YYDEBUG || 0
/* The user-facing name of the symbol whose (internal) number is
   YYSYMBOL.  No bounds checking.  */
static const char *yysymbol_name (yysymbol_kind_t yysymbol) YY_ATTRIBUTE_UNUSED;

/* YYTNAME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals.  */
static const char *const yytname[] =
{
  "\"end of file\"", "error", "\"invalid token\"", "Y_cast", "Y_constant",
  "Y_declare", "Y_define", "Y_dynamic", "Y_explain", "Y_no", "Y_quit",
  "Y_reinterpret", "Y_set", "Y_show", "Y_aligned", "Y_all", "Y_array",
  "Y_as", "Y_binding", "Y_bit", "Y_bit_precise", "Y_bits", "Y_by",
  "Y_bytes", "Y_capturing", "Y_commands", "Y_constructor", "Y_conversion",
  "Y_copy", "Y_defined", "Y_destructor", "Y_english", "Y_evaluation",
  "Y_expand", "Y_expression", "Y_floating", "Y_function",
  "Y_initialization", "Y_into", "Y_lambda", "Y_length", "Y_linkage",
  "Y_literal", "Y_macros", "Y_member", "Y_non_empty", "Y_non_member",
  "Y_of", "Y_options", "Y_point", "Y_pointer", "Y_precise", "Y_precision",
  "Y_predefined", "Y_pure", "Y_reference", "Y_returning", "Y_rvalue",
  "Y_scope", "Y_structured", "Y_to", "Y_user", "Y_user_defined",
  "Y_variable", "Y_wide", "Y_width",
  "Y_PREC_LESS_THAN_upc_layout_qualifier", "Y_COLON_COLON", "\"::\"",
  "Y_COLON_COLON_STAR", "\"++\"", "\"--\"", "'('", "')'", "'['", "']'",
  "'.'", "Y_MINUS_GREATER", "\"->\"", "'&'", "'*'", "'!'", "Y_sizeof",
  "'~'", "Y_DOT_STAR", "\".*\"", "Y_MINUS_GREATER_STAR", "\"->*\"", "'/'",
  "'%'", "'-'", "'+'", "Y_LESS_LESS", "\"<<\"", "Y_GREATER_GREATER",
  "\">>\"", "Y_LESS_EQUAL_GREATER", "\"<=>\"", "'<'", "'>'",
  "Y_LESS_EQUAL", "\"<=\"", "Y_GREATER_EQUAL", "\">=\"", "Y_EQUAL_EQUAL",
  "\"==\"", "Y_EXCLAM_EQUAL", "Y_bit_and", "'^'", "'|'", "Y_AMPER_AMPER",
  "Y_PIPE_PIPE", "Y_QMARK_COLON", "\"?:\"", "'='", "Y_PERCENT_EQUAL",
  "\"%=\"", "Y_AMPER_EQUAL", "Y_STAR_EQUAL", "\"*=\"", "Y_PLUS_EQUAL",
  "\"+=\"", "Y_MINUS_EQUAL", "\"-=\"", "Y_SLASH_EQUAL", "\"/=\"",
  "Y_LESS_LESS_EQUAL", "\"<<=\"", "Y_GREATER_GREATER_EQUAL", "\">>=\"",
  "Y_CARET_EQUAL", "Y_PIPE_EQUAL", "','", "Y_auto_STORAGE", "Y_break",
  "Y_case", "Y_char", "Y_continue", "Y_default", "Y_do", "Y_double",
  "Y_else", "Y_extern", "Y_float", "Y_for", "Y_goto", "Y_if", "Y_int",
  "Y_long", "Y_register", "Y_return", "Y_short", "Y_static", "Y_struct",
  "Y_switch", "Y_typedef", "Y_union", "Y_unsigned", "Y_while", "'#'",
  "\"##\"", "Y_PRE_SPACE", "Y_PRE_define", "Y_PRE_elif", "Y_PRE_else",
  "Y_PRE_error", "Y_PRE_if", "Y_PRE_ifdef", "Y_PRE_ifndef", "Y_PRE_line",
  "Y_PRE_undef", "Y_PRE___VA_ARGS__", "Y_PRE___VA_OPT__", "Y_PRE_pragma",
  "Y_PRE_elifdef", "Y_PRE_elifndef", "Y_PRE_embed", "Y_PRE_warning",
  "Y_asm", "Y_const", "\"...\"", "Y_enum", "Y_signed", "Y_void",
  "Y_volatile", "Y_wchar_t", "Y__Bool", "Y__Complex", "Y__Imaginary",
  "Y_inline", "Y_restrict", "Y__Alignas", "Y__Alignof", "Y__Atomic_QUAL",
  "Y__Atomic_SPEC", "Y__Generic", "Y__Noreturn", "Y__Static_assert",
  "Y__Thread_local", "Y_thread", "Y_local", "Y_bool", "Y_catch", "Y_class",
  "Y_const_cast", "Y_CONSTRUCTOR_SNAME", "Y_delete", "Y_DESTRUCTOR_SNAME",
  "Y_dynamic_cast", "Y_explicit", "Y_false", "Y_friend", "Y_mutable",
  "Y_namespace", "Y_new", "Y_operator", "Y_OPERATOR_SNAME", "Y_private",
  "Y_protected", "Y_public", "Y_reinterpret_cast", "Y_static_cast",
  "Y_template", "Y_this", "Y_throw", "Y_true", "Y_try", "Y_typeid",
  "Y_typename", "Y_using", "Y_virtual", "Y_char16_t", "Y_char32_t",
  "Y__BitInt", "Y_reproducible", "Y_typeof", "Y_typeof_unqual",
  "Y_unsequenced", "Y_ATTR_BEGIN", "Y_auto_TYPE", "Y_alignas", "Y_alignof",
  "Y_carries", "Y_dependency", "Y_carries_dependency", "Y_constexpr",
  "Y_decltype", "Y_except", "Y_final", "Y_noexcept", "Y_nullptr",
  "Y_override", "Y_static_assert", "Y_thread_local", "Y_deprecated",
  "Y_auto_STRUCTURED_BINDING", "Y_discard", "Y_maybe_unused", "Y_maybe",
  "Y_unused", "Y_nodiscard", "Y_noreturn", "Y_char8_t", "Y_concept",
  "Y_consteval", "Y_constinit", "Y_co_await", "Y_co_return", "Y_co_yield",
  "Y_export", "Y_no_unique_address", "Y_parameter", "Y_pack", "Y_requires",
  "Y_unique", "Y_address", "Y_EMC__Accum", "Y_EMC__Fract", "Y_EMC__Sat",
  "Y_UPC_relaxed", "Y_UPC_shared", "Y_UPC_strict", "Y_GNU___attribute__",
  "Y_GNU___restrict", "Y_Apple___block", "Y_Apple_block", "Y_MSC___cdecl",
  "Y_MSC___clrcall", "Y_MSC___declspec", "Y_MSC___fastcall",
  "Y_MSC___stdcall", "Y_MSC___thiscall", "Y_MSC___vectorcall", "':'",
  "';'", "'{'", "'}'", "Y_CHAR_LIT", "Y_CONCEPT_SNAME", "Y_END", "Y_ERROR",
  "Y_FLOAT_LIT", "Y_GLOB", "Y_INT_LIT", "Y_NAME", "Y_SET_OPTION",
  "Y_STR_LIT", "Y_TYPEDEF_NAME_TDEF", "Y_TYPEDEF_SNAME_TDEF",
  "Y_LEXER_ERROR", "'$'", "'@'", "'`'", "'?'", "$accept", "command_list",
  "command", "cast_command", "new_style_cast_english", "declare_command",
  "$@1", "alignas_or_width_decl_english_ast", "alignas_specifier_english",
  "aligned_english", "capturing_paren_capture_decl_list_english_opt",
  "paren_capture_decl_list_english", "capture_decl_list_english_opt",
  "capture_decl_list_english", "capture_decl_english_ast",
  "capture_default_opt", "width_specifier_english_uint",
  "storage_class_subset_english_type_opt",
  "storage_class_subset_english_type", "storage_class_subset_english_stid",
  "define_command", "expand_command", "expand_command2",
  "p_extra_token_except_lparen", "p_extra_tokens_opt", "p_extra_tokens",
  "p_extra_token", "p_arg_list_opt", "p_comma_arg_list", "p_arg_list",
  "p_arg_tokens", "p_arg_token_as_list", "p_arg_token", "p_num_lit",
  "p_other", "p_punctuator", "p_arg_tokens_with_comma_opt",
  "p_arg_tokens_with_comma", "p_arg_token_with_comma_as_list",
  "p_arg_token_with_comma", "explain_command", "$@2", "explain",
  "help_command", "$@3", "help_what_opt", "preprocessor_command",
  "p_define", "p_paren_param_list_opt", "p_param_list_opt", "p_param_list",
  "p_param", "p_replace_list_opt", "p_replace_list", "p_replace_token",
  "p_undef", "quit_command", "scoped_command", "set_command",
  "set_option_list", "set_option", "set_option_value_opt", "show_command",
  "show_format", "show_format_exp", "show_format_opt", "show_types_opt",
  "predefined_or_user_types_opt", "template_command", "typedef_command",
  "using_command", "c_style_cast_expr_c", "$@4", "new_style_cast_expr_c",
  "$@5", "new_style_cast_c", "aligned_declaration_c", "$@6", "$@7",
  "alignas_specifier_c", "$@8", "alignas", "asm_declaration_c",
  "scoped_declaration_c", "class_struct_union_declaration_c", "$@9",
  "$@10", "enum_declaration_c", "$@11", "namespace_declaration_c", "$@12",
  "$@13", "namespace_sname_c_exp", "namespace_sname_c",
  "namespace_typedef_sname_c", "brace_in_scope_declaration_c_exp",
  "brace_in_scope_declaration_c_opt", "brace_in_scope_declaration_c",
  "in_scope_declaration_c_exp", "lambda_declaration_c",
  "capture_decl_list_c_opt", "capture_decl_list_c", "capture_decl_c_ast",
  "lambda_return_type_c_ast_opt", "$@14", "template_declaration_c",
  "typed_declaration_c", "$@15", "typedef_declaration_c", "$@16", "$@17",
  "typedef_decl_list_c", "typedef_decl_c", "typedef_decl_c_exp",
  "user_defined_conversion_declaration_c", "using_declaration_c",
  "using_decl_c_ast", "$@18", "$@19", "decl_list_c_opt", "decl_list_c",
  "decl_c", "decl_c_exp", "decl_c_astp", "msc_calling_convention_c_astp",
  "decl2_c_astp", "param_pack_decl_c_ast", "array_decl_c_astp",
  "array_size_c_ast", "block_decl_c_astp", "$@20",
  "destructor_declaration_c", "no_destructor_params",
  "file_scope_constructor_declaration_c",
  "file_scope_destructor_declaration_c", "func_decl_c_astp",
  "pc99_func_or_constructor_declaration_c", "$@21",
  "param_list_rparen_func_qualifier_list_c_stid_opt", "$@22",
  "func_qualifier_list_c_stid_opt", "func_qualifier_c_stid",
  "noexcept_c_stid_opt", "noexcept_bool_stid_exp",
  "trailing_return_type_c_ast_opt", "$@23", "func_equals_c_stid_opt",
  "delete_reason_opt", "param_c_ast_list_exp", "param_c_ast_list_opt",
  "param_c_ast_list", "param_c_ast", "$@24", "param_c_ast_exp",
  "paren_param_c_ast_list_opt", "param_list_c_lparen", "param_list_rparen",
  "nested_decl_c_astp", "$@25", "oper_decl_c_astp", "pointer_decl_c_astp",
  "$@26", "pointer_type_c_ast", "pc99_pointer_decl_list_c",
  "pc99_pointer_decl_c", "$@27", "pc99_pointer_type_c_ast",
  "pointer_to_member_decl_c_astp", "$@28", "pointer_to_member_type_c_ast",
  "reference_decl_c_astp", "$@29", "reference_type_c_ast",
  "typedef_type_decl_c_ast", "user_defined_conversion_decl_c_astp", "$@30",
  "user_defined_literal_decl_c_astp", "cast_c_astp_opt", "cast_c_astp",
  "cast2_c_astp", "param_pack_cast_c_ast", "array_cast_c_astp",
  "block_cast_c_astp", "$@31", "func_cast_c_astp", "nested_cast_c_astp",
  "$@32", "pointer_cast_c_astp", "$@33", "pointer_to_member_cast_c_astp",
  "$@34", "reference_cast_c_astp", "$@35", "udc_decl_c_ast_opt",
  "udc_decl_c_ast", "pointer_udc_decl_c_ast", "$@36",
  "pointer_to_member_udc_decl_c_ast", "$@37", "reference_udc_decl_c_ast",
  "$@38", "type_c_ast", "type_modifier_list_c_type_opt",
  "type_modifier_list_c_type", "type_modifier_c_type",
  "type_modifier_base_type", "east_modified_type_c_ast",
  "east_modifiable_type_c_ast", "atomic_specifier_type_c_ast", "$@39",
  "builtin_type_c_ast", "builtin_no_BitInt_c_btid", "concept_type_c_ast",
  "structured_binding_type_c_ast", "typedef_type_c_ast",
  "sub_scope_sname_c_opt", "typeof_type_c_ast", "$@40", "typeof",
  "enum_class_struct_union_c_ast", "class_struct_union_c_ast",
  "enum_c_ast", "enum_btids", "enum_fixed_type_c_ast_opt",
  "enum_fixed_type_c_ast", "enum_fixed_type_modifier_list_btid_opt",
  "enum_fixed_type_modifier_list_btid", "enum_fixed_type_modifier_btid",
  "enum_unmodified_fixed_type_c_ast", "class_struct_btid_opt",
  "class_struct_btid", "class_struct_union_btid",
  "type_qualifier_list_c_stid_opt", "type_qualifier_list_c_stid",
  "type_qualifier_c_stid", "cv_qualifier_stid",
  "cv_qualifier_list_stid_opt", "restrict_qualifier_c_stid",
  "upc_layout_qualifier_c", "storage_class_c_type", "_Noreturn_atid",
  "attribute_specifier_list_c_atid_opt", "attribute_specifier_list_c_atid",
  "$@41", "using_opt", "attribute_list_c_atid_opt",
  "attribute_list_c_atid", "attribute_c_atid_exp",
  "attribute_str_arg_c_opt", "gnu_or_msc_attribute_specifier_list_c_opt",
  "gnu_or_msc_attribute_specifier_list_c",
  "gnu_attribute_specifier_list_c_opt", "gnu_attribute_specifier_list_c",
  "gnu_attribute_specifier_c", "$@42", "gnu_attribute_list_c_opt",
  "gnu_attribuet_list_c", "gnu_attribute_c_exp",
  "gnu_attribute_decl_arg_list_c_opt", "gnu_attribute_arg_list_c_opt",
  "gnu_attribute_arg_list_c", "gnu_attribute_arg_c",
  "msc_attribute_specifier_list_c", "msc_attribute_specifier_c", "$@43",
  "msc_attribute_list_c_opt", "msc_attribuet_list_c", "decl_english_ast",
  "array_decl_english_ast", "array_size_decl_ast", "length_opt",
  "block_decl_english_ast", "constructor_decl_english_ast",
  "destructor_decl_english_ast", "destructor_parens_opt",
  "func_decl_english_ast", "func_qualifier_english_type_opt",
  "msc_calling_convention_atid", "paren_param_decl_list_english_opt",
  "paren_param_decl_list_english", "param_decl_list_english_opt",
  "param_decl_list_english", "decl_english_ast_exp",
  "ref_qualifier_english_stid_opt", "returning_english_ast_opt",
  "returning_english_ast", "qualified_decl_english_ast",
  "type_qualifier_list_english_type_opt",
  "type_qualifier_list_english_type", "type_qualifier_english_type",
  "attribute_english_atid", "storage_class_english_stid",
  "eval_expr_init_stid", "linkage_stid", "linkage_opt",
  "type_qualifier_english_stid", "upc_layout_qualifier_english",
  "qualifiable_decl_english_ast", "pointer_decl_english_ast",
  "reference_decl_english_ast", "reference_english_ast",
  "structured_binding_decl_english_ast",
  "user_defined_literal_decl_english_ast", "var_decl_english_ast",
  "type_english_ast", "type_modifier_list_english_type_opt",
  "type_modifier_list_english_type", "type_modifier_english_type",
  "unmodified_type_english_ast", "builtin_type_english_ast",
  "builtin_no_BitInt_english_btid", "BitInt_english_int", "BitInt_english",
  "concept_type_english_ast", "parameter_pack_english_ast", "pack_exp",
  "precise_opt", "class_struct_union_english_ast", "enum_english_ast",
  "of_type_enum_fixed_type_english_ast_opt", "enum_fixed_type_english_ast",
  "enum_fixed_type_modifier_list_english_btid_opt",
  "enum_fixed_type_modifier_list_english_btid",
  "enum_unmodified_fixed_type_english_ast", "any_name", "any_name_exp",
  "any_sname_c", "any_sname_c_exp", "any_sname_c_opt", "any_typedef_tdef",
  "name_ast", "name_exp", "name_cat", "name_opt", "oper_sname_c_opt",
  "sname_c", "sname_c_ast", "bit_field_c_uint_opt", "sname_c_exp",
  "sname_c_opt", "sname_english", "sname_english_ast", "sname_english_exp",
  "sname_english_opt", "sname_list_c", "sname_list_english",
  "typedef_sname_c", "address_exp", "array_exp", "as_exp",
  "as_into_to_exp", "as_or_to_opt", "auto_TYPE_exp", "binding_exp",
  "bits_opt", "bytes_opt", "cast_exp", "char_exp",
  "class_struct_union_btid_exp", "colon_exp", "comma_exp",
  "conversion_exp", "c_operator", "default_exp", "defined_exp",
  "dependency_exp", "destructor_sname", "empty_str_lit_exp", "equals_exp",
  "extern_linkage_c_stid", "extern_linkage_c_stid_opt", "glob", "glob_opt",
  "gt_exp", "inline_stid_opt", "int_exp", "lbracket_exp", "literal_exp",
  "local_exp", "lparen_exp", "lt_exp", "member_or_non_member_opt",
  "namespace_btid_exp", "namespace_type", "of_exp", "of_scope_english",
  "of_scope_list_english", "of_scope_list_english_opt", "operator_exp",
  "operator_opt", "point_exp", "precision_opt", "rbrace_exp",
  "rbracket_exp", "ref_qualifier_c_stid_opt", "reference_exp", "returning",
  "returning_exp", "rparen_exp", "scope_english_type",
  "scope_english_type_exp", "semi_exp", "semi_opt", "semi_or_end",
  "static_stid_opt", "str_lit", "str_lit_exp", "this_exp", "this_stid_opt",
  "to_exp", "type_opt", "typename_flag_opt", "uint_lit", "uint_lit_exp",
  "uint_lit_opt", "unused_exp", "user_defined", "virtual_stid_exp",
  "virtual_stid_opt", YY_NULLPTR
};

static const char *
yysymbol_name (yysymbol_kind_t yysymbol)
{
  return yytname[yysymbol];
}
#endif

#define YYPACT_NINF (-1162)

#define yypact_value_is_default(Yyn) \
  ((Yyn) == YYPACT_NINF)

#define YYTABLE_NINF (-1129)

#define yytable_value_is_error(Yyn) \
  0

/* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
   STATE-NUM.  */
static const yytype_int16 yypact[] =
{
   -1162,  1189, -1162, -1162,   366,  3229,    50,   188, -1162, -1162,
     188,   -94,   793,    75,   188, -1162,   -95, -1162,  1160,   188,
      -2,   184, -1162, -1162, -1162, -1162, -1162, -1162, -1162, -1162,
   -1162, -1162, -1162, -1162,   293,    50,   293,   293,   293,   293,
    1772,   293,   -68,   293, -1162,   293,   293,   293,   293,   293,
   -1162, -1162, -1162, -1162, -1162, -1162, -1162, -1162, -1162, -1162,
   -1162, -1162, -1162, -1162, -1162, -1162, -1162,   249, -1162,   237,
   -1162,   135,   377, -1162, -1162, -1162, -1162,   123,   128, -1162,
   -1162, -1162, -1162, -1162, -1162, -1162, -1162, -1162, -1162, -1162,
   -1162, -1162, -1162, -1162, -1162, -1162, -1162, -1162, -1162, -1162,
   -1162, -1162, -1162, -1162, -1162, -1162, -1162, -1162, -1162, -1162,
   -1162, -1162, -1162, -1162, -1162, -1162, -1162,   399,   454, -1162,
    4761, -1162,   137, -1162, -1162, -1162,   509, -1162, -1162, -1162,
   -1162,   356,   -94, -1162, -1162,   560, -1162, -1162, -1162,    28,
     461, -1162,  5244, -1162, -1162, -1162, -1162,    80, -1162, -1162,
   -1162, -1162, -1162, -1162, -1162,    80, -1162, -1162, -1162, -1162,
   -1162, -1162, -1162, -1162, -1162, -1162, -1162, -1162, -1162,    60,
     106, -1162,   135, -1162, -1162, -1162, -1162, -1162,  5879,   515,
     683, -1162, -1162, -1162,   -12, -1162, -1162, -1162, -1162, -1162,
   -1162, -1162, -1162,   182, -1162, -1162, -1162, -1162, -1162, -1162,
   -1162, -1162,   -36, -1162, -1162, -1162,   182, -1162, -1162, -1162,
   -1162, -1162, -1162,   503, -1162,   490, -1162, -1162,   182, -1162,
   -1162,   541, -1162, -1162, -1162, -1162, -1162, -1162, -1162, -1162,
   -1162, -1162, -1162, -1162, -1162, -1162, -1162, -1162, -1162,   549,
   -1162, -1162, -1162, -1162, -1162,   107,   519, -1162, -1162,   129,
   -1162, -1162,   182, -1162, -1162, -1162, -1162, -1162, -1162, -1162,
   -1162, -1162, -1162,   501, -1162, -1162, -1162,  6042, -1162, -1162,
   -1162,  6252, -1162, -1162, -1162, -1162, -1162, -1162, -1162,   182,
   -1162, -1162, -1162,   453,   453, -1162, -1162, -1162, -1162, -1162,
   -1162, -1162,   411, -1162,   441, -1162,   673,   536,   237,   534,
     562,   -23,   716, -1162, -1162, -1162, -1162, -1162, -1162, -1162,
   -1162,    94,    94,   134,   726, -1162,   249, -1162,   400, -1162,
   -1162, -1162, -1162,  4343,   366, -1162, -1162, -1162, -1162, -1162,
   -1162,   128,   128,   807,   527,   463, -1162,    91,   -12, -1162,
   -1162, -1162, -1162, -1162,   122, -1162, -1162, -1162, -1162, -1162,
   -1162, -1162, -1162, -1162,    86, -1162, -1162, -1162, -1162, -1162,
   -1162, -1162, -1162,    88, -1162, -1162, -1162, -1162, -1162, -1162,
   -1162, -1162, -1162,    98, -1162, -1162, -1162,    50,  4343,   249,
    4343,    61, -1162, -1162, -1162, -1162, -1162, -1162, -1162, -1162,
     483,   111, -1162, -1162, -1162, -1162, -1162, -1162, -1162, -1162,
    1420, -1162, -1162, -1162, -1162, -1162, -1162, -1162, -1162, -1162,
   -1162, -1162, -1162, -1162, -1162, -1162, -1162, -1162, -1162, -1162,
   -1162, -1162, -1162, -1162, -1162, -1162, -1162, -1162, -1162, -1162,
   -1162, -1162, -1162, -1162, -1162, -1162, -1162, -1162, -1162, -1162,
   -1162, -1162, -1162, -1162, -1162, -1162, -1162, -1162, -1162, -1162,
   -1162, -1162, -1162, -1162, -1162, -1162, -1162, -1162,  5383, -1162,
   -1162, -1162, -1162, -1162,  6042, -1162, -1162,   739, -1162, -1162,
   -1162, -1162, -1162,   453, -1162,    81, -1162, -1162,   516,  4343,
   -1162, -1162,   123, -1162, -1162,   526,   120, -1162, -1162, -1162,
     773,   124, -1162, -1162,   928,   323,   928, -1162, -1162,   558,
   -1162, -1162, -1162,    54,  6042, -1162,  6042,    83, -1162,   420,
     101, -1162,   182,   182, -1162, -1162, -1162, -1162, -1162, -1162,
   -1162,  6042,   -95,  3864,  1297,  1297,  2153, -1162, -1162, -1162,
    6252,  4033,   517,    87, -1162,    87, -1162, -1162,   366, -1162,
    6042, -1162,   182, -1162, -1162,   182,    60, -1162, -1162,   564,
   -1162, -1162, -1162, -1162,   788,   796, -1162, -1162, -1162, -1162,
   -1162, -1162,    94, -1162, -1162, -1162,   807,   532, -1162,    91,
     148, -1162, -1162, -1162,   -12, -1162, -1162, -1162, -1162, -1162,
   -1162,   122, -1162, -1162, -1162, -1162, -1162, -1162, -1162, -1162,
   -1162, -1162, -1162, -1162, -1162, -1162, -1162, -1162,    30, -1162,
   -1162,   667, -1162, -1162, -1162, -1162,  5011,  4641, -1162, -1162,
   -1162, -1162, -1162, -1162,   480, -1162,   136, -1162, -1162, -1162,
   -1162, -1162, -1162, -1162, -1162, -1162, -1162, -1162,    63,   138,
     682,   799, -1162, -1162, -1162,   819, -1162, -1162, -1162, -1162,
   -1162, -1162, -1162, -1162, -1162, -1162,   187, -1162, -1162,   457,
     509, -1162, -1162, -1162,   111, -1162, -1162, -1162, -1162, -1162,
    5494, -1162,   792,  5633,   742,  5744, -1162, -1162, -1162, -1162,
   -1162,  5383, -1162, -1162,    92,  5133,   171, -1162, -1162, -1162,
   -1162, -1162,   518, -1162, -1162, -1162, -1162,   519, -1162, -1162,
     515,   323, -1162, -1162, -1162, -1162, -1162, -1162,   123, -1162,
   -1162, -1162, -1162, -1162,   123,   639, -1162, -1162,   139,   805,
   -1162,   128,   128,   182,    58,   310, -1162, -1162,   808, -1162,
     592,   123,   777, -1162,   683, -1162,   104, -1162, -1162, -1162,
   -1162, -1162, -1162,   755, -1162, -1162,   645, -1162, -1162, -1162,
   -1162, -1162, -1162, -1162, -1162, -1162, -1162, -1162,   683, -1162,
   -1162, -1162,   596,   440,   824,   700,   675,    46,   411, -1162,
   -1162,   755, -1162, -1162,   602,   564,   603, -1162,   604, -1162,
   -1162,   310,   551,   182,   992, -1162,   605,    55,   417,   474,
   -1162, -1162, -1162, -1162, -1162, -1162, -1162,   819, -1162, -1162,
   -1162, -1162, -1162,   143,   799,   830,   465,   507,   125,   299,
     863,   799, -1162, -1162, -1162, -1162, -1162, -1162,   743, -1162,
   -1162, -1162, -1162, -1162,   465, -1162, -1162,  4496,  4377, -1162,
   -1162,  4343, -1162, -1162,   182, -1162, -1162, -1162, -1162,   682,
     682, -1162,   145,   142,   833,   119, -1162, -1162,  4187,    66,
   -1162, -1162, -1162, -1162, -1162,   697,   591,    83, -1162, -1162,
   -1162,  2058, -1162,  4641, -1162,  5494,   840,  5494, -1162, -1162,
    5383, -1162,   742,  5633, -1162, -1162,  1297, -1162, -1162, -1162,
     843,   144, -1162, -1162, -1162, -1162, -1162, -1162, -1162, -1162,
   -1162,  5133, -1162, -1162, -1162,  6042,   811,   616, -1162, -1162,
   -1162,   579, -1162,   519, -1162, -1162, -1162, -1162, -1162, -1162,
   -1162, -1162, -1162, -1162,   310, -1162, -1162, -1162,   518, -1162,
      80,   223, -1162, -1162,   616, -1162, -1162, -1162,    68, -1162,
     849, -1162,   851,    73, -1162, -1162, -1162,   853,   155, -1162,
   -1162,  6042,   518,  6042, -1162,   518, -1162, -1162, -1162,  1297,
   -1162, -1162,    19, -1162,   126,  1168,   411,   310,  1297,  1297,
   -1162,    83, -1162, -1162,   645,   723, -1162,   854,  1555, -1162,
   -1162,   411,   518, -1162, -1162, -1162,   154,   853, -1162,   853,
     551, -1162, -1162, -1162, -1162, -1162, -1162, -1162, -1162, -1162,
    6191, -1162,   713,   539, -1162, -1162, -1162, -1162, -1162,    80,
   -1162, -1162,    80, -1162, -1162, -1162, -1162, -1162,   146, -1162,
   -1162,   551, -1162, -1162, -1162,  2351, -1162, -1162,   552, -1162,
   -1162, -1162, -1162,   686,    66, -1162, -1162,   899,  4343,   886,
     127,   561,   131,   635,   891, -1162, -1162, -1162, -1162, -1162,
   -1162, -1162, -1162, -1162, -1162, -1162, -1162,    50,    65, -1162,
   -1162, -1162,    94,    94, -1162, -1162, -1162, -1162,    78, -1162,
   -1162, -1162, -1162, -1162, -1162,  4187,   872,   871,   108, -1162,
   -1162,    80, -1162, -1162,   682, -1162,   874,   156, -1162, -1162,
   -1162, -1162,  2644, -1162,   249, -1162, -1162, -1162,   821, -1162,
     929,   929,   794,   880, -1162, -1162, -1162,  5633,  5744,   823,
   -1162, -1162, -1162,   110, -1162, -1162, -1162,   518, -1162,   518,
     518,   518, -1162,   616,   310,  4887,   853,   579,    59, -1162,
   -1162, -1162, -1162,   885, -1162,   885, -1162, -1162,   883,   147,
   -1162,   237,   237,   157,   887,   167, -1162,   198, -1162, -1162,
   -1162, -1162,   351, -1162,  3538, -1162,   556, -1162,   579,   683,
     123, -1162, -1162, -1162,   884,   683,   128,   888,   972, -1162,
     128, -1162,   853, -1162, -1162,  1297, -1162, -1162,   519,    80,
   -1162,   579, -1162, -1162, -1162,   182, -1162, -1162, -1162, -1162,
   -1162,   351,   351,   853, -1162,   713, -1162,   713, -1162, -1162,
   -1162,   680,    84,    84, -1162, -1162, -1162, -1162,  4343,   894,
   -1162,   146, -1162, -1162, -1162,   665, -1162,   799, -1162, -1162,
     127, -1162, -1162, -1162, -1162, -1162, -1162, -1162, -1162, -1162,
   -1162, -1162, -1162, -1162,   704, -1162, -1162, -1162,   933, -1162,
   -1162,    83,    83,   821,   909, -1162, -1162, -1162, -1162, -1162,
   -1162, -1162, -1162,  2937, -1162, -1162,   118, -1162, -1162, -1162,
   -1162, -1162, -1162, -1162,   125,   743, -1162,  1003, -1162,   518,
     683,   579,   915,   915,   915,   237, -1162,   853,  6042, -1162,
   -1162, -1162, -1162, -1162, -1162,    54, -1162, -1162,   128,   657,
     616, -1162,   123,   115,   198, -1162, -1162, -1162, -1162, -1162,
     910,   475, -1162,   182,   919,   895, -1162, -1162, -1162, -1162,
     518, -1162, -1162,   182, -1162,  1297, -1162, -1162,   343, -1162,
     128, -1162, -1162,   396, -1162,    76, -1162,   517,   310,   182,
   -1162,   154,   154,   154,   853,   411,   411,   351, -1162, -1162,
     133, -1162, -1162, -1162, -1162, -1162, -1162,   553, -1162,   146,
      66, -1162,    65,   842, -1162,   821,   123, -1162,    66, -1162,
   -1162, -1162, -1162, -1162,  4343, -1162,    96, -1162, -1162, -1162,
     915,   518, -1162,   351, -1162,   123, -1162, -1162,   237, -1162,
   -1162,   487, -1162,   198,  3369,   243,    52, -1162,   621,   915,
     116,   123,   128,   128, -1162,   128,   128,   351,   853,  3701,
   -1162, -1162, -1162,   351, -1162, -1162,   411, -1162, -1162, -1162,
   -1162, -1162,    50,  4343, -1162, -1162, -1162,   713, -1162, -1162,
   -1162, -1162, -1162, -1162,   799,   579,   173,   518, -1162,   493,
   -1162, -1162,   505, -1162, -1162, -1162, -1162,   123, -1162, -1162,
     927, -1162, -1162, -1162, -1162, -1162, -1162, -1162,   237,   123,
     182, -1162, -1162, -1162, -1162,   173,    76, -1162,   937,   510,
     895,   895,  4343, -1162, -1162, -1162,  4518,  1233,    66,   519,
    6042, -1162,   411,   915, -1162, -1162,    54, -1162, -1162,   310,
     895,   351,   351, -1162, -1162, -1162,   249, -1162, -1162, -1162,
   -1162, -1162,   310, -1162,   123,   938, -1162,   173,   173,   853,
     518, -1162,   411,   895, -1162, -1162, -1162, -1162, -1162
};

/* YYDEFACT[STATE-NUM] -- Default reduction number in state STATE-NUM.
   Performed when YYTABLE does not specify something else to do.  Zero
   means the default is an error.  */
static const yytype_int16 yydefact[] =
{
       2,     0,     1,    19,   927,     0,     0,     0,   206,   252,
       0,   254,     0,     0,     0,   601,  1114,   603,     0,     0,
     598,     0,   600,   291,   292,  1057,   293,   294,   352,   365,
    1098,  1099,   207,     3,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    12,     0,     0,     0,     0,     0,
      26,   253,   306,   307,   308,   283,   284,   285,   364,   312,
     602,   309,   314,    18,   915,   902,   903,  1064,   935,   896,
     928,     0,   897,    32,   998,   986,   990,     0,     0,   994,
     992,   979,   983,   975,  1017,   995,   993,   996,   977,   989,
     985,  1000,  1007,  1003,   999,  1006,  1002,  1009,  1005,   976,
    1012,  1014,   980,  1015,  1010,  1004,   978,   981,   984,   987,
     991,   997,  1001,  1008,  1013,  1016,   988,   973,   971,   970,
     618,   932,     0,    28,   926,   925,     0,   959,   958,    23,
      24,   259,   255,   257,   268,   280,   278,   279,   267,  1034,
     274,    93,    94,    25,  1115,   355,   229,     0,   217,   220,
     222,   223,   224,   225,   226,     0,   227,   218,   219,   221,
     228,   215,   216,    22,   580,   599,  1056,  1055,  1058,     0,
       0,     4,     0,     5,     6,     7,     8,   205,     0,   339,
     604,   626,   553,   561,   633,   560,   559,   531,   536,   532,
     641,   642,   534,     0,   616,   533,   549,   617,   558,   551,
     529,   530,   637,   620,   303,   609,     0,   646,   643,   552,
     631,   636,   638,     0,   200,   645,   555,   556,     0,   572,
     573,     0,   550,   304,   629,   557,   635,   640,   644,   618,
     647,   554,   628,   630,   632,   562,   563,   535,   612,   613,
     615,   679,   621,   627,   701,     0,   915,   188,   189,     0,
     191,   295,     0,   192,   196,   199,   190,   202,   194,   193,
     195,   197,   198,   465,   466,   363,   353,   518,   524,   525,
     520,   521,   539,   540,   547,   541,   542,   543,   544,     0,
     618,   574,   575,   648,   648,   526,   610,   611,   527,   639,
     528,   652,   673,   678,   674,   700,   567,     0,   204,   634,
       0,     0,     0,     9,    10,    11,    13,    14,    15,    16,
      17,     0,     0,     0,     0,  1063,  1065,   923,     0,   945,
     942,   943,   944,   749,     0,  1088,  1087,   982,  1077,  1076,
    1011,     0,     0,     0,     0,    42,    80,     0,    72,    82,
      88,    76,   764,    85,     0,    70,    75,    77,    83,    87,
      89,   768,   769,    64,     0,   757,    68,    74,    79,    81,
      86,   758,   760,     0,   762,   765,    67,    69,    71,   767,
      65,    61,    63,     0,    62,   941,   940,     0,   749,  1064,
     749,     0,   258,   256,   281,   282,   277,   266,  1033,  1035,
     274,     0,   269,   270,   271,   275,   262,   157,   177,   172,
       0,    98,   147,   148,   139,   170,   135,   136,   132,   153,
     158,   171,   140,   134,   138,   137,   167,   163,   166,   143,
     145,   165,   162,   160,   161,   149,   151,   154,   175,   144,
     173,   155,   179,   176,   169,   178,   168,   164,   156,   174,
     187,   133,   123,   159,   141,   142,   150,   152,   120,   127,
     128,   121,   124,   129,   130,   131,   146,    92,    99,   186,
     122,   125,   126,    97,     0,   906,   905,   231,   251,   895,
     892,   893,   894,   648,   213,     0,   908,   208,   210,   749,
     637,   645,     0,   286,   634,   343,     0,   345,   347,   346,
       0,     0,   342,   468,   605,   671,     0,  1102,  1103,  1029,
     802,  1049,  1048,     0,     0,   912,     0,     0,   650,  1078,
       0,   614,     0,     0,   950,   949,   564,   456,   413,  1051,
    1050,     0,  1114,     0,   911,   911,   368,   523,   519,   537,
     522,     0,   538,     0,   649,     0,   677,   699,     0,   566,
       0,   203,     0,  1024,  1025,     0,     0,   899,   898,   581,
     310,   319,   323,   315,   317,   318,   327,  1093,  1091,  1089,
    1090,  1092,     0,  1062,   913,   914,     0,     0,   788,     0,
       0,  1123,   770,   776,   780,   790,   796,   833,   784,   805,
     793,     0,   777,   778,   783,   785,   791,   795,   797,   774,
     782,   787,   789,   794,   773,   775,   779,   808,   809,   811,
     771,  1064,   806,   807,    20,   707,   836,   750,   752,   753,
     754,   755,   708,   709,     0,   832,     0,   934,   933,   974,
     972,   799,   800,   801,    66,   763,    78,   761,     0,     0,
      48,   732,  1126,  1125,    90,   803,  1047,  1046,    84,  1023,
    1022,   756,  1122,  1121,   759,   619,     0,   931,    27,    33,
       0,    91,   261,   260,     0,   264,   273,   272,   263,   111,
     180,   113,     0,   107,   106,   115,   117,   118,   104,   103,
      95,   100,   102,   356,     0,   240,     0,   212,   211,   907,
      21,   288,   480,   344,  1107,  1106,   348,   454,   967,   966,
       0,   671,   608,   672,   607,  1030,  1105,  1104,     0,   545,
     201,  1118,  1116,  1117,     0,   653,  1079,  1080,     0,     0,
     622,     0,     0,     0,     0,  1108,   289,   296,     0,   300,
       0,     0,   458,   474,   604,   475,     0,   726,   727,   728,
     729,   730,   731,   464,   371,   372,   375,   387,   382,   383,
     384,   385,   386,   376,   461,   377,   469,   378,   604,   389,
     390,   391,   917,   911,     0,   567,     0,   917,   675,   467,
     354,   369,   571,   569,   898,   581,     0,   576,     0,   568,
     477,  1108,     0,     0,     0,   313,   330,     0,     0,     0,
    1061,   772,   786,   798,  1021,  1020,  1124,   803,   792,   813,
     810,   812,   924,   712,   732,   721,     0,   742,     0,     0,
     716,   732,   840,   814,   815,   816,   817,   818,  1052,   725,
     724,   748,   819,   820,     0,   821,   822,     0,   837,   839,
     751,   749,  1045,  1044,     0,   937,   936,   766,    47,    48,
      48,    43,    56,    56,     0,     0,    51,    55,   749,   744,
     733,   804,    73,   969,   968,  1068,   946,     0,    40,    41,
      34,     0,    35,   749,   265,   180,     0,   181,   183,   184,
      99,   112,   108,   110,   116,   101,   911,   239,   238,   237,
       0,     0,   236,   245,   246,   247,   248,   249,   250,   244,
     230,   241,   243,  1028,  1027,     0,   498,   492,   500,   502,
     504,     0,   481,   482,   490,   486,   487,   488,   489,   483,
     484,   485,   491,    60,  1108,   341,   606,   305,   480,   548,
       0,     0,  1043,  1042,     0,   625,   624,   623,     0,   686,
     687,   706,     0,     0,   451,  1109,   904,     0,     0,   447,
     450,     0,   480,     0,   302,   480,   299,   298,   405,   911,
     463,   393,   917,   392,     0,     0,   675,  1108,   911,   911,
     472,     0,   476,   379,     0,   380,   381,     0,     0,   916,
     388,   676,   480,   578,   579,   577,   506,     0,   409,     0,
       0,   583,   591,   592,   594,   593,   595,   596,   597,   582,
     584,   590,   587,     0,   311,   331,   329,   316,   328,     0,
     320,   321,     0,   325,   324,   781,   715,   714,     0,   713,
     719,     0,   720,  1111,  1110,     0,  1082,  1081,   743,   952,
     951,   829,   717,     0,   744,  1053,  1054,     0,   749,   878,
       0,     0,     0,  1119,  1072,   861,   860,   849,   858,   851,
     852,   855,   856,   870,   850,   857,   854,     0,     0,   864,
     865,   846,     0,     0,   834,   841,   847,   848,     0,   843,
     845,   842,   844,   838,   831,   749,     0,     0,     0,    58,
      52,     0,    53,    44,     0,   738,     0,     0,  1083,  1084,
      30,   745,     0,  1069,  1064,   947,   948,    39,   953,    38,
     956,   956,   741,     0,   119,   182,    96,   109,   114,   357,
     359,   360,   232,     0,   242,   366,   495,   480,   493,   480,
     480,   480,   494,   921,  1108,   349,     0,     0,     0,   668,
     665,   666,   659,   669,   661,   669,   663,   664,     0,     0,
     658,   667,   930,     0,     0,     0,   684,   689,   685,   702,
     705,   457,   423,   415,     0,   448,     0,   297,     0,   604,
       0,   374,   373,   370,  1077,   604,     0,     0,     0,   395,
       0,   394,     0,   462,   470,   911,   918,   618,     0,     0,
    1026,     0,   512,   514,   516,     0,   507,   508,   509,   510,
     511,   423,   423,     0,   589,   587,   586,   588,   337,   332,
     334,  1096,     0,     0,   322,   326,  1060,  1059,   749,     0,
     825,     0,   823,   939,   938,   909,   718,   732,   826,   879,
       0,  1041,  1040,   871,  1071,  1070,   862,   961,   960,   859,
    1120,   853,  1073,   863,   873,   877,   876,   875,   882,   880,
     869,     0,     0,   953,     0,    46,    45,  1019,  1018,    57,
      54,    50,   734,     0,   747,   746,     0,   954,   955,    59,
     957,    37,    36,   742,     0,  1052,   185,     0,   235,   480,
     604,     0,   501,   503,   505,   922,   287,     0,     0,   338,
     455,   546,   965,   964,   654,     0,   660,   662,     0,     0,
       0,   565,     0,     0,     0,   694,   695,   693,   696,   698,
       0,     0,   692,     0,   424,   435,   417,   453,   452,   446,
     480,  1037,  1036,     0,   301,   911,   459,   404,     0,   397,
       0,  1101,   398,     0,   396,  1078,   473,   471,  1108,     0,
     570,   506,   506,   506,     0,   675,   675,   423,   585,  1097,
       0,  1095,  1094,   335,   336,   710,   722,     0,   910,     0,
     744,   872,     0,  1112,   881,   953,     0,   866,   744,   740,
     739,   737,  1086,  1085,   749,   743,     0,   362,   361,   358,
     367,   480,   499,   423,   350,     0,   651,   657,   929,   680,
     683,     0,   688,     0,     0,     0,     0,   414,   416,   449,
       0,     0,     0,     0,   401,     0,     0,   423,     0,     0,
     513,   515,   517,   423,   410,   411,   675,  1075,  1074,   333,
     963,   962,     0,   749,   723,   874,  1113,   886,   868,   867,
     830,    31,  1067,  1066,   732,     0,   431,   480,   670,   967,
     697,   691,     0,   426,   430,   428,   429,     0,   439,   436,
     440,   438,   420,   421,   422,   418,   419,   920,   919,     0,
       0,   403,   402,   400,   399,   431,  1078,   443,     0,     0,
     435,   435,   749,   711,   889,   883,     0,   887,   744,     0,
       0,   497,   434,   351,   427,   425,     0,   437,   290,  1108,
     435,   423,   423,   478,   407,   824,  1064,   890,   884,   891,
     888,    29,  1108,   432,     0,     0,   412,   431,   431,     0,
     480,   441,   675,   435,   479,   496,   433,   406,   460
};

/* YYPGOTO[NTERM-NUM].  */
static const yytype_int16 yypgoto[] =
{
   -1162, -1162, -1162, -1162, -1162, -1162, -1162, -1162, -1162, -1162,
   -1162, -1162,   -97, -1162,   -62,   179, -1162,   112, -1162, -1162,
   -1162, -1162, -1162,   875,   153, -1162,   345, -1162,  -560,   357,
    -760,  -638,  -372, -1162, -1162, -1162,   164, -1162,   166,  -191,
   -1162, -1162, -1162, -1162, -1162, -1162, -1162, -1162, -1162, -1162,
   -1162,   -69, -1162, -1162,   149, -1162, -1162, -1162, -1162, -1162,
     893, -1162, -1162,  -323,   373,   641, -1162, -1162, -1162, -1162,
   -1162, -1162, -1162, -1162, -1162,   989, -1162, -1162, -1162, -1162,
   -1162, -1162, -1162,    72, -1162, -1162, -1162, -1162, -1162, -1162,
   -1162, -1162, -1162, -1162, -1162, -1162, -1162,   260, -1162, -1162,
   -1162, -1162,  -144, -1162, -1162,  1002,  -481, -1162,    89, -1162,
   -1162, -1162,  -204, -1162, -1162,    90,   758, -1162, -1162, -1162,
     533,   117, -1162,  -467, -1162,   311, -1162, -1162,  -645, -1162,
   -1162, -1162,  -496, -1162, -1162,   314, -1162, -1162,  -892, -1162,
   -1162, -1162,  -708, -1162,  -799, -1162,  -608, -1162, -1162,  -729,
    -696,   -71, -1162, -1162, -1162,  -236, -1052, -1162, -1162, -1162,
     317, -1162,  -317,   896, -1162, -1162, -1162, -1162, -1162,  -277,
   -1162, -1162,  -263, -1162,  1031, -1162, -1162,  -862, -1162, -1162,
   -1162, -1162, -1162, -1162, -1162, -1162, -1162, -1162, -1162, -1162,
   -1162, -1162, -1162,  -498, -1162, -1162, -1162, -1162, -1162, -1162,
   -1162,  -172, -1162,   806,  -195,  -381,   812, -1162, -1162, -1162,
    -548, -1162, -1162, -1162,  -363, -1162,  -531, -1162, -1162, -1162,
   -1162, -1162,    20,   313, -1162,   -91,   306,  -962,   105, -1162,
    1061,     4,  -700,   151,  -160,  -279,  -213,  -282, -1162, -1162,
   -1162,  -178,   -42, -1162, -1162, -1162, -1162,  -181,   -24,   407,
    -147,  -927,  -675,  -281, -1162, -1162, -1162,  -866, -1162, -1162,
    -169,  -261, -1162,   814, -1162, -1162, -1162,  -300, -1162, -1162,
   -1162, -1162, -1162, -1162, -1162, -1162, -1162,   500,  -754, -1162,
      62, -1162, -1162,    27,  -969, -1162, -1162,   262, -1162,   512,
    -105, -1162,   550,  -273,   336, -1162, -1162, -1162, -1162, -1162,
   -1162, -1162, -1162, -1162, -1162, -1162, -1162,   307, -1162,  -320,
   -1162, -1162, -1162, -1162, -1162,  -205, -1162, -1162, -1162, -1162,
   -1162, -1162, -1162, -1162, -1162,   583,     3,  -278,   595,    -8,
   -1162,  -133, -1162, -1162,  1091,    -4,  -305,   381, -1162, -1162,
     753,  -310,   -32, -1162, -1162, -1162, -1162, -1162, -1162,   -87,
     965, -1162, -1162, -1162, -1057,    57,   736, -1162, -1162, -1162,
    -465, -1162,   183, -1162, -1162, -1162, -1162, -1162, -1162,  1104,
   -1162, -1162, -1162, -1162, -1162,   -55, -1162, -1162,   565,  -189,
   -1162,   -93, -1162,   834, -1077,   837, -1162,   -53, -1162, -1162,
   -1162, -1162, -1162,  -319, -1161,   -90,   -86, -1162,  -295, -1162,
   -1162,   -28, -1162,  1521, -1162,  -134,  -921, -1162, -1162,   344,
   -1162,   637,  -480,  -798, -1162, -1162,   784,   597, -1162
};

/* YYDEFGOTO[NTERM-NUM].  */
static const yytype_int16 yydefgoto[] =
{
       0,     1,    33,    34,    35,    36,   379,   648,   850,   851,
     631,   831,   834,   835,   836,  1060,   852,   120,   371,   372,
      37,    38,   457,   669,   670,   671,   672,   662,   663,   664,
     665,   666,   459,   460,   461,   462,   856,   857,   858,   463,
      39,   506,    40,    41,   170,   477,    42,   161,   675,   870,
     871,   872,   880,   881,   882,   162,    43,    44,    45,   132,
     133,   382,    46,   395,   658,   396,   139,   386,    47,    48,
      49,   247,   682,   248,   932,    50,   250,   522,   933,   251,
     935,   252,   253,    51,    52,   312,   776,    53,   311,    54,
     313,   777,   553,   554,   555,   987,   984,   985,  1181,   254,
     490,   491,   837,  1259,  1407,    55,   256,   526,    56,   464,
     866,  1089,  1090,  1349,   257,    57,    58,   169,  1249,   760,
     733,   734,  1143,   735,   953,   736,   737,   738,  1102,   739,
    1139,   258,   969,   259,   260,   740,   261,   715,  1132,  1286,
    1368,  1425,  1285,  1417,  1451,  1480,  1367,  1457,  1438,   927,
     928,   929,  1290,  1289,   903,   947,  1133,   741,   939,   742,
     743,   948,   888,   262,   263,   525,   264,   745,   949,   889,
     747,  1155,   890,   749,   750,   966,   751,   891,   892,   893,
     894,   895,   896,  1250,   897,   898,  1097,   899,  1099,   900,
    1100,   901,  1101,  1165,  1166,  1167,  1311,  1168,  1312,  1169,
    1313,   266,   529,   267,   268,   269,   270,   271,   272,   908,
     273,   274,   275,   276,   277,   539,   278,   962,   279,   280,
     281,   282,   283,   775,   979,  1176,  1177,   981,   982,   164,
      60,   284,   493,   494,   285,   286,   373,   287,   511,   288,
     289,   533,   290,   705,   911,  1118,  1119,  1120,  1266,   692,
     291,   960,   292,   293,   512,  1124,  1125,   921,  1128,  1280,
    1281,  1282,   294,   295,   513,   922,   923,  1065,   803,   998,
    1013,   804,   805,   806,  1002,   807,   808,   753,   839,   840,
    1066,  1067,  1341,   810,  1070,  1071,   605,   606,   607,   608,
     609,   610,   624,   499,   842,   611,   790,   811,   812,   813,
     814,   815,   612,   613,   816,   817,   818,   819,  1044,  1045,
    1046,  1047,  1048,  1049,  1050,  1217,  1200,  1051,  1052,  1334,
    1445,  1446,  1447,  1468,   472,   473,   754,   549,   766,    68,
     930,   467,   478,  1329,   756,   757,   902,   959,  1429,  1256,
     125,   615,   126,    71,  1123,   122,    72,   827,  1195,   378,
     323,  1077,   516,  1011,  1239,  1241,   129,  1209,  1392,  1264,
    1134,   845,   123,  1229,   786,   641,   545,  1159,   885,   484,
     300,   389,   390,  1293,   301,  1203,   914,   824,   638,   503,
     521,  1017,   168,    62,  1188,   315,   316,   792,  1404,  1074,
    1206,  1213,  1389,   330,   708,  1008,  1072,  1344,   327,   561,
     562,  1323,  1320,    63,  1303,   697,   698,   686,   931,  1005,
    1397,   145,   703,   704,  1211,   644,   616,   634,   302
};

/* YYTABLE[YYPACT[STATE-NUM]] -- What to do in state STATE-NUM.  If
   positive, shift that token.  If negative, reduce the rule whose
   number is the opposite.  If YYTABLE_NINF, syntax error.  */
static const yytype_int16 yytable[] =
{
      69,    69,    69,   172,   140,    61,   483,    67,    67,    67,
     518,   536,   619,   620,   317,   374,   509,   504,  1174,  1151,
     495,    59,   468,   604,   940,   700,   690,   864,   667,   507,
     712,    69,   296,   496,   550,   492,   298,  1160,    67,   380,
    1000,   603,   967,   721,   602,  1196,  1107,  1014,   950,  1078,
     500,   124,  1126,  1418,  1260,   696,   986,  1130,   759,   919,
    1262,   469,   652,   523,   825,   635,  1215,   532,   657,   919,
    1136,   387,   527,  1138,   919,  1171,   141,  1172,   649,  1220,
     651,   465,   677,   961,   701,  1321,   318,   639,   547,   642,
     531,   946,   632,   867,   645,   547,   603,  1402,   603,   602,
    1161,   602,   709,  1088,   863,   941,   535,   474,   514,  1227,
     789,   867,   656,   318,  1327,  -896,   919,  1427,   791,  1342,
     688,   684,  1068,   636,   325,   688,  1006,  1141,  1201,   328,
     519,  -703,  1207,   144,  1387,   551,   319,   822,   375,   828,
     912,  -681,   392,  1221,  1377,   688,  -704,  1186,   688,   784,
    1222,    15,   320,  1156,   376,   706,   688,   688,   328,   570,
     571,   752,   752,   752,  1058,  -233,  1337,  1058,   688, -1039,
     296, -1039,   883,   321,  1068,  1106,   710,   785,   823,   680,
    1007,   711,   542,   501,   543,   166,   707,   681,   843,   127,
    1419,   128,   -49,  1187,   -49,   322,   326,   603,   722,  -340,
     602,    22,  1061,   329,   500,   723,   724,   744,   744,   744,
     829,   131,   830,   913,   844,  1174,  1069,  -234,  1152,   758,
     758,   758,  -656,   996,  1109,   802,   976,   520,  -445,  -736,
     645,   304,   329,   723,   724,  1251,   725,  1252,  1253,  1254,
    -682,   534,   534,   978,  1414,  1147,  1228,   746,   746,   746,
    1450,   689,  1393,   645,   502,   765,   689,   767,  1420,   296,
    1305,   748,   748,   748,   725,   475,   393,  1208,  1069,   377,
    1274,   961,   868, -1039,  1202,  1461,   689,   194,  1398,   689,
    1059,  1317,   197,  1059,   780,   884,   544,   689,   689,  1270,
     868,   667,   673,   667,   497,   676,   314,   498,  -655,   689,
    1009,   787,  1087,   879,   318,   556,   726,    69,    69,   946,
     565,  1403,   951,   999,   548,   548,   617,  1010,   559,   614,
     618,   633,   637,   713,   714,   603,   650,  1088,   602,   640,
     388,   657,   699,   702,   691,   527,   694,  1216,   826,   951,
     394,  -911,   213,   685,  1355,   647,   515,   643,   693,   716,
     983,   719,  1263,   771,    64,   702,   772,    65,    66,   763,
     497,  1394,   920,   498,   470,  1353,   653,   471,   770,  1400,
    1064,  1081,   920,    69,   614,  1257,   614,   920,  1322,   142,
      67,   702,  -900,  -444,   466,   678,   702,  1350,  1384,  1385,
     752,    64,   916,   917,    65,    66,   869,   167,    64,  1091,
    -209,    65,    66,   907,   702,  -209,  1093,  1360,    64,   909,
     476,   977,   727,   728,   869,   729,   730,   731,   732,   920,
      64,   943,  1383,  1335,  1336,   936,   937,  1485,  1369,  1388,
      64,   534,   976,    65,    66,  1444,   744,   802,   552,  1295,
     500,    65,    66,  1330,   324,  1298,   702,   997,   758,   978,
     864,   904,  1137,  1415,  1041,   241,   296,  1110,    64,  1441,
    1111,    65,    66,  1315,  1316,  1150,  1003,  1112,  1416,   859,
     381,   846,  1140,   331,  1173,   614,   688,  1113,   391,  1471,
    1114,  1153,  1154,  1115,  1116,  1470,  1436,   629,  1409,  1405,
     924,   667,   392,  1117, -1088,  1275,   296,   821,   296,   706,
     654,  1276,  1277,   752,  1278,  1189,   688,  1279,  -827,   879,
     375,   688,   722,   296,   392,   296,   755,   755,   755,   720,
     724,  1054,   847,   296,   918,  1004,   376,    64,   332,    69,
     707,    69,   296,   925,    69,  1474,   764,   630,   764,   603,
    1178,   769,   602,  1210,   693,  1453,   905,   318,  -690,   744,
    1351,  1080,   968,  -828,  1390,  1487,   603,  1291,    69,   602,
     326,   758,  1204,   853,   495,   548, -1088,  -827,  1223,   603,
     505,   603,   602, -1128,   602,  1283,   752,   496,  1454,  1378,
     325,   752,  1098,  -442,   970,   752,   752,    30,   495,   746,
     886,   517,    31,   325,   485,   486,  1103,   723,   724,   194,
    1284,   496,  1233,   748,   197,   241,   989,   689,  1075,  1386,
    1205,   244,  -828,   384,   926,   508,   393,   977,  1486,   689,
     726,   385,   744,   510,  -408, -1088,  1149,   744,   725,   487,
     945,   744,   744,   524,   758,  1055,  1460,   689,   393,   758,
     961,   961,   689,   758,   758,  1406,   702,  1372,   848,  1162,
    1448,  1076,   326,   945,  1269,  1292,   213,  1104,  1109,   318,
    1273,  1170,   746,   992,   859,   326,   859,   746,  1412,  1435,
      64,   746,   746,    65,    66,  1440,   748,   625,  1483,  1484,
     536,   748,   625,  1439,  -915,   748,   748,  1193,  1306,  1163,
     394,   221,    15,   241,    16,    17,   194,   849,   887,   702,
    1375,   197,  1194,  1164,   564,  1192,    15,    65,    66,    17,
     832,   961,   394,  1095,   314,   667,   667,   517,  1198,   945,
      20,   990,   942,   603,    65,    66,   602,   557,    21,   244,
    1475,  1452,  1056,  1057,  -915,   241,   603,   833,   488,   602,
     538,   244,    22,  1479,    64,   296,   130,    65,    66,   942,
     143,   540,    25,  1477,  1478,   163,    22,    70,   121,  1135,
    1452,   485,   486, -1032,  1218,  1219,   296,   538,    29,  -935,
     991,   993,  1235,   603,   626,   994,   602,  1108,    64,   782,
    1091,    65,    66,   627,   558,   495,   770,  1015,   627,  1016,
     603,    29,   752,   602,   134,  -384,   487,  -384,   496,   546,
     194,   628,  1452,  1452,  1271,   197,   628,   961,   135,   296,
    -276,   674,  1261,  1380,  1381,  1382,  1363,   614,  1373,   489,
     679,  1043,    64,  1376,  -276,    65,    66,  1299,  1371,  1302,
     683,  1304,  1463,  1464,   614,  1179,  -276,  1042,   744,   621,
    1237,   622,  1238,  1294,   623,  1296,   136,   614,   687,  1243,
     758,  1244,  1476,   695,   137,   778,  1184,   774,   755,  1185,
     841,   972,   194,   779,   973,   860,  1310,   197,   910,  1422,
     974,   838,  1423,   203,   661,  1488,   205,   296,   746,    15,
     915,   934,    17,   942,   752,   938,  1421,   944,  1325,   951,
     958,  1110,   748,   957,  1111,   975,  1363,  -901,   964,   965,
     983,  1112,  1001,  1012,  1424,   488,   603,  1121,  1063,   602,
    1122,  1113,  1073,  1084,  1114,    21,  1092,  1115,  1116,  1096,
      64,  1127,  1308,   296,  1129,   296,  1131,  1117,  1230,    22,
     744,   755,   752,  1340,  1157,  1197,   755,  1199,   702,    25,
     755,   755,   758,  1212,  1307,  1225,  1226,  1232,  -276,  1356,
     296,   603,  1240,  1246,   602,  1247,  1352,  1265,  1268,  1297,
    1272,    64,   238,   239,   240,   241,   242,  1326,  1300,  1328,
     746,   244,   296,   328,  1319,  1332,  1314,  1359,   744,   495,
    1333,  1374,  1338,  1362,   748,   495,   489,    61,   691,   945,
     758,  1365,   496,   971,  1162,  1162,  1162,  1396,   496,  1456,
     374,   614,  1231,    59,  1347,  1214,  1170,  1170,  1170,  1366,
    1462,  1482,  1062,  1086,   614,  1105,   865,   458,   746,  1083,
     862,  1236,  -276,  1085,  1248,   383,  1309,   854,   645,   249,
    1094,   655,   748,    69,  1163,  1163,  1163,   988,    69,    69,
      67,  1399,   255,  1348,  1401,   548,   548,   329,  1164,  1164,
    1164,   614,  -605,  1431,  1432,  1180,  1433,  1434,   541,   761,
    1408,  1142,   603,  1288,   954,   602,  1410,   955,   614,  1413,
     956,   265,  1182,  1183,   482,   722,  1430,   530,   963,   528,
     980,   165,   723,   724,  1318,  1175,  1354,  -276,  1357,  1426,
     495,  1267,  -276,  1443,  1364,  -276,  1148,   138,   906,  1255,
      65,    66,  1411,   496,  1370,  1361,   809,   194,   537,  1245,
    1449,   603,   197,   725,   602,  1082,   781,  1224,   203,   820,
    1379,   205,  1455,   995,  1301,  1053,  1467,  1395,   182,   773,
     768,   297,   183,   952,  1458,   185,  1469,   479,  1242,   186,
     972,  1158,  1465,   973,   299,  1331,   788,   755,   560,   974,
    1343,   194,  1346,   563,  1345,  1324,   197,   646,  1018,   717,
     603,   146,   203,   602,     0,   205,   783,     0,     0,  1144,
       0,   536,     0,     0,   975,   196,     0,   198,   199,  1481,
       0,     0,     0,   726,   614,     0,     0,     0,     0,     2,
       3,     0,     4,   209,     5,     6,     7,     8,     0,     9,
      10,    11,    12,     0,     0,     0,     0,   238,   239,   240,
       0,   242,     0,  1472,     0,     0,     0,     0,  -911,   213,
       0,     0,    13,   216,   217,   218,     0,   219,   220,   614,
       0,   222,     0,     0,  -885,     0,     0,     0,   225,   755,
       0,  1459,     0,   329,     0,     0,     0,  -885,  -604,     0,
     296,   238,   239,   240,   231,   242,  -885,     0,     0,     0,
       0,     0,     0,     0,     0,  1121,  1358,     0,   235,   236,
       0,     0,     0,     0,     0, -1100, -1100,     0,  1473,     0,
       0,     0,     0,     0,     0,     0,     0,   755,     0,   727,
     728,     0,   729,   730,   731,   732,     0,     0,  -885,    65,
      66,     0,     0,     0,     0,     0,  -885,    64,     0,     0,
      65,    66,     0,     0,     0,     0,     0,     0,     0,     0,
    1145,     0,   147,   148,   149,   150,   151,   152,   153,   154,
     155,  1391,     0,   156,   157,   158,   159,   160,     0,     0,
     614,    14,    15,     0,    16,    17,     0,   194,    18,     0,
       0,     0,   197,     0,     0,     0,     0,     0,   203,     0,
    1442,   205,     0,     0,     0,  -885,  1428,     0,    19,   722,
      20,     0,     0,     0,     0,     0,   723,   724,    21,     0,
       0,   972,     0,     0,   973,     0,     0,     0,    69,   614,
     974,     0,    22,    23,     0,    67,     0,    24,     0,     0,
       0,     0,    25,     0,     0,     0,     0,   725,     0,    26,
      27,    28,     0,     0,     0,   975,     0,     0,    29,     0,
       0,   659,     0,     0,  -885,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   614,     0,
       0,     0,   296,     0,     0,     0,     0,   238,   239,   240,
     241,   242,     0,     0,     0,     0,   244,     0,     0,  -214,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   702,  1146,  -885,     0,     0,     0,   726,     0,     0,
       0,     0,     0,    30,     0,     0,     0,   397,    31,     0,
     398,   399,   660,  -105,   402,   403,   404,   405,     0,   406,
     407,   408,    32,   409,   410,     0,   411,     0,   412,   413,
     414,   415,   416,   213,   417,     0,   418,     0,   419,   420,
     421,     0,   422,     0,   423,     0,   424,  -885,   425,   426,
     427,   428,  -885,     0,   429,   430,     0,   431,   432,     0,
     433,     0,   434,     0,   435,     0,   436,     0,   437,     0,
     438,   439,   661,     0,     0,   171,   696,   173,   174,   175,
     176,     0,   303,     0,   305,     0,   306,   307,   308,   309,
     310,     0,     0,     0,     0,     0,     0,     0,     0,   441,
       0,   442,     0,   727,   728,     0,   729,   730,   731,   732,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     443,    64,     0,     0,    65,    66,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    74,     0,     0,    75,    76,    77,     0,    78,
       0,    79,    80,     0,    81,    82,    83,     0,    84,    85,
       0,    86,     0,    87,    88,    89,    90,    91,     0,    92,
       0,    93,     0,    94,    95,    96,     0,    97,     0,    98,
       0,    99,     0,   100,   101,   102,   103,   104,     0,   105,
     106,     0,   107,   108,     0,   109,     0,   110,     0,   111,
       0,   112,     0,   113,     0,   114,   115,   116,   181,     0,
       0,   182,     0,     0,     0,   183,     0,   184,   185,     0,
       0,     0,   186,   187,   188,     0,   189,   190,    15,     0,
     191,    17,   192,   444,   445,   446,   447,   448,     0,     0,
       0,   449,     0,   450,   451,     0,   452,     0,     0,     0,
     453,   454,   455,   456,   194,     0,    20,   195,   196,   197,
     198,   199,   200,   201,   480,   203,     0,     0,   205,   206,
       0,   207,     0,   208,     0,     0,   209,     0,    22,     0,
       0,   117,     0,     0,   210,     0,   211,   212,     0,   118,
       0,     0,     0,   177,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   481,   216,   217,   218,     0,
     219,   220,     0,   221,   222,     0,     0,     0,     0,     0,
     224,   225,     0,   226,     0,     0,   227,     0,   228,     0,
     229,     0,     0,     0,     0,     0,   230,   231,     0,   232,
     233,   119,     0,     0,   234,     0,     0,     0,     0,     0,
       0,   235,   236,   237,   238,   239,   240,   241,   242,   243,
       0,     0,     0,   244,   178,     0,   179,     0,     0,     0,
       0,     0,   180,   245,     0, -1127,     0,     0,     0,     0,
       0,   497,    65,    66,   498,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   181,     0,     0,   182,     0,
       0,     0,   183,     0,   184,   185,     0,     0,     0,   186,
     187,   188,     0,   189,   190,    15,     0,   191,    17,   192,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     193,   194,     0,    20,   195,   196,   197,   198,   199,   200,
     201,   202,   203,   204,     0,   205,   206,     0,   207,     0,
     208,     0,     0,   209,     0,    22,    23, -1038,     0, -1038,
      24,   210,     0,   211,   212,     0,     0,  -911,   213,     0,
       0,     0,    26,    27,    28,     0,     0,     0,     0,     0,
     214, -1031,   215,   216,   217,   218,     0,   219,   220,     0,
     221,   222,   223,     0,     0,     0,     0,   224,   225,     0,
     226,     0,     0,   227,     0,   228,     0,   229,     0,     0,
       0,     0,     0,   230,   231,     0,   232,   233,     0,     0,
       0,   234,     0,     0,     0,     0,     0,     0,   235,   236,
     237,   238,   239,   240,   241,   242,   243,     0,     0,  1079,
     244,     0,   566,     0,     0,     0,     0,   567,     0,     0,
     245,     0,     0,     0,  -749,     0,   246,  -749,  -749,    65,
      66, -1038,     0,     0,  -749,     0,     0,     0,  -749,     0,
       0,     0,     0,  -749,  -749,     0,     0,     0,     0,     0,
       0,     0,  -749,   568,  -749,     0,     0,     0,  -749,     0,
       0,     0,   569,  -749,     0,  -749,     0,  -749,     0,   570,
     571,  -749,  -749,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   572,     0,     0,  -749,     0,   573,     0,  -749,     0,
     574,  -749,     0,     0,     0,  -749,  -749,  -749,     0,  -749,
     575,  -749,     0,   576,  -749,  -749,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   722,     0,     0,     0,     0,
       0,     0,   723,   724,     0,     0,     0,   194,   577,  -749,
    -749,  -749,   197,  -749,  -749,  -749,  -749,   578,   203,     0,
       0,   579,     0,     0,   342,     0,   580,   581,     0,  -749,
       0,  -749,     0,   725,   582,     0,     0,   583,     0,   584,
     585,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   586,   587,     0,     0,     0,     0,     0,   588,  -749,
    -749,  -749,   351,     0,     0,   352,     0,  -749,     0,     0,
     354,     0,   355,   589,  -749,     0,   590,   591,     0,   592,
       0,   593,   361,     0,     0,   362,   363,     0,   364,   365,
    -749,  -749,   594,   595,     0,     0,     0,   596,   369,  -749,
       0,     0,     0,   726,  -749,  -749,  -749,   597,   598,   599,
       0,   242,   600,  -749,  -749,  -749,     0,  -749,  -749,  -749,
    -749,     0,  1190,     0,     0,   566,     0,     0,     0,     0,
     567,   702,   601,     0,     0,  -749,  -749,  -749,  -911,   213,
    -749,  -749,     0,     0,     0,     0,     0,  -749,     0,     0,
       0,  -749,     0,     0,     0,     0,  -749,  -749,     0,     0,
       0,     0,     0,     0,     0,  1191,   568,  -749,     0,     0,
       0,  -749,     0,     0,     0,   569,  -749,     0,  -749,     0,
    -749,     0,   570,   571,  -749,  -749,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   727,
     728,     0,   729,   730,   731,   732,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    64,     0,     0,
      65,    66,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   572,     0,     0,  -749,     0,   573,
       0,  -749,     0,   574,  -749,     0,     0,     0,  -749,  -749,
    -749,     0,  -749,   575,  -749,     0,   576,  -749,  -749,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     194,   577,  -749,  -749,  -749,   197,  -749,  -749,  -749,  -749,
     578,   203,     0,     0,   579,     0,     0,   342,     0,   580,
     581,     0,  -749,     0,  -749,     0,     0,   582,     0,     0,
     583,     0,   584,   585,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   586,   587,     0,     0,     0,     0,
       0,   588,  -749,  -749,  -749,   351,     0,     0,   352,     0,
    -749,     0,     0,   354,     0,   355,   589,  -749,     0,   590,
     591,     0,   592,     0,   593,   361,     0,     0,   362,   363,
       0,   364,   365,  -749,  -749,   594,   595,     0,     0,     0,
     596,   369,  -749,     0,     0,     0,     0,  -749,  -749,  -749,
     597,   598,   599,     0,   242,   600,  -749,  -749,  -749,     0,
    -749,  -749,  -749,  -749,     0,  1234,     0,     0,   566,     0,
       0,     0,     0,   567,     0,   601,     0,     0,  -749,  -749,
    -749,     0,     0,  -749,  -749,     0,     0,     0,     0,     0,
    -749,     0,     0,     0,  -749,     0,     0,     0,     0,  -749,
    -749,     0,     0,     0,     0,     0,     0,     0,  -749,   568,
    -749,     0,     0,     0,  -749,     0,     0,     0,   569,  -749,
       0,  -749,     0,  -749,     0,   570,   571,  -749,  -749,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   572,     0,     0,
    -749,     0,   573,     0,  -749,     0,   574,  -749,     0,     0,
       0,  -749,  -749,  -749,     0,  -749,   575,  -749,     0,   576,
    -749,  -749,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   194,   577,  -749,  -749,  -749,   197,  -749,
    -749,  -749,  -749,   578,   203,     0,     0,   579,     0,     0,
     342,     0,   580,   581,     0,  -749,     0,  -749,     0,     0,
     582,     0,     0,   583,     0,   584,   585,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   586,   587,     0,
       0,     0,     0,     0,   588,  -749,  -749,  -749,   351,     0,
       0,   352,     0,  -749,     0,     0,   354,     0,   355,   589,
    -749,     0,   590,   591,     0,   592,     0,   593,   361,     0,
       0,   362,   363,     0,   364,   365,  -749,  -749,   594,   595,
       0,     0,     0,   596,   369,  -749,     0,     0,     0,     0,
    -749,  -749,  -749,   597,   598,   599,     0,   242,   600,  -749,
    -749,  -749,     0,  -749,  -749,  -749,  -749,     0,  1339,     0,
       0,   566,     0,     0,     0,     0,   567,     0,   601,     0,
       0,  -749,  -749,  -749,     0,     0,  -749,  -749,     0,     0,
       0,     0,     0,  -749,     0,     0,     0,  -749,     0,     0,
       0,     0,  -749,  -749,     0,     0,     0,     0,     0,     0,
       0,  -749,   568,  -749,     0,     0,     0,  -749,     0,     0,
       0,   569,  -749,     0,  -749,     0,  -749,     0,   570,   571,
    -749,  -749,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     572,     0,     0,  -749,     0,   573,     0,  -749,     0,   574,
    -749,     0,     0,     0,  -749,  -749,  -749,     0,  -749,   575,
    -749,     0,   576,  -749,  -749,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   194,   577,  -749,  -749,
    -749,   197,  -749,  -749,  -749,  -749,   578,   203,     0,     0,
     579,     0,     0,   342,     0,   580,   581,     0,  -749,     0,
    -749,     0,     0,   582,     0,     0,   583,     0,   584,   585,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     586,   587,     0,     0,     0,     0,     0,   588,  -749,  -749,
    -749,   351,     0,     0,   352,     0,  -749,     0,     0,   354,
       0,   355,   589,  -749,     0,   590,   591,     0,   592,     0,
     593,   361,     0,     0,   362,   363,     0,   364,   365,  -749,
    -749,   594,   595,     0,     0,     0,   596,   369,  -749,     0,
       0,     0,     0,  -749,  -749,  -749,   597,   598,   599,     0,
     242,   600,  -749,  -749,  -749,     0,  -749,  -749,  -749,  -749,
      73,     0,     0,   -60,     0,     0,     0,     0,   -60,     0,
       0,   601,     0,     0,  -749,  -749,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   -60,     0,
       0,     0,     0,     0,   -60,     0,     0,     0,     0,     0,
       0,     0,     0,   -60,     0,     0,     0,     0,     0,     0,
     -60,   -60,     0,     0,     0,     0,    74,     0,     0,    75,
      76,    77,     0,    78,     0,    79,    80,     0,    81,    82,
      83,     0,    84,    85,     0,    86,     0,    87,    88,    89,
      90,    91,     0,    92,     0,    93,     0,    94,    95,    96,
       0,    97,     0,    98,     0,    99,     0,   100,   101,   102,
     103,   104,     0,   105,   106,     0,   107,   108,     0,   109,
       0,   110,     0,   111,     0,   112,     0,   113,     0,   114,
     115,   116,     0,     0,     0,     0,     0,     0,     0,     0,
     325,   -60,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   -60,     0,     0,   -60,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   -60,     0,
       0,     0,     0,   -60,     0,     0,     0,     0,   -60,     0,
       0,     0,     0,     0,     0,   -60,     0,   -60,   -60,     0,
       0,     0,     0,     0,     0,   117,     0,     0,   -60,     0,
     -60,   -60,   326,   118,     0,     0,     0,     0,     0,     0,
       0,     0,   -60,   -60,     0,     0,     0,     0,     0,   -60,
       0,     0,     0,   -60,     0,     0,   -60,     0,   -60,     0,
       0,   -60,     0,   -60,   -60,     0,     0,   -60,   -60,     0,
     -60,     0,   -60,   -60,     0,     0,   -60,   -60,     0,   -60,
     -60,     0,     0,   -60,   -60,   119,     0,     0,   -60,   -60,
       0,     0, -1108,     0,     0, -1108,     0,     0,     0, -1108,
       0, -1108, -1108,   -60,     0,     0, -1108, -1108, -1108,     0,
   -1108, -1108, -1108,     0, -1108, -1108, -1108,     0,     0,     0,
       0,     0,     0,    64,     0,     0,    65,    66,     0,  1287,
       0,     0,     0,     0,     0,     0,     0,     0, -1108,   924,
   -1108, -1108, -1108, -1108, -1108, -1108, -1108, -1108, -1108, -1108,
       0,     0, -1108, -1108,     0, -1108,     0, -1108,     0,     0,
   -1108,     0, -1108,     0,     0,     0,     0,     0, -1108,     0,
   -1108, -1108,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   925,     0,     0,     0,     0,     0,     0, -1108,
   -1108, -1108, -1108,     0, -1108, -1108,     0, -1108, -1108,     0,
       0,     0,     0,     0, -1108, -1108,     0, -1108,     0,     0,
   -1108,     0, -1108,     0, -1108,     0,     0,     0,     0,     0,
   -1108, -1108,     0, -1108, -1108,     0,     0,     0, -1108,     0,
       0,     0,     0,     0,     0, -1108, -1108, -1108, -1108, -1108,
   -1108, -1108, -1108, -1108,     0,     0,     0, -1108,     0,     0,
       0,     0,     0,     0,     0,     0,     0, -1108,     0,     0,
       0, -1108,     0,   926, -1108,     0, -1108, -1108, -1108,     0,
   -1108, -1108,     0,     0,     0, -1108, -1108, -1108,     0, -1108,
   -1108, -1108,     0, -1108, -1108, -1108,     0,     0,     0,     0,
       0,     0,  1437,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0, -1108,   924, -1108,
   -1108, -1108, -1108, -1108, -1108, -1108, -1108, -1108, -1108,     0,
       0, -1108, -1108,     0, -1108,     0, -1108,     0,     0, -1108,
       0, -1108,     0,     0,     0,     0,     0, -1108,     0, -1108,
   -1108,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   925,     0,     0,     0,     0,     0,     0, -1108, -1108,
   -1108, -1108,     0, -1108, -1108,     0, -1108, -1108,     0,     0,
       0,     0,     0, -1108, -1108,     0, -1108,     0,     0, -1108,
       0, -1108,     0, -1108,     0,     0,     0,     0,     0, -1108,
   -1108,     0, -1108, -1108,     0,     0,     0, -1108,     0,     0,
       0,     0,     0,     0, -1108, -1108, -1108, -1108, -1108, -1108,
   -1108, -1108, -1108,     0,     0,     0, -1108,     0,     0,     0,
       0,     0,     0,     0, -1108,     0, -1108, -1108,     0,     0,
       0, -1108,   926, -1108, -1108, -1108, -1108,     0, -1108, -1108,
   -1108,     0, -1108, -1108, -1108,     0, -1108, -1108, -1108,     0,
       0,     0,     0,     0,     0,   718,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
   -1108,   924, -1108, -1108, -1108, -1108, -1108, -1108, -1108, -1108,
   -1108, -1108,     0,     0, -1108, -1108,     0, -1108,     0, -1108,
       0,     0, -1108,     0, -1108,     0,     0,     0,     0,     0,
   -1108,     0, -1108, -1108,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   925,     0,     0,     0,     0,     0,
       0, -1108, -1108, -1108, -1108,     0, -1108, -1108,     0, -1108,
   -1108,     0,     0,     0,     0,     0, -1108, -1108,     0, -1108,
       0,     0, -1108,     0, -1108,     0, -1108,     0,     0,     0,
       0,     0, -1108, -1108,     0, -1108, -1108,     0,     0,     0,
   -1108,     0,     0,     0,     0,     0,     0, -1108, -1108, -1108,
   -1108, -1108, -1108, -1108, -1108, -1108,     0,     0,     0, -1108,
       0,     0,     0,     0,     0,     0,     0,   181,     0, -1108,
     182,     0,     0,     0,   183,   926,   184,   185, -1108, -1108,
       0,   186,   187,   188,     0,   189,   190,    15,     0,   191,
      17,   192,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   762,     0,     0,     0,     0,     0,
       0,     0,     0,   194,     0,    20,   195,   196,   197,   198,
     199,   200,   201,   480,   203,     0,     0,   205,   206,     0,
     207,     0,   208,     0,     0,   209,     0,    22,     0,     0,
       0,     0,     0,   210,     0,   211,   212,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   481,   216,   217,   218,     0,   219,
     220,     0,   221,   222,     0,     0,     0,     0,     0,   224,
     225,     0,   226,     0,     0,   227,     0,   228,     0,   229,
       0,     0,     0,     0,     0,   230,   231,     0,   232,   233,
       0,     0,     0,   234,     0,     0,     0,     0,     0,     0,
     235,   236,   237,   238,   239,   240,   241,   242,   243,     0,
       0,     0,   244,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   245,     0,     0,     0,   181,   702,    64,   182,
       0,    65,    66,   183,     0,   184,   185,     0,     0,     0,
     186,   187,   188,     0,   189,   190,    15,     0,   191,    17,
     192,   566,     0,     0,     0,     0,   567,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   194,     0,    20,   195,   196,   197,   198,   199,
     200,   201,   480,   203,     0,     0,   205,   206,     0,   207,
       0,   208,   568,     0,   209,     0,    22,     0,     0,     0,
       0,   569,   210,     0,   211,   212,     0,     0,   570,   571,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    -735,     0,     0,   481,   216,   217,   218,     0,   219,   220,
       0,   221,   222,     0,     0,     0,     0,     0,   224,   225,
       0,   226,     0,     0,   227,     0,   228,     0,   229,     0,
       0,     0,     0,     0,   230,   231,     0,   232,   233,     0,
       0,     0,   234,     0,     0,     0,     0,     0,     0,   235,
     236,   237,   238,   239,   240,   241,   242,   243,     0,     0,
     572,   244,     0,     0,     0,   573,     0,     0,     0,   574,
       0,   245,     0,     0,     0,     0,     0,     0,     0,   575,
      65,    66,   576,     0,     0,     0,     0,   566,     0,     0,
       0,     0,   567,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   194,   577,     0,     0,
       0,   197,     0,     0,     0,     0,   578,   203,  -835,     0,
     579,     0,     0,   342,     0,   580,   581,     0,   568,     0,
       0,  -835,     0,   582,     0,     0,   583,   569,   584,   585,
    -835,     0,     0,     0,   570,   571,     0,     0,     0,     0,
     586,   587,     0,     0,     0,     0,     0,   588,     0,     0,
       0,   351,     0,     0,   352,     0,     0,     0,     0,   354,
       0,   355,   589,     0,     0,   590,   591,     0,   592,     0,
     593,   361,  -835,     0,   362,   363,     0,   364,   365,     0,
    -835,   594,   595,     0,     0,     0,   596,   369,     0,     0,
       0,     0,     0,     0,     0,     0,   597,   598,   599,     0,
     242,   600,     0,     0,     0,     0,   572,     0,     0,     0,
       0,   573,     0,     0,     0,   574,     0,     0,     0,     0,
       0,   601,     0,     0,     0,   575,     0,     0,   576,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  -835,
       0,     0,     0,     0,     0,  1019,  1020,     0,     0,     0,
       0,     0,   194,   577,     0,   187,   188,   197,   189,     0,
       0,  1021,   578,   203,   192,     0,   579,  1019,  1020,   342,
       0,   580,   581,     0,     0,     0,     0,     0,     0,   582,
       0,     0,   583,  1021,   584,   585,     0,     0,     0,   195,
    1022,     0,     0,     0,   200,   201,   586,   587,  -835,     0,
       0,     0,     0,   588,     0,     0,     0,   351,     0,     0,
     352,     0,  1022,     0,     0,   354,     0,   355,   589,     0,
       0,   590,   591,     0,   592,     0,   593,   361,     0,     0,
     362,   363,     0,   364,   365,     0,     0,   594,   595,     0,
       0,     0,   596,   369,     0,     0,     0,  -835,     0,     0,
       0,     0,   597,   598,   599,     0,   242,   600,     0,     0,
       0,     0,  1023,     0,     0,     0,  1024,     0,     0,  1025,
       0,     0,     0,  1026,     0,   566,     0,   601,     0,    15,
     567,     0,    17,     0,  1023,   237,     0,     0,  1024,     0,
       0,  1025,     0,     0,     0,  1026,     0,     0,     0,     0,
       0,  -835,     0,     0,     0,     0,  -835,    20,     0,  1027,
       0,  1028,  1029,     0,     0,     0,   568,     0,     0,     0,
       0,     0,     0,     0,     0,   569,     0,  1030,     0,    22,
       0,  1027,     0,  1028,  1029,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1030,
       0,     0,     0,     0,     0,     0,     0,  1031,  1032,  1033,
       0,     0,     0,     0,     0,  1034,     0,     0,     0,     0,
       0,     0,  1035,     0,     0,     0,     0,     0,     0,  1031,
    1032,  1033,     0,     0,     0,     0,     0,  1034,  1036,  1037,
       0,     0,     0,     0,  1035,   333,     0,  1038,     0,     0,
     334,     0,  1039,  1040,   572,     0,     0,     0,     0,   573,
    1036,     0,     0,   574,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   575,  1039,  1040,   576,     0,     0,     0,
     335,     0,     0,    65,    66,     0,   336,     0,     0,     0,
       0,     0,     0,     0,     0,   337,     0,     0,     0,     0,
     194,     0,  1466,     0,     0,   197,     0,     0,     0,     0,
     578,   203,     0,     0,   579,     0,     0,   342,     0,   580,
     581,     0,     0,     0,     0,     0,     0,   582,     0,     0,
     583,     0,   584,   585,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   586,   587,     0,     0,     0,     0,
       0,   588,     0,     0,     0,   351,     0,     0,   352,     0,
       0,     0,     0,   354,     0,   355,   589,     0,     0,   590,
     591,   333,   592,     0,   593,   361,   334,     0,   362,   363,
       0,   364,   365,   338,     0,   594,   595,     0,     0,     0,
     596,   369,     0,   339,     0,     0,   340,     0,     0,     0,
     597,   598,   599,     0,   242,   600,     0,     0,     0,     0,
       0,     0,   336,     0,     0,     0,     0,     0,     0,     0,
       0,   337,     0,     0,     0,     0,     0,     0,     0,     0,
     341,     0,     0,     0,     0,     0,     0,   342,     0,   343,
     344,     0,     0,     0,  1258,     0,     0,     0,     0,     0,
     345,     0,   346,   347,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   348,   349,     0,     0,     0,     0,
       0,   350,     0,     0,     0,   351,     0,     0,   352,     0,
     353,     0,     0,   354,     0,   355,   356,     0,     0,   357,
     358,     0,   359,     0,   360,   361,     0,     0,   362,   363,
       0,   364,   365,     0,     0,   366,   367,   793,     0,   338,
     368,   369,     0,     0,     0,     0,     0,   794,     0,   339,
       0,   795,   340,     0,     0,   370,     0,  -741,     0,     0,
       0,     0,     0,     0,     0,  -741,     0,  -741,     0,     0,
       0,   796,     0,     0,     0,     0,   797,     0,   798,     0,
     799,     0,     0,     0,   800,     0,   341,     0,     0,     0,
       0,     0,     0,   342,     0,   343,   344,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   345,     0,   346,   347,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     348,   349,     0,     0,     0,     0,     0,   350,     0,     0,
       0,   351,     0,     0,   352,     0,   353,     0,     0,   354,
       0,   355,   356,     0,     0,   357,   358,     0,   359,     0,
     360,   361,     0,     0,   362,   363,     0,   364,   365,     0,
       0,   366,   367,     0,     0,     0,   368,   369,     0,   187,
     188,     0,   189,     0,     0,     0,     0,     0,   192,     0,
       0,   370,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   195,     0,     0,     0,     0,   200,   201,
     397,     0,     0,   398,   399,   873,   874,   402,   403,   404,
     405,     0,   406,   407,   408,     0,   409,   410,     0,   411,
       0,   412,   413,   414,   415,   416,     0,   417,     0,   418,
       0,   419,   420,   421,     0,   422,     0,   423,     0,   424,
       0,   425,   426,   427,   428,     0,     0,   429,   430,     0,
     431,   432,     0,   433,     0,   434,     0,   435,     0,   436,
       0,   437,     0,   438,   439,   875,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   237,
       0,     0,   441,   876,   442,     0,   801,   727,   728,     0,
     729,   730,   731,   732,   877,   878,     0,     0,     0,     0,
       0,   397,     0,   443,   398,   399,   400,   401,   402,   403,
     404,   405,     0,   406,   407,   408,     0,   409,   410,     0,
     411,     0,   412,   413,   414,   415,   416,     0,   417,     0,
     418,     0,   419,   420,   421,     0,   422,     0,   423,     0,
     424,     0,   425,   426,   427,   428,     0,     0,   429,   430,
       0,   431,   432,     0,   433,     0,   434,     0,   435,     0,
     436,     0,   437,     0,   438,   439,   440,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   441,     0,   442,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   443,     0,   444,   445,   446,   447,
     448,     0,     0,     0,   449,     0,   450,   451,     0,   452,
       0,     0,     0,   453,   454,   455,   456,     0,     0,     0,
     397,     0,     0,   398,   399,   668,   401,   402,   403,   404,
     405,     0,   406,   407,   408,     0,   409,   410,     0,   411,
       0,   412,   413,   414,   415,   416,     0,   417,     0,   418,
       0,   419,   420,   421,     0,   422,     0,   423,     0,   424,
       0,   425,   426,   427,   428,     0,     0,   429,   430,     0,
     431,   432,     0,   433,     0,   434,     0,   435,     0,   436,
       0,   437,     0,   438,   439,   440,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   444,   445,   446,
     447,   448,   441,     0,   442,   449,     0,   450,   451,     0,
     452,     0,     0,     0,   453,   454,   455,   456,     0,     0,
       0,   397,     0,   443,   398,   399,   855,     0,   402,   403,
     404,   405,     0,   406,   407,   408,     0,   409,   410,     0,
     411,     0,   412,   413,   414,   415,   416,     0,   417,     0,
     418,     0,   419,   420,   421,     0,   422,     0,   423,     0,
     424,     0,   425,   426,   427,   428,     0,     0,   429,   430,
       0,   431,   432,     0,   433,     0,   434,     0,   435,     0,
     436,     0,   437,     0,   438,   439,   440,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   441,     0,   442,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   443,     0,   444,   445,   446,   447,
     448,     0,     0,     0,   449,     0,   450,   451,     0,   452,
       0,     0,     0,   453,   454,   455,   456,     0,     0,     0,
     397,     0,     0,   398,   399,   660,     0,   402,   403,   404,
     405,     0,   406,   407,   408,     0,   409,   410,     0,   411,
       0,   412,   413,   414,   415,   416,     0,   417,     0,   418,
       0,   419,   420,   421,     0,   422,     0,   423,     0,   424,
       0,   425,   426,   427,   428,     0,     0,   429,   430,     0,
     431,   432,     0,   433,     0,   434,     0,   435,     0,   436,
       0,   437,     0,   438,   439,   861,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   444,   445,   446,
     447,   448,   441,     0,   442,   449,     0,   450,   451,     0,
     452,     0,     0,     0,   453,   454,   455,   456,     0,     0,
       0,   397,     0,   443,   398,   399,   660,     0,   402,   403,
     404,   405,     0,   406,   407,   408,     0,   409,   410,     0,
     411,     0,   412,   413,   414,   415,   416,     0,   417,     0,
     418,     0,   419,   420,   421,     0,   422,     0,   423,     0,
     424,     0,   425,   426,   427,   428,     0,     0,   429,   430,
       0,   431,   432,     0,   433,     0,   434,     0,   435,     0,
     436,     0,   437,     0,   438,   439,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   441,     0,   442,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   443,     0,   444,   445,   446,   447,
     448,     0,     0,     0,   449,     0,   450,   451,     0,   452,
       0,     0,     0,   453,   454,   455,   456,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   180,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   181,     0,     0,   182,     0,     0,     0,   183,
       0,   184,   185,     0,     0,     0,   186,   187,   188,     0,
     189,   190,    15,     0,   191,    17,   192,   444,   445,   446,
     447,   448,     0,     0,     0,   449,     0,   450,   451,     0,
     452,     0,     0,     0,   453,   454,   455,   456,   194,     0,
      20,   195,   196,   197,   198,   199,   200,   201,   480,   203,
       0,     0,   205,   206,     0,   207,     0,   208,     0,     0,
     209,     0,    22,     0,     0,     0,     0,     0,   210,     0,
     211,   212,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   481,
     216,   217,   218,     0,   219,   220,     0,   221,   222,     0,
       0,     0,     0,     0,   224,   225,     0,   226,     0,     0,
     227,     0,   228,     0,   229,     0,     0,     0,     0,     0,
     230,   231,     0,   232,   233,     0,     0,     0,   234,     0,
       0,     0,     0,     0,     0,   235,   236,   237,   238,   239,
     240,   241,   242,   243,     0,     0,     0,   244,     0,     0,
       0,     0,     0,     0,     0,   181,     0,   245,   182,     0,
       0,     0,   183,     0,   184,   185,    65,    66,     0,   186,
     187,   188,     0,   189,   190,    15,     0,   191,    17,   192,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   194,     0,    20,   195,   196,   197,   198,   199,   200,
     201,   480,   203,     0,     0,   205,   206,     0,   207,     0,
     208,     0,     0,   209,     0,    22,     0,     0,     0,     0,
       0,   210,     0,   211,   212,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   481,   216,   217,   218,     0,   219,   220,     0,
     221,   222,     0,     0,     0,     0,     0,   224,   225,     0,
     226,     0,     0,   227,     0,   228,     0,   229,     0,     0,
       0,     0,     0,   230,   231,     0,   232,   233,     0,     0,
       0,   234,     0,     0,     0,     0,     0,     0,   235,   236,
     237,   238,   239,   240,   241,   242,   243,   182,     0,     0,
     244,   183,     0,     0,   185,     0,     0,     0,   186,   972,
     245,     0,   973,     0,     0,     0,     0,     0,   974,    65,
      66,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   975,   196,     0,   198,   199,     0,     0,
       0,     0,     0,     0,     0,   181,     0,     0,     0,     0,
       0,     0,   209,     0,   184,     0,     0,     0,     0,     0,
     187,   188,     0,   189,   190,     0,     0,   191,     0,   192,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   216,   217,   218,     0,   219,   220,     0,     0,
     222,   194,     0,     0,   195,     0,   197,   225,     0,   200,
     201,   480,   203,     0,     0,   205,     0,     0,   207,     0,
     208,     0,     0,   231,     0,     0,     0,     0,     0,     0,
       0,   210,     0,   211,   212,     0,     0,   235,   236,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   481,     0,     0,     0,     0,     0,     0,     0,
     221,     0,     0,     0,     0,     0,     0,   224,    65,    66,
     226,     0,     0,   227,     0,   228,     0,     0,     0,     0,
       0,     0,     0,   230,     0,     0,   232,   233,     0,     0,
       0,   234,     0,     0,     0,     0,     0,     0,     0,     0,
     237,   238,   239,   240,   241,   242,   243,     0,     0,     0,
     244
};

static const yytype_int16 yycheck[] =
{
       4,     5,     6,    35,    12,     1,   178,     4,     5,     6,
     246,   292,   331,   332,    67,   120,   229,   206,   980,   946,
     180,     1,   155,   323,   724,   506,   491,   665,   400,   218,
     510,    35,    40,   180,   312,   179,    40,   958,    35,   126,
     794,   323,   771,   523,   323,  1014,   908,   801,   748,   847,
     184,     1,   918,     1,  1106,     1,     1,   923,   525,     1,
       1,     1,     1,   252,     1,   338,     1,   280,   391,     1,
     932,    43,   267,   935,     1,   967,     1,   969,   378,     1,
     380,     1,     1,   758,     1,     1,    67,     1,     1,     1,
     279,   736,     1,     1,   373,     1,   378,     1,   380,   378,
     962,   380,     1,   863,   664,     1,   284,     1,     1,     1,
      80,     1,     1,    67,  1191,    69,     1,     1,   598,     1,
       1,     1,    56,     1,     1,     1,     1,     1,     1,     1,
       1,    73,     1,   228,     1,     1,     1,     1,     1,     1,
       1,    73,    31,    65,  1305,     1,    73,     1,     1,     1,
      72,   153,    17,   951,    17,    79,     1,     1,     1,    61,
      62,   524,   525,   526,    22,    73,  1223,    22,     1,   205,
     178,   207,     1,    38,    56,   904,    75,    29,    42,   479,
      55,    80,   205,     1,   207,     1,   110,   482,     1,     1,
     138,     3,    73,    47,    75,    60,    73,   479,    72,    75,
     479,   203,    60,    75,   338,    79,    80,   524,   525,   526,
      72,   305,    74,    74,    27,  1177,   150,    73,   947,   524,
     525,   526,    75,    80,     1,   606,   774,    98,    73,    73,
     509,   299,    75,    79,    80,  1097,   110,  1099,  1100,  1101,
      73,   283,   284,   774,     1,   945,   138,   524,   525,   526,
      77,   132,  1329,   532,    72,   533,   132,   535,   206,   267,
    1152,   524,   525,   526,   110,   159,   155,   136,   150,   132,
      72,   946,   180,   309,   147,  1436,   132,   179,  1335,   132,
     138,  1173,   184,   138,   562,   114,   309,   132,   132,   132,
     180,   663,   464,   665,   306,   473,    47,   309,    75,   132,
       1,   574,   862,   675,    67,   313,   180,   311,   312,   954,
     318,   215,   293,   793,   311,   312,   324,    18,   314,   323,
     324,   230,   200,   512,   513,   607,   379,  1087,   607,   243,
     302,   654,   504,   303,   494,   530,   496,   272,   275,   293,
     229,   215,   216,   223,  1265,   377,   239,   259,   495,   521,
     295,   523,   293,   542,   304,   303,   545,   307,   308,   531,
     306,  1330,   304,   309,   304,  1257,   305,   307,   540,  1338,
     835,   851,   304,   377,   378,  1104,   380,   304,   294,   304,
     377,   303,   295,    73,   304,   304,   303,  1249,  1315,  1316,
     753,   304,   711,   712,   307,   308,   304,   213,   304,   866,
     294,   307,   308,   698,   303,   299,   871,  1273,   304,   704,
     304,   774,   286,   287,   304,   289,   290,   291,   292,   304,
     304,   726,  1314,  1221,  1222,   720,   721,  1479,  1290,   296,
     304,   473,   980,   307,   308,  1397,   753,   818,   304,  1139,
     574,   307,   308,  1197,    67,  1145,   303,   304,   753,   980,
    1088,   687,   933,   210,   817,   282,   464,   234,   304,  1386,
     237,   307,   308,  1171,  1172,   945,     1,   244,   225,   660,
     114,    14,   939,    74,   970,   479,     1,   254,    17,  1448,
     257,   948,   949,   260,   261,  1447,  1378,    24,     1,  1351,
     180,   863,    31,   270,     1,   297,   504,    17,   506,    79,
      17,   303,   304,   866,   306,  1001,     1,   309,     1,   881,
       1,     1,    72,   521,    31,   523,   524,   525,   526,   523,
      80,   821,    65,   531,   713,    60,    17,   304,    74,   533,
     110,   535,   540,   223,   538,  1456,   533,    74,   535,   821,
       1,   538,   821,  1023,   691,  1407,   690,    67,    73,   866,
    1250,   851,     1,     1,     1,  1482,   838,     1,   562,   838,
      73,   866,     1,   650,   724,   562,    73,    60,  1048,   851,
      67,   853,   851,    83,   853,   224,   939,   724,    73,  1308,
       1,   944,   887,    73,   773,   948,   949,   294,   748,   866,
      72,    72,   299,     1,    79,    80,   891,    79,    80,   179,
     249,   748,  1067,   866,   184,   282,   189,   132,    17,  1317,
      49,   288,    60,    53,   304,    74,   155,   980,  1480,   132,
     180,    61,   939,    74,    73,   132,   945,   944,   110,   114,
      74,   948,   949,   132,   939,   824,  1435,   132,   155,   944,
    1315,  1316,   132,   948,   949,  1353,   303,   304,   191,   966,
    1404,    60,    73,    74,  1119,    99,   216,   893,     1,    67,
    1125,   966,   939,   189,   855,    73,   857,   944,  1364,  1377,
     304,   948,   949,   307,   308,  1383,   939,   150,  1477,  1478,
     961,   944,   150,  1379,    17,   948,   949,     1,  1155,   966,
     229,   238,   153,   282,   155,   156,   179,   240,   180,   303,
     304,   184,    16,   966,   304,  1005,   153,   307,   308,   156,
      28,  1386,   229,   885,    47,  1087,  1088,    72,  1018,    74,
     181,   304,   726,  1005,   307,   308,  1005,     1,   189,   288,
    1459,  1406,   829,   830,    67,   282,  1018,    55,   223,  1018,
      67,   288,   203,  1472,   304,   753,    10,   307,   308,   753,
      14,   215,   213,  1461,  1462,    19,   203,     4,     5,   931,
    1435,    79,    80,   229,  1042,  1043,   774,    67,   229,    69,
     778,   779,  1072,  1055,   247,   779,  1055,   910,   304,   247,
    1247,   307,   308,   256,    58,   945,   958,    44,   256,    46,
    1072,   229,  1155,  1072,     1,    72,   114,    74,   945,    83,
     179,   274,  1477,  1478,  1123,   184,   274,  1482,    15,   817,
      17,    72,  1107,  1311,  1312,  1313,  1281,   821,  1298,   304,
     304,   817,   304,  1303,    31,   307,   308,  1146,  1295,  1148,
     304,  1150,  1440,  1441,   838,   296,    43,   817,  1155,    32,
      19,    34,    21,  1138,    37,  1140,    53,   851,    75,    55,
    1155,    57,  1460,   295,    61,    67,   989,   293,   866,   992,
      41,   148,   179,    67,   151,    73,  1161,   184,   229,   248,
     157,    72,   251,   190,   132,  1483,   193,   885,  1155,   153,
      75,    73,   156,   887,  1247,   108,  1366,   132,  1188,   293,
     215,   234,  1155,    69,   237,   182,  1361,   295,   295,   295,
     295,   244,    72,    40,   283,   223,  1188,   911,    75,  1188,
     914,   254,   215,    73,   257,   189,    73,   260,   261,   108,
     304,    72,  1158,   931,    73,   933,    73,   270,  1061,   203,
    1247,   939,  1295,  1233,    80,    36,   944,    51,   303,   213,
     948,   949,  1247,    52,  1157,    73,    75,    73,   155,  1268,
     958,  1233,    23,    73,  1233,   132,  1251,    72,    75,    75,
      73,   304,   279,   280,   281,   282,   283,    73,    80,   304,
    1247,   288,   980,     1,   294,   271,  1165,  1272,  1295,  1139,
      47,  1300,    73,    73,  1247,  1145,   304,   983,  1148,    74,
    1295,    72,  1139,     1,  1311,  1312,  1313,   155,  1145,    72,
    1105,  1005,  1064,   983,     1,  1037,  1311,  1312,  1313,   114,
      73,    73,   833,   860,  1018,   903,   671,   142,  1295,   855,
     663,  1074,   229,   857,  1093,   132,  1159,   654,  1307,    40,
     881,   390,  1295,  1037,  1311,  1312,  1313,   777,  1042,  1043,
    1037,  1336,    40,  1247,  1344,  1042,  1043,    75,  1311,  1312,
    1313,  1055,    80,  1372,  1373,   983,  1375,  1376,   300,   526,
    1355,   944,  1344,  1134,   753,  1344,  1361,   753,  1072,  1364,
     753,    40,   983,   983,   178,    72,  1371,   271,   765,   267,
     774,    20,    79,    80,  1175,   980,  1258,   294,  1269,  1368,
    1250,  1115,   299,  1393,  1283,   302,   945,   304,   691,  1103,
     307,   308,  1363,  1250,  1293,  1274,   606,   179,   294,  1082,
    1405,  1393,   184,   110,  1393,   853,   566,  1055,   190,   607,
    1309,   193,  1417,   787,   152,   818,  1446,  1332,   136,   546,
     535,    40,   140,   752,  1429,   143,  1446,   172,  1081,   147,
     148,   958,  1442,   151,    40,  1200,   581,  1155,   314,   157,
    1236,   179,  1245,   316,  1244,  1183,   184,   373,   814,   522,
    1442,     1,   190,  1442,    -1,   193,   569,    -1,    -1,     1,
      -1,  1452,    -1,    -1,   182,   183,    -1,   185,   186,  1474,
      -1,    -1,    -1,   180,  1188,    -1,    -1,    -1,    -1,     0,
       1,    -1,     3,   201,     5,     6,     7,     8,    -1,    10,
      11,    12,    13,    -1,    -1,    -1,    -1,   279,   280,   281,
      -1,   283,    -1,  1449,    -1,    -1,    -1,    -1,   215,   216,
      -1,    -1,    33,   231,   232,   233,    -1,   235,   236,  1233,
      -1,   239,    -1,    -1,     1,    -1,    -1,    -1,   246,  1247,
      -1,  1430,    -1,    75,    -1,    -1,    -1,    14,    80,    -1,
    1258,   279,   280,   281,   262,   283,    23,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1269,  1270,    -1,   276,   277,
      -1,    -1,    -1,    -1,    -1,   303,   304,    -1,  1450,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1295,    -1,   286,
     287,    -1,   289,   290,   291,   292,    -1,    -1,    65,   307,
     308,    -1,    -1,    -1,    -1,    -1,    73,   304,    -1,    -1,
     307,   308,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     152,    -1,   162,   163,   164,   165,   166,   167,   168,   169,
     170,  1327,    -1,   173,   174,   175,   176,   177,    -1,    -1,
    1344,   152,   153,    -1,   155,   156,    -1,   179,   159,    -1,
      -1,    -1,   184,    -1,    -1,    -1,    -1,    -1,   190,    -1,
    1392,   193,    -1,    -1,    -1,   132,  1370,    -1,   179,    72,
     181,    -1,    -1,    -1,    -1,    -1,    79,    80,   189,    -1,
      -1,   148,    -1,    -1,   151,    -1,    -1,    -1,  1392,  1393,
     157,    -1,   203,   204,    -1,  1392,    -1,   208,    -1,    -1,
      -1,    -1,   213,    -1,    -1,    -1,    -1,   110,    -1,   220,
     221,   222,    -1,    -1,    -1,   182,    -1,    -1,   229,    -1,
      -1,     1,    -1,    -1,   191,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1442,    -1,
      -1,    -1,  1450,    -1,    -1,    -1,    -1,   279,   280,   281,
     282,   283,    -1,    -1,    -1,    -1,   288,    -1,    -1,   299,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   303,   304,   240,    -1,    -1,    -1,   180,    -1,    -1,
      -1,    -1,    -1,   294,    -1,    -1,    -1,    67,   299,    -1,
      70,    71,    72,    73,    74,    75,    76,    77,    -1,    79,
      80,    81,   313,    83,    84,    -1,    86,    -1,    88,    89,
      90,    91,    92,   216,    94,    -1,    96,    -1,    98,    99,
     100,    -1,   102,    -1,   104,    -1,   106,   294,   108,   109,
     110,   111,   299,    -1,   114,   115,    -1,   117,   118,    -1,
     120,    -1,   122,    -1,   124,    -1,   126,    -1,   128,    -1,
     130,   131,   132,    -1,    -1,    34,     1,    36,    37,    38,
      39,    -1,    41,    -1,    43,    -1,    45,    46,    47,    48,
      49,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   159,
      -1,   161,    -1,   286,   287,    -1,   289,   290,   291,   292,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     180,   304,    -1,    -1,   307,   308,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    67,    -1,    -1,    70,    71,    72,    -1,    74,
      -1,    76,    77,    -1,    79,    80,    81,    -1,    83,    84,
      -1,    86,    -1,    88,    89,    90,    91,    92,    -1,    94,
      -1,    96,    -1,    98,    99,   100,    -1,   102,    -1,   104,
      -1,   106,    -1,   108,   109,   110,   111,   112,    -1,   114,
     115,    -1,   117,   118,    -1,   120,    -1,   122,    -1,   124,
      -1,   126,    -1,   128,    -1,   130,   131,   132,   133,    -1,
      -1,   136,    -1,    -1,    -1,   140,    -1,   142,   143,    -1,
      -1,    -1,   147,   148,   149,    -1,   151,   152,   153,    -1,
     155,   156,   157,   293,   294,   295,   296,   297,    -1,    -1,
      -1,   301,    -1,   303,   304,    -1,   306,    -1,    -1,    -1,
     310,   311,   312,   313,   179,    -1,   181,   182,   183,   184,
     185,   186,   187,   188,   189,   190,    -1,    -1,   193,   194,
      -1,   196,    -1,   198,    -1,    -1,   201,    -1,   203,    -1,
      -1,   206,    -1,    -1,   209,    -1,   211,   212,    -1,   214,
      -1,    -1,    -1,     1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   230,   231,   232,   233,    -1,
     235,   236,    -1,   238,   239,    -1,    -1,    -1,    -1,    -1,
     245,   246,    -1,   248,    -1,    -1,   251,    -1,   253,    -1,
     255,    -1,    -1,    -1,    -1,    -1,   261,   262,    -1,   264,
     265,   266,    -1,    -1,   269,    -1,    -1,    -1,    -1,    -1,
      -1,   276,   277,   278,   279,   280,   281,   282,   283,   284,
      -1,    -1,    -1,   288,    72,    -1,    74,    -1,    -1,    -1,
      -1,    -1,    80,   298,    -1,    83,    -1,    -1,    -1,    -1,
      -1,   306,   307,   308,   309,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   133,    -1,    -1,   136,    -1,
      -1,    -1,   140,    -1,   142,   143,    -1,    -1,    -1,   147,
     148,   149,    -1,   151,   152,   153,    -1,   155,   156,   157,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     178,   179,    -1,   181,   182,   183,   184,   185,   186,   187,
     188,   189,   190,   191,    -1,   193,   194,    -1,   196,    -1,
     198,    -1,    -1,   201,    -1,   203,   204,   205,    -1,   207,
     208,   209,    -1,   211,   212,    -1,    -1,   215,   216,    -1,
      -1,    -1,   220,   221,   222,    -1,    -1,    -1,    -1,    -1,
     228,   229,   230,   231,   232,   233,    -1,   235,   236,    -1,
     238,   239,   240,    -1,    -1,    -1,    -1,   245,   246,    -1,
     248,    -1,    -1,   251,    -1,   253,    -1,   255,    -1,    -1,
      -1,    -1,    -1,   261,   262,    -1,   264,   265,    -1,    -1,
      -1,   269,    -1,    -1,    -1,    -1,    -1,    -1,   276,   277,
     278,   279,   280,   281,   282,   283,   284,    -1,    -1,     1,
     288,    -1,     4,    -1,    -1,    -1,    -1,     9,    -1,    -1,
     298,    -1,    -1,    -1,    16,    -1,   304,    19,    20,   307,
     308,   309,    -1,    -1,    26,    -1,    -1,    -1,    30,    -1,
      -1,    -1,    -1,    35,    36,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    44,    45,    46,    -1,    -1,    -1,    50,    -1,
      -1,    -1,    54,    55,    -1,    57,    -1,    59,    -1,    61,
      62,    63,    64,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   133,    -1,    -1,   136,    -1,   138,    -1,   140,    -1,
     142,   143,    -1,    -1,    -1,   147,   148,   149,    -1,   151,
     152,   153,    -1,   155,   156,   157,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    72,    -1,    -1,    -1,    -1,
      -1,    -1,    79,    80,    -1,    -1,    -1,   179,   180,   181,
     182,   183,   184,   185,   186,   187,   188,   189,   190,    -1,
      -1,   193,    -1,    -1,   196,    -1,   198,   199,    -1,   201,
      -1,   203,    -1,   110,   206,    -1,    -1,   209,    -1,   211,
     212,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   223,   224,    -1,    -1,    -1,    -1,    -1,   230,   231,
     232,   233,   234,    -1,    -1,   237,    -1,   239,    -1,    -1,
     242,    -1,   244,   245,   246,    -1,   248,   249,    -1,   251,
      -1,   253,   254,    -1,    -1,   257,   258,    -1,   260,   261,
     262,   263,   264,   265,    -1,    -1,    -1,   269,   270,   271,
      -1,    -1,    -1,   180,   276,   277,   278,   279,   280,   281,
      -1,   283,   284,   285,   286,   287,    -1,   289,   290,   291,
     292,    -1,     1,    -1,    -1,     4,    -1,    -1,    -1,    -1,
       9,   303,   304,    -1,    -1,   307,   308,    16,   215,   216,
      19,    20,    -1,    -1,    -1,    -1,    -1,    26,    -1,    -1,
      -1,    30,    -1,    -1,    -1,    -1,    35,    36,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    44,    45,    46,    -1,    -1,
      -1,    50,    -1,    -1,    -1,    54,    55,    -1,    57,    -1,
      59,    -1,    61,    62,    63,    64,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   286,
     287,    -1,   289,   290,   291,   292,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   304,    -1,    -1,
     307,   308,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   133,    -1,    -1,   136,    -1,   138,
      -1,   140,    -1,   142,   143,    -1,    -1,    -1,   147,   148,
     149,    -1,   151,   152,   153,    -1,   155,   156,   157,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     179,   180,   181,   182,   183,   184,   185,   186,   187,   188,
     189,   190,    -1,    -1,   193,    -1,    -1,   196,    -1,   198,
     199,    -1,   201,    -1,   203,    -1,    -1,   206,    -1,    -1,
     209,    -1,   211,   212,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   223,   224,    -1,    -1,    -1,    -1,
      -1,   230,   231,   232,   233,   234,    -1,    -1,   237,    -1,
     239,    -1,    -1,   242,    -1,   244,   245,   246,    -1,   248,
     249,    -1,   251,    -1,   253,   254,    -1,    -1,   257,   258,
      -1,   260,   261,   262,   263,   264,   265,    -1,    -1,    -1,
     269,   270,   271,    -1,    -1,    -1,    -1,   276,   277,   278,
     279,   280,   281,    -1,   283,   284,   285,   286,   287,    -1,
     289,   290,   291,   292,    -1,     1,    -1,    -1,     4,    -1,
      -1,    -1,    -1,     9,    -1,   304,    -1,    -1,   307,   308,
      16,    -1,    -1,    19,    20,    -1,    -1,    -1,    -1,    -1,
      26,    -1,    -1,    -1,    30,    -1,    -1,    -1,    -1,    35,
      36,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    44,    45,
      46,    -1,    -1,    -1,    50,    -1,    -1,    -1,    54,    55,
      -1,    57,    -1,    59,    -1,    61,    62,    63,    64,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   133,    -1,    -1,
     136,    -1,   138,    -1,   140,    -1,   142,   143,    -1,    -1,
      -1,   147,   148,   149,    -1,   151,   152,   153,    -1,   155,
     156,   157,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   179,   180,   181,   182,   183,   184,   185,
     186,   187,   188,   189,   190,    -1,    -1,   193,    -1,    -1,
     196,    -1,   198,   199,    -1,   201,    -1,   203,    -1,    -1,
     206,    -1,    -1,   209,    -1,   211,   212,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   223,   224,    -1,
      -1,    -1,    -1,    -1,   230,   231,   232,   233,   234,    -1,
      -1,   237,    -1,   239,    -1,    -1,   242,    -1,   244,   245,
     246,    -1,   248,   249,    -1,   251,    -1,   253,   254,    -1,
      -1,   257,   258,    -1,   260,   261,   262,   263,   264,   265,
      -1,    -1,    -1,   269,   270,   271,    -1,    -1,    -1,    -1,
     276,   277,   278,   279,   280,   281,    -1,   283,   284,   285,
     286,   287,    -1,   289,   290,   291,   292,    -1,     1,    -1,
      -1,     4,    -1,    -1,    -1,    -1,     9,    -1,   304,    -1,
      -1,   307,   308,    16,    -1,    -1,    19,    20,    -1,    -1,
      -1,    -1,    -1,    26,    -1,    -1,    -1,    30,    -1,    -1,
      -1,    -1,    35,    36,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    44,    45,    46,    -1,    -1,    -1,    50,    -1,    -1,
      -1,    54,    55,    -1,    57,    -1,    59,    -1,    61,    62,
      63,    64,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     133,    -1,    -1,   136,    -1,   138,    -1,   140,    -1,   142,
     143,    -1,    -1,    -1,   147,   148,   149,    -1,   151,   152,
     153,    -1,   155,   156,   157,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   179,   180,   181,   182,
     183,   184,   185,   186,   187,   188,   189,   190,    -1,    -1,
     193,    -1,    -1,   196,    -1,   198,   199,    -1,   201,    -1,
     203,    -1,    -1,   206,    -1,    -1,   209,    -1,   211,   212,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     223,   224,    -1,    -1,    -1,    -1,    -1,   230,   231,   232,
     233,   234,    -1,    -1,   237,    -1,   239,    -1,    -1,   242,
      -1,   244,   245,   246,    -1,   248,   249,    -1,   251,    -1,
     253,   254,    -1,    -1,   257,   258,    -1,   260,   261,   262,
     263,   264,   265,    -1,    -1,    -1,   269,   270,   271,    -1,
      -1,    -1,    -1,   276,   277,   278,   279,   280,   281,    -1,
     283,   284,   285,   286,   287,    -1,   289,   290,   291,   292,
       1,    -1,    -1,     4,    -1,    -1,    -1,    -1,     9,    -1,
      -1,   304,    -1,    -1,   307,   308,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    39,    -1,
      -1,    -1,    -1,    -1,    45,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    54,    -1,    -1,    -1,    -1,    -1,    -1,
      61,    62,    -1,    -1,    -1,    -1,    67,    -1,    -1,    70,
      71,    72,    -1,    74,    -1,    76,    77,    -1,    79,    80,
      81,    -1,    83,    84,    -1,    86,    -1,    88,    89,    90,
      91,    92,    -1,    94,    -1,    96,    -1,    98,    99,   100,
      -1,   102,    -1,   104,    -1,   106,    -1,   108,   109,   110,
     111,   112,    -1,   114,   115,    -1,   117,   118,    -1,   120,
      -1,   122,    -1,   124,    -1,   126,    -1,   128,    -1,   130,
     131,   132,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
       1,   142,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   152,    -1,    -1,   155,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   179,    -1,
      -1,    -1,    -1,   184,    -1,    -1,    -1,    -1,   189,    -1,
      -1,    -1,    -1,    -1,    -1,   196,    -1,   198,   199,    -1,
      -1,    -1,    -1,    -1,    -1,   206,    -1,    -1,   209,    -1,
     211,   212,    73,   214,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   223,   224,    -1,    -1,    -1,    -1,    -1,   230,
      -1,    -1,    -1,   234,    -1,    -1,   237,    -1,   239,    -1,
      -1,   242,    -1,   244,   245,    -1,    -1,   248,   249,    -1,
     251,    -1,   253,   254,    -1,    -1,   257,   258,    -1,   260,
     261,    -1,    -1,   264,   265,   266,    -1,    -1,   269,   270,
      -1,    -1,   133,    -1,    -1,   136,    -1,    -1,    -1,   140,
      -1,   142,   143,   284,    -1,    -1,   147,   148,   149,    -1,
     151,   152,   153,    -1,   155,   156,   157,    -1,    -1,    -1,
      -1,    -1,    -1,   304,    -1,    -1,   307,   308,    -1,     1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   179,   180,
     181,   182,   183,   184,   185,   186,   187,   188,   189,   190,
      -1,    -1,   193,   194,    -1,   196,    -1,   198,    -1,    -1,
     201,    -1,   203,    -1,    -1,    -1,    -1,    -1,   209,    -1,
     211,   212,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   223,    -1,    -1,    -1,    -1,    -1,    -1,   230,
     231,   232,   233,    -1,   235,   236,    -1,   238,   239,    -1,
      -1,    -1,    -1,    -1,   245,   246,    -1,   248,    -1,    -1,
     251,    -1,   253,    -1,   255,    -1,    -1,    -1,    -1,    -1,
     261,   262,    -1,   264,   265,    -1,    -1,    -1,   269,    -1,
      -1,    -1,    -1,    -1,    -1,   276,   277,   278,   279,   280,
     281,   282,   283,   284,    -1,    -1,    -1,   288,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   298,    -1,    -1,
      -1,   133,    -1,   304,   136,    -1,   307,   308,   140,    -1,
     142,   143,    -1,    -1,    -1,   147,   148,   149,    -1,   151,
     152,   153,    -1,   155,   156,   157,    -1,    -1,    -1,    -1,
      -1,    -1,     1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   179,   180,   181,
     182,   183,   184,   185,   186,   187,   188,   189,   190,    -1,
      -1,   193,   194,    -1,   196,    -1,   198,    -1,    -1,   201,
      -1,   203,    -1,    -1,    -1,    -1,    -1,   209,    -1,   211,
     212,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   223,    -1,    -1,    -1,    -1,    -1,    -1,   230,   231,
     232,   233,    -1,   235,   236,    -1,   238,   239,    -1,    -1,
      -1,    -1,    -1,   245,   246,    -1,   248,    -1,    -1,   251,
      -1,   253,    -1,   255,    -1,    -1,    -1,    -1,    -1,   261,
     262,    -1,   264,   265,    -1,    -1,    -1,   269,    -1,    -1,
      -1,    -1,    -1,    -1,   276,   277,   278,   279,   280,   281,
     282,   283,   284,    -1,    -1,    -1,   288,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   133,    -1,   298,   136,    -1,    -1,
      -1,   140,   304,   142,   143,   307,   308,    -1,   147,   148,
     149,    -1,   151,   152,   153,    -1,   155,   156,   157,    -1,
      -1,    -1,    -1,    -1,    -1,     1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     179,   180,   181,   182,   183,   184,   185,   186,   187,   188,
     189,   190,    -1,    -1,   193,   194,    -1,   196,    -1,   198,
      -1,    -1,   201,    -1,   203,    -1,    -1,    -1,    -1,    -1,
     209,    -1,   211,   212,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   223,    -1,    -1,    -1,    -1,    -1,
      -1,   230,   231,   232,   233,    -1,   235,   236,    -1,   238,
     239,    -1,    -1,    -1,    -1,    -1,   245,   246,    -1,   248,
      -1,    -1,   251,    -1,   253,    -1,   255,    -1,    -1,    -1,
      -1,    -1,   261,   262,    -1,   264,   265,    -1,    -1,    -1,
     269,    -1,    -1,    -1,    -1,    -1,    -1,   276,   277,   278,
     279,   280,   281,   282,   283,   284,    -1,    -1,    -1,   288,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   133,    -1,   298,
     136,    -1,    -1,    -1,   140,   304,   142,   143,   307,   308,
      -1,   147,   148,   149,    -1,   151,   152,   153,    -1,   155,
     156,   157,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,     1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   179,    -1,   181,   182,   183,   184,   185,
     186,   187,   188,   189,   190,    -1,    -1,   193,   194,    -1,
     196,    -1,   198,    -1,    -1,   201,    -1,   203,    -1,    -1,
      -1,    -1,    -1,   209,    -1,   211,   212,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   230,   231,   232,   233,    -1,   235,
     236,    -1,   238,   239,    -1,    -1,    -1,    -1,    -1,   245,
     246,    -1,   248,    -1,    -1,   251,    -1,   253,    -1,   255,
      -1,    -1,    -1,    -1,    -1,   261,   262,    -1,   264,   265,
      -1,    -1,    -1,   269,    -1,    -1,    -1,    -1,    -1,    -1,
     276,   277,   278,   279,   280,   281,   282,   283,   284,    -1,
      -1,    -1,   288,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   298,    -1,    -1,    -1,   133,   303,   304,   136,
      -1,   307,   308,   140,    -1,   142,   143,    -1,    -1,    -1,
     147,   148,   149,    -1,   151,   152,   153,    -1,   155,   156,
     157,     4,    -1,    -1,    -1,    -1,     9,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   179,    -1,   181,   182,   183,   184,   185,   186,
     187,   188,   189,   190,    -1,    -1,   193,   194,    -1,   196,
      -1,   198,    45,    -1,   201,    -1,   203,    -1,    -1,    -1,
      -1,    54,   209,    -1,   211,   212,    -1,    -1,    61,    62,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      73,    -1,    -1,   230,   231,   232,   233,    -1,   235,   236,
      -1,   238,   239,    -1,    -1,    -1,    -1,    -1,   245,   246,
      -1,   248,    -1,    -1,   251,    -1,   253,    -1,   255,    -1,
      -1,    -1,    -1,    -1,   261,   262,    -1,   264,   265,    -1,
      -1,    -1,   269,    -1,    -1,    -1,    -1,    -1,    -1,   276,
     277,   278,   279,   280,   281,   282,   283,   284,    -1,    -1,
     133,   288,    -1,    -1,    -1,   138,    -1,    -1,    -1,   142,
      -1,   298,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   152,
     307,   308,   155,    -1,    -1,    -1,    -1,     4,    -1,    -1,
      -1,    -1,     9,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   179,   180,    -1,    -1,
      -1,   184,    -1,    -1,    -1,    -1,   189,   190,     1,    -1,
     193,    -1,    -1,   196,    -1,   198,   199,    -1,    45,    -1,
      -1,    14,    -1,   206,    -1,    -1,   209,    54,   211,   212,
      23,    -1,    -1,    -1,    61,    62,    -1,    -1,    -1,    -1,
     223,   224,    -1,    -1,    -1,    -1,    -1,   230,    -1,    -1,
      -1,   234,    -1,    -1,   237,    -1,    -1,    -1,    -1,   242,
      -1,   244,   245,    -1,    -1,   248,   249,    -1,   251,    -1,
     253,   254,    65,    -1,   257,   258,    -1,   260,   261,    -1,
      73,   264,   265,    -1,    -1,    -1,   269,   270,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   279,   280,   281,    -1,
     283,   284,    -1,    -1,    -1,    -1,   133,    -1,    -1,    -1,
      -1,   138,    -1,    -1,    -1,   142,    -1,    -1,    -1,    -1,
      -1,   304,    -1,    -1,    -1,   152,    -1,    -1,   155,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   132,
      -1,    -1,    -1,    -1,    -1,    19,    20,    -1,    -1,    -1,
      -1,    -1,   179,   180,    -1,   148,   149,   184,   151,    -1,
      -1,    35,   189,   190,   157,    -1,   193,    19,    20,   196,
      -1,   198,   199,    -1,    -1,    -1,    -1,    -1,    -1,   206,
      -1,    -1,   209,    35,   211,   212,    -1,    -1,    -1,   182,
      64,    -1,    -1,    -1,   187,   188,   223,   224,   191,    -1,
      -1,    -1,    -1,   230,    -1,    -1,    -1,   234,    -1,    -1,
     237,    -1,    64,    -1,    -1,   242,    -1,   244,   245,    -1,
      -1,   248,   249,    -1,   251,    -1,   253,   254,    -1,    -1,
     257,   258,    -1,   260,   261,    -1,    -1,   264,   265,    -1,
      -1,    -1,   269,   270,    -1,    -1,    -1,   240,    -1,    -1,
      -1,    -1,   279,   280,   281,    -1,   283,   284,    -1,    -1,
      -1,    -1,   136,    -1,    -1,    -1,   140,    -1,    -1,   143,
      -1,    -1,    -1,   147,    -1,     4,    -1,   304,    -1,   153,
       9,    -1,   156,    -1,   136,   278,    -1,    -1,   140,    -1,
      -1,   143,    -1,    -1,    -1,   147,    -1,    -1,    -1,    -1,
      -1,   294,    -1,    -1,    -1,    -1,   299,   181,    -1,   183,
      -1,   185,   186,    -1,    -1,    -1,    45,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    54,    -1,   201,    -1,   203,
      -1,   183,    -1,   185,   186,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   201,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   231,   232,   233,
      -1,    -1,    -1,    -1,    -1,   239,    -1,    -1,    -1,    -1,
      -1,    -1,   246,    -1,    -1,    -1,    -1,    -1,    -1,   231,
     232,   233,    -1,    -1,    -1,    -1,    -1,   239,   262,   263,
      -1,    -1,    -1,    -1,   246,     4,    -1,   271,    -1,    -1,
       9,    -1,   276,   277,   133,    -1,    -1,    -1,    -1,   138,
     262,    -1,    -1,   142,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   152,   276,   277,   155,    -1,    -1,    -1,
      39,    -1,    -1,   307,   308,    -1,    45,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    54,    -1,    -1,    -1,    -1,
     179,    -1,   304,    -1,    -1,   184,    -1,    -1,    -1,    -1,
     189,   190,    -1,    -1,   193,    -1,    -1,   196,    -1,   198,
     199,    -1,    -1,    -1,    -1,    -1,    -1,   206,    -1,    -1,
     209,    -1,   211,   212,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   223,   224,    -1,    -1,    -1,    -1,
      -1,   230,    -1,    -1,    -1,   234,    -1,    -1,   237,    -1,
      -1,    -1,    -1,   242,    -1,   244,   245,    -1,    -1,   248,
     249,     4,   251,    -1,   253,   254,     9,    -1,   257,   258,
      -1,   260,   261,   142,    -1,   264,   265,    -1,    -1,    -1,
     269,   270,    -1,   152,    -1,    -1,   155,    -1,    -1,    -1,
     279,   280,   281,    -1,   283,   284,    -1,    -1,    -1,    -1,
      -1,    -1,    45,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    54,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     189,    -1,    -1,    -1,    -1,    -1,    -1,   196,    -1,   198,
     199,    -1,    -1,    -1,    77,    -1,    -1,    -1,    -1,    -1,
     209,    -1,   211,   212,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   223,   224,    -1,    -1,    -1,    -1,
      -1,   230,    -1,    -1,    -1,   234,    -1,    -1,   237,    -1,
     239,    -1,    -1,   242,    -1,   244,   245,    -1,    -1,   248,
     249,    -1,   251,    -1,   253,   254,    -1,    -1,   257,   258,
      -1,   260,   261,    -1,    -1,   264,   265,    16,    -1,   142,
     269,   270,    -1,    -1,    -1,    -1,    -1,    26,    -1,   152,
      -1,    30,   155,    -1,    -1,   284,    -1,    36,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    44,    -1,    46,    -1,    -1,
      -1,    50,    -1,    -1,    -1,    -1,    55,    -1,    57,    -1,
      59,    -1,    -1,    -1,    63,    -1,   189,    -1,    -1,    -1,
      -1,    -1,    -1,   196,    -1,   198,   199,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   209,    -1,   211,   212,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     223,   224,    -1,    -1,    -1,    -1,    -1,   230,    -1,    -1,
      -1,   234,    -1,    -1,   237,    -1,   239,    -1,    -1,   242,
      -1,   244,   245,    -1,    -1,   248,   249,    -1,   251,    -1,
     253,   254,    -1,    -1,   257,   258,    -1,   260,   261,    -1,
      -1,   264,   265,    -1,    -1,    -1,   269,   270,    -1,   148,
     149,    -1,   151,    -1,    -1,    -1,    -1,    -1,   157,    -1,
      -1,   284,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   182,    -1,    -1,    -1,    -1,   187,   188,
      67,    -1,    -1,    70,    71,    72,    73,    74,    75,    76,
      77,    -1,    79,    80,    81,    -1,    83,    84,    -1,    86,
      -1,    88,    89,    90,    91,    92,    -1,    94,    -1,    96,
      -1,    98,    99,   100,    -1,   102,    -1,   104,    -1,   106,
      -1,   108,   109,   110,   111,    -1,    -1,   114,   115,    -1,
     117,   118,    -1,   120,    -1,   122,    -1,   124,    -1,   126,
      -1,   128,    -1,   130,   131,   132,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   278,
      -1,    -1,   159,   160,   161,    -1,   285,   286,   287,    -1,
     289,   290,   291,   292,   171,   172,    -1,    -1,    -1,    -1,
      -1,    67,    -1,   180,    70,    71,    72,    73,    74,    75,
      76,    77,    -1,    79,    80,    81,    -1,    83,    84,    -1,
      86,    -1,    88,    89,    90,    91,    92,    -1,    94,    -1,
      96,    -1,    98,    99,   100,    -1,   102,    -1,   104,    -1,
     106,    -1,   108,   109,   110,   111,    -1,    -1,   114,   115,
      -1,   117,   118,    -1,   120,    -1,   122,    -1,   124,    -1,
     126,    -1,   128,    -1,   130,   131,   132,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   159,    -1,   161,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   180,    -1,   293,   294,   295,   296,
     297,    -1,    -1,    -1,   301,    -1,   303,   304,    -1,   306,
      -1,    -1,    -1,   310,   311,   312,   313,    -1,    -1,    -1,
      67,    -1,    -1,    70,    71,    72,    73,    74,    75,    76,
      77,    -1,    79,    80,    81,    -1,    83,    84,    -1,    86,
      -1,    88,    89,    90,    91,    92,    -1,    94,    -1,    96,
      -1,    98,    99,   100,    -1,   102,    -1,   104,    -1,   106,
      -1,   108,   109,   110,   111,    -1,    -1,   114,   115,    -1,
     117,   118,    -1,   120,    -1,   122,    -1,   124,    -1,   126,
      -1,   128,    -1,   130,   131,   132,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   293,   294,   295,
     296,   297,   159,    -1,   161,   301,    -1,   303,   304,    -1,
     306,    -1,    -1,    -1,   310,   311,   312,   313,    -1,    -1,
      -1,    67,    -1,   180,    70,    71,    72,    -1,    74,    75,
      76,    77,    -1,    79,    80,    81,    -1,    83,    84,    -1,
      86,    -1,    88,    89,    90,    91,    92,    -1,    94,    -1,
      96,    -1,    98,    99,   100,    -1,   102,    -1,   104,    -1,
     106,    -1,   108,   109,   110,   111,    -1,    -1,   114,   115,
      -1,   117,   118,    -1,   120,    -1,   122,    -1,   124,    -1,
     126,    -1,   128,    -1,   130,   131,   132,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   159,    -1,   161,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   180,    -1,   293,   294,   295,   296,
     297,    -1,    -1,    -1,   301,    -1,   303,   304,    -1,   306,
      -1,    -1,    -1,   310,   311,   312,   313,    -1,    -1,    -1,
      67,    -1,    -1,    70,    71,    72,    -1,    74,    75,    76,
      77,    -1,    79,    80,    81,    -1,    83,    84,    -1,    86,
      -1,    88,    89,    90,    91,    92,    -1,    94,    -1,    96,
      -1,    98,    99,   100,    -1,   102,    -1,   104,    -1,   106,
      -1,   108,   109,   110,   111,    -1,    -1,   114,   115,    -1,
     117,   118,    -1,   120,    -1,   122,    -1,   124,    -1,   126,
      -1,   128,    -1,   130,   131,   132,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   293,   294,   295,
     296,   297,   159,    -1,   161,   301,    -1,   303,   304,    -1,
     306,    -1,    -1,    -1,   310,   311,   312,   313,    -1,    -1,
      -1,    67,    -1,   180,    70,    71,    72,    -1,    74,    75,
      76,    77,    -1,    79,    80,    81,    -1,    83,    84,    -1,
      86,    -1,    88,    89,    90,    91,    92,    -1,    94,    -1,
      96,    -1,    98,    99,   100,    -1,   102,    -1,   104,    -1,
     106,    -1,   108,   109,   110,   111,    -1,    -1,   114,   115,
      -1,   117,   118,    -1,   120,    -1,   122,    -1,   124,    -1,
     126,    -1,   128,    -1,   130,   131,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   159,    -1,   161,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   180,    -1,   293,   294,   295,   296,
     297,    -1,    -1,    -1,   301,    -1,   303,   304,    -1,   306,
      -1,    -1,    -1,   310,   311,   312,   313,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    80,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   133,    -1,    -1,   136,    -1,    -1,    -1,   140,
      -1,   142,   143,    -1,    -1,    -1,   147,   148,   149,    -1,
     151,   152,   153,    -1,   155,   156,   157,   293,   294,   295,
     296,   297,    -1,    -1,    -1,   301,    -1,   303,   304,    -1,
     306,    -1,    -1,    -1,   310,   311,   312,   313,   179,    -1,
     181,   182,   183,   184,   185,   186,   187,   188,   189,   190,
      -1,    -1,   193,   194,    -1,   196,    -1,   198,    -1,    -1,
     201,    -1,   203,    -1,    -1,    -1,    -1,    -1,   209,    -1,
     211,   212,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   230,
     231,   232,   233,    -1,   235,   236,    -1,   238,   239,    -1,
      -1,    -1,    -1,    -1,   245,   246,    -1,   248,    -1,    -1,
     251,    -1,   253,    -1,   255,    -1,    -1,    -1,    -1,    -1,
     261,   262,    -1,   264,   265,    -1,    -1,    -1,   269,    -1,
      -1,    -1,    -1,    -1,    -1,   276,   277,   278,   279,   280,
     281,   282,   283,   284,    -1,    -1,    -1,   288,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   133,    -1,   298,   136,    -1,
      -1,    -1,   140,    -1,   142,   143,   307,   308,    -1,   147,
     148,   149,    -1,   151,   152,   153,    -1,   155,   156,   157,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   179,    -1,   181,   182,   183,   184,   185,   186,   187,
     188,   189,   190,    -1,    -1,   193,   194,    -1,   196,    -1,
     198,    -1,    -1,   201,    -1,   203,    -1,    -1,    -1,    -1,
      -1,   209,    -1,   211,   212,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   230,   231,   232,   233,    -1,   235,   236,    -1,
     238,   239,    -1,    -1,    -1,    -1,    -1,   245,   246,    -1,
     248,    -1,    -1,   251,    -1,   253,    -1,   255,    -1,    -1,
      -1,    -1,    -1,   261,   262,    -1,   264,   265,    -1,    -1,
      -1,   269,    -1,    -1,    -1,    -1,    -1,    -1,   276,   277,
     278,   279,   280,   281,   282,   283,   284,   136,    -1,    -1,
     288,   140,    -1,    -1,   143,    -1,    -1,    -1,   147,   148,
     298,    -1,   151,    -1,    -1,    -1,    -1,    -1,   157,   307,
     308,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   182,   183,    -1,   185,   186,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   133,    -1,    -1,    -1,    -1,
      -1,    -1,   201,    -1,   142,    -1,    -1,    -1,    -1,    -1,
     148,   149,    -1,   151,   152,    -1,    -1,   155,    -1,   157,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   231,   232,   233,    -1,   235,   236,    -1,    -1,
     239,   179,    -1,    -1,   182,    -1,   184,   246,    -1,   187,
     188,   189,   190,    -1,    -1,   193,    -1,    -1,   196,    -1,
     198,    -1,    -1,   262,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   209,    -1,   211,   212,    -1,    -1,   276,   277,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   230,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     238,    -1,    -1,    -1,    -1,    -1,    -1,   245,   307,   308,
     248,    -1,    -1,   251,    -1,   253,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   261,    -1,    -1,   264,   265,    -1,    -1,
      -1,   269,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     278,   279,   280,   281,   282,   283,   284,    -1,    -1,    -1,
     288
};

/* YYSTOS[STATE-NUM] -- The symbol kind of the accessing symbol of
   state STATE-NUM.  */
static const yytype_int16 yystos[] =
{
       0,   315,     0,     1,     3,     5,     6,     7,     8,    10,
      11,    12,    13,    33,   152,   153,   155,   156,   159,   179,
     181,   189,   203,   204,   208,   213,   220,   221,   222,   229,
     294,   299,   313,   316,   317,   318,   319,   334,   335,   354,
     356,   357,   360,   370,   371,   372,   376,   382,   383,   384,
     389,   397,   398,   401,   403,   419,   422,   429,   430,   536,
     544,   545,   697,   717,   304,   307,   308,   640,   643,   649,
     654,   657,   660,     1,    67,    70,    71,    72,    74,    76,
      77,    79,    80,    81,    83,    84,    86,    88,    89,    90,
      91,    92,    94,    96,    98,    99,   100,   102,   104,   106,
     108,   109,   110,   111,   112,   114,   115,   117,   118,   120,
     122,   124,   126,   128,   130,   131,   132,   206,   214,   266,
     331,   654,   659,   676,     1,   654,   656,     1,     3,   670,
     670,   305,   373,   374,     1,    15,    53,    61,   304,   380,
     643,     1,   304,   670,   228,   725,     1,   162,   163,   164,
     165,   166,   167,   168,   169,   170,   173,   174,   175,   176,
     177,   361,   369,   670,   543,   544,     1,   213,   696,   431,
     358,   717,   656,   717,   717,   717,   717,     1,    72,    74,
      80,   133,   136,   140,   142,   143,   147,   148,   149,   151,
     152,   155,   157,   178,   179,   182,   183,   184,   185,   186,
     187,   188,   189,   190,   191,   193,   194,   196,   198,   201,
     209,   211,   212,   216,   228,   230,   231,   232,   233,   235,
     236,   238,   239,   240,   245,   246,   248,   251,   253,   255,
     261,   262,   264,   265,   269,   276,   277,   278,   279,   280,
     281,   282,   283,   284,   288,   298,   304,   385,   387,   389,
     390,   393,   395,   396,   413,   419,   420,   428,   445,   447,
     448,   450,   477,   478,   480,   488,   515,   517,   518,   519,
     520,   521,   522,   524,   525,   526,   527,   528,   530,   532,
     533,   534,   535,   536,   545,   548,   549,   551,   553,   554,
     556,   564,   566,   567,   576,   577,   643,   648,   649,   683,
     684,   688,   732,   717,   299,   717,   717,   717,   717,   717,
     717,   402,   399,   404,    47,   699,   700,   701,    67,     1,
      17,    38,    60,   664,    67,     1,    73,   712,     1,    75,
     707,    74,    74,     4,     9,    39,    45,    54,   142,   152,
     155,   189,   196,   198,   199,   209,   211,   212,   223,   224,
     230,   234,   237,   239,   242,   244,   245,   248,   249,   251,
     253,   254,   257,   258,   260,   261,   264,   265,   269,   270,
     284,   332,   333,   550,   604,     1,    17,   132,   663,   320,
     663,   114,   375,   374,    53,    61,   381,    43,   302,   685,
     686,    17,    31,   155,   229,   377,   379,    67,    70,    71,
      72,    73,    74,    75,    76,    77,    79,    80,    81,    83,
      84,    86,    88,    89,    90,    91,    92,    94,    96,    98,
      99,   100,   102,   104,   106,   108,   109,   110,   111,   114,
     115,   117,   118,   120,   122,   124,   126,   128,   130,   131,
     132,   159,   161,   180,   293,   294,   295,   296,   297,   301,
     303,   304,   306,   310,   311,   312,   313,   336,   337,   346,
     347,   348,   349,   353,   423,     1,   304,   645,   645,     1,
     304,   307,   638,   639,     1,   159,   304,   359,   646,   664,
     189,   230,   477,   515,   683,    79,    80,   114,   223,   304,
     414,   415,   416,   546,   547,   548,   564,   306,   309,   607,
     719,     1,    72,   693,   693,    67,   355,   693,    74,   550,
      74,   552,   568,   578,     1,   239,   666,    72,   469,     1,
      98,   694,   391,   693,   132,   479,   421,   518,   520,   516,
     517,   693,   550,   555,   556,   555,   567,   577,    67,   529,
     215,   430,   205,   207,   309,   680,    83,     1,   640,   641,
     641,     1,   304,   406,   407,   408,   643,     1,    58,   545,
     697,   713,   714,   699,   304,   643,     4,     9,    45,    54,
      61,    62,   133,   138,   142,   152,   155,   180,   189,   193,
     198,   199,   206,   209,   211,   212,   223,   224,   230,   245,
     248,   249,   251,   253,   264,   265,   269,   279,   280,   281,
     284,   304,   549,   551,   581,   600,   601,   602,   603,   604,
     605,   609,   616,   617,   649,   655,   730,   643,   649,   707,
     707,    32,    34,    37,   606,   150,   247,   256,   274,    24,
      74,   324,     1,   230,   731,   607,     1,   200,   692,     1,
     243,   679,     1,   259,   729,   549,   730,   656,   321,   581,
     701,   581,     1,   305,    17,   379,     1,   377,   378,     1,
      72,   132,   341,   342,   343,   344,   345,   346,    72,   337,
     338,   339,   340,   515,    72,   362,   555,     1,   304,   304,
     581,   712,   386,   304,     1,   223,   721,    75,     1,   132,
     674,   548,   563,   564,   548,   295,     1,   719,   720,   515,
     420,     1,   303,   726,   727,   557,    79,   110,   708,     1,
      75,    80,   726,   693,   693,   451,   515,   725,     1,   515,
     649,   726,    72,    79,    80,   110,   180,   286,   287,   289,
     290,   291,   292,   434,   435,   437,   439,   440,   441,   443,
     449,   471,   473,   474,   476,   481,   483,   484,   486,   487,
     488,   490,   528,   591,   640,   643,   648,   649,   650,   437,
     433,   434,     1,   515,   640,   641,   642,   641,   642,   640,
     515,   693,   693,   639,   293,   537,   400,   405,    67,    67,
     641,   606,   247,   731,     1,    29,   678,   607,   692,    80,
     610,   726,   701,    16,    26,    30,    50,    55,    57,    59,
      63,   285,   519,   582,   585,   586,   587,   589,   590,   591,
     597,   611,   612,   613,   614,   615,   618,   619,   620,   621,
     603,    17,     1,    42,   691,     1,   275,   661,     1,    72,
      74,   325,    28,    55,   326,   327,   328,   416,    72,   592,
     593,    41,   608,     1,    27,   675,    14,    65,   191,   240,
     322,   323,   330,   663,   378,    72,   350,   351,   352,   353,
      73,   132,   343,   342,   345,   340,   424,     1,   180,   304,
     363,   364,   365,    72,    73,   132,   160,   171,   172,   346,
     366,   367,   368,     1,   114,   682,    72,   180,   476,   483,
     486,   491,   492,   493,   494,   495,   496,   498,   499,   501,
     503,   505,   650,   468,   469,   416,   563,   712,   523,   712,
     229,   558,     1,    74,   690,    75,   707,   707,   693,     1,
     304,   571,   579,   580,   180,   223,   304,   463,   464,   465,
     644,   722,   388,   392,    73,   394,   712,   712,   108,   472,
     546,     1,   649,   650,   132,    74,   442,   469,   475,   482,
     546,   293,   651,   438,   439,   449,   474,    69,   215,   651,
     565,   566,   531,   537,   295,   295,   489,   463,     1,   446,
     693,     1,   148,   151,   157,   182,   524,   528,   530,   538,
     540,   541,   542,   295,   410,   411,     1,   409,   411,   189,
     304,   643,   189,   643,   649,   608,    80,   304,   583,   726,
     592,    72,   588,     1,    60,   723,     1,    55,   709,     1,
      18,   667,    40,   584,   592,    44,    46,   695,   723,    19,
      20,    35,    64,   136,   140,   143,   147,   183,   185,   186,
     201,   231,   232,   233,   239,   246,   262,   263,   271,   276,
     277,   528,   536,   545,   622,   623,   624,   625,   626,   627,
     628,   631,   632,   621,   581,   693,   326,   326,    22,   138,
     329,    60,   329,    75,   674,   581,   594,   595,    56,   150,
     598,   599,   710,   215,   703,    17,    60,   665,   727,     1,
     581,   726,   601,   350,    73,   352,   338,   342,   344,   425,
     426,   437,    73,   674,   368,   515,   108,   500,   650,   502,
     504,   506,   442,   712,   469,   331,   463,   491,   645,     1,
     234,   237,   244,   254,   257,   260,   261,   270,   559,   560,
     561,   649,   649,   658,   569,   570,   571,    72,   572,    73,
     571,    73,   452,   470,   674,   515,   491,   420,   491,   444,
     437,     1,   435,   436,     1,   152,   304,   546,   547,   707,
     726,   565,   463,   437,   437,   485,   727,    80,   676,   681,
     720,   491,   476,   483,   486,   507,   508,   509,   511,   513,
     650,   452,   452,   446,   541,   542,   539,   540,     1,   296,
     397,   412,   422,   429,   645,   645,     1,    47,   698,   446,
       1,    44,   581,     1,    16,   662,   598,    36,   581,    51,
     630,     1,   147,   689,     1,    49,   704,     1,   136,   671,
     726,   728,    52,   705,   656,     1,   272,   629,   641,   641,
       1,    65,    72,   726,   594,    73,    75,     1,   138,   677,
     645,   328,    73,   674,     1,   581,   701,    19,    21,   668,
      23,   669,   669,    55,    57,   597,    73,   132,   365,   432,
     497,   491,   491,   491,   491,   649,   653,   463,    77,   417,
     470,   712,     1,   293,   673,    72,   562,   562,    75,   674,
     132,   707,    73,   674,    72,   297,   303,   304,   306,   309,
     573,   574,   575,   224,   249,   456,   453,     1,   465,   467,
     466,     1,    99,   687,   712,   546,   712,    75,   546,   707,
      80,   152,   707,   718,   707,   452,   437,   550,   469,   645,
     712,   510,   512,   514,   693,   456,   456,   452,   539,   294,
     716,     1,   294,   715,   715,   581,    73,   698,   304,   647,
     592,   689,   271,    47,   633,   727,   727,   668,    73,     1,
     581,   596,     1,   710,   711,   709,   695,     1,   426,   427,
     491,   546,   712,   452,   515,   720,   707,   561,   649,   712,
     571,   574,    73,   674,   693,    72,   114,   460,   454,   491,
     693,   437,   304,   726,   707,   304,   726,   708,   463,   693,
     507,   507,   507,   452,   565,   565,   456,     1,   296,   706,
       1,   545,   672,   698,   598,   629,   155,   724,   668,   712,
     598,   581,     1,   215,   702,   491,   456,   418,   712,     1,
     712,   575,   464,   712,     1,   210,   225,   457,     1,   138,
     206,   726,   248,   251,   283,   455,   549,     1,   649,   652,
     712,   707,   707,   707,   707,   456,   452,     1,   462,   464,
     456,   565,   656,   581,   541,   634,   635,   636,   592,   712,
      77,   458,   566,   491,    73,   712,    72,   461,   712,   693,
     458,   708,    73,   460,   460,   581,   304,   623,   637,   655,
     541,   598,   469,   515,   720,   463,   460,   456,   456,   463,
     459,   712,    73,   458,   458,   470,   491,   565,   460
};

/* YYR1[RULE-NUM] -- Symbol kind of the left-hand side of rule RULE-NUM.  */
static const yytype_int16 yyr1[] =
{
       0,   314,   315,   315,   316,   316,   316,   316,   316,   316,
     316,   316,   316,   316,   316,   316,   316,   316,   316,   316,
     317,   317,   318,   318,   318,   318,   318,   319,   320,   319,
     319,   319,   319,   321,   321,   321,   322,   322,   322,   323,
     323,   323,   324,   324,   324,   325,   325,   325,   326,   326,
     327,   327,   328,   328,   328,   328,   329,   329,   329,   330,
     331,   331,   332,   332,   333,   333,   333,   333,   333,   333,
     333,   333,   333,   333,   333,   333,   333,   333,   333,   333,
     333,   333,   333,   333,   333,   333,   333,   333,   333,   333,
     333,   334,   335,   335,   336,   336,   336,   337,   337,   338,
     338,   339,   339,   340,   340,   341,   341,   341,   341,   341,
     341,   341,   342,   342,   343,   343,   344,   344,   345,   345,
     346,   346,   346,   346,   346,   346,   346,   347,   347,   348,
     348,   348,   349,   349,   349,   349,   349,   349,   349,   349,
     349,   349,   349,   349,   349,   349,   349,   349,   349,   349,
     349,   349,   349,   349,   349,   349,   349,   349,   349,   349,
     349,   349,   349,   349,   349,   349,   349,   349,   349,   349,
     349,   349,   349,   349,   349,   349,   349,   349,   349,   349,
     350,   350,   351,   351,   352,   352,   353,   353,   354,   354,
     354,   354,   354,   354,   354,   354,   354,   354,   354,   354,
     355,   354,   354,   354,   354,   354,   356,   358,   357,   359,
     359,   359,   359,   359,   360,   360,   360,   360,   360,   360,
     360,   360,   360,   360,   360,   360,   360,   360,   360,   360,
     361,   362,   362,   363,   363,   364,   364,   365,   365,   365,
     366,   366,   367,   367,   368,   368,   368,   368,   368,   368,
     368,   369,   370,   371,   372,   372,   373,   373,   374,   375,
     375,   375,   376,   376,   376,   376,   376,   376,   376,   377,
     377,   377,   378,   378,   379,   379,   380,   380,   380,   380,
     381,   381,   381,   382,   383,   384,   386,   385,   385,   388,
     387,   389,   389,   389,   389,   391,   392,   390,   393,   393,
     394,   393,   393,   395,   395,   396,   397,   397,   397,   399,
     400,   398,   402,   401,   404,   405,   403,   406,   406,   406,
     407,   407,   407,   407,   408,   408,   408,   408,   409,   409,
     410,   410,   411,   411,   412,   412,   412,   412,   413,   414,
     414,   415,   415,   416,   416,   416,   416,   416,   416,   417,
     418,   417,   419,   421,   420,   423,   424,   422,   425,   425,
     426,   427,   427,   428,   429,   431,   432,   430,   433,   433,
     434,   434,   435,   436,   436,   437,   437,   437,   437,   437,
     438,   438,   439,   439,   439,   439,   439,   439,   439,   439,
     439,   439,   440,   440,   441,   442,   442,   442,   442,   442,
     442,   442,   442,   442,   442,   444,   443,   445,   446,   446,
     447,   448,   449,   451,   450,   453,   452,   454,   454,   455,
     455,   455,   455,   456,   456,   456,   456,   456,   457,   457,
     457,   458,   459,   458,   458,   460,   460,   460,   460,   460,
     461,   461,   462,   462,   463,   463,   464,   464,   466,   465,
     465,   465,   467,   467,   468,   468,   469,   470,   472,   471,
     473,   475,   474,   476,   477,   477,   479,   478,   480,   482,
     481,   483,   485,   484,   486,   486,   487,   489,   488,   490,
     491,   491,   492,   492,   492,   492,   493,   493,   493,   493,
     493,   493,   494,   494,   495,   497,   496,   498,   500,   499,
     502,   501,   504,   503,   506,   505,   507,   507,   508,   508,
     508,   508,   510,   509,   512,   511,   514,   513,   515,   515,
     515,   516,   516,   517,   517,   518,   518,   518,   518,   519,
     519,   519,   519,   519,   519,   519,   519,   520,   520,   521,
     521,   521,   521,   521,   521,   523,   522,   524,   524,   525,
     525,   525,   525,   525,   525,   525,   525,   525,   525,   525,
     525,   525,   525,   525,   526,   527,   528,   529,   529,   531,
     530,   530,   532,   532,   533,   533,   534,   534,   535,   535,
     536,   537,   537,   537,   538,   538,   538,   539,   539,   540,
     540,   541,   541,   541,   541,   542,   542,   542,   543,   543,
     544,   544,   545,   545,   546,   546,   547,   547,   547,   548,
     548,   548,   548,   548,   548,   548,   549,   549,   550,   550,
     551,   551,   552,   552,   552,   552,   553,   553,   553,   553,
     553,   553,   553,   553,   553,   553,   553,   553,   553,   553,
     553,   553,   553,   553,   553,   553,   554,   554,   555,   555,
     557,   556,   556,   558,   558,   559,   559,   560,   560,   561,
     561,   561,   561,   561,   561,   561,   561,   561,   561,   562,
     562,   563,   563,   564,   564,   565,   565,   566,   566,   568,
     567,   569,   569,   570,   570,   571,   571,   572,   572,   573,
     573,   574,   574,   575,   575,   575,   575,   575,   575,   576,
     576,   578,   577,   579,   579,   580,   580,   581,   581,   581,
     582,   582,   583,   583,   583,   583,   584,   584,   585,   586,
     587,   588,   588,   589,   590,   590,   591,   591,   591,   591,
     591,   591,   592,   592,   593,   594,   594,   595,   595,   596,
     596,   597,   597,   597,   598,   598,   599,   599,   600,   601,
     601,   602,   602,   603,   603,   603,   604,   604,   604,   604,
     604,   604,   604,   604,   604,   604,   604,   604,   604,   604,
     605,   605,   605,   605,   605,   605,   605,   605,   605,   605,
     605,   605,   605,   605,   605,   605,   605,   605,   605,   605,
     605,   605,   605,   605,   605,   605,   605,   605,   605,   606,
     606,   606,   607,   608,   608,   609,   609,   609,   609,   609,
     609,   609,   610,   610,   611,   611,   611,   611,   611,   611,
     611,   611,   611,   612,   612,   612,   613,   614,   614,   615,
     616,   617,   617,   617,   618,   618,   619,   619,   620,   620,
     621,   622,   622,   622,   622,   622,   622,   623,   623,   624,
     624,   624,   624,   624,   624,   624,   624,   624,   624,   624,
     624,   624,   624,   624,   624,   624,   625,   625,   625,   625,
     626,   626,   626,   627,   627,   628,   629,   629,   630,   630,
     631,   632,   633,   633,   634,   634,   635,   635,   636,   636,
     637,   637,   638,   638,   639,   639,   640,   640,   641,   641,
     642,   642,   643,   643,   644,   645,   645,   646,   646,   647,
     647,   648,   648,   649,   649,   649,   650,   651,   651,   652,
     652,   653,   653,   654,   655,   656,   656,   657,   657,   658,
     658,   659,   659,   660,   660,   660,   661,   661,   662,   662,
     663,   663,   664,   664,   664,   664,   665,   665,   665,   666,
     666,   667,   667,   668,   668,   668,   669,   669,   670,   670,
     671,   671,   672,   672,   673,   673,   674,   674,   675,   675,
     676,   676,   676,   676,   676,   676,   676,   676,   676,   676,
     676,   676,   676,   676,   676,   676,   676,   676,   676,   676,
     676,   676,   676,   676,   676,   676,   676,   676,   676,   676,
     676,   676,   676,   676,   676,   676,   676,   676,   676,   676,
     676,   676,   676,   676,   676,   676,   676,   676,   677,   677,
     678,   678,   679,   679,   680,   680,   681,   682,   682,   683,
     683,   684,   684,   685,   686,   686,   687,   687,   688,   688,
     689,   689,   690,   690,   691,   691,   692,   692,   693,   693,
     694,   694,   695,   695,   695,   696,   696,   697,   697,   698,
     698,   699,   700,   700,   701,   701,   702,   702,   703,   703,
     704,   704,   705,   705,   706,   706,   707,   707,   708,   708,
     708,   709,   709,   710,   710,   711,   711,   712,   712,   713,
     713,   713,   714,   714,   715,   715,   716,   716,   717,   717,
     718,   718,   719,   719,   720,   720,   721,   721,   722,   722,
     723,   723,   724,   724,   725,   725,   726,   727,   727,   728,
     728,   729,   729,   730,   730,   731,   731,   732,   732
};

/* YYR2[RULE-NUM] -- Number of symbols on the right-hand side of rule RULE-NUM.  */
static const yytype_int8 yyr2[] =
{
       0,     2,     0,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     1,     2,     2,     2,     2,     2,     1,     1,
       4,     4,     2,     2,     2,     2,     1,     4,     0,    11,
       6,     9,     2,     1,     2,     2,     3,     3,     2,     2,
       1,     1,     0,     2,     3,     3,     3,     1,     0,     1,
       3,     1,     2,     2,     3,     1,     0,     2,     1,     3,
       0,     2,     1,     1,     1,     1,     2,     1,     1,     1,
       1,     1,     1,     3,     1,     1,     1,     1,     2,     1,
       1,     1,     1,     1,     2,     1,     1,     1,     1,     1,
       2,     4,     3,     2,     0,     2,     4,     1,     1,     0,
       1,     2,     1,     1,     1,     0,     1,     1,     2,     3,
       2,     1,     2,     1,     3,     1,     2,     1,     1,     3,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       0,     1,     2,     1,     1,     3,     1,     1,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       0,     4,     2,     3,     2,     2,     1,     0,     3,     0,
       1,     2,     2,     1,     1,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       4,     0,     3,     0,     1,     3,     1,     1,     1,     1,
       0,     1,     2,     1,     1,     1,     1,     1,     1,     1,
       1,     2,     1,     1,     1,     2,     2,     1,     2,     0,
       2,     2,     3,     4,     4,     5,     3,     2,     2,     1,
       1,     1,     1,     1,     0,     1,     0,     2,     1,     1,
       0,     1,     1,     1,     1,     1,     0,     6,     3,     0,
       9,     1,     1,     1,     1,     0,     0,     5,     4,     4,
       0,     6,     4,     1,     1,     4,     1,     1,     1,     0,
       0,     5,     0,     4,     0,     0,     5,     1,     1,     1,
       3,     3,     4,     1,     3,     3,     4,     1,     1,     1,
       0,     1,     2,     4,     1,     2,     2,     1,     6,     0,
       1,     3,     1,     1,     2,     1,     1,     1,     2,     0,
       0,     4,     1,     0,     3,     0,     0,     6,     3,     1,
       1,     1,     1,     1,     1,     0,     0,     8,     0,     1,
       3,     1,     1,     1,     1,     1,     1,     1,     1,     2,
       1,     1,     1,     1,     1,     1,     1,     1,     2,     1,
       1,     1,     2,     2,     3,     2,     3,     3,     3,     5,
       5,     4,     5,     5,     3,     0,    10,     9,     0,     1,
       7,     7,     8,     0,     7,     0,     3,     0,     2,     1,
       1,     1,     1,     0,     1,     4,     3,     4,     1,     1,
       1,     0,     0,     4,     1,     0,     2,     3,     2,     2,
       0,     3,     1,     1,     0,     1,     3,     1,     0,     4,
       1,     1,     1,     1,     0,     3,     1,     1,     0,     4,
      10,     0,     3,     2,     3,     1,     0,     3,     2,     0,
       3,     4,     0,     4,     1,     1,     2,     0,     9,     9,
       0,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     2,     2,     0,     9,     6,     0,     4,
       0,     3,     0,     3,     0,     3,     0,     1,     1,     1,
       1,     1,     0,     3,     0,     3,     0,     3,     1,     2,
       1,     0,     1,     2,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     2,     2,     1,
       1,     1,     1,     1,     1,     0,     6,     1,     4,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     2,     6,     2,     0,     2,     0,
       6,     3,     1,     1,     1,     1,     3,     4,     4,     4,
       2,     0,     2,     2,     1,     3,     2,     0,     1,     2,
       1,     1,     1,     1,     1,     1,     1,     1,     0,     1,
       1,     1,     1,     1,     0,     1,     3,     2,     2,     1,
       1,     1,     1,     1,     2,     1,     1,     1,     0,     2,
       1,     1,     2,     3,     3,     3,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     0,     1,
       0,     7,     1,     0,     3,     0,     1,     3,     1,     1,
       2,     1,     2,     1,     1,     1,     1,     1,     1,     0,
       3,     0,     1,     1,     1,     0,     1,     2,     1,     0,
       7,     0,     1,     3,     1,     2,     1,     0,     3,     0,
       1,     3,     1,     1,     1,     1,     1,     3,     1,     2,
       1,     0,     5,     0,     1,     2,     1,     1,     1,     1,
       4,     6,     0,     1,     1,     1,     0,     1,     3,     2,
       2,     0,     3,     5,     1,     1,     1,     1,     1,     1,
       1,     1,     0,     1,     3,     0,     1,     3,     1,     1,
       1,     0,     1,     2,     0,     1,     2,     2,     2,     0,
       1,     2,     1,     1,     1,     1,     2,     1,     1,     2,
       1,     2,     1,     2,     1,     1,     3,     1,     1,     1,
       1,     1,     2,     1,     1,     1,     1,     1,     1,     1,
       1,     3,     1,     1,     1,     1,     2,     1,     1,     1,
       1,     1,     2,     1,     1,     1,     1,     1,     2,     1,
       1,     1,     1,     0,     1,     1,     1,     1,     1,     1,
       2,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     3,     7,     3,     3,     1,     2,     2,
       6,     3,     1,     1,     2,     1,     0,     1,     2,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     2,     1,     1,     1,     1,     1,     2,
       1,     1,     2,     2,     1,     1,     3,     4,     4,     2,
       1,     2,     3,     2,     4,     2,     1,     1,     0,     1,
       2,     3,     0,     3,     2,     1,     0,     1,     2,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       0,     1,     1,     1,     1,     1,     1,     2,     1,     0,
       1,     0,     2,     3,     3,     1,     2,     0,     2,     1,
       1,     0,     1,     2,     2,     1,     1,     0,     1,     3,
       1,     3,     1,     3,     3,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     0,     1,     1,     1,
       1,     1,     1,     0,     1,     1,     0,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     3,     1,     3,     1,     1,     1,     1,     1,
       1,     1,     2,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     2,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     2,
       3,     0,     1,     1,     0,     1,     1,     1,     0,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     0,     1,     1,     1,     1,     1,     2,     1,
       1,     3,     2,     1,     0,     1,     1,     1,     0,     1,
       1,     1,     0,     1,     1,     1,     1,     1,     0,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     0,     1,     1,     1,
       0,     1,     1,     1,     1,     1,     1,     1,     0,     1,
       1,     1,     0,     1,     0,     1,     1,     1,     1,     0,
       1,     1,     1,     1,     2,     1,     1,     0,     1
};


enum { YYENOMEM = -2 };

#define yyerrok         (yyerrstatus = 0)
#define yyclearin       (yychar = YYEMPTY)

#define YYACCEPT        goto yyacceptlab
#define YYABORT         goto yyabortlab
#define YYERROR         goto yyerrorlab
#define YYNOMEM         goto yyexhaustedlab


#define YYRECOVERING()  (!!yyerrstatus)

#define YYBACKUP(Token, Value)                                    \
  do                                                              \
    if (yychar == YYEMPTY)                                        \
      {                                                           \
        yychar = (Token);                                         \
        yylval = (Value);                                         \
        YYPOPSTACK (yylen);                                       \
        yystate = *yyssp;                                         \
        goto yybackup;                                            \
      }                                                           \
    else                                                          \
      {                                                           \
        yyerror (YY_("syntax error: cannot back up")); \
        YYERROR;                                                  \
      }                                                           \
  while (0)

/* Backward compatibility with an undocumented macro.
   Use YYerror or YYUNDEF. */
#define YYERRCODE YYUNDEF

/* YYLLOC_DEFAULT -- Set CURRENT to span from RHS[1] to RHS[N].
   If N is 0, then set CURRENT to the empty location which ends
   the previous symbol: RHS[0] (always defined).  */

#ifndef YYLLOC_DEFAULT
# define YYLLOC_DEFAULT(Current, Rhs, N)                                \
    do                                                                  \
      if (N)                                                            \
        {                                                               \
          (Current).first_line   = YYRHSLOC (Rhs, 1).first_line;        \
          (Current).first_column = YYRHSLOC (Rhs, 1).first_column;      \
          (Current).last_line    = YYRHSLOC (Rhs, N).last_line;         \
          (Current).last_column  = YYRHSLOC (Rhs, N).last_column;       \
        }                                                               \
      else                                                              \
        {                                                               \
          (Current).first_line   = (Current).last_line   =              \
            YYRHSLOC (Rhs, 0).last_line;                                \
          (Current).first_column = (Current).last_column =              \
            YYRHSLOC (Rhs, 0).last_column;                              \
        }                                                               \
    while (0)
#endif

#define YYRHSLOC(Rhs, K) ((Rhs)[K])


/* Enable debugging if requested.  */
#if YYDEBUG

# ifndef YYFPRINTF
#  include <stdio.h> /* INFRINGES ON USER NAME SPACE */
#  define YYFPRINTF fprintf
# endif

# define YYDPRINTF(Args)                        \
do {                                            \
  if (yydebug)                                  \
    YYFPRINTF Args;                             \
} while (0)


/* YYLOCATION_PRINT -- Print the location on the stream.
   This macro was not mandated originally: define only if we know
   we won't break user code: when these are the locations we know.  */

# ifndef YYLOCATION_PRINT

#  if defined YY_LOCATION_PRINT

   /* Temporary convenience wrapper in case some people defined the
      undocumented and private YY_LOCATION_PRINT macros.  */
#   define YYLOCATION_PRINT(File, Loc)  YY_LOCATION_PRINT(File, *(Loc))

#  elif defined YYLTYPE_IS_TRIVIAL && YYLTYPE_IS_TRIVIAL

/* Print *YYLOCP on YYO.  Private, do not rely on its existence. */

YY_ATTRIBUTE_UNUSED
static int
yy_location_print_ (FILE *yyo, YYLTYPE const * const yylocp)
{
  int res = 0;
  int end_col = 0 != yylocp->last_column ? yylocp->last_column - 1 : 0;
  if (0 <= yylocp->first_line)
    {
      res += YYFPRINTF (yyo, "%d", yylocp->first_line);
      if (0 <= yylocp->first_column)
        res += YYFPRINTF (yyo, ".%d", yylocp->first_column);
    }
  if (0 <= yylocp->last_line)
    {
      if (yylocp->first_line < yylocp->last_line)
        {
          res += YYFPRINTF (yyo, "-%d", yylocp->last_line);
          if (0 <= end_col)
            res += YYFPRINTF (yyo, ".%d", end_col);
        }
      else if (0 <= end_col && yylocp->first_column < end_col)
        res += YYFPRINTF (yyo, "-%d", end_col);
    }
  return res;
}

#   define YYLOCATION_PRINT  yy_location_print_

    /* Temporary convenience wrapper in case some people defined the
       undocumented and private YY_LOCATION_PRINT macros.  */
#   define YY_LOCATION_PRINT(File, Loc)  YYLOCATION_PRINT(File, &(Loc))

#  else

#   define YYLOCATION_PRINT(File, Loc) ((void) 0)
    /* Temporary convenience wrapper in case some people defined the
       undocumented and private YY_LOCATION_PRINT macros.  */
#   define YY_LOCATION_PRINT  YYLOCATION_PRINT

#  endif
# endif /* !defined YYLOCATION_PRINT */


# define YY_SYMBOL_PRINT(Title, Kind, Value, Location)                    \
do {                                                                      \
  if (yydebug)                                                            \
    {                                                                     \
      YYFPRINTF (stderr, "%s ", Title);                                   \
      yy_symbol_print (stderr,                                            \
                  Kind, Value, Location); \
      YYFPRINTF (stderr, "\n");                                           \
    }                                                                     \
} while (0)


/*-----------------------------------.
| Print this symbol's value on YYO.  |
`-----------------------------------*/

static void
yy_symbol_value_print (FILE *yyo,
                       yysymbol_kind_t yykind, YYSTYPE const * const yyvaluep, YYLTYPE const * const yylocationp)
{
  FILE *yyoutput = yyo;
  YY_USE (yyoutput);
  YY_USE (yylocationp);
  if (!yyvaluep)
    return;
  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  YY_USE (yykind);
  YY_IGNORE_MAYBE_UNINITIALIZED_END
}


/*---------------------------.
| Print this symbol on YYO.  |
`---------------------------*/

static void
yy_symbol_print (FILE *yyo,
                 yysymbol_kind_t yykind, YYSTYPE const * const yyvaluep, YYLTYPE const * const yylocationp)
{
  YYFPRINTF (yyo, "%s %s (",
             yykind < YYNTOKENS ? "token" : "nterm", yysymbol_name (yykind));

  YYLOCATION_PRINT (yyo, yylocationp);
  YYFPRINTF (yyo, ": ");
  yy_symbol_value_print (yyo, yykind, yyvaluep, yylocationp);
  YYFPRINTF (yyo, ")");
}

/*------------------------------------------------------------------.
| yy_stack_print -- Print the state stack from its BOTTOM up to its |
| TOP (included).                                                   |
`------------------------------------------------------------------*/

static void
yy_stack_print (yy_state_t *yybottom, yy_state_t *yytop)
{
  YYFPRINTF (stderr, "Stack now");
  for (; yybottom <= yytop; yybottom++)
    {
      int yybot = *yybottom;
      YYFPRINTF (stderr, " %d", yybot);
    }
  YYFPRINTF (stderr, "\n");
}

# define YY_STACK_PRINT(Bottom, Top)                            \
do {                                                            \
  if (yydebug)                                                  \
    yy_stack_print ((Bottom), (Top));                           \
} while (0)


/*------------------------------------------------.
| Report that the YYRULE is going to be reduced.  |
`------------------------------------------------*/

static void
yy_reduce_print (yy_state_t *yyssp, YYSTYPE *yyvsp, YYLTYPE *yylsp,
                 int yyrule)
{
  int yylno = yyrline[yyrule];
  int yynrhs = yyr2[yyrule];
  int yyi;
  YYFPRINTF (stderr, "Reducing stack by rule %d (line %d):\n",
             yyrule - 1, yylno);
  /* The symbols being reduced.  */
  for (yyi = 0; yyi < yynrhs; yyi++)
    {
      YYFPRINTF (stderr, "   $%d = ", yyi + 1);
      yy_symbol_print (stderr,
                       YY_ACCESSING_SYMBOL (+yyssp[yyi + 1 - yynrhs]),
                       &yyvsp[(yyi + 1) - (yynrhs)],
                       &(yylsp[(yyi + 1) - (yynrhs)]));
      YYFPRINTF (stderr, "\n");
    }
}

# define YY_REDUCE_PRINT(Rule)          \
do {                                    \
  if (yydebug)                          \
    yy_reduce_print (yyssp, yyvsp, yylsp, Rule); \
} while (0)

/* Nonzero means print parse trace.  It is left uninitialized so that
   multiple parsers can coexist.  */
int yydebug;
#else /* !YYDEBUG */
# define YYDPRINTF(Args) ((void) 0)
# define YY_SYMBOL_PRINT(Title, Kind, Value, Location)
# define YY_STACK_PRINT(Bottom, Top)
# define YY_REDUCE_PRINT(Rule)
#endif /* !YYDEBUG */


/* YYINITDEPTH -- initial size of the parser's stacks.  */
#ifndef YYINITDEPTH
# define YYINITDEPTH 200
#endif

/* YYMAXDEPTH -- maximum size the stacks can grow to (effective only
   if the built-in stack extension method is used).

   Do not make this value too large; the results are undefined if
   YYSTACK_ALLOC_MAXIMUM < YYSTACK_BYTES (YYMAXDEPTH)
   evaluated with infinite-precision integer arithmetic.  */

#ifndef YYMAXDEPTH
# define YYMAXDEPTH 10000
#endif






/*-----------------------------------------------.
| Release the memory associated to this symbol.  |
`-----------------------------------------------*/

static void
yydestruct (const char *yymsg,
            yysymbol_kind_t yykind, YYSTYPE *yyvaluep, YYLTYPE *yylocationp)
{
  YY_USE (yyvaluep);
  YY_USE (yylocationp);
  if (!yymsg)
    yymsg = "Deleting";
  YY_SYMBOL_PRINT (yymsg, yykind, yyvaluep, yylocationp);

  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  switch (yykind)
    {
    case YYSYMBOL_Y_CONSTRUCTOR_SNAME: /* Y_CONSTRUCTOR_SNAME  */
#line 1962 "parser.y"
            { DTRACE; c_sname_cleanup( &((*yyvaluep).sname) );                 }
#line 5274 "parser.c"
        break;

    case YYSYMBOL_Y_DESTRUCTOR_SNAME: /* Y_DESTRUCTOR_SNAME  */
#line 1962 "parser.y"
            { DTRACE; c_sname_cleanup( &((*yyvaluep).sname) );                 }
#line 5280 "parser.c"
        break;

    case YYSYMBOL_Y_OPERATOR_SNAME: /* Y_OPERATOR_SNAME  */
#line 1962 "parser.y"
            { DTRACE; c_sname_cleanup( &((*yyvaluep).sname) );                 }
#line 5286 "parser.c"
        break;

    case YYSYMBOL_Y_CHAR_LIT: /* Y_CHAR_LIT  */
#line 1964 "parser.y"
            { DTRACE; FREE( ((*yyvaluep).str_val) );                             }
#line 5292 "parser.c"
        break;

    case YYSYMBOL_Y_CONCEPT_SNAME: /* Y_CONCEPT_SNAME  */
#line 1962 "parser.y"
            { DTRACE; c_sname_cleanup( &((*yyvaluep).sname) );                 }
#line 5298 "parser.c"
        break;

    case YYSYMBOL_Y_GLOB: /* Y_GLOB  */
#line 1956 "parser.y"
            { DTRACE; FREE( ((*yyvaluep).name) );                             }
#line 5304 "parser.c"
        break;

    case YYSYMBOL_Y_NAME: /* Y_NAME  */
#line 1956 "parser.y"
            { DTRACE; FREE( ((*yyvaluep).name) );                             }
#line 5310 "parser.c"
        break;

    case YYSYMBOL_Y_SET_OPTION: /* Y_SET_OPTION  */
#line 1956 "parser.y"
            { DTRACE; FREE( ((*yyvaluep).name) );                             }
#line 5316 "parser.c"
        break;

    case YYSYMBOL_Y_STR_LIT: /* Y_STR_LIT  */
#line 1964 "parser.y"
            { DTRACE; FREE( ((*yyvaluep).str_val) );                             }
#line 5322 "parser.c"
        break;

    case YYSYMBOL_capturing_paren_capture_decl_list_english_opt: /* capturing_paren_capture_decl_list_english_opt  */
#line 1955 "parser.y"
            { DTRACE; c_ast_list_cleanup( &((*yyvaluep).ast_list) );              }
#line 5328 "parser.c"
        break;

    case YYSYMBOL_paren_capture_decl_list_english: /* paren_capture_decl_list_english  */
#line 1955 "parser.y"
            { DTRACE; c_ast_list_cleanup( &((*yyvaluep).ast_list) );              }
#line 5334 "parser.c"
        break;

    case YYSYMBOL_capture_decl_list_english_opt: /* capture_decl_list_english_opt  */
#line 1955 "parser.y"
            { DTRACE; c_ast_list_cleanup( &((*yyvaluep).ast_list) );              }
#line 5340 "parser.c"
        break;

    case YYSYMBOL_capture_decl_list_english: /* capture_decl_list_english  */
#line 1955 "parser.y"
            { DTRACE; c_ast_list_cleanup( &((*yyvaluep).ast_list) );              }
#line 5346 "parser.c"
        break;

    case YYSYMBOL_p_extra_token_except_lparen: /* p_extra_token_except_lparen  */
#line 1960 "parser.y"
            { DTRACE; p_token_free( ((*yyvaluep).p_token) );                     }
#line 5352 "parser.c"
        break;

    case YYSYMBOL_p_extra_tokens_opt: /* p_extra_tokens_opt  */
#line 1961 "parser.y"
            { DTRACE; p_token_list_cleanup( ((*yyvaluep).p_token_list) ); FREE( ((*yyvaluep).p_token_list) ); }
#line 5358 "parser.c"
        break;

    case YYSYMBOL_p_extra_tokens: /* p_extra_tokens  */
#line 1961 "parser.y"
            { DTRACE; p_token_list_cleanup( ((*yyvaluep).p_token_list) ); FREE( ((*yyvaluep).p_token_list) ); }
#line 5364 "parser.c"
        break;

    case YYSYMBOL_p_extra_token: /* p_extra_token  */
#line 1960 "parser.y"
            { DTRACE; p_token_free( ((*yyvaluep).p_token) );                     }
#line 5370 "parser.c"
        break;

    case YYSYMBOL_p_arg_list_opt: /* p_arg_list_opt  */
#line 1957 "parser.y"
            { DTRACE; p_arg_list_cleanup( ((*yyvaluep).p_arg_list) );   FREE( ((*yyvaluep).p_arg_list) ); }
#line 5376 "parser.c"
        break;

    case YYSYMBOL_p_comma_arg_list: /* p_comma_arg_list  */
#line 1957 "parser.y"
            { DTRACE; p_arg_list_cleanup( ((*yyvaluep).p_arg_list) );   FREE( ((*yyvaluep).p_arg_list) ); }
#line 5382 "parser.c"
        break;

    case YYSYMBOL_p_arg_list: /* p_arg_list  */
#line 1957 "parser.y"
            { DTRACE; p_arg_list_cleanup( ((*yyvaluep).p_arg_list) );   FREE( ((*yyvaluep).p_arg_list) ); }
#line 5388 "parser.c"
        break;

    case YYSYMBOL_p_arg_tokens: /* p_arg_tokens  */
#line 1961 "parser.y"
            { DTRACE; p_token_list_cleanup( ((*yyvaluep).p_token_list) ); FREE( ((*yyvaluep).p_token_list) ); }
#line 5394 "parser.c"
        break;

    case YYSYMBOL_p_arg_token_as_list: /* p_arg_token_as_list  */
#line 1961 "parser.y"
            { DTRACE; p_token_list_cleanup( ((*yyvaluep).p_token_list) ); FREE( ((*yyvaluep).p_token_list) ); }
#line 5400 "parser.c"
        break;

    case YYSYMBOL_p_arg_token: /* p_arg_token  */
#line 1960 "parser.y"
            { DTRACE; p_token_free( ((*yyvaluep).p_token) );                     }
#line 5406 "parser.c"
        break;

    case YYSYMBOL_p_arg_tokens_with_comma_opt: /* p_arg_tokens_with_comma_opt  */
#line 1961 "parser.y"
            { DTRACE; p_token_list_cleanup( ((*yyvaluep).p_token_list) ); FREE( ((*yyvaluep).p_token_list) ); }
#line 5412 "parser.c"
        break;

    case YYSYMBOL_p_arg_tokens_with_comma: /* p_arg_tokens_with_comma  */
#line 1961 "parser.y"
            { DTRACE; p_token_list_cleanup( ((*yyvaluep).p_token_list) ); FREE( ((*yyvaluep).p_token_list) ); }
#line 5418 "parser.c"
        break;

    case YYSYMBOL_p_arg_token_with_comma_as_list: /* p_arg_token_with_comma_as_list  */
#line 1961 "parser.y"
            { DTRACE; p_token_list_cleanup( ((*yyvaluep).p_token_list) ); FREE( ((*yyvaluep).p_token_list) ); }
#line 5424 "parser.c"
        break;

    case YYSYMBOL_p_arg_token_with_comma: /* p_arg_token_with_comma  */
#line 1960 "parser.y"
            { DTRACE; p_token_free( ((*yyvaluep).p_token) );                     }
#line 5430 "parser.c"
        break;

    case YYSYMBOL_help_what_opt: /* help_what_opt  */
#line 1956 "parser.y"
            { DTRACE; FREE( ((*yyvaluep).name) );                             }
#line 5436 "parser.c"
        break;

    case YYSYMBOL_p_paren_param_list_opt: /* p_paren_param_list_opt  */
#line 1959 "parser.y"
            { DTRACE; p_param_list_cleanup( ((*yyvaluep).p_param_list) ); FREE( ((*yyvaluep).p_param_list) ); }
#line 5442 "parser.c"
        break;

    case YYSYMBOL_p_param_list_opt: /* p_param_list_opt  */
#line 1959 "parser.y"
            { DTRACE; p_param_list_cleanup( ((*yyvaluep).p_param_list) ); FREE( ((*yyvaluep).p_param_list) ); }
#line 5448 "parser.c"
        break;

    case YYSYMBOL_p_param_list: /* p_param_list  */
#line 1959 "parser.y"
            { DTRACE; p_param_list_cleanup( ((*yyvaluep).p_param_list) ); FREE( ((*yyvaluep).p_param_list) ); }
#line 5454 "parser.c"
        break;

    case YYSYMBOL_p_param: /* p_param  */
#line 1958 "parser.y"
            { DTRACE; p_param_free( ((*yyvaluep).p_param) );                     }
#line 5460 "parser.c"
        break;

    case YYSYMBOL_p_replace_list_opt: /* p_replace_list_opt  */
#line 1961 "parser.y"
            { DTRACE; p_token_list_cleanup( ((*yyvaluep).p_token_list) ); FREE( ((*yyvaluep).p_token_list) ); }
#line 5466 "parser.c"
        break;

    case YYSYMBOL_p_replace_list: /* p_replace_list  */
#line 1961 "parser.y"
            { DTRACE; p_token_list_cleanup( ((*yyvaluep).p_token_list) ); FREE( ((*yyvaluep).p_token_list) ); }
#line 5472 "parser.c"
        break;

    case YYSYMBOL_p_replace_token: /* p_replace_token  */
#line 1960 "parser.y"
            { DTRACE; p_token_free( ((*yyvaluep).p_token) );                     }
#line 5478 "parser.c"
        break;

    case YYSYMBOL_set_option_value_opt: /* set_option_value_opt  */
#line 1964 "parser.y"
            { DTRACE; FREE( ((*yyvaluep).str_val) );                             }
#line 5484 "parser.c"
        break;

    case YYSYMBOL_namespace_sname_c_exp: /* namespace_sname_c_exp  */
#line 1962 "parser.y"
            { DTRACE; c_sname_cleanup( &((*yyvaluep).sname) );                 }
#line 5490 "parser.c"
        break;

    case YYSYMBOL_namespace_sname_c: /* namespace_sname_c  */
#line 1962 "parser.y"
            { DTRACE; c_sname_cleanup( &((*yyvaluep).sname) );                 }
#line 5496 "parser.c"
        break;

    case YYSYMBOL_namespace_typedef_sname_c: /* namespace_typedef_sname_c  */
#line 1962 "parser.y"
            { DTRACE; c_sname_cleanup( &((*yyvaluep).sname) );                 }
#line 5502 "parser.c"
        break;

    case YYSYMBOL_capture_decl_list_c_opt: /* capture_decl_list_c_opt  */
#line 1955 "parser.y"
            { DTRACE; c_ast_list_cleanup( &((*yyvaluep).ast_list) );              }
#line 5508 "parser.c"
        break;

    case YYSYMBOL_capture_decl_list_c: /* capture_decl_list_c  */
#line 1955 "parser.y"
            { DTRACE; c_ast_list_cleanup( &((*yyvaluep).ast_list) );              }
#line 5514 "parser.c"
        break;

    case YYSYMBOL_decl_list_c: /* decl_list_c  */
#line 1955 "parser.y"
            { DTRACE; c_ast_list_cleanup( &((*yyvaluep).ast_list) );              }
#line 5520 "parser.c"
        break;

    case YYSYMBOL_param_c_ast_list_exp: /* param_c_ast_list_exp  */
#line 1955 "parser.y"
            { DTRACE; c_ast_list_cleanup( &((*yyvaluep).ast_list) );              }
#line 5526 "parser.c"
        break;

    case YYSYMBOL_param_c_ast_list_opt: /* param_c_ast_list_opt  */
#line 1955 "parser.y"
            { DTRACE; c_ast_list_cleanup( &((*yyvaluep).ast_list) );              }
#line 5532 "parser.c"
        break;

    case YYSYMBOL_param_c_ast_list: /* param_c_ast_list  */
#line 1955 "parser.y"
            { DTRACE; c_ast_list_cleanup( &((*yyvaluep).ast_list) );              }
#line 5538 "parser.c"
        break;

    case YYSYMBOL_paren_param_c_ast_list_opt: /* paren_param_c_ast_list_opt  */
#line 1955 "parser.y"
            { DTRACE; c_ast_list_cleanup( &((*yyvaluep).ast_list) );              }
#line 5544 "parser.c"
        break;

    case YYSYMBOL_pc99_pointer_decl_list_c: /* pc99_pointer_decl_list_c  */
#line 1955 "parser.y"
            { DTRACE; c_ast_list_cleanup( &((*yyvaluep).ast_list) );              }
#line 5550 "parser.c"
        break;

    case YYSYMBOL_sub_scope_sname_c_opt: /* sub_scope_sname_c_opt  */
#line 1962 "parser.y"
            { DTRACE; c_sname_cleanup( &((*yyvaluep).sname) );                 }
#line 5556 "parser.c"
        break;

    case YYSYMBOL_paren_param_decl_list_english_opt: /* paren_param_decl_list_english_opt  */
#line 1955 "parser.y"
            { DTRACE; c_ast_list_cleanup( &((*yyvaluep).ast_list) );              }
#line 5562 "parser.c"
        break;

    case YYSYMBOL_paren_param_decl_list_english: /* paren_param_decl_list_english  */
#line 1955 "parser.y"
            { DTRACE; c_ast_list_cleanup( &((*yyvaluep).ast_list) );              }
#line 5568 "parser.c"
        break;

    case YYSYMBOL_param_decl_list_english_opt: /* param_decl_list_english_opt  */
#line 1955 "parser.y"
            { DTRACE; c_ast_list_cleanup( &((*yyvaluep).ast_list) );              }
#line 5574 "parser.c"
        break;

    case YYSYMBOL_param_decl_list_english: /* param_decl_list_english  */
#line 1955 "parser.y"
            { DTRACE; c_ast_list_cleanup( &((*yyvaluep).ast_list) );              }
#line 5580 "parser.c"
        break;

    case YYSYMBOL_any_name: /* any_name  */
#line 1956 "parser.y"
            { DTRACE; FREE( ((*yyvaluep).name) );                             }
#line 5586 "parser.c"
        break;

    case YYSYMBOL_any_name_exp: /* any_name_exp  */
#line 1956 "parser.y"
            { DTRACE; FREE( ((*yyvaluep).name) );                             }
#line 5592 "parser.c"
        break;

    case YYSYMBOL_any_sname_c: /* any_sname_c  */
#line 1962 "parser.y"
            { DTRACE; c_sname_cleanup( &((*yyvaluep).sname) );                 }
#line 5598 "parser.c"
        break;

    case YYSYMBOL_any_sname_c_exp: /* any_sname_c_exp  */
#line 1962 "parser.y"
            { DTRACE; c_sname_cleanup( &((*yyvaluep).sname) );                 }
#line 5604 "parser.c"
        break;

    case YYSYMBOL_any_sname_c_opt: /* any_sname_c_opt  */
#line 1962 "parser.y"
            { DTRACE; c_sname_cleanup( &((*yyvaluep).sname) );                 }
#line 5610 "parser.c"
        break;

    case YYSYMBOL_name_exp: /* name_exp  */
#line 1956 "parser.y"
            { DTRACE; FREE( ((*yyvaluep).name) );                             }
#line 5616 "parser.c"
        break;

    case YYSYMBOL_name_cat: /* name_cat  */
#line 1956 "parser.y"
            { DTRACE; FREE( ((*yyvaluep).name) );                             }
#line 5622 "parser.c"
        break;

    case YYSYMBOL_name_opt: /* name_opt  */
#line 1956 "parser.y"
            { DTRACE; FREE( ((*yyvaluep).name) );                             }
#line 5628 "parser.c"
        break;

    case YYSYMBOL_oper_sname_c_opt: /* oper_sname_c_opt  */
#line 1962 "parser.y"
            { DTRACE; c_sname_cleanup( &((*yyvaluep).sname) );                 }
#line 5634 "parser.c"
        break;

    case YYSYMBOL_sname_c: /* sname_c  */
#line 1962 "parser.y"
            { DTRACE; c_sname_cleanup( &((*yyvaluep).sname) );                 }
#line 5640 "parser.c"
        break;

    case YYSYMBOL_sname_c_exp: /* sname_c_exp  */
#line 1962 "parser.y"
            { DTRACE; c_sname_cleanup( &((*yyvaluep).sname) );                 }
#line 5646 "parser.c"
        break;

    case YYSYMBOL_sname_c_opt: /* sname_c_opt  */
#line 1962 "parser.y"
            { DTRACE; c_sname_cleanup( &((*yyvaluep).sname) );                 }
#line 5652 "parser.c"
        break;

    case YYSYMBOL_sname_english: /* sname_english  */
#line 1962 "parser.y"
            { DTRACE; c_sname_cleanup( &((*yyvaluep).sname) );                 }
#line 5658 "parser.c"
        break;

    case YYSYMBOL_sname_english_exp: /* sname_english_exp  */
#line 1962 "parser.y"
            { DTRACE; c_sname_cleanup( &((*yyvaluep).sname) );                 }
#line 5664 "parser.c"
        break;

    case YYSYMBOL_sname_english_opt: /* sname_english_opt  */
#line 1962 "parser.y"
            { DTRACE; c_sname_cleanup( &((*yyvaluep).sname) );                 }
#line 5670 "parser.c"
        break;

    case YYSYMBOL_sname_list_c: /* sname_list_c  */
#line 1963 "parser.y"
            { DTRACE; c_sname_list_cleanup( &((*yyvaluep).sname_list) );            }
#line 5676 "parser.c"
        break;

    case YYSYMBOL_sname_list_english: /* sname_list_english  */
#line 1963 "parser.y"
            { DTRACE; c_sname_list_cleanup( &((*yyvaluep).sname_list) );            }
#line 5682 "parser.c"
        break;

    case YYSYMBOL_typedef_sname_c: /* typedef_sname_c  */
#line 1962 "parser.y"
            { DTRACE; c_sname_cleanup( &((*yyvaluep).sname) );                 }
#line 5688 "parser.c"
        break;

    case YYSYMBOL_destructor_sname: /* destructor_sname  */
#line 1962 "parser.y"
            { DTRACE; c_sname_cleanup( &((*yyvaluep).sname) );                 }
#line 5694 "parser.c"
        break;

    case YYSYMBOL_glob: /* glob  */
#line 1956 "parser.y"
            { DTRACE; FREE( ((*yyvaluep).name) );                             }
#line 5700 "parser.c"
        break;

    case YYSYMBOL_glob_opt: /* glob_opt  */
#line 1956 "parser.y"
            { DTRACE; FREE( ((*yyvaluep).name) );                             }
#line 5706 "parser.c"
        break;

    case YYSYMBOL_of_scope_english: /* of_scope_english  */
#line 1962 "parser.y"
            { DTRACE; c_sname_cleanup( &((*yyvaluep).sname) );                 }
#line 5712 "parser.c"
        break;

    case YYSYMBOL_of_scope_list_english: /* of_scope_list_english  */
#line 1962 "parser.y"
            { DTRACE; c_sname_cleanup( &((*yyvaluep).sname) );                 }
#line 5718 "parser.c"
        break;

    case YYSYMBOL_of_scope_list_english_opt: /* of_scope_list_english_opt  */
#line 1962 "parser.y"
            { DTRACE; c_sname_cleanup( &((*yyvaluep).sname) );                 }
#line 5724 "parser.c"
        break;

    case YYSYMBOL_str_lit: /* str_lit  */
#line 1964 "parser.y"
            { DTRACE; FREE( ((*yyvaluep).str_val) );                             }
#line 5730 "parser.c"
        break;

    case YYSYMBOL_str_lit_exp: /* str_lit_exp  */
#line 1964 "parser.y"
            { DTRACE; FREE( ((*yyvaluep).str_val) );                             }
#line 5736 "parser.c"
        break;

      default:
        break;
    }
  YY_IGNORE_MAYBE_UNINITIALIZED_END
}


/* Lookahead token kind.  */
int yychar;

/* The semantic value of the lookahead symbol.  */
YYSTYPE yylval;
/* Location data for the lookahead symbol.  */
YYLTYPE yylloc
# if defined YYLTYPE_IS_TRIVIAL && YYLTYPE_IS_TRIVIAL
  = { 1, 1, 1, 1 }
# endif
;
/* Number of syntax errors so far.  */
int yynerrs;




/*----------.
| yyparse.  |
`----------*/

int
yyparse (void)
{
    yy_state_fast_t yystate = 0;
    /* Number of tokens to shift before error messages enabled.  */
    int yyerrstatus = 0;

    /* Refer to the stacks through separate pointers, to allow yyoverflow
       to reallocate them elsewhere.  */

    /* Their size.  */
    YYPTRDIFF_T yystacksize = YYINITDEPTH;

    /* The state stack: array, bottom, top.  */
    yy_state_t yyssa[YYINITDEPTH];
    yy_state_t *yyss = yyssa;
    yy_state_t *yyssp = yyss;

    /* The semantic value stack: array, bottom, top.  */
    YYSTYPE yyvsa[YYINITDEPTH];
    YYSTYPE *yyvs = yyvsa;
    YYSTYPE *yyvsp = yyvs;

    /* The location stack: array, bottom, top.  */
    YYLTYPE yylsa[YYINITDEPTH];
    YYLTYPE *yyls = yylsa;
    YYLTYPE *yylsp = yyls;

  int yyn;
  /* The return value of yyparse.  */
  int yyresult;
  /* Lookahead symbol kind.  */
  yysymbol_kind_t yytoken = YYSYMBOL_YYEMPTY;
  /* The variables used to return semantic value and location from the
     action routines.  */
  YYSTYPE yyval;
  YYLTYPE yyloc;

  /* The locations where the error started and ended.  */
  YYLTYPE yyerror_range[3];



#define YYPOPSTACK(N)   (yyvsp -= (N), yyssp -= (N), yylsp -= (N))

  /* The number of symbols on the RHS of the reduced rule.
     Keep to zero when no symbol should be popped.  */
  int yylen = 0;

  YYDPRINTF ((stderr, "Starting parse\n"));

  yychar = YYEMPTY; /* Cause a token to be read.  */

  yylsp[0] = yylloc;
  goto yysetstate;


/*------------------------------------------------------------.
| yynewstate -- push a new state, which is found in yystate.  |
`------------------------------------------------------------*/
yynewstate:
  /* In all cases, when you get here, the value and location stacks
     have just been pushed.  So pushing a state here evens the stacks.  */
  yyssp++;


/*--------------------------------------------------------------------.
| yysetstate -- set current state (the top of the stack) to yystate.  |
`--------------------------------------------------------------------*/
yysetstate:
  YYDPRINTF ((stderr, "Entering state %d\n", yystate));
  YY_ASSERT (0 <= yystate && yystate < YYNSTATES);
  YY_IGNORE_USELESS_CAST_BEGIN
  *yyssp = YY_CAST (yy_state_t, yystate);
  YY_IGNORE_USELESS_CAST_END
  YY_STACK_PRINT (yyss, yyssp);

  if (yyss + yystacksize - 1 <= yyssp)
#if !defined yyoverflow && !defined YYSTACK_RELOCATE
    YYNOMEM;
#else
    {
      /* Get the current used size of the three stacks, in elements.  */
      YYPTRDIFF_T yysize = yyssp - yyss + 1;

# if defined yyoverflow
      {
        /* Give user a chance to reallocate the stack.  Use copies of
           these so that the &'s don't force the real ones into
           memory.  */
        yy_state_t *yyss1 = yyss;
        YYSTYPE *yyvs1 = yyvs;
        YYLTYPE *yyls1 = yyls;

        /* Each stack pointer address is followed by the size of the
           data in use in that stack, in bytes.  This used to be a
           conditional around just the two extra args, but that might
           be undefined if yyoverflow is a macro.  */
        yyoverflow (YY_("memory exhausted"),
                    &yyss1, yysize * YYSIZEOF (*yyssp),
                    &yyvs1, yysize * YYSIZEOF (*yyvsp),
                    &yyls1, yysize * YYSIZEOF (*yylsp),
                    &yystacksize);
        yyss = yyss1;
        yyvs = yyvs1;
        yyls = yyls1;
      }
# else /* defined YYSTACK_RELOCATE */
      /* Extend the stack our own way.  */
      if (YYMAXDEPTH <= yystacksize)
        YYNOMEM;
      yystacksize *= 2;
      if (YYMAXDEPTH < yystacksize)
        yystacksize = YYMAXDEPTH;

      {
        yy_state_t *yyss1 = yyss;
        union yyalloc *yyptr =
          YY_CAST (union yyalloc *,
                   YYSTACK_ALLOC (YY_CAST (YYSIZE_T, YYSTACK_BYTES (yystacksize))));
        if (! yyptr)
          YYNOMEM;
        YYSTACK_RELOCATE (yyss_alloc, yyss);
        YYSTACK_RELOCATE (yyvs_alloc, yyvs);
        YYSTACK_RELOCATE (yyls_alloc, yyls);
#  undef YYSTACK_RELOCATE
        if (yyss1 != yyssa)
          YYSTACK_FREE (yyss1);
      }
# endif

      yyssp = yyss + yysize - 1;
      yyvsp = yyvs + yysize - 1;
      yylsp = yyls + yysize - 1;

      YY_IGNORE_USELESS_CAST_BEGIN
      YYDPRINTF ((stderr, "Stack size increased to %ld\n",
                  YY_CAST (long, yystacksize)));
      YY_IGNORE_USELESS_CAST_END

      if (yyss + yystacksize - 1 <= yyssp)
        YYABORT;
    }
#endif /* !defined yyoverflow && !defined YYSTACK_RELOCATE */


  if (yystate == YYFINAL)
    YYACCEPT;

  goto yybackup;


/*-----------.
| yybackup.  |
`-----------*/
yybackup:
  /* Do appropriate processing given the current state.  Read a
     lookahead token if we need one and don't already have one.  */

  /* First try to decide what to do without reference to lookahead token.  */
  yyn = yypact[yystate];
  if (yypact_value_is_default (yyn))
    goto yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* YYCHAR is either empty, or end-of-input, or a valid lookahead.  */
  if (yychar == YYEMPTY)
    {
      YYDPRINTF ((stderr, "Reading a token\n"));
      yychar = yylex ();
    }

  if (yychar <= YYEOF)
    {
      yychar = YYEOF;
      yytoken = YYSYMBOL_YYEOF;
      YYDPRINTF ((stderr, "Now at end of input.\n"));
    }
  else if (yychar == YYerror)
    {
      /* The scanner already issued an error message, process directly
         to error recovery.  But do not keep the error token as
         lookahead, it is too special and may lead us to an endless
         loop in error recovery. */
      yychar = YYUNDEF;
      yytoken = YYSYMBOL_YYerror;
      yyerror_range[1] = yylloc;
      goto yyerrlab1;
    }
  else
    {
      yytoken = YYTRANSLATE (yychar);
      YY_SYMBOL_PRINT ("Next token is", yytoken, &yylval, &yylloc);
    }

  /* If the proper action on seeing token YYTOKEN is to reduce or to
     detect an error, take that action.  */
  yyn += yytoken;
  if (yyn < 0 || YYLAST < yyn || yycheck[yyn] != yytoken)
    goto yydefault;
  yyn = yytable[yyn];
  if (yyn <= 0)
    {
      if (yytable_value_is_error (yyn))
        goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }

  /* Count tokens shifted since error; after three, turn off error
     status.  */
  if (yyerrstatus)
    yyerrstatus--;

  /* Shift the lookahead token.  */
  YY_SYMBOL_PRINT ("Shifting", yytoken, &yylval, &yylloc);
  yystate = yyn;
  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  *++yyvsp = yylval;
  YY_IGNORE_MAYBE_UNINITIALIZED_END
  *++yylsp = yylloc;

  /* Discard the shifted token.  */
  yychar = YYEMPTY;
  goto yynewstate;


/*-----------------------------------------------------------.
| yydefault -- do the default action for the current state.  |
`-----------------------------------------------------------*/
yydefault:
  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;
  goto yyreduce;


/*-----------------------------.
| yyreduce -- do a reduction.  |
`-----------------------------*/
yyreduce:
  /* yyn is the number of a rule to reduce with.  */
  yylen = yyr2[yyn];

  /* If YYLEN is nonzero, implement the default value of the action:
     '$$ = $1'.

     Otherwise, the following line sets YYVAL to garbage.
     This behavior is undocumented and Bison
     users should not rely upon it.  Assigning to YYVAL
     unconditionally makes the parser a bit smaller, and it avoids a
     GCC warning that YYVAL may be used uninitialized.  */
  yyval = yyvsp[1-yylen];

  /* Default location. */
  YYLLOC_DEFAULT (yyloc, (yylsp - yylen), yylen);
  yyerror_range[1] = yyloc;
  YY_REDUCE_PRINT (yyn);
  switch (yyn)
    {
  case 3: /* command_list: command_list command  */
#line 1972 "parser.y"
    { //
      // We get here only after a successful parse.
      //
      parse_cleanup( /*fatal_error=*/false );
    }
#line 6035 "parser.c"
    break;

  case 19: /* command: error  */
#line 1996 "parser.y"
    {
      if ( printable_yytext() != NULL )
        elaborate_error_dym( DYM_COMMANDS, "unexpected token" );
      else
        elaborate_error( "unexpected end of command" );
    }
#line 6046 "parser.c"
    break;

  case 20: /* cast_command: Y_cast sname_english_opt as_into_to_exp decl_english_ast  */
#line 2015 "parser.y"
    {
      DUMP_START( "cast_command",
                  "CAST sname_english_opt {AS|[IN]TO} decl_english_ast" );
      DUMP_SNAME( "sname_english_opt", (yyvsp[-2].sname) );
      DUMP_AST( "decl_english_ast", (yyvsp[0].ast) );

      c_ast_t *const cast_ast = c_ast_new_gc( K_CAST, &(yylsp[-2]) );
      cast_ast->sname = c_sname_move( &(yyvsp[-2].sname) );
      cast_ast->cast.kind = C_CAST_C;
      cast_ast->cast.to_ast = (yyvsp[0].ast);

      DUMP_AST( "$$_ast", cast_ast );
      DUMP_END();

      PARSE_ASSERT( c_ast_check( cast_ast ) );
      c_ast_gibberish( cast_ast, C_GIB_PRINT_CAST, stdout );
    }
#line 6068 "parser.c"
    break;

  case 21: /* cast_command: new_style_cast_english sname_english_exp as_into_to_exp decl_english_ast  */
#line 2038 "parser.y"
    {
      DUMP_START( "cast_command",
                  "new_style_cast_english sname_english_exp {AS|[IN]TO} "
                  "decl_english_ast" );
      DUMP_STR( "new_style_cast_english", c_cast_gibberish( (yyvsp[-3].cast_kind) ) );
      DUMP_SNAME( "sname_english_exp", (yyvsp[-2].sname) );
      DUMP_AST( "decl_english_ast", (yyvsp[0].ast) );

      c_ast_t *const cast_ast = c_ast_new_gc( K_CAST, &(yyloc) );
      cast_ast->sname = c_sname_move( &(yyvsp[-2].sname) );
      cast_ast->cast.kind = (yyvsp[-3].cast_kind);
      cast_ast->cast.to_ast = (yyvsp[0].ast);

      DUMP_AST( "$$_ast", cast_ast );
      DUMP_END();

      PARSE_ASSERT( c_ast_check( cast_ast ) );
      c_ast_gibberish( cast_ast, C_GIB_PRINT_CAST, stdout );
    }
#line 6092 "parser.c"
    break;

  case 22: /* new_style_cast_english: Y_const cast_exp  */
#line 2060 "parser.y"
                                  { (yyval.cast_kind) = C_CAST_CONST;        }
#line 6098 "parser.c"
    break;

  case 23: /* new_style_cast_english: Y_dynamic cast_exp  */
#line 2061 "parser.y"
                                  { (yyval.cast_kind) = C_CAST_DYNAMIC;      }
#line 6104 "parser.c"
    break;

  case 24: /* new_style_cast_english: Y_reinterpret cast_exp  */
#line 2062 "parser.y"
                                  { (yyval.cast_kind) = C_CAST_REINTERPRET;  }
#line 6110 "parser.c"
    break;

  case 25: /* new_style_cast_english: Y_static cast_exp  */
#line 2063 "parser.y"
                                  { (yyval.cast_kind) = C_CAST_STATIC;       }
#line 6116 "parser.c"
    break;

  case 27: /* declare_command: Y_declare sname_list_english as_exp alignas_or_width_decl_english_ast  */
#line 2075 "parser.y"
    {
      if ( c_ast_is_name_error( (yyvsp[0].ast) ) ) {
        //
        // This checks for a case like:
        //
        //      declare x as y
        //
        // i.e., declaring a variable name as another name (unknown type).
        // This can get this far due to the nature of the C/C++ grammar.
        //
        // This check has to be done now in the parser rather than later in the
        // AST because the name of the AST node needs to be set to the variable
        // name, but the AST node is itself a name and overwriting it would
        // lose information.
        //
        c_sname_list_cleanup( &(yyvsp[-2].sname_list) );
        PARSE_ABORT();
      }

      DUMP_START( "declare_command",
                  "DECLARE sname_list_english AS "
                  "alignas_or_width_decl_english_ast" );
      DUMP_SNAME_LIST( "sname_list_english", (yyvsp[-2].sname_list) );
      DUMP_AST( "alignas_or_width_decl_english_ast", (yyvsp[0].ast) );

      slist_t *sname_list = &(yyvsp[-2].sname_list);
      c_ast_t *const struct_bind_ast = c_ast_unreference_any( (yyvsp[0].ast) );

      if ( struct_bind_ast->kind == K_STRUCTURED_BINDING ) {
        //
        // For ref-qualified structured bindings, it's much simpler to
        // retroactively change $decl_ast to the structured binding AST
        // directly eliding the reference AST and fold in the reference type.
        //
        struct_bind_ast->type.stids |= (yyvsp[0].ast)->type.stids;
        switch ( (yyvsp[0].ast)->kind ) {
          case K_REFERENCE:
            struct_bind_ast->type.stids |= TS_REFERENCE;
            break;
          case K_RVALUE_REFERENCE:
            struct_bind_ast->type.stids |= TS_RVALUE_REFERENCE;
            break;
          default:
            /* suppress warning */;
        } // switch
        (yyvsp[0].ast) = struct_bind_ast;
        c_ast_set_parent( (yyvsp[0].ast), /*parent_ast=*/NULL );

        //
        // A structured binding is inverted: instead of having one structured
        // binding AST for each name, we have just one structured binding AST
        // with a list of name(s).
        //
        (yyvsp[0].ast)->struct_bind.sname_list = slist_move( sname_list );
        sname_list = &(yyvsp[0].ast)->struct_bind.sname_list;
      }

      DUMP_AST( "$$_ast", (yyvsp[0].ast) );
      DUMP_END();

      (yyvsp[0].ast)->loc = (yylsp[-2]);

      bool ok = true;
      //
      // Ensure that none of the names aren't of a previously declared type:
      //
      //      cdecl> struct S
      //      cdecl> declare S as int // error: "S": previously declared
      //
      // This check is done now in the parser rather than later in the AST
      // since similar checks are also done here in the parser.
      //
      FOREACH_SLIST_NODE( sname_node, sname_list ) {
        c_sname_t const *const sname = sname_node->data;
        if ( c_sname_is_type( sname, &(yyvsp[0].ast)->loc ) ) {
          ok = false;
          break;
        }
      } // for

      if ( ok ) {
        // To check the declaration, it needs a name: just dup the first one.
        c_sname_t temp_sname = c_sname_dup( slist_front( sname_list ) );
        c_sname_set( &(yyvsp[0].ast)->sname, &temp_sname );
        ok = c_ast_check( (yyvsp[0].ast) );
      }

      if ( ok ) {
        if ( (yyvsp[0].ast)->kind == K_STRUCTURED_BINDING ) {
          decl_flags_t decl_flags = C_GIB_PRINT_DECL;
          if ( opt_semicolon )
            decl_flags |= C_GIB_OPT_SEMICOLON;
          c_ast_gibberish( (yyvsp[0].ast), decl_flags, stdout );
        }
        else {
          c_ast_sname_list_gibberish( (yyvsp[0].ast), &(yyvsp[-2].sname_list), stdout );
        }
      }

      c_sname_list_cleanup( &(yyvsp[-2].sname_list) );
      PARSE_ASSERT( ok );
      PUTC( '\n' );
    }
#line 6224 "parser.c"
    break;

  case 28: /* $@1: %empty  */
#line 2183 "parser.y"
    { //
      // This check is done now in the parser right here mid-rule rather than
      // later in the end-rule action or in the AST since it yields a better
      // error message since otherwise it would warn that "operator" is a
      // keyword in C++98 which skims right past the bigger error that operator
      // overloading isn't supported in C.
      //
      if ( !OPT_LANG_IS( operator ) ) {
        print_error( &(yylsp[0]),
          "operator overloading not supported%s\n",
          C_LANG_WHICH( operator )
        );
        PARSE_ABORT();
      }
    }
#line 6244 "parser.c"
    break;

  case 29: /* declare_command: Y_declare c_operator $@1 of_scope_list_english_opt as_exp type_qualifier_list_english_type_opt ref_qualifier_english_stid_opt member_or_non_member_opt operator_exp paren_param_decl_list_english_opt returning_english_ast_opt  */
#line 2204 "parser.y"
    {
      c_operator_t const *const operator = c_op_get( (yyvsp[-9].op_id) );

      DUMP_START( "declare_command",
                  "DECLARE c_operator of_scope_list_english_opt AS "
                  "type_qualifier_list_english_type_opt "
                  "ref_qualifier_english_stid_opt "
                  "member_or_non_member_opt "
                  "OPERATOR paren_param_decl_list_english_opt "
                  "returning_english_ast_opt" );
      DUMP_STR( "c_operator", operator->literal );
      DUMP_SNAME( "of_scope_list_english_opt", (yyvsp[-7].sname) );
      DUMP_TYPE( "type_qualifier_list_english_type_opt", (yyvsp[-5].type) );
      DUMP_TID( "ref_qualifier_english_stid_opt", (yyvsp[-4].tid) );
      DUMP_INT( "member_or_non_member_opt", (yyvsp[-3].member) );
      DUMP_AST_LIST( "paren_param_decl_list_english_opt", (yyvsp[-1].ast_list) );
      DUMP_AST( "returning_english_ast_opt", (yyvsp[0].ast) );
      DUMP_END();

      c_ast_t *const oper_ast = c_ast_new_gc( K_OPERATOR, &(yylsp[-9]) );
      c_sname_set( &oper_ast->sname, &(yyvsp[-7].sname) );
      PARSE_ASSERT( c_type_add( &oper_ast->type, &(yyvsp[-5].type), &(yylsp[-5]) ) );
      PARSE_ASSERT(
        c_type_add_tid( &oper_ast->type, (yyvsp[-4].tid), &(yylsp[-4]) )
      );
      oper_ast->oper.operator = operator;
      c_ast_list_set_param_of( &(yyvsp[-1].ast_list), oper_ast );
      oper_ast->oper.param_ast_list = slist_move( &(yyvsp[-1].ast_list) );
      oper_ast->oper.member = (yyvsp[-3].member);
      c_ast_set_parent( (yyvsp[0].ast), oper_ast );

      PARSE_ASSERT( c_ast_check( oper_ast ) );
      decl_flags_t decl_flags = C_GIB_PRINT_DECL;
      if ( opt_semicolon )
        decl_flags |= C_GIB_OPT_SEMICOLON;
      c_ast_gibberish( oper_ast, decl_flags, stdout );
      PUTC( '\n' );
    }
#line 6287 "parser.c"
    break;

  case 30: /* declare_command: Y_declare storage_class_subset_english_type_opt Y_lambda capturing_paren_capture_decl_list_english_opt paren_param_decl_list_english_opt returning_english_ast_opt  */
#line 2250 "parser.y"
    {
      DUMP_START( "declare_command",
                  "DECLARE storage_class_subset_english_type_opt "
                  "LAMBDA capturing_paren_capture_decl_list_english_opt "
                  "paren_param_decl_list_english_opt"
                  "returning_english_ast_opt" );
      DUMP_TYPE( "storage_class_subset_english_type_opt", (yyvsp[-4].type) );
      DUMP_AST_LIST( "capturing_paren_capture_decl_list_english_opt",
                     (yyvsp[-2].ast_list) );
      DUMP_AST_LIST( "paren_param_decl_list_english_opt", (yyvsp[-1].ast_list) );
      DUMP_AST( "returning_english_ast_opt", (yyvsp[0].ast) );

      c_ast_t *const lambda_ast = c_ast_new_gc( K_LAMBDA, &(yylsp[-3]) );
      lambda_ast->type = (yyvsp[-4].type);
      c_ast_list_set_param_of( &(yyvsp[-2].ast_list), lambda_ast );
      lambda_ast->lambda.capture_ast_list = slist_move( &(yyvsp[-2].ast_list) );
      c_ast_list_set_param_of( &(yyvsp[-1].ast_list), lambda_ast );
      lambda_ast->lambda.param_ast_list = slist_move( &(yyvsp[-1].ast_list) );
      c_ast_set_parent( (yyvsp[0].ast), lambda_ast );

      DUMP_AST( "$$_ast", lambda_ast );
      DUMP_END();

      PARSE_ASSERT( c_ast_check( lambda_ast ) );
      c_ast_gibberish( lambda_ast, C_GIB_PRINT_DECL, stdout );
      PUTC( '\n' );
    }
#line 6319 "parser.c"
    break;

  case 31: /* declare_command: Y_declare storage_class_subset_english_type_opt cv_qualifier_list_stid_opt user_defined conversion_exp operator_opt of_scope_list_english_opt returning_exp decl_english_ast  */
#line 2285 "parser.y"
    {
      DUMP_START( "declare_command",
                  "DECLARE storage_class_subset_english_type_opt "
                  "cv_qualifier_list_stid_opt "
                  "USER-DEFINED CONVERSION [OPERATOR] "
                  "of_scope_list_english_opt "
                  "RETURNING decl_english_ast" );
      DUMP_TYPE( "storage_class_subset_english_type_opt", (yyvsp[-7].type) );
      DUMP_TID( "cv_qualifier_list_stid_opt", (yyvsp[-6].tid) );
      DUMP_SNAME( "of_scope_list_english_opt", (yyvsp[-2].sname) );
      DUMP_AST( "decl_english_ast", (yyvsp[0].ast) );

      c_ast_t *const udc_ast = c_ast_new_gc( K_UDEF_CONV, &(yyloc) );
      c_sname_set( &udc_ast->sname, &(yyvsp[-2].sname) );
      udc_ast->type = c_type_or( &(yyvsp[-7].type), &C_TYPE_LIT_S( (yyvsp[-6].tid) ) );
      c_ast_set_parent( (yyvsp[0].ast), udc_ast );

      DUMP_AST( "$$_ast", udc_ast );
      DUMP_END();

      PARSE_ASSERT( c_ast_check( udc_ast ) );
      decl_flags_t decl_flags = C_GIB_PRINT_DECL;
      if ( opt_semicolon )
        decl_flags |= C_GIB_OPT_SEMICOLON;
      c_ast_gibberish( udc_ast, decl_flags, stdout );
      PUTC( '\n' );
    }
#line 6351 "parser.c"
    break;

  case 32: /* declare_command: Y_declare error  */
#line 2314 "parser.y"
    {
      if ( OPT_LANG_IS( operator ) )
        elaborate_error( "name or operator expected" );
      else
        elaborate_error( "name expected" );
    }
#line 6362 "parser.c"
    break;

  case 34: /* alignas_or_width_decl_english_ast: decl_english_ast alignas_specifier_english  */
#line 2326 "parser.y"
    {
      DUMP_START( "alignas_or_width_decl_english_ast",
                  "decl_english_ast alignas_specifier_english" );
      DUMP_AST( "decl_english_ast", (yyvsp[-1].ast) );
      DUMP_ALIGN( "alignas_specifier_english", (yyvsp[0].align) );

      (yyval.ast) = (yyvsp[-1].ast);
      (yyval.ast)->align = (yyvsp[0].align);
      (yyval.ast)->loc = (yyloc);

      DUMP_AST( "$$_ast", (yyval.ast) );
      DUMP_END();
    }
#line 6380 "parser.c"
    break;

  case 35: /* alignas_or_width_decl_english_ast: decl_english_ast width_specifier_english_uint  */
#line 2341 "parser.y"
    {
      DUMP_START( "alignas_or_width_decl_english_ast",
                  "decl_english_ast width_specifier_english_uint" );
      DUMP_AST( "decl_english_ast", (yyvsp[-1].ast) );
      DUMP_INT( "width_specifier_english_uint", (yyvsp[0].uint_val) );

      //
      // This check has to be done now in the parser rather than later in the
      // AST since we need to use the builtin union member now.
      //
      if ( !c_ast_is_integral( (yyvsp[-1].ast) ) ) {
        print_error( &(yylsp[0]), "invalid bit-field type " );
        print_ast_type_aka( (yyvsp[-1].ast), stderr );
        EPRINTF( "; must be an integral %stype\n",
          OPT_LANG_IS( enum_BITFIELDS ) ? "or enumeration " : ""
        );
        PARSE_ABORT();
      }

      (yyval.ast) = (yyvsp[-1].ast);
      (yyval.ast)->loc = (yyloc);
      (yyval.ast)->bit_field.bit_width = (yyvsp[0].uint_val);

      DUMP_AST( "$$_ast", (yyval.ast) );
      DUMP_END();
    }
#line 6411 "parser.c"
    break;

  case 36: /* alignas_specifier_english: aligned_english uint_lit bytes_opt  */
#line 2371 "parser.y"
    {
      DUMP_START( "alignas_specifier_english", "ALIGNAS uint_lit [BYTES]" );
      DUMP_INT( "uint_lit", (yyvsp[-1].uint_val) );

      (yyval.align).kind = C_ALIGNAS_BYTES;
      (yyval.align).loc = (yyloc);
      (yyval.align).bytes = (yyvsp[-1].uint_val);

      DUMP_ALIGN( "$$_align", (yyval.align) );
      DUMP_END();
    }
#line 6427 "parser.c"
    break;

  case 37: /* alignas_specifier_english: aligned_english decl_english_ast bytes_opt  */
#line 2383 "parser.y"
    {
      DUMP_START( "alignas_specifier_english",
                  "ALIGNAS decl_english_ast [BYTES]" );
      DUMP_AST( "decl_english_ast", (yyvsp[-1].ast) );

      if ( (yyvsp[-1].ast)->kind == K_NAME ) {
        (yyval.align).kind = C_ALIGNAS_SNAME;
        (yyval.align).sname = c_sname_move( &(yyvsp[-1].ast)->sname );
      } else {
        (yyval.align).kind = C_ALIGNAS_TYPE;
        (yyval.align).type_ast = (yyvsp[-1].ast);
      }
      (yyval.align).loc = (yyloc);

      DUMP_ALIGN( "$$_align", (yyval.align) );
      DUMP_END();
    }
#line 6449 "parser.c"
    break;

  case 38: /* alignas_specifier_english: aligned_english error  */
#line 2401 "parser.y"
    {
      (yyval.align) = (c_alignas_t){ 0 };
      (yyval.align).loc = (yyloc);
      elaborate_error( "integer or type expected" );
    }
#line 6459 "parser.c"
    break;

  case 42: /* capturing_paren_capture_decl_list_english_opt: %empty  */
#line 2415 "parser.y"
                                  { slist_init( &(yyval.ast_list) ); }
#line 6465 "parser.c"
    break;

  case 43: /* capturing_paren_capture_decl_list_english_opt: Y_capturing paren_capture_decl_list_english  */
#line 2417 "parser.y"
    {
      (yyval.ast_list) = (yyvsp[0].ast_list);
    }
#line 6473 "parser.c"
    break;

  case 44: /* capturing_paren_capture_decl_list_english_opt: '[' capture_decl_list_english_opt ']'  */
#line 2421 "parser.y"
    {
      (yyval.ast_list) = (yyvsp[-1].ast_list);
    }
#line 6481 "parser.c"
    break;

  case 45: /* paren_capture_decl_list_english: '[' capture_decl_list_english_opt ']'  */
#line 2428 "parser.y"
    {
      (yyval.ast_list) = (yyvsp[-1].ast_list);
    }
#line 6489 "parser.c"
    break;

  case 46: /* paren_capture_decl_list_english: '(' capture_decl_list_english_opt ')'  */
#line 2432 "parser.y"
    {
      (yyval.ast_list) = (yyvsp[-1].ast_list);
    }
#line 6497 "parser.c"
    break;

  case 47: /* paren_capture_decl_list_english: error  */
#line 2436 "parser.y"
    {
      slist_init( &(yyval.ast_list) );
      elaborate_error( "'[' or '(' expected\n" );
    }
#line 6506 "parser.c"
    break;

  case 48: /* capture_decl_list_english_opt: %empty  */
#line 2443 "parser.y"
                                  { slist_init( &(yyval.ast_list) ); }
#line 6512 "parser.c"
    break;

  case 50: /* capture_decl_list_english: capture_decl_list_english comma_exp capture_decl_english_ast  */
#line 2450 "parser.y"
    {
      DUMP_START( "capture_decl_list_english",
                  "capture_decl_list_english ',' capture_decl_english_ast" );
      DUMP_AST_LIST( "capture_decl_list_english", (yyvsp[-2].ast_list) );
      DUMP_AST( "capture_decl_english_ast", (yyvsp[0].ast) );

      (yyval.ast_list) = (yyvsp[-2].ast_list);
      slist_push_back( &(yyval.ast_list), (yyvsp[0].ast) );

      DUMP_AST_LIST( "$$_ast_list", (yyval.ast_list) );
      DUMP_END();
    }
#line 6529 "parser.c"
    break;

  case 51: /* capture_decl_list_english: capture_decl_english_ast  */
#line 2464 "parser.y"
    {
      DUMP_START( "capture_decl_list_english",
                  "capture_decl_english_ast" );
      DUMP_AST( "capture_decl_english_ast", (yyvsp[0].ast) );

      slist_init( &(yyval.ast_list) );
      slist_push_back( &(yyval.ast_list), (yyvsp[0].ast) );

      DUMP_AST_LIST( "$$_ast_list", (yyval.ast_list) );
      DUMP_END();
    }
#line 6545 "parser.c"
    break;

  case 52: /* capture_decl_english_ast: Y_copy capture_default_opt  */
#line 2479 "parser.y"
    {
      (yyval.ast) = c_ast_new_gc( K_CAPTURE, &(yyloc) );
      (yyval.ast)->capture.kind = C_CAPTURE_COPY;
    }
#line 6554 "parser.c"
    break;

  case 53: /* capture_decl_english_ast: Y_reference capture_default_opt  */
#line 2484 "parser.y"
    {
      (yyval.ast) = c_ast_new_gc( K_CAPTURE, &(yyloc) );
      (yyval.ast)->capture.kind = C_CAPTURE_REFERENCE;
    }
#line 6563 "parser.c"
    break;

  case 54: /* capture_decl_english_ast: Y_reference Y_to name_exp  */
#line 2489 "parser.y"
    {
      (yyval.ast) = c_ast_new_gc( K_CAPTURE, &(yyloc) );
      c_sname_init_name( &(yyval.ast)->sname, (yyvsp[0].name) );
      (yyval.ast)->capture.kind = C_CAPTURE_REFERENCE;
    }
#line 6573 "parser.c"
    break;

  case 59: /* width_specifier_english_uint: Y_width uint_lit_exp bits_opt  */
#line 2505 "parser.y"
    { //
      // This check has to be done now in the parser rather than later in the
      // AST since we use 0 to mean "no bit-field."
      //
      if ( (yyvsp[-1].uint_val) == 0 ) {
        print_error( &(yylsp[-1]), "bit-field width must be > 0\n" );
        PARSE_ABORT();
      }
      (yyval.uint_val) = (yyvsp[-1].uint_val);
    }
#line 6588 "parser.c"
    break;

  case 60: /* storage_class_subset_english_type_opt: %empty  */
#line 2518 "parser.y"
                                  { (yyval.type) = T_NONE; }
#line 6594 "parser.c"
    break;

  case 61: /* storage_class_subset_english_type_opt: storage_class_subset_english_type_opt storage_class_subset_english_type  */
#line 2521 "parser.y"
    {
      DUMP_START( "storage_class_subset_english_type_opt",
                  "storage_class_subset_english_type_opt "
                  "storage_class_subset_english_type" );
      DUMP_TYPE( "storage_class_subset_english_type_opt", (yyvsp[-1].type) );
      DUMP_TYPE( "storage_class_subset_english_type", (yyvsp[0].type) );

      (yyval.type) = (yyvsp[-1].type);
      PARSE_ASSERT( c_type_add( &(yyval.type), &(yyvsp[0].type), &(yylsp[0]) ) );

      DUMP_TYPE( "$$_type", (yyval.type) );
      DUMP_END();
    }
#line 6612 "parser.c"
    break;

  case 62: /* storage_class_subset_english_type: attribute_english_atid  */
#line 2537 "parser.y"
                                  { (yyval.type) = C_TYPE_LIT_A( (yyvsp[0].tid) ); }
#line 6618 "parser.c"
    break;

  case 63: /* storage_class_subset_english_type: storage_class_subset_english_stid  */
#line 2539 "parser.y"
    {
      (yyval.type) = C_TYPE_LIT_S( (yyvsp[0].tid) );
    }
#line 6626 "parser.c"
    break;

  case 64: /* storage_class_subset_english_stid: Y_auto_TYPE  */
#line 2559 "parser.y"
                                  { (yyval.tid) = TS_auto; }
#line 6632 "parser.c"
    break;

  case 66: /* storage_class_subset_english_stid: Y_constant eval_expr_init_stid  */
#line 2562 "parser.y"
    {
      (yyval.tid) = (yyvsp[0].tid);
    }
#line 6640 "parser.c"
    break;

  case 73: /* storage_class_subset_english_stid: Y_extern linkage_stid linkage_opt  */
#line 2572 "parser.y"
    {
      (yyval.tid) = (yyvsp[-1].tid);
    }
#line 6648 "parser.c"
    break;

  case 78: /* storage_class_subset_english_stid: Y_no Y_except  */
#line 2579 "parser.y"
                                  { (yyval.tid) = TS_noexcept; }
#line 6654 "parser.c"
    break;

  case 80: /* storage_class_subset_english_stid: Y_non_empty  */
#line 2581 "parser.y"
                                  { (yyval.tid) = TS_NON_EMPTY_ARRAY; }
#line 6660 "parser.c"
    break;

  case 84: /* storage_class_subset_english_stid: Y_thread local_exp  */
#line 2585 "parser.y"
                                  { (yyval.tid) = TS_thread_local; }
#line 6666 "parser.c"
    break;

  case 90: /* storage_class_subset_english_stid: Y_pure virtual_stid_exp  */
#line 2591 "parser.y"
                                  { (yyval.tid) = TS_PURE_virtual | (yyvsp[0].tid); }
#line 6672 "parser.c"
    break;

  case 91: /* define_command: Y_define sname_english_exp as_exp decl_english_ast  */
#line 2598 "parser.y"
    {
      DUMP_START( "define_command",
                  "DEFINE sname_english AS decl_english_ast" );
      DUMP_SNAME( "sname_english_exp", (yyvsp[-2].sname) );
      DUMP_AST( "decl_english_ast", (yyvsp[0].ast) );

      // see the comment in "declare_command"
      if ( c_ast_is_name_error( (yyvsp[0].ast) ) ) {
        c_sname_cleanup( &(yyvsp[-2].sname) );
        PARSE_ABORT();
      }

      if ( !c_tid_is_any( (yyvsp[0].ast)->type.stids, TS_typedef ) ) {
        //
        // Explicitly add TS_typedef (if it doesn't have it already) to
        // prohibit cases like:
        //
        //      define eint as extern int
        //      define rint as register int
        //      define sint as static int
        //      ...
        //
        // i.e., a defined type with a storage class.  Once the semantic checks
        // pass, remove the TS_typedef.
        //
        PARSE_ASSERT(
          c_type_add( &(yyvsp[0].ast)->type, &T_TS_typedef, &(yylsp[0]) )
        );
      }
      PARSE_ASSERT( c_ast_check( (yyvsp[0].ast) ) );
      PJL_DISCARD_RV( c_ast_take_type_any( (yyvsp[0].ast), &T_TS_typedef ) );

      c_sname_set( &(yyvsp[0].ast)->sname, &(yyvsp[-2].sname) );
      if ( c_tid_is_any( (yyvsp[0].ast)->type.btids, TB_ANY_SCOPE ) )
        c_sname_local_data( &(yyvsp[0].ast)->sname )->type = (yyvsp[0].ast)->type;
      c_sname_set_all_types( &(yyvsp[0].ast)->sname );

      DUMP_AST( "$$_ast", (yyvsp[0].ast) );
      DUMP_END();

      PARSE_ASSERT( define_type( (yyvsp[0].ast), C_ENG_DECL ) );
    }
#line 6719 "parser.c"
    break;

  case 92: /* expand_command: Y_expand Y_NAME expand_command2  */
#line 2646 "parser.y"
    {
      p_arg_list_t   *const arg_list   = (yyvsp[0].ptrs)[0];
      p_token_list_t *const extra_list = (yyvsp[0].ptrs)[1];

      DUMP_START( "expand_command", "EXPAND NAME arg_list_opt extra_list_opt" );
      DUMP_STR( "name", (yyvsp[-1].name) );
      DUMP_MACRO_ARG_LIST( "arg_list", arg_list );
      DUMP_MACRO_TOKEN_LIST( "extra_list", extra_list );
      DUMP_END();

      bool const ok =
        p_macro_expand( (yyvsp[-1].name), &(yylsp[-1]), arg_list, extra_list, stdout );
      p_arg_list_cleanup( arg_list );
      free( arg_list );
      p_token_list_cleanup( extra_list );
      free( extra_list );
      free( (yyvsp[-1].name) );
      PARSE_ASSERT( ok );
    }
#line 6743 "parser.c"
    break;

  case 93: /* expand_command: Y_expand error  */
#line 2667 "parser.y"
    {
      elaborate_error( "macro name expected" );
    }
#line 6751 "parser.c"
    break;

  case 94: /* expand_command2: %empty  */
#line 2673 "parser.y"
                                  { (yyval.ptrs)[0] = (yyval.ptrs)[1] = NULL; }
#line 6757 "parser.c"
    break;

  case 95: /* expand_command2: p_extra_token_except_lparen p_extra_tokens_opt  */
#line 2689 "parser.y"
    {
      if ( (yyvsp[0].p_token_list) == NULL ) {
        (yyvsp[0].p_token_list) = MALLOC( p_token_list_t, 1 );
        slist_init( (yyvsp[0].p_token_list) );
      }
      slist_push_front( (yyvsp[0].p_token_list), (yyvsp[-1].p_token) );

      (yyval.ptrs)[0] = NULL;
      (yyval.ptrs)[1] = (yyvsp[0].p_token_list);
    }
#line 6772 "parser.c"
    break;

  case 96: /* expand_command2: '(' p_arg_list_opt ')' p_extra_tokens_opt  */
#line 2701 "parser.y"
    {
      (yyval.ptrs)[0] = (yyvsp[-2].p_arg_list);
      (yyval.ptrs)[1] = (yyvsp[0].p_token_list);
    }
#line 6781 "parser.c"
    break;

  case 98: /* p_extra_token_except_lparen: ')'  */
#line 2710 "parser.y"
    {
      (yyval.p_token) = p_token_new_loc( P_PUNCTUATOR, &(yylsp[0]), ")" );
    }
#line 6789 "parser.c"
    break;

  case 99: /* p_extra_tokens_opt: %empty  */
#line 2716 "parser.y"
                                  { (yyval.p_token_list) = NULL; }
#line 6795 "parser.c"
    break;

  case 101: /* p_extra_tokens: p_extra_tokens p_extra_token  */
#line 2722 "parser.y"
    {
      (yyval.p_token_list) = (yyvsp[-1].p_token_list);
      slist_push_back( (yyval.p_token_list), (yyvsp[0].p_token) );
    }
#line 6804 "parser.c"
    break;

  case 102: /* p_extra_tokens: p_extra_token  */
#line 2727 "parser.y"
    {
      (yyval.p_token_list) = MALLOC( p_token_list_t, 1 );
      slist_init( (yyval.p_token_list) );
      slist_push_back( (yyval.p_token_list), (yyvsp[0].p_token) );
    }
#line 6814 "parser.c"
    break;

  case 104: /* p_extra_token: '('  */
#line 2737 "parser.y"
    {
      (yyval.p_token) = p_token_new_loc( P_PUNCTUATOR, &(yylsp[0]), "(" );
    }
#line 6822 "parser.c"
    break;

  case 105: /* p_arg_list_opt: %empty  */
#line 2744 "parser.y"
    {
      (yyval.p_arg_list) = MALLOC( p_arg_list_t, 1 );
      slist_init( (yyval.p_arg_list) );
    }
#line 6831 "parser.c"
    break;

  case 107: /* p_arg_list_opt: p_comma_arg_list  */
#line 2762 "parser.y"
    {
      slist_push_back( (yyvsp[0].p_arg_list), p_token_list_new_placemarker() );
      slist_push_back( (yyvsp[0].p_arg_list), p_token_list_new_placemarker() );

      (yyval.p_arg_list) = MALLOC( p_arg_list_t, 1 );
      slist_init( (yyval.p_arg_list) );
      slist_push_list_back( (yyval.p_arg_list), (yyvsp[0].p_arg_list) );
    }
#line 6844 "parser.c"
    break;

  case 108: /* p_arg_list_opt: p_comma_arg_list p_arg_list  */
#line 2782 "parser.y"
    {
      slist_push_back( (yyvsp[-1].p_arg_list), p_token_list_new_placemarker() );
      (yyval.p_arg_list) = (yyvsp[0].p_arg_list);
      slist_push_list_front( (yyval.p_arg_list), (yyvsp[-1].p_arg_list) );
    }
#line 6854 "parser.c"
    break;

  case 109: /* p_arg_list_opt: p_comma_arg_list p_arg_list p_comma_arg_list  */
#line 2803 "parser.y"
    {
      slist_push_back( (yyvsp[-2].p_arg_list), p_token_list_new_placemarker() );
      slist_push_back( (yyvsp[0].p_arg_list), p_token_list_new_placemarker() );

      (yyval.p_arg_list) = (yyvsp[-1].p_arg_list);
      slist_push_list_front( (yyval.p_arg_list), (yyvsp[-2].p_arg_list) );
      slist_push_list_back ( (yyval.p_arg_list), (yyvsp[0].p_arg_list) );
    }
#line 6867 "parser.c"
    break;

  case 110: /* p_arg_list_opt: p_arg_list p_comma_arg_list  */
#line 2823 "parser.y"
    {
      slist_push_back( (yyvsp[0].p_arg_list), p_token_list_new_placemarker() );
      (yyval.p_arg_list) = (yyvsp[-1].p_arg_list);
      slist_push_list_back( (yyval.p_arg_list), (yyvsp[0].p_arg_list) );
    }
#line 6877 "parser.c"
    break;

  case 111: /* p_arg_list_opt: error  */
#line 2830 "parser.y"
    {
      (yyval.p_arg_list) = NULL;
      elaborate_error( "macro argument expected" );
    }
#line 6886 "parser.c"
    break;

  case 112: /* p_comma_arg_list: p_comma_arg_list ','  */
#line 2838 "parser.y"
    {
      (yyval.p_arg_list) = (yyvsp[-1].p_arg_list);
      slist_push_back( (yyval.p_arg_list), p_token_list_new_placemarker() );
    }
#line 6895 "parser.c"
    break;

  case 113: /* p_comma_arg_list: ','  */
#line 2843 "parser.y"
    {
      (yyval.p_arg_list) = MALLOC( p_arg_list_t, 1 );
      slist_init( (yyval.p_arg_list) );
    }
#line 6904 "parser.c"
    break;

  case 114: /* p_arg_list: p_arg_list p_comma_arg_list p_arg_tokens  */
#line 2864 "parser.y"
    {
      (yyval.p_arg_list) = (yyvsp[-2].p_arg_list);

      if ( !slist_empty( (yyvsp[-1].p_arg_list) ) )
        slist_push_list_back( (yyval.p_arg_list), (yyvsp[-1].p_arg_list) );

      slist_push_back( (yyval.p_arg_list), (yyvsp[0].p_token_list) );
    }
#line 6917 "parser.c"
    break;

  case 115: /* p_arg_list: p_arg_tokens  */
#line 2874 "parser.y"
    {
      (yyval.p_arg_list) = MALLOC( p_arg_list_t, 1 );
      slist_init( (yyval.p_arg_list) );
      slist_push_back( (yyval.p_arg_list), (yyvsp[0].p_token_list) );
    }
#line 6927 "parser.c"
    break;

  case 116: /* p_arg_tokens: p_arg_tokens p_arg_token_as_list  */
#line 2883 "parser.y"
    {
      (yyval.p_token_list) = (yyvsp[-1].p_token_list);
      slist_push_list_back( (yyval.p_token_list), (yyvsp[0].p_token_list) );
    }
#line 6936 "parser.c"
    break;

  case 118: /* p_arg_token_as_list: p_arg_token  */
#line 2892 "parser.y"
    {
      (yyval.p_token_list) = MALLOC( p_token_list_t, 1 );
      slist_init( (yyval.p_token_list) );
      slist_push_back( (yyval.p_token_list), (yyvsp[0].p_token) );
    }
#line 6946 "parser.c"
    break;

  case 119: /* p_arg_token_as_list: '(' p_arg_tokens_with_comma_opt ')'  */
#line 2898 "parser.y"
    {
      (yyval.p_token_list) = (yyvsp[-1].p_token_list);
      slist_push_front( (yyval.p_token_list), p_token_new_loc( P_PUNCTUATOR, &(yylsp[-2]), "(" ) );
      slist_push_back ( (yyval.p_token_list), p_token_new_loc( P_PUNCTUATOR, &(yylsp[0]), ")" ) );
    }
#line 6956 "parser.c"
    break;

  case 120: /* p_arg_token: Y_CHAR_LIT  */
#line 2907 "parser.y"
    {
      (yyval.p_token) = p_token_new_loc( P_CHAR_LIT, &(yylsp[0]), (yyvsp[0].str_val) );
    }
#line 6964 "parser.c"
    break;

  case 121: /* p_arg_token: Y_NAME  */
#line 2911 "parser.y"
    {
      (yyval.p_token) = p_token_new_loc( P_IDENTIFIER, &(yylsp[0]), (yyvsp[0].name) );
    }
#line 6972 "parser.c"
    break;

  case 122: /* p_arg_token: p_num_lit  */
#line 2915 "parser.y"
    {
      (yyval.p_token) = p_token_new_loc( P_NUM_LIT, &(yylsp[0]), check_strdup( yytext ) );
    }
#line 6980 "parser.c"
    break;

  case 123: /* p_arg_token: Y_PRE_SPACE  */
#line 2919 "parser.y"
    {
      (yyval.p_token) = p_token_new_loc( P_SPACE, &(yylsp[0]), /*literal=*/NULL );
    }
#line 6988 "parser.c"
    break;

  case 124: /* p_arg_token: Y_STR_LIT  */
#line 2923 "parser.y"
    {
      (yyval.p_token) = p_token_new_loc( P_STR_LIT, &(yylsp[0]), (yyvsp[0].str_val) );
    }
#line 6996 "parser.c"
    break;

  case 125: /* p_arg_token: p_other  */
#line 2927 "parser.y"
    {
      (yyval.p_token) = p_token_new_loc( P_OTHER, &(yylsp[0]), yytext );
    }
#line 7004 "parser.c"
    break;

  case 126: /* p_arg_token: p_punctuator  */
#line 2931 "parser.y"
    {
      (yyval.p_token) = p_token_new_loc( P_PUNCTUATOR, &(yylsp[0]), yytext );
    }
#line 7012 "parser.c"
    break;

  case 180: /* p_arg_tokens_with_comma_opt: %empty  */
#line 3003 "parser.y"
    {
      (yyval.p_token_list) = MALLOC( p_token_list_t, 1 );
      slist_init( (yyval.p_token_list) );
    }
#line 7021 "parser.c"
    break;

  case 182: /* p_arg_tokens_with_comma: p_arg_tokens_with_comma p_arg_token_with_comma_as_list  */
#line 3023 "parser.y"
    {
      (yyval.p_token_list) = (yyvsp[-1].p_token_list);
      slist_push_list_back( (yyval.p_token_list), (yyvsp[0].p_token_list) );
    }
#line 7030 "parser.c"
    break;

  case 184: /* p_arg_token_with_comma_as_list: p_arg_token_with_comma  */
#line 3032 "parser.y"
    {
      (yyval.p_token_list) = MALLOC( p_token_list_t, 1 );
      slist_init( (yyval.p_token_list) );
      slist_push_back( (yyval.p_token_list), (yyvsp[0].p_token) );
    }
#line 7040 "parser.c"
    break;

  case 185: /* p_arg_token_with_comma_as_list: '(' p_arg_tokens_with_comma_opt ')'  */
#line 3038 "parser.y"
    {
      (yyval.p_token_list) = (yyvsp[-1].p_token_list);
      slist_push_front( (yyval.p_token_list), p_token_new_loc( P_PUNCTUATOR, &(yylsp[-2]), "(" ) );
      slist_push_back ( (yyval.p_token_list), p_token_new_loc( P_PUNCTUATOR, &(yylsp[0]), ")" ) );
    }
#line 7050 "parser.c"
    break;

  case 187: /* p_arg_token_with_comma: ','  */
#line 3048 "parser.y"
    {
      (yyval.p_token) = p_token_new_loc( P_PUNCTUATOR, &(yylsp[0]), "," );
    }
#line 7058 "parser.c"
    break;

  case 198: /* explain_command: explain pc99_pointer_decl_list_c  */
#line 3115 "parser.y"
    {
      PARSE_ASSERT( c_ast_list_check( &(yyvsp[0].ast_list) ) );
      c_ast_list_english( &(yyvsp[0].ast_list), stdout );
    }
#line 7067 "parser.c"
    break;

  case 200: /* $@2: %empty  */
#line 3133 "parser.y"
                       { in_attr.is_typename = true; }
#line 7073 "parser.c"
    break;

  case 203: /* explain_command: explain extern_linkage_c_stid_opt using_decl_c_ast  */
#line 3154 "parser.y"
    {
      DUMP_START( "explain_command",
                  "EXPLAIN extern_linkage_c_stid_opt using_decl_c_ast" );
      DUMP_TID( "extern_linkage_c_stid_opt", (yyvsp[-1].tid) );
      DUMP_AST( "using_decl_c_ast", (yyvsp[0].ast) );

      PARSE_ASSERT(
        c_type_add_tid( &(yyvsp[0].ast)->type, (yyvsp[-1].tid), &(yylsp[-1]) )
      );

      DUMP_AST( "$$_ast", (yyvsp[0].ast) );
      DUMP_END();

      PARSE_ASSERT( c_ast_check( (yyvsp[0].ast) ) );
      c_ast_english( (yyvsp[0].ast), C_ENG_DECL, stdout );
      PUTC( '\n' );
    }
#line 7095 "parser.c"
    break;

  case 204: /* explain_command: explain sname_c  */
#line 3177 "parser.y"
    {
      print_error_unknown_name( &(yylsp[0]), &(yyvsp[0].sname) );
      c_sname_cleanup( &(yyvsp[0].sname) );
      PARSE_ABORT();
    }
#line 7105 "parser.c"
    break;

  case 205: /* explain_command: explain error  */
#line 3184 "parser.y"
    {
      elaborate_error( "cast or declaration expected" );
    }
#line 7113 "parser.c"
    break;

  case 206: /* explain: Y_explain  */
#line 3191 "parser.y"
    { //
      // Set our mode to deciphering gibberish into English and specifically
      // tell the lexer to return cdecl keywords (e.g., "func") as ordinary
      // names, otherwise gibberish like:
      //
      //      int func(void);
      //
      // would result in a parser error.
      //
      gibberish_to_english();
    }
#line 7129 "parser.c"
    break;

  case 207: /* $@3: %empty  */
#line 3208 "parser.y"
    { //
      // We want cdecl commands (like "declare", etc.), other cdecl keywords
      // (like "cast", "commands", "english", "options", etc.), and C/C++
      // keywords (like "const", "static", "typedef", etc.) all to be returned
      // as just strings so we don't have to enumerate all the possible tokens
      // in the grammar.
      //
      lexer_find &= ~(LEXER_FIND_C_KEYWORDS | LEXER_FIND_CDECL_KEYWORDS);
    }
#line 7143 "parser.c"
    break;

  case 208: /* help_command: '?' $@3 help_what_opt  */
#line 3218 "parser.y"
    {
      bool const ok = print_help( (yyvsp[0].name), &(yylsp[0]) );
      free( (yyvsp[0].name) );
      PARSE_ASSERT( ok );
    }
#line 7153 "parser.c"
    break;

  case 209: /* help_what_opt: %empty  */
#line 3226 "parser.y"
                                  { (yyval.name) = NULL; }
#line 7159 "parser.c"
    break;

  case 211: /* help_what_opt: '#' Y_NAME  */
#line 3228 "parser.y"
                                  { (yyval.name) = str_realloc_pcat( "#", "", (yyvsp[0].name) ); }
#line 7165 "parser.c"
    break;

  case 212: /* help_what_opt: '#' error  */
#line 3230 "parser.y"
    {
      (yyval.name) = NULL;
      elaborate_error( "\"#define\", \"#include\", or \"#undef\" expected" );
    }
#line 7174 "parser.c"
    break;

  case 213: /* help_what_opt: error  */
#line 3235 "parser.y"
    {
      (yyval.name) = NULL;
      elaborate_error(
        "<command>, \"commands\", \"english\", or \"options\" expected"
      );
    }
#line 7185 "parser.c"
    break;

  case 217: /* preprocessor_command: '#' Y_PRE_elif  */
#line 3252 "parser.y"
    {
      UNSUPPORTED( &(yylsp[0]), "\"#elif\"" );
    }
#line 7193 "parser.c"
    break;

  case 218: /* preprocessor_command: '#' Y_PRE_elifdef  */
#line 3256 "parser.y"
    {
      UNSUPPORTED( &(yylsp[0]), "\"#elifdef\"" );
    }
#line 7201 "parser.c"
    break;

  case 219: /* preprocessor_command: '#' Y_PRE_elifndef  */
#line 3260 "parser.y"
    {
      UNSUPPORTED( &(yylsp[0]), "\"#elifdef\"" );
    }
#line 7209 "parser.c"
    break;

  case 220: /* preprocessor_command: '#' Y_PRE_else  */
#line 3264 "parser.y"
    {
      UNSUPPORTED( &(yylsp[0]), "\"#else\"" );
    }
#line 7217 "parser.c"
    break;

  case 221: /* preprocessor_command: '#' Y_PRE_embed  */
#line 3268 "parser.y"
    {
      UNSUPPORTED( &(yylsp[0]), "\"#embed\"" );
    }
#line 7225 "parser.c"
    break;

  case 222: /* preprocessor_command: '#' Y_PRE_error  */
#line 3272 "parser.y"
    {
      UNSUPPORTED( &(yylsp[0]), "\"#error\"" );
    }
#line 7233 "parser.c"
    break;

  case 223: /* preprocessor_command: '#' Y_PRE_if  */
#line 3276 "parser.y"
    {
      UNSUPPORTED( &(yylsp[0]), "\"#if\"" );
    }
#line 7241 "parser.c"
    break;

  case 224: /* preprocessor_command: '#' Y_PRE_ifdef  */
#line 3280 "parser.y"
    {
      UNSUPPORTED( &(yylsp[0]), "\"#ifdef\"" );
    }
#line 7249 "parser.c"
    break;

  case 225: /* preprocessor_command: '#' Y_PRE_ifndef  */
#line 3284 "parser.y"
    {
      UNSUPPORTED( &(yylsp[0]), "\"#ifndef\"" );
    }
#line 7257 "parser.c"
    break;

  case 226: /* preprocessor_command: '#' Y_PRE_line  */
#line 3288 "parser.y"
    {
      UNSUPPORTED( &(yylsp[0]), "\"#line\"" );
    }
#line 7265 "parser.c"
    break;

  case 227: /* preprocessor_command: '#' Y_PRE_pragma  */
#line 3292 "parser.y"
    {
      UNSUPPORTED( &(yylsp[0]), "\"#pragma\"" );
    }
#line 7273 "parser.c"
    break;

  case 228: /* preprocessor_command: '#' Y_PRE_warning  */
#line 3296 "parser.y"
    {
      UNSUPPORTED( &(yylsp[0]), "\"#warning\"" );
    }
#line 7281 "parser.c"
    break;

  case 229: /* preprocessor_command: '#' error  */
#line 3300 "parser.y"
    {
      elaborate_error( "\"#define\", \"#include\", or \"#undef\" expected" );
    }
#line 7289 "parser.c"
    break;

  case 230: /* p_define: Y_PRE_define name_exp p_paren_param_list_opt p_replace_list_opt  */
#line 3308 "parser.y"
    {
      DUMP_START( "p_define",
                  "#define NAME p_paren_param_list_opt p_replace_list_opt" );
      DUMP_STR( "name", (yyvsp[-2].name) );
      DUMP_MACRO_PARAM_LIST( "p_paren_param_list_opt", (yyvsp[-1].p_param_list) );
      DUMP_MACRO_TOKEN_LIST( "p_replace_list_opt", (yyvsp[0].p_token_list) );

      c_typedef_t const *const tdef = c_typedef_find_name( (yyvsp[-2].name) );
      if ( tdef != NULL ) {
        if ( tdef->is_predefined ) {
          print_warning( &(yylsp[-2]),
            "\"%s\" is a predefined type since %s\n",
            (yyvsp[-2].name),
            c_lang_name( c_lang_oldest( tdef->lang_ids ) )
          );
        }
        else {
          print_warning( &(yylsp[-2]),
            "\"%s\" previously defined as type (\"",
            (yyvsp[-2].name)
          );
          print_type_decl( tdef, tdef->decl_flags, stderr );
          EPUTS( "\")\n" );
        }
      }

      p_macro_t *const macro =
        p_macro_define( (yyvsp[-2].name), &(yylsp[-2]), (yyvsp[-1].p_param_list), (yyvsp[0].p_token_list) );
      p_param_list_cleanup( (yyvsp[-1].p_param_list) );
      free( (yyvsp[-1].p_param_list) );
      p_token_list_cleanup( (yyvsp[0].p_token_list) );
      free( (yyvsp[0].p_token_list) );
      PARSE_ASSERT( macro != NULL );

      DUMP_MACRO( "macro", macro );
      DUMP_END();
    }
#line 7331 "parser.c"
    break;

  case 231: /* p_paren_param_list_opt: %empty  */
#line 3347 "parser.y"
                                  { (yyval.p_param_list) = NULL; }
#line 7337 "parser.c"
    break;

  case 232: /* p_paren_param_list_opt: '(' p_param_list_opt ')'  */
#line 3348 "parser.y"
                                  { (yyval.p_param_list) = (yyvsp[-1].p_param_list); }
#line 7343 "parser.c"
    break;

  case 233: /* p_param_list_opt: %empty  */
#line 3352 "parser.y"
    { //
      // Use an empty list to distinguish a macro with an empty parameter list
      // from one with no parameter list.
      //
      //      #define M   X       // no parameter list: use NULL
      //      #define F() #X      // empty parameter list: use empty list
      //
      (yyval.p_param_list) = MALLOC( p_param_list_t, 1 );
      slist_init( (yyval.p_param_list) );
    }
#line 7358 "parser.c"
    break;

  case 235: /* p_param_list: p_param_list comma_exp p_param  */
#line 3367 "parser.y"
    {
      DUMP_START( "p_param_list", "p_param" );
      DUMP_MACRO_PARAM_LIST( "p_param_list", (yyvsp[-2].p_param_list) );
      DUMP_STR( "p_param", (yyvsp[0].p_param)->name );

      (yyval.p_param_list) = (yyvsp[-2].p_param_list);
      slist_push_back( (yyval.p_param_list), (yyvsp[0].p_param) );

      DUMP_MACRO_PARAM_LIST( "$$_list", (yyval.p_param_list) );
      DUMP_END();
    }
#line 7374 "parser.c"
    break;

  case 236: /* p_param_list: p_param  */
#line 3380 "parser.y"
    {
      DUMP_START( "p_param_list", "p_param" );
      DUMP_STR( "p_param", (yyvsp[0].p_param)->name );

      (yyval.p_param_list) = MALLOC( p_param_list_t, 1 );
      slist_init( (yyval.p_param_list) );
      slist_push_back( (yyval.p_param_list), (yyvsp[0].p_param) );

      DUMP_MACRO_PARAM_LIST( "$$_list", (yyval.p_param_list) );
      DUMP_END();
    }
#line 7390 "parser.c"
    break;

  case 237: /* p_param: Y_NAME  */
#line 3395 "parser.y"
    {
      (yyval.p_param) = MALLOC( p_param_t, 1 );
      *(yyval.p_param) = (p_param_t){ .name = (yyvsp[0].name), .loc = (yylsp[0]) };
    }
#line 7399 "parser.c"
    break;

  case 238: /* p_param: "..."  */
#line 3400 "parser.y"
    {
      (yyval.p_param) = MALLOC( p_param_t, 1 );
      *(yyval.p_param) = (p_param_t){ .name = check_strdup( L_ELLIPSIS ), .loc = (yylsp[0]) };
    }
#line 7408 "parser.c"
    break;

  case 239: /* p_param: error  */
#line 3405 "parser.y"
    {
      (yyval.p_param) = NULL;
      if ( OPT_LANG_IS( VARIADIC_MACROS ) )
        elaborate_error( "parameter name or \"...\" expected" );
      else
        elaborate_error( "parameter name expected" );
    }
#line 7420 "parser.c"
    break;

  case 240: /* p_replace_list_opt: %empty  */
#line 3415 "parser.y"
                                  { (yyval.p_token_list) = NULL; }
#line 7426 "parser.c"
    break;

  case 242: /* p_replace_list: p_replace_list p_replace_token  */
#line 3421 "parser.y"
    {
      (yyval.p_token_list) = (yyvsp[-1].p_token_list);
      slist_push_back( (yyval.p_token_list), (yyvsp[0].p_token) );
    }
#line 7435 "parser.c"
    break;

  case 243: /* p_replace_list: p_replace_token  */
#line 3427 "parser.y"
    {
      (yyval.p_token_list) = MALLOC( p_token_list_t, 1 );
      slist_init( (yyval.p_token_list) );
      slist_push_back( (yyval.p_token_list), (yyvsp[0].p_token) );
    }
#line 7445 "parser.c"
    break;

  case 244: /* p_replace_token: p_arg_token  */
#line 3436 "parser.y"
    {
      if ( p_token_is_punct( (yyvsp[0].p_token), '#' ) ) {
        //
        // A '#' macro argument token is an ordinary '#', but as a replacement
        // token, retroactively make it P_STRINGIFY.
        //
        (yyvsp[0].p_token)->kind = P_STRINGIFY;
      }
      (yyval.p_token) = (yyvsp[0].p_token);
    }
#line 7460 "parser.c"
    break;

  case 245: /* p_replace_token: '('  */
#line 3447 "parser.y"
    {
      (yyval.p_token) = p_token_new_loc( P_PUNCTUATOR, &(yylsp[0]), "(" );
    }
#line 7468 "parser.c"
    break;

  case 246: /* p_replace_token: ')'  */
#line 3451 "parser.y"
    {
      (yyval.p_token) = p_token_new_loc( P_PUNCTUATOR, &(yylsp[0]), ")" );
    }
#line 7476 "parser.c"
    break;

  case 247: /* p_replace_token: ','  */
#line 3455 "parser.y"
    {
      (yyval.p_token) = p_token_new_loc( P_PUNCTUATOR, &(yylsp[0]), "," );
    }
#line 7484 "parser.c"
    break;

  case 248: /* p_replace_token: "##"  */
#line 3459 "parser.y"
    {
      (yyval.p_token) = p_token_new_loc( P_CONCAT, &(yylsp[0]), /*literal=*/NULL );
    }
#line 7492 "parser.c"
    break;

  case 249: /* p_replace_token: Y_PRE___VA_ARGS__  */
#line 3463 "parser.y"
    {
      (yyval.p_token) = p_token_new_loc( P___VA_ARGS__, &(yylsp[0]), /*literal=*/NULL );
    }
#line 7500 "parser.c"
    break;

  case 250: /* p_replace_token: Y_PRE___VA_OPT__  */
#line 3467 "parser.y"
    {
      (yyval.p_token) = p_token_new_loc( P___VA_OPT__, &(yylsp[0]), /*literal=*/NULL );
    }
#line 7508 "parser.c"
    break;

  case 251: /* p_undef: Y_PRE_undef name_exp  */
#line 3474 "parser.y"
    {
      PARSE_ASSERT( p_macro_undef( (yyvsp[0].name), &(yylsp[0]) ) );
    }
#line 7516 "parser.c"
    break;

  case 252: /* quit_command: Y_quit  */
#line 3482 "parser.y"
                                  { cdecl_quit(); }
#line 7522 "parser.c"
    break;

  case 254: /* set_command: Y_set  */
#line 3495 "parser.y"
    {
      PARSE_ASSERT( set_option( NULL, NULL, NULL, NULL ) );
    }
#line 7530 "parser.c"
    break;

  case 258: /* set_option: Y_SET_OPTION set_option_value_opt  */
#line 3508 "parser.y"
    {
      bool const ok = set_option( (yyvsp[-1].name), &(yylsp[-1]), (yyvsp[0].str_val), &(yylsp[0]) );
      free( (yyvsp[-1].name) );
      free( (yyvsp[0].str_val) );
      PARSE_ASSERT( ok );
    }
#line 7541 "parser.c"
    break;

  case 259: /* set_option_value_opt: %empty  */
#line 3517 "parser.y"
                                  { (yyval.str_val) = NULL; }
#line 7547 "parser.c"
    break;

  case 260: /* set_option_value_opt: '=' Y_SET_OPTION  */
#line 3518 "parser.y"
                                  { (yyval.str_val) = (yyvsp[0].name); (yyloc) = (yylsp[0]); }
#line 7553 "parser.c"
    break;

  case 261: /* set_option_value_opt: '=' error  */
#line 3520 "parser.y"
    {
      (yyval.str_val) = NULL;
      elaborate_error( "option value expected" );
    }
#line 7562 "parser.c"
    break;

  case 262: /* show_command: Y_show any_typedef_tdef show_format_opt  */
#line 3530 "parser.y"
    {
      DUMP_START( "show_command", "SHOW any_typedef_tdef show_format_opt" );
      DUMP_AST( "any_typedef__ast", (yyvsp[-1].tdef)->ast );
      DUMP_INT( "show_format_opt", (yyvsp[0].flags) );
      DUMP_END();

      show_type( (yyvsp[-1].tdef), (yyvsp[0].flags), stdout );
    }
#line 7575 "parser.c"
    break;

  case 263: /* show_command: Y_show any_typedef_tdef Y_as show_format_exp  */
#line 3540 "parser.y"
    {
      DUMP_START( "show_command", "SHOW any_typedef_tdef AS show_format_exp" );
      DUMP_AST( "any_typedef__ast", (yyvsp[-2].tdef)->ast );
      DUMP_INT( "show_format_exp", (yyvsp[0].flags) );
      DUMP_END();

      show_type( (yyvsp[-2].tdef), (yyvsp[0].flags), stdout );
    }
#line 7588 "parser.c"
    break;

  case 264: /* show_command: Y_show show_types_opt glob_opt show_format_opt  */
#line 3550 "parser.y"
    {
      bool const showed_any = show_types( (yyvsp[-2].show), (yyvsp[-1].name), (yyvsp[0].flags), stdout );
      if ( (yyvsp[-1].name) != NULL && !showed_any ) {
        print_error( &(yylsp[-1]), "\"%s\": no such type or macro defined", (yyvsp[-1].name) );
        print_suggestions( DYM_C_MACROS | DYM_C_TYPES, (yyvsp[-1].name) );
        EPUTC( '\n' );
      }
      free( (yyvsp[-1].name) );
      PARSE_ASSERT( showed_any );
    }
#line 7603 "parser.c"
    break;

  case 265: /* show_command: Y_show show_types_opt glob_opt Y_as show_format_exp  */
#line 3562 "parser.y"
    {
      bool const showed_any = show_types( (yyvsp[-3].show), (yyvsp[-2].name), (yyvsp[0].flags), stdout );
      if ( !showed_any ) {
        print_error( &(yylsp[-2]), "\"%s\": no such type or macro defined", (yyvsp[-2].name) );
        print_suggestions( DYM_C_MACROS | DYM_C_TYPES, (yyvsp[-2].name) );
        EPUTC( '\n' );
      }
      free( (yyvsp[-2].name) );
      PARSE_ASSERT( showed_any );
    }
#line 7618 "parser.c"
    break;

  case 266: /* show_command: Y_show show_types_opt Y_macros  */
#line 3574 "parser.y"
    {
      show_macros( (yyvsp[-1].show), stdout );
    }
#line 7626 "parser.c"
    break;

  case 267: /* show_command: Y_show Y_NAME  */
#line 3579 "parser.y"
    {
      bool ok = false;

      //
      // Check to see if $name is a macro here rather than in the lexer since
      // this is the only place in the cdecl grammar where a name can be a
      // macro since cdecl doesn't support using macros everywhere.
      //
      p_macro_t const *const macro = p_macro_find( (yyvsp[0].name) );
      if ( macro == NULL ) {
        print_error( &(yylsp[0]), "\"%s\": no such type or macro defined", (yyvsp[0].name) );
        print_suggestions( DYM_C_MACROS | DYM_C_TYPES, (yyvsp[0].name) );
        EPUTC( '\n' );
      }
      else if ( !(ok = show_macro( macro, stdout )) ) {
        c_lang_id_t const lang_ids = (*macro->dyn_fn)( /*ptoken=*/NULL );
        print_error( &(yylsp[0]),
          "\"%s\" not supported%s\n",
          (yyvsp[0].name), c_lang_which( lang_ids )
        );
      }

      free( (yyvsp[0].name) );
      if ( !ok )
        PARSE_ABORT();
    }
#line 7657 "parser.c"
    break;

  case 268: /* show_command: Y_show error  */
#line 3607 "parser.y"
    {
      elaborate_error(
        "type or macro name, or \"all\", \"predefined\", or \"user\" expected"
      );
    }
#line 7667 "parser.c"
    break;

  case 269: /* show_format: Y_english  */
#line 3615 "parser.y"
                                  { (yyval.flags) = C_ENG_DECL; }
#line 7673 "parser.c"
    break;

  case 270: /* show_format: Y_typedef  */
#line 3616 "parser.y"
                                  { (yyval.flags) = C_GIB_TYPEDEF; }
#line 7679 "parser.c"
    break;

  case 271: /* show_format: Y_using  */
#line 3618 "parser.y"
    {
      if ( !OPT_LANG_IS( using_DECLS ) ) {
        print_error( &(yylsp[0]),
          "\"using\" not supported%s\n",
          C_LANG_WHICH( using_DECLS )
        );
        PARSE_ABORT();
      }
      (yyval.flags) = C_GIB_USING;
    }
#line 7694 "parser.c"
    break;

  case 273: /* show_format_exp: error  */
#line 3633 "parser.y"
    {
      if ( OPT_LANG_IS( using_DECLS ) )
        elaborate_error( "\"english\", \"typedef\", or \"using\" expected" );
      else
        elaborate_error( "\"english\" or \"typedef\" expected" );
    }
#line 7705 "parser.c"
    break;

  case 274: /* show_format_opt: %empty  */
#line 3642 "parser.y"
                                  { (yyval.flags) = 0/*as declared*/; }
#line 7711 "parser.c"
    break;

  case 276: /* show_types_opt: %empty  */
#line 3647 "parser.y"
                                  { (yyval.show) = CDECL_SHOW_USER_DEFINED; }
#line 7717 "parser.c"
    break;

  case 277: /* show_types_opt: Y_all predefined_or_user_types_opt  */
#line 3649 "parser.y"
    {
      (yyval.show) = (yyvsp[0].show) | CDECL_SHOW_OPT_IGNORE_LANG;
    }
#line 7725 "parser.c"
    break;

  case 278: /* show_types_opt: Y_predefined  */
#line 3652 "parser.y"
                                  { (yyval.show) = CDECL_SHOW_PREDEFINED; }
#line 7731 "parser.c"
    break;

  case 279: /* show_types_opt: Y_user  */
#line 3653 "parser.y"
                                  { (yyval.show) = CDECL_SHOW_USER_DEFINED; }
#line 7737 "parser.c"
    break;

  case 280: /* predefined_or_user_types_opt: %empty  */
#line 3658 "parser.y"
    {
      (yyval.show) = CDECL_SHOW_PREDEFINED | CDECL_SHOW_USER_DEFINED;
    }
#line 7745 "parser.c"
    break;

  case 281: /* predefined_or_user_types_opt: Y_predefined  */
#line 3661 "parser.y"
                                  { (yyval.show) = CDECL_SHOW_PREDEFINED; }
#line 7751 "parser.c"
    break;

  case 282: /* predefined_or_user_types_opt: Y_user  */
#line 3662 "parser.y"
                                  { (yyval.show) = CDECL_SHOW_USER_DEFINED; }
#line 7757 "parser.c"
    break;

  case 286: /* $@4: %empty  */
#line 3691 "parser.y"
    {
      ia_type_ast_push( (yyvsp[0].ast) );
    }
#line 7765 "parser.c"
    break;

  case 287: /* c_style_cast_expr_c: '(' type_c_ast $@4 cast_c_astp_opt rparen_exp sname_c_opt  */
#line 3695 "parser.y"
    {
      ia_type_ast_pop();

      DUMP_START( "explain_command",
                  "EXPLAIN '(' type_c_ast cast_c_astp_opt ')' sname_c_opt" );
      DUMP_AST( "type_c_ast", (yyvsp[-4].ast) );
      DUMP_AST_PAIR( "cast_c_astp_opt", (yyvsp[-2].ast_pair) );
      DUMP_SNAME( "sname_c_opt", (yyvsp[0].sname) );

      c_ast_t *const cast_ast = c_ast_new_gc( K_CAST, &(yyloc) );
      cast_ast->sname = c_sname_move( &(yyvsp[0].sname) );
      cast_ast->cast.kind = C_CAST_C;
      cast_ast->cast.to_ast =
        c_ast_patch_placeholder( (yyvsp[-4].ast), (yyvsp[-2].ast_pair).ast );

      DUMP_AST( "$$_ast", cast_ast );
      DUMP_END();

      PARSE_ASSERT( c_ast_check( cast_ast ) );
      c_ast_english( cast_ast, C_ENG_DECL, stdout );
      PUTC( '\n' );
    }
#line 7792 "parser.c"
    break;

  case 288: /* c_style_cast_expr_c: '(' pc99_pointer_decl_list_c rparen_exp  */
#line 3728 "parser.y"
    {
      PARSE_ASSERT( c_ast_list_check( &(yyvsp[-1].ast_list) ) );
      c_ast_list_english( &(yyvsp[-1].ast_list), stdout );
    }
#line 7801 "parser.c"
    break;

  case 289: /* $@5: %empty  */
#line 3738 "parser.y"
    {
      ia_type_ast_push( (yyvsp[0].ast) );
    }
#line 7809 "parser.c"
    break;

  case 290: /* new_style_cast_expr_c: new_style_cast_c lt_exp type_c_ast $@5 cast_c_astp_opt gt_exp lparen_exp sname_c_exp rparen_exp  */
#line 3742 "parser.y"
    {
      ia_type_ast_pop();

      DUMP_START( "explain_command",
                  "EXPLAIN new_style_cast_c"
                  "'<' type_c_ast cast_c_astp_opt '>' '(' sname ')'" );
      DUMP_STR( "new_style_cast_c", c_cast_english( (yyvsp[-8].cast_kind) ) );
      DUMP_AST( "type_c_ast", (yyvsp[-6].ast) );
      DUMP_AST_PAIR( "cast_c_astp_opt", (yyvsp[-4].ast_pair) );
      DUMP_SNAME( "sname_c_exp", (yyvsp[-1].sname) );

      c_ast_t *const cast_ast = c_ast_new_gc( K_CAST, &(yyloc) );
      cast_ast->sname = c_sname_move( &(yyvsp[-1].sname) );
      cast_ast->cast.kind = (yyvsp[-8].cast_kind);
      cast_ast->cast.to_ast =
        c_ast_patch_placeholder( (yyvsp[-6].ast), (yyvsp[-4].ast_pair).ast );

      DUMP_AST( "$$_ast", cast_ast );
      DUMP_END();

      PARSE_ASSERT( c_ast_check( cast_ast ) );
      c_ast_english( cast_ast, C_ENG_DECL, stdout );
      PUTC( '\n' );
    }
#line 7838 "parser.c"
    break;

  case 291: /* new_style_cast_c: Y_const_cast  */
#line 3769 "parser.y"
                                  { (yyval.cast_kind) = C_CAST_CONST;        }
#line 7844 "parser.c"
    break;

  case 292: /* new_style_cast_c: Y_dynamic_cast  */
#line 3770 "parser.y"
                                  { (yyval.cast_kind) = C_CAST_DYNAMIC;      }
#line 7850 "parser.c"
    break;

  case 293: /* new_style_cast_c: Y_reinterpret_cast  */
#line 3771 "parser.y"
                                  { (yyval.cast_kind) = C_CAST_REINTERPRET;  }
#line 7856 "parser.c"
    break;

  case 294: /* new_style_cast_c: Y_static_cast  */
#line 3772 "parser.y"
                                  { (yyval.cast_kind) = C_CAST_STATIC;       }
#line 7862 "parser.c"
    break;

  case 295: /* $@6: %empty  */
#line 3782 "parser.y"
                                  { in_attr.align = (yyvsp[0].align); }
#line 7868 "parser.c"
    break;

  case 296: /* $@7: %empty  */
#line 3783 "parser.y"
                                  { in_attr.is_typename = (yyvsp[0].flag); }
#line 7874 "parser.c"
    break;

  case 298: /* alignas_specifier_c: alignas lparen_exp uint_lit rparen_exp  */
#line 3789 "parser.y"
    {
      DUMP_START( "alignas_specifier_c", "ALIGNAS '(' uint_lit ')'" );
      DUMP_INT( "uint_lit", (yyvsp[-1].uint_val) );

      (yyval.align).kind = C_ALIGNAS_BYTES;
      (yyval.align).loc = (yyloc);
      (yyval.align).bytes = (yyvsp[-1].uint_val);

      DUMP_ALIGN( "$$_align", (yyval.align) );
      DUMP_END();
    }
#line 7890 "parser.c"
    break;

  case 299: /* alignas_specifier_c: alignas lparen_exp sname_c rparen_exp  */
#line 3802 "parser.y"
    {
      DUMP_START( "alignas_specifier_c", "ALIGNAS '(' sname_c ')'" );
      DUMP_SNAME( "sname", (yyvsp[-1].sname) );

      (yyval.align).kind = C_ALIGNAS_SNAME;
      (yyval.align).loc = (yyloc);
      (yyval.align).sname = c_sname_move( &(yyvsp[-1].sname) );

      DUMP_ALIGN( "$$_align", (yyval.align) );
      DUMP_END();
    }
#line 7906 "parser.c"
    break;

  case 300: /* $@8: %empty  */
#line 3814 "parser.y"
                                            { ia_type_ast_push( (yyvsp[0].ast) ); }
#line 7912 "parser.c"
    break;

  case 301: /* alignas_specifier_c: alignas lparen_exp type_c_ast $@8 cast_c_astp_opt rparen_exp  */
#line 3816 "parser.y"
    {
      ia_type_ast_pop();

      DUMP_START( "alignas_specifier_c",
                  "ALIGNAS '(' type_c_ast cast_c_astp_opt ')'" );
      DUMP_AST( "type_c_ast", (yyvsp[-3].ast) );
      DUMP_AST_PAIR( "cast_c_astp_opt", (yyvsp[-1].ast_pair) );

      (yyval.align).kind = C_ALIGNAS_TYPE;
      (yyval.align).loc = (yyloc);
      (yyval.align).type_ast = c_ast_patch_placeholder( (yyvsp[-3].ast), (yyvsp[-1].ast_pair).ast );

      DUMP_ALIGN( "$$_align", (yyval.align) );
      DUMP_END();
    }
#line 7932 "parser.c"
    break;

  case 302: /* alignas_specifier_c: alignas lparen_exp error ')'  */
#line 3833 "parser.y"
    {
      elaborate_error( "integer or type expected" );
    }
#line 7940 "parser.c"
    break;

  case 305: /* asm_declaration_c: Y_asm lparen_exp str_lit_exp rparen_exp  */
#line 3847 "parser.y"
    {
      free( (yyvsp[-1].str_val) );
      UNSUPPORTED( &(yylsp[-3]), "asm declarations" );
    }
#line 7949 "parser.c"
    break;

  case 309: /* $@9: %empty  */
#line 3866 "parser.y"
    {
      PARSE_ASSERT( is_nested_type_ok( &(yylsp[0]) ) );
      gibberish_to_english();           // see the comment in "explain"
    }
#line 7958 "parser.c"
    break;

  case 310: /* $@10: %empty  */
#line 3871 "parser.y"
    {
      c_type_t const *const cur_type =
        c_sname_local_type( &in_attr.scope_sname );
      if ( c_tid_is_any( cur_type->btids, TB_ANY_CLASS ) ) {
        char const *const cur_name = c_sname_local_name( &in_attr.scope_sname );
        char const *const mbr_name = c_sname_local_name( &(yyvsp[0].sname) );
        if ( strcmp( mbr_name, cur_name ) == 0 ) {
          print_error( &(yylsp[0]),
            "\"%s\": member has the same name as its enclosing %s\n",
            mbr_name, c_type_gibberish( cur_type )
          );
          c_sname_cleanup( &(yyvsp[0].sname) );
          PARSE_ABORT();
        }
      }

      DUMP_START( "class_struct_union_declaration_c",
                  "class_struct_union_btid any_sname_c_exp" );
      DUMP_SNAME( "in_attr__scope_sname", in_attr.scope_sname );
      DUMP_TID( "class_struct_union_btid", (yyvsp[-2].tid) );
      DUMP_SNAME( "any_sname_c_exp", (yyvsp[0].sname) );

      c_sname_append_sname( &in_attr.scope_sname, &(yyvsp[0].sname) );

      c_sname_local_data( &in_attr.scope_sname )->type =
        C_TYPE_LIT_B( (yyvsp[-2].tid) );
      c_sname_set_all_types( &in_attr.scope_sname );

      c_sname_t csu_sname = c_sname_dup( &in_attr.scope_sname );
      c_sname_append_sname( &csu_sname, &(yyvsp[0].sname) );

      c_ast_t *const csu_ast = c_ast_new_gc( K_CLASS_STRUCT_UNION, &(yylsp[0]) );
      csu_ast->sname = csu_sname;
      csu_ast->type.btids = c_tid_check( (yyvsp[-2].tid), C_TPID_BASE );
      c_sname_init_name(
        &csu_ast->csu.csu_sname,
        check_strdup( c_sname_local_name( &csu_ast->sname ) )
      );

      DUMP_AST( "$$_ast", csu_ast );
      DUMP_END();

      PARSE_ASSERT( define_type( csu_ast, C_GIB_TYPEDEF ) );
    }
#line 8007 "parser.c"
    break;

  case 312: /* $@11: %empty  */
#line 3923 "parser.y"
    {
      PARSE_ASSERT( is_nested_type_ok( &(yylsp[0]) ) );
      gibberish_to_english();           // see the comment in "explain"
    }
#line 8016 "parser.c"
    break;

  case 313: /* enum_declaration_c: enum_btids $@11 any_sname_c_exp enum_fixed_type_c_ast_opt  */
#line 3928 "parser.y"
    {
      DUMP_START( "enum_declaration_c",
                  "enum_btids any_sname_c_exp enum_fixed_type_c_ast_opt" );
      DUMP_TID( "enum_btids", (yyvsp[-3].tid) );
      DUMP_SNAME( "any_sname_c_exp", (yyvsp[-1].sname) );
      DUMP_AST( "enum_fixed_type_c_ast_opt", (yyvsp[0].ast) );

      c_sname_t enum_sname = c_sname_dup( &in_attr.scope_sname );
      c_sname_append_sname( &enum_sname, &(yyvsp[-1].sname) );

      c_sname_local_data( &enum_sname )->type = C_TYPE_LIT_B( (yyvsp[-3].tid) );
      c_sname_set_all_types( &enum_sname );

      c_ast_t *const enum_ast = c_ast_new_gc( K_ENUM, &(yylsp[-1]) );
      enum_ast->sname = enum_sname;
      enum_ast->type.btids = c_tid_check( (yyvsp[-3].tid), C_TPID_BASE );
      c_ast_set_parent( (yyvsp[0].ast), enum_ast );
      c_sname_init_name(
        &enum_ast->enum_.enum_sname,
        check_strdup( c_sname_local_name( &enum_ast->sname ) )
      );

      DUMP_AST( "$$_ast", enum_ast );
      DUMP_END();

      PARSE_ASSERT( define_type( enum_ast, C_GIB_TYPEDEF ) );
    }
#line 8048 "parser.c"
    break;

  case 314: /* $@12: %empty  */
#line 3962 "parser.y"
    {
      gibberish_to_english();           // see the comment in "explain"
    }
#line 8056 "parser.c"
    break;

  case 315: /* $@13: %empty  */
#line 3966 "parser.y"
    {
      DUMP_START( "namespace_declaration_c",
                  "namespace_type namespace_sname_c_exp" );
      DUMP_SNAME( "in_attr__scope_sname", in_attr.scope_sname );
      DUMP_TYPE( "namespace_type", (yyvsp[-2].type) );
      DUMP_SNAME( "namespace_sname_c_exp", (yyvsp[0].sname) );

      //
      // Nested namespace declarations are supported only in C++17 and later.
      // (However, we always allow them in configuration files.)
      //
      // This check has to be done now in the parser rather than later in the
      // AST because the AST has no "memory" of how a namespace was
      // constructed.
      //
      if ( c_sname_count( &(yyvsp[0].sname) ) > 1 && !OPT_LANG_IS( NESTED_namespace ) ) {
        print_error( &(yylsp[0]),
          "nested namespace declarations not supported%s\n",
          C_LANG_WHICH( NESTED_namespace )
        );
        c_sname_cleanup( &(yyvsp[0].sname) );
        PARSE_ABORT();
      }

      //
      // The namespace type (plain namespace or inline namespace) has to be
      // split across the namespace sname: only the storage classes (for
      // TS_inline) has to be or'd with the first scope-type of the sname ...
      //
      c_type_t *const sname_global_type = &c_sname_global_data( &(yyvsp[0].sname) )->type;
      *sname_global_type =
        C_TYPE_LIT(
          sname_global_type->btids,
          sname_global_type->stids | (yyvsp[-2].type).stids,
          sname_global_type->atids
        );
      //
      // ... and only the base types (for TB_namespace) has to be or'd with the
      // local scope type of the sname.
      //
      c_type_t *const sname_local_type = &c_sname_local_data( &(yyvsp[0].sname) )->type;
      *sname_local_type =
        C_TYPE_LIT(
          sname_local_type->btids | (yyvsp[-2].type).btids,
          sname_local_type->stids,
          sname_local_type->atids
        );

      c_sname_append_sname( &in_attr.scope_sname, &(yyvsp[0].sname) );
      c_sname_set_all_types( &in_attr.scope_sname );

      DUMP_SNAME( "$$_sname", (yyvsp[0].sname) );
      DUMP_END();

      //
      // These checks are better to do now in the parser rather than later in
      // the AST because they give a better error location.
      //
      if ( c_sname_is_inline_nested_namespace( &in_attr.scope_sname ) ) {
        print_error( &(yylsp[0]),
          "nested namespace can not be %s\n",
          c_tid_error( TS_inline )
        );
        PARSE_ABORT();
      }
      PARSE_ASSERT( c_sname_check( &in_attr.scope_sname, &(yylsp[0]) ) );
    }
#line 8128 "parser.c"
    break;

  case 319: /* namespace_sname_c_exp: error  */
#line 4040 "parser.y"
    {
      c_sname_init( &(yyval.sname) );
      elaborate_error( "name expected" );
    }
#line 8137 "parser.c"
    break;

  case 320: /* namespace_sname_c: namespace_sname_c Y_COLON_COLON Y_NAME  */
#line 4053 "parser.y"
    {
      DUMP_START( "namespace_sname_c", "sname_c '::' NAME" );
      DUMP_SNAME( "namespace_sname_c", (yyvsp[-2].sname) );
      DUMP_STR( "name", (yyvsp[0].name) );

      (yyval.sname) = (yyvsp[-2].sname);
      c_sname_append_name( &(yyval.sname), (yyvsp[0].name) );
      c_sname_local_data( &(yyval.sname) )->type = C_TYPE_LIT_B( TB_namespace );

      DUMP_SNAME( "$$_sname", (yyval.sname) );
      DUMP_END();
    }
#line 8154 "parser.c"
    break;

  case 321: /* namespace_sname_c: namespace_sname_c Y_COLON_COLON any_typedef_tdef  */
#line 4067 "parser.y"
    {
      DUMP_START( "namespace_sname_c",
                  "namespace_sname_c '::' any_typedef_tdef" );
      DUMP_SNAME( "namespace_sname_c", (yyvsp[-2].sname) );
      DUMP_AST( "any_typedef__ast", (yyvsp[0].tdef)->ast );

      (yyval.sname) = (yyvsp[-2].sname);
      c_sname_local_data( &(yyval.sname) )->type = C_TYPE_LIT_B( TB_namespace );
      c_sname_t temp_sname = c_sname_dup( &(yyvsp[0].tdef)->ast->sname );
      c_sname_append_sname( &(yyval.sname), &temp_sname );

      DUMP_SNAME( "$$_sname", (yyval.sname) );
      DUMP_END();
    }
#line 8173 "parser.c"
    break;

  case 322: /* namespace_sname_c: namespace_sname_c Y_COLON_COLON Y_inline name_exp  */
#line 4083 "parser.y"
    {
      DUMP_START( "namespace_sname_c", "sname_c '::' NAME INLINE NAME" );
      DUMP_SNAME( "namespace_sname_c", (yyvsp[-3].sname) );
      DUMP_STR( "name", (yyvsp[0].name) );

      (yyval.sname) = (yyvsp[-3].sname);
      c_sname_append_name( &(yyval.sname), (yyvsp[0].name) );
      c_sname_local_data( &(yyval.sname) )->type =
        C_TYPE_LIT( TB_namespace, (yyvsp[-1].tid), TA_NONE );

      DUMP_SNAME( "$$_sname", (yyval.sname) );
      DUMP_END();
    }
#line 8191 "parser.c"
    break;

  case 323: /* namespace_sname_c: Y_NAME  */
#line 4098 "parser.y"
    {
      DUMP_START( "namespace_sname_c", "NAME" );
      DUMP_STR( "NAME", (yyvsp[0].name) );

      c_sname_init_name( &(yyval.sname), (yyvsp[0].name) );
      c_sname_local_data( &(yyval.sname) )->type = C_TYPE_LIT_B( TB_namespace );

      DUMP_SNAME( "$$_sname", (yyval.sname) );
      DUMP_END();
    }
#line 8206 "parser.c"
    break;

  case 324: /* namespace_typedef_sname_c: namespace_typedef_sname_c Y_COLON_COLON sname_c  */
#line 4117 "parser.y"
    {
      DUMP_START( "namespace_typedef_sname_c",
                  "namespace_typedef_sname_c '::' sname_c" );
      DUMP_SNAME( "namespace_typedef_sname_c", (yyvsp[-2].sname) );
      DUMP_SNAME( "sname_c", (yyvsp[0].sname) );

      (yyval.sname) = (yyvsp[-2].sname);
      c_sname_append_sname( &(yyval.sname), &(yyvsp[0].sname) );

      DUMP_SNAME( "$$_sname", (yyval.sname) );
      DUMP_END();
    }
#line 8223 "parser.c"
    break;

  case 325: /* namespace_typedef_sname_c: namespace_typedef_sname_c Y_COLON_COLON any_typedef_tdef  */
#line 4131 "parser.y"
    {
      DUMP_START( "namespace_typedef_sname_c",
                  "namespace_typedef_sname_c '::' any_typedef_tdef" );
      DUMP_SNAME( "namespace_typedef_sname_c", (yyvsp[-2].sname) );
      DUMP_AST( "any_typedef__ast", (yyvsp[0].tdef)->ast );

      (yyval.sname) = (yyvsp[-2].sname);
      c_sname_local_data( &(yyval.sname) )->type =
        *c_sname_local_type( &(yyvsp[0].tdef)->ast->sname );
      c_sname_t temp_sname = c_sname_dup( &(yyvsp[0].tdef)->ast->sname );
      c_sname_append_sname( &(yyval.sname), &temp_sname );

      DUMP_SNAME( "$$_sname", (yyval.sname) );
      DUMP_END();
    }
#line 8243 "parser.c"
    break;

  case 326: /* namespace_typedef_sname_c: namespace_typedef_sname_c Y_COLON_COLON Y_inline name_exp  */
#line 4149 "parser.y"
    {
      DUMP_START( "namespace_typedef_sname_c",
                  "namespace_typedef_sname_c '::' INLINE NAME" );
      DUMP_SNAME( "namespace_typedef_sname_c", (yyvsp[-3].sname) );
      DUMP_STR( "name", (yyvsp[0].name) );

      (yyval.sname) = (yyvsp[-3].sname);
      c_sname_append_name( &(yyval.sname), (yyvsp[0].name) );
      c_sname_local_data( &(yyval.sname) )->type =
        C_TYPE_LIT( TB_namespace, (yyvsp[-1].tid), TA_NONE );

      DUMP_SNAME( "$$_sname", (yyval.sname) );
      DUMP_END();
    }
#line 8262 "parser.c"
    break;

  case 327: /* namespace_typedef_sname_c: any_typedef_tdef  */
#line 4164 "parser.y"
                                  { (yyval.sname) = c_sname_dup( &(yyvsp[0].tdef)->ast->sname ); }
#line 8268 "parser.c"
    break;

  case 329: /* brace_in_scope_declaration_c_exp: error  */
#line 4170 "parser.y"
    {
      punct_expected( '{' );
    }
#line 8276 "parser.c"
    break;

  case 337: /* in_scope_declaration_c_exp: error  */
#line 4190 "parser.y"
    {
      elaborate_error( "declaration expected" );
    }
#line 8284 "parser.c"
    break;

  case 338: /* lambda_declaration_c: '[' capture_decl_list_c_opt ']' paren_param_c_ast_list_opt storage_class_subset_english_type_opt lambda_return_type_c_ast_opt  */
#line 4202 "parser.y"
    {
      DUMP_START( "lambda_declaration_c",
                  "'[' capture_decl_list_c_opt ']' "
                  "paren_param_c_ast_list_opt "
                  "lambda_return_type_c_ast_opt" );
      DUMP_AST_LIST( "capture_decl_list_c_opt", (yyvsp[-4].ast_list) );
      DUMP_AST_LIST( "paren_param_c_ast_list_opt", (yyvsp[-2].ast_list) );
      DUMP_TYPE( "storage_class_subset_english_type_opt", (yyvsp[-1].type) );
      DUMP_AST( "lambda_return_type_c_ast_opt", (yyvsp[0].ast) );

      c_ast_t *const lambda_ast = c_ast_new_gc( K_LAMBDA, &(yyloc) );
      lambda_ast->type = (yyvsp[-1].type);
      c_ast_list_set_param_of( &(yyvsp[-4].ast_list), lambda_ast );
      lambda_ast->lambda.capture_ast_list = slist_move( &(yyvsp[-4].ast_list) );
      c_ast_list_set_param_of( &(yyvsp[-2].ast_list), lambda_ast );
      lambda_ast->lambda.param_ast_list = slist_move( &(yyvsp[-2].ast_list) );
      c_ast_set_parent( (yyvsp[0].ast), lambda_ast );

      DUMP_AST( "$$_ast", lambda_ast );
      DUMP_END();

      PARSE_ASSERT( c_ast_check( lambda_ast ) );
      c_ast_english( lambda_ast, C_ENG_DECL, stdout );
      PUTC( '\n' );
    }
#line 8314 "parser.c"
    break;

  case 339: /* capture_decl_list_c_opt: %empty  */
#line 4230 "parser.y"
                                  { slist_init( &(yyval.ast_list) ); }
#line 8320 "parser.c"
    break;

  case 341: /* capture_decl_list_c: capture_decl_list_c comma_exp capture_decl_c_ast  */
#line 4237 "parser.y"
    {
      DUMP_START( "capture_decl_list_c",
                  "capture_decl_list_c ',' "
                  "capture_decl_c_ast" );
      DUMP_AST_LIST( "capture_decl_list_c", (yyvsp[-2].ast_list) );
      DUMP_AST( "capture_decl_c_ast", (yyvsp[0].ast) );

      (yyval.ast_list) = (yyvsp[-2].ast_list);
      slist_push_back( &(yyval.ast_list), (yyvsp[0].ast) );

      DUMP_AST_LIST( "$$_ast_list", (yyval.ast_list) );
      DUMP_END();
    }
#line 8338 "parser.c"
    break;

  case 342: /* capture_decl_list_c: capture_decl_c_ast  */
#line 4252 "parser.y"
    {
      DUMP_START( "capture_decl_list_c",
                  "capture_decl_c_ast" );
      DUMP_AST( "capture_decl_c_ast", (yyvsp[0].ast) );

      slist_init( &(yyval.ast_list) );
      slist_push_back( &(yyval.ast_list), (yyvsp[0].ast) );

      DUMP_AST_LIST( "$$_ast_list", (yyval.ast_list) );
      DUMP_END();
    }
#line 8354 "parser.c"
    break;

  case 343: /* capture_decl_c_ast: '&'  */
#line 4267 "parser.y"
    {
      (yyval.ast) = c_ast_new_gc( K_CAPTURE, &(yyloc) );
      (yyval.ast)->capture.kind = C_CAPTURE_REFERENCE;
    }
#line 8363 "parser.c"
    break;

  case 344: /* capture_decl_c_ast: '&' Y_NAME  */
#line 4272 "parser.y"
    {
      (yyval.ast) = c_ast_new_gc( K_CAPTURE, &(yyloc) );
      c_sname_init_name( &(yyval.ast)->sname, (yyvsp[0].name) );
      (yyval.ast)->capture.kind = C_CAPTURE_REFERENCE;
    }
#line 8373 "parser.c"
    break;

  case 345: /* capture_decl_c_ast: '='  */
#line 4278 "parser.y"
    {
      (yyval.ast) = c_ast_new_gc( K_CAPTURE, &(yyloc) );
      (yyval.ast)->capture.kind = C_CAPTURE_COPY;
    }
#line 8382 "parser.c"
    break;

  case 346: /* capture_decl_c_ast: Y_NAME  */
#line 4283 "parser.y"
    {
      (yyval.ast) = c_ast_new_gc( K_CAPTURE, &(yyloc) );
      c_sname_init_name( &(yyval.ast)->sname, (yyvsp[0].name) );
    }
#line 8391 "parser.c"
    break;

  case 347: /* capture_decl_c_ast: Y_this  */
#line 4288 "parser.y"
    {
      (yyval.ast) = c_ast_new_gc( K_CAPTURE, &(yyloc) );
      (yyval.ast)->capture.kind = C_CAPTURE_THIS;
    }
#line 8400 "parser.c"
    break;

  case 348: /* capture_decl_c_ast: '*' this_exp  */
#line 4293 "parser.y"
    {
      (yyval.ast) = c_ast_new_gc( K_CAPTURE, &(yyloc) );
      (yyval.ast)->capture.kind = C_CAPTURE_STAR_THIS;
    }
#line 8409 "parser.c"
    break;

  case 349: /* lambda_return_type_c_ast_opt: %empty  */
#line 4300 "parser.y"
                                  { (yyval.ast) = NULL; }
#line 8415 "parser.c"
    break;

  case 350: /* $@14: %empty  */
#line 4301 "parser.y"
                                         { ia_type_ast_push( (yyvsp[0].ast) ); }
#line 8421 "parser.c"
    break;

  case 351: /* lambda_return_type_c_ast_opt: Y_MINUS_GREATER type_c_ast $@14 cast_c_astp_opt  */
#line 4303 "parser.y"
    {
      ia_type_ast_pop();

      DUMP_START( "lambda_return_type_c_ast_opt",
                  "'->' type_c_ast cast_c_astp_opt" );
      DUMP_AST( "type_c_ast", (yyvsp[-2].ast) );
      DUMP_AST_PAIR( "cast_c_astp_opt", (yyvsp[0].ast_pair) );

      (yyval.ast) = IF_ELSE( (yyvsp[0].ast_pair).ast, (yyvsp[-2].ast) );

      DUMP_AST( "$$_ast", (yyval.ast) );
      DUMP_END();
    }
#line 8439 "parser.c"
    break;

  case 352: /* template_declaration_c: Y_template  */
#line 4322 "parser.y"
    {
      UNSUPPORTED( &(yylsp[0]), "template declarations" );
    }
#line 8447 "parser.c"
    break;

  case 353: /* $@15: %empty  */
#line 4330 "parser.y"
                         { ia_type_ast_push( (yyvsp[0].ast) ); }
#line 8453 "parser.c"
    break;

  case 354: /* typed_declaration_c: type_c_ast $@15 decl_list_c_opt  */
#line 4331 "parser.y"
    {
      ia_type_ast_pop();
    }
#line 8461 "parser.c"
    break;

  case 355: /* $@16: %empty  */
#line 4340 "parser.y"
    {
      PARSE_ASSERT( is_nested_type_ok( &(yylsp[-1]) ) );
      in_attr.is_typename = (yyvsp[0].flag);
      gibberish_to_english();           // see the comment in "explain"
    }
#line 8471 "parser.c"
    break;

  case 356: /* $@17: %empty  */
#line 4346 "parser.y"
    {
      PARSE_ASSERT( !in_attr.is_typename || c_ast_is_typename_ok( (yyvsp[0].ast) ) );
      // see the comment in "define_command" about TS_typedef
      PARSE_ASSERT(
        c_type_add_tid( &(yyvsp[0].ast)->type, TS_typedef, &(yylsp[0]) )
      );
      ia_type_ast_push( (yyvsp[0].ast) );
    }
#line 8484 "parser.c"
    break;

  case 357: /* typedef_declaration_c: Y_typedef typename_flag_opt $@16 type_c_ast $@17 typedef_decl_list_c  */
#line 4355 "parser.y"
    {
      ia_type_ast_pop();
    }
#line 8492 "parser.c"
    break;

  case 360: /* typedef_decl_c: decl_c_astp  */
#line 4368 "parser.y"
    {
      c_ast_t *const type_ast = ia_type_ast_peek();

      DUMP_START( "typedef_decl_c", "decl_c_astp" );
      DUMP_SNAME( "in_attr__scope_sname", in_attr.scope_sname );
      DUMP_AST( "in_attr__type_c_ast", type_ast );
      DUMP_AST_PAIR( "decl_c_astp", (yyvsp[0].ast_pair) );

      c_ast_t *const decl_ast = (yyvsp[0].ast_pair).ast;
      c_ast_t *typedef_ast;
      c_sname_t temp_sname;

      if ( decl_ast->kind == K_TYPEDEF && c_sname_empty( &decl_ast->sname ) ) {
        //
        // This is for either of the following cases:
        //
        //      typedef int int32_t;
        //      typedef int32_t int_least32_t;
        //
        // that is: any type name followed by an existing typedef name.
        //
        typedef_ast = type_ast;
        if ( c_sname_empty( &typedef_ast->sname ) )
          typedef_ast->sname = c_sname_dup( &decl_ast->tdef.for_ast->sname );
      }
      else {
        //
        // This is for either of the following cases:
        //
        //      typedef int foo;
        //      typedef int32_t foo;
        //
        // that is: any type name followed by a new name.
        //
        typedef_ast = c_ast_patch_placeholder( type_ast, decl_ast );
        temp_sname = c_ast_move_sname( decl_ast );
        c_sname_set( &typedef_ast->sname, &temp_sname );
      }

      PARSE_ASSERT( c_ast_check( typedef_ast ) );
      // see the comment in "define_command" about TS_typedef
      PJL_DISCARD_RV( c_ast_take_type_any( typedef_ast, &T_TS_typedef ) );

      if ( c_sname_count( &typedef_ast->sname ) > 1 ) {
        print_error( &(yylsp[0]),
          "typedef names can not be scoped; "
          "use: namespace %s { typedef ... }\n",
          c_sname_scope_gibberish( &typedef_ast->sname )
        );
        PARSE_ABORT();
      }

      temp_sname = c_sname_dup( &in_attr.scope_sname );
      c_sname_prepend_sname( &typedef_ast->sname, &temp_sname );

      DUMP_AST( "$$_ast", typedef_ast );
      DUMP_END();

      PARSE_ASSERT( define_type( typedef_ast, C_GIB_TYPEDEF  ) );
    }
#line 8557 "parser.c"
    break;

  case 362: /* typedef_decl_c_exp: error  */
#line 4433 "parser.y"
    {
      elaborate_error( "type expected" );
    }
#line 8565 "parser.c"
    break;

  case 363: /* user_defined_conversion_declaration_c: user_defined_conversion_decl_c_astp  */
#line 4442 "parser.y"
    {
      DUMP_START( "user_defined_conversion_declaration_c",
                  "user_defined_conversion_decl_c_astp" );
      DUMP_AST_PAIR( "user_defined_conversion_declaration_c", (yyvsp[0].ast_pair) );
      DUMP_END();

      PARSE_ASSERT( c_ast_check( (yyvsp[0].ast_pair).ast ) );
      c_ast_english( (yyvsp[0].ast_pair).ast, C_ENG_DECL, stdout );
      PUTC( '\n' );
    }
#line 8580 "parser.c"
    break;

  case 364: /* using_declaration_c: using_decl_c_ast  */
#line 4458 "parser.y"
    {
      // see the comment in "define_command" about TS_typedef
      PJL_DISCARD_RV( c_ast_take_type_any( (yyvsp[0].ast), &T_TS_typedef ) );

      PARSE_ASSERT( define_type( (yyvsp[0].ast), C_GIB_USING ) );
    }
#line 8591 "parser.c"
    break;

  case 365: /* $@18: %empty  */
#line 4468 "parser.y"
    { //
      // Using declarations are supported only in C++11 and later.  (However,
      // we always allow them in configuration files.)
      //
      // This check has to be done now in the parser rather than later in the
      // AST because using declarations are treated like typedef declarations
      // and the AST has no "memory" that such a declaration was a using
      // declaration.
      //
      if ( !OPT_LANG_IS( using_DECLS ) ) {
        print_error( &(yylsp[0]),
          "\"using\" not supported%s\n",
          C_LANG_WHICH( using_DECLS )
        );
        PARSE_ABORT();
      }

      gibberish_to_english();           // see the comment in "explain"
    }
#line 8615 "parser.c"
    break;

  case 366: /* $@19: %empty  */
#line 4489 "parser.y"
    {
      // see the comment in "define_command" about TS_typedef
      if ( !c_type_add_tid( &(yyvsp[0].ast)->type, TS_typedef, &(yylsp[0]) ) ) {
        free( (yyvsp[-3].name) );
        PARSE_ABORT();
      }
      ia_type_ast_push( (yyvsp[0].ast) );
    }
#line 8628 "parser.c"
    break;

  case 367: /* using_decl_c_ast: Y_using $@18 any_name_exp attribute_specifier_list_c_atid_opt equals_exp type_c_ast $@19 cast_c_astp_opt  */
#line 4498 "parser.y"
    {
      ia_type_ast_pop();

      DUMP_START( "using_decl_c_ast",
                  "USING any_name_exp attribute_specifier_list_c_atid_opt '=' "
                  "type_c_ast cast_c_astp_opt" );
      DUMP_SNAME( "in_attr__scope_sname", in_attr.scope_sname );
      DUMP_STR( "any_name_exp", (yyvsp[-5].name) );
      DUMP_TID( "attribute_specifier_list_c_atid_opt", (yyvsp[-4].tid) );
      DUMP_AST( "type_c_ast", (yyvsp[-2].ast) );
      DUMP_AST_PAIR( "cast_c_astp_opt", (yyvsp[0].ast_pair) );

      c_ast_t *const cast_ast = (yyvsp[0].ast_pair).ast;

      //
      // Ensure the type on the right-hand side doesn't have a name, e.g.:
      //
      //      using U = void (*F)();    // error
      //
      // This check has to be done now in the parser rather than later in the
      // AST because the patched AST loses the name.
      //
      c_sname_t const *const sname = c_ast_find_name( cast_ast, C_VISIT_DOWN );
      if ( sname != NULL ) {
        print_error( &cast_ast->loc, "\"using\" type can not have a name\n" );
        free( (yyvsp[-5].name) );
        PARSE_ABORT();
      }

      c_sname_t temp_sname = c_sname_dup( &in_attr.scope_sname );
      c_sname_append_name( &temp_sname, (yyvsp[-5].name) );

      (yyval.ast) = c_ast_patch_placeholder( (yyvsp[-2].ast), cast_ast );
      c_sname_set( &(yyval.ast)->sname, &temp_sname );
      (yyval.ast)->type.atids = c_tid_check( (yyvsp[-4].tid), C_TPID_ATTR );

      DUMP_AST( "$$_ast", (yyval.ast) );
      DUMP_END();

      PARSE_ASSERT( c_ast_check( (yyval.ast) ) );
    }
#line 8674 "parser.c"
    break;

  case 368: /* decl_list_c_opt: %empty  */
#line 4559 "parser.y"
    {
      c_ast_t *const type_ast = ia_type_ast_peek();

      DUMP_START( "decl_list_c_opt", "<empty>" );
      DUMP_AST( "in_attr__type_c_ast", type_ast );

      if ( in_attr.align.kind != C_ALIGNAS_NONE ) {
        print_error( &in_attr.align.loc,
          "\"%s\" invalid here\n",
          alignas_name()
        );
        PARSE_ABORT();
      }

      bool const is_structured_binding =
        c_ast_unreference_any( type_ast )->kind == K_STRUCTURED_BINDING;

      if ( is_structured_binding ) {
        // do nothing
      }
      else if ( (type_ast->kind & K_ANY_ECSU) == 0 ) {
        //
        // The declaration is a non-ECSU type, e.g.:
        //
        //      int
        //
        c_loc_t const loc = lexer_loc();
        print_error( &loc, "declaration expected" );
        print_error_token_is_a( printable_yytext() );
        EPUTC( '\n' );
        PARSE_ABORT();
      }
      else {
        c_sname_t const *const ecsu_sname = &type_ast->csu.csu_sname;
        assert( !c_sname_empty( ecsu_sname ) );

        if ( c_sname_count( ecsu_sname ) > 1 ) {
          print_error( &type_ast->loc,
            "forward declaration can not have a scoped name\n"
          );
          PARSE_ABORT();
        }

        c_sname_t temp_sname = c_sname_dup( ecsu_sname );
        c_sname_set( &type_ast->sname, &temp_sname );
      }

      DUMP_AST( "$$_ast", type_ast );
      DUMP_END();

      PARSE_ASSERT( c_ast_check( type_ast ) );
      if ( is_structured_binding )
        c_ast_english( type_ast, C_ENG_DECL, stdout );
      else
        c_typedef_english( &C_TYPEDEF_LIT( type_ast, C_ENG_DECL ), stdout );
      PUTC( '\n' );
    }
#line 8736 "parser.c"
    break;

  case 369: /* decl_list_c_opt: decl_list_c  */
#line 4618 "parser.y"
    {
      DUMP_START( "decl_list_c_opt", "decl_list_c" );
      DUMP_AST_LIST( "decl_list_c", (yyvsp[0].ast_list) );
      DUMP_END();

      PARSE_ASSERT( c_ast_list_check( &(yyvsp[0].ast_list) ) );
      c_ast_list_english( &(yyvsp[0].ast_list), stdout );
    }
#line 8749 "parser.c"
    break;

  case 370: /* decl_list_c: decl_list_c ',' decl_c_exp  */
#line 4630 "parser.y"
    {
      (yyval.ast_list) = (yyvsp[-2].ast_list);
      slist_push_back( &(yyval.ast_list), (yyvsp[0].ast) );
    }
#line 8758 "parser.c"
    break;

  case 371: /* decl_list_c: decl_c  */
#line 4635 "parser.y"
    {
      slist_init( &(yyval.ast_list) );
      slist_push_back( &(yyval.ast_list), (yyvsp[0].ast) );
    }
#line 8767 "parser.c"
    break;

  case 372: /* decl_c: decl_c_astp  */
#line 4644 "parser.y"
    {
      c_ast_t *const type_ast = ia_type_ast_peek();

      DUMP_START( "decl_c", "decl_c_astp" );
      switch ( in_attr.align.kind ) {
        case C_ALIGNAS_NONE:
          break;
        case C_ALIGNAS_BYTES:
          DUMP_INT( "in_attr__alignas_bytes", in_attr.align.bytes );
          break;
        case C_ALIGNAS_SNAME:
          DUMP_SNAME( "in_attr__alignas_sname", in_attr.align.sname );
          break;
        case C_ALIGNAS_TYPE:
          DUMP_AST( "in_attr__alignas_type_ast", in_attr.align.type_ast );
          break;
      } // switch
      DUMP_BOOL( "in_attr__typename_flag_opt", in_attr.is_typename );
      DUMP_AST( "in_attr__type_c_ast", type_ast );
      DUMP_AST_PAIR( "decl_c_astp", (yyvsp[0].ast_pair) );

      (yyval.ast) = join_type_decl( type_ast, (yyvsp[0].ast_pair).ast );
      PARSE_ASSERT( (yyval.ast) != NULL );

      DUMP_AST( "$$_ast", (yyval.ast) );
      DUMP_END();
    }
#line 8799 "parser.c"
    break;

  case 374: /* decl_c_exp: error  */
#line 4676 "parser.y"
    {
      elaborate_error( "declaration expected" );
    }
#line 8807 "parser.c"
    break;

  case 379: /* decl_c_astp: msc_calling_convention_atid msc_calling_convention_c_astp  */
#line 4687 "parser.y"
    {
      (yyval.ast_pair) = (yyvsp[0].ast_pair);
      (yyval.ast_pair).ast->loc = (yyloc);
      (yyval.ast_pair).ast->type.atids |= (yyvsp[-1].tid);
    }
#line 8817 "parser.c"
    break;

  case 387: /* decl2_c_astp: param_pack_decl_c_ast  */
#line 4705 "parser.y"
                                   { (yyval.ast_pair) = (c_ast_pair_t){ (yyvsp[0].ast), NULL }; }
#line 8823 "parser.c"
    break;

  case 388: /* decl2_c_astp: sname_c_ast gnu_attribute_specifier_list_c_opt  */
#line 4707 "parser.y"
    {
      (yyval.ast_pair) = (c_ast_pair_t){ (yyvsp[-1].ast), .target_ast = NULL };
    }
#line 8831 "parser.c"
    break;

  case 389: /* decl2_c_astp: typedef_type_decl_c_ast  */
#line 4711 "parser.y"
    {
      (yyval.ast_pair) = (c_ast_pair_t){ (yyvsp[0].ast), .target_ast = NULL };
    }
#line 8839 "parser.c"
    break;

  case 392: /* param_pack_decl_c_ast: "..." sname_c_ast  */
#line 4720 "parser.y"
    {
      DUMP_START( "param_pack_decl_c_ast", "... sname_c_ast" );\
      DUMP_AST( "sname_c_ast", (yyvsp[0].ast) );

      c_ast_set_parameter_pack( (yyvsp[0].ast) );
      (yyval.ast) = (yyvsp[0].ast);

      DUMP_AST( "$$_ast", (yyval.ast) );
      DUMP_END();
    }
#line 8854 "parser.c"
    break;

  case 393: /* param_pack_decl_c_ast: "..." error  */
#line 4731 "parser.y"
    {
      (yyval.ast) = NULL;
      elaborate_error( "name expected" );
    }
#line 8863 "parser.c"
    break;

  case 394: /* array_decl_c_astp: decl2_c_astp array_size_c_ast gnu_attribute_specifier_list_c_opt  */
#line 4743 "parser.y"
    {
      c_ast_t *const type_ast = ia_type_ast_peek();

      DUMP_START( "array_decl_c_astp", "decl2_c_astp array_size_c_ast" );
      DUMP_AST( "in_attr__type_c_ast", type_ast );
      DUMP_AST_PAIR( "decl2_c_astp", (yyvsp[-2].ast_pair) );
      DUMP_AST( "array_size_c_ast", (yyvsp[-1].ast) );

      c_ast_set_parent(
        c_ast_new_gc( K_PLACEHOLDER, &(yylsp[-2]) ), (yyvsp[-1].ast)
      );

      c_ast_t *const of_ast = ia_type_spec_ast( type_ast );
      if ( (yyvsp[-2].ast_pair).target_ast != NULL ) {
        // array-of or function-like-ret type
        (yyval.ast_pair) = (c_ast_pair_t){
          (yyvsp[-2].ast_pair).ast,
          c_ast_add_array( (yyvsp[-2].ast_pair).target_ast, (yyvsp[-1].ast), of_ast )
        };
      }
      else {
        (yyval.ast_pair) = (c_ast_pair_t){
          c_ast_add_array( (yyvsp[-2].ast_pair).ast, (yyvsp[-1].ast), of_ast ),
          .target_ast = NULL
        };
      }

      DUMP_AST_PAIR( "$$_astp", (yyval.ast_pair) );
      DUMP_END();
    }
#line 8898 "parser.c"
    break;

  case 395: /* array_size_c_ast: '[' rbracket_exp  */
#line 4777 "parser.y"
    {
      (yyval.ast) = c_ast_new_gc( K_ARRAY, &(yyloc) );
      (yyval.ast)->array.kind = C_ARRAY_SIZE_NONE;
    }
#line 8907 "parser.c"
    break;

  case 396: /* array_size_c_ast: '[' uint_lit rbracket_exp  */
#line 4782 "parser.y"
    {
      (yyval.ast) = c_ast_new_gc( K_ARRAY, &(yyloc) );
      (yyval.ast)->array.kind = C_ARRAY_SIZE_INT;
      (yyval.ast)->array.size_int = (yyvsp[-1].uint_val);
    }
#line 8917 "parser.c"
    break;

  case 397: /* array_size_c_ast: '[' Y_NAME rbracket_exp  */
#line 4788 "parser.y"
    {
      (yyval.ast) = c_ast_new_gc( K_ARRAY, &(yyloc) );
      (yyval.ast)->array.kind = C_ARRAY_SIZE_NAME;
      (yyval.ast)->array.size_name = (yyvsp[-1].name);
    }
#line 8927 "parser.c"
    break;

  case 398: /* array_size_c_ast: '[' type_qualifier_list_c_stid rbracket_exp  */
#line 4794 "parser.y"
    {
      (yyval.ast) = c_ast_new_gc( K_ARRAY, &(yyloc) );
      (yyval.ast)->type.stids = c_tid_check( (yyvsp[-1].tid), C_TPID_STORE );
      (yyval.ast)->array.kind = C_ARRAY_SIZE_NONE;
    }
#line 8937 "parser.c"
    break;

  case 399: /* array_size_c_ast: '[' type_qualifier_list_c_stid static_stid_opt uint_lit rbracket_exp  */
#line 4801 "parser.y"
    {
      (yyval.ast) = c_ast_new_gc( K_ARRAY, &(yyloc) );
      (yyval.ast)->type.stids = c_tid_check( (yyvsp[-3].tid) | (yyvsp[-2].tid), C_TPID_STORE );
      (yyval.ast)->array.kind = C_ARRAY_SIZE_INT;
      (yyval.ast)->array.size_int = (yyvsp[-1].uint_val);
    }
#line 8948 "parser.c"
    break;

  case 400: /* array_size_c_ast: '[' type_qualifier_list_c_stid static_stid_opt Y_NAME rbracket_exp  */
#line 4809 "parser.y"
    {
      (yyval.ast) = c_ast_new_gc( K_ARRAY, &(yyloc) );
      (yyval.ast)->type.stids = c_tid_check( (yyvsp[-3].tid) | (yyvsp[-2].tid), C_TPID_STORE );
      (yyval.ast)->array.kind = C_ARRAY_SIZE_NAME;
      (yyval.ast)->array.size_name = (yyvsp[-1].name);
    }
#line 8959 "parser.c"
    break;

  case 401: /* array_size_c_ast: '[' type_qualifier_list_c_stid_opt '*' rbracket_exp  */
#line 4816 "parser.y"
    {
      (yyval.ast) = c_ast_new_gc( K_ARRAY, &(yyloc) );
      (yyval.ast)->type.stids = c_tid_check( (yyvsp[-2].tid), C_TPID_STORE );
      (yyval.ast)->array.kind = C_ARRAY_SIZE_VLA;
    }
#line 8969 "parser.c"
    break;

  case 402: /* array_size_c_ast: '[' Y_static type_qualifier_list_c_stid_opt uint_lit rbracket_exp  */
#line 4823 "parser.y"
    {
      (yyval.ast) = c_ast_new_gc( K_ARRAY, &(yyloc) );
      (yyval.ast)->type.stids =
        c_tid_check( TS_NON_EMPTY_ARRAY | (yyvsp[-2].tid), C_TPID_STORE );
      (yyval.ast)->array.kind = C_ARRAY_SIZE_INT;
      (yyval.ast)->array.size_int = (yyvsp[-1].uint_val);
    }
#line 8981 "parser.c"
    break;

  case 403: /* array_size_c_ast: '[' Y_static type_qualifier_list_c_stid_opt Y_NAME rbracket_exp  */
#line 4832 "parser.y"
    {
      (yyval.ast) = c_ast_new_gc( K_ARRAY, &(yyloc) );
      (yyval.ast)->type.stids =
        c_tid_check( TS_NON_EMPTY_ARRAY | (yyvsp[-2].tid), C_TPID_STORE );
      (yyval.ast)->array.kind = C_ARRAY_SIZE_NAME;
      (yyval.ast)->array.size_name = (yyvsp[-1].name);
    }
#line 8993 "parser.c"
    break;

  case 404: /* array_size_c_ast: '[' error ']'  */
#line 4840 "parser.y"
    {
      elaborate_error( "array size expected" );
    }
#line 9001 "parser.c"
    break;

  case 405: /* $@20: %empty  */
#line 4850 "parser.y"
    { //
      // A block AST has to be the type inherited attribute for decl_c_astp so
      // we have to create it here.
      //
      ia_type_ast_push( c_ast_new_gc( K_APPLE_BLOCK, &(yyloc) ) );
    }
#line 9012 "parser.c"
    break;

  case 406: /* block_decl_c_astp: '(' '^' $@20 type_qualifier_list_c_stid_opt decl_c_astp rparen_exp lparen_exp param_c_ast_list_opt ')' gnu_attribute_specifier_list_c_opt  */
#line 4859 "parser.y"
    {
      c_ast_t *const block_ast = ia_type_ast_pop();
      c_ast_t *const type_ast = ia_type_ast_peek();

      DUMP_START( "block_decl_c_astp",
                  "'(' '^' type_qualifier_list_c_stid_opt decl_c_astp ')' "
                  "'(' param_c_ast_list_opt ')'" );
      DUMP_AST( "in_attr__type_c_ast", type_ast );
      DUMP_TID( "type_qualifier_list_c_stid_opt", (yyvsp[-6].tid) );
      DUMP_AST_PAIR( "decl_c_astp", (yyvsp[-5].ast_pair) );
      DUMP_AST_LIST( "param_c_ast_list_opt", (yyvsp[-2].ast_list) );

      PARSE_ASSERT(
        c_type_add_tid( &block_ast->type, (yyvsp[-6].tid), &(yylsp[-6]) )
      );
      c_ast_list_set_param_of( &(yyvsp[-2].ast_list), block_ast );
      block_ast->block.param_ast_list = slist_move( &(yyvsp[-2].ast_list) );

      c_ast_t *const ret_ast = ia_type_spec_ast( type_ast );
      if ( (yyvsp[-5].ast_pair).target_ast != NULL ) {
        (yyval.ast_pair) = (c_ast_pair_t){
          (yyvsp[-5].ast_pair).ast,
          c_ast_add_func( (yyvsp[-5].ast_pair).target_ast, block_ast, ret_ast )
        };
      }
      else {
        (yyval.ast_pair) = (c_ast_pair_t){
          c_ast_add_func( (yyvsp[-5].ast_pair).ast, block_ast, ret_ast ),
          block_ast->block.ret_ast
        };
      }

      DUMP_AST_PAIR( "$$_astp", (yyval.ast_pair) );
      DUMP_END();
    }
#line 9052 "parser.c"
    break;

  case 407: /* destructor_declaration_c: virtual_stid_opt '~' any_name_exp lparen_exp no_destructor_params param_list_rparen_func_qualifier_list_c_stid_opt noexcept_c_stid_opt gnu_attribute_specifier_list_c_opt func_equals_c_stid_opt  */
#line 4907 "parser.y"
    {
      DUMP_START( "destructor_declaration_c",
                  "virtual_stid_opt '~' any_name_exp '(' ')' "
                  "func_qualifier_list_c_stid_opt noexcept_c_stid_opt "
                  "gnu_attribute_specifier_list_c_opt func_equals_c_stid_opt" );
      DUMP_TID( "virtual_stid_opt", (yyvsp[-8].tid) );
      DUMP_STR( "any_name_exp", (yyvsp[-6].name) );
      DUMP_TID( "func_qualifier_list_c_stid_opt", (yyvsp[-3].tid) );
      DUMP_TID( "noexcept_c_stid_opt", (yyvsp[-2].tid) );
      DUMP_TID( "func_equals_c_stid_opt", (yyvsp[0].tid) );

      c_ast_t *const dtor_ast = c_ast_new_gc( K_DESTRUCTOR, &(yyloc) );
      c_sname_init_name( &dtor_ast->sname, (yyvsp[-6].name) );
      dtor_ast->type.stids = c_tid_check(
        (yyvsp[-8].tid) | (yyvsp[-3].tid) | (yyvsp[-2].tid) | (yyvsp[0].tid),
        C_TPID_STORE
      );

      DUMP_AST( "$$_ast", dtor_ast );
      DUMP_END();

      PARSE_ASSERT( c_ast_check( dtor_ast ) );
      c_ast_english( dtor_ast, C_ENG_DECL, stdout );
      PUTC( '\n' );
    }
#line 9082 "parser.c"
    break;

  case 409: /* no_destructor_params: error  */
#line 4954 "parser.y"
    { //
      // Ordinarily, we'd get an error message like:
      //
      //      c++decl> explain ~C(int)
      //                          ^
      //      12: syntax error: "int": destructors may not have parameters
      //      ("int" is a keyword)
      //
      // where the <<("int" is a keyword)>> part seems wrong since the user
      // didn't try using "int" as an ordinary identifier.  To suppress that
      // part, set yytext to the empty string so elaborate_error() won't print
      // it nor call print_error_token_is_a() and and we'll instead get an
      // error message like:
      //
      //      c++decl> explain ~C(int)
      //                          ^
      //      12: syntax error: destructors may not have parameters
      //
      set_yytext( "" );
      elaborate_error( "destructors may not have parameters" );
    }
#line 9108 "parser.c"
    break;

  case 410: /* file_scope_constructor_declaration_c: inline_stid_opt Y_CONSTRUCTOR_SNAME lparen_exp param_c_ast_list_opt param_list_rparen_func_qualifier_list_c_stid_opt noexcept_c_stid_opt gnu_attribute_specifier_list_c_opt  */
#line 4984 "parser.y"
    {
      DUMP_START( "file_scope_constructor_declaration_c",
                  "inline_opt CONSTRUCTOR_SNAME '(' param_c_ast_list_opt ')' "
                  "func_qualifier_list_c_stid_opt noexcept_c_stid_opt" );
      DUMP_TID( "inline_stid_opt", (yyvsp[-6].tid) );
      DUMP_SNAME( "CONSTRUCTOR_SNAME", (yyvsp[-5].sname) );
      DUMP_AST_LIST( "param_c_ast_list_opt", (yyvsp[-3].ast_list) );
      DUMP_TID( "func_qualifier_list_c_stid_opt", (yyvsp[-2].tid) );
      DUMP_TID( "noexcept_c_stid_opt", (yyvsp[-1].tid) );

      c_sname_set_scope_type( &(yyvsp[-5].sname), &C_TYPE_LIT_B( TB_class ) );

      c_ast_t *const ctor_ast = c_ast_new_gc( K_CONSTRUCTOR, &(yyloc) );
      ctor_ast->sname = c_sname_move( &(yyvsp[-5].sname) );
      ctor_ast->type.stids = c_tid_check(
        (yyvsp[-6].tid) | (yyvsp[-2].tid) | (yyvsp[-1].tid),
        C_TPID_STORE
      );
      c_ast_list_set_param_of( &(yyvsp[-3].ast_list), ctor_ast );
      ctor_ast->ctor.param_ast_list = slist_move( &(yyvsp[-3].ast_list) );

      DUMP_AST( "$$_ast", ctor_ast );
      DUMP_END();

      PARSE_ASSERT( c_ast_check( ctor_ast ) );
      c_ast_english( ctor_ast, C_ENG_DECL, stdout );
      PUTC( '\n' );
    }
#line 9141 "parser.c"
    break;

  case 411: /* file_scope_destructor_declaration_c: inline_stid_opt destructor_sname lparen_exp no_destructor_params param_list_rparen_func_qualifier_list_c_stid_opt noexcept_c_stid_opt gnu_attribute_specifier_list_c_opt  */
#line 5021 "parser.y"
    {
      DUMP_START( "file_scope_destructor_declaration_c",
                  "inline_opt destructor_sname '(' ')' "
                  "func_qualifier_list_c_stid_opt noexcept_c_stid_opt" );
      DUMP_TID( "inline_stid_opt", (yyvsp[-6].tid) );
      DUMP_SNAME( "destructor_sname", (yyvsp[-5].sname) );
      DUMP_TID( "func_qualifier_list_c_stid_opt", (yyvsp[-2].tid) );
      DUMP_TID( "noexcept_c_stid_opt", (yyvsp[-1].tid) );

      c_sname_set_scope_type( &(yyvsp[-5].sname), &C_TYPE_LIT_B( TB_class ) );

      c_ast_t *const dtor_ast = c_ast_new_gc( K_DESTRUCTOR, &(yyloc) );
      dtor_ast->sname = c_sname_move( &(yyvsp[-5].sname) );
      dtor_ast->type.stids = c_tid_check(
        (yyvsp[-6].tid) | (yyvsp[-2].tid) | (yyvsp[-1].tid),
        C_TPID_STORE
      );

      DUMP_AST( "$$_ast", dtor_ast );
      DUMP_END();

      PARSE_ASSERT( c_ast_check( dtor_ast ) );
      c_ast_english( dtor_ast, C_ENG_DECL, stdout );
      PUTC( '\n' );
    }
#line 9171 "parser.c"
    break;

  case 412: /* func_decl_c_astp: decl2_c_astp param_list_c_lparen param_c_ast_list_opt param_list_rparen_func_qualifier_list_c_stid_opt ref_qualifier_c_stid_opt noexcept_c_stid_opt trailing_return_type_c_ast_opt func_equals_c_stid_opt  */
#line 5066 "parser.y"
    {
      c_ast_t *const type_ast = ia_type_ast_peek();

      DUMP_START( "func_decl_c_astp",
                  "decl2_c_astp '(' param_c_ast_list_opt ')' "
                  "func_qualifier_list_c_stid_opt "
                  "ref_qualifier_c_stid_opt noexcept_c_stid_opt "
                  "trailing_return_type_c_ast_opt "
                  "func_equals_c_stid_opt" );
      DUMP_AST( "in_attr__type_c_ast", type_ast );
      DUMP_AST_PAIR( "decl2_c_astp", (yyvsp[-7].ast_pair) );
      DUMP_AST_LIST( "param_c_ast_list_opt", (yyvsp[-5].ast_list) );
      DUMP_TID( "func_qualifier_list_c_stid_opt", (yyvsp[-4].tid) );
      DUMP_TID( "ref_qualifier_c_stid_opt", (yyvsp[-3].tid) );
      DUMP_TID( "noexcept_c_stid_opt", (yyvsp[-2].tid) );
      DUMP_AST( "trailing_return_type_c_ast_opt", (yyvsp[-1].ast) );
      DUMP_TID( "func_equals_c_stid_opt", (yyvsp[0].tid) );

      c_tid_t const func_stids = c_tid_check(
        (yyvsp[-4].tid) | (yyvsp[-3].tid) | (yyvsp[-2].tid) | (yyvsp[0].tid),
        C_TPID_STORE
      );

      bool const assume_constructor = c_ast_is_likely_ctor( type_ast );

      c_ast_t *const func_ast =
        c_ast_new_gc( assume_constructor ? K_CONSTRUCTOR : K_FUNCTION, &(yyloc) );
      func_ast->type.stids = func_stids;
      c_ast_list_set_param_of( &(yyvsp[-5].ast_list), func_ast );
      func_ast->func.param_ast_list = slist_move( &(yyvsp[-5].ast_list) );

      c_ast_t *const decl_ast = (yyvsp[-7].ast_pair).ast;

      if ( assume_constructor ) {
        assert( (yyvsp[-1].ast) == NULL );
        (yyval.ast_pair) = (c_ast_pair_t){
          c_ast_add_func( decl_ast, func_ast, /*ret_ast=*/NULL ),
          .target_ast = NULL
        };
      }
      else {
        c_ast_t *ret_ast;
        c_ast_t *target_ast = (yyvsp[-7].ast_pair).target_ast;

        if ( target_ast != NULL && target_ast->kind != K_POINTER ) {
          //
          // This is for a case like:
          //
          //      int f() ()
          //       |    |  |
          //       |    |  func
          //       |    |
          //       |    decl_ast (func)
          //       |
          //       ret_ast
          //
          // We replace ret_ast with decl_ast:
          //
          //      int f() ()
          //       |    |  |
          //       |    |  func
          //       X    |
          //       |    decl_ast (func)
          //       |
          //       ret_ast <- decl_ast (func)
          //
          // that is, a "function returning function" -- which is illegal
          // (since functions can't return functions) and will be caught by
          // c_ast_check_ret_type().
          //
          ret_ast = decl_ast;
          target_ast = NULL;
        }
        else {
          ret_ast = IF_ELSE( (yyvsp[-1].ast), ia_type_spec_ast( type_ast ) );
        }

        if ( target_ast != NULL ) {
          (yyval.ast_pair) = (c_ast_pair_t){
            decl_ast,
            c_ast_add_func( target_ast, func_ast, ret_ast )
          };
        }
        else {
          (yyval.ast_pair) = (c_ast_pair_t){
            c_ast_add_func( decl_ast, func_ast, ret_ast ),
            func_ast->func.ret_ast
          };
        }
      }

      c_tid_t const msc_call_atids = (yyval.ast_pair).ast->type.atids & TA_ANY_MSC_CALL;
      if ( msc_call_atids != TA_NONE ) {
        //
        // Microsoft calling conventions need to be moved from the pointer to
        // the function, e.g., change:
        //
        //      declare f as cdecl pointer to function returning void
        //
        // to:
        //
        //      declare f as pointer to cdecl function returning void
        //
        for ( c_ast_t *ast = (yyval.ast_pair).ast; (ast = c_ast_unpointer( ast )) != NULL; ) {
          if ( ast->kind == K_FUNCTION ) {
            (yyval.ast_pair).ast->type.atids &= c_tid_compl( TA_ANY_MSC_CALL );
            ast->type.atids |= msc_call_atids;
          }
        } // for
      }

      DUMP_AST_PAIR( "$$_astp", (yyval.ast_pair) );
      DUMP_END();
    }
#line 9290 "parser.c"
    break;

  case 413: /* $@21: %empty  */
#line 5191 "parser.y"
    {
      if ( OPT_LANG_IS( CONSTRUCTORS ) ) {
        //
        // In C++, encountering a name followed by '(' declares an in-class
        // constructor.  That means NAME is the name of a class, so we have to
        // create a temporary class type for it so if it's used as the type of
        // a parameter, e.g.:
        //
        //      C(C const&)
        //
        // it'll be recognized as such.
        //
        c_ast_t *const csu_ast = c_ast_new_gc( K_CLASS_STRUCT_UNION, &(yylsp[-1]) );
        csu_ast->type.btids = TB_class;
        c_sname_init_name( &csu_ast->csu.csu_sname, check_strdup( (yyvsp[-1].name) ) );
        csu_ast->sname = c_sname_dup( &csu_ast->csu.csu_sname );

        in_attr.tdef_rb = c_typedef_add( csu_ast, C_GIB_TYPEDEF );
        MAYBE_UNUSED c_typedef_t const *const csu_tdef = in_attr.tdef_rb->data;
        assert( csu_tdef->ast == csu_ast );
      }
    }
#line 9317 "parser.c"
    break;

  case 414: /* pc99_func_or_constructor_declaration_c: Y_NAME param_list_c_lparen $@21 param_c_ast_list_opt param_list_rparen_func_qualifier_list_c_stid_opt noexcept_c_stid_opt func_equals_c_stid_opt  */
#line 5216 "parser.y"
    {
      DUMP_START( "pc99_func_or_constructor_declaration_c",
                  "NAME '(' param_c_ast_list_opt ')' noexcept_c_stid_opt "
                  "func_equals_c_stid_opt" );
      DUMP_STR( "NAME", (yyvsp[-6].name) );
      DUMP_AST_LIST( "param_c_ast_list_opt", (yyvsp[-3].ast_list) );
      DUMP_TID( "func_qualifier_list_c_stid_opt", (yyvsp[-2].tid) );
      DUMP_TID( "noexcept_c_stid_opt", (yyvsp[-1].tid) );
      DUMP_TID( "func_equals_c_stid_opt", (yyvsp[0].tid) );

      c_ast_t *ast;

      if ( OPT_LANG_IS( CONSTRUCTORS ) ) {
        //
        // Free the temporary typedef for the class.
        //
        // Note that we free only the typedef and not its AST; its AST will be
        // garbage collected.
        //
        free( c_typedef_remove( in_attr.tdef_rb ) );

        //
        // In C++, encountering a name followed by '(' declares an in-class
        // constructor.
        //
        ast = c_ast_new_gc( K_CONSTRUCTOR, &(yyloc) );
      }
      else {
        if ( !OPT_LANG_IS( IMPLICIT_int ) ) {
          //
          // In C99 and later, implicit int is an error.  This check has to be
          // done now in the parser rather than later in the AST since the AST
          // would have no "memory" that the return type was implicitly int.
          //
          print_error( &(yylsp[-6]),
            "implicit \"%s\" functions are illegal%s",
            c_tid_error( TB_int ),
            C_LANG_WHICH( IMPLICIT_int )
          );
          print_error_token_is_a( (yyvsp[-6].name) );
          if ( strcmp( (yyvsp[-6].name), L_typeof ) == 0 ||
               strcmp( (yyvsp[-6].name), L_typeof_unqual ) == 0 ) {
            EPRINTF( "; use \"%s\" instead", L_GNU___typeof__ );
          }
          else {
            print_suggestions(
              DYM_C_KEYWORDS | DYM_C_MACROS | DYM_C_TYPES,
              (yyvsp[-6].name)
            );
          }
          EPUTC( '\n' );
          free( (yyvsp[-6].name) );
          PARSE_ABORT();
        }

        //
        // In C prior to C99, encountering a name followed by '(' declares a
        // function that implicitly returns int:
        //
        //      power(x, n)             /* raise x to n-th power; n > 0 */
        //
        c_ast_t *const ret_ast = c_ast_new_gc( K_BUILTIN, &(yylsp[-6]) );
        ret_ast->type.btids = TB_int;

        ast = c_ast_new_gc( K_FUNCTION, &(yyloc) );
        c_ast_set_parent( ret_ast, ast );
      }

      c_sname_init_name( &ast->sname, (yyvsp[-6].name) );
      ast->type.stids = c_tid_check(
        (yyvsp[-2].tid) | (yyvsp[-1].tid) | (yyvsp[0].tid),
        C_TPID_STORE
      );
      c_ast_list_set_param_of( &(yyvsp[-3].ast_list), ast );
      ast->func.param_ast_list = slist_move( &(yyvsp[-3].ast_list) );

      DUMP_AST( "$$_ast", ast );
      DUMP_END();

      PARSE_ASSERT( c_ast_check( ast ) );
      c_ast_english( ast, C_ENG_DECL, stdout );
      PUTC( '\n' );
    }
#line 9405 "parser.c"
    break;

  case 415: /* $@22: %empty  */
#line 5303 "parser.y"
    {
      if ( OPT_LANG_IS( MEMBER_FUNCTIONS ) ) {
        //
        // Both "final" and "override" are matched only within member function
        // declarations.  Now that ')' has been parsed, we're within one, so
        // set the keyword context to C_KW_CTX_MBR_FUNC.
        //
        lexer_keyword_ctx = C_KW_CTX_MBR_FUNC;
      }
    }
#line 9420 "parser.c"
    break;

  case 416: /* param_list_rparen_func_qualifier_list_c_stid_opt: param_list_rparen $@22 func_qualifier_list_c_stid_opt  */
#line 5314 "parser.y"
    {
      lexer_keyword_ctx = C_KW_CTX_DEFAULT;
      (yyval.tid) = (yyvsp[0].tid);
    }
#line 9429 "parser.c"
    break;

  case 417: /* func_qualifier_list_c_stid_opt: %empty  */
#line 5321 "parser.y"
                                  { (yyval.tid) = TS_NONE; }
#line 9435 "parser.c"
    break;

  case 418: /* func_qualifier_list_c_stid_opt: func_qualifier_list_c_stid_opt func_qualifier_c_stid  */
#line 5323 "parser.y"
    {
      DUMP_START( "func_qualifier_list_c_stid_opt",
                  "func_qualifier_list_c_stid_opt func_qualifier_c_stid" );
      DUMP_TID( "func_qualifier_list_c_stid_opt", (yyvsp[-1].tid) );
      DUMP_TID( "func_qualifier_c_stid", (yyvsp[0].tid) );

      (yyval.tid) = (yyvsp[-1].tid);
      PARSE_ASSERT( c_tid_add( &(yyval.tid), (yyvsp[0].tid), &(yylsp[0]) ) );

      DUMP_TID( "$$_stids", (yyval.tid) );
      DUMP_END();
    }
#line 9452 "parser.c"
    break;

  case 423: /* noexcept_c_stid_opt: %empty  */
#line 5352 "parser.y"
                                  { (yyval.tid) = TS_NONE; }
#line 9458 "parser.c"
    break;

  case 425: /* noexcept_c_stid_opt: Y_noexcept '(' noexcept_bool_stid_exp rparen_exp  */
#line 5355 "parser.y"
    {
      (yyval.tid) = (yyvsp[-1].tid);
    }
#line 9466 "parser.c"
    break;

  case 426: /* noexcept_c_stid_opt: Y_throw lparen_exp rparen_exp  */
#line 5359 "parser.y"
    {
      (yyval.tid) = (yyvsp[-2].tid);
    }
#line 9474 "parser.c"
    break;

  case 427: /* noexcept_c_stid_opt: Y_throw lparen_exp param_c_ast_list ')'  */
#line 5363 "parser.y"
    {
      c_ast_list_cleanup( &(yyvsp[-1].ast_list) );

      if ( OPT_LANG_IS( throw ) )
        UNSUPPORTED( &(yylsp[-1]), "dynamic exception specifications" );

      print_error( &(yylsp[-1]),
        "dynamic exception specifications not supported%s\n",
        C_LANG_WHICH( throw )
      );
      PARSE_ABORT();
    }
#line 9491 "parser.c"
    break;

  case 430: /* noexcept_bool_stid_exp: error  */
#line 5381 "parser.y"
    {
      elaborate_error( "\"true\" or \"false\" expected" );
    }
#line 9499 "parser.c"
    break;

  case 431: /* trailing_return_type_c_ast_opt: %empty  */
#line 5387 "parser.y"
                                  { (yyval.ast) = NULL; }
#line 9505 "parser.c"
    break;

  case 432: /* $@23: %empty  */
#line 5389 "parser.y"
                                         { ia_type_ast_push( (yyvsp[0].ast) ); }
#line 9511 "parser.c"
    break;

  case 433: /* trailing_return_type_c_ast_opt: Y_MINUS_GREATER type_c_ast $@23 cast_c_astp_opt  */
#line 5391 "parser.y"
    { //
      // The function trailing return-type syntax is supported only in C++11
      // and later.  This check has to be done now in the parser rather than
      // later in the AST because the AST has no "memory" of where the return-
      // type came from.
      //
      if ( !OPT_LANG_IS( TRAILING_RETURN_TYPES ) ) {
        print_error( &(yylsp[-3]),
          "trailing return type not supported%s\n",
          C_LANG_WHICH( TRAILING_RETURN_TYPES )
        );
        PARSE_ABORT();
      }

      ia_type_ast_pop();
      c_ast_t const *const ret_ast = ia_type_ast_peek();

      DUMP_START( "trailing_return_type_c_ast_opt",
                  "'->' type_c_ast cast_c_astp_opt" );
      DUMP_AST( "in_attr__type_c_ast", ret_ast );
      DUMP_AST( "type_c_ast", (yyvsp[-2].ast) );
      DUMP_AST_PAIR( "cast_c_astp_opt", (yyvsp[0].ast_pair) );

      (yyval.ast) = IF_ELSE( (yyvsp[0].ast_pair).ast, (yyvsp[-2].ast) );

      DUMP_AST( "$$_ast", (yyval.ast) );
      DUMP_END();

      //
      // Ensure that a function using the C++11 trailing return type syntax
      // starts with "auto":
      //
      //      void f() -> int
      //      ^
      //      error: must be "auto"
      //
      // This check has to be done now in the parser rather than later in the
      // AST because the "auto" is just a syntactic return-type placeholder in
      // C++11 and the AST node for the placeholder is discarded and never made
      // part of the AST.
      //
      if ( ret_ast->type.btids != TB_auto ) {
        print_error( &ret_ast->loc,
          "function with trailing return type must only specify \"%s\"\n",
          c_tid_error( TB_auto )
        );
        PARSE_ABORT();
      }
    }
#line 9565 "parser.c"
    break;

  case 434: /* trailing_return_type_c_ast_opt: gnu_attribute_specifier_list_c  */
#line 5442 "parser.y"
    {
      (yyval.ast) = NULL;
    }
#line 9573 "parser.c"
    break;

  case 435: /* func_equals_c_stid_opt: %empty  */
#line 5448 "parser.y"
                                  { (yyval.tid) = TS_NONE; }
#line 9579 "parser.c"
    break;

  case 436: /* func_equals_c_stid_opt: '=' Y_default  */
#line 5449 "parser.y"
                                  { (yyval.tid) = (yyvsp[0].tid); }
#line 9585 "parser.c"
    break;

  case 437: /* func_equals_c_stid_opt: '=' Y_delete delete_reason_opt  */
#line 5451 "parser.y"
    {
      (yyval.tid) = (yyvsp[-1].tid);
    }
#line 9593 "parser.c"
    break;

  case 438: /* func_equals_c_stid_opt: '=' uint_lit  */
#line 5455 "parser.y"
    {
      if ( (yyvsp[0].uint_val) != 0 ) {
        print_error( &(yylsp[0]), "'0' expected\n" );
        PARSE_ABORT();
      }
      (yyval.tid) = TS_PURE_virtual;
    }
#line 9605 "parser.c"
    break;

  case 439: /* func_equals_c_stid_opt: '=' error  */
#line 5463 "parser.y"
    {
      if ( OPT_LANG_IS( default_delete_FUNCS ) )
        elaborate_error( "'0', \"default\", or \"delete\" expected" );
      else
        elaborate_error( "'0' expected" );
    }
#line 9616 "parser.c"
    break;

  case 441: /* delete_reason_opt: '(' str_lit_exp rparen_exp  */
#line 5474 "parser.y"
    {
      FREE( (yyvsp[-1].str_val) );
      //
      // This check has to be done now in the parser rather than later in the
      // AST since we ignore the reason string.
      //
      if ( !OPT_LANG_IS( delete_REASON ) ) {
        print_error( &(yylsp[-1]),
          "\"delete\" with reason not supported%s\n",
          C_LANG_WHICH( delete_REASON )
        );
        PARSE_ABORT();
      }
    }
#line 9635 "parser.c"
    break;

  case 443: /* param_c_ast_list_exp: error  */
#line 5495 "parser.y"
    {
      slist_init( &(yyval.ast_list) );
      elaborate_error( "parameter list expected" );
    }
#line 9644 "parser.c"
    break;

  case 444: /* param_c_ast_list_opt: %empty  */
#line 5502 "parser.y"
                                  { slist_init( &(yyval.ast_list) ); }
#line 9650 "parser.c"
    break;

  case 446: /* param_c_ast_list: param_c_ast_list comma_exp param_c_ast_exp  */
#line 5508 "parser.y"
    {
      DUMP_START( "param_c_ast_list", "param_c_ast_list ',' param_c_ast" );
      DUMP_AST_LIST( "param_c_ast_list", (yyvsp[-2].ast_list) );
      DUMP_AST( "param_c_ast", (yyvsp[0].ast) );

      (yyval.ast_list) = (yyvsp[-2].ast_list);
      slist_push_back( &(yyval.ast_list), (yyvsp[0].ast) );

      DUMP_AST_LIST( "$$_ast_list", (yyval.ast_list) );
      DUMP_END();
    }
#line 9666 "parser.c"
    break;

  case 447: /* param_c_ast_list: param_c_ast  */
#line 5521 "parser.y"
    {
      DUMP_START( "param_c_ast_list", "param_c_ast" );
      DUMP_AST( "param_c_ast", (yyvsp[0].ast) );

      slist_init( &(yyval.ast_list) );
      slist_push_back( &(yyval.ast_list), (yyvsp[0].ast) );

      DUMP_AST_LIST( "$$_ast_list", (yyval.ast_list) );
      DUMP_END();
    }
#line 9681 "parser.c"
    break;

  case 448: /* $@24: %empty  */
#line 5538 "parser.y"
    {
      ia_type_ast_push( (yyvsp[0].ast) );
    }
#line 9689 "parser.c"
    break;

  case 449: /* param_c_ast: this_stid_opt type_c_ast $@24 cast_c_astp_opt  */
#line 5542 "parser.y"
    {
      ia_type_ast_pop();

      DUMP_START( "param_c_ast", "this_stid_opt type_c_ast cast_c_astp_opt" );
      DUMP_TID( "this_stid_opt", (yyvsp[-3].tid) );
      DUMP_AST( "type_c_ast", (yyvsp[-2].ast) );
      DUMP_AST_PAIR( "cast_c_astp_opt", (yyvsp[0].ast_pair) );

      (yyval.ast) = c_ast_patch_placeholder( (yyvsp[-2].ast), (yyvsp[0].ast_pair).ast );

      if ( (yyval.ast)->kind == K_FUNCTION ) {
        //
        // From the C11 standard, section 6.3.2.1(4):
        //
        //    [A] function designator with type "function returning type" is
        //    converted to an expression that has type "pointer to function
        //    returning type."
        //
        (yyval.ast) = c_ast_pointer( (yyval.ast), &gc_ast_list );
      }

      PARSE_ASSERT( c_type_add_tid( &(yyval.ast)->type, (yyvsp[-3].tid), &(yylsp[-3]) ) );

      DUMP_AST( "$$_ast", (yyval.ast) );
      DUMP_END();
    }
#line 9720 "parser.c"
    break;

  case 451: /* param_c_ast: "..."  */
#line 5578 "parser.y"
    {
      DUMP_START( "param_c_ast", "..." );

      (yyval.ast) = c_ast_new_gc( K_VARIADIC, &(yyloc) );

      DUMP_AST( "$$_ast", (yyval.ast) );
      DUMP_END();
    }
#line 9733 "parser.c"
    break;

  case 453: /* param_c_ast_exp: error  */
#line 5591 "parser.y"
    {
      elaborate_error( "parameter declaration expected" );
    }
#line 9741 "parser.c"
    break;

  case 454: /* paren_param_c_ast_list_opt: %empty  */
#line 5597 "parser.y"
                                  { slist_init( &(yyval.ast_list) ); }
#line 9747 "parser.c"
    break;

  case 455: /* paren_param_c_ast_list_opt: param_list_c_lparen param_c_ast_list_opt param_list_rparen  */
#line 5599 "parser.y"
    {
      (yyval.ast_list) = (yyvsp[-1].ast_list);
    }
#line 9755 "parser.c"
    break;

  case 456: /* param_list_c_lparen: '('  */
#line 5605 "parser.y"
                                  { lexer_is_param_list_decl = true; }
#line 9761 "parser.c"
    break;

  case 457: /* param_list_rparen: ')'  */
#line 5609 "parser.y"
                                  { lexer_is_param_list_decl = false; }
#line 9767 "parser.c"
    break;

  case 458: /* $@25: %empty  */
#line 5616 "parser.y"
    {
      ia_type_ast_push( c_ast_new_gc( K_PLACEHOLDER, &(yyloc) ) );
      ++in_attr.ast_depth;
    }
#line 9776 "parser.c"
    break;

  case 459: /* nested_decl_c_astp: '(' $@25 decl_c_astp rparen_exp  */
#line 5621 "parser.y"
    {
      ia_type_ast_pop();
      --in_attr.ast_depth;

      DUMP_START( "nested_decl_c_astp", "'(' decl_c_astp ')'" );
      DUMP_AST_PAIR( "decl_c_astp", (yyvsp[-1].ast_pair) );

      (yyval.ast_pair) = (yyvsp[-1].ast_pair);
      (yyval.ast_pair).ast->loc = (yyloc);

      DUMP_AST_PAIR( "$$_astp", (yyval.ast_pair) );
      DUMP_END();
    }
#line 9794 "parser.c"
    break;

  case 460: /* oper_decl_c_astp: oper_sname_c_opt Y_operator c_operator param_list_c_lparen param_c_ast_list_opt param_list_rparen_func_qualifier_list_c_stid_opt ref_qualifier_c_stid_opt noexcept_c_stid_opt trailing_return_type_c_ast_opt func_equals_c_stid_opt  */
#line 5647 "parser.y"
    {
      c_operator_t const *const operator = c_op_get( (yyvsp[-7].op_id) );
      c_ast_t *const type_ast = ia_type_ast_peek();

      DUMP_START( "oper_decl_c_astp",
                  "oper_sname_c_opt OPERATOR c_operator "
                  "'(' param_c_ast_list_opt ')' "
                  "func_qualifier_list_c_stid_opt "
                  "ref_qualifier_c_stid_opt noexcept_c_stid_opt "
                  "trailing_return_type_c_ast_opt "
                  "func_equals_c_stid_opt" );
      DUMP_AST( "in_attr__type_c_ast", type_ast );
      DUMP_SNAME( "oper_sname_c_opt", (yyvsp[-9].sname) );
      DUMP_STR( "c_operator", operator->literal );
      DUMP_AST_LIST( "param_c_ast_list_opt", (yyvsp[-5].ast_list) );
      DUMP_TID( "func_qualifier_list_c_stid_opt", (yyvsp[-4].tid) );
      DUMP_TID( "ref_qualifier_c_stid_opt", (yyvsp[-3].tid) );
      DUMP_TID( "noexcept_c_stid_opt", (yyvsp[-2].tid) );
      DUMP_AST( "trailing_return_type_c_ast_opt", (yyvsp[-1].ast) );
      DUMP_TID( "func_equals_c_stid_opt", (yyvsp[0].tid) );

      c_tid_t const oper_stids = c_tid_check(
        (yyvsp[-4].tid) | (yyvsp[-3].tid) | (yyvsp[-2].tid) | (yyvsp[0].tid),
        C_TPID_STORE
      );

      c_ast_t *const oper_ast = c_ast_new_gc( K_OPERATOR, &(yyloc) );
      oper_ast->sname = c_sname_move( &(yyvsp[-9].sname) );
      oper_ast->type.stids = oper_stids;
      c_ast_list_set_param_of( &(yyvsp[-5].ast_list), oper_ast );
      oper_ast->oper.param_ast_list = slist_move( &(yyvsp[-5].ast_list) );
      oper_ast->oper.operator = operator;

      c_ast_t *const ret_ast =
        IF_ELSE( (yyvsp[-1].ast), ia_type_spec_ast( type_ast ) );

      (yyval.ast_pair) = (c_ast_pair_t){
        c_ast_add_func( type_ast, oper_ast, ret_ast ),
        oper_ast->oper.ret_ast
      };

      DUMP_AST_PAIR( "$$_astp", (yyval.ast_pair) );
      DUMP_END();
    }
#line 9843 "parser.c"
    break;

  case 461: /* $@26: %empty  */
#line 5696 "parser.y"
                                 { ia_type_ast_push( (yyvsp[0].ast) ); }
#line 9849 "parser.c"
    break;

  case 462: /* pointer_decl_c_astp: pointer_type_c_ast $@26 decl_c_astp  */
#line 5698 "parser.y"
    {
      ia_type_ast_pop();

      DUMP_START( "pointer_decl_c_astp", "pointer_type_c_ast decl_c_astp" );
      DUMP_AST( "pointer_type_c_ast", (yyvsp[-2].ast) );
      DUMP_AST_PAIR( "decl_c_astp", (yyvsp[0].ast_pair) );

      PJL_DISCARD_RV( c_ast_patch_placeholder( (yyvsp[-2].ast), (yyvsp[0].ast_pair).ast ) );
      (yyval.ast_pair) = (yyvsp[0].ast_pair);
      (yyval.ast_pair).ast->loc = (yyloc);

      DUMP_AST_PAIR( "$$_astp", (yyval.ast_pair) );
      DUMP_END();
    }
#line 9868 "parser.c"
    break;

  case 463: /* pointer_type_c_ast: '*' type_qualifier_list_c_stid_opt  */
#line 5717 "parser.y"
    {
      c_ast_t *const type_ast = ia_type_ast_peek();

      DUMP_START( "pointer_type_c_ast", "'*' type_qualifier_list_c_stid_opt" );
      DUMP_AST( "in_attr__type_c_ast", type_ast );
      DUMP_TID( "type_qualifier_list_c_stid_opt", (yyvsp[0].tid) );

      (yyval.ast) = c_ast_new_gc( K_POINTER, &(yyloc) );
      (yyval.ast)->type.stids = c_tid_check( (yyvsp[0].tid), C_TPID_STORE );
      c_ast_set_parent( ia_type_spec_ast( type_ast ), (yyval.ast) );

      DUMP_AST( "$$_ast", (yyval.ast) );
      DUMP_END();
    }
#line 9887 "parser.c"
    break;

  case 464: /* pc99_pointer_decl_list_c: pc99_pointer_decl_c ',' decl_list_c  */
#line 5737 "parser.y"
    {
      (yyval.ast_list) = (yyvsp[0].ast_list);
      slist_push_front( &(yyval.ast_list), (yyvsp[-2].ast) );
    }
#line 9896 "parser.c"
    break;

  case 465: /* pc99_pointer_decl_list_c: pc99_pointer_decl_c  */
#line 5742 "parser.y"
    {
      slist_init( &(yyval.ast_list) );
      slist_push_back( &(yyval.ast_list), (yyvsp[0].ast) );
    }
#line 9905 "parser.c"
    break;

  case 466: /* $@27: %empty  */
#line 5749 "parser.y"
                                      { ia_type_ast_push( (yyvsp[0].ast) ); }
#line 9911 "parser.c"
    break;

  case 467: /* pc99_pointer_decl_c: pc99_pointer_type_c_ast $@27 decl_c_astp  */
#line 5751 "parser.y"
    {
      ia_type_ast_pop();

      DUMP_START( "pc99_pointer_decl_c",
                  "pc99_pointer_type_c_ast decl_c_astp" );
      DUMP_AST( "pc99_pointer_type_c_ast", (yyvsp[-2].ast) );
      DUMP_AST_PAIR( "decl_c_astp", (yyvsp[0].ast_pair) );

      (yyval.ast) = c_ast_patch_placeholder( (yyvsp[-2].ast), (yyvsp[0].ast_pair).ast );
      (yyval.ast)->loc = (yyloc);

      DUMP_AST( "$$_ast", (yyval.ast) );
      DUMP_END();
    }
#line 9930 "parser.c"
    break;

  case 468: /* pc99_pointer_type_c_ast: '*' type_qualifier_list_c_stid_opt  */
#line 5770 "parser.y"
    {
      if ( !OPT_LANG_IS( IMPLICIT_int ) ) {
        //
        // In C99 and later, implicit int is an error.  This check has to be
        // done now in the parser rather than later in the AST since the AST
        // would have no "memory" that the return type was implicitly int.
        //
        print_error( &(yylsp[-1]),
          "implicit \"%s\" is illegal%s\n",
          c_tid_error( TB_int ),
          C_LANG_WHICH( IMPLICIT_int )
        );
        PARSE_ABORT();
      }

      c_ast_t *type_ast = ia_type_ast_peek();

      DUMP_START( "pc99_pointer_type_c_ast",
                  "'*' type_qualifier_list_c_stid_opt" );
      DUMP_AST( "in_attr__type_c_ast", type_ast );
      DUMP_TID( "type_qualifier_list_c_stid_opt", (yyvsp[0].tid) );

      if ( type_ast == NULL ) {
        type_ast = c_ast_new_gc( K_BUILTIN, &(yyloc) );
        type_ast->type.btids = TB_int;
        ia_type_ast_push( type_ast );
      }

      (yyval.ast) = c_ast_pointer( ia_type_spec_ast( type_ast ), &gc_ast_list );
      (yyval.ast)->type.stids = c_tid_check( (yyvsp[0].tid), C_TPID_STORE );

      DUMP_AST( "$$_ast", (yyval.ast) );
      DUMP_END();
    }
#line 9969 "parser.c"
    break;

  case 469: /* $@28: %empty  */
#line 5809 "parser.y"
                                           { ia_type_ast_push( (yyvsp[0].ast) ); }
#line 9975 "parser.c"
    break;

  case 470: /* pointer_to_member_decl_c_astp: pointer_to_member_type_c_ast $@28 decl_c_astp  */
#line 5811 "parser.y"
    {
      ia_type_ast_pop();

      DUMP_START( "pointer_to_member_decl_c_astp",
                  "pointer_to_member_type_c_ast decl_c_astp" );
      DUMP_AST( "pointer_to_member_type_c_ast", (yyvsp[-2].ast) );
      DUMP_AST_PAIR( "decl_c_astp", (yyvsp[0].ast_pair) );

      (yyval.ast_pair) = (yyvsp[0].ast_pair);
      (yyval.ast_pair).ast->loc = (yyloc);

      DUMP_AST_PAIR( "$$_astp", (yyval.ast_pair) );
      DUMP_END();
    }
#line 9994 "parser.c"
    break;

  case 471: /* pointer_to_member_type_c_ast: any_sname_c Y_COLON_COLON_STAR '*' cv_qualifier_list_stid_opt  */
#line 5831 "parser.y"
    {
      c_ast_t *const type_ast = ia_type_ast_peek();

      DUMP_START( "pointer_to_member_type_c_ast",
                  "any_sname_c '::*' cv_qualifier_list_stid_opt" );
      DUMP_AST( "in_attr__type_c_ast", type_ast );
      DUMP_SNAME( "any_sname_c", (yyvsp[-3].sname) );
      DUMP_TID( "cv_qualifier_list_stid_opt", (yyvsp[0].tid) );

      (yyval.ast) = c_ast_new_gc( K_POINTER_TO_MEMBER, &(yyloc) );

      c_type_t scope_type = *c_sname_local_type( &(yyvsp[-3].sname) );
      if ( !c_tid_is_any( scope_type.btids, TB_ANY_SCOPE ) ) {
        //
        // The sname has no scope-type, but we now know there's a pointer-to-
        // member of it, so it must be a class.  (It could alternatively be a
        // struct, but we have no context to know, so just pick class because
        // it's more C++-like.)
        //
        scope_type.btids = TB_class;
        c_sname_local_data( &(yyvsp[-3].sname) )->type = scope_type;
      }

      // adopt sname's scope-type for the AST
      (yyval.ast)->type = c_type_or( &C_TYPE_LIT_S( (yyvsp[0].tid) ), &scope_type );

      (yyval.ast)->ptr_mbr.class_sname = c_sname_move( &(yyvsp[-3].sname) );
      c_ast_set_parent( c_ast_dup_gc( type_ast ), (yyval.ast) );

      DUMP_AST( "$$_ast", (yyval.ast) );
      DUMP_END();
    }
#line 10031 "parser.c"
    break;

  case 472: /* $@29: %empty  */
#line 5869 "parser.y"
    {
      (yyvsp[-1].ast)->type.stids = c_tid_check( (yyvsp[0].tid), C_TPID_STORE );
      ia_type_ast_push( (yyvsp[-1].ast) );
    }
#line 10040 "parser.c"
    break;

  case 473: /* reference_decl_c_astp: reference_type_c_ast type_qualifier_list_c_stid_opt $@29 decl_c_astp  */
#line 5874 "parser.y"
    {
      ia_type_ast_pop();

      DUMP_START( "reference_decl_c_astp", "reference_type_c_ast decl_c_astp" );
      DUMP_AST( "reference_type_c_ast", (yyvsp[-3].ast) );
      DUMP_TID( "type_qualifier_list_c_stid_opt", (yyvsp[-2].tid) );
      DUMP_AST_PAIR( "decl_c_astp", (yyvsp[0].ast_pair) );

      (yyval.ast_pair) = (yyvsp[0].ast_pair);
      (yyval.ast_pair).ast->loc = (yyloc);

      DUMP_AST_PAIR( "$$_astp", (yyval.ast_pair) );
      DUMP_END();
    }
#line 10059 "parser.c"
    break;

  case 474: /* reference_type_c_ast: '&'  */
#line 5893 "parser.y"
    {
      c_ast_t *const type_ast = ia_type_ast_peek();

      DUMP_START( "reference_type_c_ast", "'&'" );
      DUMP_AST( "in_attr__type_c_ast", type_ast );

      (yyval.ast) = c_ast_new_gc( K_REFERENCE, &(yyloc) );
      c_ast_set_parent( ia_type_spec_ast( type_ast ), (yyval.ast) );

      DUMP_AST( "$$_ast", (yyval.ast) );
      DUMP_END();
    }
#line 10076 "parser.c"
    break;

  case 475: /* reference_type_c_ast: Y_AMPER_AMPER  */
#line 5908 "parser.y"
    {
      c_ast_t *const type_ast = ia_type_ast_peek();

      DUMP_START( "reference_type_c_ast", "'&&'" );
      DUMP_AST( "in_attr__type_c_ast", type_ast );

      (yyval.ast) = c_ast_new_gc( K_RVALUE_REFERENCE, &(yyloc) );
      c_ast_set_parent( ia_type_spec_ast( type_ast ), (yyval.ast) );

      DUMP_AST( "$$_ast", (yyval.ast) );
      DUMP_END();
    }
#line 10093 "parser.c"
    break;

  case 476: /* typedef_type_decl_c_ast: typedef_type_c_ast bit_field_c_uint_opt  */
#line 5927 "parser.y"
    {
      c_ast_t *const type_ast = ia_type_ast_peek();

      DUMP_START( "typedef_type_decl_c_ast",
                  "typedef_type_c_ast bit_field_c_uint_opt" );
      DUMP_AST( "in_attr__type_c_ast", type_ast );
      DUMP_AST( "typedef_type_c_ast", (yyvsp[-1].ast) );
      DUMP_INT( "bit_field_c_uint_opt", (yyvsp[0].uint_val) );

      if ( c_tid_is_any( type_ast->type.stids, TS_typedef ) ) {
        //
        // If we're defining a type, return the type as-is.
        //
        (yyval.ast) = (yyvsp[-1].ast);
      }
      else {
        //
        // Otherwise, return the type that it's typedef'd as.
        //
        c_ast_t const *const raw_tdef_ast = c_ast_untypedef( (yyvsp[-1].ast) );

        //
        // But first ensure the name isn't of a previously declared type:
        //
        //      cdecl> struct S
        //      cdecl> explain int S    // error: "S": previously declared
        //
        // Note that typedef_type_c_ast is like:
        //
        //      typedef_type_c_ast: {
        //        sname: { string: "" },
        //        kind: { value: 0x20, string: "typedef" },
        //        ...
        //        type: { btid: 0x10000001, ..., string: "none" },
        //        tdef: {
        //          for_ast: {
        //            sname: { string: "S", scopes: "struct" },
        //            kind: { value: 0x8, string: "struct or union" },
        //            ...
        //            type: { btid: 0x800001, ..., string: "struct" },
        //            csu: {
        //              csu_sname: { string: "S", scopes: "none" }
        //            }
        //          }
        //        },
        //        ...
        //      }
        //
        // That is, typedef_type_c_ast has no name itself (at this point), but
        // the raw type, of course, does, so it's that name we have to check.
        //
        // This check has to be done now in the parser rather than later in the
        // AST since if this declaration were joined with a type (like `int`
        // above), the type information would be lost and we'd get this from
        // above:
        //
        //      declare S as structure S          // wrong
        //
        // Additionally, we also get here when the typedef name is used as part
        // of longer name, e.g., `S::x`:
        //
        //      c++decl> explain int S::x
        //      declare x of structure S as int   // correct
        //
        // but that name isn't of a previously declared type, so it's OK.
        //
        PARSE_ASSERT(
          !c_sname_is_type( &raw_tdef_ast->sname, &(yyvsp[-1].ast)->loc )
        );

        //
        // We have to duplicate the type to set the current location.
        //
        (yyval.ast) = c_ast_dup_gc( raw_tdef_ast );
        (yyval.ast)->loc = (yyvsp[-1].ast)->loc;
      }

      PARSE_ASSERT( c_ast_set_bit_field_width( (yyval.ast), (yyvsp[0].uint_val) ) );

      DUMP_AST( "$$_ast", (yyval.ast) );
      DUMP_END();
    }
#line 10180 "parser.c"
    break;

  case 477: /* $@30: %empty  */
#line 6016 "parser.y"
    {
      ia_type_ast_push( (yyvsp[0].ast) );
    }
#line 10188 "parser.c"
    break;

  case 478: /* user_defined_conversion_decl_c_astp: oper_sname_c_opt Y_operator type_c_ast $@30 udc_decl_c_ast_opt lparen_exp param_list_rparen_func_qualifier_list_c_stid_opt noexcept_c_stid_opt func_equals_c_stid_opt  */
#line 6022 "parser.y"
    {
      ia_type_ast_pop();

      c_ast_t *const type_ast = ia_type_ast_peek();

      DUMP_START( "user_defined_conversion_decl_c_astp",
                  "oper_sname_c_opt OPERATOR "
                  "type_c_ast udc_decl_c_ast_opt '(' ')' "
                  "func_qualifier_list_c_stid_opt noexcept_c_stid_opt "
                  "func_equals_c_stid_opt" );
      DUMP_AST( "in_attr__type_c_ast", type_ast );
      DUMP_SNAME( "oper_sname_c_opt", (yyvsp[-8].sname) );
      DUMP_AST( "type_c_ast", (yyvsp[-6].ast) );
      DUMP_AST( "udc_decl_c_ast_opt", (yyvsp[-4].ast) );
      DUMP_TID( "func_qualifier_list_c_stid_opt", (yyvsp[-2].tid) );
      DUMP_TID( "noexcept_c_stid_opt", (yyvsp[-1].tid) );
      DUMP_TID( "func_equals_c_stid_opt", (yyvsp[0].tid) );

      c_ast_t *const udc_ast = c_ast_new_gc( K_UDEF_CONV, &(yyloc) );
      udc_ast->sname = c_sname_move( &(yyvsp[-8].sname) );
      udc_ast->type.stids = c_tid_check(
        (yyvsp[-2].tid) | (yyvsp[-1].tid) | (yyvsp[0].tid),
        C_TPID_STORE
      );
      if ( type_ast != NULL )
        c_type_or_eq( &udc_ast->type, &type_ast->type );
      udc_ast->udef_conv.to_ast = IF_ELSE( (yyvsp[-4].ast), (yyvsp[-6].ast) );

      (yyval.ast_pair) = (c_ast_pair_t){ udc_ast, udc_ast->udef_conv.to_ast };

      DUMP_AST_PAIR( "$$_astp", (yyval.ast_pair) );
      DUMP_END();
    }
#line 10226 "parser.c"
    break;

  case 479: /* user_defined_literal_decl_c_astp: oper_sname_c_opt Y_operator empty_str_lit_exp name_exp lparen_exp param_c_ast_list_exp ')' noexcept_c_stid_opt trailing_return_type_c_ast_opt  */
#line 6065 "parser.y"
    {
      c_ast_t *const type_ast = ia_type_ast_peek();

      DUMP_START( "user_defined_literal_decl_c_astp",
                  "oper_sname_c_opt OPERATOR '\"\"' "
                  "'(' param_c_ast_list_exp ')' noexcept_c_stid_opt "
                  "trailing_return_type_c_ast_opt" );
      DUMP_AST( "in_attr__type_c_ast", type_ast );
      DUMP_SNAME( "oper_sname_c_opt", (yyvsp[-8].sname) );
      DUMP_STR( "name", (yyvsp[-5].name) );
      DUMP_AST_LIST( "param_c_ast_list_exp", (yyvsp[-3].ast_list) );
      DUMP_TID( "noexcept_c_stid_opt", (yyvsp[-1].tid) );
      DUMP_AST( "trailing_return_type_c_ast_opt", (yyvsp[0].ast) );

      c_sname_set( &type_ast->sname, &(yyvsp[-8].sname) );
      c_sname_append_name( &type_ast->sname, (yyvsp[-5].name) );

      c_ast_t *const udl_ast = c_ast_new_gc( K_UDEF_LIT, &(yyloc) );
      udl_ast->type.stids = c_tid_check( (yyvsp[-1].tid), C_TPID_STORE );
      c_ast_list_set_param_of( &(yyvsp[-3].ast_list), udl_ast );
      udl_ast->udef_lit.param_ast_list = slist_move( &(yyvsp[-3].ast_list) );

      (yyval.ast_pair) = (c_ast_pair_t){
        c_ast_add_func(
          type_ast,
          udl_ast,
          IF_ELSE( (yyvsp[0].ast), type_ast )
        ),
        udl_ast->udef_lit.ret_ast
      };

      DUMP_AST_PAIR( "$$_astp", (yyval.ast_pair) );
      DUMP_END();
    }
#line 10265 "parser.c"
    break;

  case 480: /* cast_c_astp_opt: %empty  */
#line 6106 "parser.y"
                                  { (yyval.ast_pair) = (c_ast_pair_t){ NULL, NULL }; }
#line 10271 "parser.c"
    break;

  case 490: /* cast2_c_astp: param_pack_cast_c_ast  */
#line 6123 "parser.y"
                                  { (yyval.ast_pair) = (c_ast_pair_t){ (yyvsp[0].ast), NULL }; }
#line 10277 "parser.c"
    break;

  case 491: /* cast2_c_astp: sname_c_ast  */
#line 6124 "parser.y"
                                  { (yyval.ast_pair) = (c_ast_pair_t){ (yyvsp[0].ast), NULL }; }
#line 10283 "parser.c"
    break;

  case 492: /* param_pack_cast_c_ast: "..."  */
#line 6133 "parser.y"
    {
      c_ast_t *const type_ast = ia_type_ast_peek();

      DUMP_START( "param_pack_cast_c_ast", "..." );\
      DUMP_AST( "in_attr__type_c_ast", type_ast );

      c_ast_set_parameter_pack( type_ast );
      (yyval.ast) = NULL;

      DUMP_AST( "in_attr__type_c_ast", type_ast );
      DUMP_END();
    }
#line 10300 "parser.c"
    break;

  case 493: /* param_pack_cast_c_ast: "..." sname_c_ast  */
#line 6146 "parser.y"
    {
      DUMP_START( "param_pack_cast_c_ast", "... sname_c_ast" );\
      DUMP_AST( "sname_c_ast", (yyvsp[0].ast) );

      c_ast_set_parameter_pack( (yyvsp[0].ast) );
      (yyval.ast) = (yyvsp[0].ast);

      DUMP_AST( "$$_ast", (yyval.ast) );
      DUMP_END();
    }
#line 10315 "parser.c"
    break;

  case 494: /* array_cast_c_astp: cast_c_astp_opt array_size_c_ast  */
#line 6163 "parser.y"
    {
      c_ast_t *const type_ast = ia_type_ast_peek();

      DUMP_START( "array_cast_c_astp", "cast_c_astp_opt array_size_c_ast" );
      DUMP_AST( "in_attr__type_c_ast", type_ast );
      DUMP_AST_PAIR( "cast_c_astp_opt", (yyvsp[-1].ast_pair) );
      DUMP_AST( "array_size_c_ast", (yyvsp[0].ast) );

      c_ast_set_parent(
        c_ast_new_gc( K_PLACEHOLDER, &(yylsp[-1]) ), (yyvsp[0].ast)
      );

      c_ast_t *const of_ast = ia_type_spec_ast( type_ast );
      if ( (yyvsp[-1].ast_pair).target_ast != NULL ) {
        // array-of or function-like-ret type
        (yyval.ast_pair) = (c_ast_pair_t){
          (yyvsp[-1].ast_pair).ast,
          c_ast_add_array( (yyvsp[-1].ast_pair).target_ast, (yyvsp[0].ast), of_ast )
        };
      } else {
        c_ast_t *const ast = IF_ELSE( (yyvsp[-1].ast_pair).ast, of_ast );
        (yyval.ast_pair) = (c_ast_pair_t){
          c_ast_add_array( ast, (yyvsp[0].ast), of_ast ),
          .target_ast = NULL
        };
      }

      DUMP_AST_PAIR( "$$_astp", (yyval.ast_pair) );
      DUMP_END();
    }
#line 10350 "parser.c"
    break;

  case 495: /* $@31: %empty  */
#line 6200 "parser.y"
    { //
      // A block AST has to be the type inherited attribute for cast_c_astp_opt
      // so we have to create it here.
      //
      ia_type_ast_push( c_ast_new_gc( K_APPLE_BLOCK, &(yyloc) ) );
    }
#line 10361 "parser.c"
    break;

  case 496: /* block_cast_c_astp: '(' '^' $@31 type_qualifier_list_c_stid_opt cast_c_astp_opt rparen_exp param_list_c_lparen param_c_ast_list_opt param_list_rparen  */
#line 6209 "parser.y"
    {
      c_ast_t *const block_ast = ia_type_ast_pop();
      c_ast_t *const type_ast = ia_type_ast_peek();

      DUMP_START( "block_cast_c_astp",
                  "'(' '^' type_qualifier_list_c_stid_opt cast_c_astp_opt ')' "
                  "'(' param_c_ast_list_opt ')'" );
      DUMP_AST( "in_attr__type_c_ast", type_ast );
      DUMP_TID( "type_qualifier_list_c_stid_opt", (yyvsp[-5].tid) );
      DUMP_AST_PAIR( "cast_c_astp_opt", (yyvsp[-4].ast_pair) );
      DUMP_AST_LIST( "param_c_ast_list_opt", (yyvsp[-1].ast_list) );

      PARSE_ASSERT(
        c_type_add_tid( &block_ast->type, (yyvsp[-5].tid), &(yylsp[-5]) )
      );
      c_ast_list_set_param_of( &(yyvsp[-1].ast_list), block_ast );
      block_ast->block.param_ast_list = slist_move( &(yyvsp[-1].ast_list) );

      c_ast_t *const ret_ast = ia_type_spec_ast( type_ast );
      if ( (yyvsp[-4].ast_pair).target_ast != NULL ) {
        (yyval.ast_pair) = (c_ast_pair_t){
          (yyvsp[-4].ast_pair).ast,
          c_ast_add_func( (yyvsp[-4].ast_pair).target_ast, block_ast, ret_ast )
        };
      }
      else {
        (yyval.ast_pair) = (c_ast_pair_t){
          c_ast_add_func( (yyvsp[-4].ast_pair).ast, block_ast, ret_ast ),
          block_ast->block.ret_ast
        };
      }

      DUMP_AST_PAIR( "$$_astp", (yyval.ast_pair) );
      DUMP_END();
    }
#line 10401 "parser.c"
    break;

  case 497: /* func_cast_c_astp: cast2_c_astp param_list_c_lparen param_c_ast_list_opt param_list_rparen_func_qualifier_list_c_stid_opt noexcept_c_stid_opt trailing_return_type_c_ast_opt  */
#line 6255 "parser.y"
    {
      c_ast_t *const type_ast = ia_type_ast_peek();

      DUMP_START( "func_cast_c_astp",
                  "cast2_c_astp '(' param_c_ast_list_opt ')' "
                  "func_qualifier_list_c_stid_opt noexcept_c_stid_opt "
                  "trailing_return_type_c_ast_opt" );
      DUMP_AST( "in_attr__type_c_ast", type_ast );
      DUMP_AST_PAIR( "cast2_c_astp", (yyvsp[-5].ast_pair) );
      DUMP_AST_LIST( "param_c_ast_list_opt", (yyvsp[-3].ast_list) );
      DUMP_TID( "func_qualifier_list_c_stid_opt", (yyvsp[-2].tid) );
      DUMP_AST( "trailing_return_type_c_ast_opt", (yyvsp[0].ast) );
      DUMP_TID( "noexcept_c_stid_opt", (yyvsp[-1].tid) );

      c_ast_t *const func_ast = c_ast_new_gc( K_FUNCTION, &(yyloc) );
      func_ast->type.stids =
        c_tid_check( (yyvsp[-2].tid) | (yyvsp[-1].tid), C_TPID_STORE );
      c_ast_list_set_param_of( &(yyvsp[-3].ast_list), func_ast );
      func_ast->func.param_ast_list = slist_move( &(yyvsp[-3].ast_list) );

      c_ast_t *const cast_ast = (yyvsp[-5].ast_pair).ast;
      //
      // This is for a case similar to the one in func_decl_c_astp like:
      //
      //     void f( int () () )
      //              |   |  |
      //              |   |  func
      //              |   |
      //              |   cast_ast (func)
      //              |
      //              ret_ast
      //
      // We replace ret_ast with cast_ast:
      //
      //      void f( int() () )
      //              |  |  |
      //              |  |  func
      //              X  |
      //              |  cast_ast (func)
      //              |
      //              ret_ast <- cast_ast (func)
      //
      // that is, a "function returning function returning int" -- which is
      // illegal (since functions can't return functions) and will be caught by
      // c_ast_check_ret_type().
      //
      c_ast_t *const ret_ast = cast_ast->kind == K_FUNCTION ?
        cast_ast : IF_ELSE( (yyvsp[0].ast), ia_type_spec_ast( type_ast ) );

      if ( (yyvsp[-5].ast_pair).target_ast != NULL ) {
        (yyval.ast_pair) = (c_ast_pair_t){
          cast_ast,
          c_ast_add_func( (yyvsp[-5].ast_pair).target_ast, func_ast, ret_ast )
        };
      }
      else {
        (yyval.ast_pair) = (c_ast_pair_t){
          c_ast_add_func( cast_ast, func_ast, ret_ast ),
          func_ast->func.ret_ast
        };
      }

      DUMP_AST_PAIR( "$$_astp", (yyval.ast_pair) );
      DUMP_END();
    }
#line 10471 "parser.c"
    break;

  case 498: /* $@32: %empty  */
#line 6326 "parser.y"
    {
      ia_type_ast_push( c_ast_new_gc( K_PLACEHOLDER, &(yyloc) ) );
      ++in_attr.ast_depth;
    }
#line 10480 "parser.c"
    break;

  case 499: /* nested_cast_c_astp: '(' $@32 cast_c_astp_opt rparen_exp  */
#line 6331 "parser.y"
    {
      ia_type_ast_pop();
      --in_attr.ast_depth;

      c_ast_t *const type_ast = ia_type_ast_peek();

      DUMP_START( "nested_cast_c_astp", "'(' cast_c_astp_opt ')'" );
      DUMP_AST( "in_attr__type_c_ast", type_ast );
      DUMP_AST_PAIR( "cast_c_astp_opt", (yyvsp[-1].ast_pair) );

      (yyval.ast_pair) = (yyvsp[-1].ast_pair);

      if ( (yyval.ast_pair).ast == NULL ) {
        //
        // This is for a case like:
        //
        //      void f( int() )
        //                 ^^
        //
        // where the unnamed parameter is a "function returning int".  (In
        // param_c_ast, this will be converted into a "pointer to function
        // returning int".)
        //
        (yyval.ast_pair).ast = c_ast_new_gc( K_FUNCTION, &(yyloc) );
        c_ast_set_parent( type_ast, (yyval.ast_pair).ast );
      } else {
        (yyval.ast_pair).ast->loc = (yyloc);
      }

      DUMP_AST_PAIR( "$$_astp", (yyval.ast_pair) );
      DUMP_END();
    }
#line 10517 "parser.c"
    break;

  case 500: /* $@33: %empty  */
#line 6368 "parser.y"
                                 { ia_type_ast_push( (yyvsp[0].ast) ); }
#line 10523 "parser.c"
    break;

  case 501: /* pointer_cast_c_astp: pointer_type_c_ast $@33 cast_c_astp_opt  */
#line 6370 "parser.y"
    {
      ia_type_ast_pop();

      DUMP_START( "pointer_cast_c_astp", "pointer_type_c_ast cast_c_astp_opt" );
      DUMP_AST( "pointer_type_c_ast", (yyvsp[-2].ast) );
      DUMP_AST_PAIR( "cast_c_astp_opt", (yyvsp[0].ast_pair) );

      (yyval.ast_pair) = (c_ast_pair_t){
        c_ast_patch_placeholder( (yyvsp[-2].ast), (yyvsp[0].ast_pair).ast ),
        (yyvsp[0].ast_pair).target_ast
      };

      DUMP_AST_PAIR( "$$_astp", (yyval.ast_pair) );
      DUMP_END();
    }
#line 10543 "parser.c"
    break;

  case 502: /* $@34: %empty  */
#line 6390 "parser.y"
                                           { ia_type_ast_push( (yyvsp[0].ast) ); }
#line 10549 "parser.c"
    break;

  case 503: /* pointer_to_member_cast_c_astp: pointer_to_member_type_c_ast $@34 cast_c_astp_opt  */
#line 6392 "parser.y"
    {
      ia_type_ast_pop();

      DUMP_START( "pointer_to_member_cast_c_astp",
                  "pointer_to_member_type_c_ast cast_c_astp_opt" );
      DUMP_AST( "pointer_to_member_type_c_ast", (yyvsp[-2].ast) );
      DUMP_AST_PAIR( "cast_c_astp_opt", (yyvsp[0].ast_pair) );

      (yyval.ast_pair) = (c_ast_pair_t){
        c_ast_patch_placeholder( (yyvsp[-2].ast), (yyvsp[0].ast_pair).ast ),
        (yyvsp[0].ast_pair).target_ast
      };

      DUMP_AST_PAIR( "$$_astp", (yyval.ast_pair) );
      DUMP_END();
    }
#line 10570 "parser.c"
    break;

  case 504: /* $@35: %empty  */
#line 6413 "parser.y"
                                   { ia_type_ast_push( (yyvsp[0].ast) ); }
#line 10576 "parser.c"
    break;

  case 505: /* reference_cast_c_astp: reference_type_c_ast $@35 cast_c_astp_opt  */
#line 6415 "parser.y"
    {
      ia_type_ast_pop();

      DUMP_START( "reference_cast_c_astp",
                  "reference_type_c_ast cast_c_astp_opt" );
      DUMP_AST( "reference_type_c_ast", (yyvsp[-2].ast) );
      DUMP_AST_PAIR( "cast_c_astp_opt", (yyvsp[0].ast_pair) );

      (yyval.ast_pair) = (c_ast_pair_t){
        c_ast_patch_placeholder( (yyvsp[-2].ast), (yyvsp[0].ast_pair).ast ),
        (yyvsp[0].ast_pair).target_ast
      };

      DUMP_AST_PAIR( "$$_astp", (yyval.ast_pair) );
      DUMP_END();
    }
#line 10597 "parser.c"
    break;

  case 506: /* udc_decl_c_ast_opt: %empty  */
#line 6442 "parser.y"
                                  { (yyval.ast) = NULL; }
#line 10603 "parser.c"
    break;

  case 512: /* $@36: %empty  */
#line 6454 "parser.y"
                                 { ia_type_ast_push( (yyvsp[0].ast) ); }
#line 10609 "parser.c"
    break;

  case 513: /* pointer_udc_decl_c_ast: pointer_type_c_ast $@36 udc_decl_c_ast_opt  */
#line 6456 "parser.y"
    {
      ia_type_ast_pop();

      DUMP_START( "pointer_udc_decl_c_ast",
                  "pointer_type_c_ast udc_decl_c_ast_opt" );
      DUMP_AST( "pointer_type_c_ast", (yyvsp[-2].ast) );
      DUMP_AST( "udc_decl_c_ast_opt", (yyvsp[0].ast) );

      (yyval.ast) = c_ast_patch_placeholder( (yyvsp[-2].ast), (yyvsp[0].ast) );

      DUMP_AST( "$$_ast", (yyval.ast) );
      DUMP_END();
    }
#line 10627 "parser.c"
    break;

  case 514: /* $@37: %empty  */
#line 6472 "parser.y"
                                           { ia_type_ast_push( (yyvsp[0].ast) ); }
#line 10633 "parser.c"
    break;

  case 515: /* pointer_to_member_udc_decl_c_ast: pointer_to_member_type_c_ast $@37 udc_decl_c_ast_opt  */
#line 6474 "parser.y"
    {
      ia_type_ast_pop();

      DUMP_START( "pointer_to_member_udc_decl_c_ast",
                  "pointer_to_member_type_c_ast udc_decl_c_ast_opt" );
      DUMP_AST( "pointer_to_member_type_c_ast", (yyvsp[-2].ast) );
      DUMP_AST( "udc_decl_c_ast_opt", (yyvsp[0].ast) );

      (yyval.ast) = c_ast_patch_placeholder( (yyvsp[-2].ast), (yyvsp[0].ast) );

      DUMP_AST( "$$_ast", (yyval.ast) );
      DUMP_END();
    }
#line 10651 "parser.c"
    break;

  case 516: /* $@38: %empty  */
#line 6490 "parser.y"
                                   { ia_type_ast_push( (yyvsp[0].ast) ); }
#line 10657 "parser.c"
    break;

  case 517: /* reference_udc_decl_c_ast: reference_type_c_ast $@38 udc_decl_c_ast_opt  */
#line 6492 "parser.y"
    {
      ia_type_ast_pop();

      DUMP_START( "reference_udc_decl_c_ast",
                  "reference_type_c_ast udc_decl_c_ast_opt" );
      DUMP_AST( "reference_type_c_ast", (yyvsp[-2].ast) );
      DUMP_AST( "udc_decl_c_ast_opt", (yyvsp[0].ast) );

      (yyval.ast) = c_ast_patch_placeholder( (yyvsp[-2].ast), (yyvsp[0].ast) );

      DUMP_AST( "$$_ast", (yyval.ast) );
      DUMP_END();
    }
#line 10675 "parser.c"
    break;

  case 518: /* type_c_ast: type_modifier_list_c_type  */
#line 6518 "parser.y"
    {
      DUMP_START( "type_c_ast", "type_modifier_list_c_type" );
      DUMP_TYPE( "type_modifier_list_c_type", (yyvsp[0].type) );

      //
      // Prior to C99, typeless declarations are implicitly int, so we set it
      // here.  In C99 and later, however, implicit int is an error, so we
      // don't set it here and c_ast_check() will catch the error later.
      //
      // Note that type modifiers, e.g., unsigned, count as a type since that
      // means unsigned int; however, neither qualifiers, e.g., const, nor
      // storage classes, e.g., register, by themselves count as a type:
      //
      //      unsigned i;   // legal in C99
      //      const    j;   // illegal in C99
      //      register k;   // illegal in C99
      //
      c_type_t type = OPT_LANG_IS( IMPLICIT_int ) ?
        C_TYPE_LIT_B( TB_int ) : T_NONE;

      PARSE_ASSERT( c_type_add( &type, &(yyvsp[0].type), &(yylsp[0]) ) );

      if ( type.btids == TB_int ) {     // type is still the TB_int we added
        //
        // This check has to be done now in the parser rather than later in the
        // AST since the AST has no memory that the "int" is implicit.
        //
        // Alternatively, we could _not_ set TB_int here, but then we'd need a
        // new separate AST "fix-up" pass that would change TB_NONE to TB_int.
        // Objectively, that's probably the better solution, but it's a lot of
        // extra code that would currently only be needed to fix-up implicit
        // int.
        //
        print_warning( &(yylsp[0]),
          "missing type specifier; \"%s\" assumed\n",
          c_tid_error( TB_int )
        );
      }

      (yyval.ast) = c_ast_new_gc( K_BUILTIN, &(yyloc) );
      (yyval.ast)->type = type;

      DUMP_AST( "$$_ast", (yyval.ast) );
      DUMP_END();
    }
#line 10725 "parser.c"
    break;

  case 519: /* type_c_ast: type_modifier_list_c_type east_modified_type_c_ast  */
#line 6570 "parser.y"
    {
      DUMP_START( "type_c_ast",
                  "type_modifier_list_c_type east_modified_type_c_ast " );
      DUMP_TYPE( "type_modifier_list_c_type", (yyvsp[-1].type) );
      DUMP_AST( "east_modified_type_c_ast", (yyvsp[0].ast) );

      (yyval.ast) = (yyvsp[0].ast);
      (yyval.ast)->loc = (yyloc);
      PARSE_ASSERT( c_type_add( &(yyval.ast)->type, &(yyvsp[-1].type), &(yylsp[-1]) ) );

      DUMP_AST( "$$_ast", (yyval.ast) );
      DUMP_END();
    }
#line 10743 "parser.c"
    break;

  case 521: /* type_modifier_list_c_type_opt: %empty  */
#line 6588 "parser.y"
                                  { (yyval.type) = T_NONE; }
#line 10749 "parser.c"
    break;

  case 523: /* type_modifier_list_c_type: type_modifier_list_c_type type_modifier_c_type  */
#line 6594 "parser.y"
    {
      DUMP_START( "type_modifier_list_c_type",
                  "type_modifier_list_c_type type_modifier_c_type" );
      DUMP_TYPE( "type_modifier_list_c_type", (yyvsp[-1].type) );
      DUMP_TYPE( "type_modifier_c_type", (yyvsp[0].type) );

      (yyval.type) = (yyvsp[-1].type);
      PARSE_ASSERT( c_type_add( &(yyval.type), &(yyvsp[0].type), &(yylsp[0]) ) );

      DUMP_TYPE( "$$_type", (yyval.type) );
      DUMP_END();
    }
#line 10766 "parser.c"
    break;

  case 525: /* type_modifier_c_type: type_modifier_base_type  */
#line 6612 "parser.y"
    {
      (yyval.type) = (yyvsp[0].type);
      //
      // This is for a case like:
      //
      //      explain typedef unsigned long size_t
      //
      // that is: explain a redefinition of a typedef'd type with the same type
      // that contains only one or more type_modifier_base_type.  The problem
      // is that, without an east_modified_type_c_ast (like int), the parser
      // would ordinarily take the typedef'd type (here, the size_t) as part of
      // the type_c_ast and then be out of tokens for the decl_c_astp -- at
      // which time it'll complain.
      //
      // Since type modifiers can't apply to a typedef'd type (e.g., "long
      // size_t" is illegal), we tell the lexer not to return either
      // Y_TYPEDEF_NAME_TDEF or Y_TYPEDEF_SNAME_TDEF if we encounter at least
      // one type modifier (except "register" since it's is really a storage
      // class -- see the comment in type_modifier_base_type about "register").
      //
      if ( (yyval.type).stids != TS_register )
        lexer_find &= ~LEXER_FIND_TYPES;
    }
#line 10794 "parser.c"
    break;

  case 526: /* type_modifier_c_type: type_qualifier_c_stid  */
#line 6635 "parser.y"
                                  { (yyval.type) = C_TYPE_LIT_S( (yyvsp[0].tid) ); }
#line 10800 "parser.c"
    break;

  case 528: /* type_modifier_c_type: attribute_specifier_list_c_atid  */
#line 6638 "parser.y"
    {
      (yyval.type) = C_TYPE_LIT_A( (yyvsp[0].tid) );
    }
#line 10808 "parser.c"
    break;

  case 529: /* type_modifier_base_type: Y__Complex  */
#line 6644 "parser.y"
                                  { (yyval.type) = C_TYPE_LIT_B( (yyvsp[0].tid) ); }
#line 10814 "parser.c"
    break;

  case 530: /* type_modifier_base_type: Y__Imaginary  */
#line 6645 "parser.y"
                                  { (yyval.type) = C_TYPE_LIT_B( (yyvsp[0].tid) ); }
#line 10820 "parser.c"
    break;

  case 531: /* type_modifier_base_type: Y_long  */
#line 6646 "parser.y"
                                  { (yyval.type) = C_TYPE_LIT_B( (yyvsp[0].tid) ); }
#line 10826 "parser.c"
    break;

  case 532: /* type_modifier_base_type: Y_short  */
#line 6647 "parser.y"
                                  { (yyval.type) = C_TYPE_LIT_B( (yyvsp[0].tid) ); }
#line 10832 "parser.c"
    break;

  case 533: /* type_modifier_base_type: Y_signed  */
#line 6648 "parser.y"
                                  { (yyval.type) = C_TYPE_LIT_B( (yyvsp[0].tid) ); }
#line 10838 "parser.c"
    break;

  case 534: /* type_modifier_base_type: Y_unsigned  */
#line 6649 "parser.y"
                                  { (yyval.type) = C_TYPE_LIT_B( (yyvsp[0].tid) ); }
#line 10844 "parser.c"
    break;

  case 535: /* type_modifier_base_type: Y_EMC__Sat  */
#line 6650 "parser.y"
                                  { (yyval.type) = C_TYPE_LIT_B( (yyvsp[0].tid) ); }
#line 10850 "parser.c"
    break;

  case 536: /* type_modifier_base_type: Y_register  */
#line 6656 "parser.y"
                                  { (yyval.type) = C_TYPE_LIT_S( (yyvsp[0].tid) ); }
#line 10856 "parser.c"
    break;

  case 537: /* east_modified_type_c_ast: east_modifiable_type_c_ast type_modifier_list_c_type_opt  */
#line 6662 "parser.y"
    {
      DUMP_START( "east_modified_type_c_ast",
                  "east_modifiable_type_c_ast type_modifier_list_c_type_opt" );
      DUMP_AST( "east_modifiable_type_c_ast", (yyvsp[-1].ast) );
      DUMP_TYPE( "type_modifier_list_c_type_opt", (yyvsp[0].type) );

      (yyval.ast) = (yyvsp[-1].ast);
      (yyval.ast)->loc = (yyloc);
      PARSE_ASSERT( c_type_add( &(yyval.ast)->type, &(yyvsp[0].type), &(yylsp[0]) ) );

      DUMP_AST( "$$_ast", (yyval.ast) );
      DUMP_END();
    }
#line 10874 "parser.c"
    break;

  case 538: /* east_modified_type_c_ast: enum_class_struct_union_c_ast cv_qualifier_list_stid_opt  */
#line 6678 "parser.y"
    {
      DUMP_START( "east_modified_type_c_ast",
                  "enum_class_struct_union_c_ast cv_qualifier_list_stid_opt" );
      DUMP_AST( "enum_class_struct_union_c_ast", (yyvsp[-1].ast) );
      DUMP_TID( "cv_qualifier_list_stid_opt", (yyvsp[0].tid) );

      (yyval.ast) = (yyvsp[-1].ast);
      (yyval.ast)->loc = (yyloc);
      PARSE_ASSERT( c_type_add_tid( &(yyval.ast)->type, (yyvsp[0].tid), &(yylsp[0]) ) );

      DUMP_AST( "$$_ast", (yyval.ast) );
      DUMP_END();
    }
#line 10892 "parser.c"
    break;

  case 545: /* $@39: %empty  */
#line 6706 "parser.y"
    {
      ia_type_ast_push( (yyvsp[0].ast) );
    }
#line 10900 "parser.c"
    break;

  case 546: /* atomic_specifier_type_c_ast: Y__Atomic_SPEC lparen_exp type_c_ast $@39 cast_c_astp_opt rparen_exp  */
#line 6710 "parser.y"
    {
      ia_type_ast_pop();

      DUMP_START( "atomic_specifier_type_c_ast",
                  "ATOMIC '(' type_c_ast cast_c_astp_opt ')'" );
      DUMP_AST( "type_c_ast", (yyvsp[-3].ast) );
      DUMP_AST_PAIR( "cast_c_astp_opt", (yyvsp[-1].ast_pair) );

      (yyval.ast) = IF_ELSE( (yyvsp[-1].ast_pair).ast, (yyvsp[-3].ast) );
      (yyval.ast)->loc = (yyloc);

      //
      // Ensure the _Atomic() specifier type doesn't have either a storage
      // class or attributes:
      //
      //      const _Atomic(int) x;     // OK
      //      _Atomic(const int) y;     // error
      //
      // This check has to be done now in the parser rather than later in the
      // AST since the type would be stored as "atomic const int" either way so
      // the AST has no "memory" of which it was.
      //
      if ( (yyval.ast)->type.stids != TS_NONE || (yyval.ast)->type.atids != TA_NONE ) {
        static c_type_t const TSA_ANY = { TB_NONE, TS_ANY, TA_ANY };
        c_type_t const error_type = c_type_and( &(yyval.ast)->type, &TSA_ANY );
        print_error( &(yylsp[-3]),
          "\"%s\" can not be of \"%s\"\n",
          c_tid_error( TS__Atomic ),
          c_type_gibberish( &error_type )
        );
        PARSE_ABORT();
      }

      PARSE_ASSERT( c_type_add_tid( &(yyval.ast)->type, TS__Atomic, &(yylsp[-5]) ) );

      DUMP_AST( "$$_ast", (yyval.ast) );
      DUMP_END();
    }
#line 10943 "parser.c"
    break;

  case 547: /* builtin_type_c_ast: builtin_no_BitInt_c_btid  */
#line 6754 "parser.y"
    {
      DUMP_START( "builtin_type_c_ast", "builtin_no_BitInt_c_btid" );
      DUMP_TID( "builtin_no_BitInt_c_btid", (yyvsp[0].tid) );

      (yyval.ast) = c_ast_new_gc( K_BUILTIN, &(yyloc) );
      (yyval.ast)->type.btids = c_tid_check( (yyvsp[0].tid), C_TPID_BASE );

      DUMP_AST( "$$_ast", (yyval.ast) );
      DUMP_END();
    }
#line 10958 "parser.c"
    break;

  case 548: /* builtin_type_c_ast: Y__BitInt lparen_exp uint_lit_exp rparen_exp  */
#line 6765 "parser.y"
    {
      DUMP_START( "builtin_type_c_ast", "_BitInt '(' uint_lit_exp ')'" );
      DUMP_INT( "uint_lit_exp", (yyvsp[-1].uint_val) );

      (yyval.ast) = c_ast_new_gc( K_BUILTIN, &(yyloc) );
      (yyval.ast)->type.btids = TB__BitInt;
      (yyval.ast)->builtin.BitInt.width = (yyvsp[-1].uint_val);

      DUMP_AST( "$$_ast", (yyval.ast) );
      DUMP_END();
    }
#line 10974 "parser.c"
    break;

  case 557: /* builtin_no_BitInt_c_btid: Y_decltype  */
#line 6788 "parser.y"
    {
      UNSUPPORTED( &(yylsp[0]), "decltype declarations" );
    }
#line 10982 "parser.c"
    break;

  case 564: /* concept_type_c_ast: Y_CONCEPT_SNAME auto_TYPE_exp  */
#line 6803 "parser.y"
    {
      DUMP_START( "concept_type_c_ast", "Y_CONCEPT_SNAME AUTO" );
      DUMP_SNAME( "Y_CONCEPT_SNAME", (yyvsp[-1].sname) );

      c_sname_set_all_types( &(yyvsp[-1].sname) );

      (yyval.ast) = c_ast_new_gc( K_CONCEPT, &(yylsp[-1]) );
      (yyval.ast)->concept.concept_sname = c_sname_move( &(yyvsp[-1].sname) );

      DUMP_AST( "$$_ast", (yyval.ast) );
      DUMP_END();
    }
#line 10999 "parser.c"
    break;

  case 565: /* structured_binding_type_c_ast: Y_auto_STRUCTURED_BINDING cv_qualifier_list_stid_opt ref_qualifier_c_stid_opt lbracket_exp sname_list_c rbracket_exp  */
#line 6823 "parser.y"
    {
      DUMP_START( "structured_binding_type_c_ast",
                  "AUTO cv_qualifier_list_stid_opt ref_qualifier_c_stid_opt "
                  "'[' sname_list_c ']'" );
      DUMP_TID( "cv_qualifier_list_stid_opt", (yyvsp[-4].tid) );
      DUMP_TID( "ref_qualifier_c_stid_opt", (yyvsp[-3].tid) );

      (yyval.ast) = c_ast_new_gc( K_STRUCTURED_BINDING, &(yyloc) );
      (yyval.ast)->type.stids = c_tid_check( (yyvsp[-4].tid) | (yyvsp[-3].tid), C_TPID_STORE );
      (yyval.ast)->struct_bind.sname_list = slist_move( &(yyvsp[-1].sname_list) );

      DUMP_AST( "$$_ast", (yyval.ast) );
      DUMP_END();
    }
#line 11018 "parser.c"
    break;

  case 566: /* typedef_type_c_ast: any_typedef_tdef sub_scope_sname_c_opt  */
#line 6843 "parser.y"
    {
      c_ast_t *type_ast = ia_type_ast_peek();
      c_ast_t const *type_for_ast = (yyvsp[-1].tdef)->ast;

      DUMP_START( "typedef_type_c_ast",
                  "any_typedef_tdef sub_scope_sname_c_opt" );
      DUMP_AST( "in_attr__type_c_ast", type_ast );
      DUMP_AST( "any_typedef__ast", type_for_ast );
      DUMP_SNAME( "sub_scope_sname_c_opt", (yyvsp[0].sname) );

      if ( c_sname_empty( &(yyvsp[0].sname) ) ) {
ttntd:  (yyval.ast) = c_ast_new_gc( K_TYPEDEF, &(yyloc) );
        (yyval.ast)->type.btids = TB_typedef;
        (yyval.ast)->tdef.for_ast = type_for_ast;
      }
      else {
        c_sname_t temp_sname = c_sname_dup( &(yyvsp[-1].tdef)->ast->sname );
        c_sname_append_sname( &temp_sname, &(yyvsp[0].sname) );

        if ( type_ast == NULL ) {
          //
          // This is for a case like:
          //
          //      define S as struct S
          //      explain S::T x
          //
          // that is: a typedef'd type followed by ::T where T is an unknown
          // name used as a type. Just assume the T is some type, say int, and
          // create a name for it.
          //
          type_ast = c_ast_new_gc( K_BUILTIN, &(yyloc) );
          type_ast->type.btids = TB_int;
          c_sname_set( &type_ast->sname, &temp_sname );
          type_for_ast = type_ast;
          goto ttntd;
        }

        //
        // Otherwise, this is for cases like:
        //
        //  1. A typedef'd type used for a scope:
        //
        //          define S as struct S
        //          explain int S::x
        //
        //  2. A typedef'd type used for an intermediate scope:
        //
        //          define S as struct S
        //          define T as struct T
        //          explain int S::T::x
        //
        (yyval.ast) = type_ast;
        c_sname_set( &(yyval.ast)->sname, &temp_sname );
      }

      DUMP_AST( "$$_ast", (yyval.ast) );
      DUMP_END();
    }
#line 11081 "parser.c"
    break;

  case 567: /* sub_scope_sname_c_opt: %empty  */
#line 6904 "parser.y"
                                  { c_sname_init( &(yyval.sname) ); }
#line 11087 "parser.c"
    break;

  case 568: /* sub_scope_sname_c_opt: Y_COLON_COLON any_sname_c  */
#line 6906 "parser.y"
    {
      (yyval.sname) = (yyvsp[0].sname);
    }
#line 11095 "parser.c"
    break;

  case 569: /* $@40: %empty  */
#line 6915 "parser.y"
    {
      ia_type_ast_push( (yyvsp[0].ast) );
    }
#line 11103 "parser.c"
    break;

  case 570: /* typeof_type_c_ast: typeof lparen_exp type_c_ast $@40 cast_c_astp_opt rparen_exp  */
#line 6919 "parser.y"
    {
      ia_type_ast_pop();

      DUMP_START( "typeof_type_c_ast",
                  "TYPEOF '(' type_c_ast cast_c_astp_opt ')'" );
      DUMP_BOOL( "is_unqual", (yyvsp[-5].flag) );
      DUMP_AST( "type_c_ast", (yyvsp[-3].ast) );
      DUMP_AST_PAIR( "cast_c_astp_opt", (yyvsp[-1].ast_pair) );

      if ( (yyvsp[-5].flag) ) {
        c_ast_t const *const raw_ast = c_ast_untypedef( (yyvsp[-3].ast) );
        if ( raw_ast != (yyvsp[-3].ast) &&
             c_tid_is_any( raw_ast->type.stids, TS__Atomic | TS_CVR ) ) {
          //
          // The type is a typedef and the type that it's for is ACVR-qualified
          // so we need to dup _that_ type before un-ACVR-qualifying it because
          // we don't want to modify it.
          //
          c_loc_t const *const orig_loc = &(yyvsp[-3].ast)->loc;
          (yyvsp[-3].ast) = c_ast_dup_gc( raw_ast );
          (yyvsp[-3].ast)->loc = *orig_loc;
        }
        (yyvsp[-3].ast)->type.stids &= c_tid_compl( TS__Atomic | TS_CVR );
      }

      (yyval.ast) = c_ast_patch_placeholder( (yyvsp[-3].ast), (yyvsp[-1].ast_pair).ast );

      DUMP_AST( "$$_ast", (yyval.ast) );
      DUMP_END();

      //
      // Overwrite type_spec_ast to be the typeof type since _that_ is the base
      // type for one or more declarators, e.g.:
      //
      //      typeof(int*) p, a[2], f(char)
      //
      in_attr.type_spec_ast = (yyval.ast);
    }
#line 11146 "parser.c"
    break;

  case 571: /* typeof_type_c_ast: typeof lparen_exp error  */
#line 6959 "parser.y"
    {
      elaborate_error(
        "typeof(expression) declarations not supported by " CDECL
      );
    }
#line 11156 "parser.c"
    break;

  case 572: /* typeof: Y_typeof  */
#line 6967 "parser.y"
                                  { (yyval.flag) = /*is_unqual=*/false; }
#line 11162 "parser.c"
    break;

  case 573: /* typeof: Y_typeof_unqual  */
#line 6968 "parser.y"
                                  { (yyval.flag) = /*is_unqual=*/true;  }
#line 11168 "parser.c"
    break;

  case 576: /* class_struct_union_c_ast: class_struct_union_btid attribute_specifier_list_c_atid_opt any_sname_c_exp  */
#line 6981 "parser.y"
    {
      DUMP_START( "enum_class_struct_union_c_ast",
                  "class_struct_union_btid "
                  "attribute_specifier_list_c_atid_opt any_sname_c_exp" );
      DUMP_TID( "class_struct_union_btid", (yyvsp[-2].tid) );
      DUMP_TID( "attribute_specifier_list_c_atid_opt", (yyvsp[-1].tid) );
      DUMP_SNAME( "any_sname_c_exp", (yyvsp[0].sname) );

      (yyval.ast) = c_ast_new_gc( K_CLASS_STRUCT_UNION, &(yyloc) );
      (yyval.ast)->type.btids = c_tid_check( (yyvsp[-2].tid), C_TPID_BASE );
      (yyval.ast)->type.atids = c_tid_check( (yyvsp[-1].tid), C_TPID_ATTR );
      (yyval.ast)->csu.csu_sname = c_sname_move( &(yyvsp[0].sname) );

      DUMP_AST( "$$_ast", (yyval.ast) );
      DUMP_END();
    }
#line 11189 "parser.c"
    break;

  case 577: /* class_struct_union_c_ast: class_struct_union_btid attribute_specifier_list_c_atid_opt any_sname_c_opt '{'  */
#line 7000 "parser.y"
    {
      c_sname_cleanup( &(yyvsp[-1].sname) );
      UNSUPPORTED( &(yylsp[0]),
        "explaining %s declarations", c_tid_gibberish( (yyvsp[-3].tid) )
      );
    }
#line 11200 "parser.c"
    break;

  case 578: /* enum_c_ast: enum_btids attribute_specifier_list_c_atid_opt any_sname_c_exp enum_fixed_type_c_ast_opt  */
#line 7011 "parser.y"
    {
      DUMP_START( "enum_c_ast",
                  "enum_btids attribute_specifier_list_c_atid_opt "
                  "any_sname_c_exp enum_fixed_type_c_ast_opt" );
      DUMP_TID( "enum_btids", (yyvsp[-3].tid) );
      DUMP_TID( "attribute_specifier_list_c_atid_opt", (yyvsp[-2].tid) );
      DUMP_SNAME( "any_sname_c_exp", (yyvsp[-1].sname) );
      DUMP_AST( "enum_fixed_type_c_ast_opt", (yyvsp[0].ast) );

      (yyval.ast) = c_ast_new_gc( K_ENUM, &(yyloc) );
      (yyval.ast)->type.btids = c_tid_check( (yyvsp[-3].tid), C_TPID_BASE );
      (yyval.ast)->type.atids = c_tid_check( (yyvsp[-2].tid), C_TPID_ATTR );
      c_ast_set_parent( (yyvsp[0].ast), (yyval.ast) );
      (yyval.ast)->enum_.enum_sname = c_sname_move( &(yyvsp[-1].sname) );

      DUMP_AST( "$$_ast", (yyval.ast) );
      DUMP_END();
    }
#line 11223 "parser.c"
    break;

  case 579: /* enum_c_ast: enum_btids attribute_specifier_list_c_atid_opt any_sname_c_opt '{'  */
#line 7032 "parser.y"
    {
      c_sname_cleanup( &(yyvsp[-1].sname) );
      UNSUPPORTED( &(yylsp[0]),
        "explaining %s declarations", c_tid_gibberish( (yyvsp[-3].tid) )
      );
    }
#line 11234 "parser.c"
    break;

  case 580: /* enum_btids: Y_enum class_struct_btid_opt  */
#line 7043 "parser.y"
                                  { (yyval.tid) = (yyvsp[-1].tid) | (yyvsp[0].tid); }
#line 11240 "parser.c"
    break;

  case 581: /* enum_fixed_type_c_ast_opt: %empty  */
#line 7047 "parser.y"
                                  { (yyval.ast) = NULL; }
#line 11246 "parser.c"
    break;

  case 582: /* enum_fixed_type_c_ast_opt: ':' enum_fixed_type_c_ast  */
#line 7048 "parser.y"
                                  { (yyval.ast) = (yyvsp[0].ast); }
#line 11252 "parser.c"
    break;

  case 583: /* enum_fixed_type_c_ast_opt: ':' error  */
#line 7050 "parser.y"
    {
      elaborate_error( "type name expected" );
    }
#line 11260 "parser.c"
    break;

  case 584: /* enum_fixed_type_c_ast: enum_fixed_type_modifier_list_btid  */
#line 7066 "parser.y"
    {
      DUMP_START( "enum_fixed_type_c_ast",
                  "enum_fixed_type_modifier_list_btid" );
      DUMP_TID( "enum_fixed_type_modifier_list_btid", (yyvsp[0].tid) );

      (yyval.ast) = c_ast_new_gc( K_BUILTIN, &(yyloc) );
      (yyval.ast)->type.btids = c_tid_check( (yyvsp[0].tid), C_TPID_BASE );

      DUMP_AST( "$$_ast", (yyval.ast) );
      DUMP_END();
    }
#line 11276 "parser.c"
    break;

  case 585: /* enum_fixed_type_c_ast: enum_fixed_type_modifier_list_btid enum_unmodified_fixed_type_c_ast enum_fixed_type_modifier_list_btid_opt  */
#line 7086 "parser.y"
    {
      DUMP_START( "enum_fixed_type_c_ast",
                  "enum_fixed_type_modifier_list_btid "
                  "enum_unmodified_fixed_type_c_ast "
                  "enum_fixed_type_modifier_list_btid_opt" );
      DUMP_TID( "enum_fixed_type_modifier_list_btid", (yyvsp[-2].tid) );
      DUMP_AST( "enum_unmodified_fixed_type_c_ast", (yyvsp[-1].ast) );
      DUMP_TID( "enum_fixed_type_modifier_list_btid_opt", (yyvsp[0].tid) );

      (yyval.ast) = (yyvsp[-1].ast);
      (yyval.ast)->loc = (yyloc);
      PARSE_ASSERT( c_type_add_tid( &(yyval.ast)->type, (yyvsp[-2].tid), &(yylsp[-2]) ) );
      PARSE_ASSERT( c_type_add_tid( &(yyval.ast)->type, (yyvsp[0].tid), &(yylsp[0]) ) );

      DUMP_AST( "$$_ast", (yyval.ast) );
      DUMP_END();
    }
#line 11298 "parser.c"
    break;

  case 586: /* enum_fixed_type_c_ast: enum_unmodified_fixed_type_c_ast enum_fixed_type_modifier_list_btid_opt  */
#line 7111 "parser.y"
    {
      DUMP_START( "enum_fixed_type_c_ast",
                  "enum_unmodified_fixed_type_c_ast "
                  "enum_fixed_type_modifier_list_btid_opt" );
      DUMP_AST( "enum_unmodified_fixed_type_c_ast", (yyvsp[-1].ast) );
      DUMP_TID( "enum_fixed_type_modifier_list_btid_opt", (yyvsp[0].tid) );

      (yyval.ast) = (yyvsp[-1].ast);
      (yyval.ast)->loc = (yyloc);
      PARSE_ASSERT( c_type_add_tid( &(yyval.ast)->type, (yyvsp[0].tid), &(yylsp[0]) ) );

      DUMP_AST( "$$_ast", (yyval.ast) );
      DUMP_END();
    }
#line 11317 "parser.c"
    break;

  case 587: /* enum_fixed_type_modifier_list_btid_opt: %empty  */
#line 7128 "parser.y"
                                  { (yyval.tid) = TB_NONE; }
#line 11323 "parser.c"
    break;

  case 589: /* enum_fixed_type_modifier_list_btid: enum_fixed_type_modifier_list_btid enum_fixed_type_modifier_btid  */
#line 7135 "parser.y"
    {
      DUMP_START( "enum_fixed_type_modifier_list_btid",
                  "enum_fixed_type_modifier_list_btid "
                  "enum_fixed_type_modifier_btid" );
      DUMP_TID( "enum_fixed_type_modifier_list_btid", (yyvsp[-1].tid) );
      DUMP_TID( "enum_fixed_type_modifier_btid", (yyvsp[0].tid) );

      (yyval.tid) = (yyvsp[-1].tid);
      PARSE_ASSERT( c_tid_add( &(yyval.tid), (yyvsp[0].tid), &(yylsp[0]) ) );

      DUMP_TID( "$$_btids", (yyval.tid) );
      DUMP_END();
    }
#line 11341 "parser.c"
    break;

  case 598: /* class_struct_btid_opt: %empty  */
#line 7168 "parser.y"
                                  { (yyval.tid) = TB_NONE; }
#line 11347 "parser.c"
    break;

  case 604: /* type_qualifier_list_c_stid_opt: %empty  */
#line 7185 "parser.y"
                                  { (yyval.tid) = TS_NONE; }
#line 11353 "parser.c"
    break;

  case 606: /* type_qualifier_list_c_stid: type_qualifier_list_c_stid type_qualifier_c_stid gnu_or_msc_attribute_specifier_list_c_opt  */
#line 7192 "parser.y"
    {
      DUMP_START( "type_qualifier_list_c_stid",
                  "type_qualifier_list_c_stid type_qualifier_c_stid" );
      DUMP_TID( "type_qualifier_list_c_stid", (yyvsp[-2].tid) );
      DUMP_TID( "type_qualifier_c_stid", (yyvsp[-1].tid) );

      (yyval.tid) = (yyvsp[-2].tid);
      PARSE_ASSERT( c_tid_add( &(yyval.tid), (yyvsp[-1].tid), &(yylsp[-1]) ) );

      DUMP_TID( "$$_stids", (yyval.tid) );
      DUMP_END();
    }
#line 11370 "parser.c"
    break;

  case 607: /* type_qualifier_list_c_stid: gnu_or_msc_attribute_specifier_list_c type_qualifier_c_stid  */
#line 7206 "parser.y"
    {
      (yyval.tid) = (yyvsp[0].tid);
    }
#line 11378 "parser.c"
    break;

  case 608: /* type_qualifier_list_c_stid: type_qualifier_c_stid gnu_or_msc_attribute_specifier_list_c_opt  */
#line 7211 "parser.y"
    {
      (yyval.tid) = (yyvsp[-1].tid);
    }
#line 11386 "parser.c"
    break;

  case 618: /* cv_qualifier_list_stid_opt: %empty  */
#line 7232 "parser.y"
                                  { (yyval.tid) = TS_NONE; }
#line 11392 "parser.c"
    break;

  case 619: /* cv_qualifier_list_stid_opt: cv_qualifier_list_stid_opt cv_qualifier_stid  */
#line 7234 "parser.y"
    {
      DUMP_START( "cv_qualifier_list_stid_opt",
                  "cv_qualifier_list_stid_opt cv_qualifier_stid" );
      DUMP_TID( "cv_qualifier_list_stid_opt", (yyvsp[-1].tid) );
      DUMP_TID( "cv_qualifier_stid", (yyvsp[0].tid) );

      (yyval.tid) = (yyvsp[-1].tid);
      PARSE_ASSERT( c_tid_add( &(yyval.tid), (yyvsp[0].tid), &(yylsp[0]) ) );

      DUMP_TID( "$$_stids", (yyval.tid) );
      DUMP_END();
    }
#line 11409 "parser.c"
    break;

  case 620: /* restrict_qualifier_c_stid: Y_restrict  */
#line 7250 "parser.y"
    { //
      // This check has to be done now in the parser rather than later in the
      // AST since both "restrict" and "__restrict" map to TS_restrict and the
      // AST has no "memory" of which it was.
      //
      if ( OPT_LANG_IS( CPP_ANY ) ) {
        print_error( &(yylsp[0]),
          "\"restrict\" not supported in C++; use \"%s\" instead\n",
          L_GNU___restrict
        );
        PARSE_ABORT();
      }
    }
#line 11427 "parser.c"
    break;

  case 625: /* upc_layout_qualifier_c: '[' error ']'  */
#line 7271 "parser.y"
    {
      elaborate_error( "one of nothing, integer, or '*' expected" );
    }
#line 11435 "parser.c"
    break;

  case 626: /* storage_class_c_type: Y_auto_STORAGE  */
#line 7279 "parser.y"
                                  { (yyval.type) = C_TYPE_LIT_S( (yyvsp[0].tid) ); }
#line 11441 "parser.c"
    break;

  case 627: /* storage_class_c_type: Y_Apple___block  */
#line 7280 "parser.y"
                                  { (yyval.type) = C_TYPE_LIT_S( (yyvsp[0].tid) ); }
#line 11447 "parser.c"
    break;

  case 628: /* storage_class_c_type: Y_consteval  */
#line 7281 "parser.y"
                                  { (yyval.type) = C_TYPE_LIT_S( (yyvsp[0].tid) ); }
#line 11453 "parser.c"
    break;

  case 629: /* storage_class_c_type: Y_constexpr  */
#line 7282 "parser.y"
                                  { (yyval.type) = C_TYPE_LIT_S( (yyvsp[0].tid) ); }
#line 11459 "parser.c"
    break;

  case 630: /* storage_class_c_type: Y_constinit  */
#line 7283 "parser.y"
                                  { (yyval.type) = C_TYPE_LIT_S( (yyvsp[0].tid) ); }
#line 11465 "parser.c"
    break;

  case 631: /* storage_class_c_type: Y_explicit  */
#line 7284 "parser.y"
                                  { (yyval.type) = C_TYPE_LIT_S( (yyvsp[0].tid) ); }
#line 11471 "parser.c"
    break;

  case 632: /* storage_class_c_type: Y_export  */
#line 7285 "parser.y"
                                  { (yyval.type) = C_TYPE_LIT_S( (yyvsp[0].tid) ); }
#line 11477 "parser.c"
    break;

  case 633: /* storage_class_c_type: Y_extern  */
#line 7286 "parser.y"
                                  { (yyval.type) = C_TYPE_LIT_S( (yyvsp[0].tid) ); }
#line 11483 "parser.c"
    break;

  case 634: /* storage_class_c_type: extern_linkage_c_stid  */
#line 7287 "parser.y"
                                  { (yyval.type) = C_TYPE_LIT_S( (yyvsp[0].tid) ); }
#line 11489 "parser.c"
    break;

  case 635: /* storage_class_c_type: Y_final  */
#line 7288 "parser.y"
                                  { (yyval.type) = C_TYPE_LIT_S( (yyvsp[0].tid) ); }
#line 11495 "parser.c"
    break;

  case 636: /* storage_class_c_type: Y_friend  */
#line 7289 "parser.y"
                                  { (yyval.type) = C_TYPE_LIT_S( (yyvsp[0].tid) ); }
#line 11501 "parser.c"
    break;

  case 637: /* storage_class_c_type: Y_inline  */
#line 7290 "parser.y"
                                  { (yyval.type) = C_TYPE_LIT_S( (yyvsp[0].tid) ); }
#line 11507 "parser.c"
    break;

  case 638: /* storage_class_c_type: Y_mutable  */
#line 7291 "parser.y"
                                  { (yyval.type) = C_TYPE_LIT_S( (yyvsp[0].tid) ); }
#line 11513 "parser.c"
    break;

  case 639: /* storage_class_c_type: _Noreturn_atid  */
#line 7293 "parser.y"
    {
      //
      // These checks have to be done now in the parser rather than later in
      // the AST because the _Noreturn keyword is mapped to the [[noreturn]]
      // attribute and the AST has no "memory" that it was _Noreturn.
      //
      if ( !OPT_LANG_IS( _Noreturn ) ) {
        print_error( &(yylsp[0]),
          "\"%s\" keyword not supported%s",
          yytext, C_LANG_WHICH( _Noreturn )
        );
        print_hint(
          "%snoreturn%s", other_token_c( "[[" ), other_token_c( "]]" )
        );
        PARSE_ABORT();
      }
      if ( !OPT_LANG_IS( _Noreturn_NOT_DEPRECATED ) ) {
        print_warning( &(yylsp[0]),
          "\"%s\" is deprecated%s",
          yytext, C_LANG_WHICH( _Noreturn_NOT_DEPRECATED )
        );
        print_hint(
          "%snoreturn%s", other_token_c( "[[" ), other_token_c( "]]" )
        );
      }

      (yyval.type) = C_TYPE_LIT_A( (yyvsp[0].tid) );
    }
#line 11546 "parser.c"
    break;

  case 640: /* storage_class_c_type: Y_override  */
#line 7321 "parser.y"
                                  { (yyval.type) = C_TYPE_LIT_S( (yyvsp[0].tid) ); }
#line 11552 "parser.c"
    break;

  case 641: /* storage_class_c_type: Y_static  */
#line 7323 "parser.y"
                                  { (yyval.type) = C_TYPE_LIT_S( (yyvsp[0].tid) ); }
#line 11558 "parser.c"
    break;

  case 642: /* storage_class_c_type: Y_typedef  */
#line 7324 "parser.y"
                                  { (yyval.type) = C_TYPE_LIT_S( (yyvsp[0].tid) ); }
#line 11564 "parser.c"
    break;

  case 643: /* storage_class_c_type: Y__Thread_local  */
#line 7325 "parser.y"
                                  { (yyval.type) = C_TYPE_LIT_S( (yyvsp[0].tid) ); }
#line 11570 "parser.c"
    break;

  case 644: /* storage_class_c_type: Y_thread_local  */
#line 7326 "parser.y"
                                  { (yyval.type) = C_TYPE_LIT_S( (yyvsp[0].tid) ); }
#line 11576 "parser.c"
    break;

  case 645: /* storage_class_c_type: Y_virtual  */
#line 7327 "parser.y"
                                  { (yyval.type) = C_TYPE_LIT_S( (yyvsp[0].tid) ); }
#line 11582 "parser.c"
    break;

  case 648: /* attribute_specifier_list_c_atid_opt: %empty  */
#line 7338 "parser.y"
                                  { (yyval.tid) = TA_NONE; }
#line 11588 "parser.c"
    break;

  case 650: /* $@41: %empty  */
#line 7344 "parser.y"
    {
      if ( !OPT_LANG_IS( ATTRIBUTES ) ) {
        print_error( &(yylsp[-1]),
          "\"%s\" attribute syntax not supported%s\n",
          other_token_c( "[[" ),
          C_LANG_WHICH( ATTRIBUTES )
        );
        PARSE_ABORT();
      }
      lexer_keyword_ctx = C_KW_CTX_ATTRIBUTE;
    }
#line 11604 "parser.c"
    break;

  case 651: /* attribute_specifier_list_c_atid: Y_ATTR_BEGIN '[' $@41 using_opt attribute_list_c_atid_opt ']' rbracket_exp  */
#line 7356 "parser.y"
    {
      lexer_keyword_ctx = C_KW_CTX_DEFAULT;

      DUMP_START( "attribute_specifier_list_c_atid",
                  "'[[' using_opt attribute_list_c_atid_opt ']]'" );
      DUMP_TID( "attribute_list_c_atid_opt", (yyvsp[-2].tid) );

      (yyval.tid) = (yyvsp[-2].tid);

      DUMP_END();
    }
#line 11620 "parser.c"
    break;

  case 652: /* attribute_specifier_list_c_atid: gnu_or_msc_attribute_specifier_list_c  */
#line 7369 "parser.y"
    {
      (yyval.tid) = TA_NONE;
    }
#line 11628 "parser.c"
    break;

  case 654: /* using_opt: Y_using name_exp colon_exp  */
#line 7377 "parser.y"
    {
      IGNORING( &(yylsp[-2]), "\"using\" in attributes" );
      free( (yyvsp[-1].name) );
    }
#line 11637 "parser.c"
    break;

  case 655: /* attribute_list_c_atid_opt: %empty  */
#line 7384 "parser.y"
                                  { (yyval.tid) = TA_NONE; }
#line 11643 "parser.c"
    break;

  case 657: /* attribute_list_c_atid: attribute_list_c_atid comma_exp attribute_c_atid_exp  */
#line 7390 "parser.y"
    {
      DUMP_START( "attribute_list_c_atid",
                  "attribute_list_c_atid ',' attribute_c_atid" );
      DUMP_TID( "attribute_list_c_atid", (yyvsp[-2].tid) );
      DUMP_TID( "attribute_c_atid_exp", (yyvsp[0].tid) );

      (yyval.tid) = (yyvsp[-2].tid);
      PARSE_ASSERT( c_tid_add( &(yyval.tid), (yyvsp[0].tid), &(yylsp[0]) ) );

      DUMP_TID( "$$_atids", (yyval.tid) );
      DUMP_END();
    }
#line 11660 "parser.c"
    break;

  case 667: /* attribute_c_atid_exp: sname_c  */
#line 7416 "parser.y"
    {
      if ( c_sname_count( &(yyvsp[0].sname) ) > 1 ) {
        IGNORING( &(yylsp[0]),
          "\"%s\": namespaced attributes", c_sname_gibberish( &(yyvsp[0].sname) )
        );
      }
      else {
        char const *adj = "unknown";
        c_lang_id_t lang_ids = LANG_NONE;

        char const *const name = c_sname_local_name( &(yyvsp[0].sname) );
        c_keyword_t const *const ck = c_keyword_find(
          name, c_lang_newer( opt_lang_id ), C_KW_CTX_ATTRIBUTE
        );
        if ( ck != NULL && c_tid_tpid( ck->tid ) == C_TPID_ATTR ) {
          adj = "unsupported";
          lang_ids = ck->lang_ids;
        }
        print_warning( &(yylsp[0]),
          "\"%s\": %s attribute%s",
          name, adj, c_lang_which( lang_ids )
        );

        print_suggestions( DYM_C_ATTRIBUTES, name );
        EPUTC( '\n' );
      }

      (yyval.tid) = TA_NONE;
      c_sname_cleanup( &(yyvsp[0].sname) );
    }
#line 11695 "parser.c"
    break;

  case 668: /* attribute_c_atid_exp: error  */
#line 7447 "parser.y"
    {
      elaborate_error_dym( DYM_C_ATTRIBUTES, "attribute name expected" );
    }
#line 11703 "parser.c"
    break;

  case 670: /* attribute_str_arg_c_opt: '(' str_lit_exp rparen_exp  */
#line 7455 "parser.y"
    {
      IGNORING( &(yylsp[-2]), "attribute arguments" );
      free( (yyvsp[-1].str_val) );
    }
#line 11712 "parser.c"
    break;

  case 679: /* $@42: %empty  */
#line 7483 "parser.y"
    {
      attr_syntax_not_supported( L_GNU___attribute__, &(yylsp[0]) );
      //
      // Temporariy disabling finding keywords allows GNU attributes that are C
      // keywords (e.g., const) to be found as ordinary string literals.
      //
      lexer_find &= ~LEXER_FIND_C_KEYWORDS;
    }
#line 11725 "parser.c"
    break;

  case 680: /* gnu_attribute_specifier_c: Y_GNU___attribute__ $@42 lparen_exp lparen_exp gnu_attribute_list_c_opt ')' rparen_exp  */
#line 7492 "parser.y"
    {
      lexer_find |= LEXER_FIND_C_KEYWORDS;
    }
#line 11733 "parser.c"
    break;

  case 685: /* gnu_attribute_c_exp: Y_NAME gnu_attribute_decl_arg_list_c_opt  */
#line 7509 "parser.y"
    {
      free( (yyvsp[-1].name) );
    }
#line 11741 "parser.c"
    break;

  case 686: /* gnu_attribute_c_exp: error  */
#line 7513 "parser.y"
    {
      elaborate_error( "attribute name expected" );
    }
#line 11749 "parser.c"
    break;

  case 693: /* gnu_attribute_arg_c: Y_NAME  */
#line 7534 "parser.y"
                                  { free( (yyvsp[0].name) ); }
#line 11755 "parser.c"
    break;

  case 694: /* gnu_attribute_arg_c: Y_CHAR_LIT  */
#line 7535 "parser.y"
                                  { free( (yyvsp[0].str_val) ); }
#line 11761 "parser.c"
    break;

  case 696: /* gnu_attribute_arg_c: Y_STR_LIT  */
#line 7537 "parser.y"
                                  { free( (yyvsp[0].str_val) ); }
#line 11767 "parser.c"
    break;

  case 698: /* gnu_attribute_arg_c: Y_LEXER_ERROR  */
#line 7540 "parser.y"
    {
      PARSE_ABORT();
    }
#line 11775 "parser.c"
    break;

  case 701: /* $@43: %empty  */
#line 7552 "parser.y"
    {
      attr_syntax_not_supported( L_MSC___declspec, &(yylsp[0]) );
      // See comment in gnu_attribute_specifier_c.
      lexer_find &= ~LEXER_FIND_C_KEYWORDS;
    }
#line 11785 "parser.c"
    break;

  case 702: /* msc_attribute_specifier_c: Y_MSC___declspec $@43 lparen_exp msc_attribute_list_c_opt ')'  */
#line 7558 "parser.y"
    {
      lexer_find |= LEXER_FIND_C_KEYWORDS;
    }
#line 11793 "parser.c"
    break;

  case 710: /* array_decl_english_ast: Y_array array_size_decl_ast of_exp decl_english_ast  */
#line 7594 "parser.y"
    {
      DUMP_START( "array_decl_english_ast",
                  "ARRAY array_size_num_opt OF decl_english_ast" );
      DUMP_AST( "array_size_decl_ast", (yyvsp[-2].ast) );
      DUMP_AST( "decl_english_ast", (yyvsp[0].ast) );

      (yyval.ast) = (yyvsp[-2].ast);
      (yyval.ast)->loc = (yylsp[-3]);
      c_ast_set_parent( (yyvsp[0].ast), (yyval.ast) );

      DUMP_AST( "$$_ast", (yyval.ast) );
      DUMP_END();
    }
#line 11811 "parser.c"
    break;

  case 711: /* array_decl_english_ast: Y_variable length_opt array_exp name_opt of_exp decl_english_ast  */
#line 7610 "parser.y"
    {
      DUMP_START( "array_decl_english_ast",
                  "VARIABLE LENGTH ARRAY name_opt OF decl_english_ast" );
      DUMP_STR( "name_opt", (yyvsp[-2].name) );
      DUMP_AST( "decl_english_ast", (yyvsp[0].ast) );

      (yyval.ast) = c_ast_new_gc( K_ARRAY, &(yyloc) );
      if ( (yyvsp[-2].name) == NULL ) {
        (yyval.ast)->array.kind = C_ARRAY_SIZE_VLA;
      } else {
        (yyval.ast)->array.kind = C_ARRAY_SIZE_NAME;
        (yyval.ast)->array.size_name = (yyvsp[-2].name);
      }
      c_ast_set_parent( (yyvsp[0].ast), (yyval.ast) );

      DUMP_AST( "$$_ast", (yyval.ast) );
      DUMP_END();
    }
#line 11834 "parser.c"
    break;

  case 712: /* array_size_decl_ast: %empty  */
#line 7632 "parser.y"
    {
      (yyval.ast) = c_ast_new_gc( K_ARRAY, &(yyloc) );
      (yyval.ast)->array.kind = C_ARRAY_SIZE_NONE;
    }
#line 11843 "parser.c"
    break;

  case 713: /* array_size_decl_ast: uint_lit  */
#line 7637 "parser.y"
    {
      (yyval.ast) = c_ast_new_gc( K_ARRAY, &(yyloc) );
      (yyval.ast)->array.kind = C_ARRAY_SIZE_INT;
      (yyval.ast)->array.size_int = (yyvsp[0].uint_val);
    }
#line 11853 "parser.c"
    break;

  case 714: /* array_size_decl_ast: Y_NAME  */
#line 7643 "parser.y"
    {
      (yyval.ast) = c_ast_new_gc( K_ARRAY, &(yyloc) );
      (yyval.ast)->array.kind = C_ARRAY_SIZE_NAME;
      (yyval.ast)->array.size_name = (yyvsp[0].name);
    }
#line 11863 "parser.c"
    break;

  case 715: /* array_size_decl_ast: '*'  */
#line 7649 "parser.y"
    {
      (yyval.ast) = c_ast_new_gc( K_ARRAY, &(yyloc) );
      (yyval.ast)->array.kind = C_ARRAY_SIZE_VLA;
    }
#line 11872 "parser.c"
    break;

  case 718: /* block_decl_english_ast: Y_Apple_block paren_param_decl_list_english_opt returning_english_ast_opt  */
#line 7666 "parser.y"
    {
      DUMP_START( "block_decl_english_ast",
                  "BLOCK paren_param_decl_list_english_opt "
                  "returning_english_ast_opt" );
      DUMP_AST_LIST( "paren_param_decl_list_english_opt", (yyvsp[-1].ast_list) );
      DUMP_AST( "returning_english_ast_opt", (yyvsp[0].ast) );

      (yyval.ast) = c_ast_new_gc( K_APPLE_BLOCK, &(yyloc) );
      c_ast_list_set_param_of( &(yyvsp[-1].ast_list), (yyval.ast) );
      (yyval.ast)->block.param_ast_list = slist_move( &(yyvsp[-1].ast_list) );
      c_ast_set_parent( (yyvsp[0].ast), (yyval.ast) );

      DUMP_AST( "$$_ast", (yyval.ast) );
      DUMP_END();
    }
#line 11892 "parser.c"
    break;

  case 719: /* constructor_decl_english_ast: Y_constructor paren_param_decl_list_english_opt  */
#line 7687 "parser.y"
    {
      DUMP_START( "constructor_decl_english_ast",
                  "CONSTRUCTOR paren_param_decl_list_english_opt" );
      DUMP_AST_LIST( "paren_param_decl_list_english_opt", (yyvsp[0].ast_list) );

      (yyval.ast) = c_ast_new_gc( K_CONSTRUCTOR, &(yyloc) );
      c_ast_list_set_param_of( &(yyvsp[0].ast_list), (yyval.ast) );
      (yyval.ast)->ctor.param_ast_list = slist_move( &(yyvsp[0].ast_list) );

      DUMP_AST( "$$_ast", (yyval.ast) );
      DUMP_END();
    }
#line 11909 "parser.c"
    break;

  case 720: /* destructor_decl_english_ast: Y_destructor destructor_parens_opt  */
#line 7705 "parser.y"
    {
      DUMP_START( "destructor_decl_english_ast", "DESTRUCTOR ['(' ')']" );

      (yyval.ast) = c_ast_new_gc( K_DESTRUCTOR, &(yyloc) );

      DUMP_AST( "$$_ast", (yyval.ast) );
      DUMP_END();
    }
#line 11922 "parser.c"
    break;

  case 723: /* func_decl_english_ast: func_qualifier_english_type_opt member_or_non_member_opt Y_function paren_param_decl_list_english_opt returning_english_ast_opt  */
#line 7727 "parser.y"
    {
      DUMP_START( "func_decl_english_ast",
                  "ref_qualifier_english_stid_opt "
                  "member_or_non_member_opt "
                  "FUNCTION paren_param_decl_list_english_opt "
                  "returning_english_ast_opt" );
      DUMP_TYPE( "func_qualifier_english_type_opt", (yyvsp[-4].type) );
      DUMP_INT( "member_or_non_member_opt", (yyvsp[-3].member) );
      DUMP_AST_LIST( "paren_param_decl_list_english_opt", (yyvsp[-1].ast_list) );
      DUMP_AST( "returning_english_ast_opt", (yyvsp[0].ast) );

      (yyval.ast) = c_ast_new_gc( K_FUNCTION, &(yyloc) );
      (yyval.ast)->type = (yyvsp[-4].type);
      c_ast_list_set_param_of( &(yyvsp[-1].ast_list), (yyval.ast) );
      (yyval.ast)->func.param_ast_list = slist_move( &(yyvsp[-1].ast_list) );
      (yyval.ast)->func.member = (yyvsp[-3].member);
      c_ast_set_parent( (yyvsp[0].ast), (yyval.ast) );

      DUMP_AST( "$$_ast", (yyval.ast) );
      DUMP_END();
    }
#line 11948 "parser.c"
    break;

  case 724: /* func_qualifier_english_type_opt: ref_qualifier_english_stid_opt  */
#line 7752 "parser.y"
    {
      (yyval.type) = C_TYPE_LIT_S( (yyvsp[0].tid) );
    }
#line 11956 "parser.c"
    break;

  case 725: /* func_qualifier_english_type_opt: msc_calling_convention_atid  */
#line 7756 "parser.y"
    {
      (yyval.type) = C_TYPE_LIT_A( (yyvsp[0].tid) );
    }
#line 11964 "parser.c"
    break;

  case 732: /* paren_param_decl_list_english_opt: %empty  */
#line 7773 "parser.y"
                                  { slist_init( &(yyval.ast_list) ); }
#line 11970 "parser.c"
    break;

  case 734: /* paren_param_decl_list_english: '(' param_decl_list_english_opt ')'  */
#line 7779 "parser.y"
    {
      DUMP_START( "paren_param_decl_list_english",
                  "'(' param_decl_list_english_opt ')'" );
      DUMP_AST_LIST( "param_decl_list_english_opt", (yyvsp[-1].ast_list) );

      (yyval.ast_list) = (yyvsp[-1].ast_list);

      DUMP_AST_LIST( "$$_ast_list", (yyval.ast_list) );
      DUMP_END();
    }
#line 11985 "parser.c"
    break;

  case 735: /* param_decl_list_english_opt: %empty  */
#line 7792 "parser.y"
                                  { slist_init( &(yyval.ast_list) ); }
#line 11991 "parser.c"
    break;

  case 737: /* param_decl_list_english: param_decl_list_english comma_exp decl_english_ast_exp  */
#line 7799 "parser.y"
    {
      DUMP_START( "param_decl_list_english",
                  "param_decl_list_english ',' decl_english_ast" );
      DUMP_AST_LIST( "param_decl_list_english", (yyvsp[-2].ast_list) );
      DUMP_AST( "decl_english_ast", (yyvsp[0].ast) );

      (yyval.ast_list) = (yyvsp[-2].ast_list);
      slist_push_back( &(yyval.ast_list), (yyvsp[0].ast) );

      DUMP_AST_LIST( "$$_ast_list", (yyval.ast_list) );
      DUMP_END();
    }
#line 12008 "parser.c"
    break;

  case 738: /* param_decl_list_english: decl_english_ast  */
#line 7813 "parser.y"
    {
      DUMP_START( "param_decl_list_english", "decl_english_ast" );
      DUMP_AST( "decl_english_ast", (yyvsp[0].ast) );

      if ( (yyvsp[0].ast)->kind == K_FUNCTION ) // see the comment in param_c_ast
        (yyvsp[0].ast) = c_ast_pointer( (yyvsp[0].ast), &gc_ast_list );

      slist_init( &(yyval.ast_list) );
      slist_push_back( &(yyval.ast_list), (yyvsp[0].ast) );

      DUMP_AST_LIST( "$$_ast_list", (yyval.ast_list) );
      DUMP_END();
    }
#line 12026 "parser.c"
    break;

  case 740: /* decl_english_ast_exp: error  */
#line 7831 "parser.y"
    {
      elaborate_error( "declaration expected" );
    }
#line 12034 "parser.c"
    break;

  case 741: /* ref_qualifier_english_stid_opt: %empty  */
#line 7839 "parser.y"
                                  { (yyval.tid) = TS_NONE; }
#line 12040 "parser.c"
    break;

  case 742: /* ref_qualifier_english_stid_opt: Y_reference  */
#line 7840 "parser.y"
                                  { (yyval.tid) = TS_REFERENCE; }
#line 12046 "parser.c"
    break;

  case 743: /* ref_qualifier_english_stid_opt: Y_rvalue reference_exp  */
#line 7841 "parser.y"
                                  { (yyval.tid) = TS_RVALUE_REFERENCE; }
#line 12052 "parser.c"
    break;

  case 744: /* returning_english_ast_opt: %empty  */
#line 7848 "parser.y"
    {
      DUMP_START( "returning_english_ast_opt", "<empty>" );

      (yyval.ast) = c_ast_new_gc( K_BUILTIN, &(yyloc) );
      // see the comment in "type_c_ast"
      (yyval.ast)->type.btids = OPT_LANG_IS( IMPLICIT_int ) ? TB_int : TB_void;

      DUMP_AST( "$$_ast", (yyval.ast) );
      DUMP_END();
    }
#line 12067 "parser.c"
    break;

  case 746: /* returning_english_ast: returning decl_english_ast  */
#line 7864 "parser.y"
    {
      DUMP_START( "returning_english_ast", "RETURNING decl_english_ast" );
      DUMP_AST( "decl_english_ast", (yyvsp[0].ast) );

      (yyval.ast) = (yyvsp[0].ast);

      DUMP_AST( "$$_ast", (yyval.ast) );
      DUMP_END();
    }
#line 12081 "parser.c"
    break;

  case 747: /* returning_english_ast: returning error  */
#line 7875 "parser.y"
    {
      elaborate_error( "English expected after \"returning\"" );
    }
#line 12089 "parser.c"
    break;

  case 748: /* qualified_decl_english_ast: type_qualifier_list_english_type_opt qualifiable_decl_english_ast  */
#line 7885 "parser.y"
    {
      DUMP_START( "qualified_decl_english_ast",
                  "type_qualifier_list_english_type_opt "
                  "qualifiable_decl_english_ast" );
      DUMP_TYPE( "type_qualifier_list_english_type_opt", (yyvsp[-1].type) );
      DUMP_AST( "qualifiable_decl_english_ast", (yyvsp[0].ast) );

      (yyval.ast) = (yyvsp[0].ast);
      if ( !c_type_is_none( &(yyvsp[-1].type) ) )
        (yyval.ast)->loc = (yyloc);
      PARSE_ASSERT( c_type_add( &(yyval.ast)->type, &(yyvsp[-1].type), &(yylsp[-1]) ) );

      DUMP_AST( "$$_ast", (yyval.ast) );
      DUMP_END();
    }
#line 12109 "parser.c"
    break;

  case 749: /* type_qualifier_list_english_type_opt: %empty  */
#line 7903 "parser.y"
                                  { (yyval.type) = T_NONE; }
#line 12115 "parser.c"
    break;

  case 751: /* type_qualifier_list_english_type: type_qualifier_list_english_type type_qualifier_english_type  */
#line 7910 "parser.y"
    {
      DUMP_START( "type_qualifier_list_english_type",
                  "type_qualifier_list_english_type "
                  "type_qualifier_english_type" );
      DUMP_TYPE( "type_qualifier_list_english_type", (yyvsp[-1].type) );
      DUMP_TYPE( "type_qualifier_english_type", (yyvsp[0].type) );

      (yyval.type) = (yyvsp[-1].type);
      PARSE_ASSERT( c_type_add( &(yyval.type), &(yyvsp[0].type), &(yylsp[0]) ) );

      DUMP_TYPE( "$$_type", (yyval.type) );
      DUMP_END();
    }
#line 12133 "parser.c"
    break;

  case 753: /* type_qualifier_english_type: attribute_english_atid  */
#line 7928 "parser.y"
                                  { (yyval.type) = C_TYPE_LIT_A( (yyvsp[0].tid) ); }
#line 12139 "parser.c"
    break;

  case 754: /* type_qualifier_english_type: storage_class_english_stid  */
#line 7929 "parser.y"
                                  { (yyval.type) = C_TYPE_LIT_S( (yyvsp[0].tid) ); }
#line 12145 "parser.c"
    break;

  case 755: /* type_qualifier_english_type: type_qualifier_english_stid  */
#line 7930 "parser.y"
                                  { (yyval.type) = C_TYPE_LIT_S( (yyvsp[0].tid) ); }
#line 12151 "parser.c"
    break;

  case 756: /* attribute_english_atid: Y_carries dependency_exp  */
#line 7934 "parser.y"
                                  { (yyval.tid) = TA_carries_dependency; }
#line 12157 "parser.c"
    break;

  case 759: /* attribute_english_atid: Y_maybe unused_exp  */
#line 7937 "parser.y"
                                  { (yyval.tid) = TA_maybe_unused; }
#line 12163 "parser.c"
    break;

  case 761: /* attribute_english_atid: Y_no Y_discard  */
#line 7939 "parser.y"
                                  { (yyval.tid) = TA_nodiscard; }
#line 12169 "parser.c"
    break;

  case 763: /* attribute_english_atid: Y_no Y_return  */
#line 7941 "parser.y"
                                  { (yyval.tid) = TA_noreturn; }
#line 12175 "parser.c"
    break;

  case 766: /* attribute_english_atid: Y_no Y_unique address_exp  */
#line 7944 "parser.y"
                                  { (yyval.tid) = TA_no_unique_address; }
#line 12181 "parser.c"
    break;

  case 772: /* storage_class_english_stid: Y_constant eval_expr_init_stid  */
#line 7954 "parser.y"
    {
      (yyval.tid) = (yyvsp[0].tid);
    }
#line 12189 "parser.c"
    break;

  case 781: /* storage_class_english_stid: Y_extern linkage_stid linkage_opt  */
#line 7966 "parser.y"
    {
      (yyval.tid) = (yyvsp[-1].tid);
    }
#line 12197 "parser.c"
    break;

  case 786: /* storage_class_english_stid: Y_no Y_except  */
#line 7973 "parser.y"
                                  { (yyval.tid) = TS_noexcept; }
#line 12203 "parser.c"
    break;

  case 788: /* storage_class_english_stid: Y_non_empty  */
#line 7975 "parser.y"
                                  { (yyval.tid) = TS_NON_EMPTY_ARRAY; }
#line 12209 "parser.c"
    break;

  case 792: /* storage_class_english_stid: Y_thread local_exp  */
#line 7980 "parser.y"
                                  { (yyval.tid) = TS_thread_local; }
#line 12215 "parser.c"
    break;

  case 798: /* storage_class_english_stid: Y_pure virtual_stid_exp  */
#line 7986 "parser.y"
                                  { (yyval.tid) = TS_PURE_virtual | (yyvsp[0].tid); }
#line 12221 "parser.c"
    break;

  case 799: /* eval_expr_init_stid: Y_evaluation  */
#line 7990 "parser.y"
                                  { (yyval.tid) = TS_consteval; }
#line 12227 "parser.c"
    break;

  case 800: /* eval_expr_init_stid: Y_expression  */
#line 7991 "parser.y"
                                  { (yyval.tid) = TS_constexpr; }
#line 12233 "parser.c"
    break;

  case 801: /* eval_expr_init_stid: Y_initialization  */
#line 7992 "parser.y"
                                  { (yyval.tid) = TS_constinit; }
#line 12239 "parser.c"
    break;

  case 802: /* linkage_stid: str_lit  */
#line 8004 "parser.y"
    {
      bool ok = true;

      if ( strcmp( (yyvsp[0].str_val), "C" ) == 0 )
        (yyval.tid) = TS_extern_C;
      else if ( strcmp( (yyvsp[0].str_val), "C++" ) == 0 )
        (yyval.tid) = TS_NONE;
      else {
        print_error( &(yylsp[0]), "\"%s\": unknown linkage language", (yyvsp[0].str_val) );
        print_hint( "\"C\" or \"C++\"" );
        ok = false;
      }

      free( (yyvsp[0].str_val) );
      PARSE_ASSERT( ok );
    }
#line 12260 "parser.c"
    break;

  case 823: /* pointer_decl_english_ast: Y_pointer to_exp decl_english_ast  */
#line 8062 "parser.y"
    {
      DUMP_START( "pointer_decl_english_ast", "POINTER TO decl_english_ast" );
      DUMP_AST( "decl_english_ast", (yyvsp[0].ast) );

      // see the comment in "declare_command"
      PARSE_ASSERT( !c_ast_is_name_error( (yyvsp[0].ast) ) );

      (yyval.ast) = c_ast_new_gc( K_POINTER, &(yyloc) );
      c_ast_set_parent( (yyvsp[0].ast), (yyval.ast) );

      DUMP_AST( "$$_ast", (yyval.ast) );
      DUMP_END();
    }
#line 12278 "parser.c"
    break;

  case 824: /* pointer_decl_english_ast: Y_pointer to_exp Y_member of_exp class_struct_union_btid_exp sname_english_exp decl_english_ast  */
#line 8082 "parser.y"
    {
      DUMP_START( "pointer_to_member_decl_english",
                  "POINTER TO MEMBER OF "
                  "class_struct_union_btid_exp "
                  "sname_english decl_english_ast" );
      DUMP_TID( "class_struct_union_btid_exp", (yyvsp[-2].tid) );
      DUMP_SNAME( "sname_english_exp", (yyvsp[-1].sname) );
      DUMP_AST( "decl_english_ast", (yyvsp[0].ast) );

      // see the comment in "declare_command"
      if ( c_ast_is_name_error( (yyvsp[0].ast) ) ) {
        c_sname_cleanup( &(yyvsp[-1].sname) );
        PARSE_ABORT();
      }

      (yyval.ast) = c_ast_new_gc( K_POINTER_TO_MEMBER, &(yyloc) );
      (yyval.ast)->ptr_mbr.class_sname = c_sname_move( &(yyvsp[-1].sname) );
      c_ast_set_parent( (yyvsp[0].ast), (yyval.ast) );
      PARSE_ASSERT( c_type_add_tid( &(yyval.ast)->type, (yyvsp[-2].tid), &(yylsp[-2]) ) );

      DUMP_AST( "$$_ast", (yyval.ast) );
      DUMP_END();
    }
#line 12306 "parser.c"
    break;

  case 825: /* pointer_decl_english_ast: Y_pointer to_exp error  */
#line 8107 "parser.y"
    {
      if ( OPT_LANG_IS( POINTERS_TO_MEMBER ) )
        elaborate_error( "type name or \"member\" expected" );
      else
        elaborate_error( "type name expected" );
    }
#line 12317 "parser.c"
    break;

  case 826: /* reference_decl_english_ast: reference_english_ast to_exp decl_english_ast  */
#line 8120 "parser.y"
    {
      DUMP_START( "reference_decl_english_ast",
                  "reference_english_ast TO decl_english_ast" );
      DUMP_AST( "reference_english_ast", (yyvsp[-2].ast) );
      DUMP_AST( "decl_english_ast", (yyvsp[0].ast) );

      // see the comment in "declare_command"
      PARSE_ASSERT( !c_ast_is_name_error( (yyvsp[0].ast) ) );

      (yyval.ast) = (yyvsp[-2].ast);
      (yyval.ast)->loc = (yyloc);
      c_ast_set_parent( (yyvsp[0].ast), (yyval.ast) );

      DUMP_AST( "$$_ast", (yyval.ast) );
      DUMP_END();
    }
#line 12338 "parser.c"
    break;

  case 827: /* reference_english_ast: Y_reference  */
#line 8140 "parser.y"
    {
      (yyval.ast) = c_ast_new_gc( K_REFERENCE, &(yyloc) );
    }
#line 12346 "parser.c"
    break;

  case 828: /* reference_english_ast: Y_rvalue reference_exp  */
#line 8145 "parser.y"
    {
      (yyval.ast) = c_ast_new_gc( K_RVALUE_REFERENCE, &(yyloc) );
    }
#line 12354 "parser.c"
    break;

  case 829: /* structured_binding_decl_english_ast: Y_structured binding_exp  */
#line 8154 "parser.y"
    {
      (yyval.ast) = c_ast_new_gc( K_STRUCTURED_BINDING, &(yyloc) );
    }
#line 12362 "parser.c"
    break;

  case 830: /* user_defined_literal_decl_english_ast: user_defined literal_exp lparen_exp param_decl_list_english_opt ')' returning_english_ast_opt  */
#line 8165 "parser.y"
    { //
      // User-defined literals are supported only in C++11 and later.
      // (However, we always allow them in configuration files.)
      //
      // This check is better to do now in the parser rather than later in the
      // AST because it has to be done in fewer places in the code plus gives a
      // better error location.
      //
      if ( !OPT_LANG_IS( USER_DEF_LITS ) ) {
        print_error( &(yylsp[-5]),
          "user-defined literals not supported%s\n",
          C_LANG_WHICH( USER_DEF_LITS )
        );
        PARSE_ABORT();
      }

      DUMP_START( "user_defined_literal_decl_english_ast",
                  "USER-DEFINED LITERAL '(' param_decl_list_english_opt ')' "
                  "returning_english_ast_opt" );
      DUMP_AST_LIST( "param_decl_list_english_opt", (yyvsp[-2].ast_list) );
      DUMP_AST( "returning_english_ast_opt", (yyvsp[0].ast) );

      (yyval.ast) = c_ast_new_gc( K_UDEF_LIT, &(yyloc) );
      c_ast_list_set_param_of( &(yyvsp[-2].ast_list), (yyval.ast) );
      (yyval.ast)->udef_lit.param_ast_list = slist_move( &(yyvsp[-2].ast_list) );
      c_ast_set_parent( (yyvsp[0].ast), (yyval.ast) );

      DUMP_AST( "$$_ast", (yyval.ast) );
      DUMP_END();
    }
#line 12397 "parser.c"
    break;

  case 831: /* var_decl_english_ast: sname_c Y_as decl_english_ast  */
#line 8204 "parser.y"
    {
      DUMP_START( "var_decl_english_ast", "sname_c AS decl_english_ast" );
      DUMP_SNAME( "sname_c", (yyvsp[-2].sname) );
      DUMP_AST( "decl_english_ast", (yyvsp[0].ast) );

      // see the comment in "declare_command"
      if ( c_ast_is_name_error( (yyvsp[0].ast) ) ) {
        c_sname_cleanup( &(yyvsp[-2].sname) );
        PARSE_ABORT();
      }

      (yyval.ast) = (yyvsp[0].ast);
      (yyval.ast)->loc = (yyloc);
      c_sname_set( &(yyval.ast)->sname, &(yyvsp[-2].sname) );

      DUMP_AST( "$$_ast", (yyval.ast) );
      DUMP_END();
    }
#line 12420 "parser.c"
    break;

  case 833: /* var_decl_english_ast: "..."  */
#line 8232 "parser.y"
    {
      DUMP_START( "var_decl_english_ast", "..." );

      (yyval.ast) = c_ast_new_gc( K_VARIADIC, &(yyloc) );

      DUMP_AST( "$$_ast", (yyval.ast) );
      DUMP_END();
    }
#line 12433 "parser.c"
    break;

  case 834: /* type_english_ast: type_modifier_list_english_type_opt unmodified_type_english_ast  */
#line 8249 "parser.y"
    {
      DUMP_START( "type_english_ast",
                  "type_modifier_list_english_type_opt "
                  "unmodified_type_english_ast" );
      DUMP_TYPE( "type_modifier_list_english_type_opt", (yyvsp[-1].type) );
      DUMP_AST( "unmodified_type_english_ast", (yyvsp[0].ast) );

      (yyval.ast) = (yyvsp[0].ast);
      if ( !c_type_is_none( &(yyvsp[-1].type) ) ) {
        // Set the AST's location to the entire rule only if the leading
        // optional rule is actually present, otherwise @$ refers to a column
        // before $ast.
        (yyval.ast)->loc = (yyloc);
        PARSE_ASSERT( c_type_add( &(yyval.ast)->type, &(yyvsp[-1].type), &(yylsp[-1]) ) );
      }

      DUMP_AST( "$$_ast", (yyval.ast) );
      DUMP_END();
    }
#line 12457 "parser.c"
    break;

  case 835: /* type_english_ast: type_modifier_list_english_type  */
#line 8271 "parser.y"
    {
      DUMP_START( "type_english_ast", "type_modifier_list_english_type" );
      DUMP_TYPE( "type_modifier_list_english_type", (yyvsp[0].type) );

      // see the comment in "type_c_ast"
      c_type_t new_type =
        C_TYPE_LIT_B( OPT_LANG_IS( IMPLICIT_int ) ? TB_int : TB_NONE );

      PARSE_ASSERT( c_type_add( &new_type, &(yyvsp[0].type), &(yylsp[0]) ) );

      (yyval.ast) = c_ast_new_gc( K_BUILTIN, &(yyloc) );
      (yyval.ast)->type = new_type;

      DUMP_AST( "$$_ast", (yyval.ast) );
      DUMP_END();
    }
#line 12478 "parser.c"
    break;

  case 836: /* type_modifier_list_english_type_opt: %empty  */
#line 8290 "parser.y"
                                  { (yyval.type) = T_NONE; }
#line 12484 "parser.c"
    break;

  case 838: /* type_modifier_list_english_type: type_modifier_list_english_type type_modifier_english_type  */
#line 8297 "parser.y"
    {
      DUMP_START( "type_modifier_list_english_type",
                  "type_modifier_list_english_type "
                  "type_modifier_english_type" );
      DUMP_TYPE( "type_modifier_list_english_type", (yyvsp[-1].type) );
      DUMP_TYPE( "type_modifier_english_type", (yyvsp[0].type) );

      (yyval.type) = (yyvsp[-1].type);
      PARSE_ASSERT( c_type_add( &(yyval.type), &(yyvsp[0].type), &(yylsp[0]) ) );

      DUMP_TYPE( "$$_type", (yyval.type) );
      DUMP_END();
    }
#line 12502 "parser.c"
    break;

  case 847: /* builtin_type_english_ast: builtin_no_BitInt_english_btid  */
#line 8329 "parser.y"
    {
      DUMP_START( "builtin_type_english_ast",
                  "builtin_no_BitInt_english_btid" );
      DUMP_TID( "builtin_no_BitInt_english_btid", (yyvsp[0].tid) );

      (yyval.ast) = c_ast_new_gc( K_BUILTIN, &(yyloc) );
      (yyval.ast)->type.btids = c_tid_check( (yyvsp[0].tid), C_TPID_BASE );

      DUMP_AST( "$$_ast", (yyval.ast) );
      DUMP_END();
    }
#line 12518 "parser.c"
    break;

  case 848: /* builtin_type_english_ast: BitInt_english_int  */
#line 8341 "parser.y"
    {
      DUMP_START( "builtin_type_english_ast", "BitInt_english_int" );
      DUMP_INT( "BitInt_english_int", (yyvsp[0].uint_val) );

      (yyval.ast) = c_ast_new_gc( K_BUILTIN, &(yyloc) );
      (yyval.ast)->type.btids = TB__BitInt;
      (yyval.ast)->builtin.BitInt.width = (yyvsp[0].uint_val);

      DUMP_AST( "$$_ast", (yyval.ast) );
      DUMP_END();
    }
#line 12534 "parser.c"
    break;

  case 853: /* builtin_no_BitInt_english_btid: Y_char uint_lit_opt  */
#line 8360 "parser.y"
    {
      switch ( (yyvsp[0].uint_val) ) {
        case  0: (yyval.tid) = TB_char    ; break;
        case  8: (yyval.tid) = TB_char8_t ; break;
        case 16: (yyval.tid) = TB_char16_t; break;
        case 32: (yyval.tid) = TB_char32_t; break;
        default:
          print_error( &(yylsp[0]), "bits must be one of 8, 16, or 32\n" );
          PARSE_ABORT();
      } // switch
    }
#line 12550 "parser.c"
    break;

  case 857: /* builtin_no_BitInt_english_btid: Y_decltype  */
#line 8375 "parser.y"
    {
      UNSUPPORTED( &(yylsp[0]), "decltype() declarations" );
    }
#line 12558 "parser.c"
    break;

  case 859: /* builtin_no_BitInt_english_btid: Y_wide char_exp  */
#line 8379 "parser.y"
                                  { (yyval.tid) = TB_wchar_t; }
#line 12564 "parser.c"
    break;

  case 862: /* builtin_no_BitInt_english_btid: Y_floating point_exp  */
#line 8382 "parser.y"
                                  { (yyval.tid) = TB_float; }
#line 12570 "parser.c"
    break;

  case 863: /* builtin_no_BitInt_english_btid: Y_double precision_opt  */
#line 8383 "parser.y"
                                  { (yyval.tid) = TB_double; }
#line 12576 "parser.c"
    break;

  case 866: /* BitInt_english_int: BitInt_english uint_lit bits_opt  */
#line 8390 "parser.y"
    {
      (yyval.uint_val) = (yyvsp[-1].uint_val);
    }
#line 12584 "parser.c"
    break;

  case 867: /* BitInt_english_int: BitInt_english '(' uint_lit_exp rparen_exp  */
#line 8394 "parser.y"
    {
      (yyval.uint_val) = (yyvsp[-1].uint_val);
    }
#line 12592 "parser.c"
    break;

  case 868: /* BitInt_english_int: BitInt_english Y_width uint_lit_exp bits_opt  */
#line 8398 "parser.y"
    {
      (yyval.uint_val) = (yyvsp[-1].uint_val);
    }
#line 12600 "parser.c"
    break;

  case 869: /* BitInt_english_int: BitInt_english error  */
#line 8402 "parser.y"
    {
      elaborate_error( "integer literal, '(', or \"width\" expected" );
    }
#line 12608 "parser.c"
    break;

  case 873: /* concept_type_english_ast: Y_concept sname_english_exp  */
#line 8415 "parser.y"
    {
      DUMP_START( "concept_type_english_ast", "CONCEPT sname_english_exp" );
      DUMP_SNAME( "sname_english_exp", (yyvsp[0].sname) );

      c_sname_set_all_types( &(yyvsp[0].sname) );

      (yyval.ast) = c_ast_new_gc( K_CONCEPT, &(yyloc) );
      (yyval.ast)->concept.concept_sname = c_sname_move( &(yyvsp[0].sname) );

      DUMP_AST( "$$_ast", (yyval.ast) );
      DUMP_END();
    }
#line 12625 "parser.c"
    break;

  case 874: /* concept_type_english_ast: Y_concept sname_english_exp Y_parameter pack_exp  */
#line 8429 "parser.y"
    {
      DUMP_START( "concept_type_english_ast",
                  "CONCEPT sname_english_exp PARAMTER PACK" );
      DUMP_SNAME( "sname_english_exp", (yyvsp[-2].sname) );

      c_sname_set_all_types( &(yyvsp[-2].sname) );

      (yyval.ast) = c_ast_new_gc( K_CONCEPT, &(yyloc) );
      (yyval.ast)->is_param_pack = true;
      (yyval.ast)->concept.concept_sname = c_sname_move( &(yyvsp[-2].sname) );

      DUMP_AST( "$$_ast", (yyval.ast) );
      DUMP_END();
    }
#line 12644 "parser.c"
    break;

  case 875: /* parameter_pack_english_ast: Y_parameter pack_exp  */
#line 8447 "parser.y"
    {
      (yyval.ast) = c_ast_new_gc( K_BUILTIN, &(yyloc) );
      (yyval.ast)->is_param_pack = true;
      (yyval.ast)->type.btids = TB_auto;         // for consistency with C++ case
    }
#line 12654 "parser.c"
    break;

  case 877: /* pack_exp: error  */
#line 8457 "parser.y"
    {
      keyword_expected( L_pack );
    }
#line 12662 "parser.c"
    break;

  case 880: /* class_struct_union_english_ast: class_struct_union_btid any_sname_c_exp  */
#line 8469 "parser.y"
    {
      DUMP_START( "class_struct_union_english_ast",
                  "class_struct_union_btid any_sname_c_exp" );
      DUMP_TID( "class_struct_union_btid", (yyvsp[-1].tid) );
      DUMP_SNAME( "any_sname_c_exp", (yyvsp[0].sname) );

      (yyval.ast) = c_ast_new_gc( K_CLASS_STRUCT_UNION, &(yyloc) );
      (yyval.ast)->type.btids = c_tid_check( (yyvsp[-1].tid), C_TPID_BASE );
      (yyval.ast)->csu.csu_sname = c_sname_move( &(yyvsp[0].sname) );

      DUMP_AST( "$$_ast", (yyval.ast) );
      DUMP_END();
    }
#line 12680 "parser.c"
    break;

  case 881: /* enum_english_ast: enum_btids any_sname_c_exp of_type_enum_fixed_type_english_ast_opt  */
#line 8487 "parser.y"
    {
      DUMP_START( "enum_english_ast",
                  "enum_btids any_sname_c_exp "
                  "of_type_enum_fixed_type_english_ast_opt" );
      DUMP_TID( "enum_btids", (yyvsp[-2].tid) );
      DUMP_SNAME( "any_sname_c_exp", (yyvsp[-1].sname) );
      DUMP_AST( "enum_fixed_type_english_ast", (yyvsp[0].ast) );

      (yyval.ast) = c_ast_new_gc( K_ENUM, &(yyloc) );
      (yyval.ast)->type.btids = c_tid_check( (yyvsp[-2].tid), C_TPID_BASE );
      c_ast_set_parent( (yyvsp[0].ast), (yyval.ast) );
      (yyval.ast)->enum_.enum_sname = c_sname_move( &(yyvsp[-1].sname) );

      DUMP_AST( "$$_ast", (yyval.ast) );
      DUMP_END();
    }
#line 12701 "parser.c"
    break;

  case 882: /* of_type_enum_fixed_type_english_ast_opt: %empty  */
#line 8506 "parser.y"
                                        { (yyval.ast) = NULL; }
#line 12707 "parser.c"
    break;

  case 883: /* of_type_enum_fixed_type_english_ast_opt: Y_of type_opt enum_fixed_type_english_ast  */
#line 8508 "parser.y"
    {
      (yyval.ast) = (yyvsp[0].ast);
    }
#line 12715 "parser.c"
    break;

  case 884: /* enum_fixed_type_english_ast: enum_fixed_type_modifier_list_english_btid_opt enum_unmodified_fixed_type_english_ast  */
#line 8516 "parser.y"
    {
      DUMP_START( "enum_fixed_type_english_ast",
                  "enum_fixed_type_modifier_list_stid" );
      DUMP_TID( "enum_fixed_type_modifier_list_stid", (yyvsp[-1].tid) );
      DUMP_AST( "enum_unmodified_fixed_type_english_ast", (yyvsp[0].ast) );

      (yyval.ast) = (yyvsp[0].ast);
      if ( (yyvsp[-1].tid) != TB_NONE ) {        // See comment in type_english_ast.
        (yyval.ast)->loc = (yyloc);
        PARSE_ASSERT( c_type_add_tid( &(yyval.ast)->type, (yyvsp[-1].tid), &(yylsp[-1]) ) );
      }

      DUMP_AST( "$$_ast", (yyval.ast) );
      DUMP_END();
    }
#line 12735 "parser.c"
    break;

  case 885: /* enum_fixed_type_english_ast: enum_fixed_type_modifier_list_english_btid  */
#line 8533 "parser.y"
    {
      DUMP_START( "enum_fixed_type_english_ast",
                  "enum_fixed_type_modifier_list_english_btid" );
      DUMP_TID( "enum_fixed_type_modifier_list_english_btid", (yyvsp[0].tid) );

      (yyval.ast) = c_ast_new_gc( K_BUILTIN, &(yyloc) );
      (yyval.ast)->type.btids = c_tid_check( (yyvsp[0].tid), C_TPID_BASE );

      DUMP_AST( "$$_ast", (yyval.ast) );
      DUMP_END();
    }
#line 12751 "parser.c"
    break;

  case 886: /* enum_fixed_type_modifier_list_english_btid_opt: %empty  */
#line 8547 "parser.y"
                                  { (yyval.tid) = TB_NONE; }
#line 12757 "parser.c"
    break;

  case 888: /* enum_fixed_type_modifier_list_english_btid: enum_fixed_type_modifier_list_english_btid enum_fixed_type_modifier_btid  */
#line 8554 "parser.y"
    {
      DUMP_START( "enum_fixed_type_modifier_list_english_btid",
                  "enum_fixed_type_modifier_list_english_btid "
                  "enum_fixed_type_modifier_btid" );
      DUMP_TID( "enum_fixed_type_modifier_list_english_btid", (yyvsp[-1].tid) );
      DUMP_TID( "enum_fixed_type_modifier_btid", (yyvsp[0].tid) );

      (yyval.tid) = (yyvsp[-1].tid);
      PARSE_ASSERT( c_tid_add( &(yyval.tid), (yyvsp[0].tid), &(yylsp[0]) ) );

      DUMP_TID( "$$_btids", (yyval.tid) );
      DUMP_END();
    }
#line 12775 "parser.c"
    break;

  case 893: /* any_name: Y_TYPEDEF_NAME_TDEF  */
#line 8583 "parser.y"
    {
      assert( c_sname_count( &(yyvsp[0].tdef)->ast->sname ) == 1 );
      (yyval.name) = check_strdup( c_sname_local_name( &(yyvsp[0].tdef)->ast->sname ) );
    }
#line 12784 "parser.c"
    break;

  case 895: /* any_name_exp: error  */
#line 8592 "parser.y"
    {
      (yyval.name) = NULL;
      elaborate_error( "name expected" );
    }
#line 12793 "parser.c"
    break;

  case 899: /* any_sname_c_exp: error  */
#line 8606 "parser.y"
    {
      c_sname_init( &(yyval.sname) );
      elaborate_error( "name expected" );
    }
#line 12802 "parser.c"
    break;

  case 900: /* any_sname_c_opt: %empty  */
#line 8613 "parser.y"
                                  { c_sname_init( &(yyval.sname) ); }
#line 12808 "parser.c"
    break;

  case 904: /* name_ast: Y_NAME  */
#line 8624 "parser.y"
    {
      DUMP_START( "name_ast", "NAME" );
      DUMP_STR( "NAME", (yyvsp[0].name) );

      (yyval.ast) = c_ast_new_gc( K_NAME, &(yyloc) );
      c_sname_init_name( &(yyval.ast)->sname, (yyvsp[0].name) );

      DUMP_AST( "$$_ast", (yyval.ast) );
      DUMP_END();
    }
#line 12823 "parser.c"
    break;

  case 906: /* name_exp: error  */
#line 8639 "parser.y"
    {
      (yyval.name) = NULL;
      elaborate_error( "name expected" );
    }
#line 12832 "parser.c"
    break;

  case 907: /* name_cat: name_cat Y_NAME  */
#line 8647 "parser.y"
    {
      (yyval.name) = str_realloc_cat( (yyvsp[-1].name), " ", (yyvsp[0].name) );
      free( (yyvsp[0].name) );
    }
#line 12841 "parser.c"
    break;

  case 909: /* name_opt: %empty  */
#line 8655 "parser.y"
                                  { (yyval.name) = NULL; }
#line 12847 "parser.c"
    break;

  case 911: /* oper_sname_c_opt: %empty  */
#line 8660 "parser.y"
                                  { c_sname_init( &(yyval.sname) ); }
#line 12853 "parser.c"
    break;

  case 912: /* oper_sname_c_opt: Y_OPERATOR_SNAME Y_COLON_COLON  */
#line 8663 "parser.y"
    {
      (yyval.sname) = (yyvsp[-1].sname);
      if ( c_type_is_none( c_sname_local_type( &(yyval.sname) ) ) )
        c_sname_local_data( &(yyval.sname) )->type = C_TYPE_LIT_B( TB_SCOPE );
    }
#line 12863 "parser.c"
    break;

  case 913: /* sname_c: sname_c Y_COLON_COLON Y_NAME  */
#line 8672 "parser.y"
    {
      // see the comment in "of_scope_english"
      if ( !OPT_LANG_IS( SCOPED_NAMES ) ) {
        print_error( &(yylsp[-1]),
          "scoped names not supported%s\n",
          C_LANG_WHICH( SCOPED_NAMES )
        );
        c_sname_cleanup( &(yyvsp[-2].sname) );
        free( (yyvsp[0].name) );
        PARSE_ABORT();
      }

      DUMP_START( "sname_c", "sname_c '::' NAME" );
      DUMP_SNAME( "sname_c", (yyvsp[-2].sname) );
      DUMP_STR( "name", (yyvsp[0].name) );

      (yyval.sname) = (yyvsp[-2].sname);
      c_sname_local_data( &(yyval.sname) )->type = C_TYPE_LIT_B( TB_SCOPE );
      c_sname_append_name( &(yyval.sname), (yyvsp[0].name) );

      DUMP_SNAME( "$$_sname", (yyval.sname) );
      DUMP_END();
    }
#line 12891 "parser.c"
    break;

  case 914: /* sname_c: sname_c Y_COLON_COLON any_typedef_tdef  */
#line 8697 "parser.y"
    { //
      // This is for a case like:
      //
      //      define S::int8_t as char
      //
      // that is: the type int8_t is an existing type in no scope being defined
      // as a distinct type in a new scope.
      //
      DUMP_START( "sname_c", "sname_c '::' any_typedef_tdef" );
      DUMP_SNAME( "sname_c", (yyvsp[-2].sname) );
      DUMP_AST( "any_typedef__ast", (yyvsp[0].tdef)->ast );

      (yyval.sname) = (yyvsp[-2].sname);
      c_sname_local_data( &(yyval.sname) )->type = C_TYPE_LIT_B( TB_SCOPE );
      c_sname_t temp_sname = c_sname_dup( &(yyvsp[0].tdef)->ast->sname );
      c_sname_append_sname( &(yyval.sname), &temp_sname );

      DUMP_SNAME( "$$_sname", (yyval.sname) );
      DUMP_END();
    }
#line 12916 "parser.c"
    break;

  case 915: /* sname_c: Y_NAME  */
#line 8719 "parser.y"
    {
      DUMP_START( "sname_c", "NAME" );
      DUMP_STR( "NAME", (yyvsp[0].name) );

      c_sname_init_name( &(yyval.sname), (yyvsp[0].name) );

      DUMP_SNAME( "$$_sname", (yyval.sname) );
      DUMP_END();
    }
#line 12930 "parser.c"
    break;

  case 916: /* sname_c_ast: sname_c bit_field_c_uint_opt  */
#line 8733 "parser.y"
    {
      c_ast_t *const type_ast = ia_type_ast_peek();

      DUMP_START( "sname_c_ast", "sname_c" );
      DUMP_AST( "in_attr__type_c_ast", type_ast );
      DUMP_SNAME( "sname_c", (yyvsp[-1].sname) );
      DUMP_INT( "bit_field_c_uint_opt", (yyvsp[0].uint_val) );

      (yyval.ast) = ia_type_spec_ast( type_ast );
      c_sname_set( &(yyval.ast)->sname, &(yyvsp[-1].sname) );
      PARSE_ASSERT( c_ast_set_bit_field_width( (yyval.ast), (yyvsp[0].uint_val) ) );

      DUMP_AST( "$$_ast", (yyval.ast) );
      DUMP_END();
    }
#line 12950 "parser.c"
    break;

  case 917: /* bit_field_c_uint_opt: %empty  */
#line 8751 "parser.y"
                                  { (yyval.uint_val) = 0; }
#line 12956 "parser.c"
    break;

  case 918: /* bit_field_c_uint_opt: ':' uint_lit_exp  */
#line 8753 "parser.y"
    { //
      // This check has to be done now in the parser rather than later in the
      // AST since we use 0 to mean "no bit-field."
      //
      if ( (yyvsp[0].uint_val) == 0 ) {
        print_error( &(yylsp[0]), "bit-field width must be > 0\n" );
        PARSE_ABORT();
      }
      (yyval.uint_val) = (yyvsp[0].uint_val);
    }
#line 12971 "parser.c"
    break;

  case 920: /* sname_c_exp: error  */
#line 8768 "parser.y"
    {
      c_sname_init( &(yyval.sname) );
      elaborate_error( "name expected" );
    }
#line 12980 "parser.c"
    break;

  case 921: /* sname_c_opt: %empty  */
#line 8775 "parser.y"
                                  { c_sname_init( &(yyval.sname) ); }
#line 12986 "parser.c"
    break;

  case 923: /* sname_english: any_sname_c of_scope_list_english_opt  */
#line 8781 "parser.y"
    {
      DUMP_START( "sname_english", "any_sname_c of_scope_list_english_opt" );
      DUMP_SNAME( "any_sname_c", (yyvsp[-1].sname) );
      DUMP_SNAME( "of_scope_list_english_opt", (yyvsp[0].sname) );

      c_type_t const *local_type = c_sname_local_type( &(yyvsp[0].sname) );
      if ( c_type_is_none( local_type ) )
        local_type = c_sname_local_type( &(yyvsp[-1].sname) );
      (yyval.sname) = (yyvsp[0].sname);
      c_sname_append_sname( &(yyval.sname), &(yyvsp[-1].sname) );
      c_sname_local_data( &(yyval.sname) )->type = *local_type;

      DUMP_SNAME( "$$_sname", (yyval.sname) );
      DUMP_END();
    }
#line 13006 "parser.c"
    break;

  case 924: /* sname_english_ast: Y_NAME of_scope_list_english_opt  */
#line 8800 "parser.y"
    {
      DUMP_START( "sname_english_ast", "NAME of_scope_list_english_opt" );
      DUMP_STR( "NAME", (yyvsp[-1].name) );
      DUMP_SNAME( "of_scope_list_english_opt", (yyvsp[0].sname) );

      c_sname_t sname = c_sname_move( &(yyvsp[0].sname) );
      c_sname_append_name( &sname, (yyvsp[-1].name) );

      c_typedef_t const *const tdef = c_typedef_find_sname( &sname );
      if ( tdef != NULL ) {
        //
        // The sname is the name of a typedef'd type: create a new K_TYPEDEF
        // node and point it at the typedef's AST.
        //
        (yyval.ast) = c_ast_new_gc( K_TYPEDEF, &(yyloc) );
        (yyval.ast)->type.btids = TB_typedef;
        (yyval.ast)->tdef.for_ast = tdef->ast;
        c_sname_cleanup( &sname );
      }
      else {
        (yyval.ast) = c_ast_new_gc( K_NAME, &(yyloc) );
        (yyval.ast)->sname = sname;
        //
        // Set the c_name_ast's sname also in case it's used as a type name.
        //
        c_sname_t temp_sname = c_sname_dup( &(yyval.ast)->sname );
        c_sname_set( &(yyval.ast)->name.sname, &temp_sname );
      }

      DUMP_AST( "$$_ast", (yyval.ast) );
      DUMP_END();
    }
#line 13043 "parser.c"
    break;

  case 926: /* sname_english_exp: error  */
#line 8837 "parser.y"
    {
      c_sname_init( &(yyval.sname) );
      elaborate_error( "name expected" );
    }
#line 13052 "parser.c"
    break;

  case 927: /* sname_english_opt: %empty  */
#line 8844 "parser.y"
                                  { c_sname_init( &(yyval.sname) ); }
#line 13058 "parser.c"
    break;

  case 929: /* sname_list_c: sname_list_c ',' sname_c  */
#line 8850 "parser.y"
    {
      DUMP_START( "sname_list_c",
                  "sname_list_c ',' sname_c" );
      DUMP_SNAME_LIST( "sname_list_c", (yyvsp[-2].sname_list) );
      DUMP_SNAME( "sname_c", (yyvsp[0].sname) );

      (yyval.sname_list) = (yyvsp[-2].sname_list);
      c_sname_t *const temp_sname = MALLOC( c_sname_t, 1 );
      *temp_sname = c_sname_move( &(yyvsp[0].sname) );
      slist_push_back( &(yyval.sname_list), temp_sname );

      DUMP_SNAME_LIST( "$$_sname_list", (yyval.sname_list) );
      DUMP_END();
    }
#line 13077 "parser.c"
    break;

  case 930: /* sname_list_c: sname_c  */
#line 8865 "parser.y"
    {
      DUMP_START( "sname_list_c", "sname_c" );
      DUMP_SNAME( "sname_c", (yyvsp[0].sname) );

      c_sname_t *const temp_sname = MALLOC( c_sname_t, 1 );
      *temp_sname = c_sname_move( &(yyvsp[0].sname) );
      slist_init( &(yyval.sname_list) );
      slist_push_back( &(yyval.sname_list), temp_sname );

      DUMP_SNAME_LIST( "$$_sname_list", (yyval.sname_list) );
      DUMP_END();
    }
#line 13094 "parser.c"
    break;

  case 931: /* sname_list_english: sname_list_english ',' sname_english_exp  */
#line 8881 "parser.y"
    {
      DUMP_START( "sname_list_english",
                  "sname_list_english ',' sname_english" );
      DUMP_SNAME_LIST( "sname_list_english", (yyvsp[-2].sname_list) );
      DUMP_SNAME( "sname_english_exp", (yyvsp[0].sname) );

      (yyval.sname_list) = (yyvsp[-2].sname_list);
      c_sname_t *const temp_sname = MALLOC( c_sname_t, 1 );
      *temp_sname = c_sname_move( &(yyvsp[0].sname) );
      slist_push_back( &(yyval.sname_list), temp_sname );

      DUMP_SNAME_LIST( "$$_sname_list", (yyval.sname_list) );
      DUMP_END();
    }
#line 13113 "parser.c"
    break;

  case 932: /* sname_list_english: sname_english  */
#line 8897 "parser.y"
    {
      DUMP_START( "sname_list_english", "sname_english" );
      DUMP_SNAME( "sname_english", (yyvsp[0].sname) );

      c_sname_t *const temp_sname = MALLOC( c_sname_t, 1 );
      *temp_sname = c_sname_move( &(yyvsp[0].sname) );
      slist_init( &(yyval.sname_list) );
      slist_push_back( &(yyval.sname_list), temp_sname );

      DUMP_SNAME_LIST( "$$_sname_list", (yyval.sname_list) );
      DUMP_END();
    }
#line 13130 "parser.c"
    break;

  case 933: /* typedef_sname_c: typedef_sname_c Y_COLON_COLON sname_c  */
#line 8913 "parser.y"
    {
      DUMP_START( "typedef_sname_c", "typedef_sname_c '::' sname_c" );
      DUMP_SNAME( "typedef_sname_c", (yyvsp[-2].sname) );
      DUMP_SNAME( "sname_c", (yyvsp[0].sname) );

      //
      // This is for a case like:
      //
      //      define S as struct S
      //      define S::T as struct T
      //
      (yyval.sname) = c_sname_move( &(yyvsp[-2].sname) );
      c_sname_append_sname( &(yyval.sname), &(yyvsp[0].sname) );

      DUMP_SNAME( "$$_sname", (yyval.sname) );
      DUMP_END();
    }
#line 13152 "parser.c"
    break;

  case 934: /* typedef_sname_c: typedef_sname_c Y_COLON_COLON any_typedef_tdef  */
#line 8932 "parser.y"
    {
      DUMP_START( "typedef_sname_c", "typedef_sname_c '::' any_typedef_tdef" );
      DUMP_SNAME( "typedef_sname_c", (yyvsp[-2].sname) );
      DUMP_AST( "any_typedef__ast", (yyvsp[0].tdef)->ast );

      //
      // This is for a case like:
      //
      //      define S as struct S
      //      define T as struct T
      //      define S::T as struct S_T
      //
      (yyval.sname) = c_sname_move( &(yyvsp[-2].sname) );
      c_sname_local_data( &(yyval.sname) )->type =
        *c_sname_local_type( &(yyvsp[0].tdef)->ast->sname );
      c_sname_t temp_sname = c_sname_dup( &(yyvsp[0].tdef)->ast->sname );
      c_sname_append_sname( &(yyval.sname), &temp_sname );

      DUMP_SNAME( "$$_sname", (yyval.sname) );
      DUMP_END();
    }
#line 13178 "parser.c"
    break;

  case 935: /* typedef_sname_c: any_typedef_tdef  */
#line 8954 "parser.y"
                                  { (yyval.sname) = c_sname_dup( &(yyvsp[0].tdef)->ast->sname ); }
#line 13184 "parser.c"
    break;

  case 937: /* address_exp: error  */
#line 8964 "parser.y"
    {
      keyword_expected( L_address );
    }
#line 13192 "parser.c"
    break;

  case 939: /* array_exp: error  */
#line 8972 "parser.y"
    {
      keyword_expected( L_array );
    }
#line 13200 "parser.c"
    break;

  case 940: /* as_exp: Y_as  */
#line 8979 "parser.y"
    {
      if ( OPT_LANG_IS( MEMBER_FUNCTIONS ) ) {
        //
        // For either "declare" or "define", neither "override" nor "final"
        // must be matched initially to allow for cases like:
        //
        //      c++decl> declare final as int
        //      int final;
        //
        // (which is legal).  However, in C++, after parsing "as", the keyword
        // context has to be set to C_KW_CTX_MBR_FUNC to be able to match
        // "override" and "final", e.g.:
        //
        //      c++decl> declare f as final function
        //      void f() final;
        //
        lexer_keyword_ctx = C_KW_CTX_MBR_FUNC;
      }
    }
#line 13224 "parser.c"
    break;

  case 941: /* as_exp: error  */
#line 8999 "parser.y"
    {
      keyword_expected( L_as );
    }
#line 13232 "parser.c"
    break;

  case 945: /* as_into_to_exp: error  */
#line 9009 "parser.y"
    {
      elaborate_error( "\"as\", \"into\", or \"to\" expected" );
    }
#line 13240 "parser.c"
    break;

  case 950: /* auto_TYPE_exp: error  */
#line 9023 "parser.y"
    {
      keyword_expected( L_auto );
    }
#line 13248 "parser.c"
    break;

  case 952: /* binding_exp: error  */
#line 9031 "parser.y"
    {
      keyword_expected( L_binding );
    }
#line 13256 "parser.c"
    break;

  case 959: /* cast_exp: error  */
#line 9050 "parser.y"
    {
      keyword_expected( L_cast );
    }
#line 13264 "parser.c"
    break;

  case 961: /* char_exp: error  */
#line 9058 "parser.y"
    {
      keyword_expected( L_char );
    }
#line 13272 "parser.c"
    break;

  case 963: /* class_struct_union_btid_exp: error  */
#line 9066 "parser.y"
    {
      elaborate_error( "\"class\", \"struct\", or \"union\" expected" );
    }
#line 13280 "parser.c"
    break;

  case 965: /* colon_exp: error  */
#line 9074 "parser.y"
    {
      punct_expected( ':' );
    }
#line 13288 "parser.c"
    break;

  case 967: /* comma_exp: error  */
#line 9082 "parser.y"
    {
      punct_expected( ',' );
    }
#line 13296 "parser.c"
    break;

  case 969: /* conversion_exp: error  */
#line 9090 "parser.y"
    {
      keyword_expected( L_conversion );
    }
#line 13304 "parser.c"
    break;

  case 970: /* c_operator: Y_co_await  */
#line 9096 "parser.y"
                                  { (yyval.op_id) = C_OP_CO_AWAIT              ; }
#line 13310 "parser.c"
    break;

  case 971: /* c_operator: Y_new  */
#line 9097 "parser.y"
                                  { (yyval.op_id) = C_OP_NEW                   ; }
#line 13316 "parser.c"
    break;

  case 972: /* c_operator: Y_new '[' rbracket_exp  */
#line 9098 "parser.y"
                                  { (yyval.op_id) = C_OP_NEW_ARRAY             ; }
#line 13322 "parser.c"
    break;

  case 973: /* c_operator: Y_delete  */
#line 9099 "parser.y"
                                  { (yyval.op_id) = C_OP_DELETE                ; }
#line 13328 "parser.c"
    break;

  case 974: /* c_operator: Y_delete '[' rbracket_exp  */
#line 9100 "parser.y"
                                  { (yyval.op_id) = C_OP_DELETE_ARRAY          ; }
#line 13334 "parser.c"
    break;

  case 975: /* c_operator: '!'  */
#line 9101 "parser.y"
                                  { (yyval.op_id) = C_OP_EXCLAMATION           ; }
#line 13340 "parser.c"
    break;

  case 976: /* c_operator: Y_EXCLAM_EQUAL  */
#line 9102 "parser.y"
                                  { (yyval.op_id) = C_OP_EXCLAMATION_EQUAL     ; }
#line 13346 "parser.c"
    break;

  case 977: /* c_operator: '%'  */
#line 9103 "parser.y"
                                  { (yyval.op_id) = C_OP_PERCENT               ; }
#line 13352 "parser.c"
    break;

  case 978: /* c_operator: Y_PERCENT_EQUAL  */
#line 9104 "parser.y"
                                  { (yyval.op_id) = C_OP_PERCENT_EQUAL         ; }
#line 13358 "parser.c"
    break;

  case 979: /* c_operator: '&'  */
#line 9105 "parser.y"
                                  { (yyval.op_id) = C_OP_AMPERSAND             ; }
#line 13364 "parser.c"
    break;

  case 980: /* c_operator: Y_AMPER_AMPER  */
#line 9106 "parser.y"
                                  { (yyval.op_id) = C_OP_AMPERSAND_AMPERSAND   ; }
#line 13370 "parser.c"
    break;

  case 981: /* c_operator: Y_AMPER_EQUAL  */
#line 9107 "parser.y"
                                  { (yyval.op_id) = C_OP_AMPER_EQUAL           ; }
#line 13376 "parser.c"
    break;

  case 982: /* c_operator: '(' rparen_exp  */
#line 9108 "parser.y"
                                  { (yyval.op_id) = C_OP_PARENTHESES           ; }
#line 13382 "parser.c"
    break;

  case 983: /* c_operator: '*'  */
#line 9109 "parser.y"
                                  { (yyval.op_id) = C_OP_STAR                  ; }
#line 13388 "parser.c"
    break;

  case 984: /* c_operator: Y_STAR_EQUAL  */
#line 9110 "parser.y"
                                  { (yyval.op_id) = C_OP_STAR_EQUAL            ; }
#line 13394 "parser.c"
    break;

  case 985: /* c_operator: '+'  */
#line 9111 "parser.y"
                                  { (yyval.op_id) = C_OP_PLUS                  ; }
#line 13400 "parser.c"
    break;

  case 986: /* c_operator: "++"  */
#line 9112 "parser.y"
                                  { (yyval.op_id) = C_OP_PLUS_PLUS             ; }
#line 13406 "parser.c"
    break;

  case 987: /* c_operator: Y_PLUS_EQUAL  */
#line 9113 "parser.y"
                                  { (yyval.op_id) = C_OP_PLUS_EQUAL            ; }
#line 13412 "parser.c"
    break;

  case 988: /* c_operator: ','  */
#line 9114 "parser.y"
                                  { (yyval.op_id) = C_OP_COMMA                 ; }
#line 13418 "parser.c"
    break;

  case 989: /* c_operator: '-'  */
#line 9115 "parser.y"
                                  { (yyval.op_id) = C_OP_MINUS                 ; }
#line 13424 "parser.c"
    break;

  case 990: /* c_operator: "--"  */
#line 9116 "parser.y"
                                  { (yyval.op_id) = C_OP_MINUS_MINUS           ; }
#line 13430 "parser.c"
    break;

  case 991: /* c_operator: Y_MINUS_EQUAL  */
#line 9117 "parser.y"
                                  { (yyval.op_id) = C_OP_MINUS_EQUAL           ; }
#line 13436 "parser.c"
    break;

  case 992: /* c_operator: Y_MINUS_GREATER  */
#line 9118 "parser.y"
                                  { (yyval.op_id) = C_OP_MINUS_GREATER         ; }
#line 13442 "parser.c"
    break;

  case 993: /* c_operator: Y_MINUS_GREATER_STAR  */
#line 9119 "parser.y"
                                  { (yyval.op_id) = C_OP_MINUS_GREATER_STAR    ; }
#line 13448 "parser.c"
    break;

  case 994: /* c_operator: '.'  */
#line 9120 "parser.y"
                                  { (yyval.op_id) = C_OP_DOT                   ; }
#line 13454 "parser.c"
    break;

  case 995: /* c_operator: Y_DOT_STAR  */
#line 9121 "parser.y"
                                  { (yyval.op_id) = C_OP_DOT_STAR              ; }
#line 13460 "parser.c"
    break;

  case 996: /* c_operator: '/'  */
#line 9122 "parser.y"
                                  { (yyval.op_id) = C_OP_SLASH                 ; }
#line 13466 "parser.c"
    break;

  case 997: /* c_operator: Y_SLASH_EQUAL  */
#line 9123 "parser.y"
                                  { (yyval.op_id) = C_OP_SLASH_EQUAL           ; }
#line 13472 "parser.c"
    break;

  case 998: /* c_operator: Y_COLON_COLON  */
#line 9124 "parser.y"
                                  { (yyval.op_id) = C_OP_COLON_COLON           ; }
#line 13478 "parser.c"
    break;

  case 999: /* c_operator: '<'  */
#line 9125 "parser.y"
                                  { (yyval.op_id) = C_OP_LESS                  ; }
#line 13484 "parser.c"
    break;

  case 1000: /* c_operator: Y_LESS_LESS  */
#line 9126 "parser.y"
                                  { (yyval.op_id) = C_OP_LESS_LESS             ; }
#line 13490 "parser.c"
    break;

  case 1001: /* c_operator: Y_LESS_LESS_EQUAL  */
#line 9127 "parser.y"
                                  { (yyval.op_id) = C_OP_LESS_LESS_EQUAL       ; }
#line 13496 "parser.c"
    break;

  case 1002: /* c_operator: Y_LESS_EQUAL  */
#line 9128 "parser.y"
                                  { (yyval.op_id) = C_OP_LESS_EQUAL            ; }
#line 13502 "parser.c"
    break;

  case 1003: /* c_operator: Y_LESS_EQUAL_GREATER  */
#line 9129 "parser.y"
                                  { (yyval.op_id) = C_OP_LESS_EQUAL_GREATER    ; }
#line 13508 "parser.c"
    break;

  case 1004: /* c_operator: '='  */
#line 9130 "parser.y"
                                  { (yyval.op_id) = C_OP_EQUAL                 ; }
#line 13514 "parser.c"
    break;

  case 1005: /* c_operator: Y_EQUAL_EQUAL  */
#line 9131 "parser.y"
                                  { (yyval.op_id) = C_OP_EQUAL_EQUAL           ; }
#line 13520 "parser.c"
    break;

  case 1006: /* c_operator: '>'  */
#line 9132 "parser.y"
                                  { (yyval.op_id) = C_OP_GREATER               ; }
#line 13526 "parser.c"
    break;

  case 1007: /* c_operator: Y_GREATER_GREATER  */
#line 9133 "parser.y"
                                  { (yyval.op_id) = C_OP_GREATER_GREATER       ; }
#line 13532 "parser.c"
    break;

  case 1008: /* c_operator: Y_GREATER_GREATER_EQUAL  */
#line 9134 "parser.y"
                                  { (yyval.op_id) = C_OP_GREATER_GREATER_EQUAL ; }
#line 13538 "parser.c"
    break;

  case 1009: /* c_operator: Y_GREATER_EQUAL  */
#line 9135 "parser.y"
                                  { (yyval.op_id) = C_OP_GREATER_EQUAL         ; }
#line 13544 "parser.c"
    break;

  case 1010: /* c_operator: Y_QMARK_COLON  */
#line 9136 "parser.y"
                                  { (yyval.op_id) = C_OP_QUESTION_MARK_COLON   ; }
#line 13550 "parser.c"
    break;

  case 1011: /* c_operator: '[' rbracket_exp  */
#line 9137 "parser.y"
                                  { (yyval.op_id) = C_OP_BRACKETS              ; }
#line 13556 "parser.c"
    break;

  case 1012: /* c_operator: '^'  */
#line 9138 "parser.y"
                                  { (yyval.op_id) = C_OP_CARET                 ; }
#line 13562 "parser.c"
    break;

  case 1013: /* c_operator: Y_CARET_EQUAL  */
#line 9139 "parser.y"
                                  { (yyval.op_id) = C_OP_CARET_EQUAL           ; }
#line 13568 "parser.c"
    break;

  case 1014: /* c_operator: '|'  */
#line 9140 "parser.y"
                                  { (yyval.op_id) = C_OP_PIPE                  ; }
#line 13574 "parser.c"
    break;

  case 1015: /* c_operator: Y_PIPE_PIPE  */
#line 9141 "parser.y"
                                  { (yyval.op_id) = C_OP_PIPE_PIPE             ; }
#line 13580 "parser.c"
    break;

  case 1016: /* c_operator: Y_PIPE_EQUAL  */
#line 9142 "parser.y"
                                  { (yyval.op_id) = C_OP_PIPE_EQUAL            ; }
#line 13586 "parser.c"
    break;

  case 1017: /* c_operator: '~'  */
#line 9143 "parser.y"
                                  { (yyval.op_id) = C_OP_TILDE                 ; }
#line 13592 "parser.c"
    break;

  case 1019: /* default_exp: error  */
#line 9149 "parser.y"
    {
      keyword_expected( L_default );
    }
#line 13600 "parser.c"
    break;

  case 1021: /* defined_exp: error  */
#line 9157 "parser.y"
    {
      keyword_expected( L_defined );
    }
#line 13608 "parser.c"
    break;

  case 1023: /* dependency_exp: error  */
#line 9165 "parser.y"
    {
      keyword_expected( L_dependency );
    }
#line 13616 "parser.c"
    break;

  case 1025: /* destructor_sname: Y_LEXER_ERROR  */
#line 9173 "parser.y"
    {
      c_sname_init( &(yyval.sname) );
      PARSE_ABORT();
    }
#line 13625 "parser.c"
    break;

  case 1026: /* empty_str_lit_exp: str_lit_exp  */
#line 9181 "parser.y"
    { //
      // This check is done now in the parser rather than later in the AST so
      // we don't have to keep the string literal around.
      //
      bool const is_empty = (yyvsp[0].str_val) == NULL || (yyvsp[0].str_val)[0] == '\0';
      free( (yyvsp[0].str_val) );
      if ( !is_empty ) {
        print_error( &(yylsp[0]), "empty string literal expected\n" );
        PARSE_ABORT();
      }
    }
#line 13641 "parser.c"
    break;

  case 1028: /* equals_exp: error  */
#line 9197 "parser.y"
    {
      punct_expected( '=' );
    }
#line 13649 "parser.c"
    break;

  case 1029: /* extern_linkage_c_stid: Y_extern linkage_stid  */
#line 9203 "parser.y"
                                  { (yyval.tid) = (yyvsp[0].tid); }
#line 13655 "parser.c"
    break;

  case 1030: /* extern_linkage_c_stid: Y_extern linkage_stid '{'  */
#line 9205 "parser.y"
    {
      UNSUPPORTED( &(yylsp[0]), "scoped linkage declarations" );
    }
#line 13663 "parser.c"
    break;

  case 1031: /* extern_linkage_c_stid_opt: %empty  */
#line 9211 "parser.y"
                                  { (yyval.tid) = TS_NONE; }
#line 13669 "parser.c"
    break;

  case 1033: /* glob: Y_GLOB  */
#line 9217 "parser.y"
    {
      if ( !OPT_LANG_IS( SCOPED_NAMES ) && strchr( (yyvsp[0].name), ':' ) != NULL ) {
        print_error( &(yylsp[0]),
          "scoped names not supported%s\n",
          C_LANG_WHICH( SCOPED_NAMES )
        );
        free( (yyvsp[0].name) );
        PARSE_ABORT();
      }
      (yyval.name) = (yyvsp[0].name);
    }
#line 13685 "parser.c"
    break;

  case 1034: /* glob_opt: %empty  */
#line 9231 "parser.y"
                                  { (yyval.name) = NULL; }
#line 13691 "parser.c"
    break;

  case 1037: /* gt_exp: error  */
#line 9238 "parser.y"
    {
      punct_expected( '>' );
    }
#line 13699 "parser.c"
    break;

  case 1038: /* inline_stid_opt: %empty  */
#line 9244 "parser.y"
                                  { (yyval.tid) = TS_NONE; }
#line 13705 "parser.c"
    break;

  case 1041: /* int_exp: error  */
#line 9251 "parser.y"
    {
      elaborate_error( "\"int[eger]\" expected" );
    }
#line 13713 "parser.c"
    break;

  case 1043: /* lbracket_exp: error  */
#line 9259 "parser.y"
    {
      punct_expected( '[' );
    }
#line 13721 "parser.c"
    break;

  case 1045: /* literal_exp: error  */
#line 9267 "parser.y"
    {
      keyword_expected( L_literal );
    }
#line 13729 "parser.c"
    break;

  case 1047: /* local_exp: error  */
#line 9275 "parser.y"
    {
      keyword_expected( L_local );
    }
#line 13737 "parser.c"
    break;

  case 1049: /* lparen_exp: error  */
#line 9283 "parser.y"
    {
      punct_expected( '(' );
    }
#line 13745 "parser.c"
    break;

  case 1051: /* lt_exp: error  */
#line 9291 "parser.y"
    {
      punct_expected( '<' );
    }
#line 13753 "parser.c"
    break;

  case 1052: /* member_or_non_member_opt: %empty  */
#line 9297 "parser.y"
                                  { (yyval.member) = C_FUNC_UNSPECIFIED; }
#line 13759 "parser.c"
    break;

  case 1053: /* member_or_non_member_opt: Y_member  */
#line 9298 "parser.y"
                                  { (yyval.member) = C_FUNC_MEMBER     ; }
#line 13765 "parser.c"
    break;

  case 1054: /* member_or_non_member_opt: Y_non_member  */
#line 9299 "parser.y"
                                  { (yyval.member) = C_FUNC_NON_MEMBER ; }
#line 13771 "parser.c"
    break;

  case 1056: /* namespace_btid_exp: error  */
#line 9305 "parser.y"
    {
      keyword_expected( L_namespace );
    }
#line 13779 "parser.c"
    break;

  case 1057: /* namespace_type: Y_namespace  */
#line 9311 "parser.y"
                                  { (yyval.type) = C_TYPE_LIT_B( (yyvsp[0].tid) ); }
#line 13785 "parser.c"
    break;

  case 1058: /* namespace_type: Y_inline namespace_btid_exp  */
#line 9312 "parser.y"
                                  { (yyval.type) = C_TYPE_LIT( (yyvsp[0].tid), (yyvsp[-1].tid), TA_NONE ); }
#line 13791 "parser.c"
    break;

  case 1060: /* of_exp: error  */
#line 9318 "parser.y"
    {
      keyword_expected( L_of );
    }
#line 13799 "parser.c"
    break;

  case 1061: /* of_scope_english: Y_of scope_english_type_exp any_sname_c_exp  */
#line 9325 "parser.y"
    { //
      // Scoped names are supported only in C++.  (However, we always allow
      // them in configuration files.)
      //
      // This check is better to do now in the parser rather than later in the
      // AST because it has to be done in fewer places in the code plus gives a
      // better error location.
      //
      if ( !OPT_LANG_IS( SCOPED_NAMES ) ) {
        print_error( &(yylsp[-1]),
          "scoped names not supported%s\n",
          C_LANG_WHICH( SCOPED_NAMES )
        );
        c_sname_cleanup( &(yyvsp[0].sname) );
        PARSE_ABORT();
      }
      (yyval.sname) = c_sname_move( &(yyvsp[0].sname) );
      c_sname_local_data( &(yyval.sname) )->type = (yyvsp[-1].type);
    }
#line 13823 "parser.c"
    break;

  case 1062: /* of_scope_list_english: of_scope_list_english of_scope_english  */
#line 9348 "parser.y"
    {
      // "of scope X of scope Y" means Y::X
      (yyval.sname) = c_sname_move( &(yyvsp[0].sname) );
      c_sname_append_sname( &(yyval.sname), &(yyvsp[-1].sname) );
      c_sname_set_all_types( &(yyval.sname) );
      if ( !c_sname_check( &(yyval.sname), &(yylsp[-1]) ) ) {
        c_sname_cleanup( &(yyval.sname) );
        PARSE_ABORT();
      }
    }
#line 13838 "parser.c"
    break;

  case 1064: /* of_scope_list_english_opt: %empty  */
#line 9362 "parser.y"
                                  { c_sname_init( &(yyval.sname) ); }
#line 13844 "parser.c"
    break;

  case 1067: /* operator_exp: error  */
#line 9369 "parser.y"
    {
      keyword_expected( L_operator );
    }
#line 13852 "parser.c"
    break;

  case 1071: /* point_exp: error  */
#line 9382 "parser.y"
    {
      keyword_expected( L_point );
    }
#line 13860 "parser.c"
    break;

  case 1075: /* rbrace_exp: error  */
#line 9394 "parser.y"
    {
      punct_expected( '}' );
    }
#line 13868 "parser.c"
    break;

  case 1077: /* rbracket_exp: error  */
#line 9402 "parser.y"
    {
      punct_expected( ']' );
    }
#line 13876 "parser.c"
    break;

  case 1078: /* ref_qualifier_c_stid_opt: %empty  */
#line 9408 "parser.y"
                                  { (yyval.tid) = TS_NONE; }
#line 13882 "parser.c"
    break;

  case 1079: /* ref_qualifier_c_stid_opt: '&'  */
#line 9409 "parser.y"
                                  { (yyval.tid) = TS_REFERENCE; }
#line 13888 "parser.c"
    break;

  case 1080: /* ref_qualifier_c_stid_opt: Y_AMPER_AMPER  */
#line 9410 "parser.y"
                                  { (yyval.tid) = TS_RVALUE_REFERENCE; }
#line 13894 "parser.c"
    break;

  case 1082: /* reference_exp: error  */
#line 9416 "parser.y"
    {
      keyword_expected( L_reference );
    }
#line 13902 "parser.c"
    break;

  case 1086: /* returning_exp: error  */
#line 9429 "parser.y"
    {
      keyword_expected( L_returning );
    }
#line 13910 "parser.c"
    break;

  case 1088: /* rparen_exp: error  */
#line 9437 "parser.y"
    {
      punct_expected( ')' );
    }
#line 13918 "parser.c"
    break;

  case 1089: /* scope_english_type: class_struct_union_btid  */
#line 9443 "parser.y"
                                  { (yyval.type) = C_TYPE_LIT_B( (yyvsp[0].tid) ); }
#line 13924 "parser.c"
    break;

  case 1091: /* scope_english_type: Y_scope  */
#line 9445 "parser.y"
                                  { (yyval.type) = C_TYPE_LIT_B( TB_SCOPE ); }
#line 13930 "parser.c"
    break;

  case 1093: /* scope_english_type_exp: error  */
#line 9451 "parser.y"
    {
      elaborate_error(
        "\"class\", \"namespace\", \"scope\", \"struct\", or \"union\" expected"
      );
    }
#line 13940 "parser.c"
    break;

  case 1095: /* semi_exp: error  */
#line 9461 "parser.y"
    {
      punct_expected( ';' );
    }
#line 13948 "parser.c"
    break;

  case 1100: /* static_stid_opt: %empty  */
#line 9477 "parser.y"
                                  { (yyval.tid) = TS_NONE; }
#line 13954 "parser.c"
    break;

  case 1101: /* static_stid_opt: Y_static  */
#line 9478 "parser.y"
                                  { (yyval.tid) = TS_NON_EMPTY_ARRAY; }
#line 13960 "parser.c"
    break;

  case 1103: /* str_lit: Y_LEXER_ERROR  */
#line 9484 "parser.y"
    {
      (yyval.str_val) = NULL;
      PARSE_ABORT();
    }
#line 13969 "parser.c"
    break;

  case 1105: /* str_lit_exp: error  */
#line 9493 "parser.y"
    {
      (yyval.str_val) = NULL;
      elaborate_error( "string literal expected" );
    }
#line 13978 "parser.c"
    break;

  case 1107: /* this_exp: error  */
#line 9502 "parser.y"
    {
      keyword_expected( L_this );
    }
#line 13986 "parser.c"
    break;

  case 1108: /* this_stid_opt: %empty  */
#line 9508 "parser.y"
                                  { (yyval.tid) = TS_NONE; }
#line 13992 "parser.c"
    break;

  case 1111: /* to_exp: error  */
#line 9515 "parser.y"
    {
      keyword_expected( L_to );
    }
#line 14000 "parser.c"
    break;

  case 1114: /* typename_flag_opt: %empty  */
#line 9526 "parser.y"
                                  { (yyval.flag) = false; }
#line 14006 "parser.c"
    break;

  case 1115: /* typename_flag_opt: Y_typename  */
#line 9527 "parser.y"
                                  { (yyval.flag) = true; }
#line 14012 "parser.c"
    break;

  case 1116: /* uint_lit: Y_INT_LIT  */
#line 9532 "parser.y"
    {
      if ( (yyvsp[0].int_val) < 0 ) {
        //
        // This check is better to do now in the parser rather than later in
        // the AST because we can store the value as unsigned plus gives a
        // better error location.
        //
        print_error( &(yylsp[0]), "non-negative integer expected\n" );
        PARSE_ABORT();
      }
      (yyval.uint_val) = STATIC_CAST( unsigned, (yyvsp[0].int_val) );
    }
#line 14029 "parser.c"
    break;

  case 1118: /* uint_lit_exp: error  */
#line 9549 "parser.y"
    {
      elaborate_error( "integer literal expected" );
    }
#line 14037 "parser.c"
    break;

  case 1119: /* uint_lit_opt: %empty  */
#line 9555 "parser.y"
                                  { (yyval.uint_val) = 0; }
#line 14043 "parser.c"
    break;

  case 1122: /* unused_exp: error  */
#line 9562 "parser.y"
    {
      keyword_expected( L_unused );
    }
#line 14051 "parser.c"
    break;

  case 1126: /* virtual_stid_exp: error  */
#line 9575 "parser.y"
    {
      keyword_expected( L_virtual );
    }
#line 14059 "parser.c"
    break;

  case 1127: /* virtual_stid_opt: %empty  */
#line 9581 "parser.y"
                                  { (yyval.tid) = TS_NONE; }
#line 14065 "parser.c"
    break;


#line 14069 "parser.c"

      default: break;
    }
  /* User semantic actions sometimes alter yychar, and that requires
     that yytoken be updated with the new translation.  We take the
     approach of translating immediately before every use of yytoken.
     One alternative is translating here after every semantic action,
     but that translation would be missed if the semantic action invokes
     YYABORT, YYACCEPT, or YYERROR immediately after altering yychar or
     if it invokes YYBACKUP.  In the case of YYABORT or YYACCEPT, an
     incorrect destructor might then be invoked immediately.  In the
     case of YYERROR or YYBACKUP, subsequent parser actions might lead
     to an incorrect destructor call or verbose syntax error message
     before the lookahead is translated.  */
  YY_SYMBOL_PRINT ("-> $$ =", YY_CAST (yysymbol_kind_t, yyr1[yyn]), &yyval, &yyloc);

  YYPOPSTACK (yylen);
  yylen = 0;

  *++yyvsp = yyval;
  *++yylsp = yyloc;

  /* Now 'shift' the result of the reduction.  Determine what state
     that goes to, based on the state we popped back to and the rule
     number reduced by.  */
  {
    const int yylhs = yyr1[yyn] - YYNTOKENS;
    const int yyi = yypgoto[yylhs] + *yyssp;
    yystate = (0 <= yyi && yyi <= YYLAST && yycheck[yyi] == *yyssp
               ? yytable[yyi]
               : yydefgoto[yylhs]);
  }

  goto yynewstate;


/*--------------------------------------.
| yyerrlab -- here on detecting error.  |
`--------------------------------------*/
yyerrlab:
  /* Make sure we have latest lookahead translation.  See comments at
     user semantic actions for why this is necessary.  */
  yytoken = yychar == YYEMPTY ? YYSYMBOL_YYEMPTY : YYTRANSLATE (yychar);
  /* If not already recovering from an error, report this error.  */
  if (!yyerrstatus)
    {
      ++yynerrs;
      yyerror (YY_("syntax error"));
    }

  yyerror_range[1] = yylloc;
  if (yyerrstatus == 3)
    {
      /* If just tried and failed to reuse lookahead token after an
         error, discard it.  */

      if (yychar <= YYEOF)
        {
          /* Return failure if at end of input.  */
          if (yychar == YYEOF)
            YYABORT;
        }
      else
        {
          yydestruct ("Error: discarding",
                      yytoken, &yylval, &yylloc);
          yychar = YYEMPTY;
        }
    }

  /* Else will try to reuse lookahead token after shifting the error
     token.  */
  goto yyerrlab1;


/*---------------------------------------------------.
| yyerrorlab -- error raised explicitly by YYERROR.  |
`---------------------------------------------------*/
yyerrorlab:
  /* Pacify compilers when the user code never invokes YYERROR and the
     label yyerrorlab therefore never appears in user code.  */
  if (0)
    YYERROR;
  ++yynerrs;

  /* Do not reclaim the symbols of the rule whose action triggered
     this YYERROR.  */
  YYPOPSTACK (yylen);
  yylen = 0;
  YY_STACK_PRINT (yyss, yyssp);
  yystate = *yyssp;
  goto yyerrlab1;


/*-------------------------------------------------------------.
| yyerrlab1 -- common code for both syntax error and YYERROR.  |
`-------------------------------------------------------------*/
yyerrlab1:
  yyerrstatus = 3;      /* Each real token shifted decrements this.  */

  /* Pop stack until we find a state that shifts the error token.  */
  for (;;)
    {
      yyn = yypact[yystate];
      if (!yypact_value_is_default (yyn))
        {
          yyn += YYSYMBOL_YYerror;
          if (0 <= yyn && yyn <= YYLAST && yycheck[yyn] == YYSYMBOL_YYerror)
            {
              yyn = yytable[yyn];
              if (0 < yyn)
                break;
            }
        }

      /* Pop the current state because it cannot handle the error token.  */
      if (yyssp == yyss)
        YYABORT;

      yyerror_range[1] = *yylsp;
      yydestruct ("Error: popping",
                  YY_ACCESSING_SYMBOL (yystate), yyvsp, yylsp);
      YYPOPSTACK (1);
      yystate = *yyssp;
      YY_STACK_PRINT (yyss, yyssp);
    }

  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  *++yyvsp = yylval;
  YY_IGNORE_MAYBE_UNINITIALIZED_END

  yyerror_range[2] = yylloc;
  ++yylsp;
  YYLLOC_DEFAULT (*yylsp, yyerror_range, 2);

  /* Shift the error token.  */
  YY_SYMBOL_PRINT ("Shifting", YY_ACCESSING_SYMBOL (yyn), yyvsp, yylsp);

  yystate = yyn;
  goto yynewstate;


/*-------------------------------------.
| yyacceptlab -- YYACCEPT comes here.  |
`-------------------------------------*/
yyacceptlab:
  yyresult = 0;
  goto yyreturnlab;


/*-----------------------------------.
| yyabortlab -- YYABORT comes here.  |
`-----------------------------------*/
yyabortlab:
  yyresult = 1;
  goto yyreturnlab;


/*-----------------------------------------------------------.
| yyexhaustedlab -- YYNOMEM (memory exhaustion) comes here.  |
`-----------------------------------------------------------*/
yyexhaustedlab:
  yyerror (YY_("memory exhausted"));
  yyresult = 2;
  goto yyreturnlab;


/*----------------------------------------------------------.
| yyreturnlab -- parsing is finished, clean up and return.  |
`----------------------------------------------------------*/
yyreturnlab:
  if (yychar != YYEMPTY)
    {
      /* Make sure we have latest lookahead translation.  See comments at
         user semantic actions for why this is necessary.  */
      yytoken = YYTRANSLATE (yychar);
      yydestruct ("Cleanup: discarding lookahead",
                  yytoken, &yylval, &yylloc);
    }
  /* Do not reclaim the symbols of the rule whose action triggered
     this YYABORT or YYACCEPT.  */
  YYPOPSTACK (yylen);
  YY_STACK_PRINT (yyss, yyssp);
  while (yyssp != yyss)
    {
      yydestruct ("Cleanup: popping",
                  YY_ACCESSING_SYMBOL (+*yyssp), yyvsp, yylsp);
      YYPOPSTACK (1);
    }
#ifndef yyoverflow
  if (yyss != yyssa)
    YYSTACK_FREE (yyss);
#endif

  return yyresult;
}

#line 9585 "parser.y"


/// @endcond

// Re-enable warnings.
#ifdef __GNUC__
# pragma GCC diagnostic pop
#endif /* __GNUC__ */

/**
 * @addtogroup parser-group
 * @{
 */

////////// local functions ////////////////////////////////////////////////////

/**
 * Prints an additional parsing error message including a newline to standard
 * error that continues from where yyerror() left off.  Additionally:
 *
 * + If the printable_yytext() isn't NULL:
 *     + Checks to see if it's a keyword: if it is, mentions that it's a
 *       keyword in the error message.
 *     + May print "did you mean ...?" \a dym_kinds suggestions.
 *
 * + In debug mode, also prints the file & line where the function was called
 *   from as well as the ID of the lookahead token, if any.
 *
 * @note A newline _is_ printed.
 * @note This function isn't normally called directly; use the
 * #elaborate_error() or #elaborate_error_dym() macros instead.
 *
 * @param line The line number within this file where this function was called
 * from.
 * @param dym_kinds The bitwise-or of the kind(s) of things possibly meant.
 * @param format A `printf()` style format string.  It _must not_ end in a
 * newline since this function prints its own newline.
 * @param ... Arguments to print.
 *
 * @sa #elaborate_error()
 * @sa #elaborate_error_dym()
 * @sa l_keyword_expected()
 * @sa l_punct_expected()
 * @sa yyerror()
 */
PJL_PRINTF_LIKE_FUNC(3)
static void l_elaborate_error( int line, dym_kind_t dym_kinds,
                               char const *format, ... ) {
  assert( format != NULL );

  EPUTS( ": " );
  print_debug_file_line( __FILE__, line );

  char const *const error_token = printable_yytext();
  if ( print_error_token( error_token ) )
    EPUTS( ": " );

  va_list args;
  va_start( args, format );
  vfprintf( stderr, format, args );
  va_end( args );

  if ( error_token != NULL ) {
    print_error_token_is_a( error_token );
    print_suggestions( dym_kinds, error_token );
  }

  EPUTC( '\n' );
}

/**
 * Cleans up global parser data at program termination.
 */
static void parser_cleanup( void ) {
  c_ast_list_cleanup_gc( &typedef_ast_list );
}

/**
 * Prints \a token, quoted; if \ref opt_cdecl_debug `!=` #CDECL_DEBUG_NO, also
 * prints the look-ahead character within `[]`.
 *
 * @param token The error token to print, if any.
 * @return Returns `true` only if anything was printed.
 */
static bool print_error_token( char const *token ) {
  if ( token == NULL )
    return false;
  EPRINTF( "\"%s\"", token );
  if ( opt_cdecl_debug != CDECL_DEBUG_NO ) {
    // LCOV_EXCL_START
    switch ( yychar ) {
      case YYEMPTY:
        EPUTS( " [<EMPTY>]" );
        break;
      case YYEOF:
        EPUTS( " [<EOF>]" );
        break;
      case YYerror:
        EPUTS( " [<error>]" );
        break;
      case YYUNDEF:
        EPUTS( " [<UNDEF>]" );
        break;
      default:
        EPRINTF( isprint( yychar ) ? " ['%c']" : " [%d]", yychar );
    } // switch
    // LCOV_EXCL_STOP
  }
  return true;
}

////////// extern functions ///////////////////////////////////////////////////

void parser_init( void ) {
  ASSERT_RUN_ONCE();
  ATEXIT( &parser_cleanup );
}

bool yyparse_sn( char const *s, size_t s_len ) {
  assert( s != NULL );

  FILE *const s_file = fmemopen( CONST_CAST( void*, s ), s_len, "r" );
  PERROR_EXIT_IF( s_file == NULL, EX_IOERR );
  yyrestart( s_file );

  int const bison_rv = yyparse();
  fclose( s_file );
  if ( unlikely( bison_rv == 2 ) ) {
    //
    // Bison has already printed "memory exhausted" via yyerror() that doesn't
    // print a newline, so print one now.
    //
    // LCOV_EXCL_START
    EPUTC( '\n' );
    _Exit( EX_SOFTWARE );
    // LCOV_EXCL_STOP
  }

  return bison_rv == 0;
}

///////////////////////////////////////////////////////////////////////////////

/** @} */

/* vim:set et sw=2 ts=2: */
