#!/usr/bin/perl -w

use strict;

use constant N => 1024.0;
use constant K => 32.0;
use constant ITERATIONS => 100;

my $grandTotal = 0;

foreach my $iter (1 .. ITERATIONS) {
	my $tot = &iteration;
	$grandTotal += $tot;
	print "Ineffiency: " . (($tot - K)/K) . "\n";
}
print "Average: " . ((($grandTotal / ITERATIONS) - K) / K) . "\n";

sub iteration {
		my $unique = 0;
		my $total  = 0;

		while ($unique < K) {
			my $pick = int(rand() * N) + 1;
			$unique++ if ($pick > $unique);
			$total++;
		}
		return $total;
}

