import java.util.*;
import com.onionnetworks.fec.io.*;
import com.onionnetworks.util.*;
import java.io.*;

public class PacketPlacementIteratorTest {
    
    public static final int k = 32;
    public static final int n = 256;
    public static final int packetSize = 1024;

    public static void main(String[] args) throws Exception {
        for (int i=0;i<100;i++) {
            doIt(args);
            System.out.println(i);
        }
        System.out.println("All Good!");
        System.exit(0);
    }
    
    public static void doIt(String[] args) throws Exception {
        File sourceFile = new File(args[0]);
        FECParameters params = new FECParameters(k,n,packetSize,
                                                 (int) sourceFile.length());

        FECFile server = new FECFile(sourceFile,"r",params);
        FECFile client = new FECFile(new File(args[1]),"rw",params);
     
        int[] stripeOrder = new int[n];
        for (int i=0;i<stripeOrder.length;i++) {
            stripeOrder[i] = i;
        }
        Util.shuffle(stripeOrder);

        int[] indexes = new int[k];
        System.arraycopy(stripeOrder,0,indexes,0,k);
        
        /*for (int i=0;i<indexes.length;i++) {
            System.out.print(indexes[i]+",");
        }
        System.out.println();*/

        Buffer[] bufs = new Buffer[k];
        for (int i=0;i<k;i++) {
            bufs[i] = new Buffer(packetSize);
        }

        for (int i=0;i<params.getBlockCount();i++) {
            server.read(bufs,i,indexes);
            int l=0;
            for (int j=0;l<params.getUnexpandedPacketCount(i)-1;j++) {
                if (indexes[j] > k || 
                    indexes[j] < params.getUnexpandedPacketCount(i)) {
                    client.write(bufs[j],i,indexes[j]);
                    l++;
                }
            }
        }

        System.out.println("This test will hang");

        for (Iterator it = client.getPacketPlacement().iterator();
             it.hasNext();) {
            System.out.println("next="+it.next());
        }

        server.close();
        client.close();

        RandomAccessFile raf1 = new RandomAccessFile(sourceFile,"r");
        RandomAccessFile raf2 = new RandomAccessFile(new File(args[1]),"r");
        int b;
        while((b = raf1.read()) != -1) {
            if (b != raf2.read()) {
                System.out.println("Files not equal!");
                System.exit(0);
            }
        }
        
        raf1.close();
        raf2.close();
    }
}
            
                
                    
                    


    
        
        
