/*
 * Decompiled with CFR 0.152.
 */
package com.onionnetworks.util;

import com.onionnetworks.util.ExceptionEvent;
import com.onionnetworks.util.ExceptionHandler;
import com.onionnetworks.util.Tuple;
import com.onionnetworks.util.Util;
import java.lang.reflect.Method;
import java.util.EventListener;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;

public class ReflectiveEventDispatch
implements Runnable {
    public static final int DEFAULT_WARNING_TIME = 10;
    private Thread t;
    private HashMap methodCache = new HashMap();
    private HashMap listeners = new HashMap();
    private LinkedList eventQueue = new LinkedList();
    private ExceptionHandler handler;

    public void setPriority(int priority) {
        this.t.setPriority(priority);
    }

    public void setExceptionHandler(ExceptionHandler h) {
        this.handler = h;
    }

    public synchronized void addListener(Object source, EventListener el, String methodName) {
        this.addListener(source, el, new String[]{methodName});
    }

    public synchronized void addListener(Object source, EventListener el, String[] methodNames) {
        HashMap<String, HashSet<EventListener>> hm = (HashMap<String, HashSet<EventListener>>)this.listeners.get(source);
        if (hm == null) {
            hm = new HashMap<String, HashSet<EventListener>>();
            this.listeners.put(source, hm);
        }
        int i = 0;
        while (i < methodNames.length) {
            HashSet<EventListener> set = (HashSet<EventListener>)hm.get(methodNames[i]);
            if (set == null) {
                set = new HashSet<EventListener>();
                hm.put(methodNames[i], set);
            }
            set.add(el);
            ++i;
        }
    }

    public synchronized void removeListener(Object source, EventListener el, String methodName) {
        this.removeListener(source, el, new String[]{methodName});
    }

    public synchronized void removeListener(Object source, EventListener el, String[] methodNames) {
        HashMap hm = (HashMap)this.listeners.get(source);
        if (hm == null) {
            throw new IllegalArgumentException("Listener not registered.");
        }
        int i = 0;
        while (i < methodNames.length) {
            HashSet set = (HashSet)hm.get(methodNames[i]);
            if (set == null || !set.contains(el)) {
                throw new IllegalArgumentException("Listener not registered.");
            }
            set.remove(el);
            ++i;
        }
    }

    public synchronized void fire(EventObject ev, String methodName) {
        this.eventQueue.add(new Tuple(ev, methodName));
        this.notifyAll();
    }

    public synchronized void close() {
        this.eventQueue.add(this);
        this.notifyAll();
    }

    public void run() {
        boolean done = false;
        while (!done) {
            EventObject ev = null;
            String methodName = null;
            HashSet set = null;
            ReflectiveEventDispatch reflectiveEventDispatch = this;
            synchronized (reflectiveEventDispatch) {
                if (this.eventQueue.isEmpty()) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        done = true;
                    }
                    continue;
                }
                Object obj = this.eventQueue.removeFirst();
                if (obj == this) {
                    done = true;
                    continue;
                }
                Tuple t = (Tuple)obj;
                ev = (EventObject)t.getLeft();
                methodName = (String)t.getRight();
                HashMap hm = (HashMap)this.listeners.get(ev.getSource());
                if (hm == null) {
                    continue;
                }
                set = (HashSet)hm.get(methodName);
                if (set == null) {
                    continue;
                }
                set = (HashSet)set.clone();
            }
            Iterator it = set.iterator();
            while (it.hasNext()) {
                EventListener el = (EventListener)it.next();
                try {
                    Class<?> elc = el.getClass();
                    Class<?> evc = ev.getClass();
                    Tuple cacheKey = new Tuple(elc, new Tuple(methodName, evc));
                    Method m = (Method)this.methodCache.get(cacheKey);
                    if (m == null) {
                        Class[] ca = new Class[]{evc};
                        m = Util.getPublicMethod(elc, methodName, ca);
                        this.methodCache.put(cacheKey, m);
                    }
                    Object[] oa = new Object[]{ev};
                    m.invoke((Object)el, oa);
                }
                catch (Throwable t) {
                    if (this.handler != null) {
                        this.handler.handleException(new ExceptionEvent(this, t));
                        continue;
                    }
                    t.printStackTrace();
                }
            }
        }
    }

    public ReflectiveEventDispatch() {
        this.t = new Thread((Runnable)this, "Reflective Dispatch#" + this.hashCode());
        this.t.setDaemon(true);
        this.t.start();
    }
}

