/*
 * Decompiled with CFR 0.152.
 */
package eu.geekplace.sandmann;

import dev.dirs.ProjectDirectories;
import eu.geekplace.sandmann.Cli;
import eu.geekplace.sandmann.Configuration$;
import eu.geekplace.sandmann.Configuration$File$;
import eu.geekplace.sandmann.Configuration$TimeRange$;
import eu.geekplace.sandmann.Configuration$WakeupFromPoweroffMethod$;
import eu.geekplace.sandmann.package$package$;
import java.io.Serializable;
import java.time.DayOfWeek;
import java.time.Duration;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.spi.ExtendedLogger;
import org.rogach.scallop.ValueConverter;
import org.virtuslab.yaml.YamlDecoder;
import os.Path;
import os.PathChunk;
import os.PathChunk$;
import os.RelPath$;
import os.makeDir$all$;
import os.remove$;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.Some$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.reflect.Enum;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public class Configuration
implements Product,
Serializable {
    private final Cli cli;
    private final File file;
    private final Level logLevel;
    private final boolean debug;
    private final Option<Path> stateDir;
    private final Duration idleDuration;
    private final Duration checkInterval;
    private final boolean wakeupFromHibernationOrPoweroff;
    private final boolean hibernate;
    private final Duration hibernationDelay;

    public static Configuration apply(Cli cli, File file) {
        return Configuration$.MODULE$.apply(cli, file);
    }

    public static Configuration apply(Seq<String> seq) {
        return Configuration$.MODULE$.apply(seq);
    }

    public static Path defaultConfigurationFile() {
        return Configuration$.MODULE$.defaultConfigurationFile();
    }

    public static Path defaultStateDir() {
        return Configuration$.MODULE$.defaultStateDir();
    }

    public static Configuration fromProduct(Product product) {
        return Configuration$.MODULE$.fromProduct(product);
    }

    public static ExtendedLogger logger() {
        return Configuration$.MODULE$.logger();
    }

    public static ValueConverter<Path> osPathConverter() {
        return Configuration$.MODULE$.osPathConverter();
    }

    public static Configuration unapply(Configuration configuration) {
        return Configuration$.MODULE$.unapply(configuration);
    }

    public static ProjectDirectories xdgProjectDirs() {
        return Configuration$.MODULE$.xdgProjectDirs();
    }

    public static YamlDecoder<DayOfWeek> yamlDecoderForDayOfWeek() {
        return Configuration$.MODULE$.yamlDecoderForDayOfWeek();
    }

    public static YamlDecoder<Duration> yamlDecoderForDuration() {
        return Configuration$.MODULE$.yamlDecoderForDuration();
    }

    public static YamlDecoder<LocalTime> yamlDecoderForLocalTime() {
        return Configuration$.MODULE$.yamlDecoderForLocalTime();
    }

    public static YamlDecoder<Level> yamlDecoderForLogLevel() {
        return Configuration$.MODULE$.yamlDecoderForLogLevel();
    }

    public static YamlDecoder<Path> yamlDecoderForPath() {
        return Configuration$.MODULE$.yamlDecoderForPath();
    }

    public static YamlDecoder<TimeRange> yamlDecoderForTimeRange() {
        return Configuration$.MODULE$.yamlDecoderForTimeRange();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Configuration(Cli cli, File file) {
        Option option;
        this.cli = cli;
        this.file = file;
        int cliDebug = BoxesRunTime.unboxToInt(cli.debug().apply());
        this.logLevel = cliDebug >= 2 ? Level.TRACE : (cliDebug == 1 ? Level.DEBUG : (Level)file.logLevel().getOrElse(Configuration::$init$$$anonfun$1));
        this.debug = this.logLevel().isMoreSpecificThan(Level.DEBUG);
        None$ none$ = file.stateDir();
        if (None$.MODULE$.equals(none$)) {
            Path writeTestDir = Configuration$.MODULE$.defaultStateDir().$div(new PathChunk.RelPathChunk(RelPath$.MODULE$.fromStringSegments(PathChunk$.MODULE$.segmentsFromString(".writeTest"))));
            Try try_ = Try$.MODULE$.apply((Function0<Object> & Serializable)() -> {
                Configuration.$init$$$anonfun$2(writeTestDir);
                return BoxedUnit.UNIT;
            });
            if (try_ instanceof Success) {
                remove$.MODULE$.apply(writeTestDir);
                option = Some$.MODULE$.apply(Configuration$.MODULE$.defaultStateDir());
            } else {
                if (!(try_ instanceof Failure)) throw new MatchError(try_);
                option = None$.MODULE$;
            }
        } else {
            None$ x;
            option = x = none$;
        }
        this.stateDir = option;
        this.idleDuration = (Duration)file.idleDuration().getOrElse(Configuration::$init$$$anonfun$3);
        this.checkInterval = (Duration)file.checkInterval().getOrElse(Configuration::$init$$$anonfun$4);
        if (package$package$.MODULE$.longerThan(this.checkInterval(), Duration.ofMinutes(13L))) {
            throw new IllegalArgumentException("checkInterval must be no longer than 13 minutes");
        }
        this.wakeupFromHibernationOrPoweroff = BoxesRunTime.unboxToBoolean(file.wakeupFromHibernationOrPoweroff().getOrElse(Configuration::$init$$$anonfun$5));
        this.hibernate = BoxesRunTime.unboxToBoolean(file.hibernate().getOrElse(Configuration::$init$$$anonfun$6));
        this.hibernationDelay = (Duration)file.hibernationDelay().getOrElse(Configuration::$init$$$anonfun$7);
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode(this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof Configuration)) return false;
        Configuration configuration = (Configuration)object;
        Cli cli = this.cli();
        Cli cli2 = configuration.cli();
        if (cli == null) {
            if (cli2 != null) {
                return false;
            }
        } else if (!cli.equals(cli2)) return false;
        File file = this.file();
        File file2 = configuration.file();
        if (file == null) {
            if (file2 != null) {
                return false;
            }
        } else if (!((Object)file).equals(file2)) return false;
        if (!configuration.canEqual(this)) return false;
        return true;
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString(this);
    }

    @Override
    public boolean canEqual(Object that) {
        return that instanceof Configuration;
    }

    @Override
    public int productArity() {
        return 2;
    }

    @Override
    public String productPrefix() {
        return "Configuration";
    }

    @Override
    public Object productElement(int n) {
        int n2 = n;
        if (0 == n2) {
            return this._1();
        }
        if (1 == n2) {
            return this._2();
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
    }

    @Override
    public String productElementName(int n) {
        int n2 = n;
        if (0 == n2) {
            return "cli";
        }
        if (1 == n2) {
            return "file";
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
    }

    public Cli cli() {
        return this.cli;
    }

    public File file() {
        return this.file;
    }

    public Level logLevel() {
        return this.logLevel;
    }

    public boolean debug() {
        return this.debug;
    }

    public Option<Path> stateDir() {
        return this.stateDir;
    }

    public Duration idleDuration() {
        return this.idleDuration;
    }

    public Duration checkInterval() {
        return this.checkInterval;
    }

    public boolean wakeupFromHibernationOrPoweroff() {
        return this.wakeupFromHibernationOrPoweroff;
    }

    public boolean hibernate() {
        return this.hibernate;
    }

    public Duration hibernationDelay() {
        return this.hibernationDelay;
    }

    public Configuration copy(Cli cli, File file) {
        return new Configuration(cli, file);
    }

    public Cli copy$default$1() {
        return this.cli();
    }

    public File copy$default$2() {
        return this.file();
    }

    public Cli _1() {
        return this.cli();
    }

    public File _2() {
        return this.file();
    }

    private static final Level $init$$$anonfun$1() {
        return Level.INFO;
    }

    private static final void $init$$$anonfun$2(Path writeTestDir$1) {
        makeDir$all$.MODULE$.apply(writeTestDir$1);
    }

    private static final Duration $init$$$anonfun$3() {
        return Duration.ofMinutes(30L);
    }

    private static final Duration $init$$$anonfun$4() {
        return Duration.ofMinutes(3L);
    }

    private static final boolean $init$$$anonfun$5() {
        return true;
    }

    private static final boolean $init$$$anonfun$6() {
        return true;
    }

    private static final Duration $init$$$anonfun$7() {
        return Duration.ofHours(2L);
    }

    public static class File
    implements Product,
    Serializable {
        private final Option<Level> logLevel;
        private final Option<Path> stateDir;
        private final Option<Duration> idleDuration;
        private final Option<Duration> checkInterval;
        private final Option<List<String>> wakeupTimers;
        private final Option<LocalTime> wakeupTime;
        private final Option<Duration> wakeupTimeRandomizedDelay;
        private final Option<Set<DayOfWeek>> wakeupDaysOfWeek;
        private final Option<Object> wakeupFromHibernationOrPoweroff;
        private final Option<Object> hibernate;
        private final Option<TimeRange> hibernationTimeRange;
        private final Option<Duration> hibernationDelay;
        public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(Configuration$File$.class.getDeclaredField("derived$YamlDecoder$lzy1"));

        public static File apply(Option<Level> option, Option<Path> option2, Option<Duration> option3, Option<Duration> option4, Option<List<String>> option5, Option<LocalTime> option6, Option<Duration> option7, Option<Set<DayOfWeek>> option8, Option<Object> option9, Option<Object> option10, Option<TimeRange> option11, Option<Duration> option12) {
            return Configuration$File$.MODULE$.apply(option, option2, option3, option4, option5, option6, option7, option8, option9, option10, option11, option12);
        }

        public static YamlDecoder<File> derived$YamlDecoder() {
            return Configuration$File$.MODULE$.derived$YamlDecoder();
        }

        public static File fromProduct(Product product) {
            return Configuration$File$.MODULE$.fromProduct(product);
        }

        public static File unapply(File file) {
            return Configuration$File$.MODULE$.unapply(file);
        }

        public static Option<Level> $lessinit$greater$default$1() {
            return Configuration$File$.MODULE$.$lessinit$greater$default$1();
        }

        public static Option<Path> $lessinit$greater$default$2() {
            return Configuration$File$.MODULE$.$lessinit$greater$default$2();
        }

        public static Option<Duration> $lessinit$greater$default$3() {
            return Configuration$File$.MODULE$.$lessinit$greater$default$3();
        }

        public static Option<Duration> $lessinit$greater$default$4() {
            return Configuration$File$.MODULE$.$lessinit$greater$default$4();
        }

        public static Option<List<String>> $lessinit$greater$default$5() {
            return Configuration$File$.MODULE$.$lessinit$greater$default$5();
        }

        public static Option<LocalTime> $lessinit$greater$default$6() {
            return Configuration$File$.MODULE$.$lessinit$greater$default$6();
        }

        public static Option<Duration> $lessinit$greater$default$7() {
            return Configuration$File$.MODULE$.$lessinit$greater$default$7();
        }

        public static Option<Set<DayOfWeek>> $lessinit$greater$default$8() {
            return Configuration$File$.MODULE$.$lessinit$greater$default$8();
        }

        public static Option<Object> $lessinit$greater$default$9() {
            return Configuration$File$.MODULE$.$lessinit$greater$default$9();
        }

        public static Option<Object> $lessinit$greater$default$10() {
            return Configuration$File$.MODULE$.$lessinit$greater$default$10();
        }

        public static Option<TimeRange> $lessinit$greater$default$11() {
            return Configuration$File$.MODULE$.$lessinit$greater$default$11();
        }

        public static Option<Duration> $lessinit$greater$default$12() {
            return Configuration$File$.MODULE$.$lessinit$greater$default$12();
        }

        public File(Option<Level> logLevel, Option<Path> stateDir, Option<Duration> idleDuration, Option<Duration> checkInterval, Option<List<String>> wakeupTimers, Option<LocalTime> wakeupTime, Option<Duration> wakeupTimeRandomizedDelay, Option<Set<DayOfWeek>> wakeupDaysOfWeek, Option<Object> wakeupFromHibernationOrPoweroff, Option<Object> hibernate, Option<TimeRange> hibernationTimeRange, Option<Duration> hibernationDelay) {
            this.logLevel = logLevel;
            this.stateDir = stateDir;
            this.idleDuration = idleDuration;
            this.checkInterval = checkInterval;
            this.wakeupTimers = wakeupTimers;
            this.wakeupTime = wakeupTime;
            this.wakeupTimeRandomizedDelay = wakeupTimeRandomizedDelay;
            this.wakeupDaysOfWeek = wakeupDaysOfWeek;
            this.wakeupFromHibernationOrPoweroff = wakeupFromHibernationOrPoweroff;
            this.hibernate = hibernate;
            this.hibernationTimeRange = hibernationTimeRange;
            this.hibernationDelay = hibernationDelay;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode(this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof File)) return false;
            File file = (File)object;
            Option<Level> option = this.logLevel();
            Option<Level> option2 = file.logLevel();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            Option<Path> option3 = this.stateDir();
            Option<Path> option4 = file.stateDir();
            if (option3 == null) {
                if (option4 != null) {
                    return false;
                }
            } else if (!option3.equals(option4)) return false;
            Option<Duration> option5 = this.idleDuration();
            Option<Duration> option6 = file.idleDuration();
            if (option5 == null) {
                if (option6 != null) {
                    return false;
                }
            } else if (!option5.equals(option6)) return false;
            Option<Duration> option7 = this.checkInterval();
            Option<Duration> option8 = file.checkInterval();
            if (option7 == null) {
                if (option8 != null) {
                    return false;
                }
            } else if (!option7.equals(option8)) return false;
            Option<List<String>> option9 = this.wakeupTimers();
            Option<List<String>> option10 = file.wakeupTimers();
            if (option9 == null) {
                if (option10 != null) {
                    return false;
                }
            } else if (!option9.equals(option10)) return false;
            Option<LocalTime> option11 = this.wakeupTime();
            Option<LocalTime> option12 = file.wakeupTime();
            if (option11 == null) {
                if (option12 != null) {
                    return false;
                }
            } else if (!option11.equals(option12)) return false;
            Option<Duration> option13 = this.wakeupTimeRandomizedDelay();
            Option<Duration> option14 = file.wakeupTimeRandomizedDelay();
            if (option13 == null) {
                if (option14 != null) {
                    return false;
                }
            } else if (!option13.equals(option14)) return false;
            Option<Set<DayOfWeek>> option15 = this.wakeupDaysOfWeek();
            Option<Set<DayOfWeek>> option16 = file.wakeupDaysOfWeek();
            if (option15 == null) {
                if (option16 != null) {
                    return false;
                }
            } else if (!option15.equals(option16)) return false;
            Option<Object> option17 = this.wakeupFromHibernationOrPoweroff();
            Option<Object> option18 = file.wakeupFromHibernationOrPoweroff();
            if (option17 == null) {
                if (option18 != null) {
                    return false;
                }
            } else if (!option17.equals(option18)) return false;
            Option<Object> option19 = this.hibernate();
            Option<Object> option20 = file.hibernate();
            if (option19 == null) {
                if (option20 != null) {
                    return false;
                }
            } else if (!option19.equals(option20)) return false;
            Option<TimeRange> option21 = this.hibernationTimeRange();
            Option<TimeRange> option22 = file.hibernationTimeRange();
            if (option21 == null) {
                if (option22 != null) {
                    return false;
                }
            } else if (!option21.equals(option22)) return false;
            Option<Duration> option23 = this.hibernationDelay();
            Option<Duration> option24 = file.hibernationDelay();
            if (option23 == null) {
                if (option24 != null) {
                    return false;
                }
            } else if (!option23.equals(option24)) return false;
            if (!file.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString(this);
        }

        @Override
        public boolean canEqual(Object that) {
            return that instanceof File;
        }

        @Override
        public int productArity() {
            return 12;
        }

        @Override
        public String productPrefix() {
            return "File";
        }

        @Override
        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
                case 3: {
                    return this._4();
                }
                case 4: {
                    return this._5();
                }
                case 5: {
                    return this._6();
                }
                case 6: {
                    return this._7();
                }
                case 7: {
                    return this._8();
                }
                case 8: {
                    return this._9();
                }
                case 9: {
                    return this._10();
                }
                case 10: {
                    return this._11();
                }
                case 11: {
                    return this._12();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        @Override
        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "logLevel";
                }
                case 1: {
                    return "stateDir";
                }
                case 2: {
                    return "idleDuration";
                }
                case 3: {
                    return "checkInterval";
                }
                case 4: {
                    return "wakeupTimers";
                }
                case 5: {
                    return "wakeupTime";
                }
                case 6: {
                    return "wakeupTimeRandomizedDelay";
                }
                case 7: {
                    return "wakeupDaysOfWeek";
                }
                case 8: {
                    return "wakeupFromHibernationOrPoweroff";
                }
                case 9: {
                    return "hibernate";
                }
                case 10: {
                    return "hibernationTimeRange";
                }
                case 11: {
                    return "hibernationDelay";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        public Option<Level> logLevel() {
            return this.logLevel;
        }

        public Option<Path> stateDir() {
            return this.stateDir;
        }

        public Option<Duration> idleDuration() {
            return this.idleDuration;
        }

        public Option<Duration> checkInterval() {
            return this.checkInterval;
        }

        public Option<List<String>> wakeupTimers() {
            return this.wakeupTimers;
        }

        public Option<LocalTime> wakeupTime() {
            return this.wakeupTime;
        }

        public Option<Duration> wakeupTimeRandomizedDelay() {
            return this.wakeupTimeRandomizedDelay;
        }

        public Option<Set<DayOfWeek>> wakeupDaysOfWeek() {
            return this.wakeupDaysOfWeek;
        }

        public Option<Object> wakeupFromHibernationOrPoweroff() {
            return this.wakeupFromHibernationOrPoweroff;
        }

        public Option<Object> hibernate() {
            return this.hibernate;
        }

        public Option<TimeRange> hibernationTimeRange() {
            return this.hibernationTimeRange;
        }

        public Option<Duration> hibernationDelay() {
            return this.hibernationDelay;
        }

        public File copy(Option<Level> logLevel, Option<Path> stateDir, Option<Duration> idleDuration, Option<Duration> checkInterval, Option<List<String>> wakeupTimers, Option<LocalTime> wakeupTime, Option<Duration> wakeupTimeRandomizedDelay, Option<Set<DayOfWeek>> wakeupDaysOfWeek, Option<Object> wakeupFromHibernationOrPoweroff, Option<Object> hibernate, Option<TimeRange> hibernationTimeRange, Option<Duration> hibernationDelay) {
            return new File(logLevel, stateDir, idleDuration, checkInterval, wakeupTimers, wakeupTime, wakeupTimeRandomizedDelay, wakeupDaysOfWeek, wakeupFromHibernationOrPoweroff, hibernate, hibernationTimeRange, hibernationDelay);
        }

        public Option<Level> copy$default$1() {
            return this.logLevel();
        }

        public Option<Path> copy$default$2() {
            return this.stateDir();
        }

        public Option<Duration> copy$default$3() {
            return this.idleDuration();
        }

        public Option<Duration> copy$default$4() {
            return this.checkInterval();
        }

        public Option<List<String>> copy$default$5() {
            return this.wakeupTimers();
        }

        public Option<LocalTime> copy$default$6() {
            return this.wakeupTime();
        }

        public Option<Duration> copy$default$7() {
            return this.wakeupTimeRandomizedDelay();
        }

        public Option<Set<DayOfWeek>> copy$default$8() {
            return this.wakeupDaysOfWeek();
        }

        public Option<Object> copy$default$9() {
            return this.wakeupFromHibernationOrPoweroff();
        }

        public Option<Object> copy$default$10() {
            return this.hibernate();
        }

        public Option<TimeRange> copy$default$11() {
            return this.hibernationTimeRange();
        }

        public Option<Duration> copy$default$12() {
            return this.hibernationDelay();
        }

        public Option<Level> _1() {
            return this.logLevel();
        }

        public Option<Path> _2() {
            return this.stateDir();
        }

        public Option<Duration> _3() {
            return this.idleDuration();
        }

        public Option<Duration> _4() {
            return this.checkInterval();
        }

        public Option<List<String>> _5() {
            return this.wakeupTimers();
        }

        public Option<LocalTime> _6() {
            return this.wakeupTime();
        }

        public Option<Duration> _7() {
            return this.wakeupTimeRandomizedDelay();
        }

        public Option<Set<DayOfWeek>> _8() {
            return this.wakeupDaysOfWeek();
        }

        public Option<Object> _9() {
            return this.wakeupFromHibernationOrPoweroff();
        }

        public Option<Object> _10() {
            return this.hibernate();
        }

        public Option<TimeRange> _11() {
            return this.hibernationTimeRange();
        }

        public Option<Duration> _12() {
            return this.hibernationDelay();
        }
    }

    public static class TimeRange
    implements Product,
    Serializable {
        private final LocalTime start;
        private final LocalTime stop;
        private final boolean startIsBeforeStop;

        public static TimeRange apply(LocalTime localTime, LocalTime localTime2) {
            return Configuration$TimeRange$.MODULE$.apply(localTime, localTime2);
        }

        public static TimeRange fromProduct(Product product) {
            return Configuration$TimeRange$.MODULE$.fromProduct(product);
        }

        public static TimeRange unapply(TimeRange timeRange) {
            return Configuration$TimeRange$.MODULE$.unapply(timeRange);
        }

        public TimeRange(LocalTime start, LocalTime stop) {
            this.start = start;
            this.stop = stop;
            this.startIsBeforeStop = start.isBefore(stop);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode(this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof TimeRange)) return false;
            TimeRange timeRange = (TimeRange)object;
            LocalTime localTime = this.start();
            LocalTime localTime2 = timeRange.start();
            if (localTime == null) {
                if (localTime2 != null) {
                    return false;
                }
            } else if (!((Object)localTime).equals(localTime2)) return false;
            LocalTime localTime3 = this.stop();
            LocalTime localTime4 = timeRange.stop();
            if (localTime3 == null) {
                if (localTime4 != null) {
                    return false;
                }
            } else if (!((Object)localTime3).equals(localTime4)) return false;
            if (!timeRange.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString(this);
        }

        @Override
        public boolean canEqual(Object that) {
            return that instanceof TimeRange;
        }

        @Override
        public int productArity() {
            return 2;
        }

        @Override
        public String productPrefix() {
            return "TimeRange";
        }

        @Override
        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        @Override
        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "start";
            }
            if (1 == n2) {
                return "stop";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        public LocalTime start() {
            return this.start;
        }

        public LocalTime stop() {
            return this.stop;
        }

        public boolean startIsBeforeStop() {
            return this.startIsBeforeStop;
        }

        public boolean inTimeRange(OffsetDateTime time) {
            return this.inTimeRange(LocalTime.from(time));
        }

        public boolean inTimeRange(LocalTime time) {
            boolean afterStart = time.isAfter(this.start());
            boolean beforeStop = time.isBefore(this.stop());
            if (this.startIsBeforeStop()) {
                return afterStart && beforeStop;
            }
            return afterStart || beforeStop;
        }

        public TimeRange copy(LocalTime start, LocalTime stop) {
            return new TimeRange(start, stop);
        }

        public LocalTime copy$default$1() {
            return this.start();
        }

        public LocalTime copy$default$2() {
            return this.stop();
        }

        public LocalTime _1() {
            return this.start();
        }

        public LocalTime _2() {
            return this.stop();
        }
    }

    public static abstract class WakeupFromPoweroffMethod
    implements Product,
    Enum {
        public static WakeupFromPoweroffMethod fromOrdinal(int n) {
            return Configuration$WakeupFromPoweroffMethod$.MODULE$.fromOrdinal(n);
        }

        public static WakeupFromPoweroffMethod valueOf(String string2) {
            return Configuration$WakeupFromPoweroffMethod$.MODULE$.valueOf(string2);
        }

        public static WakeupFromPoweroffMethod[] values() {
            return Configuration$WakeupFromPoweroffMethod$.MODULE$.values();
        }
    }
}

