""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""
"" MochaLatte Vim Color Scheme
"" (C) Copyright 2014 Jeet Sukumaran
"" Released under the BSD License
""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""

" General Setup {{{1
set background=dark
hi clear
if exists("syntax_on")
  syntax reset
endif
let colors_name = "mochalatte"
" }}}1

" Code Setup {{{1
if !exists("g:did_mochalatte_code_setup")

    " Preamble {{{2
    let g:did_mochalatte_code_setup = 1
    let s:save_cpo = &cpo
    " }}}2

    " Dynamic Colors Base Definitions {{{2`
    let s:mochalatte_dynamic_colors = {}
    let s:mochalatte_dynamic_colors["Normal"]            = [ [0xdd, 0xd6, 0xc0], [], "guibg=#302a2a gui=NONE" ]
    let s:mochalatte_dynamic_colors["NonText"]           = [ [0x66, 0x60, 0x46], [], "guibg=bg gui=NONE" ]
    let s:mochalatte_dynamic_colors["Folded"]            = [ [0x88, 0x80, 0x78], [0x3c, 0x34, 0x34], "gui=italic" ]
    let s:mochalatte_dynamic_colors["Comment"]           = [ [0x70, 0x70, 0x70], [], "gui=italic" ]
    let s:mochalatte_dynamic_colors["Boolean"]           = [ [0xff, 0x98, 0x00], [], "gui=NONE" ]
    let s:mochalatte_dynamic_colors["String"]            = [ [0xaa, 0xaa, 0x99], [], "gui=NONE" ]
    let s:mochalatte_dynamic_colors["Identifier"]        = [ [0x99, 0x88, 0x77], [], "gui=NONE" ]
    let s:mochalatte_dynamic_colors["Function"]          = [ [0xdd, 0xcc, 0xa8], [], "gui=NONE" ]
    let s:mochalatte_dynamic_colors["Type"]              = [ [0x99, 0x66, 0x44], [], "gui=NONE" ]
    let s:mochalatte_dynamic_colors["Statement"]         = [ [0x90, 0x9a, 0x9f], [], "gui=NONE" ]
    let s:mochalatte_dynamic_colors["Keyword"]           = [ [0x90, 0x9a, 0x9f], [], "gui=NONE" ]
    let s:mochalatte_dynamic_colors["Constant"]          = [ [0xff, 0x98, 0x00], [], "gui=NONE" ]
    let s:mochalatte_dynamic_colors["Number"]            = [ [0xcc, 0x88, 0x00], [], "gui=NONE" ]
    let s:mochalatte_dynamic_colors["Special"]           = [ [0x71, 0x96, 0x11], [], "gui=NONE" ]
    let s:mochalatte_dynamic_colors["PreProc"]           = [ [0xbb, 0xaa, 0x88], [], "gui=NONE" ]
    let s:mochalatte_dynamic_colors["Title"]             = [ [0x77, 0x88, 0x88], [], "gui=NONE" ]
    let s:mochalatte_dynamic_colors["Todo"]              = [ [0x8f, 0x6f, 0x8f], [], "guibg=#202020   gui=italic,underline,bold" ]
    let s:mochalatte_dynamic_colors["pythonExClass"]     = [ [0x99, 0x76, 0x76], [], "guibg=NONE gui=NONE" ]
    let s:mochalatte_dynamic_colors["pythonDecorator"]   = [ [0x88, 0x77, 0x44], [], "guibg=NONE gui=NONE" ]
    " }}}2

    " Dynamic Colors State Tracking Variables {{{2
    let s:mochalatte_brightness_levels = range(-96, 96, 8)
    let s:mochalatte_brightness_level_max = len(s:mochalatte_brightness_levels) - 1
    let s:mochalatte_brightness_level_min = 0
    let s:mochalatte_default_brightness_level = index(s:mochalatte_brightness_levels, 0)
    let g:mochalatte_base_brightness_level = get(g:, 'mochalatte_base_brightness_level', s:mochalatte_default_brightness_level)
    let g:mochalatte_current_brightness_level = g:mochalatte_base_brightness_level
    " }}}2

    " Functions {{{2
    function! s:_mochalatte_change_brightness(step, up) "{{{3
        if empty(a:step)
            let l:level_step = 1
        else
            let l:level_step = a:step + 0
        endif
        if a:up
            let g:mochalatte_current_brightness_level += l:level_step
        else
            let g:mochalatte_current_brightness_level -= l:level_step
        endif
        call s:_mochalatte_validate_brightness_level()
        colorscheme mochalatte
    endfunction "}}}3

    function! s:_mochalatte_validate_brightness_level() "{{{3
        if g:mochalatte_current_brightness_level < s:mochalatte_brightness_level_min
            let g:mochalatte_current_brightness_level = s:mochalatte_brightness_level_min
        elseif g:mochalatte_current_brightness_level > s:mochalatte_brightness_level_max
            let g:mochalatte_current_brightness_level = s:mochalatte_brightness_level_max
        endif
    endfunction "}}}3

    function! s:_mochalatte_reset_brightness() "{{{3
        let g:mochalatte_current_brightness_level = g:mochalatte_base_brightness_level
        colorscheme mochalatte
    endfunction "}}}3

    function! s:_mochalatte_set_stable_colors() "{{{3
        """ Cursor {{{4
        hi Cursor           guifg=NONE      guibg=#626262   gui=NONE
        hi nCursor          guifg=black     guibg=green1    gui=NONE
        hi vCursor          guifg=black     guibg=magenta   gui=NONE
        hi iCursor          guifg=black     guibg=#f08080   gui=NONE
        hi cCursor          gui=reverse
        """ }}}4
        """ Cursor Line/Column {{{4
        hi CursorColumn     guibg=#000000
        hi CursorLine       guibg=#000000
        hi CursorLineNr     guifg=#ffee99 guibg=bg gui=none
        """ }}}4
        """ Structural {{{4
        hi LineNr           guifg=#807060   guibg=#000000   gui=NONE
        hi SignColumn       guifg=#333344   guibg=#363636   gui=NONE
        hi StatusLine       guifg=#000000   guibg=#9d9080   gui=bold
        hi StatusLineNC     guifg=#000000   guibg=#48403a   gui=italic
        hi VertSplit        guifg=#48403a   guibg=#48403a   gui=NONE
        hi FoldColumn       guifg=#68838b   guibg=#4B4B4B   gui=bold
        """ }}}4
        """ Tabs {{{4
        hi TabLine          guifg=fg        guibg=#d3d3d3   gui=underline
        hi TabLineFill      guifg=fg        guibg=bg        gui=reverse
        hi TabLineSel       guifg=fg        guibg=bg        gui=bold
        """ }}}4
        """ Search {{{4
        hi IncSearch        guifg=#000000   guibg=#ff8800   gui=BOLD
        hi Search           guifg=#000000   guibg=#ffffbb   gui=BOLD
        """ }}}4
        """ Selection {{{4
        hi Visual           guifg=#000000   guibg=#768798   gui=NONE
        """ }}}4
        """ Pop-up Menus {{{4
        hi Pmenu            guifg=#000000   guibg=#bbbaaa
        hi PmenuSel         guifg=#000000   guibg=#ee9944
        """ }}}4
        """ Messaging {{{4
        hi ModeMsg          guifg=#000000   guibg=#00ff00   gui=bold
        hi MoreMsg          guifg=#2e8b57   guibg=bg        gui=bold
        hi ErrorMsg         guifg=#ff6a6a   guibg=NONE      gui=bold
        hi WarningMsg       guifg=#ee9a00   guibg=bg        gui=NONE
        """ }}}4
        """ Spelling {{{4
        hi SpellBad         guisp=#ee2c2c   gui=undercurl
        hi SpellCap         guisp=#0000ff   gui=undercurl
        hi SpellLocal       guisp=#008b8b   gui=undercurl
        hi SpellRare        guisp=#ff00ff   gui=undercurl
        """ }}}4
        """ Diff {{{4
        hi DiffAdd          guifg=#000000   guibg=#3cb371   gui=NONE
        hi DiffDelete       guifg=#000000   guibg=#aa4450   gui=NONE
        hi DiffChange       guifg=#000000   guibg=#4f94cd   gui=NONE
        hi DiffText         guifg=#000000   guibg=#8ee5ee   gui=NONE
        hi diffOldFile      guifg=#88afcb   guibg=NONE      gui=italic
        hi diffNewFile      guifg=#88afcb   guibg=NONE      gui=italic
        hi diffFile         guifg=#88afcb   guibg=NONE      gui=italic
        hi diffLine         guifg=#88afcb   guibg=NONE      gui=italic
        hi link             diffSubname     diffLine
        hi diffAdded        guifg=#3cb371   guibg=NONE      gui=NONE
        hi diffRemoved      guifg=#aa4450   guibg=NONE      gui=NONE
        hi diffChanged      guifg=#4f94cd   guibg=NONE      gui=NONE
        hi link             diffOnly        Constant
        hi link             diffIdentical   Constant
        hi link             diffDiffer      Constant
        hi link             diffBDiffer     Constant
        hi link             diffIsA         Constant
        hi link             diffNoEOL       Constant
        hi link             diffCommon      Constant
        hi link             diffComment     Constant
        """ }}}4
        """ Other {{{4
        hi Directory        guifg=#ddaa66   guibg=bg        gui=NONE
        hi MatchParen       guifg=#fff000   guibg=bg        gui=bold
        hi SpecialKey       guifg=#cccc44   guibg=bg        gui=bold
        hi WildMenu         guifg=#000000   guibg=#87ceeb   gui=NONE
        """ Special Syntax {{{4
        hi link pythonDecoratorFunction pythonDecorator
        """ }}}4
    endfunction "}}}3

    function! s:_mochalatte_set_dynamic_colors() "{{{3
        call s:_mochalatte_validate_brightness_level()
        let brightness_boost = s:mochalatte_brightness_levels[g:mochalatte_current_brightness_level]
        for highlight_name in keys(s:mochalatte_dynamic_colors)
            let fg_rgb_list = copy(s:mochalatte_dynamic_colors[highlight_name][0])
            let bg_rgb_list = copy(s:mochalatte_dynamic_colors[highlight_name][1])
            let other = s:mochalatte_dynamic_colors[highlight_name][2]
            if !empty(fg_rgb_list)
                for idx in range(len(fg_rgb_list))
                    let c = fg_rgb_list[idx] + brightness_boost
                    if c > 255
                        let c = 255
                    elseif c < 0
                        let c = 0
                    endif
                    let fg_rgb_list[idx] = c
                endfor
                let fg = "guifg=#" . printf("%02x%02x%02x", fg_rgb_list[0], fg_rgb_list[1], fg_rgb_list[2])
            else
                let fg = ""
            endif
            if !empty(bg_rgb_list)
                for idx in range(len(bg_rgb_list))
                    let c = bg_rgb_list[idx] + brightness_boost
                    if c > 255
                        let c = 255
                    elseif c < 0
                        let c = 0
                    endif
                    let bg_rgb_list[idx] = c
                endfor
                let bg = "guibg=#" . printf("%02x%02x%02x", bg_rgb_list[0], bg_rgb_list[1], bg_rgb_list[2])
            else
                let bg = ""
            endif
            execute "highlight " . highlight_name . " " . fg . " " . bg . " " . other
        endfor
    endfunction "}}}3

    function! s:_mochalatte_set_colors() "{{{3
        call s:_mochalatte_set_stable_colors()
        call s:_mochalatte_set_dynamic_colors()
    endfunction "}}}3
    " }}}2

    " Epilogue {{{2
    let &cpo = s:save_cpo
    " }}}2

" }}}1

" Public Interface Setup {{{1

    " Commands {{{2
    command! -nargs=? MochalatteDarken :call <SID>_mochalatte_change_brightness(<q-args>, 0)
    command! -nargs=? MochalatteBrighten :call <SID>_mochalatte_change_brightness(<q-args>, 1)
    command! -nargs=0 MochalatteReset :call <SID>_mochalatte_reset_brightness()
    command! -nargs=0 MochalatteColors :call <SID>_mochalatte_set_colors()
    " }}}2

    " Key Maps {{{2
    nnoremap <silent> <Plug>MochalatteBrighten     :MochalatteBrighten<CR>
    nnoremap <silent> <Plug>MochalatteDarken       :MochalatteDarken<CR>
    nnoremap <silent> <Plug>MochalatteReset        :MochalatteReset<CR>
    nnoremap <silent> <Plug>MochalatteColors       :MochalatteColors<CR>
    if !exists('g:mochalatte_suppress_keymaps') || !g:mochalatte_suppress_keymaps
        map <silent> <M-1>  <Plug>MochalatteDarken
        map <silent> <M-2>  <Plug>MochalatteBrighten
        map <silent> <M-0>  <Plug>MochalatteReset
    endif
    " }}}2

endif
" }}}1

" Set Colors {{{1
:MochalatteColors
" }}}1

" Clean Up {{{1
" Set background again -- for some reason, this does not always 'take
set background=dark
" }}}1
