/*
 * Copyright 2011-2021 Blender Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License
 *
 * Modifications made by Advanced Micro Devices, Inc.:
 * Copyright(C) 2019-2024 Advanced Micro Devices, Inc. All rights reserved.
 *
 * The modifications include updates to maintain an up-to-date API,
 * enhancing compatibility in response to evolving technical standards.
 * These changes are designed to augment the original work by the Blender Foundation,
 * ensuring the software remains relevant and efficient for its intended applications.
 *
 * The modified software is provided under the Apache License, Version 2.0.
 * For more details, see the License above.
 */

#ifdef _MSC_VER
#  if _MSC_VER < 1900
#    define snprintf _snprintf
#  endif
#  define popen _popen
#  define pclose _pclose
#if !defined(_CRT_SECURE_NO_WARNINGS)
#  define _CRT_SECURE_NO_WARNINGS
#endif
#endif

#include <contrib/hipew/include/hipew.h>
#include <assert.h>
#include <stdio.h>
#include <string.h>
#include <sys/stat.h>

#ifdef _WIN32
#  define WIN32_LEAN_AND_MEAN
#  define VC_EXTRALEAN
#  include <windows.h>

/* Utility macros. */

typedef HMODULE DynamicLibrary;

#  define dynamic_library_open(path)         LoadLibraryA(path)
#  define dynamic_library_close(lib)         FreeLibrary(lib)
#  define dynamic_library_find(lib, symbol)  GetProcAddress(lib, symbol)
#else
#  include <dlfcn.h>

typedef void* DynamicLibrary;

#  define dynamic_library_open(path)         dlopen(path, RTLD_NOW)
#  define dynamic_library_close(lib)         dlclose(lib)
#  define dynamic_library_find(lib, symbol)  dlsym(lib, symbol)
#endif

#define _LIBRARY_FIND_CHECKED(lib, name) \
        name = (t##name *)dynamic_library_find(lib, #name); \
        assert(name);

#define _LIBRARY_FIND(lib, name) \
        name = (t##name *)dynamic_library_find(lib, #name);


static DynamicLibrary hip_lib = NULL;
static DynamicLibrary hiprtc_lib = NULL;


#pragma region OROCHI_SUMMONER_REGION_hipew_cpp_1

/////
///// THIS REGION HAS BEEN AUTOMATICALLY GENERATED BY OROCHI SUMMONER.
///// Manual modification of this region is not recommended.
/////

t__hipPopCallConfiguration *__hipPopCallConfiguration = nullptr;
t__hipPushCallConfiguration *__hipPushCallConfiguration = nullptr;
thipApiName *hipApiName = nullptr;
thipArray3DCreate *hipArray3DCreate = nullptr;
thipArray3DGetDescriptor *hipArray3DGetDescriptor = nullptr;
thipArrayCreate *hipArrayCreate = nullptr;
thipArrayDestroy *hipArrayDestroy = nullptr;
thipArrayGetDescriptor *hipArrayGetDescriptor = nullptr;
thipArrayGetInfo *hipArrayGetInfo = nullptr;
thipBindTexture *hipBindTexture = nullptr;
thipBindTexture2D *hipBindTexture2D = nullptr;
thipBindTextureToArray *hipBindTextureToArray = nullptr;
thipBindTextureToMipmappedArray *hipBindTextureToMipmappedArray = nullptr;
thipChooseDeviceR0600 *hipChooseDeviceR0600 = nullptr;
thipConfigureCall *hipConfigureCall = nullptr;
thipCreateChannelDesc *hipCreateChannelDesc = nullptr;
thipCreateSurfaceObject *hipCreateSurfaceObject = nullptr;
thipCreateTextureObject *hipCreateTextureObject = nullptr;
thipCtxCreate *hipCtxCreate = nullptr;
thipCtxDestroy *hipCtxDestroy = nullptr;
thipCtxDisablePeerAccess *hipCtxDisablePeerAccess = nullptr;
thipCtxEnablePeerAccess *hipCtxEnablePeerAccess = nullptr;
thipCtxGetApiVersion *hipCtxGetApiVersion = nullptr;
thipCtxGetCacheConfig *hipCtxGetCacheConfig = nullptr;
thipCtxGetCurrent *hipCtxGetCurrent = nullptr;
thipCtxGetDevice *hipCtxGetDevice = nullptr;
thipCtxGetFlags *hipCtxGetFlags = nullptr;
thipCtxGetSharedMemConfig *hipCtxGetSharedMemConfig = nullptr;
thipCtxPopCurrent *hipCtxPopCurrent = nullptr;
thipCtxPushCurrent *hipCtxPushCurrent = nullptr;
thipCtxSetCacheConfig *hipCtxSetCacheConfig = nullptr;
thipCtxSetCurrent *hipCtxSetCurrent = nullptr;
thipCtxSetSharedMemConfig *hipCtxSetSharedMemConfig = nullptr;
thipCtxSynchronize *hipCtxSynchronize = nullptr;
thipDestroyExternalMemory *hipDestroyExternalMemory = nullptr;
thipDestroyExternalSemaphore *hipDestroyExternalSemaphore = nullptr;
thipDestroySurfaceObject *hipDestroySurfaceObject = nullptr;
thipDestroyTextureObject *hipDestroyTextureObject = nullptr;
thipDeviceCanAccessPeer *hipDeviceCanAccessPeer = nullptr;
thipDeviceComputeCapability *hipDeviceComputeCapability = nullptr;
thipDeviceDisablePeerAccess *hipDeviceDisablePeerAccess = nullptr;
thipDeviceEnablePeerAccess *hipDeviceEnablePeerAccess = nullptr;
thipDeviceGet *hipDeviceGet = nullptr;
thipDeviceGetAttribute *hipDeviceGetAttribute = nullptr;
thipDeviceGetByPCIBusId *hipDeviceGetByPCIBusId = nullptr;
thipDeviceGetCacheConfig *hipDeviceGetCacheConfig = nullptr;
thipDeviceGetDefaultMemPool *hipDeviceGetDefaultMemPool = nullptr;
thipDeviceGetGraphMemAttribute *hipDeviceGetGraphMemAttribute = nullptr;
thipDeviceGetLimit *hipDeviceGetLimit = nullptr;
thipDeviceGetMemPool *hipDeviceGetMemPool = nullptr;
thipDeviceGetName *hipDeviceGetName = nullptr;
thipDeviceGetP2PAttribute *hipDeviceGetP2PAttribute = nullptr;
thipDeviceGetPCIBusId *hipDeviceGetPCIBusId = nullptr;
thipDeviceGetSharedMemConfig *hipDeviceGetSharedMemConfig = nullptr;
thipDeviceGetStreamPriorityRange *hipDeviceGetStreamPriorityRange = nullptr;
thipDeviceGetUuid *hipDeviceGetUuid = nullptr;
thipDeviceGraphMemTrim *hipDeviceGraphMemTrim = nullptr;
thipDevicePrimaryCtxGetState *hipDevicePrimaryCtxGetState = nullptr;
thipDevicePrimaryCtxRelease *hipDevicePrimaryCtxRelease = nullptr;
thipDevicePrimaryCtxReset *hipDevicePrimaryCtxReset = nullptr;
thipDevicePrimaryCtxRetain *hipDevicePrimaryCtxRetain = nullptr;
thipDevicePrimaryCtxSetFlags *hipDevicePrimaryCtxSetFlags = nullptr;
thipDeviceReset *hipDeviceReset = nullptr;
thipDeviceSetCacheConfig *hipDeviceSetCacheConfig = nullptr;
thipDeviceSetGraphMemAttribute *hipDeviceSetGraphMemAttribute = nullptr;
thipDeviceSetLimit *hipDeviceSetLimit = nullptr;
thipDeviceSetMemPool *hipDeviceSetMemPool = nullptr;
thipDeviceSetSharedMemConfig *hipDeviceSetSharedMemConfig = nullptr;
thipDeviceSynchronize *hipDeviceSynchronize = nullptr;
thipDeviceTotalMem *hipDeviceTotalMem = nullptr;
thipDriverGetVersion *hipDriverGetVersion = nullptr;
thipDrvGetErrorName *hipDrvGetErrorName = nullptr;
thipDrvGetErrorString *hipDrvGetErrorString = nullptr;
thipDrvGraphAddMemcpyNode *hipDrvGraphAddMemcpyNode = nullptr;
thipDrvMemcpy2DUnaligned *hipDrvMemcpy2DUnaligned = nullptr;
thipDrvMemcpy3D *hipDrvMemcpy3D = nullptr;
thipDrvMemcpy3DAsync *hipDrvMemcpy3DAsync = nullptr;
thipDrvPointerGetAttributes *hipDrvPointerGetAttributes = nullptr;
thipEventCreate *hipEventCreate = nullptr;
thipEventCreateWithFlags *hipEventCreateWithFlags = nullptr;
thipEventDestroy *hipEventDestroy = nullptr;
thipEventElapsedTime *hipEventElapsedTime = nullptr;
thipEventQuery *hipEventQuery = nullptr;
thipEventRecord *hipEventRecord = nullptr;
thipEventRecord_spt *hipEventRecord_spt = nullptr;
thipEventSynchronize *hipEventSynchronize = nullptr;
thipExtGetLastError *hipExtGetLastError = nullptr;
thipExtGetLinkTypeAndHopCount *hipExtGetLinkTypeAndHopCount = nullptr;
thipExtLaunchKernel *hipExtLaunchKernel = nullptr;
thipExtLaunchMultiKernelMultiDevice *hipExtLaunchMultiKernelMultiDevice = nullptr;
thipExtMallocWithFlags *hipExtMallocWithFlags = nullptr;
thipExtStreamCreateWithCUMask *hipExtStreamCreateWithCUMask = nullptr;
thipExtStreamGetCUMask *hipExtStreamGetCUMask = nullptr;
thipExternalMemoryGetMappedBuffer *hipExternalMemoryGetMappedBuffer = nullptr;
thipExternalMemoryGetMappedMipmappedArray *hipExternalMemoryGetMappedMipmappedArray = nullptr;
thipFree *hipFree = nullptr;
thipFreeArray *hipFreeArray = nullptr;
thipFreeAsync *hipFreeAsync = nullptr;
thipFreeHost *hipFreeHost = nullptr;
thipFreeMipmappedArray *hipFreeMipmappedArray = nullptr;
thipFuncGetAttribute *hipFuncGetAttribute = nullptr;
thipFuncGetAttributes *hipFuncGetAttributes = nullptr;
thipFuncSetAttribute *hipFuncSetAttribute = nullptr;
thipFuncSetCacheConfig *hipFuncSetCacheConfig = nullptr;
thipFuncSetSharedMemConfig *hipFuncSetSharedMemConfig = nullptr;
thipGetChannelDesc *hipGetChannelDesc = nullptr;
thipGetDevice *hipGetDevice = nullptr;
thipGetDeviceCount *hipGetDeviceCount = nullptr;
thipGetDeviceFlags *hipGetDeviceFlags = nullptr;
thipGetDevicePropertiesR0600 *hipGetDevicePropertiesR0600 = nullptr;
thipGetErrorName *hipGetErrorName = nullptr;
thipGetErrorString *hipGetErrorString = nullptr;
thipGetLastError *hipGetLastError = nullptr;
thipGetMipmappedArrayLevel *hipGetMipmappedArrayLevel = nullptr;
thipGetStreamDeviceId *hipGetStreamDeviceId = nullptr;
thipGetSymbolAddress *hipGetSymbolAddress = nullptr;
thipGetSymbolSize *hipGetSymbolSize = nullptr;
thipGetTextureAlignmentOffset *hipGetTextureAlignmentOffset = nullptr;
thipGetTextureObjectResourceDesc *hipGetTextureObjectResourceDesc = nullptr;
thipGetTextureObjectResourceViewDesc *hipGetTextureObjectResourceViewDesc = nullptr;
thipGetTextureObjectTextureDesc *hipGetTextureObjectTextureDesc = nullptr;
thipGetTextureReference *hipGetTextureReference = nullptr;
thipGraphAddChildGraphNode *hipGraphAddChildGraphNode = nullptr;
thipGraphAddDependencies *hipGraphAddDependencies = nullptr;
thipGraphAddEmptyNode *hipGraphAddEmptyNode = nullptr;
thipGraphAddEventRecordNode *hipGraphAddEventRecordNode = nullptr;
thipGraphAddEventWaitNode *hipGraphAddEventWaitNode = nullptr;
thipGraphAddHostNode *hipGraphAddHostNode = nullptr;
thipGraphAddKernelNode *hipGraphAddKernelNode = nullptr;
thipGraphAddMemAllocNode *hipGraphAddMemAllocNode = nullptr;
thipGraphAddMemFreeNode *hipGraphAddMemFreeNode = nullptr;
thipGraphAddMemcpyNode *hipGraphAddMemcpyNode = nullptr;
thipGraphAddMemcpyNode1D *hipGraphAddMemcpyNode1D = nullptr;
thipGraphAddMemcpyNodeFromSymbol *hipGraphAddMemcpyNodeFromSymbol = nullptr;
thipGraphAddMemcpyNodeToSymbol *hipGraphAddMemcpyNodeToSymbol = nullptr;
thipGraphAddMemsetNode *hipGraphAddMemsetNode = nullptr;
thipGraphChildGraphNodeGetGraph *hipGraphChildGraphNodeGetGraph = nullptr;
thipGraphClone *hipGraphClone = nullptr;
thipGraphCreate *hipGraphCreate = nullptr;
thipGraphDebugDotPrint *hipGraphDebugDotPrint = nullptr;
thipGraphDestroy *hipGraphDestroy = nullptr;
thipGraphDestroyNode *hipGraphDestroyNode = nullptr;
thipGraphEventRecordNodeGetEvent *hipGraphEventRecordNodeGetEvent = nullptr;
thipGraphEventRecordNodeSetEvent *hipGraphEventRecordNodeSetEvent = nullptr;
thipGraphEventWaitNodeGetEvent *hipGraphEventWaitNodeGetEvent = nullptr;
thipGraphEventWaitNodeSetEvent *hipGraphEventWaitNodeSetEvent = nullptr;
thipGraphExecChildGraphNodeSetParams *hipGraphExecChildGraphNodeSetParams = nullptr;
thipGraphExecDestroy *hipGraphExecDestroy = nullptr;
thipGraphExecEventRecordNodeSetEvent *hipGraphExecEventRecordNodeSetEvent = nullptr;
thipGraphExecEventWaitNodeSetEvent *hipGraphExecEventWaitNodeSetEvent = nullptr;
thipGraphExecHostNodeSetParams *hipGraphExecHostNodeSetParams = nullptr;
thipGraphExecKernelNodeSetParams *hipGraphExecKernelNodeSetParams = nullptr;
thipGraphExecMemcpyNodeSetParams *hipGraphExecMemcpyNodeSetParams = nullptr;
thipGraphExecMemcpyNodeSetParams1D *hipGraphExecMemcpyNodeSetParams1D = nullptr;
thipGraphExecMemcpyNodeSetParamsFromSymbol *hipGraphExecMemcpyNodeSetParamsFromSymbol = nullptr;
thipGraphExecMemcpyNodeSetParamsToSymbol *hipGraphExecMemcpyNodeSetParamsToSymbol = nullptr;
thipGraphExecMemsetNodeSetParams *hipGraphExecMemsetNodeSetParams = nullptr;
thipGraphExecUpdate *hipGraphExecUpdate = nullptr;
thipGraphGetEdges *hipGraphGetEdges = nullptr;
thipGraphGetNodes *hipGraphGetNodes = nullptr;
thipGraphGetRootNodes *hipGraphGetRootNodes = nullptr;
thipGraphHostNodeGetParams *hipGraphHostNodeGetParams = nullptr;
thipGraphHostNodeSetParams *hipGraphHostNodeSetParams = nullptr;
thipGraphInstantiate *hipGraphInstantiate = nullptr;
thipGraphInstantiateWithFlags *hipGraphInstantiateWithFlags = nullptr;
thipGraphKernelNodeCopyAttributes *hipGraphKernelNodeCopyAttributes = nullptr;
thipGraphKernelNodeGetAttribute *hipGraphKernelNodeGetAttribute = nullptr;
thipGraphKernelNodeGetParams *hipGraphKernelNodeGetParams = nullptr;
thipGraphKernelNodeSetAttribute *hipGraphKernelNodeSetAttribute = nullptr;
thipGraphKernelNodeSetParams *hipGraphKernelNodeSetParams = nullptr;
thipGraphLaunch *hipGraphLaunch = nullptr;
thipGraphLaunch_spt *hipGraphLaunch_spt = nullptr;
thipGraphMemAllocNodeGetParams *hipGraphMemAllocNodeGetParams = nullptr;
thipGraphMemFreeNodeGetParams *hipGraphMemFreeNodeGetParams = nullptr;
thipGraphMemcpyNodeGetParams *hipGraphMemcpyNodeGetParams = nullptr;
thipGraphMemcpyNodeSetParams *hipGraphMemcpyNodeSetParams = nullptr;
thipGraphMemcpyNodeSetParams1D *hipGraphMemcpyNodeSetParams1D = nullptr;
thipGraphMemcpyNodeSetParamsFromSymbol *hipGraphMemcpyNodeSetParamsFromSymbol = nullptr;
thipGraphMemcpyNodeSetParamsToSymbol *hipGraphMemcpyNodeSetParamsToSymbol = nullptr;
thipGraphMemsetNodeGetParams *hipGraphMemsetNodeGetParams = nullptr;
thipGraphMemsetNodeSetParams *hipGraphMemsetNodeSetParams = nullptr;
thipGraphNodeFindInClone *hipGraphNodeFindInClone = nullptr;
thipGraphNodeGetDependencies *hipGraphNodeGetDependencies = nullptr;
thipGraphNodeGetDependentNodes *hipGraphNodeGetDependentNodes = nullptr;
thipGraphNodeGetEnabled *hipGraphNodeGetEnabled = nullptr;
thipGraphNodeGetType *hipGraphNodeGetType = nullptr;
thipGraphNodeSetEnabled *hipGraphNodeSetEnabled = nullptr;
thipGraphReleaseUserObject *hipGraphReleaseUserObject = nullptr;
thipGraphRemoveDependencies *hipGraphRemoveDependencies = nullptr;
thipGraphRetainUserObject *hipGraphRetainUserObject = nullptr;
thipGraphUpload *hipGraphUpload = nullptr;
thipGraphicsMapResources *hipGraphicsMapResources = nullptr;
thipGraphicsResourceGetMappedPointer *hipGraphicsResourceGetMappedPointer = nullptr;
thipGraphicsSubResourceGetMappedArray *hipGraphicsSubResourceGetMappedArray = nullptr;
thipGraphicsUnmapResources *hipGraphicsUnmapResources = nullptr;
thipGraphicsUnregisterResource *hipGraphicsUnregisterResource = nullptr;
thipHostAlloc *hipHostAlloc = nullptr;
thipHostFree *hipHostFree = nullptr;
thipHostGetDevicePointer *hipHostGetDevicePointer = nullptr;
thipHostGetFlags *hipHostGetFlags = nullptr;
thipHostMalloc *hipHostMalloc = nullptr;
thipHostRegister *hipHostRegister = nullptr;
thipHostUnregister *hipHostUnregister = nullptr;
thipImportExternalMemory *hipImportExternalMemory = nullptr;
thipImportExternalSemaphore *hipImportExternalSemaphore = nullptr;
thipInit *hipInit = nullptr;
thipIpcCloseMemHandle *hipIpcCloseMemHandle = nullptr;
thipIpcGetEventHandle *hipIpcGetEventHandle = nullptr;
thipIpcGetMemHandle *hipIpcGetMemHandle = nullptr;
thipIpcOpenEventHandle *hipIpcOpenEventHandle = nullptr;
thipIpcOpenMemHandle *hipIpcOpenMemHandle = nullptr;
thipKernelNameRef *hipKernelNameRef = nullptr;
thipKernelNameRefByPtr *hipKernelNameRefByPtr = nullptr;
thipLaunchByPtr *hipLaunchByPtr = nullptr;
thipLaunchCooperativeKernel *hipLaunchCooperativeKernel = nullptr;
thipLaunchCooperativeKernelMultiDevice *hipLaunchCooperativeKernelMultiDevice = nullptr;
thipLaunchCooperativeKernel_spt *hipLaunchCooperativeKernel_spt = nullptr;
thipLaunchHostFunc *hipLaunchHostFunc = nullptr;
thipLaunchHostFunc_spt *hipLaunchHostFunc_spt = nullptr;
thipLaunchKernel *hipLaunchKernel = nullptr;
thipLaunchKernel_spt *hipLaunchKernel_spt = nullptr;
thipMalloc *hipMalloc = nullptr;
thipMalloc3D *hipMalloc3D = nullptr;
thipMalloc3DArray *hipMalloc3DArray = nullptr;
thipMallocArray *hipMallocArray = nullptr;
thipMallocAsync *hipMallocAsync = nullptr;
thipMallocFromPoolAsync *hipMallocFromPoolAsync = nullptr;
thipMallocHost *hipMallocHost = nullptr;
thipMallocManaged *hipMallocManaged = nullptr;
thipMallocMipmappedArray *hipMallocMipmappedArray = nullptr;
thipMallocPitch *hipMallocPitch = nullptr;
thipMemAddressFree *hipMemAddressFree = nullptr;
thipMemAddressReserve *hipMemAddressReserve = nullptr;
thipMemAdvise *hipMemAdvise = nullptr;
thipMemAllocHost *hipMemAllocHost = nullptr;
thipMemAllocPitch *hipMemAllocPitch = nullptr;
thipMemCreate *hipMemCreate = nullptr;
thipMemExportToShareableHandle *hipMemExportToShareableHandle = nullptr;
thipMemGetAccess *hipMemGetAccess = nullptr;
thipMemGetAddressRange *hipMemGetAddressRange = nullptr;
thipMemGetAllocationGranularity *hipMemGetAllocationGranularity = nullptr;
thipMemGetAllocationPropertiesFromHandle *hipMemGetAllocationPropertiesFromHandle = nullptr;
thipMemGetInfo *hipMemGetInfo = nullptr;
thipMemImportFromShareableHandle *hipMemImportFromShareableHandle = nullptr;
thipMemMap *hipMemMap = nullptr;
thipMemMapArrayAsync *hipMemMapArrayAsync = nullptr;
thipMemPoolCreate *hipMemPoolCreate = nullptr;
thipMemPoolDestroy *hipMemPoolDestroy = nullptr;
thipMemPoolExportPointer *hipMemPoolExportPointer = nullptr;
thipMemPoolExportToShareableHandle *hipMemPoolExportToShareableHandle = nullptr;
thipMemPoolGetAccess *hipMemPoolGetAccess = nullptr;
thipMemPoolGetAttribute *hipMemPoolGetAttribute = nullptr;
thipMemPoolImportFromShareableHandle *hipMemPoolImportFromShareableHandle = nullptr;
thipMemPoolImportPointer *hipMemPoolImportPointer = nullptr;
thipMemPoolSetAccess *hipMemPoolSetAccess = nullptr;
thipMemPoolSetAttribute *hipMemPoolSetAttribute = nullptr;
thipMemPoolTrimTo *hipMemPoolTrimTo = nullptr;
thipMemPrefetchAsync *hipMemPrefetchAsync = nullptr;
thipMemPtrGetInfo *hipMemPtrGetInfo = nullptr;
thipMemRangeGetAttribute *hipMemRangeGetAttribute = nullptr;
thipMemRangeGetAttributes *hipMemRangeGetAttributes = nullptr;
thipMemRelease *hipMemRelease = nullptr;
thipMemRetainAllocationHandle *hipMemRetainAllocationHandle = nullptr;
thipMemSetAccess *hipMemSetAccess = nullptr;
thipMemUnmap *hipMemUnmap = nullptr;
thipMemcpy *hipMemcpy = nullptr;
thipMemcpy2D *hipMemcpy2D = nullptr;
thipMemcpy2DAsync *hipMemcpy2DAsync = nullptr;
thipMemcpy2DAsync_spt *hipMemcpy2DAsync_spt = nullptr;
thipMemcpy2DFromArray *hipMemcpy2DFromArray = nullptr;
thipMemcpy2DFromArrayAsync *hipMemcpy2DFromArrayAsync = nullptr;
thipMemcpy2DFromArrayAsync_spt *hipMemcpy2DFromArrayAsync_spt = nullptr;
thipMemcpy2DFromArray_spt *hipMemcpy2DFromArray_spt = nullptr;
thipMemcpy2DToArray *hipMemcpy2DToArray = nullptr;
thipMemcpy2DToArrayAsync *hipMemcpy2DToArrayAsync = nullptr;
thipMemcpy2DToArrayAsync_spt *hipMemcpy2DToArrayAsync_spt = nullptr;
thipMemcpy2DToArray_spt *hipMemcpy2DToArray_spt = nullptr;
thipMemcpy2D_spt *hipMemcpy2D_spt = nullptr;
thipMemcpy3D *hipMemcpy3D = nullptr;
thipMemcpy3DAsync *hipMemcpy3DAsync = nullptr;
thipMemcpy3DAsync_spt *hipMemcpy3DAsync_spt = nullptr;
thipMemcpy3D_spt *hipMemcpy3D_spt = nullptr;
thipMemcpyAsync *hipMemcpyAsync = nullptr;
thipMemcpyAsync_spt *hipMemcpyAsync_spt = nullptr;
thipMemcpyAtoH *hipMemcpyAtoH = nullptr;
thipMemcpyDtoD *hipMemcpyDtoD = nullptr;
thipMemcpyDtoDAsync *hipMemcpyDtoDAsync = nullptr;
thipMemcpyDtoH *hipMemcpyDtoH = nullptr;
thipMemcpyDtoHAsync *hipMemcpyDtoHAsync = nullptr;
thipMemcpyFromArray *hipMemcpyFromArray = nullptr;
thipMemcpyFromArray_spt *hipMemcpyFromArray_spt = nullptr;
thipMemcpyFromSymbol *hipMemcpyFromSymbol = nullptr;
thipMemcpyFromSymbolAsync *hipMemcpyFromSymbolAsync = nullptr;
thipMemcpyFromSymbolAsync_spt *hipMemcpyFromSymbolAsync_spt = nullptr;
thipMemcpyFromSymbol_spt *hipMemcpyFromSymbol_spt = nullptr;
thipMemcpyHtoA *hipMemcpyHtoA = nullptr;
thipMemcpyHtoD *hipMemcpyHtoD = nullptr;
thipMemcpyHtoDAsync *hipMemcpyHtoDAsync = nullptr;
thipMemcpyParam2D *hipMemcpyParam2D = nullptr;
thipMemcpyParam2DAsync *hipMemcpyParam2DAsync = nullptr;
thipMemcpyPeer *hipMemcpyPeer = nullptr;
thipMemcpyPeerAsync *hipMemcpyPeerAsync = nullptr;
thipMemcpyToArray *hipMemcpyToArray = nullptr;
thipMemcpyToSymbol *hipMemcpyToSymbol = nullptr;
thipMemcpyToSymbolAsync *hipMemcpyToSymbolAsync = nullptr;
thipMemcpyToSymbolAsync_spt *hipMemcpyToSymbolAsync_spt = nullptr;
thipMemcpyToSymbol_spt *hipMemcpyToSymbol_spt = nullptr;
thipMemcpyWithStream *hipMemcpyWithStream = nullptr;
thipMemcpy_spt *hipMemcpy_spt = nullptr;
thipMemset *hipMemset = nullptr;
thipMemset2D *hipMemset2D = nullptr;
thipMemset2DAsync *hipMemset2DAsync = nullptr;
thipMemset2DAsync_spt *hipMemset2DAsync_spt = nullptr;
thipMemset2D_spt *hipMemset2D_spt = nullptr;
thipMemset3D *hipMemset3D = nullptr;
thipMemset3DAsync *hipMemset3DAsync = nullptr;
thipMemset3DAsync_spt *hipMemset3DAsync_spt = nullptr;
thipMemset3D_spt *hipMemset3D_spt = nullptr;
thipMemsetAsync *hipMemsetAsync = nullptr;
thipMemsetAsync_spt *hipMemsetAsync_spt = nullptr;
thipMemsetD16 *hipMemsetD16 = nullptr;
thipMemsetD16Async *hipMemsetD16Async = nullptr;
thipMemsetD32 *hipMemsetD32 = nullptr;
thipMemsetD32Async *hipMemsetD32Async = nullptr;
thipMemsetD8 *hipMemsetD8 = nullptr;
thipMemsetD8Async *hipMemsetD8Async = nullptr;
thipMemset_spt *hipMemset_spt = nullptr;
thipMipmappedArrayCreate *hipMipmappedArrayCreate = nullptr;
thipMipmappedArrayDestroy *hipMipmappedArrayDestroy = nullptr;
thipMipmappedArrayGetLevel *hipMipmappedArrayGetLevel = nullptr;
thipModuleGetFunction *hipModuleGetFunction = nullptr;
thipModuleGetGlobal *hipModuleGetGlobal = nullptr;
thipModuleGetTexRef *hipModuleGetTexRef = nullptr;
thipModuleLaunchCooperativeKernel *hipModuleLaunchCooperativeKernel = nullptr;
thipModuleLaunchCooperativeKernelMultiDevice *hipModuleLaunchCooperativeKernelMultiDevice = nullptr;
thipModuleLaunchKernel *hipModuleLaunchKernel = nullptr;
thipModuleLoad *hipModuleLoad = nullptr;
thipModuleLoadData *hipModuleLoadData = nullptr;
thipModuleLoadDataEx *hipModuleLoadDataEx = nullptr;
thipModuleOccupancyMaxActiveBlocksPerMultiprocessor *hipModuleOccupancyMaxActiveBlocksPerMultiprocessor = nullptr;
thipModuleOccupancyMaxActiveBlocksPerMultiprocessorWithFlags *hipModuleOccupancyMaxActiveBlocksPerMultiprocessorWithFlags = nullptr;
thipModuleOccupancyMaxPotentialBlockSize *hipModuleOccupancyMaxPotentialBlockSize = nullptr;
thipModuleOccupancyMaxPotentialBlockSizeWithFlags *hipModuleOccupancyMaxPotentialBlockSizeWithFlags = nullptr;
thipModuleUnload *hipModuleUnload = nullptr;
thipOccupancyMaxActiveBlocksPerMultiprocessor *hipOccupancyMaxActiveBlocksPerMultiprocessor = nullptr;
thipOccupancyMaxActiveBlocksPerMultiprocessorWithFlags *hipOccupancyMaxActiveBlocksPerMultiprocessorWithFlags = nullptr;
thipOccupancyMaxPotentialBlockSize *hipOccupancyMaxPotentialBlockSize = nullptr;
thipPeekAtLastError *hipPeekAtLastError = nullptr;
thipPointerGetAttribute *hipPointerGetAttribute = nullptr;
thipPointerGetAttributes *hipPointerGetAttributes = nullptr;
thipPointerSetAttribute *hipPointerSetAttribute = nullptr;
thipProfilerStart *hipProfilerStart = nullptr;
thipProfilerStop *hipProfilerStop = nullptr;
thipRuntimeGetVersion *hipRuntimeGetVersion = nullptr;
thipSetDevice *hipSetDevice = nullptr;
thipSetDeviceFlags *hipSetDeviceFlags = nullptr;
thipSetupArgument *hipSetupArgument = nullptr;
thipSignalExternalSemaphoresAsync *hipSignalExternalSemaphoresAsync = nullptr;
thipStreamAddCallback *hipStreamAddCallback = nullptr;
thipStreamAddCallback_spt *hipStreamAddCallback_spt = nullptr;
thipStreamAttachMemAsync *hipStreamAttachMemAsync = nullptr;
thipStreamBeginCapture *hipStreamBeginCapture = nullptr;
thipStreamBeginCapture_spt *hipStreamBeginCapture_spt = nullptr;
thipStreamCreate *hipStreamCreate = nullptr;
thipStreamCreateWithFlags *hipStreamCreateWithFlags = nullptr;
thipStreamCreateWithPriority *hipStreamCreateWithPriority = nullptr;
thipStreamDestroy *hipStreamDestroy = nullptr;
thipStreamEndCapture *hipStreamEndCapture = nullptr;
thipStreamEndCapture_spt *hipStreamEndCapture_spt = nullptr;
thipStreamGetCaptureInfo *hipStreamGetCaptureInfo = nullptr;
thipStreamGetCaptureInfo_spt *hipStreamGetCaptureInfo_spt = nullptr;
thipStreamGetCaptureInfo_v2 *hipStreamGetCaptureInfo_v2 = nullptr;
thipStreamGetCaptureInfo_v2_spt *hipStreamGetCaptureInfo_v2_spt = nullptr;
thipStreamGetDevice *hipStreamGetDevice = nullptr;
thipStreamGetFlags *hipStreamGetFlags = nullptr;
thipStreamGetFlags_spt *hipStreamGetFlags_spt = nullptr;
thipStreamGetPriority *hipStreamGetPriority = nullptr;
thipStreamGetPriority_spt *hipStreamGetPriority_spt = nullptr;
thipStreamIsCapturing *hipStreamIsCapturing = nullptr;
thipStreamIsCapturing_spt *hipStreamIsCapturing_spt = nullptr;
thipStreamQuery *hipStreamQuery = nullptr;
thipStreamQuery_spt *hipStreamQuery_spt = nullptr;
thipStreamSynchronize *hipStreamSynchronize = nullptr;
thipStreamSynchronize_spt *hipStreamSynchronize_spt = nullptr;
thipStreamUpdateCaptureDependencies *hipStreamUpdateCaptureDependencies = nullptr;
thipStreamWaitEvent *hipStreamWaitEvent = nullptr;
thipStreamWaitEvent_spt *hipStreamWaitEvent_spt = nullptr;
thipStreamWaitValue32 *hipStreamWaitValue32 = nullptr;
thipStreamWaitValue64 *hipStreamWaitValue64 = nullptr;
thipStreamWriteValue32 *hipStreamWriteValue32 = nullptr;
thipStreamWriteValue64 *hipStreamWriteValue64 = nullptr;
thipTexObjectCreate *hipTexObjectCreate = nullptr;
thipTexObjectDestroy *hipTexObjectDestroy = nullptr;
thipTexObjectGetResourceDesc *hipTexObjectGetResourceDesc = nullptr;
thipTexObjectGetResourceViewDesc *hipTexObjectGetResourceViewDesc = nullptr;
thipTexObjectGetTextureDesc *hipTexObjectGetTextureDesc = nullptr;
thipTexRefGetAddress *hipTexRefGetAddress = nullptr;
thipTexRefGetAddressMode *hipTexRefGetAddressMode = nullptr;
thipTexRefGetFilterMode *hipTexRefGetFilterMode = nullptr;
thipTexRefGetFlags *hipTexRefGetFlags = nullptr;
thipTexRefGetFormat *hipTexRefGetFormat = nullptr;
thipTexRefGetMaxAnisotropy *hipTexRefGetMaxAnisotropy = nullptr;
thipTexRefGetMipMappedArray *hipTexRefGetMipMappedArray = nullptr;
thipTexRefGetMipmapFilterMode *hipTexRefGetMipmapFilterMode = nullptr;
thipTexRefGetMipmapLevelBias *hipTexRefGetMipmapLevelBias = nullptr;
thipTexRefGetMipmapLevelClamp *hipTexRefGetMipmapLevelClamp = nullptr;
thipTexRefSetAddress *hipTexRefSetAddress = nullptr;
thipTexRefSetAddress2D *hipTexRefSetAddress2D = nullptr;
thipTexRefSetAddressMode *hipTexRefSetAddressMode = nullptr;
thipTexRefSetArray *hipTexRefSetArray = nullptr;
thipTexRefSetBorderColor *hipTexRefSetBorderColor = nullptr;
thipTexRefSetFilterMode *hipTexRefSetFilterMode = nullptr;
thipTexRefSetFlags *hipTexRefSetFlags = nullptr;
thipTexRefSetFormat *hipTexRefSetFormat = nullptr;
thipTexRefSetMaxAnisotropy *hipTexRefSetMaxAnisotropy = nullptr;
thipTexRefSetMipmapFilterMode *hipTexRefSetMipmapFilterMode = nullptr;
thipTexRefSetMipmapLevelBias *hipTexRefSetMipmapLevelBias = nullptr;
thipTexRefSetMipmapLevelClamp *hipTexRefSetMipmapLevelClamp = nullptr;
thipTexRefSetMipmappedArray *hipTexRefSetMipmappedArray = nullptr;
thipThreadExchangeStreamCaptureMode *hipThreadExchangeStreamCaptureMode = nullptr;
thipUnbindTexture *hipUnbindTexture = nullptr;
thipUserObjectCreate *hipUserObjectCreate = nullptr;
thipUserObjectRelease *hipUserObjectRelease = nullptr;
thipUserObjectRetain *hipUserObjectRetain = nullptr;
thipWaitExternalSemaphoresAsync *hipWaitExternalSemaphoresAsync = nullptr;
thiprtcAddNameExpression *hiprtcAddNameExpression = nullptr;
thiprtcCompileProgram *hiprtcCompileProgram = nullptr;
thiprtcCreateProgram *hiprtcCreateProgram = nullptr;
thiprtcDestroyProgram *hiprtcDestroyProgram = nullptr;
thiprtcGetBitcode *hiprtcGetBitcode = nullptr;
thiprtcGetBitcodeSize *hiprtcGetBitcodeSize = nullptr;
thiprtcGetCode *hiprtcGetCode = nullptr;
thiprtcGetCodeSize *hiprtcGetCodeSize = nullptr;
thiprtcGetErrorString *hiprtcGetErrorString = nullptr;
thiprtcGetLoweredName *hiprtcGetLoweredName = nullptr;
thiprtcGetProgramLog *hiprtcGetProgramLog = nullptr;
thiprtcGetProgramLogSize *hiprtcGetProgramLogSize = nullptr;
thiprtcLinkAddData *hiprtcLinkAddData = nullptr;
thiprtcLinkAddFile *hiprtcLinkAddFile = nullptr;
thiprtcLinkComplete *hiprtcLinkComplete = nullptr;
thiprtcLinkCreate *hiprtcLinkCreate = nullptr;
thiprtcLinkDestroy *hiprtcLinkDestroy = nullptr;
thiprtcVersion *hiprtcVersion = nullptr;
tmake_hipExtent *make_hipExtent = nullptr;
tmake_hipPitchedPtr *make_hipPitchedPtr = nullptr;
tmake_hipPos *make_hipPos = nullptr;



///// END REGION: OROCHI_SUMMONER_REGION_hipew_cpp_1
///// (region automatically generated by Orochi Summoner)
#pragma endregion


static DynamicLibrary dynamic_library_open_find(const char **paths) {
  int i = 0;
  while (paths[i] != NULL) {
      DynamicLibrary lib = dynamic_library_open(paths[i]);
      if (lib != NULL) {
        return lib;
      }
      ++i;
  }
  return NULL;
}

// Implementation function.
static void hipewHipExit(void) {
  if (hip_lib != NULL) {
    //  Ignore errors.
    dynamic_library_close(hip_lib);
    hip_lib = NULL;
  }

  if (hiprtc_lib != NULL) {
    //  Ignore errors.
    dynamic_library_close(hiprtc_lib);
    hiprtc_lib = NULL;
  }

  return;
}

#ifdef _WIN32
static int hipewHasOldDriver(const char *hip_path) {
    //
    //
    // we shoudn't need this complicated check anymore, and just rely on the "hipRuntimeGetVersion" check done during the hipewInit.
    // As this check doesn't seem to hurt, let's keep it for now...
    //
  DWORD verHandle = 0;
  DWORD verSize = GetFileVersionInfoSizeA(hip_path, &verHandle);
  int old_driver = 0;
  if (verSize != 0) {
    LPSTR verData = (LPSTR)malloc(verSize);
    if (GetFileVersionInfoA(hip_path, verHandle, verSize, verData)) {
      LPBYTE lpBuffer = NULL;
      UINT size = 0;
      if (VerQueryValueA(verData, "\\", (VOID FAR * FAR *)&lpBuffer, &size)) {
        if (size) {
          VS_FIXEDFILEINFO *verInfo = (VS_FIXEDFILEINFO *)lpBuffer;
          /* Magic value from
           * https://docs.microsoft.com/en-us/windows/win32/api/verrsrc/ns-verrsrc-vs_fixedfileinfo */
          if (verInfo->dwSignature == 0xfeef04bd) {
            unsigned int fileVersionLS0 = (verInfo->dwFileVersionLS >> 16) & 0xffff;
            unsigned int fileversionLS1 = (verInfo->dwFileVersionLS >> 0) & 0xffff;
            /* Corresponds to versions older than AMD Radeon Pro 21.Q4. */
            old_driver = ((fileVersionLS0 < 3354) || (fileVersionLS0 == 3354 && fileversionLS1 < 13));
          }
        }
      }
    }
    free(verData);
  }
  return old_driver;
}
#endif


// description in header
void hipewInit( int* resultDriver, int* resultRtc, uint32_t flags, const char** customPaths_Hip, const char** customPaths_Hiprtc )
{

  // Search existing HIP libraries.
  // A general rule is that we search in descending order, starting with the most recent versions.
  //
  // The HIP libraries are backward compatible, examples:
  // - If you are using the 5.7 HIP API, then any library above 5.7 (like 6.0) should be able to run your program correctly.
  // - However, if you use the 6.0 HIP API, then loading older library (like 5.7) will fail to run API that has been introduced in HIP 6.0.
  // 
  // All those fixed paths search can be overridden by the arguments of hipewInit/oroInitialize.
  // This is important to keep in mind as depending on your project you may want to search in custom order.
  //

#ifdef _WIN32
  // Expected in C:/Windows/System32 or similar, no path needed.
  const char* hip_paths[] = {
      "amdhip64_6.dll", 
      "amdhip64.dll",   // <- hip '5.x' DLL.
      NULL };
  const char* hiprtc_paths[] = {
      "hiprtc0605.dll",
      "hiprtc0604.dll",
      "hiprtc0603.dll",
      "hiprtc0602.dll",
      "hiprtc0601.dll",
      "hiprtc0600.dll",
      "hiprtc0507.dll",  
      "hiprtc0506.dll", 
      "hiprtc0505.dll", 
      "hiprtc0504.dll",
      "hiprtc0503.dll",
      NULL };
#elif defined(__APPLE__)
  // Default installation path. 
  const char *hip_paths[] = {"", NULL};
  const char* hiprtc_paths[] = { NULL };
#else
  const char *hip_paths[] = { 

      // we first try the specific versions
      "/opt/rocm/hip/lib/libamdhip64.so.6",
      "/opt/rocm/lib/libamdhip64.so.6", 
      "libamdhip64.so.6",

      "/opt/rocm/hip/lib/libamdhip64.so.5",
      "/opt/rocm/lib/libamdhip64.so.5", 
      "libamdhip64.so.5",

      // .. if it doesn't exist, we take the generic symbolic link.
      "/opt/rocm/hip/lib/libamdhip64.so",
      "/opt/rocm/lib/libamdhip64.so", 
      "libamdhip64.so",

      NULL };

  const char* hiprtc_paths[] = { 

      // we first try the specific versions
      "/opt/rocm/hip/lib/libhiprtc.so.6",
      "/opt/rocm/lib/libhiprtc.so.6", 
      "libhiprtc.so.6",

      "/opt/rocm/hip/lib/libhiprtc.so.5",
      "/opt/rocm/lib/libhiprtc.so.5", 
      "libhiprtc.so.5",

      // .. if it doesn't exist, we take the generic symbolic link.
      "/opt/rocm/hip/lib/libhiprtc.so",
      "/opt/rocm/lib/libhiprtc.so", 
      "libhiprtc.so",
      NULL };

#endif


  static int initialized = 0;
  static int s_resultDriver = 0;
  static int s_resultRtc = 0;

  if (initialized) {
	*resultDriver = s_resultDriver;
	*resultRtc = s_resultRtc;
    return;
  }

  initialized = 1;

  int error = atexit( hipewHipExit );
  if (error) {
    s_resultDriver = HIPEW_ERROR_ATEXIT_FAILED;
    s_resultRtc = HIPEW_NOT_INITIALIZED;
    *resultDriver = s_resultDriver;
    *resultRtc = s_resultRtc;
    return;
  }

#ifdef _WIN32
  /* Test for driver version. */
  if(hipewHasOldDriver(customPaths_Hip ? customPaths_Hip[0] : hip_paths[0])) {
    s_resultDriver = HIPEW_ERROR_OLD_DRIVER;
    s_resultRtc = HIPEW_NOT_INITIALIZED;
    *resultDriver = s_resultDriver;
    *resultRtc = s_resultRtc;
    return;
  }
#endif

  /* Load library. */
  hip_lib = dynamic_library_open_find(customPaths_Hip ? customPaths_Hip : hip_paths);
  hiprtc_lib = dynamic_library_open_find(customPaths_Hiprtc ? customPaths_Hiprtc : hiprtc_paths);

  if (hip_lib == NULL) {
    s_resultDriver = HIPEW_ERROR_ATEXIT_FAILED;
    s_resultRtc = HIPEW_NOT_INITIALIZED;
	*resultDriver = s_resultDriver;
	*resultRtc = s_resultRtc;
    return;
  }




#pragma region OROCHI_SUMMONER_REGION_hipew_cpp_2

/////
///// THIS REGION HAS BEEN AUTOMATICALLY GENERATED BY OROCHI SUMMONER.
///// Manual modification of this region is not recommended.
/////

_LIBRARY_FIND( hip_lib, __hipPopCallConfiguration );
_LIBRARY_FIND( hip_lib, __hipPushCallConfiguration );
_LIBRARY_FIND( hip_lib, hipApiName );
_LIBRARY_FIND( hip_lib, hipArray3DCreate );
_LIBRARY_FIND( hip_lib, hipArray3DGetDescriptor );
_LIBRARY_FIND( hip_lib, hipArrayCreate );
_LIBRARY_FIND( hip_lib, hipArrayDestroy );
_LIBRARY_FIND( hip_lib, hipArrayGetDescriptor );
_LIBRARY_FIND( hip_lib, hipArrayGetInfo );
_LIBRARY_FIND( hip_lib, hipBindTexture );
_LIBRARY_FIND( hip_lib, hipBindTexture2D );
_LIBRARY_FIND( hip_lib, hipBindTextureToArray );
_LIBRARY_FIND( hip_lib, hipBindTextureToMipmappedArray );
_LIBRARY_FIND( hip_lib, hipChooseDeviceR0600 );
_LIBRARY_FIND( hip_lib, hipConfigureCall );
_LIBRARY_FIND( hip_lib, hipCreateChannelDesc );
_LIBRARY_FIND( hip_lib, hipCreateSurfaceObject );
_LIBRARY_FIND( hip_lib, hipCreateTextureObject );
_LIBRARY_FIND( hip_lib, hipCtxCreate );
_LIBRARY_FIND( hip_lib, hipCtxDestroy );
_LIBRARY_FIND( hip_lib, hipCtxDisablePeerAccess );
_LIBRARY_FIND( hip_lib, hipCtxEnablePeerAccess );
_LIBRARY_FIND( hip_lib, hipCtxGetApiVersion );
_LIBRARY_FIND( hip_lib, hipCtxGetCacheConfig );
_LIBRARY_FIND( hip_lib, hipCtxGetCurrent );
_LIBRARY_FIND( hip_lib, hipCtxGetDevice );
_LIBRARY_FIND( hip_lib, hipCtxGetFlags );
_LIBRARY_FIND( hip_lib, hipCtxGetSharedMemConfig );
_LIBRARY_FIND( hip_lib, hipCtxPopCurrent );
_LIBRARY_FIND( hip_lib, hipCtxPushCurrent );
_LIBRARY_FIND( hip_lib, hipCtxSetCacheConfig );
_LIBRARY_FIND( hip_lib, hipCtxSetCurrent );
_LIBRARY_FIND( hip_lib, hipCtxSetSharedMemConfig );
_LIBRARY_FIND( hip_lib, hipCtxSynchronize );
_LIBRARY_FIND( hip_lib, hipDestroyExternalMemory );
_LIBRARY_FIND( hip_lib, hipDestroyExternalSemaphore );
_LIBRARY_FIND( hip_lib, hipDestroySurfaceObject );
_LIBRARY_FIND( hip_lib, hipDestroyTextureObject );
_LIBRARY_FIND( hip_lib, hipDeviceCanAccessPeer );
_LIBRARY_FIND( hip_lib, hipDeviceComputeCapability );
_LIBRARY_FIND( hip_lib, hipDeviceDisablePeerAccess );
_LIBRARY_FIND( hip_lib, hipDeviceEnablePeerAccess );
_LIBRARY_FIND( hip_lib, hipDeviceGet );
_LIBRARY_FIND( hip_lib, hipDeviceGetAttribute );
_LIBRARY_FIND( hip_lib, hipDeviceGetByPCIBusId );
_LIBRARY_FIND( hip_lib, hipDeviceGetCacheConfig );
_LIBRARY_FIND( hip_lib, hipDeviceGetDefaultMemPool );
_LIBRARY_FIND( hip_lib, hipDeviceGetGraphMemAttribute );
_LIBRARY_FIND( hip_lib, hipDeviceGetLimit );
_LIBRARY_FIND( hip_lib, hipDeviceGetMemPool );
_LIBRARY_FIND( hip_lib, hipDeviceGetName );
_LIBRARY_FIND( hip_lib, hipDeviceGetP2PAttribute );
_LIBRARY_FIND( hip_lib, hipDeviceGetPCIBusId );
_LIBRARY_FIND( hip_lib, hipDeviceGetSharedMemConfig );
_LIBRARY_FIND( hip_lib, hipDeviceGetStreamPriorityRange );
_LIBRARY_FIND( hip_lib, hipDeviceGetUuid );
_LIBRARY_FIND( hip_lib, hipDeviceGraphMemTrim );
_LIBRARY_FIND( hip_lib, hipDevicePrimaryCtxGetState );
_LIBRARY_FIND( hip_lib, hipDevicePrimaryCtxRelease );
_LIBRARY_FIND( hip_lib, hipDevicePrimaryCtxReset );
_LIBRARY_FIND( hip_lib, hipDevicePrimaryCtxRetain );
_LIBRARY_FIND( hip_lib, hipDevicePrimaryCtxSetFlags );
_LIBRARY_FIND( hip_lib, hipDeviceReset );
_LIBRARY_FIND( hip_lib, hipDeviceSetCacheConfig );
_LIBRARY_FIND( hip_lib, hipDeviceSetGraphMemAttribute );
_LIBRARY_FIND( hip_lib, hipDeviceSetLimit );
_LIBRARY_FIND( hip_lib, hipDeviceSetMemPool );
_LIBRARY_FIND( hip_lib, hipDeviceSetSharedMemConfig );
_LIBRARY_FIND( hip_lib, hipDeviceSynchronize );
_LIBRARY_FIND( hip_lib, hipDeviceTotalMem );
_LIBRARY_FIND( hip_lib, hipDriverGetVersion );
_LIBRARY_FIND( hip_lib, hipDrvGetErrorName );
_LIBRARY_FIND( hip_lib, hipDrvGetErrorString );
_LIBRARY_FIND( hip_lib, hipDrvMemcpy2DUnaligned );
_LIBRARY_FIND( hip_lib, hipDrvMemcpy3D );
_LIBRARY_FIND( hip_lib, hipDrvMemcpy3DAsync );
_LIBRARY_FIND( hip_lib, hipDrvPointerGetAttributes );
_LIBRARY_FIND( hip_lib, hipEventCreate );
_LIBRARY_FIND( hip_lib, hipEventCreateWithFlags );
_LIBRARY_FIND( hip_lib, hipEventDestroy );
_LIBRARY_FIND( hip_lib, hipEventElapsedTime );
_LIBRARY_FIND( hip_lib, hipEventQuery );
_LIBRARY_FIND( hip_lib, hipEventRecord );
_LIBRARY_FIND( hip_lib, hipEventRecord_spt );
_LIBRARY_FIND( hip_lib, hipEventSynchronize );
_LIBRARY_FIND( hip_lib, hipExtGetLastError );
_LIBRARY_FIND( hip_lib, hipExtGetLinkTypeAndHopCount );
_LIBRARY_FIND( hip_lib, hipExtLaunchKernel );
_LIBRARY_FIND( hip_lib, hipExtLaunchMultiKernelMultiDevice );
_LIBRARY_FIND( hip_lib, hipExtMallocWithFlags );
_LIBRARY_FIND( hip_lib, hipExtStreamCreateWithCUMask );
_LIBRARY_FIND( hip_lib, hipExtStreamGetCUMask );
_LIBRARY_FIND( hip_lib, hipExternalMemoryGetMappedBuffer );
_LIBRARY_FIND( hip_lib, hipExternalMemoryGetMappedMipmappedArray );
_LIBRARY_FIND( hip_lib, hipFree );
_LIBRARY_FIND( hip_lib, hipFreeArray );
_LIBRARY_FIND( hip_lib, hipFreeAsync );
_LIBRARY_FIND( hip_lib, hipFreeHost );
_LIBRARY_FIND( hip_lib, hipFreeMipmappedArray );
_LIBRARY_FIND( hip_lib, hipFuncGetAttribute );
_LIBRARY_FIND( hip_lib, hipFuncGetAttributes );
_LIBRARY_FIND( hip_lib, hipFuncSetAttribute );
_LIBRARY_FIND( hip_lib, hipFuncSetCacheConfig );
_LIBRARY_FIND( hip_lib, hipFuncSetSharedMemConfig );
_LIBRARY_FIND( hip_lib, hipGetChannelDesc );
_LIBRARY_FIND( hip_lib, hipGetDevice );
_LIBRARY_FIND( hip_lib, hipGetDeviceCount );
_LIBRARY_FIND( hip_lib, hipGetDeviceFlags );
_LIBRARY_FIND( hip_lib, hipGetDevicePropertiesR0600 );
_LIBRARY_FIND( hip_lib, hipGetErrorName );
_LIBRARY_FIND( hip_lib, hipGetErrorString );
_LIBRARY_FIND( hip_lib, hipGetLastError );
_LIBRARY_FIND( hip_lib, hipGetMipmappedArrayLevel );
_LIBRARY_FIND( hip_lib, hipGetStreamDeviceId );
_LIBRARY_FIND( hip_lib, hipGetSymbolAddress );
_LIBRARY_FIND( hip_lib, hipGetSymbolSize );
_LIBRARY_FIND( hip_lib, hipGetTextureAlignmentOffset );
_LIBRARY_FIND( hip_lib, hipGetTextureObjectResourceDesc );
_LIBRARY_FIND( hip_lib, hipGetTextureObjectResourceViewDesc );
_LIBRARY_FIND( hip_lib, hipGetTextureObjectTextureDesc );
_LIBRARY_FIND( hip_lib, hipGetTextureReference );
_LIBRARY_FIND( hip_lib, hipGraphAddChildGraphNode );
_LIBRARY_FIND( hip_lib, hipGraphAddDependencies );
_LIBRARY_FIND( hip_lib, hipGraphAddEmptyNode );
_LIBRARY_FIND( hip_lib, hipGraphAddEventRecordNode );
_LIBRARY_FIND( hip_lib, hipGraphAddEventWaitNode );
_LIBRARY_FIND( hip_lib, hipGraphAddHostNode );
_LIBRARY_FIND( hip_lib, hipGraphAddKernelNode );
_LIBRARY_FIND( hip_lib, hipGraphAddMemAllocNode );
_LIBRARY_FIND( hip_lib, hipGraphAddMemFreeNode );
_LIBRARY_FIND( hip_lib, hipGraphAddMemcpyNode );
_LIBRARY_FIND( hip_lib, hipGraphAddMemcpyNode1D );
_LIBRARY_FIND( hip_lib, hipGraphAddMemcpyNodeFromSymbol );
_LIBRARY_FIND( hip_lib, hipGraphAddMemcpyNodeToSymbol );
_LIBRARY_FIND( hip_lib, hipGraphAddMemsetNode );
_LIBRARY_FIND( hip_lib, hipGraphChildGraphNodeGetGraph );
_LIBRARY_FIND( hip_lib, hipGraphClone );
_LIBRARY_FIND( hip_lib, hipGraphCreate );
_LIBRARY_FIND( hip_lib, hipGraphDebugDotPrint );
_LIBRARY_FIND( hip_lib, hipGraphDestroy );
_LIBRARY_FIND( hip_lib, hipGraphDestroyNode );
_LIBRARY_FIND( hip_lib, hipGraphEventRecordNodeGetEvent );
_LIBRARY_FIND( hip_lib, hipGraphEventRecordNodeSetEvent );
_LIBRARY_FIND( hip_lib, hipGraphEventWaitNodeGetEvent );
_LIBRARY_FIND( hip_lib, hipGraphEventWaitNodeSetEvent );
_LIBRARY_FIND( hip_lib, hipGraphExecChildGraphNodeSetParams );
_LIBRARY_FIND( hip_lib, hipGraphExecDestroy );
_LIBRARY_FIND( hip_lib, hipGraphExecEventRecordNodeSetEvent );
_LIBRARY_FIND( hip_lib, hipGraphExecEventWaitNodeSetEvent );
_LIBRARY_FIND( hip_lib, hipGraphExecHostNodeSetParams );
_LIBRARY_FIND( hip_lib, hipGraphExecKernelNodeSetParams );
_LIBRARY_FIND( hip_lib, hipGraphExecMemcpyNodeSetParams );
_LIBRARY_FIND( hip_lib, hipGraphExecMemcpyNodeSetParams1D );
_LIBRARY_FIND( hip_lib, hipGraphExecMemcpyNodeSetParamsFromSymbol );
_LIBRARY_FIND( hip_lib, hipGraphExecMemcpyNodeSetParamsToSymbol );
_LIBRARY_FIND( hip_lib, hipGraphExecMemsetNodeSetParams );
_LIBRARY_FIND( hip_lib, hipGraphExecUpdate );
_LIBRARY_FIND( hip_lib, hipGraphGetEdges );
_LIBRARY_FIND( hip_lib, hipGraphGetNodes );
_LIBRARY_FIND( hip_lib, hipGraphGetRootNodes );
_LIBRARY_FIND( hip_lib, hipGraphHostNodeGetParams );
_LIBRARY_FIND( hip_lib, hipGraphHostNodeSetParams );
_LIBRARY_FIND( hip_lib, hipGraphInstantiate );
_LIBRARY_FIND( hip_lib, hipGraphInstantiateWithFlags );
_LIBRARY_FIND( hip_lib, hipGraphKernelNodeCopyAttributes );
_LIBRARY_FIND( hip_lib, hipGraphKernelNodeGetAttribute );
_LIBRARY_FIND( hip_lib, hipGraphKernelNodeGetParams );
_LIBRARY_FIND( hip_lib, hipGraphKernelNodeSetAttribute );
_LIBRARY_FIND( hip_lib, hipGraphKernelNodeSetParams );
_LIBRARY_FIND( hip_lib, hipGraphLaunch );
_LIBRARY_FIND( hip_lib, hipGraphLaunch_spt );
_LIBRARY_FIND( hip_lib, hipGraphMemAllocNodeGetParams );
_LIBRARY_FIND( hip_lib, hipGraphMemFreeNodeGetParams );
_LIBRARY_FIND( hip_lib, hipGraphMemcpyNodeGetParams );
_LIBRARY_FIND( hip_lib, hipGraphMemcpyNodeSetParams );
_LIBRARY_FIND( hip_lib, hipGraphMemcpyNodeSetParams1D );
_LIBRARY_FIND( hip_lib, hipGraphMemcpyNodeSetParamsFromSymbol );
_LIBRARY_FIND( hip_lib, hipGraphMemcpyNodeSetParamsToSymbol );
_LIBRARY_FIND( hip_lib, hipGraphMemsetNodeGetParams );
_LIBRARY_FIND( hip_lib, hipGraphMemsetNodeSetParams );
_LIBRARY_FIND( hip_lib, hipGraphNodeFindInClone );
_LIBRARY_FIND( hip_lib, hipGraphNodeGetDependencies );
_LIBRARY_FIND( hip_lib, hipGraphNodeGetDependentNodes );
_LIBRARY_FIND( hip_lib, hipGraphNodeGetEnabled );
_LIBRARY_FIND( hip_lib, hipGraphNodeGetType );
_LIBRARY_FIND( hip_lib, hipGraphNodeSetEnabled );
_LIBRARY_FIND( hip_lib, hipGraphReleaseUserObject );
_LIBRARY_FIND( hip_lib, hipGraphRemoveDependencies );
_LIBRARY_FIND( hip_lib, hipGraphRetainUserObject );
_LIBRARY_FIND( hip_lib, hipGraphUpload );
_LIBRARY_FIND( hip_lib, hipGraphicsMapResources );
_LIBRARY_FIND( hip_lib, hipGraphicsResourceGetMappedPointer );
_LIBRARY_FIND( hip_lib, hipGraphicsSubResourceGetMappedArray );
_LIBRARY_FIND( hip_lib, hipGraphicsUnmapResources );
_LIBRARY_FIND( hip_lib, hipGraphicsUnregisterResource );
_LIBRARY_FIND( hip_lib, hipHostAlloc );
_LIBRARY_FIND( hip_lib, hipHostFree );
_LIBRARY_FIND( hip_lib, hipHostGetDevicePointer );
_LIBRARY_FIND( hip_lib, hipHostGetFlags );
_LIBRARY_FIND( hip_lib, hipHostMalloc );
_LIBRARY_FIND( hip_lib, hipHostRegister );
_LIBRARY_FIND( hip_lib, hipHostUnregister );
_LIBRARY_FIND( hip_lib, hipImportExternalMemory );
_LIBRARY_FIND( hip_lib, hipImportExternalSemaphore );
_LIBRARY_FIND( hip_lib, hipInit );
_LIBRARY_FIND( hip_lib, hipIpcCloseMemHandle );
_LIBRARY_FIND( hip_lib, hipIpcGetEventHandle );
_LIBRARY_FIND( hip_lib, hipIpcGetMemHandle );
_LIBRARY_FIND( hip_lib, hipIpcOpenEventHandle );
_LIBRARY_FIND( hip_lib, hipIpcOpenMemHandle );
_LIBRARY_FIND( hip_lib, hipKernelNameRef );
_LIBRARY_FIND( hip_lib, hipLaunchByPtr );
_LIBRARY_FIND( hip_lib, hipLaunchCooperativeKernel );
_LIBRARY_FIND( hip_lib, hipLaunchCooperativeKernelMultiDevice );
_LIBRARY_FIND( hip_lib, hipLaunchCooperativeKernel_spt );
_LIBRARY_FIND( hip_lib, hipLaunchHostFunc );
_LIBRARY_FIND( hip_lib, hipLaunchHostFunc_spt );
_LIBRARY_FIND( hip_lib, hipLaunchKernel );
_LIBRARY_FIND( hip_lib, hipLaunchKernel_spt );
_LIBRARY_FIND( hip_lib, hipMalloc );
_LIBRARY_FIND( hip_lib, hipMalloc3D );
_LIBRARY_FIND( hip_lib, hipMalloc3DArray );
_LIBRARY_FIND( hip_lib, hipMallocArray );
_LIBRARY_FIND( hip_lib, hipMallocAsync );
_LIBRARY_FIND( hip_lib, hipMallocFromPoolAsync );
_LIBRARY_FIND( hip_lib, hipMallocHost );
_LIBRARY_FIND( hip_lib, hipMallocManaged );
_LIBRARY_FIND( hip_lib, hipMallocMipmappedArray );
_LIBRARY_FIND( hip_lib, hipMallocPitch );
_LIBRARY_FIND( hip_lib, hipMemAddressFree );
_LIBRARY_FIND( hip_lib, hipMemAddressReserve );
_LIBRARY_FIND( hip_lib, hipMemAdvise );
_LIBRARY_FIND( hip_lib, hipMemAllocHost );
_LIBRARY_FIND( hip_lib, hipMemAllocPitch );
_LIBRARY_FIND( hip_lib, hipMemCreate );
_LIBRARY_FIND( hip_lib, hipMemExportToShareableHandle );
_LIBRARY_FIND( hip_lib, hipMemGetAccess );
_LIBRARY_FIND( hip_lib, hipMemGetAddressRange );
_LIBRARY_FIND( hip_lib, hipMemGetAllocationGranularity );
_LIBRARY_FIND( hip_lib, hipMemGetAllocationPropertiesFromHandle );
_LIBRARY_FIND( hip_lib, hipMemGetInfo );
_LIBRARY_FIND( hip_lib, hipMemImportFromShareableHandle );
_LIBRARY_FIND( hip_lib, hipMemMap );
_LIBRARY_FIND( hip_lib, hipMemMapArrayAsync );
_LIBRARY_FIND( hip_lib, hipMemPoolCreate );
_LIBRARY_FIND( hip_lib, hipMemPoolDestroy );
_LIBRARY_FIND( hip_lib, hipMemPoolExportPointer );
_LIBRARY_FIND( hip_lib, hipMemPoolExportToShareableHandle );
_LIBRARY_FIND( hip_lib, hipMemPoolGetAccess );
_LIBRARY_FIND( hip_lib, hipMemPoolGetAttribute );
_LIBRARY_FIND( hip_lib, hipMemPoolImportFromShareableHandle );
_LIBRARY_FIND( hip_lib, hipMemPoolImportPointer );
_LIBRARY_FIND( hip_lib, hipMemPoolSetAccess );
_LIBRARY_FIND( hip_lib, hipMemPoolSetAttribute );
_LIBRARY_FIND( hip_lib, hipMemPoolTrimTo );
_LIBRARY_FIND( hip_lib, hipMemPrefetchAsync );
_LIBRARY_FIND( hip_lib, hipMemPtrGetInfo );
_LIBRARY_FIND( hip_lib, hipMemRangeGetAttribute );
_LIBRARY_FIND( hip_lib, hipMemRangeGetAttributes );
_LIBRARY_FIND( hip_lib, hipMemRelease );
_LIBRARY_FIND( hip_lib, hipMemRetainAllocationHandle );
_LIBRARY_FIND( hip_lib, hipMemSetAccess );
_LIBRARY_FIND( hip_lib, hipMemUnmap );
_LIBRARY_FIND( hip_lib, hipMemcpy );
_LIBRARY_FIND( hip_lib, hipMemcpy2D );
_LIBRARY_FIND( hip_lib, hipMemcpy2DAsync );
_LIBRARY_FIND( hip_lib, hipMemcpy2DAsync_spt );
_LIBRARY_FIND( hip_lib, hipMemcpy2DFromArray );
_LIBRARY_FIND( hip_lib, hipMemcpy2DFromArrayAsync );
_LIBRARY_FIND( hip_lib, hipMemcpy2DFromArrayAsync_spt );
_LIBRARY_FIND( hip_lib, hipMemcpy2DFromArray_spt );
_LIBRARY_FIND( hip_lib, hipMemcpy2DToArray );
_LIBRARY_FIND( hip_lib, hipMemcpy2DToArrayAsync );
_LIBRARY_FIND( hip_lib, hipMemcpy2DToArrayAsync_spt );
_LIBRARY_FIND( hip_lib, hipMemcpy2DToArray_spt );
_LIBRARY_FIND( hip_lib, hipMemcpy2D_spt );
_LIBRARY_FIND( hip_lib, hipMemcpy3D );
_LIBRARY_FIND( hip_lib, hipMemcpy3DAsync );
_LIBRARY_FIND( hip_lib, hipMemcpy3DAsync_spt );
_LIBRARY_FIND( hip_lib, hipMemcpy3D_spt );
_LIBRARY_FIND( hip_lib, hipMemcpyAsync );
_LIBRARY_FIND( hip_lib, hipMemcpyAsync_spt );
_LIBRARY_FIND( hip_lib, hipMemcpyAtoH );
_LIBRARY_FIND( hip_lib, hipMemcpyDtoD );
_LIBRARY_FIND( hip_lib, hipMemcpyDtoDAsync );
_LIBRARY_FIND( hip_lib, hipMemcpyDtoH );
_LIBRARY_FIND( hip_lib, hipMemcpyDtoHAsync );
_LIBRARY_FIND( hip_lib, hipMemcpyFromArray );
_LIBRARY_FIND( hip_lib, hipMemcpyFromArray_spt );
_LIBRARY_FIND( hip_lib, hipMemcpyFromSymbol );
_LIBRARY_FIND( hip_lib, hipMemcpyFromSymbolAsync );
_LIBRARY_FIND( hip_lib, hipMemcpyFromSymbolAsync_spt );
_LIBRARY_FIND( hip_lib, hipMemcpyFromSymbol_spt );
_LIBRARY_FIND( hip_lib, hipMemcpyHtoA );
_LIBRARY_FIND( hip_lib, hipMemcpyHtoD );
_LIBRARY_FIND( hip_lib, hipMemcpyHtoDAsync );
_LIBRARY_FIND( hip_lib, hipMemcpyParam2D );
_LIBRARY_FIND( hip_lib, hipMemcpyParam2DAsync );
_LIBRARY_FIND( hip_lib, hipMemcpyPeer );
_LIBRARY_FIND( hip_lib, hipMemcpyPeerAsync );
_LIBRARY_FIND( hip_lib, hipMemcpyToArray );
_LIBRARY_FIND( hip_lib, hipMemcpyToSymbol );
_LIBRARY_FIND( hip_lib, hipMemcpyToSymbolAsync );
_LIBRARY_FIND( hip_lib, hipMemcpyToSymbolAsync_spt );
_LIBRARY_FIND( hip_lib, hipMemcpyToSymbol_spt );
_LIBRARY_FIND( hip_lib, hipMemcpyWithStream );
_LIBRARY_FIND( hip_lib, hipMemcpy_spt );
_LIBRARY_FIND( hip_lib, hipMemset );
_LIBRARY_FIND( hip_lib, hipMemset2D );
_LIBRARY_FIND( hip_lib, hipMemset2DAsync );
_LIBRARY_FIND( hip_lib, hipMemset2DAsync_spt );
_LIBRARY_FIND( hip_lib, hipMemset2D_spt );
_LIBRARY_FIND( hip_lib, hipMemset3D );
_LIBRARY_FIND( hip_lib, hipMemset3DAsync );
_LIBRARY_FIND( hip_lib, hipMemset3DAsync_spt );
_LIBRARY_FIND( hip_lib, hipMemset3D_spt );
_LIBRARY_FIND( hip_lib, hipMemsetAsync );
_LIBRARY_FIND( hip_lib, hipMemsetAsync_spt );
_LIBRARY_FIND( hip_lib, hipMemsetD16 );
_LIBRARY_FIND( hip_lib, hipMemsetD16Async );
_LIBRARY_FIND( hip_lib, hipMemsetD32 );
_LIBRARY_FIND( hip_lib, hipMemsetD32Async );
_LIBRARY_FIND( hip_lib, hipMemsetD8 );
_LIBRARY_FIND( hip_lib, hipMemsetD8Async );
_LIBRARY_FIND( hip_lib, hipMemset_spt );
_LIBRARY_FIND( hip_lib, hipMipmappedArrayCreate );
_LIBRARY_FIND( hip_lib, hipMipmappedArrayDestroy );
_LIBRARY_FIND( hip_lib, hipMipmappedArrayGetLevel );
_LIBRARY_FIND( hip_lib, hipModuleGetFunction );
_LIBRARY_FIND( hip_lib, hipModuleGetGlobal );
_LIBRARY_FIND( hip_lib, hipModuleGetTexRef );
_LIBRARY_FIND( hip_lib, hipModuleLaunchCooperativeKernel );
_LIBRARY_FIND( hip_lib, hipModuleLaunchCooperativeKernelMultiDevice );
_LIBRARY_FIND( hip_lib, hipModuleLaunchKernel );
_LIBRARY_FIND( hip_lib, hipModuleLoad );
_LIBRARY_FIND( hip_lib, hipModuleLoadData );
_LIBRARY_FIND( hip_lib, hipModuleLoadDataEx );
_LIBRARY_FIND( hip_lib, hipModuleOccupancyMaxActiveBlocksPerMultiprocessor );
_LIBRARY_FIND( hip_lib, hipModuleOccupancyMaxActiveBlocksPerMultiprocessorWithFlags );
_LIBRARY_FIND( hip_lib, hipModuleOccupancyMaxPotentialBlockSize );
_LIBRARY_FIND( hip_lib, hipModuleOccupancyMaxPotentialBlockSizeWithFlags );
_LIBRARY_FIND( hip_lib, hipModuleUnload );
_LIBRARY_FIND( hip_lib, hipOccupancyMaxActiveBlocksPerMultiprocessor );
_LIBRARY_FIND( hip_lib, hipOccupancyMaxActiveBlocksPerMultiprocessorWithFlags );
_LIBRARY_FIND( hip_lib, hipOccupancyMaxPotentialBlockSize );
_LIBRARY_FIND( hip_lib, hipPeekAtLastError );
_LIBRARY_FIND( hip_lib, hipPointerGetAttribute );
_LIBRARY_FIND( hip_lib, hipPointerGetAttributes );
_LIBRARY_FIND( hip_lib, hipProfilerStart );
_LIBRARY_FIND( hip_lib, hipProfilerStop );
_LIBRARY_FIND( hip_lib, hipRuntimeGetVersion );
_LIBRARY_FIND( hip_lib, hipSetDevice );
_LIBRARY_FIND( hip_lib, hipSetDeviceFlags );
_LIBRARY_FIND( hip_lib, hipSetupArgument );
_LIBRARY_FIND( hip_lib, hipSignalExternalSemaphoresAsync );
_LIBRARY_FIND( hip_lib, hipStreamAddCallback );
_LIBRARY_FIND( hip_lib, hipStreamAddCallback_spt );
_LIBRARY_FIND( hip_lib, hipStreamAttachMemAsync );
_LIBRARY_FIND( hip_lib, hipStreamBeginCapture );
_LIBRARY_FIND( hip_lib, hipStreamBeginCapture_spt );
_LIBRARY_FIND( hip_lib, hipStreamCreate );
_LIBRARY_FIND( hip_lib, hipStreamCreateWithFlags );
_LIBRARY_FIND( hip_lib, hipStreamCreateWithPriority );
_LIBRARY_FIND( hip_lib, hipStreamDestroy );
_LIBRARY_FIND( hip_lib, hipStreamEndCapture );
_LIBRARY_FIND( hip_lib, hipStreamEndCapture_spt );
_LIBRARY_FIND( hip_lib, hipStreamGetCaptureInfo );
_LIBRARY_FIND( hip_lib, hipStreamGetCaptureInfo_spt );
_LIBRARY_FIND( hip_lib, hipStreamGetCaptureInfo_v2 );
_LIBRARY_FIND( hip_lib, hipStreamGetCaptureInfo_v2_spt );
_LIBRARY_FIND( hip_lib, hipStreamGetDevice );
_LIBRARY_FIND( hip_lib, hipStreamGetFlags );
_LIBRARY_FIND( hip_lib, hipStreamGetFlags_spt );
_LIBRARY_FIND( hip_lib, hipStreamGetPriority );
_LIBRARY_FIND( hip_lib, hipStreamGetPriority_spt );
_LIBRARY_FIND( hip_lib, hipStreamIsCapturing );
_LIBRARY_FIND( hip_lib, hipStreamIsCapturing_spt );
_LIBRARY_FIND( hip_lib, hipStreamQuery );
_LIBRARY_FIND( hip_lib, hipStreamQuery_spt );
_LIBRARY_FIND( hip_lib, hipStreamSynchronize );
_LIBRARY_FIND( hip_lib, hipStreamSynchronize_spt );
_LIBRARY_FIND( hip_lib, hipStreamUpdateCaptureDependencies );
_LIBRARY_FIND( hip_lib, hipStreamWaitEvent );
_LIBRARY_FIND( hip_lib, hipStreamWaitEvent_spt );
_LIBRARY_FIND( hip_lib, hipStreamWaitValue32 );
_LIBRARY_FIND( hip_lib, hipStreamWaitValue64 );
_LIBRARY_FIND( hip_lib, hipStreamWriteValue32 );
_LIBRARY_FIND( hip_lib, hipStreamWriteValue64 );
_LIBRARY_FIND( hip_lib, hipTexObjectCreate );
_LIBRARY_FIND( hip_lib, hipTexObjectDestroy );
_LIBRARY_FIND( hip_lib, hipTexObjectGetResourceDesc );
_LIBRARY_FIND( hip_lib, hipTexObjectGetResourceViewDesc );
_LIBRARY_FIND( hip_lib, hipTexObjectGetTextureDesc );
_LIBRARY_FIND( hip_lib, hipTexRefGetAddress );
_LIBRARY_FIND( hip_lib, hipTexRefGetAddressMode );
_LIBRARY_FIND( hip_lib, hipTexRefGetFilterMode );
_LIBRARY_FIND( hip_lib, hipTexRefGetFlags );
_LIBRARY_FIND( hip_lib, hipTexRefGetFormat );
_LIBRARY_FIND( hip_lib, hipTexRefGetMaxAnisotropy );
_LIBRARY_FIND( hip_lib, hipTexRefGetMipmapFilterMode );
_LIBRARY_FIND( hip_lib, hipTexRefGetMipmapLevelBias );
_LIBRARY_FIND( hip_lib, hipTexRefGetMipmapLevelClamp );
_LIBRARY_FIND( hip_lib, hipTexRefSetAddress );
_LIBRARY_FIND( hip_lib, hipTexRefSetAddress2D );
_LIBRARY_FIND( hip_lib, hipTexRefSetAddressMode );
_LIBRARY_FIND( hip_lib, hipTexRefSetArray );
_LIBRARY_FIND( hip_lib, hipTexRefSetBorderColor );
_LIBRARY_FIND( hip_lib, hipTexRefSetFilterMode );
_LIBRARY_FIND( hip_lib, hipTexRefSetFlags );
_LIBRARY_FIND( hip_lib, hipTexRefSetFormat );
_LIBRARY_FIND( hip_lib, hipTexRefSetMaxAnisotropy );
_LIBRARY_FIND( hip_lib, hipTexRefSetMipmapFilterMode );
_LIBRARY_FIND( hip_lib, hipTexRefSetMipmapLevelBias );
_LIBRARY_FIND( hip_lib, hipTexRefSetMipmapLevelClamp );
_LIBRARY_FIND( hip_lib, hipTexRefSetMipmappedArray );
_LIBRARY_FIND( hip_lib, hipThreadExchangeStreamCaptureMode );
_LIBRARY_FIND( hip_lib, hipUnbindTexture );
_LIBRARY_FIND( hip_lib, hipUserObjectCreate );
_LIBRARY_FIND( hip_lib, hipUserObjectRelease );
_LIBRARY_FIND( hip_lib, hipUserObjectRetain );
_LIBRARY_FIND( hip_lib, hipWaitExternalSemaphoresAsync );


///// END REGION: OROCHI_SUMMONER_REGION_hipew_cpp_2
///// (region automatically generated by Orochi Summoner)
#pragma endregion



  s_resultDriver = HIPEW_SUCCESS;
  *resultDriver = s_resultDriver;

  if( ( flags & HIPEW_INIT_HIPRTC ) == 0 )
  {
	s_resultRtc = HIPEW_NOT_INITIALIZED;
	*resultRtc = s_resultRtc;
	return;
  }

  auto rtcLib = hiprtc_lib ? hiprtc_lib : hip_lib;
  _LIBRARY_FIND( rtcLib, hiprtcGetErrorString );
  if( hiprtcGetErrorString )
  {



#pragma region OROCHI_SUMMONER_REGION_hipew_cpp_rtc

/////
///// THIS REGION HAS BEEN AUTOMATICALLY GENERATED BY OROCHI SUMMONER.
///// Manual modification of this region is not recommended.
/////

_LIBRARY_FIND( rtcLib, hiprtcAddNameExpression );
_LIBRARY_FIND( rtcLib, hiprtcCompileProgram );
_LIBRARY_FIND( rtcLib, hiprtcCreateProgram );
_LIBRARY_FIND( rtcLib, hiprtcDestroyProgram );
_LIBRARY_FIND( rtcLib, hiprtcGetBitcode );
_LIBRARY_FIND( rtcLib, hiprtcGetBitcodeSize );
_LIBRARY_FIND( rtcLib, hiprtcGetCode );
_LIBRARY_FIND( rtcLib, hiprtcGetCodeSize );
_LIBRARY_FIND( rtcLib, hiprtcGetErrorString );
_LIBRARY_FIND( rtcLib, hiprtcGetLoweredName );
_LIBRARY_FIND( rtcLib, hiprtcGetProgramLog );
_LIBRARY_FIND( rtcLib, hiprtcGetProgramLogSize );
_LIBRARY_FIND( rtcLib, hiprtcLinkAddData );
_LIBRARY_FIND( rtcLib, hiprtcLinkAddFile );
_LIBRARY_FIND( rtcLib, hiprtcLinkComplete );
_LIBRARY_FIND( rtcLib, hiprtcLinkCreate );
_LIBRARY_FIND( rtcLib, hiprtcLinkDestroy );
_LIBRARY_FIND( rtcLib, hiprtcVersion );


///// END REGION: OROCHI_SUMMONER_REGION_hipew_cpp_rtc
///// (region automatically generated by Orochi Summoner)
#pragma endregion


	s_resultRtc = HIPEW_SUCCESS;
	*resultRtc = s_resultRtc;
  }
  else
  {
	s_resultRtc = HIPEW_ERROR_OPEN_FAILED;
	*resultRtc = s_resultRtc;
  }



#ifndef HIPEW_DO_NOT_CHECK_VERSION // not recommanded to define this flag, but just give a possibility for the developer to do it...
    if ( hipRuntimeGetVersion )
    {
      int runtimeVersion = 0;
      hipRuntimeGetVersion(&runtimeVersion);
      int runtimeVersion_major = runtimeVersion / (int)10000000;
      if ( (int)HIP_VERSION_MAJOR > runtimeVersion_major )
      {
        *resultDriver = HIPEW_ERROR_OLD_DRIVER;
        *resultRtc = HIPEW_ERROR_OLD_DRIVER; // as currently hiprtcVersion is not used, set the same result than resultDriver
      }
    }

    if (hiprtcVersion) 
    {
      int major, minor = 0;
      hiprtcVersion(&major, &minor);
      // we currently can't compare this version with API as this version is decoupled from HIP_VERSION
    }

#endif





}

const char *hipewErrorString(hipError_t result) {
  switch (result) {
    case hipSuccess: return "No errors";
    case hipErrorInvalidValue: return "Invalid value";
    case hipErrorOutOfMemory: return "Out of memory";
    case hipErrorNotInitialized: return "Driver not initialized";
    case hipErrorDeinitialized: return "Driver deinitialized";
    case hipErrorProfilerDisabled: return "Profiler disabled";
    case hipErrorProfilerNotInitialized: return "Profiler not initialized";
    case hipErrorProfilerAlreadyStarted: return "Profiler already started";
    case hipErrorProfilerAlreadyStopped: return "Profiler already stopped";
    case hipErrorNoDevice: return "No HIP-capable device available";
    case hipErrorInvalidDevice: return "Invalid device";
    case hipErrorInvalidImage: return "Invalid kernel image";
    case hipErrorInvalidContext: return "Invalid context";
    case hipErrorContextAlreadyCurrent: return "Context already current";
    case hipErrorMapFailed: return "Map failed";
    case hipErrorUnmapFailed: return "Unmap failed";
    case hipErrorArrayIsMapped: return "Array is mapped";
    case hipErrorAlreadyMapped: return "Already mapped";
    case hipErrorNoBinaryForGpu: return "No binary for GPU";
    case hipErrorAlreadyAcquired: return "Already acquired";
    case hipErrorNotMapped: return "Not mapped";
    case hipErrorNotMappedAsArray: return "Mapped resource not available for access as an array";
    case hipErrorNotMappedAsPointer: return "Mapped resource not available for access as a pointer";
    case hipErrorECCNotCorrectable: return "Uncorrectable ECC error detected";
    case hipErrorUnsupportedLimit: return "hipLimit_t not supported by device";
    case hipErrorContextAlreadyInUse: return "Context already in use";
    case hipErrorPeerAccessUnsupported: return "Peer access unsupported";
    case hipErrorInvalidKernelFile: return "Invalid ptx";
    case hipErrorInvalidGraphicsContext: return "Invalid graphics context";
    case hipErrorInvalidSource: return "Invalid source";
    case hipErrorFileNotFound: return "File not found";
    case hipErrorSharedObjectSymbolNotFound: return "Link to a shared object failed to resolve";
    case hipErrorSharedObjectInitFailed: return "Shared object initialization failed";
    case hipErrorOperatingSystem: return "Operating system";
    case hipErrorInvalidHandle: return "Invalid handle";
    case hipErrorNotFound: return "Not found";
    case hipErrorNotReady: return "HIP not ready";
    case hipErrorIllegalAddress: return "Illegal address";
    case hipErrorLaunchOutOfResources: return "Launch exceeded resources";
    case hipErrorLaunchTimeOut: return "Launch exceeded timeout";
    case hipErrorPeerAccessAlreadyEnabled: return "Peer access already enabled";
    case hipErrorPeerAccessNotEnabled: return "Peer access not enabled";
    case hipErrorSetOnActiveProcess: return "Primary context active";
    case hipErrorAssert: return "Assert";
    case hipErrorHostMemoryAlreadyRegistered: return "Host memory already registered";
    case hipErrorHostMemoryNotRegistered: return "Host memory not registered";
    case hipErrorLaunchFailure: return "Launch failed";
    case hipErrorCooperativeLaunchTooLarge: return "Cooperative launch too large";
    case hipErrorNotSupported: return "Not supported";
    case hipErrorUnknown: return "Unknown error";
    default: return "Unknown HIP error value";
  }
}

static void path_join(const char *path1,
                      const char *path2,
                      int maxlen,
                      char *result) {
#if defined(WIN32) || defined(_WIN32)
  const char separator = '\\';
#else
  const char separator = '/';
#endif
  int n = snprintf(result, maxlen, "%s%c%s", path1, separator, path2);
  if (n != -1 && n < maxlen) {
    result[n] = '\0';
  }
  else {
    result[maxlen - 1] = '\0';
  }
}

static int path_exists(const char *path) {
  struct stat st;
  if (stat(path, &st)) {
    return 0;
  }
  return 1;
}

const char *hipewCompilerPath(void) {
    #ifdef _WIN32
    const char *hipPath = getenv("HIP_ROCCLR_HOME");
    const char *windowsCommand = "perl ";
    const char *executable = "bin/hipcc";

    static char hipcc[65536];
    static char finalCommand[65536];
    if(hipPath) {
      path_join(hipPath, executable, sizeof(hipcc), hipcc);
      if(path_exists(hipcc)) {
        snprintf(finalCommand, sizeof(hipcc), "%s %s", windowsCommand, hipcc);
        return finalCommand;
      } else {
        printf("Could not find hipcc. Make sure HIP_ROCCLR_HOME points to the directory holding /bin/hipcc");
      }
    }
    #else
    const char *hipPath =  "opt/rocm/hip/bin";
    const char *executable = "hipcc";

    static char hipcc[65536];
    if(hipPath) {
      path_join(hipPath, executable, sizeof(hipcc), hipcc);
      if(path_exists(hipcc)){
        return hipcc;
      }
    }
    #endif

  {
#ifdef _WIN32
    FILE *handle = popen("where hipcc", "r");
#else
    FILE *handle = popen("which hipcc", "r");
#endif
    if (handle) {
      char buffer[4096] = {0};
      size_t elementSize = 1;
      size_t elementCount = sizeof(buffer) - 1;
      size_t len = fread(buffer, elementSize, elementCount, handle);
      buffer[len] = '\0';
      pclose(handle);
      if (buffer[0]) {
        return "hipcc";
      }
    }
  }

  return NULL;
}

int hipewCompilerVersion(void) {
  const char *path = hipewCompilerPath();
  const char *marker = "Hip compilation tools, release ";
  FILE *pipe;
  char buf[128];
  char output[65536] = "\0";
  char command[65536] = "\0";

  if (path == NULL) {
    return 0;
  }

  /* get --version output */
  strcat(command, "\"");
  strncat(command, path, sizeof(command) - 1);
  strncat(command, "\" --version", sizeof(command) - strlen(path) - 1);
  pipe = popen(command, "r");
  if (!pipe) {
    fprintf(stderr, "HIP: failed to run compiler to retrieve version");
    return 0;
  }

  while (!feof(pipe)) {
    if (fgets(buf, sizeof(buf), pipe) != NULL) {
      strncat(output, buf, sizeof(output) - strlen(output) - 1);
    }
  }

  pclose(pipe);
  return 40;
}
