%{

#include "headers.h"
#include "cfgy.h"

int ipcacfglineno = 1;

%}

%option never-interactive
%option noinput nounput
%option noyywrap stack
%option caseless 8bit

%pointer

%x comment
%x string
%x ifbody
%x filename
%x rshdef
%x nflowdef
%x aggr
%x cports

%%

<*>"/*"		yy_push_state(comment);
<comment>{
	[^*/\n]		/* Eat */
	"*/"	yy_pop_state();
	\n		ipcacfglineno++;
	.	/* Eat */
}

<*>";"	{ while(YY_START) yy_pop_state(); yy_top_state(); return SEMICOLON; }
"="		{ yy_push_state(string); return EQ; }

#[^\n]*[\n]?	{
		if(yytext[yyleng-1] == '\n')
			ipcacfglineno++;
	}

<INITIAL,rshdef>ttl		{ return TTL; }
pidfile		{ return PIDFILE; }

interface|iface		{
		yy_push_state(ifbody);
		return IFACE;
	}
<filename>{
	[^ \r\n\t\f;]+	{
		ipcacfglval.tv_char = strdup(yytext);
		yy_pop_state();
		return TOK_STRING;
	}
}
<ifbody>{
	file	yy_push_state(filename); return IFILE;	/* PCAP file */
	divert	return DIVERT;	/* BSD's ipfw(8) divert(4) */
	tee	return TEE;	/* BSD's ipfw(8), grep tee */
	port	return PORT;	/* port for divert(4) and tee. */
	ipq	return IPQ;	/* Linux libipq(3) */
	ulog	return ULOG;	/* Linux ULOG */
	group	return GROUP;	/* ULOG group */
	","	return ',';	/* ULOG groups are comma separated */

	input[a-z_-]*	return INONLY;
	prom[a-z]*		return PROMISC;
	netflow-sampled		return NETFLOW_SAMPLED;
	netflow-disable		return NETFLOW_DISABLE;
	filter		return FILTER;

	[a-z]+[_0-9\*]+[:\.][0-9\*]+	{
		ipcacfglval.tv_char = strdup(yytext);
		return TOK_STRING;
	}
	[a-z]+[_0-9*]*	{
		ipcacfglval.tv_char = strdup(yytext);
		return TOK_STRING;
	}
	[0-9]+	{
		ipcacfglval.tv_int = atoi(yytext);
		return TOK_INTEGER;
	}

	\"[^\"]*\"	{
		yytext[yyleng-1] = '\0';
		ipcacfglval.tv_char = strdup(yytext+1);
		return TOK_STRING;
	}
}

rsh|rcmd	{ yy_push_state(rshdef); return RSH; }

<rshdef>{
	"@"		return AT;
	"="		{ yy_push_state(string); return EQ; }
	at		return AT;
	timeout				{ yy_pop_state(); return TIMEOUT; }

	deny|off|disable|no		return DENY;
	allow|on|enable|yes		return ALLOW;
	view[a-z-]*		return VIEW_ONLY;
	default		return DEFAULT;
	backup		return BACKUP;
	admin		return ADMIN;

	[a-z0-9._]+	{
		ipcacfglval.tv_char = strdup(yytext);
		return TOK_STRING;
	}
}

netflow	{ yy_push_state(nflowdef); return NETFLOW; }
<nflowdef>{
	export			return EXPORT;
	dst|dest[a-z]*		return DESTINATION;
	version			return VERSION;
	timeout			return TIMEOUT;
	active			return ACTIVE;
	inactive		return INACTIVE;
	sampling-mode		return SAMPLING_MODE;
	packet-interval		return PACKET_INTERVAL;
	ifclass			return IFCLASS;
	engine-type		return ENGINE_TYPE;
	engine-id		return ENGINE_ID;
	mapto			return MAPTO;
	"-"			return	'-';

	[0-9]+	{
		ipcacfglval.tv_int = atoi(yytext);
		return TOK_INTEGER;
		}
	[a-z0-9._]+	{
		ipcacfglval.tv_char = strdup(yytext);
		return TOK_STRING;
	}
}

capture-ports	{ yy_push_state(cports); return CAPTURE_PORTS; }
<cports>{
	deny|off|disable|no	return DENY;
	allow|on|enable|yes	return ALLOW;
}

mem[a-z_-]*		return MEMSIZE;
buf[a-z]*		return BUFFERS;
chroot		return CHROOT;
uid	return UID;
gid	return GID;
dump[a-z]*	return DUMP;

aggr[a-z]*	{ yy_push_state(aggr); return AGGR; }
<aggr>{
	[0-9.]+	{
		ipcacfglval.tv_char = strdup(yytext);
		return TOK_STRING;
	}
	"/"	return SLASH;
	"-"	return	'-';
	strip	return STRIP;
	into	return INTO;
}

<string>[a-z0-9./-]+	{
		ipcacfglval.tv_char = strdup(yytext);
		return TOK_STRING;
	}

<*>[[:space:]]	{
		if(*yytext == '\n')
			ipcacfglineno++;
	}

<*>.	{ return ERROR; }

<*><<EOF>>	{ yyterminate(); }

%%
