RabbitMQ `3.12.13` is a maintenance release in the `3.12.x` [release series](https://www.rabbitmq.com/versions.html).
This series [is covered](https://rabbitmq.com/versions.html) by community support through June 30, 2024 and extended commercial support through Dec 31, 2024.

Please refer to the upgrade section from the [3.12.0 release notes](https://github.com/rabbitmq/rabbitmq-server/releases/tag/v3.12.0)
if upgrading from a version prior to 3.12.0.

This release requires Erlang 25 and supports Erlang versions up to `26.2.x`.
[RabbitMQ and Erlang/OTP Compatibility Matrix](https://www.rabbitmq.com/which-erlang.html) has more details on
Erlang version requirements for RabbitMQ.


### Minimum Supported Erlang Version

As of 3.12.0, RabbitMQ requires Erlang 25. Nodes **will fail to start** on older Erlang releases.

Users upgrading from 3.11.x (or older releases) on Erlang 25 to 3.12.x on Erlang 26
(both RabbitMQ *and* Erlang are upgraded at the same time) **must** consult
the [v3.12.0 release notes](https://github.com/rabbitmq/rabbitmq-server/releases/tag/v3.12.0) first.


## Changes Worth Mentioning

Release notes can be found on GitHub at [rabbitmq-server/release-notes](https://github.com/rabbitmq/rabbitmq-server/tree/v3.12.x/release-notes).


### Core Broker

#### Bug Fixes

 * When a channel is closed, its consumer metric samples will now be cleared differently
   depending on the number of them. In [#9356](https://github.com/rabbitmq/rabbitmq-server/pull/9356), it was over optimized for the uncommon case with
   a very large number of consumers per channel, hurting the baseline case with one or a few consumers
   per channel.

   In part contributed by @SimonUnge (AWS).

   GitHub issue: [#10478](https://github.com/rabbitmq/rabbitmq-server/pull/10478)


### CLI Tools

#### Enhancement

 * CLI tool startup time was reduced.

   GitHub issue: [#10461](https://github.com/rabbitmq/rabbitmq-server/pull/10461)

#### Bug Fixes

 * JSON output formatter now avoids ANSI escape sequences.

   Contributed by @ariel-anieli.

   GitHub issue: [#8557](https://github.com/rabbitmq/rabbitmq-server/issues/8557)

 * ANSI escape sequences are no longer used on Windows.

   Contributed by @ariel-anieli.

   GitHub issue: [#2634](https://github.com/rabbitmq/rabbitmq-server/issues/2634)


### Stream Plugin

#### Bug Fixes

 * If a stream publisher cannot be set up, a clearer message will be logged.

   GitHub issue: [#10524](https://github.com/rabbitmq/rabbitmq-server/pull/10524)


### Management Plugin

#### Bug Fixes

 * `GET /api/nodes/{name}` failed with a 500 when called with a non-existed node name.

   GitHub issue: [#10330](https://github.com/rabbitmq/rabbitmq-server/issues/10330)


### Shovel Plugin

#### Bug Fixes

 * AMQP 1.0 Shovels will no longer set a delivery mode header that is not meaningful in AMQP 1.0.

   Contributed by @luos (Erlang Solutions).

   GitHub issue: [#10503](https://github.com/rabbitmq/rabbitmq-server/pull/10503)


### Federation Plugin

#### Bug Fixes

 * Upstream node shutdown could produce a scary looking exception in the log.

   GitHub issue: [#10473](https://github.com/rabbitmq/rabbitmq-server/pull/10473)

 * Exchange federation links could run into an exception.

   Contributed by @gomoripeti (CloudAMQP).

   GitHub issue: [#10305](https://github.com/rabbitmq/rabbitmq-server/pull/10305)


### Dependency Changes

 * `cowboy` was updated to [`2.11.0`](https://ninenines.eu/docs/en/cowboy/2.11/guide/migrating_from_2.10/)

## Source Code Archives

To obtain source code of the entire distribution, please download the archive named `rabbitmq-server-3.12.13.tar.xz`
instead of the source tarball produced by GitHub.
