package xray

const FatalErrorXrayScanResponse = `
{
 "errors": [{"status":-1}, {"status":500}]
}
`

const CleanXrayScanResponse = `
{
  "summary" : {
    "message" : "Build pipeline-xray number 307 was scanned by Xray and passed with no Alerts",
    "total_alerts" : 0,
    "fail_build" : false,
    "more_details_url" : ""
  },
  "alerts" : [ ],
  "licenses" : [ {
    "name" : "Unknown",
    "components" : [ "generic://sha256:8739c76e681f900923b900c9df0ef75cf421d39cabb54650c4b9ad19b6a76d85/ArtifactoryPipeline.zip", "gav://com.opensymphony:xwork:2.0.6", "build://pipeline-xray:307" ],
    "full_name" : "Unknown license",
    "more_info_url" : null
  } ]
}`

const VulnerableXrayScanResponse = `{
  "summary": {
    "message": "Build pipeline-xray number 294 was scanned by Xray and 2 Alerts were generated",
    "total_alerts": 2,
    "fail_build": true,
    "more_details_url": "http://10.1.20.29:8000//web/#/alerts/all?filter=58760987e138231efd444492,58760987e138231efd444493"
  },
  "alerts": [
    {
      "created": "2017-01-11T12:31:35.79130964+02:00",
      "issues": [
        {
          "severity": "Major",
          "type": "security",
          "provider": "JFrog",
          "created": "2011-05-13T16:05:45+03:00",
          "summary": "CWE-200 Information Exposure",
          "description": "XWork 2.2.1 in Apache Struts 2.2.1, and OpenSymphony XWork in OpenSymphony WebWork, allows remote attackers to obtain potentially sensitive information about internal Java class paths via vectors involving an s:submit element and a nonexistent method, a different vulnerability than CVE-2011-1772.3.",
          "cve": "CVE-2011-2088",
          "component_ids": [
            "gav://opensymphony:xwork:1.0.3.6",
            "gav://opensymphony:xwork:1.0.3.5",
            "gav://opensymphony:xwork:1.0.3.4",
            "gav://opensymphony:xwork:1.0.3.3",
            "gav://opensymphony:xwork:1.1.1",
            "gav://opensymphony:xwork:1.0.3.2",
            "gav://opensymphony:xwork:1.0.3.1",
            "gav://opensymphony:xwork:1.1.3",
            "gav://opensymphony:webwork:2.1.5-atlassian-2",
            "gav://opensymphony:webwork:2.1.5-atlassian-3",
            "gav://opensymphony:webwork:2.2.1",
            "gav://opensymphony:webwork:2.2.2",
            "gav://opensymphony:webwork:2.2.3",
            "gav://opensymphony:xwork:2.0-beta-3-j4",
            "gav://opensymphony:xwork:2.0.1-j4",
            "gav://com.opensymphony:webwork:2.2.6-atlassian-3",
            "gav://opensymphony:webwork:2.2.4",
            "gav://opensymphony:webwork:2.2.5",
            "gav://com.opensymphony:webwork:2.2.6-atlassian-2",
            "gav://opensymphony:webwork:2.2.7",
            "gav://opensymphony:xwork:2.0.3",
            "gav://opensymphony:xwork:2.0.2",
            "gav://com.opensymphony:xwork:2.0.7",
            "gav://com.opensymphony:xwork:2.0.5",
            "gav://com.opensymphony:xwork:2.0.6",
            "gav://opensymphony:webwork:2.2.7-atlassian-25",
            "gav://opensymphony:webwork:2.2.7-atlassian-27",
            "gav://opensymphony:xwork:2.0.0-j4",
            "gav://opensymphony:xwork:1.2.2",
            "gav://opensymphony:xwork:1.2.1",
            "gav://opensymphony:webwork:2.2.7-atlassian-23",
            "gav://opensymphony:xwork:1.2.3",
            "gav://opensymphony:webwork:2.2.7-atlassian-24",
            "gav://opensymphony:xwork:2.0-beta-2",
            "gav://opensymphony:xwork:2.0-RC1",
            "gav://opensymphony:xwork:2.0-beta-3",
            "gav://opensymphony:xwork:2.0-RC1-j4",
            "gav://opensymphony:xwork:2.0-beta-1",
            "gav://opensymphony:xwork:2.0.1",
            "gav://opensymphony:xwork:2.0.0",
            "gav://opensymphony:xwork:1.1",
            "gav://opensymphony:xwork:1.2",
            "gav://opensymphony:xwork:1.0",
            "gav://opensymphony:webwork:2.2.7-atlassian-29",
            "gav://opensymphony:webwork:1.4-atlassian-26-testmvn2-1",
            "gav://opensymphony:webwork:2.2.7-atlassian-1",
            "gav://opensymphony:webwork:2.2.7-atlassian-2",
            "gav://opensymphony:webwork:2.2.7-atlassian-3",
            "gav://opensymphony:webwork:2.2.7-atlassian-5",
            "gav://opensymphony:webwork:2.2.7-atlassian-6",
            "gav://com.opensymphony:webwork:2.2.6",
            "gav://opensymphony:webwork:1.4-atlassian-9",
            "gav://opensymphony:webwork:2.1",
            "gav://opensymphony:webwork:1.4-atlassian-4",
            "gav://opensymphony:webwork:2.0",
            "gav://opensymphony:webwork:1.4-atlassian-2",
            "gav://opensymphony:webwork:2.2",
            "gav://opensymphony:webwork:1.4-atlassian-1",
            "gav://com.opensymphony:xwork:2.0.4",
            "gav://opensymphony:xwork:1.2.5-rc1",
            "gav://opensymphony:xwork:1.0.1",
            "gav://opensymphony:webwork:1.4-atlassian-19",
            "gav://opensymphony:xwork:1.2.5-atlassian-1",
            "gav://opensymphony:xwork:1.2.5-atlassian-2",
            "gav://opensymphony:xwork:1.2.5-atlassian-4",
            "gav://opensymphony:xwork:1.0.4",
            "gav://opensymphony:xwork:1.0.3",
            "gav://opensymphony:xwork:1.2.5-atlassian-5",
            "gav://opensymphony:xwork:1.2.5-atlassian-6",
            "gav://opensymphony:xwork:1.2.5-atlassian-7",
            "gav://opensymphony:xwork:1.0.5",
            "gav://opensymphony:webwork:1.4-atlassian-10",
            "gav://opensymphony:webwork:1.4-atlassian-11",
            "gav://opensymphony:webwork:1.4-atlassian-12",
            "gav://opensymphony:webwork:1.4-atlassian-13",
            "gav://opensymphony:webwork:1.4-atlassian-15",
            "gav://opensymphony:webwork:1.4-atlassian-16",
            "gav://opensymphony:webwork:1.4-atlassian-17",
            "gav://opensymphony:xwork:1.2.3-20070717",
            "gav://opensymphony:webwork:1.4-atlassian-30",
            "gav://opensymphony:webwork:12Dec05-jiratld",
            "gav://opensymphony:xwork:1.2.5-atlassian-8",
            "gav://opensymphony:webwork:1.4",
            "gav://opensymphony:webwork:2.1.3",
            "gav://opensymphony:webwork:2.1.4",
            "gav://com.opensymphony:xwork:2.1.2",
            "gav://opensymphony:webwork:2.1.5",
            "gav://com.opensymphony:xwork:2.1.3",
            "gav://opensymphony:webwork:2.1.6",
            "gav://com.opensymphony:xwork:2.1.0",
            "gav://opensymphony:webwork:2.1.7",
            "gav://com.opensymphony:xwork:2.1.1",
            "gav://opensymphony:webwork:1.4-atlassian-22",
            "gav://opensymphony:webwork:1.4-atlassian-23",
            "gav://opensymphony:webwork:1.4-atlassian-24",
            "gav://opensymphony:webwork:1.4-atlassian-25",
            "gav://opensymphony:webwork:1.4-atlassian-27",
            "gav://opensymphony:xwork-src:1.1.3",
            "gav://opensymphony:xwork-tiger-src:1.2.2",
            "gav://opensymphony:xwork-tiger-src:1.2.3",
            "gav://opensymphony:xwork-tiger-src:1.2.1",
            "gav://org.apache.struts:struts2-embeddedjsp-plugin:2.2.1",
            "gav://opensymphony:xwork-src:1.1.1",
            "gav://org.apache.struts:struts2-archetype-blank:2.2.1",
            "gav://org.apache.struts:struts2-portlet:2.2.1",
            "gav://org.apache.struts:struts2-archetype-starter:2.2.1",
            "gav://org.apache.struts:struts2-spring-plugin:2.2.1",
            "gav://org.apache.struts:struts2-jasperreports-plugin:2.2.1",
            "gav://com.opensymphony:xwork-parent:2.1.6",
            "gav://com.opensymphony:xwork-parent:2.1.5",
            "gav://org.apache.struts:struts2-archetypes:2.2.1",
            "gav://org.apache.struts:struts2-assembly:2.2.1",
            "gav://com.opensymphony:xwork-parent:2.1.4",
            "gav://org.apache.struts:struts2-jboss-blank:2.2.1",
            "gav://org.apache.struts:struts2-sitegraph-plugin:2.2.1",
            "gav://org.apache.struts:struts2-showcase:2.2.1",
            "gav://com.opensymphony:xwork-core:2.1.5",
            "gav://org.apache.struts:struts2-core:2.2.1",
            "gav://com.opensymphony:xwork-core:2.1.4",
            "gav://org.apache.struts:struts2-portlet-plugin:2.2.1",
            "gav://com.opensymphony:xwork-core:2.1.6",
            "gav://org.apache.struts:struts2-osgi-demo-bundle:2.2.1",
            "gav://com.opensymphony.webwork:com.springsource.com.opensymphony.webwork:2.2.6",
            "gav://com.opensymphony.xwork:com.springsource.com.opensymphony.xwork:1.2.3",
            "gav://opensymphony:xwork-tiger-src:1.1.3",
            "gav://opensymphony:xwork-src:1.2.2",
            "gav://opensymphony:xwork-src:1.2.3",
            "gav://opensymphony:xwork-tiger-src:1.1.1",
            "gav://org.apache.struts:struts2-tiles-plugin:2.2.1",
            "gav://org.apache.struts:struts2-junit-plugin:2.2.1",
            "gav://opensymphony:webwork-src:2.2",
            "gav://opensymphony:xwork-src:1.2.1",
            "gav://org.apache.struts:struts2-dojo-plugin:2.2.1",
            "gav://org.apache.struts:struts2-json-plugin:2.2.1",
            "gav://org.apache.struts:struts2-osgi-bundles:2.2.1",
            "gav://org.apache.struts:struts2-osgi-admin-bundle:2.2.1",
            "gav://opensymphony:xwork-src:2.0-beta-1",
            "gav://opensymphony:xwork-src:2.0-beta-2",
            "gav://opensymphony:webwork-src:2.2.3",
            "gav://opensymphony:webwork-src:2.2.4",
            "gav://opensymphony:webwork-src:2.2.1",
            "gav://org.apache.struts:struts2-dwr-plugin:2.2.1",
            "gav://opensymphony:webwork-src:2.2.2",
            "gav://opensymphony:xwork-tiger:1.2",
            "gav://org.apache.struts:struts2-oval-plugin:2.2.1",
            "gav://opensymphony:xwork-tiger:1.1",
            "gav://org.apache.struts:struts2-codebehind-plugin:2.2.1",
            "gav://opensymphony:webwork-src:2.2.5",
            "gav://opensymphony:xwork-tiger:1.2.3",
            "gav://opensymphony:xwork-tiger:1.2.1",
            "gav://com.opensymphony.xwork:com.springsource.com.opensymphony.xwork:1.1.1",
            "gav://opensymphony:xwork-tiger:1.2.2",
            "gav://org.apache.struts:struts2-archetype-dbportlet:2.2.1",
            "gav://opensymphony:xwork-tiger-src:1.2",
            "gav://org.apache.struts:struts2-plexus-plugin:2.2.1",
            "gav://opensymphony:xwork-tiger-src:1.1",
            "gav://org.apache.struts:struts2-jfreechart-plugin:2.2.1",
            "gav://org.apache.struts:struts2-jsf-plugin:2.2.1",
            "gav://opensymphony:xwork-src:1.1",
            "gav://org.apache.struts:struts2-pell-multipart-plugin:2.2.1",
            "gav://opensymphony:xwork-src:1.2",
            "gav://com.opensymphony:xwork-assembly:2.1.4",
            "gav://org.apache.struts:struts2-rest-showcase:2.2.1",
            "gav://com.opensymphony:xwork-assembly:2.1.6",
            "gav://org.apache.struts:struts2-struts1-plugin:2.2.1",
            "gav://org.apache.struts:struts2-javatemplates-plugin:2.2.1",
            "gav://com.opensymphony:xwork-assembly:2.1.5",
            "gav://org.apache.struts:struts2-osgi-plugin:2.2.1",
            "gav://org.apache.struts:struts2-archetype-convention:2.2.1",
            "gav://opensymphony:xwork-tiger:2.0-beta-1",
            "gav://opensymphony:xwork-tiger-src:2.0-beta-1",
            "gav://org.apache.struts:struts2-archetype-plugin:2.2.1",
            "gav://opensymphony:xwork-tiger:1.1.3",
            "gav://opensymphony:xwork-tiger:1.1.1",
            "gav://org.apache.struts:struts2-blank:2.2.1",
            "gav://org.apache.struts:struts2-testng-plugin:2.2.1",
            "gav://org.apache.struts:struts2-parent:2.2.1",
            "gav://org.apache.struts:struts2-sitemesh-plugin:2.2.1",
            "gav://org.apache.struts:struts2-config-browser-plugin:2.2.1",
            "gav://org.apache.struts:struts2-convention-plugin:2.2.1",
            "gav://org.apache.struts:struts2-plugins:2.2.1",
            "gav://org.apache.struts:struts2-rest-plugin:2.2.1",
            "gav://org.apache.struts:struts2-apps:2.2.1",
            "gav://org.apache.struts.xwork:xwork-core:2.2.1",
            "gav://org.apache.struts:struts2-mailreader:2.2.1",
            "gav://com.opensymphony:xwork-plugins:2.1.4",
            "gav://com.opensymphony:xwork-plugins:2.1.5",
            "gav://com.opensymphony:xwork-plugins:2.1.6",
            "gav://org.apache.struts:struts2-archetype-portlet:2.2.1"
          ],
          "impacted_artifacts": [
            {
              "name": "pipeline-xray",
              "path": "LOCAL/builds/",
              "sha256": "f8fa924e200c8412075de89d867f1b8dd5aa343938754fb652f84ff472a75b97",
              "sha1": "",
              "depth": 0,
              "display_name": "pipeline-xray:294",
              "pkg_type": "Build",
              "parent_sha": "f8fa924e200c8412075de89d867f1b8dd5aa343938754fb652f84ff472a75b97",
              "impact_path": "",
              "infected_file": {
                "name": "xwork-2.0.6.jar",
                "path": "LOCAL/libs-release-local/com/opensymphony/xwork/2.0.6/",
                "sha256": "4baa7d0a7203ceeefa063a3782de733d417c4eae5ee5c0ab06e9e9e4607c004a",
                "sha1": "",
                "depth": 0,
                "parent_sha": "4baa7d0a7203ceeefa063a3782de733d417c4eae5ee5c0ab06e9e9e4607c004a",
                "display_name": "com.opensymphony:xwork:2.0.6",
                "pkg_type": "Maven"
              }
            }
          ]
        },
        {
          "severity": "Minor",
          "type": "security",
          "provider": "JFrog",
          "created": "2011-05-13T16:05:44+03:00",
          "summary": "CWE-79 Improper Neutralization of Input During Web Page Generation ('Cross-site Scripting')",
          "description": "Multiple cross-site scripting (XSS) vulnerabilities in XWork in Apache Struts 2.x before 2.2.3, and OpenSymphony XWork in OpenSymphony WebWork, allow remote attackers to inject arbitrary web script or HTML via vectors involving (1) an action name, (2) the action attribute of an s:submit element, or (3) the method attribute of an s:submit element.",
          "cve": "CVE-2011-1772",
          "component_ids": [
            "gav://opensymphony:xwork:1.0.3.6",
            "gav://opensymphony:xwork:1.0.3.5",
            "gav://opensymphony:xwork:1.0.3.4",
            "gav://opensymphony:xwork:1.0.3.3",
            "gav://opensymphony:xwork:1.1.1",
            "gav://opensymphony:xwork:1.0.3.2",
            "gav://opensymphony:xwork:1.0.3.1",
            "gav://opensymphony:xwork:1.1.3",
            "gav://opensymphony:webwork:2.1.5-atlassian-2",
            "gav://opensymphony:webwork:2.1.5-atlassian-3",
            "gav://opensymphony:webwork:2.2.1",
            "gav://opensymphony:webwork:2.2.2",
            "gav://opensymphony:webwork:2.2.3",
            "gav://opensymphony:xwork:2.0-beta-3-j4",
            "gav://opensymphony:xwork:2.0.1-j4",
            "gav://com.opensymphony:webwork:2.2.6-atlassian-3",
            "gav://opensymphony:webwork:2.2.4",
            "gav://opensymphony:webwork:2.2.5",
            "gav://com.opensymphony:webwork:2.2.6-atlassian-2",
            "gav://opensymphony:webwork:2.2.7",
            "gav://opensymphony:xwork:2.0.3",
            "gav://opensymphony:xwork:2.0.2",
            "gav://com.opensymphony:xwork:2.0.7",
            "gav://com.opensymphony:xwork:2.0.5",
            "gav://com.opensymphony:xwork:2.0.6",
            "gav://opensymphony:webwork:2.2.7-atlassian-25",
            "gav://opensymphony:webwork:2.2.7-atlassian-27",
            "gav://opensymphony:xwork:2.0.0-j4",
            "gav://opensymphony:xwork:1.2.2",
            "gav://opensymphony:xwork:1.2.1",
            "gav://opensymphony:webwork:2.2.7-atlassian-23",
            "gav://opensymphony:xwork:1.2.3",
            "gav://opensymphony:webwork:2.2.7-atlassian-24",
            "gav://opensymphony:xwork:2.0-beta-2",
            "gav://opensymphony:xwork:2.0-RC1",
            "gav://opensymphony:xwork:2.0-beta-3",
            "gav://opensymphony:xwork:2.0-RC1-j4",
            "gav://opensymphony:xwork:2.0-beta-1",
            "gav://opensymphony:xwork:2.0.1",
            "gav://opensymphony:xwork:2.0.0",
            "gav://opensymphony:xwork:1.1",
            "gav://opensymphony:xwork:1.2",
            "gav://opensymphony:xwork:1.0",
            "gav://opensymphony:webwork:2.2.7-atlassian-29",
            "gav://opensymphony:webwork:1.4-atlassian-26-testmvn2-1",
            "gav://opensymphony:webwork:2.2.7-atlassian-1",
            "gav://opensymphony:webwork:2.2.7-atlassian-2",
            "gav://opensymphony:webwork:2.2.7-atlassian-3",
            "gav://opensymphony:webwork:2.2.7-atlassian-5",
            "gav://opensymphony:webwork:2.2.7-atlassian-6",
            "gav://com.opensymphony:webwork:2.2.6",
            "gav://opensymphony:webwork:1.4-atlassian-9",
            "gav://opensymphony:webwork:2.1",
            "gav://opensymphony:webwork:1.4-atlassian-4",
            "gav://opensymphony:webwork:2.0",
            "gav://opensymphony:webwork:1.4-atlassian-2",
            "gav://opensymphony:webwork:2.2",
            "gav://opensymphony:webwork:1.4-atlassian-1",
            "gav://com.opensymphony:xwork:2.0.4",
            "gav://opensymphony:xwork:1.2.5-rc1",
            "gav://opensymphony:xwork:1.0.1",
            "gav://opensymphony:webwork:1.4-atlassian-19",
            "gav://opensymphony:xwork:1.2.5-atlassian-1",
            "gav://opensymphony:xwork:1.2.5-atlassian-2",
            "gav://opensymphony:xwork:1.2.5-atlassian-4",
            "gav://opensymphony:xwork:1.0.4",
            "gav://opensymphony:xwork:1.0.3",
            "gav://opensymphony:xwork:1.2.5-atlassian-5",
            "gav://opensymphony:xwork:1.2.5-atlassian-6",
            "gav://opensymphony:xwork:1.2.5-atlassian-7",
            "gav://opensymphony:xwork:1.0.5",
            "gav://opensymphony:webwork:1.4-atlassian-10",
            "gav://opensymphony:webwork:1.4-atlassian-11",
            "gav://opensymphony:webwork:1.4-atlassian-12",
            "gav://opensymphony:webwork:1.4-atlassian-13",
            "gav://opensymphony:webwork:1.4-atlassian-15",
            "gav://opensymphony:webwork:1.4-atlassian-16",
            "gav://opensymphony:webwork:1.4-atlassian-17",
            "gav://opensymphony:xwork:1.2.3-20070717",
            "gav://opensymphony:webwork:1.4-atlassian-30",
            "gav://opensymphony:webwork:12Dec05-jiratld",
            "gav://opensymphony:xwork:1.2.5-atlassian-8",
            "gav://opensymphony:webwork:1.4",
            "gav://opensymphony:webwork:2.1.3",
            "gav://opensymphony:webwork:2.1.4",
            "gav://com.opensymphony:xwork:2.1.2",
            "gav://opensymphony:webwork:2.1.5",
            "gav://com.opensymphony:xwork:2.1.3",
            "gav://opensymphony:webwork:2.1.6",
            "gav://com.opensymphony:xwork:2.1.0",
            "gav://opensymphony:webwork:2.1.7",
            "gav://com.opensymphony:xwork:2.1.1",
            "gav://opensymphony:webwork:1.4-atlassian-22",
            "gav://opensymphony:webwork:1.4-atlassian-23",
            "gav://opensymphony:webwork:1.4-atlassian-24",
            "gav://opensymphony:webwork:1.4-atlassian-25",
            "gav://opensymphony:webwork:1.4-atlassian-27",
            "gav://org.apache.struts:struts2-testng-plugin:2.1.6",
            "gav://org.apache.struts:struts2-sitegraph-plugin:2.0.12",
            "gav://org.apache.struts:struts2-sitegraph-plugin:2.0.11",
            "gav://org.apache.struts:struts2-portlet:2.2.1.1",
            "gav://org.apache.struts:struts2-testng-plugin:2.1.8",
            "gav://org.apache.struts:struts2-jfreechart-plugin:2.0.8",
            "gav://org.apache.struts:struts2-testng-plugin:2.1.2",
            "gav://org.apache.struts:struts2-jfreechart-plugin:2.0.5",
            "gav://org.apache.struts:struts2-jfreechart-plugin:2.0.6",
            "gav://org.apache.struts:struts2-portlet:2.2.1",
            "gav://org.apache.struts:struts2-archetype-starter:2.2.1.1",
            "gav://org.apache.struts:struts2-spring-plugin:2.2.1",
            "gav://org.apache.struts:struts2-config-browser-plugin:2.1.6",
            "gav://org.apache.struts:struts2-config-browser-plugin:2.1.8",
            "gav://org.apache.struts:struts2-config-browser-plugin:2.1.2",
            "gav://org.apache.struts:struts2-tiles-plugin:2.1.8.1",
            "gav://org.apache.struts:struts2-jfreechart-plugin:2.1.8",
            "gav://org.apache.struts:struts2-jsf-plugin:2.1.8",
            "gav://org.apache.struts:struts2-jsf-plugin:2.1.6",
            "gav://org.apache.struts:struts2-dojo-plugin:2.1.8.1",
            "gav://org.apache.struts:struts2-archetype-convention:2.2.1.1",
            "gav://org.apache.struts:struts2-spring-plugin:2.2.1.1",
            "gav://org.apache.struts:struts2-jsf-plugin:2.0.11.1",
            "gav://org.apache.struts:struts2-jfreechart-plugin:2.1.2",
            "gav://org.apache.struts:struts2-jsf-plugin:2.0.11.2",
            "gav://org.apache.struts:struts2-codebehind-plugin:2.0.11.1",
            "gav://org.apache.struts:struts2-jfreechart-plugin:2.1.6",
            "gav://org.apache.struts:struts2-codebehind-plugin:2.0.11.2",
            "gav://org.apache.struts:struts2-config-browser-plugin:2.0.6",
            "gav://org.apache.struts:struts2-config-browser-plugin:2.0.9",
            "gav://org.apache.struts:struts2-config-browser-plugin:2.0.8",
            "gav://org.apache.struts:struts2-jboss-blank:2.2.1.1",
            "gav://org.apache.struts:struts2-config-browser-plugin:2.0.5",
            "gav://org.apache.struts:struts2-dwr-plugin:2.2.1",
            "gav://org.apache.struts:struts-parent:2",
            "gav://org.apache.struts:struts2-oval-plugin:2.2.1",
            "gav://org.apache.struts:struts2-osgi-demo-bundle:2.2.1.1",
            "gav://org.apache.struts:struts2-jsf-plugin:2.0.8",
            "gav://org.apache.struts:struts2-jasperreports-plugin:2.2.1.1",
            "gav://org.apache.struts:struts2-jsf-plugin:2.0.9",
            "gav://org.apache.struts:struts2-jsf-plugin:2.0.6",
            "gav://org.apache.struts:struts2-testng-plugin:2.2.1.1",
            "gav://org.apache.struts:struts2-jsf-plugin:2.0.5",
            "gav://org.apache.struts:struts2-jsf-plugin:2.2.1.1",
            "gav://org.apache.struts:struts2-rest-plugin:2.1.8.1",
            "gav://org.apache.struts:struts2-plexus-plugin:2.1.8.1",
            "gav://org.apache.struts:struts2-jfreechart-plugin:2.2.1",
            "gav://org.apache.struts:struts2-config-browser-plugin:2.2.1.1",
            "gav://org.apache.struts:struts2-archetype-blank:2.2.1.1",
            "gav://org.apache.struts:struts2-archetype-convention:2.2.1",
            "gav://org.apache.struts:struts2-oval-plugin:2.1.8",
            "gav://opensymphony:xwork-tiger:2.0-beta-1",
            "gav://org.apache.struts:struts2-osgi-admin-bundle:2.1.8.1",
            "gav://org.apache.struts:struts2-rest-showcase:2.2.1.1",
            "gav://org.apache.struts:struts2-config-browser-plugin:2.0.14",
            "gav://org.apache.empire-db:empire-db-struts2:2.0.6-incubating",
            "gav://org.apache.struts:struts2-parent:2.2.1",
            "gav://org.apache.struts:struts2-config-browser-plugin:2.0.11",
            "gav://org.apache.struts:struts2-config-browser-plugin:2.0.12",
            "gav://org.apache.struts:struts2-pell-multipart-plugin:2.0.12",
            "gav://org.apache.struts:struts2-osgi-demo-bundle:2.1.8.1",
            "gav://org.apache.struts:struts2-pell-multipart-plugin:2.0.11",
            "gav://org.apache.struts:struts2-config-browser-plugin:2.2.1",
            "gav://org.apache.struts:struts2-dwr-plugin:2.2.1.1",
            "gav://org.apache.struts:struts2-pell-multipart-plugin:2.0.14",
            "gav://org.apache.struts:struts2-jasperreports-plugin:2.0.12",
            "gav://org.apache.struts:struts2-parent:2.2.1.1",
            "gav://org.apache.struts:struts2-jasperreports-plugin:2.0.11",
            "gav://org.apache.struts:struts2-jfreechart-plugin:2.2.1.1",
            "gav://org.apache.struts:struts2-jasperreports-plugin:2.0.14",
            "gav://opensymphony:xwork-tiger-src:1.2.2",
            "gav://org.apache.struts:struts2-testng-plugin:2.1.8.1",
            "gav://opensymphony:xwork-tiger-src:1.2.3",
            "gav://opensymphony:xwork-tiger-src:1.2.1",
            "gav://org.apache.struts:struts2-tiles-plugin:2.1.2",
            "gav://org.apache.struts:struts2-struts1-plugin:2.0.9",
            "gav://org.apache.struts:struts2-tiles-plugin:2.1.8",
            "gav://org.apache.struts:struts2-struts1-plugin:2.0.5",
            "gav://org.apache.struts:struts2-struts1-plugin:2.0.6",
            "gav://org.apache.struts:struts2-struts1-plugin:2.0.8",
            "gav://org.apache.struts:struts2-tiles-plugin:2.1.6",
            "gav://org.apache.struts:struts2-spring-plugin:2.1.8.1",
            "gav://org.apache.struts:struts2-osgi-bundles:2.1.8",
            "gav://org.apache.struts:struts2-tiles-plugin:2.2.1.1",
            "gav://org.apache.struts:struts2-jasperreports-plugin:2.2.1",
            "gav://com.opensymphony:xwork-parent:2.1.6",
            "gav://com.opensymphony:xwork-parent:2.1.5",
            "gav://org.apache.struts:struts2-archetypes:2.2.1",
            "gav://com.opensymphony:xwork-parent:2.1.4",
            "gav://org.apache.struts:struts2-sitegraph-plugin:2.2.1",
            "gav://org.apache.struts:struts2-showcase:2.2.1",
            "gav://org.apache.struts:struts2-mailreader:2.0.14",
            "gav://com.opensymphony:xwork-core:2.1.5",
            "gav://com.opensymphony:xwork-core:2.1.4",
            "gav://org.apache.struts:struts2-osgi-plugin:2.1.8",
            "gav://org.apache.struts:struts2-apps:2.0.11",
            "gav://org.apache.struts:struts2-mailreader:2.1.2",
            "gav://org.apache.struts:struts2-embeddedjsp-plugin:2.2.1.1",
            "gav://org.apache.struts:struts2-showcase:2.2.1.1",
            "gav://org.apache.struts:struts2-spring-plugin:2.0.11",
            "gav://org.apache.struts:struts2-spring-plugin:2.0.12",
            "gav://org.apache.struts:struts2-apps:2.0.12",
            "gav://com.opensymphony:xwork-core:2.1.6",
            "gav://org.apache.struts:struts2-mailreader:2.1.6",
            "gav://org.apache.struts:struts2-apps:2.0.14",
            "gav://com.opensymphony.webwork:com.springsource.com.opensymphony.webwork:2.2.6",
            "gav://org.apache.struts:struts2-mailreader:2.1.8",
            "gav://opensymphony:xwork-tiger-src:1.1.3",
            "gav://opensymphony:xwork-tiger-src:1.1.1",
            "gav://org.apache.struts:struts2-tiles-plugin:2.2.1",
            "gav://org.apache.struts:struts2-struts1-plugin:2.1.8",
            "gav://org.apache.struts:struts2-junit-plugin:2.2.1",
            "gav://org.apache.struts:struts2-spring-plugin:2.0.14",
            "gav://org.apache.struts:struts2-apps:2.1.8.1",
            "gav://org.apache.struts:struts2-spring-plugin:2.0.11.2",
            "gav://org.apache.struts:struts2-struts1-plugin:2.1.6",
            "gav://org.apache.struts:struts2-spring-plugin:2.0.11.1",
            "gav://org.apache.struts:struts2-sitegraph-plugin:2.1.6",
            "gav://org.apache.struts:struts2-struts1-plugin:2.1.2",
            "gav://org.apache.struts:struts2-sitegraph-plugin:2.1.8",
            "gav://org.apache.struts:struts2-struts1-plugin:2.0.14",
            "gav://org.apache.struts:struts2-jasperreports-plugin:2.1.2",
            "gav://org.apache.struts:struts2-jfreechart-plugin:2.0.14",
            "gav://org.apache.struts:struts2-osgi-bundles:2.2.1",
            "gav://org.apache.struts:struts2-mailreader:2.0.11",
            "gav://org.apache.struts:struts2-struts1-plugin:2.0.11",
            "gav://org.apache.struts:struts2-struts1-plugin:2.0.12",
            "gav://org.apache.struts:struts2-mailreader:2.0.12",
            "gav://org.apache.struts:struts2-jfreechart-plugin:2.0.11",
            "gav://org.apache.struts:struts2-sitegraph-plugin:2.1.2",
            "gav://org.apache.struts:struts2-jfreechart-plugin:2.0.12",
            "gav://org.apache.struts:struts2-jasperreports-plugin:2.0.11.2",
            "gav://org.apache.struts:struts2-jasperreports-plugin:2.0.11.1",
            "gav://org.apache.struts:struts2-mailreader:2.0.8",
            "gav://org.apache.struts:struts2-mailreader:2.0.6",
            "gav://opensymphony:xwork-tiger:1.2.3",
            "gav://org.apache.struts:struts2-mailreader:2.0.5",
            "gav://org.apache.struts:struts2-mailreader:2.2.1.1",
            "gav://opensymphony:xwork-tiger:1.2.1",
            "gav://opensymphony:xwork-tiger:1.2.2",
            "gav://org.apache.struts:struts2-mailreader:2.0.9",
            "gav://org.apache.struts:struts2-portlet-plugin:2.1.8.1",
            "gav://org.apache.struts:struts2-pell-multipart-plugin:2.1.8.1",
            "gav://org.apache.struts:struts2-junit-plugin:2.2.1.1",
            "gav://org.apache.struts:struts2-junit-plugin:2.1.2",
            "gav://org.apache.struts:struts2-jsf-plugin:2.2.1",
            "gav://opensymphony:xwork-src:1.1",
            "gav://org.apache.struts:struts2-portlet:2.0.6",
            "gav://opensymphony:xwork-src:1.2",
            "gav://org.apache.struts:struts2-portlet:2.0.5",
            "gav://org.apache.struts:struts2-sitegraph-plugin:2.0.6",
            "gav://org.apache.struts:struts2-spring-plugin:2.0.5",
            "gav://org.apache.struts:struts2-struts1-plugin:2.2.1",
            "gav://org.apache.struts:struts2-junit-plugin:2.1.8",
            "gav://org.apache.struts:struts2-sitegraph-plugin:2.0.8",
            "gav://org.apache.struts:struts2-osgi-plugin:2.2.1",
            "gav://org.apache.struts:struts2-sitegraph-plugin:2.0.9",
            "gav://org.apache.struts:struts2-sitemesh-plugin:2.0.12",
            "gav://org.apache.struts:struts2-junit-plugin:2.1.6",
            "gav://org.apache.struts:struts2-sitemesh-plugin:2.0.11",
            "gav://org.apache.struts:struts2-apps:2.0.11.1",
            "gav://org.apache.struts:struts2-apps:2.0.11.2",
            "gav://org.apache.struts:struts2-sitemesh-plugin:2.0.14",
            "gav://org.apache.struts:struts2-spring-plugin:2.0.8",
            "gav://org.apache.struts:struts2-spring-plugin:2.0.9",
            "gav://org.apache.struts:struts2-spring-plugin:2.0.6",
            "gav://org.apache.struts:struts2-sitegraph-plugin:2.0.5",
            "gav://org.apache.struts:struts2-javatemplates-plugin:2.2.1.1",
            "gav://org.apache.struts:struts2-jasperreports-plugin:2.1.8.1",
            "gav://org.apache.struts:struts2-showcase:2.0.5",
            "gav://org.apache.struts:struts2-showcase:2.0.6",
            "gav://org.apache.struts:struts2-showcase:2.0.8",
            "gav://org.apache.struts:struts2-sitemesh-plugin:2.1.8.1",
            "gav://org.apache.struts:struts2-showcase:2.0.9",
            "gav://org.apache.struts:struts2-jasperreports-plugin:2.1.6",
            "gav://org.apache.struts:struts2-jasperreports-plugin:2.1.8",
            "gav://org.apache.struts:struts2-rest-plugin:2.1.2",
            "gav://org.apache.struts:struts2-rest-plugin:2.2.1.1",
            "gav://org.apache.struts:struts2-portlet:2.0.9",
            "gav://org.apache.struts:struts2-rest-plugin:2.1.6",
            "gav://org.apache.struts:struts2-portlet:2.0.8",
            "gav://org.apache.struts:struts2-rest-plugin:2.1.8",
            "gav://opensymphony:xwork-tiger:1.1.3",
            "gav://opensymphony:xwork-tiger:1.1.1",
            "gav://org.apache.struts:struts2-oval-plugin:2.2.1.1",
            "gav://org.apache.struts:struts2-pell-multipart-plugin:2.0.11.2",
            "gav://org.apache.struts:struts2-tiles-plugin:2.0.8",
            "gav://org.apache.struts:struts2-jsf-plugin:2.1.2",
            "gav://org.apache.struts:struts2-pell-multipart-plugin:2.0.11.1",
            "gav://org.apache.struts:struts2-tiles-plugin:2.0.9",
            "gav://org.apache.struts:struts2-tiles-plugin:2.0.5",
            "gav://org.apache.struts:struts2-tiles-plugin:2.0.6",
            "gav://org.apache.struts:struts2-portlet:2.1.2",
            "gav://org.apache.struts:struts2-spring-plugin:2.1.2",
            "gav://org.apache.struts:struts2-osgi-bundles:2.2.1.1",
            "gav://org.apache.struts:struts2-sitemesh-plugin:2.2.1",
            "gav://org.apache.struts:struts2-spring-plugin:2.1.8",
            "gav://org.apache.struts:struts2-tiles-plugin:2.0.11.1",
            "gav://org.apache.struts:struts2-spring-plugin:2.1.6",
            "gav://org.apache.struts:struts2-showcase:2.1.2",
            "gav://org.apache.struts:struts2-tiles-plugin:2.0.11.2",
            "gav://org.apache.struts:struts2-jfreechart-plugin:2.0.11.1",
            "gav://org.apache.struts:struts2-jfreechart-plugin:2.0.11.2",
            "gav://org.apache.struts:struts2-showcase:2.1.6",
            "gav://org.apache.struts:struts2-parent:2.0.11.2",
            "gav://org.apache.struts:struts2-showcase:2.1.8",
            "gav://org.apache.struts:struts2-parent:2.0.11.1",
            "gav://org.apache.struts:struts2-portlet:2.1.8.1",
            "gav://org.apache.struts:struts2-jasperreports-plugin:2.0.6",
            "gav://org.apache.struts:struts2-jasperreports-plugin:2.0.5",
            "gav://org.apache.struts:struts2-jasperreports-plugin:2.0.8",
            "gav://org.apache.struts:struts2-jasperreports-plugin:2.0.9",
            "gav://org.apache.struts:struts2-rest-plugin:2.2.1",
            "gav://org.apache.archiva.redback:redback-struts2:2.0",
            "gav://org.apache.struts:struts2-portlet:2.1.8",
            "gav://org.apache.struts:struts2-portlet:2.1.6",
            "gav://org.apache.struts:struts2-sitegraph-plugin:2.0.14",
            "gav://org.apache.empire-db:empire-db-struts2:2.1.0-incubating",
            "gav://opensymphony:xwork-src:1.1.3",
            "gav://org.apache.struts:struts2-blank:2.1.2",
            "gav://org.apache.empire-db:empire-db-struts2:2.0.7-incubating",
            "gav://org.apache.struts:struts2-sitemesh-plugin:2.1.6",
            "gav://org.apache.struts:struts2-blank:2.1.8",
            "gav://org.apache.struts:struts2-sitemesh-plugin:2.1.8",
            "gav://org.apache.struts:struts2-blank:2.1.6",
            "gav://opensymphony:xwork-src:1.1.1",
            "gav://org.apache.struts:struts2-archetype-blank:2.2.1",
            "gav://org.apache.struts:struts2-pell-multipart-plugin:2.0.8",
            "gav://org.apache.struts:struts2-archetype-starter:2.2.1",
            "gav://org.apache.struts:struts2-pell-multipart-plugin:2.0.6",
            "gav://org.apache.struts:struts2-pell-multipart-plugin:2.0.5",
            "gav://org.apache.struts:struts2-sitemesh-plugin:2.1.2",
            "gav://org.apache.struts:struts2-pell-multipart-plugin:2.0.9",
            "gav://org.apache.struts:struts2-assembly:2.2.1",
            "gav://org.apache.struts:struts2-codebehind-plugin:2.0.14",
            "gav://org.apache.struts:struts2-convention-plugin:2.1.8",
            "gav://org.apache.struts:struts2-jboss-blank:2.2.1",
            "gav://org.apache.struts:struts2-codebehind-plugin:2.0.12",
            "gav://org.apache.struts:struts2-convention-plugin:2.1.6",
            "gav://org.apache.struts:struts2-codebehind-plugin:2.0.11",
            "gav://org.apache.struts:struts2-parent:2.1.8.1",
            "gav://org.apache.struts:struts2-core:2.2.1",
            "gav://org.apache.struts:struts2-codebehind-plugin:2.1.6",
            "gav://org.apache.struts:struts2-codebehind-plugin:2.1.2",
            "gav://org.apache.struts:struts2-apps:2.1.2",
            "gav://org.apache.struts:struts2-json-plugin:2.1.8",
            "gav://org.apache.struts:struts2-archetype-portlet:2.2.1.1",
            "gav://org.apache.struts:struts2-apps:2.1.6",
            "gav://org.apache.struts:struts2-portlet-plugin:2.2.1",
            "gav://org.apache.struts:struts2-core:2.1.8.1",
            "gav://org.apache.struts:struts2-apps:2.1.8",
            "gav://opensymphony:xwork-src:1.2.2",
            "gav://opensymphony:xwork-src:1.2.3",
            "gav://org.apache.struts:struts2-sitemesh-plugin:2.0.5",
            "gav://org.apache.struts:struts2-sitemesh-plugin:2.0.6",
            "gav://org.apache.struts:struts2-sitemesh-plugin:2.0.8",
            "gav://org.apache.struts:struts2-blank:2.0.9",
            "gav://org.apache.struts:struts2-blank:2.0.8",
            "gav://org.apache.struts:struts2-sitemesh-plugin:2.0.9",
            "gav://org.apache.struts:struts2-blank:2.0.6",
            "gav://opensymphony:xwork-src:1.2.1",
            "gav://org.apache.struts:struts2-blank:2.0.5",
            "gav://org.apache.struts:struts2-junit-plugin:2.1.8.1",
            "gav://org.apache.struts:struts2-core:2.0.11.1",
            "gav://org.apache.struts:struts2-dojo-plugin:2.2.1",
            "gav://org.apache.struts:struts2-json-plugin:2.2.1",
            "gav://org.apache.struts:struts2-core:2.0.11.2",
            "gav://org.apache.struts:struts2-osgi-admin-bundle:2.2.1",
            "gav://org.apache.struts:struts2-plugins:2.2.1.1",
            "gav://org.apache.struts:struts2-codebehind-plugin:2.2.1",
            "gav://org.apache.struts:struts2-apps:2.0.8",
            "gav://org.apache.struts:struts2-portlet-plugin:2.1.6",
            "gav://org.apache.struts:struts2-apps:2.0.6",
            "gav://org.apache.struts:struts2-apps:2.0.5",
            "gav://org.apache.struts:struts2-portlet-plugin:2.1.2",
            "gav://org.apache.struts:struts2-osgi-plugin:2.1.8.1",
            "gav://org.apache.struts:struts2-apps:2.0.9",
            "gav://org.apache.struts:struts2-showcase:2.1.8.1",
            "gav://org.apache.struts:struts2-portlet:2.0.11.2",
            "gav://org.apache.struts:struts2-portlet:2.0.11.1",
            "gav://org.apache.struts:struts2-portlet-plugin:2.1.8",
            "gav://org.apache.struts:struts2-osgi-bundles:2.1.8.1",
            "gav://org.apache.struts:struts2-codebehind-plugin:2.1.8.1",
            "gav://org.apache.struts:struts2-json-plugin:2.2.1.1",
            "gav://org.apache.struts:struts2-blank:2.0.11.2",
            "gav://org.apache.struts:struts2-pell-multipart-plugin:2.2.1",
            "gav://org.apache.struts:struts2-blank:2.0.11.1",
            "gav://com.opensymphony:xwork-assembly:2.1.4",
            "gav://org.apache.struts:struts2-plexus-plugin:2.0.11.2",
            "gav://com.opensymphony:xwork-assembly:2.1.6",
            "gav://org.apache.struts:struts2-javatemplates-plugin:2.2.1",
            "gav://org.apache.struts:struts2-dojo-plugin:2.1.2",
            "gav://org.apache.struts:struts2-convention-plugin:2.1.8.1",
            "gav://com.opensymphony:xwork-assembly:2.1.5",
            "gav://org.apache.struts:struts2-plexus-plugin:2.0.11.1",
            "gav://org.apache.struts:struts2-dojo-plugin:2.1.6",
            "gav://org.apache.struts:struts2-sitegraph-plugin:2.1.8.1",
            "gav://org.apache.struts:struts2-codebehind-plugin:2.0.8",
            "gav://org.apache.struts:struts2-codebehind-plugin:2.0.9",
            "gav://org.apache.struts:struts2-dojo-plugin:2.1.8",
            "gav://org.apache.struts:struts2-core:2.0.9",
            "gav://org.apache.struts:struts2-core:2.0.8",
            "gav://org.apache.struts:struts2-core:2.0.5",
            "gav://org.apache.struts:struts2-core:2.0.6",
            "gav://org.apache.struts:struts2-archetype-dbportlet:2.2.1.1",
            "gav://org.apache.struts:struts2-struts1-plugin:2.2.1.1",
            "gav://opensymphony:xwork-tiger-src:2.0-beta-1",
            "gav://org.apache.struts:struts2-pell-multipart-plugin:2.2.1.1",
            "gav://org.apache.struts:struts2-assembly:2.0.14",
            "gav://org.apache.archiva.redback:redback-struts2-content:2.0",
            "gav://org.apache.struts:struts2-assembly:2.0.11",
            "gav://org.apache.struts:struts2-blank:2.2.1",
            "gav://org.apache.struts:struts2-pell-multipart-plugin:2.1.2",
            "gav://org.apache.struts:struts2-blank:2.1.8.1",
            "gav://org.apache.struts:struts2-pell-multipart-plugin:2.1.6",
            "gav://org.apache.struts:struts2-pell-multipart-plugin:2.1.8",
            "gav://org.apache.struts:struts2-codebehind-plugin:2.1.8",
            "gav://org.apache.struts:struts2-convention-plugin:2.2.1",
            "gav://org.apache.struts:struts2-core:2.1.8",
            "gav://org.apache.struts:struts2-javatemplates-plugin:2.1.8",
            "gav://org.apache.struts:struts2-portlet-plugin:2.2.1.1",
            "gav://org.apache.struts:struts2-javatemplates-plugin:2.1.6",
            "gav://org.apache.struts:struts2-embeddedjsp-plugin:2.1.8.1",
            "gav://org.apache.struts:struts2-core:2.1.6",
            "gav://org.apache.struts:struts2-sitemesh-plugin:2.0.11.2",
            "gav://org.apache.struts:struts2-sitemesh-plugin:2.0.11.1",
            "gav://org.apache.struts:struts2-core:2.1.2",
            "gav://org.apache.struts:struts2-config-browser-plugin:2.0.11.2",
            "gav://org.apache.struts:struts2-codebehind-plugin:2.0.6",
            "gav://org.apache.struts:struts2-config-browser-plugin:2.0.11.1",
            "gav://org.apache.struts:struts2-codebehind-plugin:2.0.5",
            "gav://org.apache.struts:struts2-plugins:2.0.12",
            "gav://org.apache.struts:struts2-plugins:2.0.11",
            "gav://org.apache.struts:struts2-mailreader:2.2.1",
            "gav://org.apache.struts:struts2-plugins:2.0.14",
            "gav://com.opensymphony:xwork-plugins:2.1.4",
            "gav://org.apache.struts:struts2-osgi-demo-bundle:2.1.8",
            "gav://com.opensymphony:xwork-plugins:2.1.5",
            "gav://com.opensymphony:xwork-plugins:2.1.6",
            "gav://org.apache.struts:struts2-archetype-starter:2.0.11.2",
            "gav://org.apache.struts:struts2-blank:2.2.1.1",
            "gav://org.apache.struts:struts2-plexus-plugin:2.0.5",
            "gav://org.apache.struts:struts2-embeddedjsp-plugin:2.2.1",
            "gav://org.apache.struts:struts2-plexus-plugin:2.0.6",
            "gav://org.apache.struts:struts2-jsf-plugin:2.0.14",
            "gav://org.apache.struts:struts2-jsf-plugin:2.0.11",
            "gav://org.apache.struts:struts2-plexus-plugin:2.0.8",
            "gav://org.apache.struts:struts2-jsf-plugin:2.0.12",
            "gav://org.apache.struts:struts2-plexus-plugin:2.0.9",
            "gav://org.apache.struts:struts2-dwr-plugin:2.1.8.1",
            "gav://org.apache.struts:struts2-tiles-plugin:2.0.12",
            "gav://org.apache.struts:struts2-tiles-plugin:2.0.11",
            "gav://org.apache.struts:struts2-tiles-plugin:2.0.14",
            "gav://org.apache.struts:struts2-plugins:2.1.8.1",
            "gav://org.apache.struts:struts2-parent:2.1.2",
            "gav://org.apache.struts:struts2-parent:2.1.8",
            "gav://org.apache.struts:struts2-oval-plugin:2.1.8.1",
            "gav://org.apache.struts:struts2-parent:2.1.6",
            "gav://org.apache.struts:struts2-osgi-demo-bundle:2.2.1",
            "gav://com.opensymphony.xwork:com.springsource.com.opensymphony.xwork:1.2.3",
            "gav://org.apache.struts:struts2-core:2.2.1.1",
            "gav://org.apache.struts:struts2-plexus-plugin:2.1.2",
            "gav://opensymphony:webwork-src:2.2",
            "gav://org.apache.struts:struts2-plexus-plugin:2.1.6",
            "gav://org.apache.struts:struts2-plexus-plugin:2.1.8",
            "gav://org.apache.struts:struts2-sitegraph-plugin:2.2.1.1",
            "gav://org.apache.struts:struts2-core:2.0.12",
            "gav://org.apache.struts:struts2-core:2.0.11",
            "gav://org.apache.struts:struts2-core:2.0.14",
            "gav://org.apache.struts:struts2-assembly:2.2.1.1",
            "gav://org.apache.struts:struts2-mailreader:2.0.11.1",
            "gav://org.apache.struts:struts2-plugins:2.0.11.1",
            "gav://org.apache.struts:struts2-mailreader:2.0.11.2",
            "gav://org.apache.struts:struts2-plugins:2.0.11.2",
            "gav://org.apache.struts:struts2-parent:2.0.9",
            "gav://org.apache.struts:struts2-api:2.0.5",
            "gav://opensymphony:xwork-src:2.0-beta-1",
            "gav://org.apache.struts:struts2-parent:2.0.6",
            "gav://org.apache.struts:struts2-archetype-plugin:2.2.1.1",
            "gav://opensymphony:xwork-src:2.0-beta-2",
            "gav://org.apache.struts:struts2-parent:2.0.5",
            "gav://org.apache.struts:struts2-parent:2.0.8",
            "gav://opensymphony:webwork-src:2.2.3",
            "gav://org.apache.struts:struts2-plugins:2.0.9",
            "gav://opensymphony:webwork-src:2.2.4",
            "gav://opensymphony:webwork-src:2.2.1",
            "gav://opensymphony:webwork-src:2.2.2",
            "gav://org.apache.struts:struts2-struts1-plugin:2.0.11.1",
            "gav://org.apache.struts:struts2-struts1-plugin:2.0.11.2",
            "gav://opensymphony:xwork-tiger:1.2",
            "gav://opensymphony:xwork-tiger:1.1",
            "gav://org.apache.struts:struts2-plugins:2.0.6",
            "gav://org.apache.struts:struts2-plugins:2.0.5",
            "gav://org.apache.struts:struts2-plugins:2.0.8",
            "gav://opensymphony:webwork-src:2.2.5",
            "gav://org.apache.struts:struts2-sitemesh-plugin:2.2.1.1",
            "gav://org.apache.struts:struts2-struts1-plugin:2.1.8.1",
            "gav://com.opensymphony.xwork:com.springsource.com.opensymphony.xwork:1.1.1",
            "gav://org.apache.struts:struts2-archetype-dbportlet:2.2.1",
            "gav://opensymphony:xwork-tiger-src:1.2",
            "gav://org.apache.struts:struts2-plexus-plugin:2.2.1",
            "gav://opensymphony:xwork-tiger-src:1.1",
            "gav://org.apache.struts:struts2-plexus-plugin:2.0.14",
            "gav://org.apache.struts:struts2-rest-showcase:2.2.1",
            "gav://org.apache.struts:struts2-blank:2.0.12",
            "gav://org.apache.archiva.redback:redback-struts2-integration:2.0",
            "gav://org.apache.struts:struts2-javatemplates-plugin:2.1.8.1",
            "gav://org.apache.struts:struts2-blank:2.0.11",
            "gav://org.apache.struts:struts2-showcase:2.0.11.1",
            "gav://org.apache.struts:struts2-osgi-admin-bundle:2.1.8",
            "gav://org.apache.struts:struts2-showcase:2.0.11.2",
            "gav://org.apache.struts:struts2-plugins:2.1.8",
            "gav://org.apache.struts:struts2-dwr-plugin:2.1.2",
            "gav://org.apache.struts:struts2-rest-showcase:2.1.8.1",
            "gav://org.apache.struts.xwork:xwork-core:2.2.1.1",
            "gav://org.apache.struts:struts2-plugins:2.1.2",
            "gav://org.apache.struts:struts2-codebehind-plugin:2.2.1.1",
            "gav://org.apache.struts:struts2-plugins:2.1.6",
            "gav://org.apache.struts:struts2-jsf-plugin:2.1.8.1",
            "gav://org.apache.struts:struts2-portlet:2.0.12",
            "gav://org.apache.struts:struts2-embeddedjsp-plugin:2.1.8",
            "gav://org.apache.struts:struts2-portlet:2.0.14",
            "gav://org.apache.struts:struts2-archetype-plugin:2.2.1",
            "gav://org.apache.struts:struts2-jfreechart-plugin:2.1.8.1",
            "gav://org.apache.struts:struts2-config-browser-plugin:2.1.8.1",
            "gav://org.apache.struts:struts2-osgi-plugin:2.2.1.1",
            "gav://org.apache.struts:struts2-portlet:2.0.11",
            "gav://org.apache.struts:struts2-convention-plugin:2.2.1.1",
            "gav://org.apache.struts:struts2-mailreader:2.1.8.1",
            "gav://org.apache.struts:struts2-parent:2.0.12",
            "gav://org.apache.struts:struts2-testng-plugin:2.2.1",
            "gav://org.apache.struts:struts2-parent:2.0.11",
            "gav://org.apache.struts:struts2-rest-showcase:2.1.2",
            "gav://org.apache.struts:struts2-parent:2.0.14",
            "gav://org.apache.struts:struts2-rest-showcase:2.1.6",
            "gav://org.apache.struts:struts2-rest-showcase:2.1.8",
            "gav://org.apache.struts:struts2-sitegraph-plugin:2.0.11.1",
            "gav://org.apache.struts:struts2-sitegraph-plugin:2.0.11.2",
            "gav://org.apache.struts:struts2-dwr-plugin:2.1.8",
            "gav://org.apache.struts:struts2-dwr-plugin:2.1.6",
            "gav://org.apache.struts:struts2-archetypes:2.2.1.1",
            "gav://org.apache.empire-db:empire-db-struts2:2.0.5-incubating",
            "gav://org.apache.struts:struts2-dojo-plugin:2.2.1.1",
            "gav://org.apache.struts:struts2-plugins:2.2.1",
            "gav://org.apache.struts:struts2-json-plugin:2.1.8.1",
            "gav://org.apache.struts:struts2-apps:2.2.1",
            "gav://org.apache.struts:struts2-blank:2.0.14",
            "gav://org.apache.struts.xwork:xwork-core:2.2.1",
            "gav://org.apache.struts:struts2-plexus-plugin:2.2.1.1",
            "gav://org.apache.struts:struts2-jfreechart-plugin:2.0.9",
            "gav://org.apache.struts:struts2-osgi-admin-bundle:2.2.1.1",
            "gav://org.apache.struts:struts2-plexus-plugin:2.0.11",
            "gav://org.apache.struts:struts2-plexus-plugin:2.0.12",
            "gav://org.apache.struts:struts2-showcase:2.0.14",
            "gav://org.apache.struts:struts2-apps:2.2.1.1",
            "gav://org.apache.struts:struts2-showcase:2.0.11",
            "gav://org.apache.struts:struts2-archetype-portlet:2.2.1",
            "gav://org.apache.struts:struts2-showcase:2.0.12"
          ],
          "impacted_artifacts": [
            {
              "name": "pipeline-xray",
              "path": "LOCAL/builds/",
              "sha256": "f8fa924e200c8412075de89d867f1b8dd5aa343938754fb652f84ff472a75b97",
              "sha1": "",
              "depth": 0,
              "display_name": "pipeline-xray:294",
              "pkg_type": "Build",
              "parent_sha": "f8fa924e200c8412075de89d867f1b8dd5aa343938754fb652f84ff472a75b97",
              "impact_path": "",
              "infected_file": {
                "name": "xwork-2.0.6.jar",
                "path": "LOCAL/libs-release-local/com/opensymphony/xwork/2.0.6/",
                "sha256": "4baa7d0a7203ceeefa063a3782de733d417c4eae5ee5c0ab06e9e9e4607c004a",
                "sha1": "",
                "depth": 0,
                "parent_sha": "4baa7d0a7203ceeefa063a3782de733d417c4eae5ee5c0ab06e9e9e4607c004a",
                "display_name": "com.opensymphony:xwork:2.0.6",
                "pkg_type": "Maven"
              }
            }
          ]
        }
      ],
      "top_severity": "Major",
      "watch_name": "all"
    },
    {
      "created": "2017-01-11T12:31:35.816224803+02:00",
      "issues": [
        {
          "severity": "Major",
          "type": "security",
          "provider": "JFrog",
          "created": "2011-05-13T16:05:45+03:00",
          "summary": "CWE-200 Information Exposure",
          "description": "XWork 2.2.1 in Apache Struts 2.2.1, and OpenSymphony XWork in OpenSymphony WebWork, allows remote attackers to obtain potentially sensitive information about internal Java class paths via vectors involving an s:submit element and a nonexistent method, a different vulnerability than CVE-2011-1772.3.",
          "cve": "CVE-2011-2088",
          "component_ids": [
            "gav://opensymphony:xwork:1.0.3.6",
            "gav://opensymphony:xwork:1.0.3.5",
            "gav://opensymphony:xwork:1.0.3.4",
            "gav://opensymphony:xwork:1.0.3.3",
            "gav://opensymphony:xwork:1.1.1",
            "gav://opensymphony:xwork:1.0.3.2",
            "gav://opensymphony:xwork:1.0.3.1",
            "gav://opensymphony:xwork:1.1.3",
            "gav://opensymphony:webwork:2.1.5-atlassian-2",
            "gav://opensymphony:webwork:2.1.5-atlassian-3",
            "gav://opensymphony:webwork:2.2.1",
            "gav://opensymphony:webwork:2.2.2",
            "gav://opensymphony:webwork:2.2.3",
            "gav://opensymphony:xwork:2.0-beta-3-j4",
            "gav://opensymphony:xwork:2.0.1-j4",
            "gav://com.opensymphony:webwork:2.2.6-atlassian-3",
            "gav://opensymphony:webwork:2.2.4",
            "gav://opensymphony:webwork:2.2.5",
            "gav://com.opensymphony:webwork:2.2.6-atlassian-2",
            "gav://opensymphony:webwork:2.2.7",
            "gav://opensymphony:xwork:2.0.3",
            "gav://opensymphony:xwork:2.0.2",
            "gav://com.opensymphony:xwork:2.0.7",
            "gav://com.opensymphony:xwork:2.0.5",
            "gav://com.opensymphony:xwork:2.0.6",
            "gav://opensymphony:webwork:2.2.7-atlassian-25",
            "gav://opensymphony:webwork:2.2.7-atlassian-27",
            "gav://opensymphony:xwork:2.0.0-j4",
            "gav://opensymphony:xwork:1.2.2",
            "gav://opensymphony:xwork:1.2.1",
            "gav://opensymphony:webwork:2.2.7-atlassian-23",
            "gav://opensymphony:xwork:1.2.3",
            "gav://opensymphony:webwork:2.2.7-atlassian-24",
            "gav://opensymphony:xwork:2.0-beta-2",
            "gav://opensymphony:xwork:2.0-RC1",
            "gav://opensymphony:xwork:2.0-beta-3",
            "gav://opensymphony:xwork:2.0-RC1-j4",
            "gav://opensymphony:xwork:2.0-beta-1",
            "gav://opensymphony:xwork:2.0.1",
            "gav://opensymphony:xwork:2.0.0",
            "gav://opensymphony:xwork:1.1",
            "gav://opensymphony:xwork:1.2",
            "gav://opensymphony:xwork:1.0",
            "gav://opensymphony:webwork:2.2.7-atlassian-29",
            "gav://opensymphony:webwork:1.4-atlassian-26-testmvn2-1",
            "gav://opensymphony:webwork:2.2.7-atlassian-1",
            "gav://opensymphony:webwork:2.2.7-atlassian-2",
            "gav://opensymphony:webwork:2.2.7-atlassian-3",
            "gav://opensymphony:webwork:2.2.7-atlassian-5",
            "gav://opensymphony:webwork:2.2.7-atlassian-6",
            "gav://com.opensymphony:webwork:2.2.6",
            "gav://opensymphony:webwork:1.4-atlassian-9",
            "gav://opensymphony:webwork:2.1",
            "gav://opensymphony:webwork:1.4-atlassian-4",
            "gav://opensymphony:webwork:2.0",
            "gav://opensymphony:webwork:1.4-atlassian-2",
            "gav://opensymphony:webwork:2.2",
            "gav://opensymphony:webwork:1.4-atlassian-1",
            "gav://com.opensymphony:xwork:2.0.4",
            "gav://opensymphony:xwork:1.2.5-rc1",
            "gav://opensymphony:xwork:1.0.1",
            "gav://opensymphony:webwork:1.4-atlassian-19",
            "gav://opensymphony:xwork:1.2.5-atlassian-1",
            "gav://opensymphony:xwork:1.2.5-atlassian-2",
            "gav://opensymphony:xwork:1.2.5-atlassian-4",
            "gav://opensymphony:xwork:1.0.4",
            "gav://opensymphony:xwork:1.0.3",
            "gav://opensymphony:xwork:1.2.5-atlassian-5",
            "gav://opensymphony:xwork:1.2.5-atlassian-6",
            "gav://opensymphony:xwork:1.2.5-atlassian-7",
            "gav://opensymphony:xwork:1.0.5",
            "gav://opensymphony:webwork:1.4-atlassian-10",
            "gav://opensymphony:webwork:1.4-atlassian-11",
            "gav://opensymphony:webwork:1.4-atlassian-12",
            "gav://opensymphony:webwork:1.4-atlassian-13",
            "gav://opensymphony:webwork:1.4-atlassian-15",
            "gav://opensymphony:webwork:1.4-atlassian-16",
            "gav://opensymphony:webwork:1.4-atlassian-17",
            "gav://opensymphony:xwork:1.2.3-20070717",
            "gav://opensymphony:webwork:1.4-atlassian-30",
            "gav://opensymphony:webwork:12Dec05-jiratld",
            "gav://opensymphony:xwork:1.2.5-atlassian-8",
            "gav://opensymphony:webwork:1.4",
            "gav://opensymphony:webwork:2.1.3",
            "gav://opensymphony:webwork:2.1.4",
            "gav://com.opensymphony:xwork:2.1.2",
            "gav://opensymphony:webwork:2.1.5",
            "gav://com.opensymphony:xwork:2.1.3",
            "gav://opensymphony:webwork:2.1.6",
            "gav://com.opensymphony:xwork:2.1.0",
            "gav://opensymphony:webwork:2.1.7",
            "gav://com.opensymphony:xwork:2.1.1",
            "gav://opensymphony:webwork:1.4-atlassian-22",
            "gav://opensymphony:webwork:1.4-atlassian-23",
            "gav://opensymphony:webwork:1.4-atlassian-24",
            "gav://opensymphony:webwork:1.4-atlassian-25",
            "gav://opensymphony:webwork:1.4-atlassian-27",
            "gav://opensymphony:xwork-src:1.1.3",
            "gav://opensymphony:xwork-tiger-src:1.2.2",
            "gav://opensymphony:xwork-tiger-src:1.2.3",
            "gav://opensymphony:xwork-tiger-src:1.2.1",
            "gav://org.apache.struts:struts2-embeddedjsp-plugin:2.2.1",
            "gav://opensymphony:xwork-src:1.1.1",
            "gav://org.apache.struts:struts2-archetype-blank:2.2.1",
            "gav://org.apache.struts:struts2-portlet:2.2.1",
            "gav://org.apache.struts:struts2-archetype-starter:2.2.1",
            "gav://org.apache.struts:struts2-spring-plugin:2.2.1",
            "gav://org.apache.struts:struts2-jasperreports-plugin:2.2.1",
            "gav://com.opensymphony:xwork-parent:2.1.6",
            "gav://com.opensymphony:xwork-parent:2.1.5",
            "gav://org.apache.struts:struts2-archetypes:2.2.1",
            "gav://org.apache.struts:struts2-assembly:2.2.1",
            "gav://com.opensymphony:xwork-parent:2.1.4",
            "gav://org.apache.struts:struts2-jboss-blank:2.2.1",
            "gav://org.apache.struts:struts2-sitegraph-plugin:2.2.1",
            "gav://org.apache.struts:struts2-showcase:2.2.1",
            "gav://com.opensymphony:xwork-core:2.1.5",
            "gav://org.apache.struts:struts2-core:2.2.1",
            "gav://com.opensymphony:xwork-core:2.1.4",
            "gav://org.apache.struts:struts2-portlet-plugin:2.2.1",
            "gav://com.opensymphony:xwork-core:2.1.6",
            "gav://org.apache.struts:struts2-osgi-demo-bundle:2.2.1",
            "gav://com.opensymphony.webwork:com.springsource.com.opensymphony.webwork:2.2.6",
            "gav://com.opensymphony.xwork:com.springsource.com.opensymphony.xwork:1.2.3",
            "gav://opensymphony:xwork-tiger-src:1.1.3",
            "gav://opensymphony:xwork-src:1.2.2",
            "gav://opensymphony:xwork-src:1.2.3",
            "gav://opensymphony:xwork-tiger-src:1.1.1",
            "gav://org.apache.struts:struts2-tiles-plugin:2.2.1",
            "gav://org.apache.struts:struts2-junit-plugin:2.2.1",
            "gav://opensymphony:webwork-src:2.2",
            "gav://opensymphony:xwork-src:1.2.1",
            "gav://org.apache.struts:struts2-dojo-plugin:2.2.1",
            "gav://org.apache.struts:struts2-json-plugin:2.2.1",
            "gav://org.apache.struts:struts2-osgi-bundles:2.2.1",
            "gav://org.apache.struts:struts2-osgi-admin-bundle:2.2.1",
            "gav://opensymphony:xwork-src:2.0-beta-1",
            "gav://opensymphony:xwork-src:2.0-beta-2",
            "gav://opensymphony:webwork-src:2.2.3",
            "gav://opensymphony:webwork-src:2.2.4",
            "gav://opensymphony:webwork-src:2.2.1",
            "gav://org.apache.struts:struts2-dwr-plugin:2.2.1",
            "gav://opensymphony:webwork-src:2.2.2",
            "gav://opensymphony:xwork-tiger:1.2",
            "gav://org.apache.struts:struts2-oval-plugin:2.2.1",
            "gav://opensymphony:xwork-tiger:1.1",
            "gav://org.apache.struts:struts2-codebehind-plugin:2.2.1",
            "gav://opensymphony:webwork-src:2.2.5",
            "gav://opensymphony:xwork-tiger:1.2.3",
            "gav://opensymphony:xwork-tiger:1.2.1",
            "gav://com.opensymphony.xwork:com.springsource.com.opensymphony.xwork:1.1.1",
            "gav://opensymphony:xwork-tiger:1.2.2",
            "gav://org.apache.struts:struts2-archetype-dbportlet:2.2.1",
            "gav://opensymphony:xwork-tiger-src:1.2",
            "gav://org.apache.struts:struts2-plexus-plugin:2.2.1",
            "gav://opensymphony:xwork-tiger-src:1.1",
            "gav://org.apache.struts:struts2-jfreechart-plugin:2.2.1",
            "gav://org.apache.struts:struts2-jsf-plugin:2.2.1",
            "gav://opensymphony:xwork-src:1.1",
            "gav://org.apache.struts:struts2-pell-multipart-plugin:2.2.1",
            "gav://opensymphony:xwork-src:1.2",
            "gav://com.opensymphony:xwork-assembly:2.1.4",
            "gav://org.apache.struts:struts2-rest-showcase:2.2.1",
            "gav://com.opensymphony:xwork-assembly:2.1.6",
            "gav://org.apache.struts:struts2-struts1-plugin:2.2.1",
            "gav://org.apache.struts:struts2-javatemplates-plugin:2.2.1",
            "gav://com.opensymphony:xwork-assembly:2.1.5",
            "gav://org.apache.struts:struts2-osgi-plugin:2.2.1",
            "gav://org.apache.struts:struts2-archetype-convention:2.2.1",
            "gav://opensymphony:xwork-tiger:2.0-beta-1",
            "gav://opensymphony:xwork-tiger-src:2.0-beta-1",
            "gav://org.apache.struts:struts2-archetype-plugin:2.2.1",
            "gav://opensymphony:xwork-tiger:1.1.3",
            "gav://opensymphony:xwork-tiger:1.1.1",
            "gav://org.apache.struts:struts2-blank:2.2.1",
            "gav://org.apache.struts:struts2-testng-plugin:2.2.1",
            "gav://org.apache.struts:struts2-parent:2.2.1",
            "gav://org.apache.struts:struts2-sitemesh-plugin:2.2.1",
            "gav://org.apache.struts:struts2-config-browser-plugin:2.2.1",
            "gav://org.apache.struts:struts2-convention-plugin:2.2.1",
            "gav://org.apache.struts:struts2-plugins:2.2.1",
            "gav://org.apache.struts:struts2-rest-plugin:2.2.1",
            "gav://org.apache.struts:struts2-apps:2.2.1",
            "gav://org.apache.struts.xwork:xwork-core:2.2.1",
            "gav://org.apache.struts:struts2-mailreader:2.2.1",
            "gav://com.opensymphony:xwork-plugins:2.1.4",
            "gav://com.opensymphony:xwork-plugins:2.1.5",
            "gav://com.opensymphony:xwork-plugins:2.1.6",
            "gav://org.apache.struts:struts2-archetype-portlet:2.2.1"
          ],
          "impacted_artifacts": [
            {
              "name": "pipeline-xray",
              "path": "LOCAL/builds/",
              "sha256": "f8fa924e200c8412075de89d867f1b8dd5aa343938754fb652f84ff472a75b97",
              "sha1": "",
              "depth": 0,
              "display_name": "pipeline-xray:294",
              "pkg_type": "Build",
              "parent_sha": "f8fa924e200c8412075de89d867f1b8dd5aa343938754fb652f84ff472a75b97",
              "impact_path": "",
              "infected_file": {
                "name": "xwork-2.0.6.jar",
                "path": "LOCAL/libs-release-local/com/opensymphony/xwork/2.0.6/",
                "sha256": "4baa7d0a7203ceeefa063a3782de733d417c4eae5ee5c0ab06e9e9e4607c004a",
                "sha1": "",
                "depth": 0,
                "parent_sha": "4baa7d0a7203ceeefa063a3782de733d417c4eae5ee5c0ab06e9e9e4607c004a",
                "display_name": "com.opensymphony:xwork:2.0.6",
                "pkg_type": "Maven"
              }
            }
          ]
        }
      ],
      "top_severity": "Major",
      "watch_name": "my-jenkins"
    }
  ],
  "licenses": [
    {
      "name": "Unknown",
      "components": [
        "build://pipeline-xray:294",
        "gav://com.opensymphony:xwork:2.0.6"
      ],
      "full_name": "Unknown license",
      "more_info_url": null
    },
    {
      "name": "MIT",
      "components": [
        "gav://org.webjars.bower:vf-angular-ui-router:1.0.0-beta.3"
      ],
      "full_name": "MIT license ",
      "more_info_url": [
        "https://opensource.org/licenses/MIT"
      ]
    }
  ]
}
`
