// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

// Package simspaceweaveriface provides an interface to enable mocking the AWS SimSpace Weaver service client
// for testing your code.
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters.
package simspaceweaveriface

import (
	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/service/simspaceweaver"
)

// SimSpaceWeaverAPI provides an interface to enable mocking the
// simspaceweaver.SimSpaceWeaver service client's API operation,
// paginators, and waiters. This make unit testing your code that calls out
// to the SDK's service client's calls easier.
//
// The best way to use this interface is so the SDK's service client's calls
// can be stubbed out for unit testing your code with the SDK without needing
// to inject custom request handlers into the SDK's request pipeline.
//
//	// myFunc uses an SDK service client to make a request to
//	// AWS SimSpace Weaver.
//	func myFunc(svc simspaceweaveriface.SimSpaceWeaverAPI) bool {
//	    // Make svc.DeleteApp request
//	}
//
//	func main() {
//	    sess := session.New()
//	    svc := simspaceweaver.New(sess)
//
//	    myFunc(svc)
//	}
//
// In your _test.go file:
//
//	// Define a mock struct to be used in your unit tests of myFunc.
//	type mockSimSpaceWeaverClient struct {
//	    simspaceweaveriface.SimSpaceWeaverAPI
//	}
//	func (m *mockSimSpaceWeaverClient) DeleteApp(input *simspaceweaver.DeleteAppInput) (*simspaceweaver.DeleteAppOutput, error) {
//	    // mock response/functionality
//	}
//
//	func TestMyFunc(t *testing.T) {
//	    // Setup Test
//	    mockSvc := &mockSimSpaceWeaverClient{}
//
//	    myfunc(mockSvc)
//
//	    // Verify myFunc's functionality
//	}
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters. Its suggested to use the pattern above for testing, or using
// tooling to generate mocks to satisfy the interfaces.
type SimSpaceWeaverAPI interface {
	DeleteApp(*simspaceweaver.DeleteAppInput) (*simspaceweaver.DeleteAppOutput, error)
	DeleteAppWithContext(aws.Context, *simspaceweaver.DeleteAppInput, ...request.Option) (*simspaceweaver.DeleteAppOutput, error)
	DeleteAppRequest(*simspaceweaver.DeleteAppInput) (*request.Request, *simspaceweaver.DeleteAppOutput)

	DeleteSimulation(*simspaceweaver.DeleteSimulationInput) (*simspaceweaver.DeleteSimulationOutput, error)
	DeleteSimulationWithContext(aws.Context, *simspaceweaver.DeleteSimulationInput, ...request.Option) (*simspaceweaver.DeleteSimulationOutput, error)
	DeleteSimulationRequest(*simspaceweaver.DeleteSimulationInput) (*request.Request, *simspaceweaver.DeleteSimulationOutput)

	DescribeApp(*simspaceweaver.DescribeAppInput) (*simspaceweaver.DescribeAppOutput, error)
	DescribeAppWithContext(aws.Context, *simspaceweaver.DescribeAppInput, ...request.Option) (*simspaceweaver.DescribeAppOutput, error)
	DescribeAppRequest(*simspaceweaver.DescribeAppInput) (*request.Request, *simspaceweaver.DescribeAppOutput)

	DescribeSimulation(*simspaceweaver.DescribeSimulationInput) (*simspaceweaver.DescribeSimulationOutput, error)
	DescribeSimulationWithContext(aws.Context, *simspaceweaver.DescribeSimulationInput, ...request.Option) (*simspaceweaver.DescribeSimulationOutput, error)
	DescribeSimulationRequest(*simspaceweaver.DescribeSimulationInput) (*request.Request, *simspaceweaver.DescribeSimulationOutput)

	ListApps(*simspaceweaver.ListAppsInput) (*simspaceweaver.ListAppsOutput, error)
	ListAppsWithContext(aws.Context, *simspaceweaver.ListAppsInput, ...request.Option) (*simspaceweaver.ListAppsOutput, error)
	ListAppsRequest(*simspaceweaver.ListAppsInput) (*request.Request, *simspaceweaver.ListAppsOutput)

	ListAppsPages(*simspaceweaver.ListAppsInput, func(*simspaceweaver.ListAppsOutput, bool) bool) error
	ListAppsPagesWithContext(aws.Context, *simspaceweaver.ListAppsInput, func(*simspaceweaver.ListAppsOutput, bool) bool, ...request.Option) error

	ListSimulations(*simspaceweaver.ListSimulationsInput) (*simspaceweaver.ListSimulationsOutput, error)
	ListSimulationsWithContext(aws.Context, *simspaceweaver.ListSimulationsInput, ...request.Option) (*simspaceweaver.ListSimulationsOutput, error)
	ListSimulationsRequest(*simspaceweaver.ListSimulationsInput) (*request.Request, *simspaceweaver.ListSimulationsOutput)

	ListSimulationsPages(*simspaceweaver.ListSimulationsInput, func(*simspaceweaver.ListSimulationsOutput, bool) bool) error
	ListSimulationsPagesWithContext(aws.Context, *simspaceweaver.ListSimulationsInput, func(*simspaceweaver.ListSimulationsOutput, bool) bool, ...request.Option) error

	ListTagsForResource(*simspaceweaver.ListTagsForResourceInput) (*simspaceweaver.ListTagsForResourceOutput, error)
	ListTagsForResourceWithContext(aws.Context, *simspaceweaver.ListTagsForResourceInput, ...request.Option) (*simspaceweaver.ListTagsForResourceOutput, error)
	ListTagsForResourceRequest(*simspaceweaver.ListTagsForResourceInput) (*request.Request, *simspaceweaver.ListTagsForResourceOutput)

	StartApp(*simspaceweaver.StartAppInput) (*simspaceweaver.StartAppOutput, error)
	StartAppWithContext(aws.Context, *simspaceweaver.StartAppInput, ...request.Option) (*simspaceweaver.StartAppOutput, error)
	StartAppRequest(*simspaceweaver.StartAppInput) (*request.Request, *simspaceweaver.StartAppOutput)

	StartClock(*simspaceweaver.StartClockInput) (*simspaceweaver.StartClockOutput, error)
	StartClockWithContext(aws.Context, *simspaceweaver.StartClockInput, ...request.Option) (*simspaceweaver.StartClockOutput, error)
	StartClockRequest(*simspaceweaver.StartClockInput) (*request.Request, *simspaceweaver.StartClockOutput)

	StartSimulation(*simspaceweaver.StartSimulationInput) (*simspaceweaver.StartSimulationOutput, error)
	StartSimulationWithContext(aws.Context, *simspaceweaver.StartSimulationInput, ...request.Option) (*simspaceweaver.StartSimulationOutput, error)
	StartSimulationRequest(*simspaceweaver.StartSimulationInput) (*request.Request, *simspaceweaver.StartSimulationOutput)

	StopApp(*simspaceweaver.StopAppInput) (*simspaceweaver.StopAppOutput, error)
	StopAppWithContext(aws.Context, *simspaceweaver.StopAppInput, ...request.Option) (*simspaceweaver.StopAppOutput, error)
	StopAppRequest(*simspaceweaver.StopAppInput) (*request.Request, *simspaceweaver.StopAppOutput)

	StopClock(*simspaceweaver.StopClockInput) (*simspaceweaver.StopClockOutput, error)
	StopClockWithContext(aws.Context, *simspaceweaver.StopClockInput, ...request.Option) (*simspaceweaver.StopClockOutput, error)
	StopClockRequest(*simspaceweaver.StopClockInput) (*request.Request, *simspaceweaver.StopClockOutput)

	StopSimulation(*simspaceweaver.StopSimulationInput) (*simspaceweaver.StopSimulationOutput, error)
	StopSimulationWithContext(aws.Context, *simspaceweaver.StopSimulationInput, ...request.Option) (*simspaceweaver.StopSimulationOutput, error)
	StopSimulationRequest(*simspaceweaver.StopSimulationInput) (*request.Request, *simspaceweaver.StopSimulationOutput)

	TagResource(*simspaceweaver.TagResourceInput) (*simspaceweaver.TagResourceOutput, error)
	TagResourceWithContext(aws.Context, *simspaceweaver.TagResourceInput, ...request.Option) (*simspaceweaver.TagResourceOutput, error)
	TagResourceRequest(*simspaceweaver.TagResourceInput) (*request.Request, *simspaceweaver.TagResourceOutput)

	UntagResource(*simspaceweaver.UntagResourceInput) (*simspaceweaver.UntagResourceOutput, error)
	UntagResourceWithContext(aws.Context, *simspaceweaver.UntagResourceInput, ...request.Option) (*simspaceweaver.UntagResourceOutput, error)
	UntagResourceRequest(*simspaceweaver.UntagResourceInput) (*request.Request, *simspaceweaver.UntagResourceOutput)
}

var _ SimSpaceWeaverAPI = (*simspaceweaver.SimSpaceWeaver)(nil)
