/*
 * Decompiled with CFR 0.152.
 */
package groovy.servlet;

import groovy.lang.Binding;
import groovy.xml.MarkupBuilder;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ServletBinding
extends Binding {
    private final Binding binding = new Binding();
    private final ServletContext context;
    private final HttpServletRequest request;
    private final HttpServletResponse response;
    private MarkupBuilder html;

    public ServletBinding(HttpServletRequest request, HttpServletResponse response, ServletContext context) {
        this.request = request;
        this.response = response;
        this.context = context;
        this.binding.setVariable("request", request);
        this.binding.setVariable("response", response);
        this.binding.setVariable("context", context);
        this.binding.setVariable("application", context);
        this.binding.setVariable("session", request.getSession(false));
        HashMap<String, Object> params = new HashMap<String, Object>();
        Enumeration names = request.getParameterNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            if (this.binding.getVariables().containsKey(name)) continue;
            String[] values = request.getParameterValues(name);
            if (values.length == 1) {
                params.put(name, values[0]);
                continue;
            }
            params.put(name, values);
        }
        this.binding.setVariable("params", params);
        HashMap<String, String> headers = new HashMap<String, String>();
        Enumeration names2 = request.getHeaderNames();
        while (names2.hasMoreElements()) {
            String headerName = (String)names2.nextElement();
            String headerValue = request.getHeader(headerName);
            headers.put(headerName, headerValue);
        }
        this.binding.setVariable("headers", headers);
    }

    public void setVariable(String name, Object value) {
        if (name == null) {
            throw new IllegalArgumentException("Can't bind variable to null key.");
        }
        if (name.length() == 0) {
            throw new IllegalArgumentException("Can't bind variable to blank key name. [length=0]");
        }
        if ("out".equals(name)) {
            throw new IllegalArgumentException("Can't bind variable to key named '" + name + "'.");
        }
        if ("sout".equals(name)) {
            throw new IllegalArgumentException("Can't bind variable to key named '" + name + "'.");
        }
        if ("html".equals(name)) {
            throw new IllegalArgumentException("Can't bind variable to key named '" + name + "'.");
        }
        this.binding.setVariable(name, value);
    }

    public Map getVariables() {
        return this.binding.getVariables();
    }

    public Object getVariable(String name) {
        if (name == null) {
            throw new IllegalArgumentException("No variable with null key name.");
        }
        if (name.length() == 0) {
            throw new IllegalArgumentException("No variable with blank key name. [length=0]");
        }
        try {
            if ("out".equals(name)) {
                return this.response.getWriter();
            }
            if ("sout".equals(name)) {
                return this.response.getOutputStream();
            }
            if ("html".equals(name)) {
                if (this.html == null) {
                    this.html = new MarkupBuilder(this.response.getWriter());
                }
                return this.html;
            }
        }
        catch (IOException e) {
            String message = "Failed to get writer or output stream from response.";
            this.context.log(message, (Throwable)e);
            throw new RuntimeException(message, e);
        }
        return this.binding.getVariable(name);
    }
}

