// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/home/graph/v1/device.proto

package graph

import (
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	_struct "github.com/golang/protobuf/ptypes/struct"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// Third-party partner's device definition.
type Device struct {
	// Third-party partner's device ID.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// Hardware type of the device (e.g. light, outlet, etc).
	Type string `protobuf:"bytes,2,opt,name=type,proto3" json:"type,omitempty"`
	// Traits supported by the device.
	Traits []string `protobuf:"bytes,3,rep,name=traits,proto3" json:"traits,omitempty"`
	// Name of the device given by the third party. This includes names given to
	// the device via third party device manufacturer's app, model names for the
	// device, etc.
	Name *DeviceNames `protobuf:"bytes,4,opt,name=name,proto3" json:"name,omitempty"`
	// Indicates whether the state of this device is being reported to Google
	// through ReportStateAndNotification call.
	WillReportState bool `protobuf:"varint,5,opt,name=will_report_state,json=willReportState,proto3" json:"will_report_state,omitempty"`
	// If the third-party partner's cloud configuration includes placing devices
	// in rooms, the name of the room can be provided here.
	RoomHint string `protobuf:"bytes,6,opt,name=room_hint,json=roomHint,proto3" json:"room_hint,omitempty"`
	// As in roomHint, for structures that users set up in the partner's system.
	StructureHint string `protobuf:"bytes,7,opt,name=structure_hint,json=structureHint,proto3" json:"structure_hint,omitempty"`
	// Device manufacturer, model, hardware version, and software version.
	DeviceInfo *DeviceInfo `protobuf:"bytes,8,opt,name=device_info,json=deviceInfo,proto3" json:"device_info,omitempty"`
	// Attributes for the traits supported by the device.
	Attributes *_struct.Struct `protobuf:"bytes,9,opt,name=attributes,proto3" json:"attributes,omitempty"`
	// Custom JSON data provided by the manufacturer and attached to QUERY and
	// EXECUTE requests in AoG.
	CustomData string `protobuf:"bytes,10,opt,name=custom_data,json=customData,proto3" json:"custom_data,omitempty"`
	// IDs of other devices associated with this device. This is used to
	// represent a device group (e.g. bonded zone) or "facets" synced
	// through different flows (e.g. Google Nest Hub Max with a Nest Camera).
	//
	// This may also be used to pass in alternate IDs used to identify a cloud
	// synced device for local execution (i.e. local verification). If used for
	// local verification, this field is synced from the cloud.
	OtherDeviceIds       []*AgentOtherDeviceId `protobuf:"bytes,11,rep,name=other_device_ids,json=otherDeviceIds,proto3" json:"other_device_ids,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *Device) Reset()         { *m = Device{} }
func (m *Device) String() string { return proto.CompactTextString(m) }
func (*Device) ProtoMessage()    {}
func (*Device) Descriptor() ([]byte, []int) {
	return fileDescriptor_1729f8e53993f499, []int{0}
}

func (m *Device) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Device.Unmarshal(m, b)
}
func (m *Device) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Device.Marshal(b, m, deterministic)
}
func (m *Device) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Device.Merge(m, src)
}
func (m *Device) XXX_Size() int {
	return xxx_messageInfo_Device.Size(m)
}
func (m *Device) XXX_DiscardUnknown() {
	xxx_messageInfo_Device.DiscardUnknown(m)
}

var xxx_messageInfo_Device proto.InternalMessageInfo

func (m *Device) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *Device) GetType() string {
	if m != nil {
		return m.Type
	}
	return ""
}

func (m *Device) GetTraits() []string {
	if m != nil {
		return m.Traits
	}
	return nil
}

func (m *Device) GetName() *DeviceNames {
	if m != nil {
		return m.Name
	}
	return nil
}

func (m *Device) GetWillReportState() bool {
	if m != nil {
		return m.WillReportState
	}
	return false
}

func (m *Device) GetRoomHint() string {
	if m != nil {
		return m.RoomHint
	}
	return ""
}

func (m *Device) GetStructureHint() string {
	if m != nil {
		return m.StructureHint
	}
	return ""
}

func (m *Device) GetDeviceInfo() *DeviceInfo {
	if m != nil {
		return m.DeviceInfo
	}
	return nil
}

func (m *Device) GetAttributes() *_struct.Struct {
	if m != nil {
		return m.Attributes
	}
	return nil
}

func (m *Device) GetCustomData() string {
	if m != nil {
		return m.CustomData
	}
	return ""
}

func (m *Device) GetOtherDeviceIds() []*AgentOtherDeviceId {
	if m != nil {
		return m.OtherDeviceIds
	}
	return nil
}

// Different names for the device.
type DeviceNames struct {
	// Primary name of the device, generally provided by the user.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Additional names provided by the user for the device.
	Nicknames []string `protobuf:"bytes,2,rep,name=nicknames,proto3" json:"nicknames,omitempty"`
	// List of names provided by the partner rather than the user, often
	// manufacturer names, SKUs, etc.
	DefaultNames         []string `protobuf:"bytes,3,rep,name=default_names,json=defaultNames,proto3" json:"default_names,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeviceNames) Reset()         { *m = DeviceNames{} }
func (m *DeviceNames) String() string { return proto.CompactTextString(m) }
func (*DeviceNames) ProtoMessage()    {}
func (*DeviceNames) Descriptor() ([]byte, []int) {
	return fileDescriptor_1729f8e53993f499, []int{1}
}

func (m *DeviceNames) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeviceNames.Unmarshal(m, b)
}
func (m *DeviceNames) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeviceNames.Marshal(b, m, deterministic)
}
func (m *DeviceNames) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeviceNames.Merge(m, src)
}
func (m *DeviceNames) XXX_Size() int {
	return xxx_messageInfo_DeviceNames.Size(m)
}
func (m *DeviceNames) XXX_DiscardUnknown() {
	xxx_messageInfo_DeviceNames.DiscardUnknown(m)
}

var xxx_messageInfo_DeviceNames proto.InternalMessageInfo

func (m *DeviceNames) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *DeviceNames) GetNicknames() []string {
	if m != nil {
		return m.Nicknames
	}
	return nil
}

func (m *DeviceNames) GetDefaultNames() []string {
	if m != nil {
		return m.DefaultNames
	}
	return nil
}

// Device information.
type DeviceInfo struct {
	// Device manufacturer.
	Manufacturer string `protobuf:"bytes,1,opt,name=manufacturer,proto3" json:"manufacturer,omitempty"`
	// Device model.
	Model string `protobuf:"bytes,2,opt,name=model,proto3" json:"model,omitempty"`
	// Device hardware version.
	HwVersion string `protobuf:"bytes,3,opt,name=hw_version,json=hwVersion,proto3" json:"hw_version,omitempty"`
	// Device software version.
	SwVersion            string   `protobuf:"bytes,4,opt,name=sw_version,json=swVersion,proto3" json:"sw_version,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeviceInfo) Reset()         { *m = DeviceInfo{} }
func (m *DeviceInfo) String() string { return proto.CompactTextString(m) }
func (*DeviceInfo) ProtoMessage()    {}
func (*DeviceInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_1729f8e53993f499, []int{2}
}

func (m *DeviceInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeviceInfo.Unmarshal(m, b)
}
func (m *DeviceInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeviceInfo.Marshal(b, m, deterministic)
}
func (m *DeviceInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeviceInfo.Merge(m, src)
}
func (m *DeviceInfo) XXX_Size() int {
	return xxx_messageInfo_DeviceInfo.Size(m)
}
func (m *DeviceInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_DeviceInfo.DiscardUnknown(m)
}

var xxx_messageInfo_DeviceInfo proto.InternalMessageInfo

func (m *DeviceInfo) GetManufacturer() string {
	if m != nil {
		return m.Manufacturer
	}
	return ""
}

func (m *DeviceInfo) GetModel() string {
	if m != nil {
		return m.Model
	}
	return ""
}

func (m *DeviceInfo) GetHwVersion() string {
	if m != nil {
		return m.HwVersion
	}
	return ""
}

func (m *DeviceInfo) GetSwVersion() string {
	if m != nil {
		return m.SwVersion
	}
	return ""
}

// Identifies a device in the third party or first party system.
type AgentOtherDeviceId struct {
	// The agent's ID. Generally it is the agent's AoG project id.
	AgentId string `protobuf:"bytes,1,opt,name=agent_id,json=agentId,proto3" json:"agent_id,omitempty"`
	// Device ID defined by the agent. The device_id must be unique.
	DeviceId             string   `protobuf:"bytes,2,opt,name=device_id,json=deviceId,proto3" json:"device_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *AgentOtherDeviceId) Reset()         { *m = AgentOtherDeviceId{} }
func (m *AgentOtherDeviceId) String() string { return proto.CompactTextString(m) }
func (*AgentOtherDeviceId) ProtoMessage()    {}
func (*AgentOtherDeviceId) Descriptor() ([]byte, []int) {
	return fileDescriptor_1729f8e53993f499, []int{3}
}

func (m *AgentOtherDeviceId) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AgentOtherDeviceId.Unmarshal(m, b)
}
func (m *AgentOtherDeviceId) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AgentOtherDeviceId.Marshal(b, m, deterministic)
}
func (m *AgentOtherDeviceId) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AgentOtherDeviceId.Merge(m, src)
}
func (m *AgentOtherDeviceId) XXX_Size() int {
	return xxx_messageInfo_AgentOtherDeviceId.Size(m)
}
func (m *AgentOtherDeviceId) XXX_DiscardUnknown() {
	xxx_messageInfo_AgentOtherDeviceId.DiscardUnknown(m)
}

var xxx_messageInfo_AgentOtherDeviceId proto.InternalMessageInfo

func (m *AgentOtherDeviceId) GetAgentId() string {
	if m != nil {
		return m.AgentId
	}
	return ""
}

func (m *AgentOtherDeviceId) GetDeviceId() string {
	if m != nil {
		return m.DeviceId
	}
	return ""
}

func init() {
	proto.RegisterType((*Device)(nil), "google.home.graph.v1.Device")
	proto.RegisterType((*DeviceNames)(nil), "google.home.graph.v1.DeviceNames")
	proto.RegisterType((*DeviceInfo)(nil), "google.home.graph.v1.DeviceInfo")
	proto.RegisterType((*AgentOtherDeviceId)(nil), "google.home.graph.v1.AgentOtherDeviceId")
}

func init() { proto.RegisterFile("google/home/graph/v1/device.proto", fileDescriptor_1729f8e53993f499) }

var fileDescriptor_1729f8e53993f499 = []byte{
	// 532 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x7c, 0x53, 0x4d, 0x6f, 0xd4, 0x30,
	0x10, 0xd5, 0x7e, 0x74, 0xbb, 0x99, 0xb4, 0x05, 0xac, 0x0a, 0x0c, 0x14, 0x91, 0x2e, 0x42, 0x8a,
	0x38, 0x24, 0x6a, 0x11, 0x42, 0x88, 0x53, 0xab, 0x1e, 0xa8, 0x84, 0x00, 0xa5, 0x12, 0x07, 0x2e,
	0x91, 0x77, 0xed, 0x4d, 0x2c, 0x92, 0x78, 0x65, 0x3b, 0xbb, 0xe2, 0xce, 0xcf, 0xe4, 0xc7, 0x20,
	0x8f, 0xb3, 0x1f, 0x15, 0x2b, 0x6e, 0x9e, 0x37, 0xcf, 0xe3, 0x97, 0xf7, 0x26, 0x70, 0x5e, 0x28,
	0x55, 0x54, 0x22, 0x2d, 0x55, 0x2d, 0xd2, 0x42, 0xb3, 0x45, 0x99, 0x2e, 0x2f, 0x52, 0x2e, 0x96,
	0x72, 0x26, 0x92, 0x85, 0x56, 0x56, 0x91, 0x53, 0x4f, 0x49, 0x1c, 0x25, 0x41, 0x4a, 0xb2, 0xbc,
	0x78, 0x76, 0xd6, 0x5d, 0x44, 0xce, 0xb4, 0x9d, 0xa7, 0xc6, 0xea, 0x76, 0x66, 0xfd, 0x9d, 0xc9,
	0x9f, 0x01, 0x8c, 0x6e, 0x70, 0x08, 0x39, 0x81, 0xbe, 0xe4, 0xb4, 0x17, 0xf5, 0xe2, 0x20, 0xeb,
	0x4b, 0x4e, 0x08, 0x0c, 0xed, 0xaf, 0x85, 0xa0, 0x7d, 0x44, 0xf0, 0x4c, 0x1e, 0xc3, 0xc8, 0x6a,
	0x26, 0xad, 0xa1, 0x83, 0x68, 0x10, 0x07, 0x59, 0x57, 0x91, 0x77, 0x30, 0x6c, 0x58, 0x2d, 0xe8,
	0x30, 0xea, 0xc5, 0xe1, 0xe5, 0x79, 0xb2, 0x4f, 0x49, 0xe2, 0xdf, 0xf9, 0xc2, 0x6a, 0x61, 0x32,
	0xa4, 0x93, 0x37, 0xf0, 0x68, 0x25, 0xab, 0x2a, 0xd7, 0x62, 0xa1, 0xb4, 0xcd, 0x8d, 0x65, 0x56,
	0xd0, 0x83, 0xa8, 0x17, 0x8f, 0xb3, 0x07, 0xae, 0x91, 0x21, 0x7e, 0xe7, 0x60, 0xf2, 0x1c, 0x02,
	0xad, 0x54, 0x9d, 0x97, 0xb2, 0xb1, 0x74, 0x84, 0x9a, 0xc6, 0x0e, 0xf8, 0x24, 0x1b, 0x4b, 0x5e,
	0xc3, 0x89, 0xff, 0xac, 0x56, 0x0b, 0xcf, 0x38, 0x44, 0xc6, 0xf1, 0x06, 0x45, 0xda, 0x15, 0x84,
	0xde, 0xb1, 0x5c, 0x36, 0x73, 0x45, 0xc7, 0xa8, 0x36, 0xfa, 0x9f, 0xda, 0xdb, 0x66, 0xae, 0x32,
	0xe0, 0x9b, 0x33, 0x79, 0x0f, 0xc0, 0xac, 0xd5, 0x72, 0xda, 0x5a, 0x61, 0x68, 0x80, 0x13, 0x9e,
	0xac, 0x27, 0xac, 0x3d, 0x4e, 0xee, 0xf0, 0xd9, 0x6c, 0x87, 0x4a, 0x5e, 0x42, 0x38, 0x6b, 0x8d,
	0x55, 0x75, 0xce, 0x99, 0x65, 0x14, 0x50, 0x1f, 0x78, 0xe8, 0x86, 0x59, 0x46, 0x32, 0x78, 0xa8,
	0x6c, 0x29, 0x74, 0xbe, 0x96, 0xc8, 0x0d, 0x0d, 0xa3, 0x41, 0x1c, 0x5e, 0xc6, 0xfb, 0x15, 0x5e,
	0x15, 0xa2, 0xb1, 0x5f, 0xdd, 0x95, 0x4e, 0x2b, 0xcf, 0x4e, 0xd4, 0x6e, 0x69, 0x26, 0x1c, 0xc2,
	0x1d, 0xd7, 0x5d, 0xa4, 0x18, 0x93, 0x0f, 0xd9, 0x67, 0x70, 0x06, 0x41, 0x23, 0x67, 0x3f, 0xdd,
	0xd9, 0xd0, 0x3e, 0xa6, 0xba, 0x05, 0xc8, 0x2b, 0x38, 0xe6, 0x62, 0xce, 0xda, 0xca, 0xe6, 0x9e,
	0xe1, 0x73, 0x3f, 0xea, 0x40, 0x1c, 0x3b, 0xf9, 0xdd, 0x03, 0xd8, 0xda, 0x45, 0x26, 0x70, 0x54,
	0xb3, 0xa6, 0x9d, 0x33, 0x34, 0x5e, 0x77, 0xaf, 0xdd, 0xc3, 0xc8, 0x29, 0x1c, 0xd4, 0x8a, 0x8b,
	0xaa, 0xdb, 0x2e, 0x5f, 0x90, 0x17, 0x00, 0xe5, 0x2a, 0x5f, 0x0a, 0x6d, 0xa4, 0x6a, 0xe8, 0x00,
	0x5b, 0x41, 0xb9, 0xfa, 0xee, 0x01, 0xd7, 0x36, 0xdb, 0xf6, 0xd0, 0xb7, 0xcd, 0xba, 0x3d, 0xf9,
	0x0c, 0xe4, 0x5f, 0x4b, 0xc8, 0x53, 0x18, 0x33, 0x87, 0xe6, 0x9b, 0xe5, 0x3e, 0xc4, 0xfa, 0x96,
	0xbb, 0x95, 0xda, 0x78, 0xdd, 0x09, 0x19, 0x77, 0x51, 0xf3, 0xeb, 0x29, 0xd0, 0x99, 0xaa, 0xf7,
	0x3a, 0x7f, 0xdd, 0x99, 0xfa, 0xcd, 0xc5, 0xfd, 0xe3, 0x43, 0x47, 0x29, 0x54, 0xc5, 0x9a, 0x22,
	0x51, 0xba, 0x48, 0x0b, 0xd1, 0xe0, 0x2a, 0xa4, 0xbe, 0xc5, 0x16, 0xd2, 0xdc, 0xff, 0x71, 0x3f,
	0xe2, 0x61, 0x3a, 0x42, 0xd6, 0xdb, 0xbf, 0x01, 0x00, 0x00, 0xff, 0xff, 0x40, 0x65, 0xdc, 0x87,
	0xdd, 0x03, 0x00, 0x00,
}
