/*
 * Decompiled with CFR 0.152.
 */
package org.olsr.v1.info.api.dto;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.net.InetAddress;
import org.olsr.v1.info.api.util.CompareUtils;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public class JsonInfoGatewaysEntryBase {
    private boolean selected = false;
    private boolean selectable = false;
    private String originator = "";
    private String prefix = "";
    private int prefixLen = 0;
    private long uplink = 0L;
    private long downlink = 0L;
    private double cost = Double.POSITIVE_INFINITY;
    private boolean ipv4 = false;
    private boolean ipv4Nat = false;
    private boolean ipv6 = false;
    private long expireTime = 0L;
    private long cleanupTime = 0L;
    private double pathCost = Double.POSITIVE_INFINITY;
    private int hops = 0;

    public boolean getSelected() {
        return this.selected;
    }

    @JsonProperty(value="selected")
    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public boolean getSelectable() {
        return this.selectable;
    }

    @JsonProperty(value="selectable")
    public void setSelectable(boolean selectable) {
        this.selectable = selectable;
    }

    public String getOriginator() {
        return this.originator;
    }

    @JsonProperty(value="originator")
    public void setOriginator(InetAddress originator) {
        this.originator = originator == null ? "" : originator.getHostAddress();
    }

    public String getPrefix() {
        return this.prefix;
    }

    @JsonProperty(value="prefix")
    public void setPrefix(InetAddress prefix) {
        this.prefix = prefix == null ? "" : prefix.getHostAddress();
    }

    public int getPrefixLen() {
        return this.prefixLen;
    }

    @JsonProperty(value="prefixLen")
    public void setPrefixLen(int prefixLen) {
        this.prefixLen = prefixLen;
    }

    public long getUplink() {
        return this.uplink;
    }

    @JsonProperty(value="uplink")
    public void setUplink(long uplink) {
        this.uplink = uplink;
    }

    public long getDownlink() {
        return this.downlink;
    }

    @JsonProperty(value="downlink")
    public void setDownlink(long downlink) {
        this.downlink = downlink;
    }

    public double getCost() {
        return this.cost;
    }

    @JsonProperty(value="cost")
    public void setCost(double cost) {
        this.cost = Double.compare(cost, 9.223372036854776E18) >= 0 ? Double.POSITIVE_INFINITY : cost;
    }

    public boolean getIpv4() {
        return this.ipv4;
    }

    @JsonProperty(value="IPv4")
    public void setIpv4(boolean ipv4) {
        this.ipv4 = ipv4;
    }

    public boolean getIpv4Nat() {
        return this.ipv4Nat;
    }

    @JsonProperty(value="IPv4-NAT")
    public void setIpv4Nat(boolean ipv4Nat) {
        this.ipv4Nat = ipv4Nat;
    }

    public boolean getIpv6() {
        return this.ipv6;
    }

    @JsonProperty(value="IPv6")
    public void setIpv6(boolean ipv6) {
        this.ipv6 = ipv6;
    }

    public long getExpireTime() {
        return this.expireTime;
    }

    @JsonProperty(value="expireTime")
    public void setExpireTime(long expireTime) {
        this.expireTime = expireTime;
    }

    public long getCleanupTime() {
        return this.cleanupTime;
    }

    @JsonProperty(value="cleanupTime")
    public void setCleanupTime(long cleanupTime) {
        this.cleanupTime = cleanupTime;
    }

    public double getPathCost() {
        return this.pathCost;
    }

    @JsonProperty(value="pathcost")
    public void setPathCost(double pathCost) {
        this.pathCost = Double.compare(pathCost, 4.294967295E9) >= 0 ? Double.POSITIVE_INFINITY : pathCost;
    }

    public int getHops() {
        return this.hops;
    }

    @JsonProperty(value="hops")
    public void setHops(int hops) {
        this.hops = hops;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.selected ? 1231 : 1237);
        result = 31 * result + (this.selectable ? 1231 : 1237);
        result = 31 * result + this.originator.hashCode();
        result = 31 * result + this.prefix.hashCode();
        result = 31 * result + this.prefixLen;
        result = 31 * result + (int)(this.uplink ^ this.uplink >>> 32);
        result = 31 * result + (int)(this.downlink ^ this.downlink >>> 32);
        long temp = Double.doubleToLongBits(this.cost);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (this.ipv4 ? 1231 : 1237);
        result = 31 * result + (this.ipv4Nat ? 1231 : 1237);
        result = 31 * result + (this.ipv6 ? 1231 : 1237);
        result = 31 * result + (int)(this.expireTime ^ this.expireTime >>> 32);
        result = 31 * result + (int)(this.cleanupTime ^ this.cleanupTime >>> 32);
        temp = Double.doubleToLongBits(this.pathCost);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + this.hops;
        return result;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        return this.compareTo((JsonInfoGatewaysEntryBase)other) == 0;
    }

    public int compareTo(JsonInfoGatewaysEntryBase other) {
        if (other == null) {
            return -1;
        }
        int result = Boolean.compare(this.selected, other.selected);
        if (result != 0) {
            return result;
        }
        result = Boolean.compare(this.selectable, other.selectable);
        if (result != 0) {
            return result;
        }
        result = this.originator.compareTo(other.originator);
        if (result != 0) {
            return CompareUtils.clip(result);
        }
        result = this.prefix.compareTo(other.prefix);
        if (result != 0) {
            return CompareUtils.clip(result);
        }
        result = Integer.compare(this.prefixLen, other.prefixLen);
        if (result != 0) {
            return result;
        }
        result = Long.compare(this.uplink, other.uplink);
        if (result != 0) {
            return result;
        }
        result = Long.compare(this.downlink, other.downlink);
        if (result != 0) {
            return result;
        }
        result = Double.compare(this.cost, other.cost);
        if (result != 0) {
            return result;
        }
        result = Boolean.compare(this.ipv4, other.ipv4);
        if (result != 0) {
            return result;
        }
        result = Boolean.compare(this.ipv4Nat, other.ipv4Nat);
        if (result != 0) {
            return result;
        }
        result = Boolean.compare(this.ipv6, other.ipv6);
        if (result != 0) {
            return result;
        }
        result = Long.compare(this.expireTime, other.expireTime);
        if (result != 0) {
            return result;
        }
        result = Long.compare(this.cleanupTime, other.cleanupTime);
        if (result != 0) {
            return result;
        }
        result = Double.compare(this.pathCost, other.pathCost);
        if (result != 0) {
            return result;
        }
        result = Integer.compare(this.hops, other.hops);
        if (result != 0) {
            return result;
        }
        return 0;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("JsonInfoGatewaysEntry [selected=");
        builder.append(this.selected);
        builder.append(", selectable=");
        builder.append(this.selectable);
        builder.append(", originator=");
        builder.append(this.originator);
        builder.append(", prefix=");
        builder.append(this.prefix);
        builder.append(", prefixLen=");
        builder.append(this.prefixLen);
        builder.append(", uplink=");
        builder.append(this.uplink);
        builder.append(", downlink=");
        builder.append(this.downlink);
        builder.append(", cost=");
        builder.append(this.cost);
        builder.append(", ipv4=");
        builder.append(this.ipv4);
        builder.append(", ipv4Nat=");
        builder.append(this.ipv4Nat);
        builder.append(", ipv6=");
        builder.append(this.ipv6);
        builder.append(", expireTime=");
        builder.append(this.expireTime);
        builder.append(", cleanupTime=");
        builder.append(this.cleanupTime);
        builder.append(", pathCost=");
        builder.append(this.pathCost);
        builder.append(", hops=");
        builder.append(this.hops);
        builder.append("]");
        return builder.toString();
    }
}

