﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/Globals.h>
#include <aws/core/utils/EnumParseOverflowContainer.h>
#include <aws/core/utils/HashingUtils.h>
#include <aws/datasync/model/ManifestFormat.h>

using namespace Aws::Utils;

namespace Aws {
namespace DataSync {
namespace Model {
namespace ManifestFormatMapper {

static const int CSV_HASH = HashingUtils::HashString("CSV");

ManifestFormat GetManifestFormatForName(const Aws::String& name) {
  int hashCode = HashingUtils::HashString(name.c_str());
  if (hashCode == CSV_HASH) {
    return ManifestFormat::CSV;
  }
  EnumParseOverflowContainer* overflowContainer = Aws::GetEnumOverflowContainer();
  if (overflowContainer) {
    overflowContainer->StoreOverflow(hashCode, name);
    return static_cast<ManifestFormat>(hashCode);
  }

  return ManifestFormat::NOT_SET;
}

Aws::String GetNameForManifestFormat(ManifestFormat enumValue) {
  switch (enumValue) {
    case ManifestFormat::NOT_SET:
      return {};
    case ManifestFormat::CSV:
      return "CSV";
    default:
      EnumParseOverflowContainer* overflowContainer = Aws::GetEnumOverflowContainer();
      if (overflowContainer) {
        return overflowContainer->RetrieveOverflow(static_cast<int>(enumValue));
      }

      return {};
  }
}

}  // namespace ManifestFormatMapper
}  // namespace Model
}  // namespace DataSync
}  // namespace Aws
