﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/AmazonWebServiceResult.h>
#include <aws/core/utils/StringUtils.h>
#include <aws/core/utils/UnreferencedParam.h>
#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/core/utils/memory/stl/AWSStringStream.h>
#include <aws/databrew/model/ListRulesetsResult.h>

#include <utility>

using namespace Aws::GlueDataBrew::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;
using namespace Aws;

ListRulesetsResult::ListRulesetsResult(const Aws::AmazonWebServiceResult<JsonValue>& result) { *this = result; }

ListRulesetsResult& ListRulesetsResult::operator=(const Aws::AmazonWebServiceResult<JsonValue>& result) {
  JsonView jsonValue = result.GetPayload().View();
  if (jsonValue.ValueExists("Rulesets")) {
    Aws::Utils::Array<JsonView> rulesetsJsonList = jsonValue.GetArray("Rulesets");
    for (unsigned rulesetsIndex = 0; rulesetsIndex < rulesetsJsonList.GetLength(); ++rulesetsIndex) {
      m_rulesets.push_back(rulesetsJsonList[rulesetsIndex].AsObject());
    }
    m_rulesetsHasBeenSet = true;
  }
  if (jsonValue.ValueExists("NextToken")) {
    m_nextToken = jsonValue.GetString("NextToken");
    m_nextTokenHasBeenSet = true;
  }

  const auto& headers = result.GetHeaderValueCollection();
  const auto& requestIdIter = headers.find("x-amzn-requestid");
  if (requestIdIter != headers.end()) {
    m_requestId = requestIdIter->second;
    m_requestIdHasBeenSet = true;
  }

  return *this;
}
