﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/cost-optimization-hub/model/RecommendationSummary.h>

#include <utility>

using namespace Aws::Utils::Json;
using namespace Aws::Utils;

namespace Aws {
namespace CostOptimizationHub {
namespace Model {

RecommendationSummary::RecommendationSummary(JsonView jsonValue) { *this = jsonValue; }

RecommendationSummary& RecommendationSummary::operator=(JsonView jsonValue) {
  if (jsonValue.ValueExists("group")) {
    m_group = jsonValue.GetString("group");
    m_groupHasBeenSet = true;
  }
  if (jsonValue.ValueExists("estimatedMonthlySavings")) {
    m_estimatedMonthlySavings = jsonValue.GetDouble("estimatedMonthlySavings");
    m_estimatedMonthlySavingsHasBeenSet = true;
  }
  if (jsonValue.ValueExists("recommendationCount")) {
    m_recommendationCount = jsonValue.GetInteger("recommendationCount");
    m_recommendationCountHasBeenSet = true;
  }
  return *this;
}

JsonValue RecommendationSummary::Jsonize() const {
  JsonValue payload;

  if (m_groupHasBeenSet) {
    payload.WithString("group", m_group);
  }

  if (m_estimatedMonthlySavingsHasBeenSet) {
    payload.WithDouble("estimatedMonthlySavings", m_estimatedMonthlySavings);
  }

  if (m_recommendationCountHasBeenSet) {
    payload.WithInteger("recommendationCount", m_recommendationCount);
  }

  return payload;
}

}  // namespace Model
}  // namespace CostOptimizationHub
}  // namespace Aws
