﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/connectcampaignsv2/model/ListConnectInstanceIntegrationsResult.h>
#include <aws/core/AmazonWebServiceResult.h>
#include <aws/core/utils/StringUtils.h>
#include <aws/core/utils/UnreferencedParam.h>
#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/core/utils/memory/stl/AWSStringStream.h>

#include <utility>

using namespace Aws::ConnectCampaignsV2::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;
using namespace Aws;

ListConnectInstanceIntegrationsResult::ListConnectInstanceIntegrationsResult(const Aws::AmazonWebServiceResult<JsonValue>& result) {
  *this = result;
}

ListConnectInstanceIntegrationsResult& ListConnectInstanceIntegrationsResult::operator=(
    const Aws::AmazonWebServiceResult<JsonValue>& result) {
  JsonView jsonValue = result.GetPayload().View();
  if (jsonValue.ValueExists("nextToken")) {
    m_nextToken = jsonValue.GetString("nextToken");
    m_nextTokenHasBeenSet = true;
  }
  if (jsonValue.ValueExists("integrationSummaryList")) {
    Aws::Utils::Array<JsonView> integrationSummaryListJsonList = jsonValue.GetArray("integrationSummaryList");
    for (unsigned integrationSummaryListIndex = 0; integrationSummaryListIndex < integrationSummaryListJsonList.GetLength();
         ++integrationSummaryListIndex) {
      m_integrationSummaryList.push_back(integrationSummaryListJsonList[integrationSummaryListIndex].AsObject());
    }
    m_integrationSummaryListHasBeenSet = true;
  }

  const auto& headers = result.GetHeaderValueCollection();
  const auto& requestIdIter = headers.find("x-amzn-requestid");
  if (requestIdIter != headers.end()) {
    m_requestId = requestIdIter->second;
    m_requestIdHasBeenSet = true;
  }

  return *this;
}
