﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/cloudformation/CloudFormation_EXPORTS.h>
#include <aws/cloudformation/model/ResponseMetadata.h>
#include <aws/core/utils/memory/stl/AWSString.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Xml {
class XmlDocument;
}  // namespace Xml
}  // namespace Utils
namespace CloudFormation {
namespace Model {
class DetectStackDriftResult {
 public:
  AWS_CLOUDFORMATION_API DetectStackDriftResult() = default;
  AWS_CLOUDFORMATION_API DetectStackDriftResult(const Aws::AmazonWebServiceResult<Aws::Utils::Xml::XmlDocument>& result);
  AWS_CLOUDFORMATION_API DetectStackDriftResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Xml::XmlDocument>& result);

  ///@{
  /**
   * <p>The ID of the drift detection results of this operation.</p>
   * <p>CloudFormation generates new results, with a new drift detection ID, each
   * time this operation is run. However, the number of drift results CloudFormation
   * retains for any given stack, and for how long, may vary.</p>
   */
  inline const Aws::String& GetStackDriftDetectionId() const { return m_stackDriftDetectionId; }
  template <typename StackDriftDetectionIdT = Aws::String>
  void SetStackDriftDetectionId(StackDriftDetectionIdT&& value) {
    m_stackDriftDetectionIdHasBeenSet = true;
    m_stackDriftDetectionId = std::forward<StackDriftDetectionIdT>(value);
  }
  template <typename StackDriftDetectionIdT = Aws::String>
  DetectStackDriftResult& WithStackDriftDetectionId(StackDriftDetectionIdT&& value) {
    SetStackDriftDetectionId(std::forward<StackDriftDetectionIdT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const ResponseMetadata& GetResponseMetadata() const { return m_responseMetadata; }
  template <typename ResponseMetadataT = ResponseMetadata>
  void SetResponseMetadata(ResponseMetadataT&& value) {
    m_responseMetadataHasBeenSet = true;
    m_responseMetadata = std::forward<ResponseMetadataT>(value);
  }
  template <typename ResponseMetadataT = ResponseMetadata>
  DetectStackDriftResult& WithResponseMetadata(ResponseMetadataT&& value) {
    SetResponseMetadata(std::forward<ResponseMetadataT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_stackDriftDetectionId;
  bool m_stackDriftDetectionIdHasBeenSet = false;

  ResponseMetadata m_responseMetadata;
  bool m_responseMetadataHasBeenSet = false;
};

}  // namespace Model
}  // namespace CloudFormation
}  // namespace Aws
