/****************************************************************************/
/*                                                                          */
/*         Copyright 1995-97 SCM Microsystems GmbH                          */
/*                                                                          */
/*         This software is supplied under the terms of a license           */
/*         agreement or nondisclosure agreement and may not be copied       */
/*         or disclosed except in accordance with the terms of that         */
/*         agreement.                                                       */
/*                                                                          */
/****************************************************************************/
/*    Name: CTAPI.H                                                         */
/*                                                                          */
/*      Description: Include file for CT-API layer of SmartOS               */
/*                                                                          */
/*--------------------------------------------------------------------------*/
/* History   :                                                              */
/*   Revision      Date            Author         Description               */
/*   -----------------------------------------------------------------------*/
/*   Version: 1.00: 27-Nov-1997  T.Maykranz   Initial version               */
/****************************************************************************/

#ifdef __cplusplus
extern "C" {
#endif

#ifndef CT_API
#define CT_API

/* CT-API: */

extern char 
  CT_init (unsigned short Ctn,           	/* logical terminal number */
  unsigned short Pn);					 	/* physical port number: */
                                          	/* see specification of the concret SmartOS */
                                          	/* hardware implementation to get more */
                                          	/* information about the meaning */
                                          	/* of this parameter */

extern char CT_close
          (unsigned short Ctn);          	/* logical terminal number */

extern char 
   CT_data (unsigned short      Ctn, 	    /* logical terminal number */
            unsigned char  		*Dad,   	/* destination address */
            unsigned char 		*Sad,     	/* source address */
            unsigned short      Lc,      	/* length of command in bytes */
            unsigned char		*Cmd,     	/* command&data buffer */
            unsigned short		*Lr,      	/* length of response in bytes */
            unsigned char		*Rsp);    	/* answer */

#endif

#ifdef __cplusplus
}
#endif
