/*
 * Decompiled with CFR 0.152.
 */
package org.mvel.tests.main;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import junit.framework.TestCase;
import org.mvel.ASTNode;
import org.mvel.CompileException;
import org.mvel.CompiledExpression;
import org.mvel.ExpressionCompiler;
import org.mvel.MVEL;
import org.mvel.MVELRuntime;
import org.mvel.Macro;
import org.mvel.ParserContext;
import org.mvel.debug.DebugTools;
import org.mvel.debug.Debugger;
import org.mvel.debug.Frame;
import org.mvel.integration.Interceptor;
import org.mvel.integration.ResolverTools;
import org.mvel.integration.VariableResolverFactory;
import org.mvel.integration.impl.ClassImportResolverFactory;
import org.mvel.integration.impl.MapVariableResolverFactory;
import org.mvel.optimizers.OptimizerFactory;
import org.mvel.tests.main.res.Bar;
import org.mvel.tests.main.res.Base;
import org.mvel.tests.main.res.Cheese;
import org.mvel.tests.main.res.DefaultKnowledgeHelper;
import org.mvel.tests.main.res.DerivedClass;
import org.mvel.tests.main.res.Foo;
import org.mvel.tests.main.res.TestInterface;

public class CoreConfidenceTests
extends TestCase {
    protected Foo foo = new Foo();
    protected Map<String, Object> map = new HashMap<String, Object>();
    protected Base base = new Base();
    protected DerivedClass derived = new DerivedClass();

    public CoreConfidenceTests() {
        this.foo.setBar(new Bar());
        this.map.put("foo", this.foo);
        this.map.put("a", null);
        this.map.put("b", null);
        this.map.put("c", "cat");
        this.map.put("BWAH", "");
        this.map.put("misc", new MiscTestClass());
        this.map.put("pi", "3.14");
        this.map.put("hour", "60");
        this.map.put("zero", 0);
        this.map.put("testImpl", new TestInterface(){

            @Override
            public String getName() {
                return "FOOBAR!";
            }

            @Override
            public boolean isFoo() {
                return true;
            }
        });
        this.map.put("derived", this.derived);
    }

    public void testSingleProperty() {
        CoreConfidenceTests.assertEquals((Object)false, (Object)this.parseDirect("fun"));
    }

    public void testMethodOnValue() {
        CoreConfidenceTests.assertEquals((Object)"DOG", (Object)this.parseDirect("foo.bar.name.toUpperCase()"));
    }

    public void testSimpleProperty() {
        CoreConfidenceTests.assertEquals((Object)"dog", (Object)this.parseDirect("foo.bar.name"));
    }

    public void testSimpleProperty2() {
        CoreConfidenceTests.assertEquals((Object)"cat", (Object)this.parseDirect("DATA"));
    }

    public void testPropertyViaDerivedClass() {
        CoreConfidenceTests.assertEquals((Object)"cat", (Object)this.parseDirect("derived.data"));
    }

    public void testDeepAssignment() {
        CoreConfidenceTests.assertEquals((Object)"crap", (Object)this.parseDirect("foo.bar.assignTest = 'crap'"));
        CoreConfidenceTests.assertEquals((Object)"crap", (Object)this.parseDirect("foo.bar.assignTest"));
    }

    public void testThroughInterface() {
        CoreConfidenceTests.assertEquals((Object)"FOOBAR!", (Object)this.parseDirect("testImpl.name"));
    }

    public void testThroughInterface2() {
        CoreConfidenceTests.assertEquals((Object)true, (Object)this.parseDirect("testImpl.foo"));
    }

    public void testMapAccessWithMethodCall() {
        CoreConfidenceTests.assertEquals((Object)"happyBar", (Object)this.parseDirect("funMap['foo'].happy()"));
    }

    public void testBooleanOperator() {
        CoreConfidenceTests.assertEquals((Object)true, (Object)this.parseDirect("foo.bar.woof == true"));
    }

    public void testBooleanOperator2() {
        CoreConfidenceTests.assertEquals((Object)false, (Object)this.parseDirect("foo.bar.woof == false"));
    }

    public void testTextComparison() {
        CoreConfidenceTests.assertEquals((Object)true, (Object)this.parseDirect("foo.bar.name == 'dog'"));
    }

    public void testNETextComparison() {
        CoreConfidenceTests.assertEquals((Object)true, (Object)this.parseDirect("foo.bar.name != 'foo'"));
    }

    public void testChor() {
        CoreConfidenceTests.assertEquals((Object)"cat", (Object)this.parseDirect("a or b or c"));
    }

    public void testChorWithLiteral() {
        CoreConfidenceTests.assertEquals((Object)"fubar", (Object)this.parseDirect("a or 'fubar'"));
    }

    public void testNullCompare() {
        CoreConfidenceTests.assertEquals((Object)true, (Object)this.parseDirect("c != null"));
    }

    public void testUninitializedInt() {
        CoreConfidenceTests.assertEquals((Object)0, (Object)this.parseDirect("sarahl"));
    }

    public void testAnd() {
        CoreConfidenceTests.assertEquals((Object)true, (Object)this.parseDirect("c != null && foo.bar.name == 'dog' && foo.bar.woof"));
    }

    public void testMath() {
        CoreConfidenceTests.assertEquals((Object)Float.valueOf(188.4f), (Object)this.parseDirect("pi * hour"));
    }

    public void testMath2() {
        CoreConfidenceTests.assertEquals((Object)3, (Object)this.parseDirect("foo.number-1"));
    }

    public void testComplexExpression() {
        CoreConfidenceTests.assertEquals((Object)"bar", (Object)this.parseDirect("a = 'foo'; b = 'bar'; c = 'jim'; list = {a,b,c}; list[1]"));
    }

    public void testComplexAnd() {
        CoreConfidenceTests.assertEquals((Object)true, (Object)this.parseDirect("(pi * hour) > 0 && foo.happy() == 'happyBar'"));
    }

    public void testShortPathExpression() {
        CoreConfidenceTests.assertEquals(null, (Object)this.parseDirect("3 > 4 && foo.toUC('test'); foo.register"));
    }

    public void testShortPathExpression2() {
        CoreConfidenceTests.assertEquals((Object)true, (Object)this.parseDirect("4 > 3 || foo.toUC('test')"));
    }

    public void testOrOperator() {
        CoreConfidenceTests.assertEquals((Object)true, (Object)this.parseDirect("true || true"));
    }

    public void testOrOperator2() {
        CoreConfidenceTests.assertEquals((Object)true, (Object)this.parseDirect("2 > 3 || 3 > 2"));
    }

    public void testOrOperator3() {
        CoreConfidenceTests.assertEquals((Object)true, (Object)this.parseDirect("pi > 5 || pi > 6 || pi > 3"));
    }

    public void testShortPathExpression3() {
        CoreConfidenceTests.assertEquals((Object)false, (Object)this.parseDirect("defnull != null  && defnull.length() > 0"));
    }

    public void testModulus() {
        CoreConfidenceTests.assertEquals((Object)0, (Object)this.parseDirect("38392 % 2"));
    }

    public void testLessThan() {
        CoreConfidenceTests.assertEquals((Object)true, (Object)this.parseDirect("pi < 3.15"));
        CoreConfidenceTests.assertEquals((Object)true, (Object)this.parseDirect("pi <= 3.14"));
        CoreConfidenceTests.assertEquals((Object)false, (Object)this.parseDirect("pi > 3.14"));
        CoreConfidenceTests.assertEquals((Object)true, (Object)this.parseDirect("pi >= 3.14"));
    }

    public void testMethodAccess() {
        CoreConfidenceTests.assertEquals((Object)"happyBar", (Object)this.parseDirect("foo.happy()"));
    }

    public void testMethodAccess2() {
        CoreConfidenceTests.assertEquals((Object)"FUBAR", (Object)this.parseDirect("foo.toUC('fubar')"));
    }

    public void testMethodAccess3() {
        CoreConfidenceTests.assertEquals((Object)true, (Object)this.parseDirect("equalityCheck(c, 'cat')"));
    }

    public void testMethodAccess4() {
        CoreConfidenceTests.assertEquals(null, (Object)this.parseDirect("readBack(null)"));
    }

    public void testMethodAccess5() {
        CoreConfidenceTests.assertEquals((Object)"nulltest", (Object)this.parseDirect("appendTwoStrings(null, 'test')"));
    }

    public void testNegation() {
        CoreConfidenceTests.assertEquals((Object)true, (Object)this.parseDirect("!fun && !fun"));
    }

    public void testNegation2() {
        CoreConfidenceTests.assertEquals((Object)false, (Object)this.parseDirect("fun && !fun"));
    }

    public void testNegation3() {
        CoreConfidenceTests.assertEquals((Object)true, (Object)this.parseDirect("!(fun && fun)"));
    }

    public void testNegation4() {
        CoreConfidenceTests.assertEquals((Object)false, (Object)this.parseDirect("(fun && fun)"));
    }

    public void testMultiStatement() {
        CoreConfidenceTests.assertEquals((Object)true, (Object)this.parseDirect("populate(); barfoo == 'sarah'"));
    }

    public void testAssignment() {
        CoreConfidenceTests.assertEquals((Object)true, (Object)this.parseDirect("populate(); blahfoo = 'sarah'; blahfoo == 'sarah'"));
    }

    public void testAssignment2() {
        CoreConfidenceTests.assertEquals((Object)"sarah", (Object)this.parseDirect("populate(); blahfoo = barfoo"));
    }

    public void testAssignment3() {
        CoreConfidenceTests.assertEquals(Integer.class, this.parseDirect("blah = 5").getClass());
    }

    public void testAssignment4() {
        CoreConfidenceTests.assertEquals((Object)102, (Object)this.parseDirect("a = 100 + 1 + 1"));
    }

    public void testOr() {
        CoreConfidenceTests.assertEquals((Object)true, (Object)this.parseDirect("fun || true"));
    }

    public void testLiteralPassThrough() {
        CoreConfidenceTests.assertEquals((Object)true, (Object)this.parseDirect("true"));
    }

    public void testLiteralPassThrough2() {
        CoreConfidenceTests.assertEquals((Object)false, (Object)this.parseDirect("false"));
    }

    public void testLiteralPassThrough3() {
        CoreConfidenceTests.assertEquals(null, (Object)this.parseDirect("null"));
    }

    public void testRegEx() {
        CoreConfidenceTests.assertEquals((Object)true, (Object)this.parseDirect("foo.bar.name ~= '[a-z].+'"));
    }

    public void testRegExNegate() {
        CoreConfidenceTests.assertEquals((Object)false, (Object)this.parseDirect("!(foo.bar.name ~= '[a-z].+')"));
    }

    public void testRegEx2() {
        CoreConfidenceTests.assertEquals((Object)true, (Object)this.parseDirect("foo.bar.name ~= '[a-z].+' && foo.bar.name != null"));
    }

    public void testBlank() {
        CoreConfidenceTests.assertEquals((Object)true, (Object)this.parseDirect("'' == empty"));
    }

    public void testBlank2() {
        CoreConfidenceTests.assertEquals((Object)true, (Object)this.parseDirect("BWAH == empty"));
    }

    public void testBooleanModeOnly2() {
        CoreConfidenceTests.assertEquals((Object)false, (Object)MVEL.evalToBoolean("BWAH", (Object)this.base, this.map));
    }

    public void testBooleanModeOnly4() {
        CoreConfidenceTests.assertEquals((Object)true, (Object)MVEL.evalToBoolean("hour == (hour + 0)", (Object)this.base, this.map));
    }

    public void testTernary() {
        CoreConfidenceTests.assertEquals((Object)"foobie", (Object)this.parseDirect("zero==0?'foobie':zero"));
    }

    public void testTernary2() {
        CoreConfidenceTests.assertEquals((Object)"blimpie", (Object)this.parseDirect("zero==1?'foobie':'blimpie'"));
    }

    public void testTernary3() {
        CoreConfidenceTests.assertEquals((Object)"foobiebarbie", (Object)this.parseDirect("zero==1?'foobie':'foobie'+'barbie'"));
    }

    public void testStrAppend() {
        CoreConfidenceTests.assertEquals((Object)"foobarcar", (Object)this.parseDirect("'foo' + 'bar' + 'car'"));
    }

    public void testStrAppend2() {
        CoreConfidenceTests.assertEquals((Object)"foobarcar1", (Object)this.parseDirect("'foobar' + 'car' + 1"));
    }

    public void testInstanceCheck1() {
        CoreConfidenceTests.assertEquals((Object)true, (Object)this.parseDirect("c is 'java.lang.String'"));
    }

    public void testInstanceCheck2() {
        CoreConfidenceTests.assertEquals((Object)false, (Object)this.parseDirect("pi is 'java.lang.Integer'"));
    }

    public void testBitwiseOr1() {
        CoreConfidenceTests.assertEquals((Object)6, (Object)this.parseDirect("2 | 4"));
    }

    public void testBitwiseOr2() {
        CoreConfidenceTests.assertEquals((Object)true, (Object)this.parseDirect("(2 | 1) > 0"));
    }

    public void testBitwiseOr3() {
        CoreConfidenceTests.assertEquals((Object)true, (Object)this.parseDirect("(2 | 1) == 3"));
    }

    public void testBitwiseAnd1() {
        CoreConfidenceTests.assertEquals((Object)2, (Object)this.parseDirect("2 & 3"));
    }

    public void testShiftLeft() {
        CoreConfidenceTests.assertEquals((Object)4, (Object)this.parseDirect("2 << 1"));
    }

    public void testUnsignedShiftLeft() {
        CoreConfidenceTests.assertEquals((Object)2, (Object)this.parseDirect("-2 <<< 0"));
    }

    public void testShiftRight() {
        CoreConfidenceTests.assertEquals((Object)128, (Object)this.parseDirect("256 >> 1"));
    }

    public void testXOR() {
        CoreConfidenceTests.assertEquals((Object)3, (Object)this.parseDirect("1 ^ 2"));
    }

    public void testContains1() {
        CoreConfidenceTests.assertEquals((Object)true, (Object)this.parseDirect("list contains 'Happy!'"));
    }

    public void testContains2() {
        CoreConfidenceTests.assertEquals((Object)false, (Object)this.parseDirect("list contains 'Foobie'"));
    }

    public void testContains3() {
        CoreConfidenceTests.assertEquals((Object)true, (Object)this.parseDirect("sentence contains 'fox'"));
    }

    public void testContains4() {
        CoreConfidenceTests.assertEquals((Object)false, (Object)this.parseDirect("sentence contains 'mike'"));
    }

    public void testContains5() {
        CoreConfidenceTests.assertEquals((Object)true, (Object)this.parseDirect("!(sentence contains 'mike')"));
    }

    public void testInvert() {
        CoreConfidenceTests.assertEquals((Object)-11, (Object)this.parseDirect("~10"));
    }

    public void testInvert2() {
        CoreConfidenceTests.assertEquals((Object)-12, (Object)this.parseDirect("~(10 + 1)"));
    }

    public void testInvert3() {
        CoreConfidenceTests.assertEquals((Object)-61, (Object)this.parseDirect("~10 + (1 + ~50)"));
    }

    public void testListCreation2() {
        CoreConfidenceTests.assertTrue((boolean)(this.parseDirect("[\"test\"]") instanceof List));
    }

    public void testListCreation3() {
        CoreConfidenceTests.assertTrue((boolean)(this.parseDirect("[66]") instanceof List));
    }

    public void testListCreation4() {
        List ar = (List)this.parseDirect("[   66   , \"test\"   ]");
        CoreConfidenceTests.assertEquals((int)2, (int)ar.size());
        CoreConfidenceTests.assertEquals((Object)66, ar.get(0));
        CoreConfidenceTests.assertEquals((Object)"test", ar.get(1));
    }

    public void testListCreationWithCall() {
        CoreConfidenceTests.assertEquals((Object)1, (Object)this.parseDirect("[\"apple\"].size()"));
    }

    public void testArrayCreationWithLength() {
        CoreConfidenceTests.assertEquals((Object)2, (Object)this.parseDirect("Array.getLength({'foo', 'bar'})"));
    }

    public void testEmptyList() {
        CoreConfidenceTests.assertTrue((boolean)(this.parseDirect("[]") instanceof List));
    }

    public void testEmptyArray() {
        CoreConfidenceTests.assertTrue((((Object[])this.parseDirect("{}")).length == 0 ? 1 : 0) != 0);
    }

    public void testArrayCreation() {
        CoreConfidenceTests.assertEquals((Object)0, (Object)this.parseDirect("arrayTest = {{1, 2, 3}, {2, 1, 0}}; arrayTest[1][2]"));
    }

    public void testMapCreation() {
        CoreConfidenceTests.assertEquals((Object)"sarah", (Object)this.parseDirect("map = ['mike':'sarah','tom':'jacquelin']; map['mike']"));
    }

    public void testMapCreation2() {
        CoreConfidenceTests.assertEquals((Object)"sarah", (Object)this.parseDirect("map = ['mike' :'sarah'  ,'tom'  :'jacquelin'  ]; map['mike']"));
    }

    public void testMapCreation3() {
        CoreConfidenceTests.assertEquals((Object)"foo", (Object)this.parseDirect("map = [1 : 'foo']; map[1]"));
    }

    public void testProjectionSupport() {
        CoreConfidenceTests.assertEquals((Object)true, (Object)this.parseDirect("(name in things) contains 'Bob'"));
    }

    public void testProjectionSupport2() {
        CoreConfidenceTests.assertEquals((Object)3, (Object)this.parseDirect("(name in things).size()"));
    }

    public void testSizeOnInlineArray() {
        CoreConfidenceTests.assertEquals((Object)3, (Object)this.parseDirect("{1,2,3}.size()"));
    }

    public void testStaticMethodFromLiteral() {
        CoreConfidenceTests.assertEquals((Object)String.class.getName(), (Object)this.parseDirect("String.valueOf(Class.forName('java.lang.String').getName())"));
    }

    public void testMethodCallsEtc() {
        this.parseDirect("title = 1; frame = new javax.swing.JFrame; label = new javax.swing.JLabel; title = title + 1;frame.setTitle(title);label.setText('MVEL UNIT TEST PACKAGE -- IF YOU SEE THIS, THAT IS GOOD');frame.getContentPane().add(label);frame.pack();frame.setVisible(true);");
    }

    public void testObjectInstantiation() {
        this.parseDirect("new java.lang.String('foobie')");
    }

    public void testObjectInstantiationWithMethodCall() {
        this.parseDirect("new String('foobie').toString()");
    }

    public void testObjectInstantiation2() {
        this.parseDirect("new String() is String");
    }

    public void testObjectInstantiation3() {
        this.parseDirect("new java.text.SimpleDateFormat('yyyy').format(new java.util.Date(System.currentTimeMillis()))");
    }

    public void testArrayCoercion() {
        CoreConfidenceTests.assertEquals((Object)"gonk", (Object)this.parseDirect("funMethod( {'gonk', 'foo'} )"));
    }

    public void testArrayCoercion2() {
        CoreConfidenceTests.assertEquals((Object)10, (Object)this.parseDirect("sum({2,2,2,2,2})"));
    }

    public void testMapAccess() {
        CoreConfidenceTests.assertEquals((Object)"dog", (Object)this.parseDirect("funMap['foo'].bar.name"));
    }

    public void testMapAccess2() {
        CoreConfidenceTests.assertEquals((Object)"dog", (Object)this.parseDirect("funMap.foo.bar.name"));
    }

    public void testSoundex() {
        CoreConfidenceTests.assertTrue((boolean)((Boolean)this.parseDirect("'foobar' soundslike 'fubar'")));
    }

    public void testSoundex2() {
        CoreConfidenceTests.assertFalse((boolean)((Boolean)this.parseDirect("'flexbar' soundslike 'fubar'")));
    }

    public void testThisReference() {
        CoreConfidenceTests.assertEquals((boolean)true, (boolean)(this.parseDirect("this") instanceof Base));
    }

    public void testThisReference2() {
        CoreConfidenceTests.assertEquals((boolean)true, (boolean)(this.parseDirect("this.funMap") instanceof Map));
    }

    public void testThisReference3() {
        CoreConfidenceTests.assertEquals((Object)true, (Object)this.parseDirect("this is org.mvel.tests.main.res.Base"));
    }

    public void testStringEscaping() {
        CoreConfidenceTests.assertEquals((Object)"\"Mike Brock\"", (Object)this.parseDirect("\"\\\"Mike Brock\\\"\""));
    }

    public void testStringEscaping2() {
        CoreConfidenceTests.assertEquals((Object)"MVEL's Parser is Fast", (Object)this.parseDirect("'MVEL\\'s Parser is Fast'"));
    }

    public void testEvalToBoolean() {
        CoreConfidenceTests.assertEquals((boolean)true, (boolean)MVEL.evalToBoolean("true ", "true"));
        CoreConfidenceTests.assertEquals((boolean)true, (boolean)MVEL.evalToBoolean("true ", "true"));
    }

    public void testCompiledMapStructures() {
        Serializable compiled = MVEL.compileExpression("['foo':'bar'] contains 'foo'");
        MVEL.executeExpression(compiled, null, null, Boolean.class);
    }

    public void testSubListInMap() {
        CoreConfidenceTests.assertEquals((Object)"pear", (Object)this.parseDirect("map = ['test' : 'poo', 'foo' : [c, 'pear']]; map['foo'][1]"));
    }

    public void testCompiledMethodCall() {
        Serializable compiled = MVEL.compileExpression("c.getClass()");
        CoreConfidenceTests.assertEquals(String.class, (Object)MVEL.executeExpression((Object)compiled, (Object)this.base, this.map));
    }

    public void testStaticNamespaceCall() {
        CoreConfidenceTests.assertEquals(ArrayList.class, (Object)this.parseDirect("java.util.ArrayList"));
    }

    public void testStaticNamespaceClassWithMethod() {
        CoreConfidenceTests.assertEquals((Object)"FooBar", (Object)this.parseDirect("java.lang.String.valueOf('FooBar')"));
    }

    public void testThisReferenceInMethodCall() {
        CoreConfidenceTests.assertEquals((Object)101, (Object)this.parseDirect("Integer.parseInt(this.number)"));
    }

    public void testThisReferenceInConstructor() {
        CoreConfidenceTests.assertEquals((Object)"101", (Object)this.parseDirect("new String(this.number)"));
    }

    public void testConstructor() {
        CoreConfidenceTests.assertEquals((Object)"foo", (Object)this.parseDirect("a = 'foobar'; new String(a.toCharArray(), 0, 3)"));
    }

    public void testStaticNamespaceClassWithField() {
        CoreConfidenceTests.assertEquals((Object)Integer.MAX_VALUE, (Object)this.parseDirect("java.lang.Integer.MAX_VALUE"));
    }

    public void testStaticNamespaceClassWithField2() {
        CoreConfidenceTests.assertEquals((Object)Integer.MAX_VALUE, (Object)this.parseDirect("Integer.MAX_VALUE"));
    }

    public void testStaticFieldAsMethodParm() {
        CoreConfidenceTests.assertEquals((Object)String.valueOf(Integer.MAX_VALUE), (Object)this.parseDirect("String.valueOf(Integer.MAX_VALUE)"));
    }

    public void testEmptyIf() {
        CoreConfidenceTests.assertEquals((Object)5, (Object)this.parseDirect("a = 5; if (a == 5) { }; return a;"));
    }

    public void testIf() {
        CoreConfidenceTests.assertEquals((Object)10, (Object)this.parseDirect("if (5 > 4) { return 10; } else { return 5; }"));
    }

    public void testIf2() {
        CoreConfidenceTests.assertEquals((Object)10, (Object)this.parseDirect("if (5 < 4) { return 5; } else { return 10; }"));
    }

    public void testIfAndElse() {
        CoreConfidenceTests.assertEquals((Object)true, (Object)this.parseDirect("if (false) { return false; } else { return true; }"));
    }

    public void testIfAndElseif() {
        CoreConfidenceTests.assertEquals((Object)true, (Object)this.parseDirect("if (false) { return false; } else if(100 < 50) { return false; } else if (10 > 5) return true;"));
    }

    public void testIfAndElseIfCondensedGrammar() {
        CoreConfidenceTests.assertEquals((Object)"Foo", (Object)this.parseDirect("if (false) return 'Bar'; else return 'Foo';"));
    }

    public void testForeEach2() {
        CoreConfidenceTests.assertEquals((Object)6, (Object)this.parseDirect("total = 0; a = {1,2,3}; foreach(item : a) { total += item }; total"));
    }

    public void testForEach3() {
        CoreConfidenceTests.assertEquals((Object)true, (Object)this.parseDirect("a = {1,2,3}; foreach (i : a) { if (i == 1) { return true; } }"));
    }

    public void testForEach4() {
        CoreConfidenceTests.assertEquals((Object)"OneTwoThreeFour", (Object)this.parseDirect("a = {1,2,3,4}; builder = ''; foreach (i : a) { if (i == 1) { builder = builder + 'One' } else if (i == 2) { builder = builder + 'Two' } else if (i == 3) { builder = builder + 'Three' } else { builder = builder + 'Four' }}; builder;"));
    }

    public void testWith() {
        CoreConfidenceTests.assertEquals((Object)"OneTwo", (Object)this.parseDirect("with (foo) {aValue = 'One',bValue='Two'}; foo.aValue + foo.bValue;"));
    }

    public void testWith2() {
        CoreConfidenceTests.assertEquals((Object)"OneTwo", (Object)this.parseDirect("with (foo) { \naValue = 'One', \nbValue='Two' \n}; \nfoo.aValue + foo.bValue;"));
    }

    public void testAssertion() {
        try {
            this.parseDirect("assert false");
            CoreConfidenceTests.assertTrue((boolean)false);
        }
        catch (AssertionError assertionError) {
            // empty catch block
        }
    }

    public void testAssertion2() {
        try {
            this.parseDirect("assert true;");
        }
        catch (AssertionError error) {
            CoreConfidenceTests.assertTrue((boolean)false);
        }
    }

    public void testMagicArraySize() {
        CoreConfidenceTests.assertEquals((Object)5, (Object)this.parseDirect("stringArray.size()"));
    }

    public void testMagicArraySize2() {
        CoreConfidenceTests.assertEquals((Object)5, (Object)this.parseDirect("intArray.size()"));
    }

    public void testStaticVarAssignment() {
        CoreConfidenceTests.assertEquals((Object)"1", (Object)this.parseDirect("String mikeBrock = 1; mikeBrock"));
    }

    public void testIntentionalFailure() {
        try {
            this.parseDirect("int = 0");
            CoreConfidenceTests.assertTrue((boolean)false);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testImport() {
        CoreConfidenceTests.assertEquals(HashMap.class, (Object)this.parseDirect("import java.util.HashMap; HashMap;"));
    }

    public void testStaticImport() {
        CoreConfidenceTests.assertEquals((Object)2.0, (Object)this.parseDirect("import_static java.lang.Math.sqrt; sqrt(4)"));
    }

    public void testFunctionPointer() {
        CoreConfidenceTests.assertEquals((Object)2.0, (Object)this.parseDirect("squareRoot = java.lang.Math.sqrt; squareRoot(4)"));
    }

    public void testFunctionPointerAsParam() {
        CoreConfidenceTests.assertEquals((Object)"2.0", (Object)this.parseDirect("squareRoot = Math.sqrt; new String(String.valueOf(squareRoot(4)));"));
    }

    public void testIncrementOperator() {
        CoreConfidenceTests.assertEquals((Object)2, (Object)this.parseDirect("x = 1; x++; x"));
    }

    public void testPreIncrementOperator() {
        CoreConfidenceTests.assertEquals((Object)2, (Object)this.parseDirect("x = 1; ++x"));
    }

    public void testDecrementOperator() {
        CoreConfidenceTests.assertEquals((Object)1, (Object)this.parseDirect("x = 2; x--; x"));
    }

    public void testPreDecrementOperator() {
        CoreConfidenceTests.assertEquals((Object)1, (Object)this.parseDirect("x = 2; --x"));
    }

    public void testQualifiedStaticTyping() {
        CoreConfidenceTests.assertEquals((Object)20, (Object)this.parseDirect("java.math.BigDecimal a = new java.math.BigDecimal( 10.0 ); java.math.BigDecimal b = new java.math.BigDecimal( 10.0 ); java.math.BigDecimal c = a + b; return c; "));
    }

    public void testUnQualifiedStaticTyping() {
        CoreConfidenceTests.assertEquals((Object)20, (Object)this.parseDirect("import java.math.BigDecimal; BigDecimal a = new BigDecimal( 10.0 ); BigDecimal b = new BigDecimal( 10.0 ); BigDecimal c = a + b; return c; "));
    }

    public void testObjectCreation() {
        CoreConfidenceTests.assertEquals((Object)6, (Object)this.parseDirect("new Integer( 6 )"));
    }

    public void testTernary4() {
        CoreConfidenceTests.assertEquals((Object)"<test>", (Object)this.parseDirect("true ? '<test>' : '<poo>'"));
    }

    public void testStringAsCollection() {
        CoreConfidenceTests.assertEquals((Object)Character.valueOf('o'), (Object)this.parseDirect("abc = 'foo'; abc[1]"));
    }

    public void testSubExpressionIndexer() {
        CoreConfidenceTests.assertEquals((Object)"bar", (Object)this.parseDirect("xx = new java.util.HashMap(); xx.put('foo', 'bar'); prop = 'foo'; xx[prop];"));
    }

    public void testCompileTimeLiteralReduction() {
        CoreConfidenceTests.assertEquals((Object)1000, (Object)this.parseDirect("10 * 100"));
    }

    public void testInterfaceResolution() {
        Serializable ex = MVEL.compileExpression("foo.collectionTest.size()");
        this.foo.setCollectionTest(new HashSet());
        Object result1 = MVEL.executeExpression((Object)ex, this.map);
        this.foo.setCollectionTest(new ArrayList());
        Object result2 = MVEL.executeExpression((Object)ex, this.map);
        CoreConfidenceTests.assertEquals((Object)result1, (Object)result2);
    }

    public void testCreationOfSet() {
        CoreConfidenceTests.assertEquals((Object)"foo bar foo bar", (Object)this.parseDirect("set = new java.util.HashSet(); set.add('foo');set.add('bar');output = '';foreach (item : set) {output = output + item + ' ';} foreach (item : set) {output = output + item + ' ';} output = output.trim();if (set.size() == 2) { return output; }"));
    }

    public void testCreationOfList() {
        CoreConfidenceTests.assertEquals((Object)5, (Object)this.parseDirect("l = new java.util.LinkedList();l.add('fun');l.add('happy');l.add('fun');l.add('slide');l.add('crap');poo = new java.util.ArrayList(l);poo.size();"));
    }

    public void testMapOperations() {
        CoreConfidenceTests.assertEquals((Object)"poo5", (Object)this.parseDirect("l = new java.util.ArrayList();l.add('plop');l.add('poo');m = new java.util.HashMap();m.put('foo', l);m.put('cah', 'mah');m.put('bar', 'foo');m.put('sarah', 'mike');m.put('edgar', 'poe');if (m.edgar == 'poe') {return m.foo[1] + m.size();}"));
    }

    public void testStackOperations() {
        CoreConfidenceTests.assertEquals((Object)10, (Object)this.parseDirect("stk = new java.util.Stack();stk.push(5);stk.push(5);stk.pop() + stk.pop();"));
    }

    public void testCompileMultiLine() {
        ExpressionCompiler compiler = new ExpressionCompiler("a = 5;\nb = 5;\n\nif (a == b) {\n\nSystem.out.println('Good');\nreturn a + b;\n}\n");
        System.out.println("-------\n" + compiler.getExpression() + "\n-------\n");
        compiler.setDebugSymbols(true);
        ParserContext ctx = new ParserContext();
        ctx.setSourceFile("test.mv");
        CompiledExpression compiled = compiler.compile(ctx);
        System.out.println(DebugTools.decompile(compiled));
        MVELRuntime.registerBreakpoint("test.mv", 7);
        Debugger testDebugger = new Debugger(){

            @Override
            public int onBreak(Frame frame) {
                System.out.println("Breakpoint [source:" + frame.getSourceName() + "; line:" + frame.getLineNumber() + "]");
                return 0;
            }
        };
        MVELRuntime.setThreadDebugger(testDebugger);
        CoreConfidenceTests.assertEquals((Object)10, (Object)MVEL.executeDebugger(compiled, null, new MapVariableResolverFactory(this.map)));
    }

    public void testReflectionCache() {
        CoreConfidenceTests.assertEquals((Object)"happyBar", (Object)this.parseDirect("foo.happy(); foo.bar.happy()"));
    }

    public void testVarInputs() {
        ExpressionCompiler compiler = new ExpressionCompiler("test != foo && bo.addSomething(trouble); String bleh = foo; twa = bleh;");
        CompiledExpression c = compiler.compile();
        ParserContext pCtx = compiler.getParserContextState();
        CoreConfidenceTests.assertEquals((int)4, (int)pCtx.getInputs().size());
        CoreConfidenceTests.assertTrue((boolean)pCtx.getInputs().containsKey("test"));
        CoreConfidenceTests.assertTrue((boolean)pCtx.getInputs().containsKey("foo"));
        CoreConfidenceTests.assertTrue((boolean)pCtx.getInputs().containsKey("bo"));
        CoreConfidenceTests.assertTrue((boolean)pCtx.getInputs().containsKey("trouble"));
        CoreConfidenceTests.assertEquals((int)2, (int)pCtx.getVariables().size());
        CoreConfidenceTests.assertTrue((boolean)pCtx.getVariables().containsKey("bleh"));
        CoreConfidenceTests.assertTrue((boolean)pCtx.getVariables().containsKey("twa"));
        CoreConfidenceTests.assertEquals(String.class, (Object)DebugTools.determineType("bleh", c));
    }

    public void testVarInputs2() {
        ExpressionCompiler compiler = new ExpressionCompiler("test != foo && bo.addSomething(trouble); String bleh = foo; twa = bleh;");
        ParserContext ctx = new ParserContext();
        ctx.setRetainParserState(true);
        CompiledExpression c = compiler.compile(ctx);
        System.out.println(ctx.getVarOrInputType("bleh"));
    }

    public void testAnalyzer() {
        ExpressionCompiler compiler = new ExpressionCompiler("order.id == 10");
        compiler.compile();
        for (String input : compiler.getParserContextState().getInputs().keySet()) {
            System.out.println("input>" + input);
        }
        CoreConfidenceTests.assertEquals((int)1, (int)compiler.getParserContextState().getInputs().size());
        CoreConfidenceTests.assertTrue((boolean)compiler.getParserContextState().getInputs().containsKey("order"));
    }

    public void testClassImportViaFactory() {
        MapVariableResolverFactory mvf = new MapVariableResolverFactory(this.map);
        ClassImportResolverFactory classes = new ClassImportResolverFactory();
        classes.addClass(HashMap.class);
        ResolverTools.appendFactory(mvf, classes);
        Serializable compiled = MVEL.compileExpression("HashMap map = new HashMap()", classes.getImportedClasses());
        CoreConfidenceTests.assertTrue((boolean)(MVEL.executeExpression((Object)compiled, mvf) instanceof HashMap));
    }

    public void testCheeseConstructor() {
        MapVariableResolverFactory mvf = new MapVariableResolverFactory(this.map);
        ClassImportResolverFactory classes = new ClassImportResolverFactory();
        classes.addClass(Cheese.class);
        ResolverTools.appendFactory(mvf, classes);
        Serializable compiled = MVEL.compileExpression("cheese = new Cheese(\"cheddar\", 15);", classes.getImportedClasses());
        CoreConfidenceTests.assertTrue((boolean)(MVEL.executeExpression((Object)compiled, mvf) instanceof Cheese));
    }

    public void testInterceptors() {
        Interceptor testInterceptor = new Interceptor(){

            @Override
            public int doBefore(ASTNode node, VariableResolverFactory factory) {
                System.out.println("BEFORE Node: " + node.getName());
                return 0;
            }

            @Override
            public int doAfter(Object val, ASTNode node, VariableResolverFactory factory) {
                System.out.println("AFTER Node: " + node.getName());
                return 0;
            }
        };
        HashMap<String, Interceptor> interceptors = new HashMap<String, Interceptor>();
        interceptors.put("test", testInterceptor);
        Serializable compiled = MVEL.compileExpression("@test System.out.println('MIDDLE');", null, interceptors);
        MVEL.executeExpression(compiled);
    }

    public void testMacroSupport() {
        HashMap<String, Foo> vars = new HashMap<String, Foo>();
        vars.put("foo", new Foo());
        HashMap<String, Interceptor> interceptors = new HashMap<String, Interceptor>();
        HashMap<String, Macro> macros = new HashMap<String, Macro>();
        interceptors.put("Modify", new Interceptor(){

            @Override
            public int doBefore(ASTNode node, VariableResolverFactory factory) {
                factory.createVariable("mod", "FOOBAR!");
                return 0;
            }

            @Override
            public int doAfter(Object val, ASTNode node, VariableResolverFactory factory) {
                return 0;
            }
        });
        macros.put("modify", new Macro(){

            @Override
            public String doMacro() {
                return "@Modify with";
            }
        });
        Serializable s = MVEL.compileExpression(MVEL.parseMacros("modify (foo) { aValue = 'poo' }; mod", macros), null, interceptors);
        CoreConfidenceTests.assertEquals((Object)"FOOBAR!", (Object)MVEL.executeExpression((Object)s, vars));
    }

    public void testComments() {
        CoreConfidenceTests.assertEquals((Object)10, (Object)this.parseDirect("// This is a comment\n5 + 5"));
    }

    public void testComments2() {
        CoreConfidenceTests.assertEquals((Object)20, (Object)this.parseDirect("10 + 10; // This is a comment"));
    }

    public void testComments3() {
        CoreConfidenceTests.assertEquals((Object)30, (Object)this.parseDirect("/* This is a test of\r\nMVEL's support for\r\nmulti-line comments\r\n*/\r\n 15 + 15"));
    }

    public void testComments4() {
        CoreConfidenceTests.assertEquals((Object)50, (Object)this.parseDirect("/** This is a fun test script **/\r\na = 10;\r\n/**\r\n* Here is a useful variable\r\n*/\r\nb = 20; // set b to '20'\r\nreturn ((a + b) * 2) - 10;"));
    }

    public void testSubtractNoSpace1() {
        CoreConfidenceTests.assertEquals((Object)59, (Object)this.parseDirect("hour-1"));
    }

    public void testStrictTypingCompilation() {
        ExpressionCompiler compiler = new ExpressionCompiler("a.foo;\nb.foo;\n x = 5");
        ParserContext ctx = new ParserContext();
        ctx.setStrictTypeEnforcement(true);
        try {
            compiler.compile(ctx);
        }
        catch (CompileException e) {
            e.printStackTrace();
            CoreConfidenceTests.assertEquals((int)2, (int)e.getErrors().size());
            return;
        }
        CoreConfidenceTests.assertTrue((boolean)false);
    }

    public void testProvidedExternalTypes() {
        ExpressionCompiler compiler = new ExpressionCompiler("foo.bar");
        ParserContext ctx = new ParserContext();
        ctx.setStrictTypeEnforcement(true);
        ctx.addInput("foo", Foo.class);
        CompiledExpression c = compiler.compile(ctx);
    }

    public Object parseDirect(String ex) {
        return this.compiledExecute(ex);
    }

    public Object compiledExecute(String ex) {
        OptimizerFactory.setDefaultOptimizer("ASM");
        ExpressionCompiler compiler = new ExpressionCompiler(ex);
        Serializable compiled = compiler.compile();
        Object first = MVEL.executeExpression((Object)compiled, (Object)this.base, this.map);
        Object second = MVEL.executeExpression((Object)compiled, (Object)this.base, this.map);
        Object third = MVEL.eval(ex, (Object)this.base, this.map);
        if (first != null && !first.getClass().isArray()) {
            CoreConfidenceTests.assertEquals((Object)first, (Object)second);
            if (!first.equals(second)) {
                throw new AssertionError((Object)("Different result from test 1 and 2 (Compiled Re-Run / JIT) [first: " + String.valueOf(first) + "; second: " + String.valueOf(second) + "]"));
            }
            if (!first.equals(third)) {
                throw new AssertionError((Object)("Different result from test 1 and 3 (Compiled to Interpreted) [first: " + String.valueOf(first) + "; third: " + String.valueOf(third) + "]"));
            }
        }
        OptimizerFactory.setDefaultOptimizer("reflective");
        compiled = MVEL.compileExpression(ex);
        Object fourth = MVEL.executeExpression((Object)compiled, (Object)this.base, this.map);
        Object fifth = MVEL.executeExpression((Object)compiled, (Object)this.base, this.map);
        if (fourth != null && !fourth.getClass().isArray()) {
            CoreConfidenceTests.assertEquals((Object)fourth, (Object)fifth);
            if (!fourth.equals(fifth)) {
                throw new AssertionError((Object)("Different result from test 4 and 5 (Compiled Re-Run / Reflective) [first: " + String.valueOf(first) + "; second: " + String.valueOf(second) + "]"));
            }
        }
        return second;
    }

    public Object compiledExecute(String ex, Object base, Map map) {
        Serializable compiled = MVEL.compileExpression(ex);
        Object first = MVEL.executeExpression((Object)compiled, base, map);
        Object second = MVEL.executeExpression((Object)compiled, base, map);
        if (first != null && !first.getClass().isArray()) {
            CoreConfidenceTests.assertSame((Object)first, (Object)second);
        }
        return second;
    }

    public void testDifferentImplSameCompile() {
        Serializable compiled = MVEL.compileExpression("a.funMap.hello");
        HashMap<String, Base> testMap = new HashMap<String, Base>();
        for (int i = 0; i < 100; ++i) {
            Base b = new Base();
            b.funMap.put("hello", "dog");
            testMap.put("a", b);
            CoreConfidenceTests.assertEquals((Object)"dog", (Object)MVEL.executeExpression((Object)compiled, testMap));
            b = new Base();
            b.funMap.put("hello", "cat");
            testMap.put("a", b);
            CoreConfidenceTests.assertEquals((Object)"cat", (Object)MVEL.executeExpression((Object)compiled, testMap));
        }
    }

    public void testInterfaceMethodCallWithSpace() {
        Serializable compiled = MVEL.compileExpression("drools.retract (cheese)");
        HashMap<String, Object> map = new HashMap<String, Object>();
        DefaultKnowledgeHelper helper = new DefaultKnowledgeHelper();
        map.put("drools", helper);
        Cheese cheese = new Cheese("stilton", 15);
        map.put("cheese", cheese);
        MVEL.executeExpression((Object)compiled, map);
        CoreConfidenceTests.assertSame((Object)cheese, helper.retracted.get(0));
    }

    public void testInterfaceMethodCallWithMacro() {
        HashMap<String, Macro> macros = new HashMap<String, Macro>(1);
        macros.put("retract", new Macro(){

            @Override
            public String doMacro() {
                return "drools.retract";
            }
        });
        Serializable compiled = MVEL.compileExpression(MVEL.parseMacros("retract(cheese)", macros));
        HashMap<String, Object> map = new HashMap<String, Object>();
        DefaultKnowledgeHelper helper = new DefaultKnowledgeHelper();
        map.put("drools", helper);
        Cheese cheese = new Cheese("stilton", 15);
        map.put("cheese", cheese);
        MVEL.executeExpression((Object)compiled, map);
        CoreConfidenceTests.assertSame((Object)cheese, helper.retracted.get(0));
    }

    public void testToList() {
        String text = "misc.toList(foo.bar.name, 'hello', 42, ['key1' : 'value1', c : [ foo.bar.age, 'car', 42 ]], [42, [c : 'value1']] )";
        List list = (List)this.parseDirect(text);
        CoreConfidenceTests.assertSame((Object)"dog", list.get(0));
        CoreConfidenceTests.assertEquals((Object)"hello", list.get(1));
        CoreConfidenceTests.assertEquals((Object)new Integer(42), list.get(2));
        Map map = (Map)list.get(3);
        CoreConfidenceTests.assertEquals((Object)"value1", map.get("key1"));
        List nestedList = (List)map.get("cat");
        CoreConfidenceTests.assertEquals((Object)14, nestedList.get(0));
        CoreConfidenceTests.assertEquals((Object)"car", nestedList.get(1));
        CoreConfidenceTests.assertEquals((Object)42, nestedList.get(2));
        nestedList = (List)list.get(4);
        CoreConfidenceTests.assertEquals((Object)42, nestedList.get(0));
        map = (Map)nestedList.get(1);
        CoreConfidenceTests.assertEquals((Object)"value1", map.get("cat"));
    }

    public void testToList2() {
        for (int i = 0; i < 10; ++i) {
            this.testToList();
        }
    }

    public void testCalculateAge() {
        Calendar c1 = Calendar.getInstance();
        c1.set(1999, 0, 10);
        HashMap objectMap = new HashMap(1);
        HashMap<String, Date> propertyMap = new HashMap<String, Date>(1);
        propertyMap.put("GEBDAT", c1.getTime());
        objectMap.put("EV_VI_ANT1", propertyMap);
        CoreConfidenceTests.assertEquals((Object)"N", (Object)this.compiledExecute("new org.mvel.tests.main.res.PDFFieldUtil().calculateAge(EV_VI_ANT1.GEBDAT) >= 25 ? 'Y' : 'N'", null, objectMap));
    }

    public static class MiscTestClass {
        int exec = 0;

        public List toList(Object object1, String string, int integer, Map map, List list) {
            ++this.exec;
            ArrayList<Object> l = new ArrayList<Object>();
            l.add(object1);
            l.add(string);
            l.add(new Integer(integer));
            l.add(map);
            l.add(list);
            return l;
        }

        public int getExec() {
            return this.exec;
        }
    }
}

