/*
 * Decompiled with CFR 0.152.
 */
package org.mvel.ast;

import org.mvel.ASTNode;
import org.mvel.AbstractParser;
import org.mvel.Accessor;
import org.mvel.CompileException;
import org.mvel.ParserContext;
import org.mvel.integration.VariableResolverFactory;
import org.mvel.optimizers.OptimizerFactory;
import org.mvel.util.ArrayTools;

public class NewObjectNode
extends ASTNode {
    private Accessor newObjectOptimizer;

    public NewObjectNode(char[] expr, int fields) {
        super(expr, fields);
        if ((fields & 0x10) != 0) {
            int endRange = ArrayTools.findFirst('(', expr);
            String name = endRange == -1 ? new String(expr) : new String(expr, 0, ArrayTools.findFirst('(', expr));
            ParserContext pCtx = AbstractParser.getCurrentThreadParserContext();
            if (pCtx != null && pCtx.hasImport(name)) {
                this.egressType = pCtx.getImport(name);
            } else if (AbstractParser.LITERALS.containsKey(name)) {
                this.egressType = (Class)AbstractParser.LITERALS.get(name);
            } else {
                try {
                    this.egressType = Class.forName(name);
                }
                catch (ClassNotFoundException e) {
                    throw new CompileException("class not found: " + name, e);
                }
            }
        }
    }

    @Override
    public Object getReducedValueAccelerated(Object ctx, Object thisValue, VariableResolverFactory factory) {
        if (this.newObjectOptimizer == null) {
            this.newObjectOptimizer = OptimizerFactory.getThreadAccessorOptimizer().optimizeObjectCreation(this.name, ctx, thisValue, factory);
        }
        return this.newObjectOptimizer.getValue(ctx, thisValue, factory);
    }

    @Override
    public Object getReducedValue(Object ctx, Object thisValue, VariableResolverFactory factory) {
        return this.getReducedValueAccelerated(ctx, thisValue, factory);
    }

    public Accessor getNewObjectOptimizer() {
        return this.newObjectOptimizer;
    }
}

