/*
 * Decompiled with CFR 0.152.
 */
package org.myworldgis.projection;

import com.vividsolutions.jts.geom.Coordinate;
import java.text.ParseException;
import org.myworldgis.projection.Ellipsoid;
import org.myworldgis.projection.HemisphericalProjection;
import org.myworldgis.projection.ProjectionParameters;
import org.ngs.ngunits.SI;
import org.ngs.ngunits.Unit;
import org.ngs.ngunits.quantity.Angle;
import org.ngs.ngunits.quantity.Length;

public strictfp final class TransverseMercator
extends HemisphericalProjection {
    public static final String WKT_NAME = "Transverse_Mercator";
    public static final String CENTER_LON_PROPERTY = "central_meridian";
    public static final String CENTER_LAT_PROPERTY = "latitude_of_origin";
    public static final String SCALE_FACTOR_PROPERTY = "scale_factor";
    private double _k0;
    private double _ePrimeSq;
    private double _subMU;
    private double _M0;
    private double[] _subM;
    private double[] _subPhi1;
    private Coordinate _hemisphereCenter;

    public TransverseMercator(Ellipsoid ellipsoid, Coordinate center, Unit<Length> units, double falseEasting, double falseNorthing, double k0) {
        super(ellipsoid, center, units, falseEasting, falseNorthing);
        this._name = WKT_NAME;
        this._k0 = k0;
        this._subM = new double[4];
        this._subPhi1 = new double[4];
        this.computeParameters();
    }

    public TransverseMercator(Ellipsoid ellipsoid, ProjectionParameters parameters) throws ParseException {
        super(ellipsoid, parameters);
        this._name = WKT_NAME;
        this._k0 = parameters.getDimensionlessParameter(SCALE_FACTOR_PROPERTY);
        this._subM = new double[4];
        this._subPhi1 = new double[4];
        this.computeParameters();
    }

    public double getCenterScaleFactor() {
        return this._k0;
    }

    public void setCenterScaleFactor(double newScale) {
        if (newScale != this._k0) {
            this._k0 = newScale;
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            TransverseMercator proj = (TransverseMercator)obj;
            return StrictMath.abs(proj._k0 - this._k0) < 1.567855942887398E-7;
        }
        return false;
    }

    public int hashCode() {
        return (int)((long)super.hashCode() * Math.round(this._k0 / 1.567855942887398E-7) % Integer.MAX_VALUE);
    }

    @Override
    protected double getMaxC() {
        return 1.4137167;
    }

    @Override
    protected Coordinate getHemisphereCenter() {
        return this._hemisphereCenter;
    }

    @Override
    protected Coordinate forwardPointRaw(double lambda, double phi, Coordinate storage) {
        if (StrictMath.abs(StrictMath.abs(phi) - 1.5707963267948966) < 1.567855942887398E-7) {
            double M = this._a * (this._subM[0] * phi - this._subM[1] * StrictMath.sin(2.0 * phi) + this._subM[2] * StrictMath.sin(4.0 * phi) - this._subM[3] * StrictMath.sin(6.0 * phi));
            storage.x = 0.0;
            storage.y = this._k0 * (M - this._M0);
        } else {
            double sinPhi = StrictMath.sin(phi);
            double cosPhi = StrictMath.cos(phi);
            double tanPhi = StrictMath.tan(phi);
            double N = this._a / StrictMath.sqrt(1.0 - this._e2 * (sinPhi * sinPhi));
            double T = tanPhi * tanPhi;
            double C = this._ePrimeSq * (cosPhi * cosPhi);
            double A = (lambda - this._lambda0) * cosPhi;
            double M = this._a * (this._subM[0] * phi - this._subM[1] * StrictMath.sin(2.0 * phi) + this._subM[2] * StrictMath.sin(4.0 * phi) - this._subM[3] * StrictMath.sin(6.0 * phi));
            storage.x = this._k0 * N * (A + (1.0 - T + C) * A * A * A / 6.0 + (5.0 - 18.0 * T + T * T + 72.0 * C - 58.0 * this._ePrimeSq) * A * A * A * A * A / 120.0);
            storage.y = this._k0 * (M - this._M0 + N * tanPhi * (A * A / 2.0 + (5.0 - T + 9.0 * C + 4.0 * C * C) * A * A * A * A / 24.0 + (61.0 - 58.0 * T + T * T + 600.0 * C - 330.0 * this._ePrimeSq) * A * A * A * A * A * A / 720.0));
        }
        return storage;
    }

    @Override
    protected Coordinate inversePointRaw(double x, double y, Coordinate storage) {
        double M = this._M0 + y / this._k0;
        double mu = M / this._subMU;
        double phi1 = mu + this._subPhi1[0] * StrictMath.sin(2.0 * mu) + this._subPhi1[1] * StrictMath.sin(4.0 * mu) + this._subPhi1[2] * StrictMath.sin(6.0 * mu) + this._subPhi1[3] * StrictMath.sin(8.0 * mu);
        double sinPhi1 = StrictMath.sin(phi1);
        double cosPhi1 = StrictMath.cos(phi1);
        double tanPhi1 = StrictMath.tan(phi1);
        double C1 = this._ePrimeSq * cosPhi1 * cosPhi1;
        double T1 = tanPhi1 * tanPhi1;
        double N1 = this._a / StrictMath.sqrt(1.0 - this._e2 * sinPhi1 * sinPhi1);
        double R1 = this._a * (1.0 - this._e2) / StrictMath.pow(1.0 - this._e2 * sinPhi1 * sinPhi1, 1.5);
        double D = x / (N1 * this._k0);
        storage.y = phi1 - N1 * tanPhi1 / R1 * (D * D / 2.0 - (5.0 + 3.0 * T1 + 10.0 * C1 - 4.0 * C1 * C1 - 9.0 * this._ePrimeSq) * D * D * D * D / 24.0 + (61.0 + 90.0 * T1 + 298.0 * C1 + 45.0 * T1 * T1 - 252.0 * this._ePrimeSq - 3.0 * C1 * C1) * D * D * D * D * D * D / 720.0);
        storage.x = this._lambda0 + (D - (1.0 + 2.0 * T1 + C1) * D * D * D / 6.0 + (5.0 - 2.0 * C1 + 28.0 * T1 - 3.0 * C1 * C1 + 8.0 * this._ePrimeSq + 24.0 * T1 * T1) * D * D * D * D * D / 120.0) / cosPhi1;
        return storage;
    }

    @Override
    protected void computeParameters() {
        this._ePrimeSq = this._e2 / (1.0 - this._e2);
        this._subM[0] = 1.0 - this._e2 / 4.0 - 3.0 * this._e2 * this._e2 / 64.0 - 5.0 * this._e2 * this._e2 * this._e2 / 256.0;
        this._subM[1] = 3.0 * this._e2 / 8.0 + 3.0 * this._e2 * this._e2 / 32.0 + 45.0 * this._e2 * this._e2 * this._e2 / 1024.0;
        this._subM[2] = 15.0 * this._e2 * this._e2 / 256.0 + 45.0 * this._e2 * this._e2 * this._e2 / 1024.0;
        this._subM[3] = 35.0 * this._e2 * this._e2 * this._e2 / 3072.0;
        this._M0 = this._a * (this._subM[0] * this._phi0 - this._subM[1] * StrictMath.sin(2.0 * this._phi0) + this._subM[2] * StrictMath.sin(4.0 * this._phi0) - this._subM[3] * StrictMath.sin(6.0 * this._phi0));
        this._subMU = this._a * (1.0 - this._e2 / 4.0 - 3.0 * this._e2 * this._e2 / 64.0 - 5.0 * this._e2 * this._e2 * this._e2 / 256.0);
        double e1 = (1.0 - StrictMath.sqrt(1.0 - this._e2)) / (1.0 + StrictMath.sqrt(1.0 - this._e2));
        this._subPhi1[0] = 3.0 * e1 / 2.0 - 27.0 * e1 * e1 * e1 / 32.0;
        this._subPhi1[1] = 21.0 * e1 * e1 / 16.0 - 55.0 * e1 * e1 * e1 * e1 / 32.0;
        this._subPhi1[2] = 151.0 * e1 * e1 * e1 / 96.0;
        this._subPhi1[3] = 1097.0 * e1 * e1 * e1 * e1 / 512.0;
        this._hemisphereCenter = new Coordinate(this._lambda0, 0.0);
        super.computeParameters();
    }

    @Override
    public ProjectionParameters getParameters() {
        ProjectionParameters result = super.getParameters();
        result.addAngularParameter(CENTER_LON_PROPERTY, this._lambda0, (Unit<Angle>)SI.RADIAN);
        result.addAngularParameter(CENTER_LAT_PROPERTY, this._phi0, (Unit<Angle>)SI.RADIAN);
        result.addDimensionlessParameter(SCALE_FACTOR_PROPERTY, this._k0);
        return result;
    }

    @Override
    public Object clone() {
        TransverseMercator clone = (TransverseMercator)super.clone();
        clone._subM = (double[])this._subM.clone();
        clone._subPhi1 = (double[])this._subPhi1.clone();
        return clone;
    }
}

