/*
 * Decompiled with CFR 0.152.
 */
package javafx.util.converter;

import java.text.Format;
import java.text.ParsePosition;
import javafx.beans.NamedArg;
import javafx.util.StringConverter;

public class FormatStringConverter<T>
extends StringConverter<T> {
    final Format format;

    public FormatStringConverter(@NamedArg(value="format") Format format) {
        this.format = format;
    }

    @Override
    public T fromString(String value) {
        if (value == null) {
            return null;
        }
        if ((value = value.trim()).length() < 1) {
            return null;
        }
        Format _format = this.getFormat();
        ParsePosition pos = new ParsePosition(0);
        Object result = _format.parseObject(value, pos);
        if (pos.getIndex() != value.length()) {
            throw new RuntimeException("Parsed string not according to the format");
        }
        return (T)result;
    }

    @Override
    public String toString(T value) {
        if (value == null) {
            return "";
        }
        Format _format = this.getFormat();
        return _format.format(value);
    }

    protected Format getFormat() {
        return this.format;
    }
}

