/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control.cell;

import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Pos;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.cell.CellUtils;
import javafx.util.Callback;
import javafx.util.StringConverter;

public class CheckBoxListCell<T>
extends ListCell<T> {
    private final CheckBox checkBox;
    private ObservableValue<Boolean> booleanProperty;
    private ObjectProperty<StringConverter<T>> converter = new SimpleObjectProperty<StringConverter<T>>(this, "converter");
    private ObjectProperty<Callback<T, ObservableValue<Boolean>>> selectedStateCallback = new SimpleObjectProperty<Callback<T, ObservableValue<Boolean>>>(this, "selectedStateCallback");

    public static <T> Callback<ListView<T>, ListCell<T>> forListView(Callback<T, ObservableValue<Boolean>> getSelectedProperty) {
        return CheckBoxListCell.forListView(getSelectedProperty, CellUtils.defaultStringConverter());
    }

    public static <T> Callback<ListView<T>, ListCell<T>> forListView(Callback<T, ObservableValue<Boolean>> getSelectedProperty, StringConverter<T> converter) {
        return list -> new CheckBoxListCell(getSelectedProperty, converter);
    }

    public CheckBoxListCell() {
        this((Callback<T, ObservableValue<Boolean>>)null);
    }

    public CheckBoxListCell(Callback<T, ObservableValue<Boolean>> getSelectedProperty) {
        this(getSelectedProperty, CellUtils.defaultStringConverter());
    }

    public CheckBoxListCell(Callback<T, ObservableValue<Boolean>> getSelectedProperty, StringConverter<T> converter) {
        this.getStyleClass().add("check-box-list-cell");
        this.setSelectedStateCallback(getSelectedProperty);
        this.setConverter(converter);
        this.checkBox = new CheckBox();
        this.setAlignment(Pos.CENTER_LEFT);
        this.setContentDisplay(ContentDisplay.LEFT);
        this.setGraphic(null);
    }

    public final ObjectProperty<StringConverter<T>> converterProperty() {
        return this.converter;
    }

    public final void setConverter(StringConverter<T> value) {
        this.converterProperty().set(value);
    }

    public final StringConverter<T> getConverter() {
        return (StringConverter)this.converterProperty().get();
    }

    public final ObjectProperty<Callback<T, ObservableValue<Boolean>>> selectedStateCallbackProperty() {
        return this.selectedStateCallback;
    }

    public final void setSelectedStateCallback(Callback<T, ObservableValue<Boolean>> value) {
        this.selectedStateCallbackProperty().set(value);
    }

    public final Callback<T, ObservableValue<Boolean>> getSelectedStateCallback() {
        return (Callback)this.selectedStateCallbackProperty().get();
    }

    @Override
    public void updateItem(T item, boolean empty) {
        super.updateItem(item, empty);
        if (!empty) {
            StringConverter<T> c = this.getConverter();
            Callback<T, ObservableValue<Boolean>> callback = this.getSelectedStateCallback();
            if (callback == null) {
                throw new NullPointerException("The CheckBoxListCell selectedStateCallbackProperty can not be null");
            }
            this.setGraphic(this.checkBox);
            this.setText(c != null ? c.toString(item) : (item == null ? "" : item.toString()));
            if (this.booleanProperty != null) {
                this.checkBox.selectedProperty().unbindBidirectional((BooleanProperty)this.booleanProperty);
            }
            this.booleanProperty = callback.call(item);
            if (this.booleanProperty != null) {
                this.checkBox.selectedProperty().bindBidirectional((BooleanProperty)this.booleanProperty);
            }
        } else {
            this.setGraphic(null);
            this.setText(null);
        }
    }
}

