/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control;

import java.lang.ref.WeakReference;
import javafx.beans.NamedArg;
import javafx.scene.control.TablePositionBase;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeTableColumn;
import javafx.scene.control.TreeTableView;

public class TreeTablePosition<S, T>
extends TablePositionBase<TreeTableColumn<S, T>> {
    private final WeakReference<TreeTableView<S>> controlRef;
    private final WeakReference<TreeItem<S>> treeItemRef;
    int fixedColumnIndex = -1;
    private final int nonFixedColumnIndex;

    public TreeTablePosition(@NamedArg(value="treeTableView") TreeTableView<S> treeTableView, @NamedArg(value="row") int row, @NamedArg(value="tableColumn") TreeTableColumn<S, T> tableColumn) {
        super(row, tableColumn);
        this.controlRef = new WeakReference<TreeTableView<S>>(treeTableView);
        this.treeItemRef = new WeakReference<TreeItem<S>>(treeTableView.getTreeItem(row));
        this.nonFixedColumnIndex = treeTableView == null || tableColumn == null ? -1 : treeTableView.getVisibleLeafIndex(tableColumn);
    }

    TreeTablePosition(@NamedArg(value="treeTableView") TreeTablePosition<S, T> pos, @NamedArg(value="row") int row) {
        super(row, pos.getTableColumn());
        this.controlRef = new WeakReference<TreeTableView<S>>(pos.getTreeTableView());
        this.treeItemRef = new WeakReference<TreeItem<S>>(pos.getTreeItem());
        this.nonFixedColumnIndex = pos.getColumn();
    }

    @Override
    public int getColumn() {
        if (this.fixedColumnIndex > -1) {
            return this.fixedColumnIndex;
        }
        return this.nonFixedColumnIndex;
    }

    public final TreeTableView<S> getTreeTableView() {
        return (TreeTableView)this.controlRef.get();
    }

    @Override
    public final TreeTableColumn<S, T> getTableColumn() {
        return (TreeTableColumn)super.getTableColumn();
    }

    public final TreeItem<S> getTreeItem() {
        return (TreeItem)this.treeItemRef.get();
    }
}

