/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control;

import com.sun.javafx.css.converters.EnumConverter;
import com.sun.javafx.scene.control.skin.SplitPaneSkin;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.WeakHashMap;
import javafx.beans.DefaultProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.css.CssMetaData;
import javafx.css.PseudoClass;
import javafx.css.Styleable;
import javafx.css.StyleableObjectProperty;
import javafx.css.StyleableProperty;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Skin;

@DefaultProperty(value="items")
public class SplitPane
extends Control {
    private static final String RESIZABLE_WITH_PARENT = "resizable-with-parent";
    private ObjectProperty<Orientation> orientation;
    private final ObservableList<Node> items = FXCollections.observableArrayList();
    private final ObservableList<Divider> dividers = FXCollections.observableArrayList();
    private final ObservableList<Divider> unmodifiableDividers = FXCollections.unmodifiableObservableList(this.dividers);
    private final WeakHashMap<Integer, Double> dividerCache = new WeakHashMap();
    private static final String DEFAULT_STYLE_CLASS = "split-pane";
    private static final PseudoClass VERTICAL_PSEUDOCLASS_STATE = PseudoClass.getPseudoClass("vertical");
    private static final PseudoClass HORIZONTAL_PSEUDOCLASS_STATE = PseudoClass.getPseudoClass("horizontal");

    public static void setResizableWithParent(Node node, Boolean value) {
        if (value == null) {
            node.getProperties().remove(RESIZABLE_WITH_PARENT);
        } else {
            node.getProperties().put(RESIZABLE_WITH_PARENT, value);
        }
    }

    public static Boolean isResizableWithParent(Node node) {
        Object value;
        if (node.hasProperties() && (value = node.getProperties().get(RESIZABLE_WITH_PARENT)) != null) {
            return (Boolean)value;
        }
        return true;
    }

    public SplitPane() {
        this(null);
    }

    public SplitPane(Node ... items) {
        this.getStyleClass().setAll((String[])new String[]{DEFAULT_STYLE_CLASS});
        ((StyleableProperty)((Object)this.focusTraversableProperty())).applyStyle(null, Boolean.FALSE);
        this.getItems().addListener(new ListChangeListener<Node>(){

            @Override
            public void onChanged(ListChangeListener.Change<? extends Node> c) {
                while (c.next()) {
                    int i;
                    int from;
                    int index = from = c.getFrom();
                    for (i = 0; i < c.getRemovedSize(); ++i) {
                        if (index < SplitPane.this.dividers.size()) {
                            SplitPane.this.dividerCache.put(index, Double.MAX_VALUE);
                        } else if (index == SplitPane.this.dividers.size() && !SplitPane.this.dividers.isEmpty()) {
                            if (c.wasReplaced()) {
                                SplitPane.this.dividerCache.put(index - 1, ((Divider)SplitPane.this.dividers.get(index - 1)).getPosition());
                            } else {
                                SplitPane.this.dividerCache.put(index - 1, Double.MAX_VALUE);
                            }
                        }
                        ++index;
                    }
                    for (i = 0; i < SplitPane.this.dividers.size(); ++i) {
                        if (SplitPane.this.dividerCache.get(i) != null) continue;
                        SplitPane.this.dividerCache.put(i, ((Divider)SplitPane.this.dividers.get(i)).getPosition());
                    }
                }
                SplitPane.this.dividers.clear();
                for (int i = 0; i < SplitPane.this.getItems().size() - 1; ++i) {
                    if (SplitPane.this.dividerCache.containsKey(i) && (Double)SplitPane.this.dividerCache.get(i) != Double.MAX_VALUE) {
                        Divider d = new Divider();
                        d.setPosition((Double)SplitPane.this.dividerCache.get(i));
                        SplitPane.this.dividers.add(d);
                    } else {
                        SplitPane.this.dividers.add(new Divider());
                    }
                    SplitPane.this.dividerCache.remove(i);
                }
            }
        });
        if (items != null) {
            this.getItems().addAll((Node[])items);
        }
        this.pseudoClassStateChanged(HORIZONTAL_PSEUDOCLASS_STATE, true);
    }

    public final void setOrientation(Orientation value) {
        this.orientationProperty().set(value);
    }

    public final Orientation getOrientation() {
        return this.orientation == null ? Orientation.HORIZONTAL : (Orientation)((Object)this.orientation.get());
    }

    public final ObjectProperty<Orientation> orientationProperty() {
        if (this.orientation == null) {
            this.orientation = new StyleableObjectProperty<Orientation>(Orientation.HORIZONTAL){

                @Override
                public void invalidated() {
                    boolean isVertical = this.get() == Orientation.VERTICAL;
                    SplitPane.this.pseudoClassStateChanged(VERTICAL_PSEUDOCLASS_STATE, isVertical);
                    SplitPane.this.pseudoClassStateChanged(HORIZONTAL_PSEUDOCLASS_STATE, !isVertical);
                }

                @Override
                public CssMetaData<SplitPane, Orientation> getCssMetaData() {
                    return StyleableProperties.ORIENTATION;
                }

                @Override
                public Object getBean() {
                    return SplitPane.this;
                }

                @Override
                public String getName() {
                    return "orientation";
                }
            };
        }
        return this.orientation;
    }

    public ObservableList<Node> getItems() {
        return this.items;
    }

    public ObservableList<Divider> getDividers() {
        return this.unmodifiableDividers;
    }

    public void setDividerPosition(int dividerIndex, double position) {
        if (this.getDividers().size() <= dividerIndex) {
            this.dividerCache.put(dividerIndex, position);
            return;
        }
        if (dividerIndex >= 0) {
            ((Divider)this.getDividers().get(dividerIndex)).setPosition(position);
        }
    }

    public void setDividerPositions(double ... positions) {
        if (this.dividers.isEmpty()) {
            for (int i = 0; i < positions.length; ++i) {
                this.dividerCache.put(i, positions[i]);
            }
            return;
        }
        for (int i = 0; i < positions.length && i < this.dividers.size(); ++i) {
            ((Divider)this.dividers.get(i)).setPosition(positions[i]);
        }
    }

    public double[] getDividerPositions() {
        double[] positions = new double[this.dividers.size()];
        for (int i = 0; i < this.dividers.size(); ++i) {
            positions[i] = ((Divider)this.dividers.get(i)).getPosition();
        }
        return positions;
    }

    @Override
    protected Skin<?> createDefaultSkin() {
        return new SplitPaneSkin(this);
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return StyleableProperties.STYLEABLES;
    }

    @Override
    public List<CssMetaData<? extends Styleable, ?>> getControlCssMetaData() {
        return SplitPane.getClassCssMetaData();
    }

    @Override
    @Deprecated
    protected Boolean impl_cssGetFocusTraversableInitialValue() {
        return Boolean.FALSE;
    }

    public static class Divider {
        private DoubleProperty position;

        public final void setPosition(double value) {
            this.positionProperty().set(value);
        }

        public final double getPosition() {
            return this.position == null ? 0.5 : this.position.get();
        }

        public final DoubleProperty positionProperty() {
            if (this.position == null) {
                this.position = new SimpleDoubleProperty(this, "position", 0.5);
            }
            return this.position;
        }
    }

    private static class StyleableProperties {
        private static final CssMetaData<SplitPane, Orientation> ORIENTATION = new CssMetaData<SplitPane, Orientation>("-fx-orientation", new EnumConverter<Orientation>(Orientation.class), Orientation.HORIZONTAL){

            @Override
            public Orientation getInitialValue(SplitPane node) {
                return node.getOrientation();
            }

            @Override
            public boolean isSettable(SplitPane n) {
                return n.orientation == null || !n.orientation.isBound();
            }

            @Override
            public StyleableProperty<Orientation> getStyleableProperty(SplitPane n) {
                return (StyleableProperty)((Object)n.orientationProperty());
            }
        };
        private static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES;

        private StyleableProperties() {
        }

        static {
            ArrayList styleables = new ArrayList(Control.getClassCssMetaData());
            styleables.add(ORIENTATION);
            STYLEABLES = Collections.unmodifiableList(styleables);
        }
    }
}

