/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control;

import com.sun.javafx.scene.control.skin.ComboBoxPopupControl;
import com.sun.javafx.scene.control.skin.SpinnerSkin;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.temporal.TemporalUnit;
import javafx.beans.NamedArg;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.ObservableList;
import javafx.scene.AccessibleAction;
import javafx.scene.AccessibleAttribute;
import javafx.scene.AccessibleRole;
import javafx.scene.control.Control;
import javafx.scene.control.Skin;
import javafx.scene.control.SpinnerValueFactory;
import javafx.scene.control.TextField;
import javafx.util.StringConverter;

public class Spinner<T>
extends Control {
    private static final String DEFAULT_STYLE_CLASS = "spinner";
    public static final String STYLE_CLASS_ARROWS_ON_RIGHT_HORIZONTAL = "arrows-on-right-horizontal";
    public static final String STYLE_CLASS_ARROWS_ON_LEFT_VERTICAL = "arrows-on-left-vertical";
    public static final String STYLE_CLASS_ARROWS_ON_LEFT_HORIZONTAL = "arrows-on-left-horizontal";
    public static final String STYLE_CLASS_SPLIT_ARROWS_VERTICAL = "split-arrows-vertical";
    public static final String STYLE_CLASS_SPLIT_ARROWS_HORIZONTAL = "split-arrows-horizontal";
    private ReadOnlyObjectWrapper<T> value = new ReadOnlyObjectWrapper(this, "value");
    private ObjectProperty<SpinnerValueFactory<T>> valueFactory = new SimpleObjectProperty<SpinnerValueFactory<T>>(this, "valueFactory"){

        @Override
        protected void invalidated() {
            Spinner.this.value.unbind();
            SpinnerValueFactory newFactory = (SpinnerValueFactory)this.get();
            if (newFactory != null) {
                Spinner.this.value.bind(newFactory.valueProperty());
            }
        }
    };
    private BooleanProperty editable;
    private TextField textField;
    private ReadOnlyObjectWrapper<TextField> editor;

    public Spinner() {
        this.getStyleClass().add(DEFAULT_STYLE_CLASS);
        this.setAccessibleRole(AccessibleRole.SPINNER);
        this.getEditor().setOnAction(action -> {
            StringConverter<T> converter;
            String text = this.getEditor().getText();
            SpinnerValueFactory<T> valueFactory = this.getValueFactory();
            if (valueFactory != null && (converter = valueFactory.getConverter()) != null) {
                T value = converter.fromString(text);
                valueFactory.setValue(value);
            }
        });
        this.getEditor().editableProperty().bind(this.editableProperty());
        this.value.addListener((o, oldValue, newValue) -> this.setText(newValue));
        this.getProperties().addListener(change -> {
            if (change.wasAdded() && change.getKey() == "FOCUSED") {
                this.setFocused((Boolean)change.getValueAdded());
                this.getProperties().remove("FOCUSED");
            }
        });
    }

    public Spinner(@NamedArg(value="min") int min, @NamedArg(value="max") int max, @NamedArg(value="initialValue") int initialValue) {
        this(new SpinnerValueFactory.IntegerSpinnerValueFactory(min, max, initialValue));
    }

    public Spinner(@NamedArg(value="min") int min, @NamedArg(value="max") int max, @NamedArg(value="initialValue") int initialValue, @NamedArg(value="amountToStepBy") int amountToStepBy) {
        this(new SpinnerValueFactory.IntegerSpinnerValueFactory(min, max, initialValue, amountToStepBy));
    }

    public Spinner(@NamedArg(value="min") double min, @NamedArg(value="max") double max, @NamedArg(value="initialValue") double initialValue) {
        this(new SpinnerValueFactory.DoubleSpinnerValueFactory(min, max, initialValue));
    }

    public Spinner(@NamedArg(value="min") double min, @NamedArg(value="max") double max, @NamedArg(value="initialValue") double initialValue, @NamedArg(value="amountToStepBy") double amountToStepBy) {
        this(new SpinnerValueFactory.DoubleSpinnerValueFactory(min, max, initialValue, amountToStepBy));
    }

    Spinner(@NamedArg(value="min") LocalDate min, @NamedArg(value="max") LocalDate max, @NamedArg(value="initialValue") LocalDate initialValue) {
        this(new SpinnerValueFactory.LocalDateSpinnerValueFactory(min, max, initialValue));
    }

    Spinner(@NamedArg(value="min") LocalDate min, @NamedArg(value="max") LocalDate max, @NamedArg(value="initialValue") LocalDate initialValue, @NamedArg(value="amountToStepBy") long amountToStepBy, @NamedArg(value="temporalUnit") TemporalUnit temporalUnit) {
        this(new SpinnerValueFactory.LocalDateSpinnerValueFactory(min, max, initialValue, amountToStepBy, temporalUnit));
    }

    Spinner(@NamedArg(value="min") LocalTime min, @NamedArg(value="max") LocalTime max, @NamedArg(value="initialValue") LocalTime initialValue) {
        this(new SpinnerValueFactory.LocalTimeSpinnerValueFactory(min, max, initialValue));
    }

    Spinner(@NamedArg(value="min") LocalTime min, @NamedArg(value="max") LocalTime max, @NamedArg(value="initialValue") LocalTime initialValue, @NamedArg(value="amountToStepBy") long amountToStepBy, @NamedArg(value="temporalUnit") TemporalUnit temporalUnit) {
        this(new SpinnerValueFactory.LocalTimeSpinnerValueFactory(min, max, initialValue, amountToStepBy, temporalUnit));
    }

    public Spinner(@NamedArg(value="items") ObservableList<T> items) {
        this(new SpinnerValueFactory.ListSpinnerValueFactory<T>(items));
    }

    public Spinner(@NamedArg(value="valueFactory") SpinnerValueFactory<T> valueFactory) {
        this();
        this.setValueFactory(valueFactory);
    }

    public void increment() {
        this.increment(1);
    }

    public void increment(int steps) {
        SpinnerValueFactory<T> valueFactory = this.getValueFactory();
        if (valueFactory == null) {
            throw new IllegalStateException("Can't increment Spinner with a null SpinnerValueFactory");
        }
        this.commitEditorText();
        valueFactory.increment(steps);
    }

    public void decrement() {
        this.decrement(1);
    }

    public void decrement(int steps) {
        SpinnerValueFactory<T> valueFactory = this.getValueFactory();
        if (valueFactory == null) {
            throw new IllegalStateException("Can't decrement Spinner with a null SpinnerValueFactory");
        }
        this.commitEditorText();
        valueFactory.decrement(steps);
    }

    @Override
    protected Skin<?> createDefaultSkin() {
        return new SpinnerSkin(this);
    }

    public final T getValue() {
        return this.value.get();
    }

    public final ReadOnlyObjectProperty<T> valueProperty() {
        return this.value;
    }

    public final void setValueFactory(SpinnerValueFactory<T> value) {
        this.valueFactory.setValue(value);
    }

    public final SpinnerValueFactory<T> getValueFactory() {
        return (SpinnerValueFactory)this.valueFactory.get();
    }

    public final ObjectProperty<SpinnerValueFactory<T>> valueFactoryProperty() {
        return this.valueFactory;
    }

    public final void setEditable(boolean value) {
        this.editableProperty().set(value);
    }

    public final boolean isEditable() {
        return this.editable == null ? true : this.editable.get();
    }

    public final BooleanProperty editableProperty() {
        if (this.editable == null) {
            this.editable = new SimpleBooleanProperty(this, "editable", false);
        }
        return this.editable;
    }

    public final ReadOnlyObjectProperty<TextField> editorProperty() {
        if (this.editor == null) {
            this.editor = new ReadOnlyObjectWrapper(this, "editor");
            this.textField = new ComboBoxPopupControl.FakeFocusTextField();
            this.editor.set(this.textField);
        }
        return this.editor.getReadOnlyProperty();
    }

    public final TextField getEditor() {
        return (TextField)this.editorProperty().get();
    }

    private void setText(T value) {
        StringConverter<T> converter;
        String text = null;
        SpinnerValueFactory<T> valueFactory = this.getValueFactory();
        if (valueFactory != null && (converter = valueFactory.getConverter()) != null) {
            text = converter.toString(value);
        }
        this.notifyAccessibleAttributeChanged(AccessibleAttribute.TEXT);
        if (text == null) {
            if (value == null) {
                this.getEditor().clear();
                return;
            }
            text = value.toString();
        }
        this.getEditor().setText(text);
    }

    static int wrapValue(int value, int min, int max) {
        if (max == 0) {
            throw new RuntimeException();
        }
        int r = value % max;
        if (r > min && max < min) {
            r = r + max - min;
        } else if (r < min && max > min) {
            r = r + max - min;
        }
        return r;
    }

    static BigDecimal wrapValue(BigDecimal value, BigDecimal min, BigDecimal max) {
        if (max.doubleValue() == 0.0) {
            throw new RuntimeException();
        }
        if (value.compareTo(min) < 0) {
            return max;
        }
        if (value.compareTo(max) > 0) {
            return min;
        }
        return value;
    }

    private void commitEditorText() {
        StringConverter<T> converter;
        if (!this.isEditable()) {
            return;
        }
        String text = this.getEditor().getText();
        SpinnerValueFactory<T> valueFactory = this.getValueFactory();
        if (valueFactory != null && (converter = valueFactory.getConverter()) != null) {
            T value = converter.fromString(text);
            valueFactory.setValue(value);
        }
    }

    @Override
    public Object queryAccessibleAttribute(AccessibleAttribute attribute, Object ... parameters) {
        switch (attribute) {
            case TEXT: {
                StringConverter<T> converter;
                T value = this.getValue();
                SpinnerValueFactory<T> factory = this.getValueFactory();
                if (factory != null && (converter = factory.getConverter()) != null) {
                    return converter.toString(value);
                }
                return value != null ? value.toString() : "";
            }
        }
        return super.queryAccessibleAttribute(attribute, parameters);
    }

    @Override
    public void executeAccessibleAction(AccessibleAction action, Object ... parameters) {
        switch (action) {
            case INCREMENT: {
                this.increment();
                break;
            }
            case DECREMENT: {
                this.decrement();
                break;
            }
            default: {
                super.executeAccessibleAction(action, new Object[0]);
            }
        }
    }
}

