/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.fxml.expression;

import com.sun.javafx.fxml.BeanAdapter;
import com.sun.javafx.fxml.expression.Expression;
import com.sun.javafx.fxml.expression.KeyPath;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javafx.beans.InvalidationListener;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.ObservableValueBase;
import javafx.collections.ListChangeListener;
import javafx.collections.MapChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.ObservableMap;

public class ExpressionValue
extends ObservableValueBase<Object> {
    private Object namespace;
    private Expression expression;
    private Class<?> type;
    private ArrayList<KeyPathMonitor> argumentMonitors;
    private int listenerCount = 0;

    public ExpressionValue(Object namespace, Expression expression, Class<?> type) {
        if (namespace == null) {
            throw new NullPointerException();
        }
        if (expression == null) {
            throw new NullPointerException();
        }
        if (type == null) {
            throw new NullPointerException();
        }
        this.namespace = namespace;
        this.expression = expression;
        this.type = type;
        List<KeyPath> arguments = expression.getArguments();
        this.argumentMonitors = new ArrayList(arguments.size());
        for (KeyPath argument : arguments) {
            this.argumentMonitors.add(new KeyPathMonitor(argument.iterator()));
        }
    }

    @Override
    public Object getValue() {
        return BeanAdapter.coerce(this.expression.evaluate(this.namespace), this.type);
    }

    @Override
    public void addListener(InvalidationListener listener) {
        if (this.listenerCount == 0) {
            this.monitorArguments();
        }
        super.addListener(listener);
        ++this.listenerCount;
    }

    @Override
    public void removeListener(InvalidationListener listener) {
        super.removeListener(listener);
        --this.listenerCount;
        if (this.listenerCount == 0) {
            this.unmonitorArguments();
        }
    }

    @Override
    public void addListener(ChangeListener<? super Object> listener) {
        if (this.listenerCount == 0) {
            this.monitorArguments();
        }
        super.addListener(listener);
        ++this.listenerCount;
    }

    @Override
    public void removeListener(ChangeListener<? super Object> listener) {
        super.removeListener(listener);
        --this.listenerCount;
        if (this.listenerCount == 0) {
            this.unmonitorArguments();
        }
    }

    private void monitorArguments() {
        for (KeyPathMonitor argumentMonitor : this.argumentMonitors) {
            argumentMonitor.monitor(this.namespace);
        }
    }

    private void unmonitorArguments() {
        for (KeyPathMonitor argumentMonitor : this.argumentMonitors) {
            argumentMonitor.unmonitor();
        }
    }

    private class KeyPathMonitor {
        private String key;
        private KeyPathMonitor next;
        private Object namespace = null;
        private ListChangeListener<Object> listChangeListener = new ListChangeListener<Object>(){

            @Override
            public void onChanged(ListChangeListener.Change<? extends Object> change) {
                while (change.next()) {
                    int index = Integer.parseInt(KeyPathMonitor.this.key);
                    if (index < change.getFrom() || index >= change.getTo()) continue;
                    ExpressionValue.this.fireValueChangedEvent();
                    KeyPathMonitor.this.remonitor();
                }
            }
        };
        private MapChangeListener<String, Object> mapChangeListener = new MapChangeListener<String, Object>(){

            @Override
            public void onChanged(MapChangeListener.Change<? extends String, ? extends Object> change) {
                if (KeyPathMonitor.this.key.equals(change.getKey())) {
                    ExpressionValue.this.fireValueChangedEvent();
                    KeyPathMonitor.this.remonitor();
                }
            }
        };
        private ChangeListener<Object> propertyChangeListener = new ChangeListener<Object>(){

            @Override
            public void changed(ObservableValue<? extends Object> observable, Object oldValue, Object newValue) {
                ExpressionValue.this.fireValueChangedEvent();
                KeyPathMonitor.this.remonitor();
            }
        };

        public KeyPathMonitor(Iterator<String> keyPathIterator) {
            this.key = keyPathIterator.next();
            this.next = keyPathIterator.hasNext() ? new KeyPathMonitor(keyPathIterator) : null;
        }

        public void monitor(Object namespace) {
            Object value;
            if (namespace instanceof ObservableList) {
                ((ObservableList)namespace).addListener(this.listChangeListener);
            } else if (namespace instanceof ObservableMap) {
                ((ObservableMap)namespace).addListener(this.mapChangeListener);
            } else {
                BeanAdapter namespaceAdapter = new BeanAdapter(namespace);
                ObservableValue<Object> propertyModel = namespaceAdapter.getPropertyModel(this.key);
                if (propertyModel != null) {
                    propertyModel.addListener(this.propertyChangeListener);
                }
                namespace = namespaceAdapter;
            }
            this.namespace = namespace;
            if (this.next != null && (value = Expression.get(namespace, this.key)) != null) {
                this.next.monitor(value);
            }
        }

        public void unmonitor() {
            BeanAdapter namespaceAdapter;
            ObservableValue<Object> propertyModel;
            if (this.namespace instanceof ObservableList) {
                ((ObservableList)this.namespace).removeListener(this.listChangeListener);
            } else if (this.namespace instanceof ObservableMap) {
                ((ObservableMap)this.namespace).removeListener(this.mapChangeListener);
            } else if (this.namespace != null && (propertyModel = (namespaceAdapter = (BeanAdapter)this.namespace).getPropertyModel(this.key)) != null) {
                propertyModel.removeListener(this.propertyChangeListener);
            }
            this.namespace = null;
            if (this.next != null) {
                this.next.unmonitor();
            }
        }

        public void remonitor() {
            if (this.next != null) {
                this.next.unmonitor();
                Object value = Expression.get(this.namespace, this.key);
                if (value != null) {
                    this.next.monitor(value);
                }
            }
        }
    }
}

