/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.swing;

import java.awt.Dimension;
import java.awt.Font;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public strictfp class TextFieldBox
extends JPanel {
    private int labelAlignment;
    private Font labelFont;
    private Font fieldFont;
    private int maxLabelWidth = 0;
    private final List<JLabel> labels = new ArrayList<JLabel>();

    public TextFieldBox() {
        this(2, null, null);
    }

    public TextFieldBox(int labelAlignment) {
        this(labelAlignment, null, null);
    }

    public TextFieldBox(int labelAlignment, Font labelFont, Font fieldFont) {
        this.labelAlignment = labelAlignment;
        this.labelFont = labelFont;
        this.fieldFont = fieldFont;
        this.setLayout(new BoxLayout(this, 1));
    }

    public void addField(String prompt, JComponent textField) {
        JLabel label = new JLabel(prompt, this.labelAlignment);
        this.addField(label, textField);
    }

    public void addField(JLabel label, JComponent textField) {
        label.setLabelFor(textField);
        if (this.labelFont != null) {
            label.setFont(this.labelFont);
        }
        if (this.fieldFont != null) {
            textField.setFont(this.fieldFont);
        }
        textField.setMaximumSize(textField.getPreferredSize());
        Box holder = new Box(0);
        this.labels.add(label);
        label.setAlignmentX(0.0f);
        textField.setAlignmentX(0.0f);
        holder.add(label);
        holder.add(Box.createHorizontalStrut(8));
        holder.add(textField);
        holder.setAlignmentX(0.0f);
        holder.add(Box.createHorizontalGlue());
        holder.setMaximumSize(new Dimension(holder.getMaximumSize().width, holder.getPreferredSize().height));
        this.add(holder);
        this.add(Box.createVerticalStrut(4));
        int w = label.getPreferredSize().width;
        if (w > this.maxLabelWidth) {
            this.maxLabelWidth = w;
        }
        for (int j = 0; j < this.labels.size(); ++j) {
            JLabel l = this.labels.get(j);
            l.setPreferredSize(new Dimension(this.maxLabelWidth, l.getPreferredSize().height));
        }
    }

    public static void main(String[] argv) {
        TextFieldBox fb = new TextFieldBox(2);
        fb.addField("Name:", (JComponent)new JTextField(20));
        fb.addField("Server location or IP address:", (JComponent)new JTextField(8));
        fb.addField("Port:", (JComponent)new JTextField(20));
        fb.add(Box.createGlue());
        JDialog d = new JDialog();
        d.setTitle("TextFieldBox");
        d.setContentPane(fb);
        d.setVisible(true);
        d.setSize(new Dimension(fb.getPreferredSize().width + 20, fb.getPreferredSize().height + 40));
    }
}

