/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.swing;

import java.awt.Component;
import java.awt.FileDialog;
import java.awt.Frame;
import java.io.File;
import javax.swing.JFileChooser;
import org.nlogo.awt.Hierarchy$;
import org.nlogo.awt.UserCancelException;
import org.nlogo.core.I18N$;
import org.nlogo.swing.OptionDialog$;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.UninitializedFieldError;

public final class FileDialog$ {
    public static FileDialog$ MODULE$;
    private String currentDirectory;
    private volatile boolean bitmap$init$0;

    static {
        new FileDialog$();
    }

    private String currentDirectory() {
        if (!this.bitmap$init$0) {
            throw new UninitializedFieldError("Uninitialized field: /media/sf_NetLogo/netlogo-gui/src/main/swing/FileDialog.scala: 18");
        }
        return this.currentDirectory;
    }

    private void currentDirectory_$eq(String x$1) {
        this.currentDirectory = x$1;
        this.bitmap$init$0 = true;
    }

    public void setDirectory(String directory) {
        this.currentDirectory_$eq(directory);
    }

    public String showFiles(Component component, String title, int mode, String file) throws UserCancelException {
        return this.showFiles(Hierarchy$.MODULE$.getFrame(component), title, mode, file);
    }

    public Option<String> confirmFileOverwrite(Component owner, String path) {
        Object[] options = new Object[]{I18N$.MODULE$.gui().get("common.buttons.replace"), I18N$.MODULE$.gui().get("common.buttons.cancel")};
        String message = I18N$.MODULE$.gui().getN("file.save.warn.overwrite", Predef$.MODULE$.wrapRefArray(new Object[]{path}));
        if (OptionDialog$.MODULE$.showMessage(owner, "NetLogo", message, options) != 0) {
            return None$.MODULE$;
        }
        return new Some<String>(path);
    }

    public String showFiles(Frame parentFrame, String title, int mode) throws UserCancelException {
        return this.showFiles(parentFrame, title, mode, null);
    }

    public String showDirectories(Frame parentFrame, String title) throws UserCancelException {
        JFileChooser chooser = new JFileChooser(this.currentDirectory());
        chooser.setDialogTitle(title);
        chooser.setFileSelectionMode(1);
        if (chooser.showOpenDialog(parentFrame) != 0) {
            throw new UserCancelException();
        }
        this.currentDirectory_$eq(this.selectedDirectory(chooser));
        if (!chooser.getSelectedFile().exists()) {
            return this.showDirectories(parentFrame, title);
        }
        return chooser.getSelectedFile().getAbsolutePath();
    }

    private String showFiles(Frame parentFrame, String title, int mode, String file) throws UserCancelException {
        FileDialog dialog = new FileDialog(parentFrame, title, mode);
        dialog.setDirectory(this.currentDirectory());
        if (file != null) {
            dialog.setFile(file);
        }
        dialog.setVisible(true);
        if (dialog.getFile() == null) {
            throw new UserCancelException();
        }
        this.currentDirectory_$eq(dialog.getDirectory());
        if (mode == 0 && !new File(new StringBuilder(0).append(this.currentDirectory()).append(dialog.getFile()).toString()).exists()) {
            return this.showFiles(parentFrame, title, mode, dialog.getFile());
        }
        if (dialog.getDirectory() == null) {
            return dialog.getFile();
        }
        return new StringBuilder(0).append(dialog.getDirectory()).append(dialog.getFile()).toString();
    }

    private String selectedDirectory(JFileChooser chooser) {
        File file = chooser.getSelectedFile();
        return (file.isDirectory() ? file : chooser.getCurrentDirectory()).getAbsolutePath();
    }

    private FileDialog$() {
        MODULE$ = this;
        this.currentDirectory = System.getProperty("user.home");
        this.bitmap$init$0 = true;
    }
}

