/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.render;

import java.awt.Color;
import org.nlogo.api.GraphicsInterface;
import org.nlogo.api.Turtle;
import org.nlogo.core.ShapeListTracker;
import org.nlogo.render.Drawable;
import org.nlogo.render.TopologyRenderer;
import org.nlogo.render.TurtleShapeManager;
import org.nlogo.render.VectorShapeDrawable;
import org.nlogo.shape.VectorShape;

public strictfp class TurtleDrawer {
    private static final double MIN_PATCH_SIZE_FOR_TURTLE_SHAPES = 3.0;
    final TurtleShapeManager shapes;

    public TurtleDrawer(ShapeListTracker shapeTracker) {
        this.shapes = new TurtleShapeManager(shapeTracker);
    }

    public void drawTurtle(GraphicsInterface g, TopologyRenderer topology, Turtle turtle, double patchSize) {
        if (!turtle.hidden()) {
            if (turtle.size() * patchSize >= 3.0) {
                this.drawTurtleShape(g, topology, turtle, patchSize);
            } else {
                topology.drawWrappedRect(g, org.nlogo.api.Color.getColor(turtle.color()), 0.0f, turtle.xcor(), turtle.ycor(), turtle.size(), patchSize, true);
            }
            if (turtle.hasLabel()) {
                this.drawTurtleLabel(g, topology, turtle, patchSize);
            }
        }
    }

    void drawTurtleShape(GraphicsInterface g, TopologyRenderer topology, Turtle turtle, double patchSize) {
        Drawable d = this.getShapeFromCacheOrCreateDrawable(turtle, patchSize, this.shapes.getShape(turtle));
        topology.wrapDrawable(d, g, turtle.xcor(), turtle.ycor(), turtle.size(), patchSize);
    }

    private Drawable getShapeFromCacheOrCreateDrawable(Turtle turtle, double patchSize, VectorShape shape) {
        if (this.shapes.useCache(turtle, patchSize) && !shape.isTooSimpleToCache()) {
            Color turtleColor = org.nlogo.api.Color.getColor(turtle.color());
            Color fgColor = shape.fgRecolorable() ? turtleColor : new Color(255, 255, 255, turtleColor.getAlpha());
            return this.shapes.getCachedShape(shape, fgColor, turtle.heading(), turtle.size());
        }
        return new VectorShapeDrawable(shape, org.nlogo.api.Color.getColor(turtle.color()), patchSize, (int)turtle.heading(), turtle.lineThickness(), turtle.size());
    }

    void drawTurtleWithOutline(GraphicsInterface g, TopologyRenderer topology, Turtle turtle, double patchSize) {
        if (!turtle.hidden()) {
            if (turtle.size() * patchSize >= 3.0) {
                this.drawTurtleShapeWithOutline(g, topology, turtle, patchSize);
            } else {
                this.drawWrappedRectWithOutline(g, topology, turtle, patchSize);
            }
            if (turtle.hasLabel()) {
                this.drawTurtleLabel(g, topology, turtle, patchSize);
            }
        }
    }

    private void drawTurtleShapeWithOutline(GraphicsInterface g, TopologyRenderer topology, Turtle turtle, double patchSize) {
        double turtleSize = turtle.size();
        double xcor = turtle.xcor();
        double ycor = turtle.ycor();
        VectorShape shape = this.shapes.getShape(turtle);
        VectorShape outline = shape.clone();
        outline.setOutline();
        double thickness = StrictMath.min(turtleSize / 5.0, 0.5);
        Color color = org.nlogo.api.Color.getColor(turtle.color());
        int heading = (int)turtle.heading();
        topology.wrapDrawable(new VectorShapeDrawable(outline, color, patchSize, heading, thickness, turtleSize), g, turtle.xcor(), turtle.ycor(), turtleSize, patchSize);
        topology.wrapDrawable(new VectorShapeDrawable(outline, org.nlogo.api.Color.getComplement(color), patchSize, heading, thickness / 2.0, turtleSize), g, xcor, ycor, turtleSize, patchSize);
        topology.wrapDrawable(new VectorShapeDrawable(shape, color, patchSize, heading, turtle.lineThickness(), turtleSize), g, xcor, ycor, turtleSize, patchSize);
    }

    private void drawWrappedRectWithOutline(GraphicsInterface g, TopologyRenderer topology, Turtle turtle, double patchSize) {
        double xcor = turtle.xcor();
        double ycor = turtle.ycor();
        double turtleSize = turtle.size();
        Color color = org.nlogo.api.Color.getColor(turtle.color());
        topology.drawWrappedRect(g, color, 4.0f, xcor, ycor, turtleSize, patchSize, false);
        topology.drawWrappedRect(g, org.nlogo.api.Color.getComplement(color), 2.0f, xcor, ycor, turtleSize, patchSize, false);
        topology.drawWrappedRect(g, color, (float)turtleSize, xcor, ycor, turtleSize, patchSize, true);
    }

    private void drawTurtleLabel(GraphicsInterface g, TopologyRenderer topology, Turtle turtle, double patchSize) {
        topology.drawLabelHelper(g, turtle.xcor(), turtle.ycor(), turtle.labelString(), turtle.labelColor(), patchSize, turtle.size());
    }
}

