/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.render;

import java.awt.Color;
import java.awt.Image;
import java.awt.geom.Rectangle2D;
import org.nlogo.api.GraphicsInterface;
import org.nlogo.api.ViewSettings;
import org.nlogo.api.World;
import org.nlogo.render.Drawable;
import org.nlogo.render.TopologyRenderer;

public strictfp abstract class AbstractTopologyRenderer
implements TopologyRenderer {
    final World world;
    int width;
    int height;
    int viewWidth;
    int viewHeight;
    int worldAndViewPreMultipliedX;
    int worldAndViewPreMultipliedY;
    double viewOffsetX;
    double viewOffsetY;

    public AbstractTopologyRenderer(World world) {
        this.world = world;
    }

    @Override
    public void prepareToPaint(ViewSettings settings, int width, int height) {
        this.width = width;
        this.height = height;
        this.viewWidth = (int)StrictMath.round(settings.viewWidth() * settings.patchSize());
        this.viewHeight = (int)StrictMath.round(settings.viewHeight() * settings.patchSize());
        if (settings.renderPerspective()) {
            this.viewOffsetX = settings.viewOffsetX();
            this.viewOffsetY = settings.viewOffsetY();
            this.worldAndViewPreMultipliedX = -((int)StrictMath.round(settings.patchSize() * this.viewOffsetX));
            this.worldAndViewPreMultipliedY = (int)StrictMath.round(settings.patchSize() * this.viewOffsetY);
        } else {
            this.worldAndViewPreMultipliedX = 0;
            this.worldAndViewPreMultipliedY = 0;
            this.viewOffsetX = 0.0;
            this.viewOffsetY = 0.0;
        }
    }

    void draw(Drawable drawable, GraphicsInterface g, double x, double y, double xOffset, double yOffset, double size) {
        if (x + size - xOffset >= 0.0 && x - xOffset <= (double)this.viewWidth && y + size - yOffset >= 0.0 && y - yOffset <= (double)this.viewHeight) {
            g.push();
            g.translate(-xOffset, -yOffset);
            drawable.draw(g, size);
            g.pop();
        }
    }

    protected void drawLabel(String label, GraphicsInterface g, double x, double y, double xOffset, double yOffset, double patchSize) {
        g.push();
        g.drawLabel(label, x - xOffset, y - yOffset, patchSize);
        g.pop();
    }

    @Override
    public void drawWrappedRect(GraphicsInterface g, Color color, final float stroke, double xcor, double ycor, double agentSize, double patchSize, final boolean fill) {
        g.setColor(color);
        this.wrapDrawable(new Drawable(){

            @Override
            public void draw(GraphicsInterface g, double size) {
                g.setStroke(stroke);
                Rectangle2D.Double rect = new Rectangle2D.Double(0.0, 0.0, size, size);
                if (fill) {
                    g.fill(rect);
                } else {
                    g.draw(rect);
                }
            }

            @Override
            public double adjustSize(double turtleSize, double patchSize) {
                return patchSize >= 5.0 ? -2.0 : 0.0;
            }
        }, g, xcor, ycor, agentSize, patchSize);
    }

    void fillWith(GraphicsInterface g, Color color) {
        g.setColor(color);
        g.fillRect(0, 0, this.width, this.height);
    }

    @Override
    public void paintViewImage(GraphicsInterface g, Image image) {
        g.setInterpolation();
        g.drawImage(image, this.worldAndViewPreMultipliedX, this.worldAndViewPreMultipliedY, this.width, this.height);
    }

    @Override
    public double wrapX(double pos) {
        return this.world.wrap(pos, (double)this.world.minPxcor() - 0.5, (double)this.world.maxPxcor() + 0.5);
    }

    @Override
    public double wrapY(double pos) {
        return this.world.wrap(pos, (double)this.world.minPycor() - 0.5, (double)this.world.maxPycor() + 0.5);
    }

    double graphicsXNoOffset(double xcor, double patchSize) {
        return patchSize * (xcor - ((double)this.world.minPxcor() - 0.5)) - 0.5;
    }

    double graphicsYNoOffset(double ycor, double patchSize) {
        return patchSize * (-ycor + ((double)this.world.maxPycor() + 0.5)) - 0.5;
    }

    @Override
    public final double graphicsX(double xcor, double patchSize) {
        return this.graphicsX(xcor, patchSize, this.viewOffsetX);
    }

    @Override
    public double graphicsX(double xcor, double patchSize, double viewOffsetX) {
        return patchSize * (xcor - (double)this.world.minPxcor() + 0.5 - viewOffsetX);
    }

    @Override
    public final double graphicsY(double ycor, double patchSize) {
        return this.graphicsY(ycor, patchSize, this.viewOffsetY);
    }

    @Override
    public double graphicsY(double ycor, double patchSize, double viewOffsetY) {
        return patchSize * (-ycor + (double)this.world.maxPycor() + 0.5 + viewOffsetY);
    }
}

