/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.mc;

import java.awt.Frame;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JDialog;
import org.apache.http.client.HttpClient;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.nlogo.mc.LoadingDialog;
import org.nlogo.mc.PostRequest;

public strictfp abstract class DownloadNewUserParametersRequest
extends PostRequest {
    private JDialog loadingDialog;
    private Frame frame;

    public DownloadNewUserParametersRequest(HttpClient http, Frame frame) {
        super(http, "http://modelingcommons.org/account/new");
        this.frame = frame;
    }

    @Override
    protected void onReturn(String response) {
        this.loadingDialog.dispose();
        if (response == null) {
            this.onDownloaded("CONNECTION_ERROR", null, null, null);
            return;
        }
        JSONParser json = new JSONParser();
        try {
            ArrayList<String> priorityCountries = new ArrayList<String>();
            ArrayList<String> unpriorityCountries = new ArrayList<String>();
            JSONObject obj = (JSONObject)json.parse(response);
            JSONArray countries = (JSONArray)obj.get((Object)"countries");
            for (Object countryObj : countries) {
                JSONObject country = (JSONObject)countryObj;
                String countryName = (String)country.get((Object)"name");
                Boolean isPriority = (Boolean)country.get((Object)"priority");
                if (isPriority.booleanValue()) {
                    priorityCountries.add(countryName);
                    continue;
                }
                unpriorityCountries.add(countryName);
            }
            String userAgreement = (String)obj.get((Object)"user_agreement");
            this.onDownloaded("SUCCESS", userAgreement, priorityCountries, unpriorityCountries);
        }
        catch (ParseException e) {
            this.onDownloaded("INVALID_RESPONSE_FROM_SERVER", null, null, null);
        }
    }

    @Override
    public void execute() {
        this.loadingDialog = new LoadingDialog(this.frame, "Loading new user information");
        super.execute();
        this.loadingDialog.setVisible(true);
    }

    protected abstract void onDownloaded(String var1, String var2, List<String> var3, List<String> var4);
}

