/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.util.hash;

import org.openimaj.util.hash.HashFunction;

public class StringMurmurHashFunction
implements HashFunction<String> {
    private int seed = -1;

    public StringMurmurHashFunction() {
    }

    public StringMurmurHashFunction(int seed) {
        this.seed = seed;
    }

    @Override
    public int computeHashCode(String data) {
        return StringMurmurHashFunction.murmurhash(data.getBytes(), this.seed);
    }

    public static int murmurhash(byte[] data) {
        return StringMurmurHashFunction.murmurhash(data, data.length, -1);
    }

    public static int murmurhash(byte[] data, int seed) {
        return StringMurmurHashFunction.murmurhash(data, data.length, seed);
    }

    public static int murmurhash(byte[] data, int length, int seed) {
        int m = 1540483477;
        int r = 24;
        int h = seed ^ length;
        int len_4 = length >> 2;
        for (int i = 0; i < len_4; ++i) {
            int i_4 = i << 2;
            int k = data[i_4 + 3];
            k <<= 8;
            k |= data[i_4 + 2] & 0xFF;
            k <<= 8;
            k |= data[i_4 + 1] & 0xFF;
            k <<= 8;
            k |= data[i_4 + 0] & 0xFF;
            k *= 1540483477;
            k ^= k >>> 24;
            h *= 1540483477;
            h ^= (k *= 1540483477);
        }
        int len_m = len_4 << 2;
        int left = length - len_m;
        if (left != 0) {
            if (left >= 3) {
                h ^= data[length - 3] << 16;
            }
            if (left >= 2) {
                h ^= data[length - 2] << 8;
            }
            if (left >= 1) {
                h ^= data[length - 1];
            }
            h *= 1540483477;
        }
        h ^= h >>> 13;
        h *= 1540483477;
        h ^= h >>> 15;
        return h;
    }
}

