/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.io;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Scanner;
import org.openimaj.io.IOUtils;
import org.openimaj.io.ReadWriteable;
import org.openimaj.io.ReadableASCII;
import org.openimaj.io.ReadableBinary;
import org.openimaj.io.WriteableASCII;
import org.openimaj.io.WriteableBinary;

class ObjectWrapper
implements ReadWriteable {
    Object object;

    public ObjectWrapper() {
    }

    public ObjectWrapper(Object o) {
        this.object = o;
    }

    @Override
    public void readASCII(Scanner in) throws IOException {
        String className = in.next();
        this.object = IOUtils.newInstance(className);
        ((ReadableASCII)this.object).readASCII(in);
    }

    @Override
    public String asciiHeader() {
        return "Class: ";
    }

    @Override
    public void readBinary(DataInput in) throws IOException {
        String className = in.readUTF();
        this.object = IOUtils.newInstance(className);
        ((ReadableBinary)this.object).readBinary(in);
    }

    @Override
    public byte[] binaryHeader() {
        return "CLS:".getBytes();
    }

    @Override
    public void writeASCII(PrintWriter out) throws IOException {
        out.println(this.object.getClass().getName());
        ((WriteableASCII)this.object).writeASCII(out);
    }

    @Override
    public void writeBinary(DataOutput out) throws IOException {
        out.writeUTF(this.object.getClass().getName());
        ((WriteableBinary)this.object).writeBinary(out);
    }
}

