/*
 * Decompiled with CFR 0.152.
 */
package com.github.sarxos.webcam.ds.openimaj;

import com.github.sarxos.webcam.WebcamDevice;
import com.github.sarxos.webcam.WebcamDriver;
import com.github.sarxos.webcam.WebcamTask;
import com.github.sarxos.webcam.ds.openimaj.OpenImajDevice;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.openimaj.video.capture.Device;
import org.openimaj.video.capture.VideoCapture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenImajDriver
implements WebcamDriver {
    private static final Logger LOG;

    public List<WebcamDevice> getDevices() {
        List<WebcamDevice> devices = new GetDevicesTask(this).getDevices();
        if (LOG.isDebugEnabled()) {
            for (WebcamDevice device : devices) {
                LOG.debug("OpenIMAJ found device {}", (Object)device.getName());
            }
        }
        return devices;
    }

    public boolean isThreadSafe() {
        return false;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    static {
        if (!"true".equals(System.getProperty("webcam.debug"))) {
            System.setProperty("bridj.quiet", "true");
        }
        LOG = LoggerFactory.getLogger(OpenImajDriver.class);
    }

    private static class GetDevicesTask
    extends WebcamTask {
        private volatile List<WebcamDevice> devices = null;

        public GetDevicesTask(WebcamDriver driver) {
            super(driver, null);
        }

        public List<WebcamDevice> getDevices() {
            try {
                this.process();
            }
            catch (InterruptedException e) {
                LOG.debug("Interrupted", (Throwable)e);
                return Collections.emptyList();
            }
            return this.devices;
        }

        protected void handle() {
            this.devices = new ArrayList<WebcamDevice>();
            for (Device device : VideoCapture.getVideoDevices()) {
                this.devices.add(new OpenImajDevice(device));
            }
        }
    }
}

