/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.audio.processor;

import org.openimaj.audio.AudioStream;
import org.openimaj.audio.SampleChunk;
import org.openimaj.audio.processor.AudioProcessor;

public class FixedSizeSampleAudioProcessor
extends AudioProcessor {
    private int requiredSampleSetSize = 512;
    private SampleChunk sampleBuffer = null;
    private int windowStep = 0;
    private boolean overlapping = false;

    public FixedSizeSampleAudioProcessor(int sizeRequired) {
        this.requiredSampleSetSize = sizeRequired;
    }

    public FixedSizeSampleAudioProcessor(AudioStream stream, int sizeRequired) {
        super(stream);
        this.requiredSampleSetSize = sizeRequired;
    }

    public FixedSizeSampleAudioProcessor(int nSamplesInWindow, int nSamplesOverlap) {
        this(nSamplesInWindow);
        this.setWindowStep(nSamplesOverlap);
    }

    public FixedSizeSampleAudioProcessor(AudioStream as, int nSamplesInWindow, int nSamplesOverlap) {
        this(as, nSamplesInWindow);
        this.setWindowStep(nSamplesOverlap);
    }

    @Override
    public SampleChunk nextSampleChunk() {
        SampleChunk ss;
        SampleChunk s = null;
        if (this.sampleBuffer != null && this.sampleBuffer.getNumberOfSamples() >= this.requiredSampleSetSize) {
            s = this.sampleBuffer;
            this.sampleBuffer = null;
        } else {
            s = this.getUnderlyingStream().nextSampleChunk();
            if (s != null) {
                s = s.clone();
            }
            if (this.sampleBuffer != null && this.sampleBuffer.getNumberOfSamples() > 0 && s != null) {
                s.prepend(this.sampleBuffer);
                this.sampleBuffer = null;
            }
        }
        if (s == null) {
            if (this.sampleBuffer != null) {
                s = this.sampleBuffer;
                this.sampleBuffer = null;
                return s;
            }
            return null;
        }
        int nSamples = s.getNumberOfSamples();
        boolean endOfStream = false;
        while (!endOfStream && nSamples < this.requiredSampleSetSize) {
            SampleChunk nextSamples = this.getUnderlyingStream().nextSampleChunk();
            if (nextSamples != null) {
                s.append(nextSamples);
                nSamples = s.getNumberOfSamples();
                continue;
            }
            endOfStream = true;
        }
        if (!endOfStream && (this.overlapping || nSamples > this.requiredSampleSetSize)) {
            int start = 0;
            start = this.overlapping ? this.windowStep : this.requiredSampleSetSize;
            this.sampleBuffer = s.getSampleSlice(start, nSamples - start);
            ss = s.getSampleSlice(0, this.requiredSampleSetSize);
        } else {
            ss = s;
            if (ss.getNumberOfSamples() < this.requiredSampleSetSize) {
                ss.pad(this.requiredSampleSetSize);
            }
        }
        try {
            return this.process(ss);
        }
        catch (Exception e) {
            e.printStackTrace();
            return ss;
        }
    }

    public void setWindowStep(int overlap) {
        this.windowStep = overlap;
        this.overlapping = true;
        if (overlap <= 0) {
            this.overlapping = false;
        }
    }

    public int getWindowStep() {
        return this.windowStep;
    }

    public void setWindowSize(int sizeRequired) {
        this.requiredSampleSetSize = sizeRequired;
    }

    public int getWindowSize() {
        return this.requiredSampleSetSize;
    }

    public boolean isOverlapping() {
        return this.overlapping;
    }

    @Override
    public SampleChunk process(SampleChunk sample) throws Exception {
        return sample;
    }
}

