/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.audio;

import java.util.ArrayList;
import java.util.List;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
import org.openimaj.audio.AudioEventListener;
import org.openimaj.audio.AudioStream;
import org.openimaj.audio.SampleChunk;
import org.openimaj.audio.timecode.AudioTimecode;
import org.openimaj.audio.util.AudioUtils;
import org.openimaj.time.TimeKeeper;
import org.openimaj.time.Timecode;

public class AudioPlayer
implements Runnable,
TimeKeeper<AudioTimecode> {
    private AudioStream stream = null;
    private SourceDataLine mLine = null;
    private AudioTimecode currentTimecode = null;
    private long currentTimestamp = 0L;
    private long timecodeReadAt = 0L;
    private String deviceName = null;
    private Mode mode = Mode.PLAY;
    private final List<AudioEventListener> listeners = new ArrayList<AudioEventListener>();
    private boolean started = false;
    private double soundLineBufferSize = 100.0;

    public AudioPlayer(AudioStream a) {
        this(a, null);
    }

    public AudioPlayer(AudioStream a, String deviceName) {
        this.stream = a;
        this.deviceName = deviceName;
        this.setTimecodeObject(new AudioTimecode(0L));
    }

    public void setSoundLineBufferSize(double ms) {
        this.soundLineBufferSize = ms;
    }

    public void addAudioEventListener(AudioEventListener l) {
        this.listeners.add(l);
    }

    public void removeAudioEventListener(AudioEventListener l) {
        this.listeners.remove(l);
    }

    protected void fireAudioEnded(AudioStream as) {
        for (AudioEventListener ael : this.listeners) {
            ael.audioEnded();
        }
    }

    protected void fireBeforePlay(SampleChunk sc) {
        for (AudioEventListener ael : this.listeners) {
            ael.beforePlay(sc);
        }
    }

    protected void fireAfterPlay(SampleChunk sc) {
        for (AudioEventListener ael : this.listeners) {
            ael.afterPlay(this, sc);
        }
    }

    public void setTimecodeObject(AudioTimecode t) {
        this.currentTimecode = t;
    }

    public Timecode getTimecodeObject() {
        return this.currentTimecode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.setMode(Mode.PLAY);
        this.timecodeReadAt = 0L;
        if (!this.started) {
            this.started = true;
            try {
                this.openJavaSound();
                SampleChunk samples = null;
                boolean ended = false;
                while (!ended && this.mode != Mode.STOP) {
                    if (this.mode == Mode.PLAY) {
                        samples = this.stream.nextSampleChunk();
                        if (samples == null) {
                            ended = true;
                            continue;
                        }
                        this.fireBeforePlay(samples);
                        this.playJavaSound(samples);
                        this.fireAfterPlay(samples);
                        if (this.currentTimecode == null) continue;
                        this.currentTimestamp = samples.getStartTimecode().getTimecodeInMilliseconds();
                        this.timecodeReadAt = System.currentTimeMillis();
                        this.currentTimecode.setTimecodeInMilliseconds(this.currentTimestamp);
                        continue;
                    }
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                this.fireAudioEnded(this.stream);
                this.setMode(Mode.STOP);
                this.reset();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                this.closeJavaSound();
            }
        } else {
            this.setMode(Mode.PLAY);
        }
    }

    public static AudioPlayer createAudioPlayer(AudioStream as) {
        AudioPlayer ap = new AudioPlayer(as);
        new Thread(ap).start();
        return ap;
    }

    public static AudioPlayer createAudioPlayer(AudioStream as, String device) {
        AudioPlayer ap = new AudioPlayer(as, device);
        new Thread(ap).start();
        return ap;
    }

    private void openJavaSound() throws Exception {
        try {
            this.mLine = this.deviceName != null ? AudioUtils.getJavaOutputLine(this.deviceName, this.stream.getFormat()) : AudioUtils.getAnyJavaOutputLine(this.stream.getFormat());
            if (this.mLine == null) {
                throw new Exception("Cannot instantiate a sound line.");
            }
            this.mLine.open(this.mLine.getFormat(), (int)(this.stream.getFormat().getSampleRateKHz() * this.soundLineBufferSize));
            this.mLine.start();
            System.out.println("Opened Java Sound Line: " + this.mLine.getFormat());
        }
        catch (LineUnavailableException e) {
            throw new Exception("Could not open Java Sound audio line for the audio format " + this.stream.getFormat());
        }
    }

    private void playJavaSound(SampleChunk chunk) {
        byte[] rawBytes = chunk.getSamples();
        this.mLine.write(rawBytes, 0, rawBytes.length);
    }

    private void closeJavaSound() {
        if (this.mLine != null) {
            this.mLine.drain();
            this.mLine.close();
            this.mLine = null;
        }
    }

    public AudioTimecode getTime() {
        if (this.timecodeReadAt == 0L) {
            return this.currentTimecode;
        }
        if (this.mode == Mode.PLAY) {
            this.currentTimecode.setTimecodeInMilliseconds(this.currentTimestamp + (System.currentTimeMillis() - this.timecodeReadAt));
        }
        return this.currentTimecode;
    }

    public void stop() {
        this.setMode(Mode.STOP);
    }

    public void setMode(Mode m) {
        this.mode = m;
    }

    public boolean supportsPause() {
        return true;
    }

    public boolean supportsSeek() {
        return true;
    }

    public void seek(long timestamp) {
        this.stream.seek(timestamp);
    }

    public void reset() {
        this.timecodeReadAt = 0L;
        this.currentTimestamp = 0L;
        this.started = false;
        this.currentTimecode.setTimecodeInMilliseconds(0L);
        this.stream.reset();
    }

    public void pause() {
        this.setMode(Mode.PAUSE);
        this.currentTimecode.setTimecodeInMilliseconds(this.currentTimestamp + (System.currentTimeMillis() - this.timecodeReadAt));
    }

    public static enum Mode {
        PLAY,
        PAUSE,
        STOP;

    }
}

