/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl.util.pngj.chunks;

import jogamp.opengl.util.pngj.ImageInfo;
import jogamp.opengl.util.pngj.PngjException;
import jogamp.opengl.util.pngj.chunks.ChunkRaw;
import jogamp.opengl.util.pngj.chunks.PngChunk;
import jogamp.opengl.util.pngj.chunks.PngChunkSingle;

public class PngChunkSTER
extends PngChunkSingle {
    public static final String ID = "sTER";
    private byte mode;

    public PngChunkSTER(ImageInfo imageInfo) {
        super(ID, imageInfo);
    }

    @Override
    public PngChunk.ChunkOrderingConstraint getOrderingConstraint() {
        return PngChunk.ChunkOrderingConstraint.BEFORE_IDAT;
    }

    @Override
    public ChunkRaw createRawChunk() {
        ChunkRaw chunkRaw = this.createEmptyChunk(1, true);
        chunkRaw.data[0] = this.mode;
        return chunkRaw;
    }

    @Override
    public void parseFromRaw(ChunkRaw chunkRaw) {
        if (chunkRaw.len != 1) {
            throw new PngjException("bad chunk length " + chunkRaw);
        }
        this.mode = chunkRaw.data[0];
    }

    @Override
    public void cloneDataFromRead(PngChunk pngChunk) {
        PngChunkSTER pngChunkSTER = (PngChunkSTER)pngChunk;
        this.mode = pngChunkSTER.mode;
    }

    public byte getMode() {
        return this.mode;
    }

    public void setMode(byte by) {
        this.mode = by;
    }
}

