/*
 * Decompiled with CFR 0.152.
 */
package com.flickr4java.flickr.places;

import com.flickr4java.flickr.FlickrException;
import com.flickr4java.flickr.Response;
import com.flickr4java.flickr.Transport;
import com.flickr4java.flickr.photos.SearchParameters;
import com.flickr4java.flickr.places.Location;
import com.flickr4java.flickr.places.Place;
import com.flickr4java.flickr.places.PlaceType;
import com.flickr4java.flickr.places.PlacesList;
import com.flickr4java.flickr.places.ShapeData;
import com.flickr4java.flickr.places.ShapeDataList;
import com.flickr4java.flickr.tags.Tag;
import com.flickr4java.flickr.util.StringUtilities;
import com.flickr4java.flickr.util.XMLUtilities;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class PlacesInterface {
    private static final String METHOD_FIND = "flickr.places.find";
    private static final String METHOD_FIND_BY_LATLON = "flickr.places.findByLatLon";
    private static final String METHOD_RESOLVE_PLACE_ID = "flickr.places.resolvePlaceId";
    private static final String METHOD_RESOLVE_PLACE_URL = "flickr.places.resolvePlaceURL";
    private static final String METHOD_GET_CHILDREN_WITH_PHOTOS_PUBLIC = "flickr.places.getChildrenWithPhotosPublic";
    private static final String METHOD_GET_INFO = "flickr.places.getInfo";
    private static final String METHOD_GET_INFO_BY_URL = "flickr.places.getInfoByUrl";
    private static final String METHOD_GET_PLACETYPES = "flickr.places.getPlaceTypes";
    private static final String METHOD_GET_SHAPEHISTORY = "flickr.places.getShapeHistory";
    private static final String METHOD_GET_TOP_PLACES_LIST = "flickr.places.getTopPlacesList";
    private static final String METHOD_PLACES_FOR_BOUNDINGBOX = "flickr.places.placesForBoundingBox";
    private static final String METHOD_PLACES_FOR_CONTACTS = "flickr.places.placesForContacts";
    private static final String METHOD_PLACES_FOR_TAGS = "flickr.places.placesForTags";
    private static final String METHOD_PLACES_FOR_USER = "flickr.places.placesForUser";
    private static final String METHOD_TAGS_FOR_PLACE = "flickr.places.tagsForPlace";
    private final String apiKey;
    private final String sharedSecret;
    private final Transport transportAPI;

    public PlacesInterface(String apiKey, String sharedSecret, Transport transportAPI) {
        this.apiKey = apiKey;
        this.sharedSecret = sharedSecret;
        this.transportAPI = transportAPI;
    }

    public PlacesList<Place> find(String query) throws FlickrException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        PlacesList<Place> placesList = new PlacesList<Place>();
        parameters.put("method", METHOD_FIND);
        parameters.put("query", query);
        Response response = this.transportAPI.get(this.transportAPI.getPath(), parameters, this.apiKey, this.sharedSecret);
        if (response.isError()) {
            throw new FlickrException(response.getErrorCode(), response.getErrorMessage());
        }
        Element placesElement = response.getPayload();
        NodeList placesNodes = placesElement.getElementsByTagName("place");
        placesList.setPage("1");
        placesList.setPages("1");
        placesList.setPerPage("" + placesNodes.getLength());
        placesList.setTotal("" + placesNodes.getLength());
        for (int i = 0; i < placesNodes.getLength(); ++i) {
            Element placeElement = (Element)placesNodes.item(i);
            placesList.add(this.parsePlace(placeElement));
        }
        return placesList;
    }

    public PlacesList<Place> findByLatLon(double latitude, double longitude, int accuracy) throws FlickrException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        PlacesList<Place> placesList = new PlacesList<Place>();
        parameters.put("method", METHOD_FIND_BY_LATLON);
        parameters.put("lat", "" + Double.toString(latitude));
        parameters.put("lon", "" + Double.toString(longitude));
        parameters.put("accuracy", "" + Integer.toString(accuracy));
        Response response = this.transportAPI.get(this.transportAPI.getPath(), parameters, this.apiKey, this.sharedSecret);
        if (response.isError()) {
            throw new FlickrException(response.getErrorCode(), response.getErrorMessage());
        }
        Element placesElement = response.getPayload();
        NodeList placesNodes = placesElement.getElementsByTagName("place");
        placesList.setPage("1");
        placesList.setPages("1");
        placesList.setPerPage("" + placesNodes.getLength());
        placesList.setTotal("" + placesNodes.getLength());
        for (int i = 0; i < placesNodes.getLength(); ++i) {
            Element placeElement = (Element)placesNodes.item(i);
            placesList.add(this.parsePlace(placeElement));
        }
        return placesList;
    }

    public PlacesList<Place> getChildrenWithPhotosPublic(String placeId, String woeId) throws FlickrException {
        Response response;
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        PlacesList<Place> placesList = new PlacesList<Place>();
        parameters.put("method", METHOD_GET_CHILDREN_WITH_PHOTOS_PUBLIC);
        if (placeId != null) {
            parameters.put("place_id", placeId);
        }
        if (woeId != null) {
            parameters.put("woe_id", woeId);
        }
        if ((response = this.transportAPI.get(this.transportAPI.getPath(), parameters, this.apiKey, this.sharedSecret)).isError()) {
            throw new FlickrException(response.getErrorCode(), response.getErrorMessage());
        }
        Element placesElement = response.getPayload();
        NodeList placesNodes = placesElement.getElementsByTagName("place");
        placesList.setPage("1");
        placesList.setPages("1");
        placesList.setPerPage("" + placesNodes.getLength());
        placesList.setTotal("" + placesNodes.getLength());
        for (int i = 0; i < placesNodes.getLength(); ++i) {
            Element placeElement = (Element)placesNodes.item(i);
            placesList.add(this.parsePlace(placeElement));
        }
        return placesList;
    }

    public Location getInfo(String placeId, String woeId) throws FlickrException {
        Response response;
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("method", METHOD_GET_INFO);
        if (placeId != null) {
            parameters.put("place_id", placeId);
        }
        if (woeId != null) {
            parameters.put("woe_id", woeId);
        }
        if ((response = this.transportAPI.get(this.transportAPI.getPath(), parameters, this.apiKey, this.sharedSecret)).isError()) {
            throw new FlickrException(response.getErrorCode(), response.getErrorMessage());
        }
        Element locationElement = response.getPayload();
        return this.parseLocation(locationElement);
    }

    public Location getInfoByUrl(String url) throws FlickrException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("method", METHOD_GET_INFO_BY_URL);
        parameters.put("url", url);
        Response response = this.transportAPI.get(this.transportAPI.getPath(), parameters, this.apiKey, this.sharedSecret);
        if (response.isError()) {
            throw new FlickrException(response.getErrorCode(), response.getErrorMessage());
        }
        Element locationElement = response.getPayload();
        return this.parseLocation(locationElement);
    }

    public ArrayList<PlaceType> getPlaceTypes() throws FlickrException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("method", METHOD_GET_PLACETYPES);
        Response response = this.transportAPI.get(this.transportAPI.getPath(), parameters, this.apiKey, this.sharedSecret);
        if (response.isError()) {
            throw new FlickrException(response.getErrorCode(), response.getErrorMessage());
        }
        ArrayList<PlaceType> placeTypeList = new ArrayList<PlaceType>();
        Element placeTypeElement = response.getPayload();
        NodeList placeTypeNodes = placeTypeElement.getElementsByTagName("place_type");
        for (int i = 0; i < placeTypeNodes.getLength(); ++i) {
            placeTypeElement = (Element)placeTypeNodes.item(i);
            PlaceType placeType = new PlaceType();
            placeType.setPlaceTypeId(placeTypeElement.getAttribute("id"));
            placeType.setPlaceTypeName(XMLUtilities.getValue(placeTypeElement));
            placeTypeList.add(placeType);
        }
        return placeTypeList;
    }

    public ShapeDataList<ShapeData> getShapeHistory(String placeId, String woeId) throws FlickrException {
        Response response;
        ShapeDataList<ShapeData> shapeList = new ShapeDataList<ShapeData>();
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("method", METHOD_GET_SHAPEHISTORY);
        if (placeId != null) {
            parameters.put("place_id", placeId);
        }
        if (woeId != null) {
            parameters.put("woe_id", woeId);
        }
        if ((response = this.transportAPI.get(this.transportAPI.getPath(), parameters, this.apiKey, this.sharedSecret)).isError()) {
            throw new FlickrException(response.getErrorCode(), response.getErrorMessage());
        }
        Element shapeElements = response.getPayload();
        shapeList.setTotal(Integer.parseInt(shapeElements.getAttribute("total")));
        shapeList.setWoeId(shapeElements.getAttribute("woe_id"));
        shapeList.setPlaceId(shapeElements.getAttribute("place_id"));
        shapeList.setPlaceType(shapeElements.getAttribute("place_type"));
        shapeList.setPlaceTypeId(Integer.parseInt(shapeElements.getAttribute("place_type_id")));
        NodeList shapeNodes = shapeElements.getElementsByTagName("shape");
        for (int i = 0; i < shapeNodes.getLength(); ++i) {
            Element shapeElement = (Element)shapeNodes.item(i);
            ShapeData data = new ShapeData();
            data.setAlpha(Double.parseDouble(shapeElement.getAttribute("alpha")));
            data.setCountEdges(Integer.parseInt(shapeElement.getAttribute("count_edges")));
            data.setCountPoints(Integer.parseInt(shapeElement.getAttribute("count_points")));
            data.setCreated(shapeElement.getAttribute("created"));
            data.setIsDonutHole("1".equals(shapeElement.getAttribute("is_donuthole")));
            data.setHasDonuthole("1".equals(shapeElement.getAttribute("has_donuthole")));
            Element polyElement = XMLUtilities.getChild(shapeElement, "polylines");
            data.setPolyline(XMLUtilities.getChildValue(polyElement, "polyline"));
            Element urlElement = XMLUtilities.getChild(shapeElement, "urls");
            data.setShapefile(XMLUtilities.getChildValue(urlElement, "shapefile"));
            shapeList.add(data);
        }
        return shapeList;
    }

    public PlacesList<Place> getTopPlacesList(int placeType, Date date, String placeId, String woeId) throws FlickrException {
        Response response;
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        PlacesList<Place> placesList = new PlacesList<Place>();
        parameters.put("method", METHOD_GET_TOP_PLACES_LIST);
        parameters.put("place_type", this.intPlaceTypeToString(placeType));
        if (placeId != null) {
            parameters.put("place_id", placeId);
        }
        if (woeId != null) {
            parameters.put("woe_id", woeId);
        }
        if (date != null) {
            parameters.put("date", ((DateFormat)SearchParameters.DATE_FORMATS.get()).format(date));
        }
        if ((response = this.transportAPI.get(this.transportAPI.getPath(), parameters, this.apiKey, this.sharedSecret)).isError()) {
            throw new FlickrException(response.getErrorCode(), response.getErrorMessage());
        }
        Element placesElement = response.getPayload();
        NodeList placesNodes = placesElement.getElementsByTagName("place");
        placesList.setPage("1");
        placesList.setPages("1");
        placesList.setPerPage("" + placesNodes.getLength());
        placesList.setTotal("" + placesNodes.getLength());
        for (int i = 0; i < placesNodes.getLength(); ++i) {
            Element placeElement = (Element)placesNodes.item(i);
            placesList.add(this.parsePlace(placeElement));
        }
        return placesList;
    }

    public PlacesList<Place> placesForBoundingBox(int placeType, String bbox) throws FlickrException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        PlacesList<Place> placesList = new PlacesList<Place>();
        parameters.put("method", METHOD_PLACES_FOR_BOUNDINGBOX);
        parameters.put("place_type", this.intPlaceTypeToString(placeType));
        parameters.put("bbox", bbox);
        Response response = this.transportAPI.get(this.transportAPI.getPath(), parameters, this.apiKey, this.sharedSecret);
        if (response.isError()) {
            throw new FlickrException(response.getErrorCode(), response.getErrorMessage());
        }
        Element placesElement = response.getPayload();
        NodeList placesNodes = placesElement.getElementsByTagName("place");
        placesList.setPage("1");
        placesList.setPages("1");
        placesList.setPerPage("" + placesNodes.getLength());
        placesList.setTotal("" + placesNodes.getLength());
        placesList.setBBox(placesElement.getAttribute("bbox"));
        placesList.setPlaceType(placesElement.getAttribute("place_type"));
        for (int i = 0; i < placesNodes.getLength(); ++i) {
            Element placeElement = (Element)placesNodes.item(i);
            placesList.add(this.parsePlace(placeElement));
        }
        return placesList;
    }

    public PlacesList<Place> placesForContacts(int placeType, String placeId, String woeId, String threshold, String contacts) throws FlickrException {
        Response response;
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        PlacesList<Place> placesList = new PlacesList<Place>();
        parameters.put("method", METHOD_PLACES_FOR_CONTACTS);
        parameters.put("place_type", this.intPlaceTypeToString(placeType));
        if (placeId != null) {
            parameters.put("place_id", placeId);
        }
        if (woeId != null) {
            parameters.put("woe_id", woeId);
        }
        if (threshold != null) {
            parameters.put("threshold", threshold);
        }
        if (contacts != null) {
            parameters.put("contacts", contacts);
        }
        if ((response = this.transportAPI.get(this.transportAPI.getPath(), parameters, this.apiKey, this.sharedSecret)).isError()) {
            throw new FlickrException(response.getErrorCode(), response.getErrorMessage());
        }
        Element placesElement = response.getPayload();
        NodeList placesNodes = placesElement.getElementsByTagName("place");
        placesList.setPage("1");
        placesList.setPages("1");
        placesList.setPerPage("" + placesNodes.getLength());
        placesList.setTotal("" + placesNodes.getLength());
        for (int i = 0; i < placesNodes.getLength(); ++i) {
            Element placeElement = (Element)placesNodes.item(i);
            placesList.add(this.parsePlace(placeElement));
        }
        return placesList;
    }

    public PlacesList<Place> placesForTags(int placeTypeId, String woeId, String placeId, String threshold, String[] tags, String tagMode, String machineTags, String machineTagMode, Date minUploadDate, Date maxUploadDate, Date minTakenDate, Date maxTakenDate) throws FlickrException {
        Response response;
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        PlacesList<Place> placesList = new PlacesList<Place>();
        parameters.put("method", METHOD_PLACES_FOR_TAGS);
        parameters.put("place_type_id", Integer.toString(placeTypeId));
        if (woeId != null) {
            parameters.put("woe_id", woeId);
        }
        if (placeId != null) {
            parameters.put("place_id", placeId);
        }
        if (threshold != null) {
            parameters.put("threshold", threshold);
        }
        if (tags != null) {
            parameters.put("tags", StringUtilities.join(tags, ","));
        }
        if (tagMode != null) {
            parameters.put("tag_mode", tagMode);
        }
        if (machineTags != null) {
            parameters.put("machine_tags", machineTags);
        }
        if (machineTagMode != null) {
            parameters.put("machine_tag_mode", machineTagMode);
        }
        if (minUploadDate != null) {
            parameters.put("min_upload_date", Long.toString(minUploadDate.getTime() / 1000L));
        }
        if (maxUploadDate != null) {
            parameters.put("max_upload_date", Long.toString(maxUploadDate.getTime() / 1000L));
        }
        if (minTakenDate != null) {
            parameters.put("min_taken_date", ((DateFormat)SearchParameters.MYSQL_DATE_FORMATS.get()).format(minTakenDate));
        }
        if (maxTakenDate != null) {
            parameters.put("max_taken_date", ((DateFormat)SearchParameters.MYSQL_DATE_FORMATS.get()).format(maxTakenDate));
        }
        if ((response = this.transportAPI.get(this.transportAPI.getPath(), parameters, this.apiKey, this.sharedSecret)).isError()) {
            throw new FlickrException(response.getErrorCode(), response.getErrorMessage());
        }
        Element placesElement = response.getPayload();
        NodeList placesNodes = placesElement.getElementsByTagName("place");
        placesList.setPage("1");
        placesList.setPages("1");
        placesList.setPerPage("" + placesNodes.getLength());
        placesList.setTotal("" + placesNodes.getLength());
        for (int i = 0; i < placesNodes.getLength(); ++i) {
            Element placeElement = (Element)placesNodes.item(i);
            placesList.add(this.parsePlace(placeElement));
        }
        return placesList;
    }

    public PlacesList<Place> placesForUser(int placeType, String woeId, String placeId, String threshold, Date minUploadDate, Date maxUploadDate, Date minTakenDate, Date maxTakenDate) throws FlickrException {
        Response response;
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        PlacesList<Place> placesList = new PlacesList<Place>();
        parameters.put("method", METHOD_PLACES_FOR_USER);
        parameters.put("place_type", this.intPlaceTypeToString(placeType));
        if (placeId != null) {
            parameters.put("place_id", placeId);
        }
        if (woeId != null) {
            parameters.put("woe_id", woeId);
        }
        if (threshold != null) {
            parameters.put("threshold", threshold);
        }
        if (minUploadDate != null) {
            parameters.put("min_upload_date", Long.toString(minUploadDate.getTime() / 1000L));
        }
        if (maxUploadDate != null) {
            parameters.put("max_upload_date", Long.toString(maxUploadDate.getTime() / 1000L));
        }
        if (minTakenDate != null) {
            parameters.put("min_taken_date", ((DateFormat)SearchParameters.MYSQL_DATE_FORMATS.get()).format(minTakenDate));
        }
        if (maxTakenDate != null) {
            parameters.put("max_taken_date", ((DateFormat)SearchParameters.MYSQL_DATE_FORMATS.get()).format(maxTakenDate));
        }
        if ((response = this.transportAPI.get(this.transportAPI.getPath(), parameters, this.apiKey, this.sharedSecret)).isError()) {
            throw new FlickrException(response.getErrorCode(), response.getErrorMessage());
        }
        Element placesElement = response.getPayload();
        NodeList placesNodes = placesElement.getElementsByTagName("place");
        placesList.setPage("1");
        placesList.setPages("1");
        placesList.setPerPage("" + placesNodes.getLength());
        placesList.setTotal("" + placesNodes.getLength());
        for (int i = 0; i < placesNodes.getLength(); ++i) {
            Element placeElement = (Element)placesNodes.item(i);
            placesList.add(this.parsePlace(placeElement));
        }
        return placesList;
    }

    @Deprecated
    public Location resolvePlaceId(String placeId) throws FlickrException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("method", METHOD_RESOLVE_PLACE_ID);
        parameters.put("place_id", placeId);
        Response response = this.transportAPI.get(this.transportAPI.getPath(), parameters, this.apiKey, this.sharedSecret);
        if (response.isError()) {
            throw new FlickrException(response.getErrorCode(), response.getErrorMessage());
        }
        Element locationElement = response.getPayload();
        return this.parseLocation(locationElement);
    }

    @Deprecated
    public Location resolvePlaceURL(String flickrPlacesUrl) throws FlickrException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("method", METHOD_RESOLVE_PLACE_URL);
        parameters.put("url", flickrPlacesUrl);
        Response response = this.transportAPI.get(this.transportAPI.getPath(), parameters, this.apiKey, this.sharedSecret);
        if (response.isError()) {
            throw new FlickrException(response.getErrorCode(), response.getErrorMessage());
        }
        Element locationElement = response.getPayload();
        return this.parseLocation(locationElement);
    }

    public ArrayList<Tag> tagsForPlace(String woeId, String placeId, Date minUploadDate, Date maxUploadDate, Date minTakenDate, Date maxTakenDate) throws FlickrException {
        Response response;
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        ArrayList<Tag> tagsList = new ArrayList<Tag>();
        parameters.put("method", METHOD_TAGS_FOR_PLACE);
        if (woeId != null) {
            parameters.put("woe_id", woeId);
        }
        if (placeId != null) {
            parameters.put("place_id", placeId);
        }
        if (minUploadDate != null) {
            parameters.put("min_upload_date", Long.toString(minUploadDate.getTime() / 1000L));
        }
        if (maxUploadDate != null) {
            parameters.put("max_upload_date", Long.toString(maxUploadDate.getTime() / 1000L));
        }
        if (minTakenDate != null) {
            parameters.put("min_taken_date", ((DateFormat)SearchParameters.MYSQL_DATE_FORMATS.get()).format(minTakenDate));
        }
        if (maxTakenDate != null) {
            parameters.put("max_taken_date", ((DateFormat)SearchParameters.MYSQL_DATE_FORMATS.get()).format(maxTakenDate));
        }
        if ((response = this.transportAPI.get(this.transportAPI.getPath(), parameters, this.apiKey, this.sharedSecret)).isError()) {
            throw new FlickrException(response.getErrorCode(), response.getErrorMessage());
        }
        Element tagsElement = response.getPayload();
        NodeList tagsNodes = tagsElement.getElementsByTagName("tag");
        for (int i = 0; i < tagsNodes.getLength(); ++i) {
            Element tagElement = (Element)tagsNodes.item(i);
            Tag tag = new Tag();
            tag.setCount(tagElement.getAttribute("count"));
            tag.setValue(XMLUtilities.getValue(tagElement));
            tagsList.add(tag);
        }
        return tagsList;
    }

    private Location parseLocation(Element locationElement) {
        Location location = new Location();
        Element localityElement = (Element)locationElement.getElementsByTagName("locality").item(0);
        Element countyElement = (Element)locationElement.getElementsByTagName("county").item(0);
        Element regionElement = (Element)locationElement.getElementsByTagName("region").item(0);
        Element countryElement = (Element)locationElement.getElementsByTagName("country").item(0);
        location.setPlaceId(locationElement.getAttribute("place_id"));
        location.setPlaceUrl(locationElement.getAttribute("place_url"));
        location.setWoeId(locationElement.getAttribute("woeid"));
        location.setLatitude(locationElement.getAttribute("latitude"));
        location.setLongitude(locationElement.getAttribute("longitude"));
        location.setTimezone(locationElement.getAttribute("timezone"));
        location.setName(locationElement.getAttribute("name"));
        location.setWoeName(locationElement.getAttribute("woe_name"));
        location.setIsHasShapeData("1".equals(locationElement.getAttribute("has_shapedata")));
        location.setPlaceType(this.stringPlaceTypeToInt(locationElement.getAttribute("place_type")));
        try {
            location.setLocality(this.parseLocationPlace(localityElement, 7));
        }
        catch (NullPointerException ex) {
            // empty catch block
        }
        try {
            location.setCounty(this.parseLocationPlace(countyElement, 9));
        }
        catch (NullPointerException ex) {
            // empty catch block
        }
        location.setRegion(this.parseLocationPlace(regionElement, 8));
        location.setCountry(this.parseLocationPlace(countryElement, 12));
        return location;
    }

    private Place parseLocationPlace(Element element, int type) {
        Place place = new Place();
        place.setName(XMLUtilities.getValue(element));
        place.setPlaceId(element.getAttribute("place_id"));
        place.setPlaceUrl(element.getAttribute("place_url"));
        place.setWoeId(element.getAttribute("woeid"));
        place.setLatitude(element.getAttribute("latitude"));
        place.setLongitude(element.getAttribute("longitude"));
        place.setPlaceType(type);
        return place;
    }

    private Place parsePlace(Element placeElement) {
        Place place = new Place();
        place.setPlaceId(placeElement.getAttribute("place_id"));
        place.setPlaceUrl(placeElement.getAttribute("place_url"));
        place.setWoeId(placeElement.getAttribute("woeid"));
        place.setLatitude(placeElement.getAttribute("latitude"));
        place.setLongitude(placeElement.getAttribute("longitude"));
        place.setPhotoCount(placeElement.getAttribute("photo_count"));
        place.setPlaceType(placeElement.getAttribute("place_type_id"));
        place.setName(XMLUtilities.getValue(placeElement));
        return place;
    }

    private int stringPlaceTypeToInt(String typeString) {
        int placeType = 0;
        if (typeString.equals("locality")) {
            placeType = 7;
        } else if (typeString.equals("county")) {
            placeType = 9;
        } else if (typeString.equals("region")) {
            placeType = 8;
        } else if (typeString.equals("country")) {
            placeType = 12;
        } else if (typeString.equals("continent")) {
            placeType = 29;
        } else if (typeString.equals("neighbourhood")) {
            placeType = 22;
        }
        return placeType;
    }

    public String intPlaceTypeToString(int placeType) throws FlickrException {
        String placeTypeStr = "";
        if (placeType == 12) {
            placeTypeStr = "country";
        } else if (placeType == 8) {
            placeTypeStr = "region";
        } else if (placeType == 7) {
            placeTypeStr = "locality";
        } else if (placeType == 29) {
            placeTypeStr = "continent";
        } else if (placeType == 22) {
            placeTypeStr = "neighbourhood";
        } else {
            throw new FlickrException("33", "Not a valid place type");
        }
        return placeTypeStr;
    }
}

