/*
 * Decompiled with CFR 0.152.
 */
package com.flickr4java.flickr.photos.licenses;

import com.flickr4java.flickr.FlickrException;
import com.flickr4java.flickr.Response;
import com.flickr4java.flickr.Transport;
import com.flickr4java.flickr.photos.licenses.License;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class LicensesInterface {
    public static final String METHOD_GET_INFO = "flickr.photos.licenses.getInfo";
    public static final String METHOD_SET_LICENSE = "flickr.photos.licenses.setLicense";
    private String apiKey;
    private String sharedSecret;
    private Transport transportAPI;

    public LicensesInterface(String apiKey, String sharedSecret, Transport transportAPI) {
        this.apiKey = apiKey;
        this.sharedSecret = sharedSecret;
        this.transportAPI = transportAPI;
    }

    public Collection<License> getInfo() throws FlickrException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("method", METHOD_GET_INFO);
        Response response = this.transportAPI.get(this.transportAPI.getPath(), parameters, this.apiKey, this.sharedSecret);
        if (response.isError()) {
            throw new FlickrException(response.getErrorCode(), response.getErrorMessage());
        }
        ArrayList<License> licenses = new ArrayList<License>();
        Element licensesElement = response.getPayload();
        NodeList licenseElements = licensesElement.getElementsByTagName("license");
        for (int i = 0; i < licenseElements.getLength(); ++i) {
            Element licenseElement = (Element)licenseElements.item(i);
            License license = new License();
            license.setId(licenseElement.getAttribute("id"));
            license.setName(licenseElement.getAttribute("name"));
            license.setUrl(licenseElement.getAttribute("url"));
            licenses.add(license);
        }
        return licenses;
    }

    public void setLicense(String photoId, int licenseId) throws FlickrException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("method", METHOD_SET_LICENSE);
        parameters.put("photo_id", photoId);
        parameters.put("license_id", Integer.toString(licenseId));
        Response response = this.transportAPI.post(this.transportAPI.getPath(), parameters, this.apiKey, this.sharedSecret);
        if (response.isError()) {
            throw new FlickrException(response.getErrorCode(), response.getErrorMessage());
        }
    }
}

