/*
 * Decompiled with CFR 0.152.
 */
package com.flickr4java.flickr.photos;

import com.flickr4java.flickr.people.User;
import com.flickr4java.flickr.photos.Editability;
import com.flickr4java.flickr.photos.GeoData;
import com.flickr4java.flickr.photos.Note;
import com.flickr4java.flickr.photos.Permissions;
import com.flickr4java.flickr.photos.Photo;
import com.flickr4java.flickr.photos.PhotoList;
import com.flickr4java.flickr.photos.PhotoUrl;
import com.flickr4java.flickr.photos.Size;
import com.flickr4java.flickr.photos.Usage;
import com.flickr4java.flickr.places.Place;
import com.flickr4java.flickr.tags.Tag;
import com.flickr4java.flickr.util.XMLUtilities;
import java.util.ArrayList;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public final class PhotoUtils {
    private PhotoUtils() {
    }

    private static String getAttribute(String name, Element firstElement, Element secondElement) {
        String val = firstElement.getAttribute(name);
        if (val.length() == 0 && secondElement != null) {
            val = secondElement.getAttribute(name);
        }
        return val;
    }

    public static final Photo createPhoto(Element photoElement) {
        return PhotoUtils.createPhoto(photoElement, null);
    }

    public static final Photo createPhoto(Element photoElement, Element defaultElement) {
        Place place;
        User owner;
        Size sizeT;
        Photo photo = new Photo();
        photo.setId(photoElement.getAttribute("id"));
        photo.setPlaceId(photoElement.getAttribute("place_id"));
        photo.setSecret(photoElement.getAttribute("secret"));
        photo.setServer(photoElement.getAttribute("server"));
        photo.setFarm(photoElement.getAttribute("farm"));
        photo.setRotation(photoElement.getAttribute("rotation"));
        photo.setFavorite("1".equals(photoElement.getAttribute("isfavorite")));
        photo.setLicense(photoElement.getAttribute("license"));
        photo.setOriginalFormat(photoElement.getAttribute("originalformat"));
        photo.setOriginalSecret(photoElement.getAttribute("originalsecret"));
        photo.setIconServer(photoElement.getAttribute("iconserver"));
        photo.setIconFarm(photoElement.getAttribute("iconfarm"));
        photo.setDateTaken(photoElement.getAttribute("datetaken"));
        photo.setDatePosted(photoElement.getAttribute("dateupload"));
        photo.setLastUpdate(photoElement.getAttribute("lastupdate"));
        photo.setDateAdded(photoElement.getAttribute("dateadded"));
        photo.setOriginalWidth(photoElement.getAttribute("o_width"));
        photo.setOriginalHeight(photoElement.getAttribute("o_height"));
        photo.setMedia(photoElement.getAttribute("media"));
        photo.setMediaStatus(photoElement.getAttribute("media_status"));
        photo.setPathAlias(photoElement.getAttribute("pathalias"));
        photo.setViews(photoElement.getAttribute("views"));
        Element peopleElement = (Element)photoElement.getElementsByTagName("people").item(0);
        if (peopleElement != null) {
            photo.setIsHasPeople("1".equals(peopleElement.getAttribute("haspeople")));
        } else {
            photo.setIsHasPeople(false);
        }
        ArrayList<Size> sizes = new ArrayList<Size>();
        String urlTmp = photoElement.getAttribute("url_t");
        if (urlTmp != null && urlTmp.startsWith("http")) {
            sizeT = new Size();
            sizeT.setLabel(0);
            sizeT.setSource(urlTmp);
            sizes.add(sizeT);
        }
        if ((urlTmp = photoElement.getAttribute("url_s")) != null && urlTmp.startsWith("http")) {
            sizeT = new Size();
            sizeT.setLabel(2);
            sizeT.setSource(urlTmp);
            sizes.add(sizeT);
        }
        if ((urlTmp = photoElement.getAttribute("url_sq")) != null && urlTmp.startsWith("http")) {
            sizeT = new Size();
            sizeT.setLabel(1);
            sizeT.setSource(urlTmp);
            sizes.add(sizeT);
        }
        if ((urlTmp = photoElement.getAttribute("url_m")) != null && urlTmp.startsWith("http")) {
            sizeT = new Size();
            sizeT.setLabel(3);
            sizeT.setSource(urlTmp);
            sizes.add(sizeT);
        }
        if ((urlTmp = photoElement.getAttribute("url_l")) != null && urlTmp.startsWith("http")) {
            sizeT = new Size();
            sizeT.setLabel(4);
            sizeT.setSource(urlTmp);
            sizes.add(sizeT);
        }
        if ((urlTmp = photoElement.getAttribute("url_o")) != null && urlTmp.startsWith("http")) {
            sizeT = new Size();
            sizeT.setLabel(5);
            sizeT.setSource(urlTmp);
            sizes.add(sizeT);
        }
        if ((urlTmp = photoElement.getAttribute("url_q")) != null && urlTmp.startsWith("http")) {
            sizeT = new Size();
            sizeT.setLabel(6);
            sizeT.setSource(urlTmp);
            sizes.add(sizeT);
        }
        if ((urlTmp = photoElement.getAttribute("url_n")) != null && urlTmp.startsWith("http")) {
            sizeT = new Size();
            sizeT.setLabel(7);
            sizeT.setSource(urlTmp);
            sizes.add(sizeT);
        }
        if ((urlTmp = photoElement.getAttribute("url_z")) != null && urlTmp.startsWith("http")) {
            sizeT = new Size();
            sizeT.setLabel(8);
            sizeT.setSource(urlTmp);
            sizes.add(sizeT);
        }
        if ((urlTmp = photoElement.getAttribute("url_c")) != null && urlTmp.startsWith("http")) {
            sizeT = new Size();
            sizeT.setLabel(9);
            sizeT.setSource(urlTmp);
            sizes.add(sizeT);
        }
        if (sizes.size() > 0) {
            photo.setSizes(sizes);
        }
        try {
            if (photo.getOriginalFormat() == null || photo.getOriginalFormat().equals("")) {
                String media = photo.getMedia();
                if (media != null && media.equals("video")) {
                    photo.setOriginalFormat("mov");
                } else {
                    photo.setOriginalFormat("jpg");
                }
            }
        }
        catch (NullPointerException e) {
            photo.setOriginalFormat("jpg");
        }
        try {
            Element ownerElement = (Element)photoElement.getElementsByTagName("owner").item(0);
            if (ownerElement == null) {
                owner = new User();
                owner.setId(PhotoUtils.getAttribute("owner", photoElement, defaultElement));
                owner.setUsername(PhotoUtils.getAttribute("ownername", photoElement, defaultElement));
                photo.setOwner(owner);
                photo.setUrl("https://flickr.com/photos/" + owner.getId() + "/" + photo.getId());
            } else {
                owner = new User();
                owner.setId(ownerElement.getAttribute("nsid"));
                String username = ownerElement.getAttribute("username");
                String ownername = ownerElement.getAttribute("ownername");
                if (username != null && !"".equals(username)) {
                    owner.setUsername(username);
                } else if (ownername != null && !"".equals(ownername)) {
                    owner.setUsername(ownername);
                }
                owner.setUsername(ownerElement.getAttribute("username"));
                owner.setRealName(ownerElement.getAttribute("realname"));
                owner.setLocation(ownerElement.getAttribute("location"));
                photo.setOwner(owner);
                photo.setUrl("https://flickr.com/photos/" + owner.getId() + "/" + photo.getId());
            }
        }
        catch (IndexOutOfBoundsException e) {
            owner = new User();
            owner.setId(photoElement.getAttribute("owner"));
            owner.setUsername(photoElement.getAttribute("ownername"));
            photo.setOwner(owner);
            photo.setUrl("https://flickr.com/photos/" + owner.getId() + "/" + photo.getId());
        }
        try {
            photo.setTitle(XMLUtilities.getChildValue(photoElement, "title"));
            if (photo.getTitle() == null) {
                photo.setTitle(photoElement.getAttribute("title"));
            }
        }
        catch (IndexOutOfBoundsException e) {
            photo.setTitle(photoElement.getAttribute("title"));
        }
        try {
            photo.setDescription(XMLUtilities.getChildValue(photoElement, "description"));
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            Element visibilityElement = (Element)photoElement.getElementsByTagName("visibility").item(0);
            photo.setPublicFlag("1".equals(visibilityElement.getAttribute("ispublic")));
            photo.setFriendFlag("1".equals(visibilityElement.getAttribute("isfriend")));
            photo.setFamilyFlag("1".equals(visibilityElement.getAttribute("isfamily")));
        }
        catch (IndexOutOfBoundsException e) {
        }
        catch (NullPointerException e) {
            photo.setPublicFlag("1".equals(photoElement.getAttribute("ispublic")));
            photo.setFriendFlag("1".equals(photoElement.getAttribute("isfriend")));
            photo.setFamilyFlag("1".equals(photoElement.getAttribute("isfamily")));
        }
        try {
            Element datesElement = XMLUtilities.getChild(photoElement, "dates");
            photo.setDatePosted(datesElement.getAttribute("posted"));
            photo.setDateTaken(datesElement.getAttribute("taken"));
            photo.setTakenGranularity(datesElement.getAttribute("takengranularity"));
            photo.setLastUpdate(datesElement.getAttribute("lastupdate"));
        }
        catch (IndexOutOfBoundsException e) {
            photo.setDateTaken(photoElement.getAttribute("datetaken"));
        }
        catch (NullPointerException e) {
            photo.setDateTaken(photoElement.getAttribute("datetaken"));
        }
        try {
            Element permissionsElement = (Element)photoElement.getElementsByTagName("permissions").item(0);
            Permissions permissions = new Permissions();
            permissions.setComment(permissionsElement.getAttribute("permcomment"));
            permissions.setAddmeta(permissionsElement.getAttribute("permaddmeta"));
            photo.setPermissions(permissions);
        }
        catch (IndexOutOfBoundsException e) {
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            Element editabilityElement = (Element)photoElement.getElementsByTagName("editability").item(0);
            Editability editability = new Editability();
            editability.setComment("1".equals(editabilityElement.getAttribute("cancomment")));
            editability.setAddmeta("1".equals(editabilityElement.getAttribute("canaddmeta")));
            photo.setEditability(editability);
        }
        catch (IndexOutOfBoundsException e) {
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            Element publicEditabilityElement = (Element)photoElement.getElementsByTagName("publiceditability").item(0);
            Editability publicEditability = new Editability();
            publicEditability.setComment("1".equals(publicEditabilityElement.getAttribute("cancomment")));
            publicEditability.setAddmeta("1".equals(publicEditabilityElement.getAttribute("canaddmeta")));
            photo.setPublicEditability(publicEditability);
        }
        catch (IndexOutOfBoundsException e) {
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            Element usageElement = (Element)photoElement.getElementsByTagName("usage").item(0);
            Usage usage = new Usage();
            usage.setIsCanBlog("1".equals(usageElement.getAttribute("canblog")));
            usage.setIsCanDownload("1".equals(usageElement.getAttribute("candownload")));
            usage.setIsCanShare("1".equals(usageElement.getAttribute("canshare")));
            usage.setIsCanPrint("1".equals(usageElement.getAttribute("canprint")));
            photo.setUsage(usage);
        }
        catch (IndexOutOfBoundsException e) {
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            Element commentsElement = (Element)photoElement.getElementsByTagName("comments").item(0);
            photo.setComments(((Text)commentsElement.getFirstChild()).getData());
        }
        catch (IndexOutOfBoundsException e) {
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            Element notesElement = (Element)photoElement.getElementsByTagName("notes").item(0);
            ArrayList<Note> notes = new ArrayList<Note>();
            NodeList noteNodes = notesElement.getElementsByTagName("note");
            for (int i = 0; i < noteNodes.getLength(); ++i) {
                Element noteElement = (Element)noteNodes.item(i);
                Note note = new Note();
                note.setId(noteElement.getAttribute("id"));
                note.setAuthor(noteElement.getAttribute("author"));
                note.setAuthorName(noteElement.getAttribute("authorname"));
                note.setBounds(noteElement.getAttribute("x"), noteElement.getAttribute("y"), noteElement.getAttribute("w"), noteElement.getAttribute("h"));
                note.setText(noteElement.getTextContent());
                notes.add(note);
            }
            photo.setNotes(notes);
        }
        catch (IndexOutOfBoundsException e) {
            photo.setNotes(new ArrayList<Note>());
        }
        catch (NullPointerException e) {
            photo.setNotes(new ArrayList<Note>());
        }
        try {
            ArrayList<Tag> tags = new ArrayList<Tag>();
            String tagsAttr = photoElement.getAttribute("tags");
            if (!tagsAttr.equals("")) {
                String[] values = tagsAttr.split("\\s+");
                for (int i = 0; i < values.length; ++i) {
                    Tag tag = new Tag();
                    tag.setValue(values[i]);
                    tags.add(tag);
                }
            } else {
                try {
                    Element tagsElement = (Element)photoElement.getElementsByTagName("tags").item(0);
                    NodeList tagNodes = tagsElement.getElementsByTagName("tag");
                    for (int i = 0; i < tagNodes.getLength(); ++i) {
                        Element tagElement = (Element)tagNodes.item(i);
                        Tag tag = new Tag();
                        tag.setId(tagElement.getAttribute("id"));
                        tag.setAuthor(tagElement.getAttribute("author"));
                        tag.setRaw(tagElement.getAttribute("raw"));
                        tag.setValue(((Text)tagElement.getFirstChild()).getData());
                        tags.add(tag);
                    }
                }
                catch (IndexOutOfBoundsException e) {
                    // empty catch block
                }
            }
            photo.setTags(tags);
        }
        catch (NullPointerException e) {
            photo.setTags(new ArrayList<Tag>());
        }
        try {
            Element urlsElement = (Element)photoElement.getElementsByTagName("urls").item(0);
            ArrayList<String> urls = new ArrayList<String>();
            NodeList urlNodes = urlsElement.getElementsByTagName("url");
            for (int i = 0; i < urlNodes.getLength(); ++i) {
                Element urlElement = (Element)urlNodes.item(i);
                PhotoUrl photoUrl = new PhotoUrl();
                photo.setPhotoUrl(photoUrl);
                photoUrl.setType(urlElement.getAttribute("type"));
                photoUrl.setUrl(XMLUtilities.getValue(urlElement));
                if (!photoUrl.getType().equals("photopage")) continue;
                photo.setUrl(photoUrl.getUrl());
                urls.add(photoUrl.getUrl());
            }
            photo.setUrls(urls);
        }
        catch (IndexOutOfBoundsException e) {
        }
        catch (NullPointerException e) {
            photo.setUrls(new ArrayList<String>());
        }
        String longitude = null;
        String latitude = null;
        String accuracy = null;
        try {
            Element geoElement = (Element)photoElement.getElementsByTagName("location").item(0);
            longitude = geoElement.getAttribute("longitude");
            latitude = geoElement.getAttribute("latitude");
            accuracy = geoElement.getAttribute("accuracy");
        }
        catch (IndexOutOfBoundsException e) {
        }
        catch (NullPointerException e) {
            try {
                longitude = photoElement.getAttribute("longitude");
                latitude = photoElement.getAttribute("latitude");
                accuracy = photoElement.getAttribute("accuracy");
            }
            catch (NullPointerException e2) {
                // empty catch block
            }
        }
        if (!(longitude == null || latitude == null || longitude.length() <= 0 || latitude.length() <= 0 || "0".equals(longitude) && "0".equals(latitude))) {
            photo.setGeoData(new GeoData(longitude, latitude, accuracy));
        }
        try {
            place = null;
            Element element = (Element)photoElement.getElementsByTagName("locality").item(0);
            place = new Place(element.getAttribute("place_id"), element.getTextContent(), element.getAttribute("woeid"));
            photo.setLocality(place);
        }
        catch (IndexOutOfBoundsException e) {
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            place = null;
            Element element = (Element)photoElement.getElementsByTagName("county").item(0);
            place = new Place(element.getAttribute("place_id"), element.getTextContent(), element.getAttribute("woeid"));
            photo.setCounty(place);
        }
        catch (IndexOutOfBoundsException e) {
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            place = null;
            Element element = (Element)photoElement.getElementsByTagName("region").item(0);
            place = new Place(element.getAttribute("place_id"), element.getTextContent(), element.getAttribute("woeid"));
            photo.setRegion(place);
        }
        catch (IndexOutOfBoundsException e) {
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            place = null;
            Element element = (Element)photoElement.getElementsByTagName("country").item(0);
            place = new Place(element.getAttribute("place_id"), element.getTextContent(), element.getAttribute("woeid"));
            photo.setCountry(place);
        }
        catch (IndexOutOfBoundsException e) {
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        return photo;
    }

    public static final PhotoList<Photo> createPhotoList(Element photosElement) {
        PhotoList<Photo> photos = new PhotoList<Photo>();
        photos.setPage(photosElement.getAttribute("page"));
        photos.setPages(photosElement.getAttribute("pages"));
        photos.setPerPage(photosElement.getAttribute("perpage"));
        photos.setTotal(photosElement.getAttribute("total"));
        NodeList photoNodes = photosElement.getElementsByTagName("photo");
        for (int i = 0; i < photoNodes.getLength(); ++i) {
            Element photoElement = (Element)photoNodes.item(i);
            photos.add(PhotoUtils.createPhoto(photoElement));
        }
        return photos;
    }
}

