/*
 * Decompiled with CFR 0.152.
 */
package com.flickr4java.flickr.groups.members;

import com.flickr4java.flickr.FlickrException;
import com.flickr4java.flickr.Response;
import com.flickr4java.flickr.Transport;
import com.flickr4java.flickr.groups.members.Member;
import com.flickr4java.flickr.groups.members.MembersList;
import com.flickr4java.flickr.util.StringUtilities;
import java.util.HashMap;
import java.util.Set;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class MembersInterface {
    public static final String METHOD_GET_LIST = "flickr.groups.members.getList";
    private String apiKey;
    private String sharedSecret;
    private Transport transportAPI;

    public MembersInterface(String apiKey, String sharedSecret, Transport transportAPI) {
        this.apiKey = apiKey;
        this.sharedSecret = sharedSecret;
        this.transportAPI = transportAPI;
    }

    public MembersList<Member> getList(String groupId, Set<String> memberTypes, int perPage, int page) throws FlickrException {
        Response response;
        MembersList<Member> members = new MembersList<Member>();
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("method", METHOD_GET_LIST);
        parameters.put("group_id", groupId);
        if (perPage > 0) {
            parameters.put("per_page", "" + perPage);
        }
        if (page > 0) {
            parameters.put("page", "" + page);
        }
        if (memberTypes != null) {
            parameters.put("membertypes", StringUtilities.join(memberTypes, ","));
        }
        if ((response = this.transportAPI.get(this.transportAPI.getPath(), parameters, this.apiKey, this.sharedSecret)).isError()) {
            throw new FlickrException(response.getErrorCode(), response.getErrorMessage());
        }
        Element mElement = response.getPayload();
        members.setPage(mElement.getAttribute("page"));
        members.setPages(mElement.getAttribute("pages"));
        members.setPerPage(mElement.getAttribute("perpage"));
        members.setTotal(mElement.getAttribute("total"));
        NodeList mNodes = mElement.getElementsByTagName("member");
        for (int i = 0; i < mNodes.getLength(); ++i) {
            Element element = (Element)mNodes.item(i);
            members.add(this.parseMember(element));
        }
        return members;
    }

    private Member parseMember(Element mElement) {
        Member member = new Member();
        member.setId(mElement.getAttribute("nsid"));
        member.setUserName(mElement.getAttribute("username"));
        member.setIconServer(mElement.getAttribute("iconserver"));
        member.setIconFarm(mElement.getAttribute("iconfarm"));
        member.setMemberType(mElement.getAttribute("membertype"));
        return member;
    }
}

