/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.extensions.table;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.google.gson.internal.LinkedTreeMap;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.nlogo.agent.Agent;
import org.nlogo.agent.AgentIterator;
import org.nlogo.agent.AgentSet;
import org.nlogo.agent.AgentSetBuilder;
import org.nlogo.api.AnonymousReporter;
import org.nlogo.api.Argument;
import org.nlogo.api.Command;
import org.nlogo.api.Context;
import org.nlogo.api.DefaultClassManager;
import org.nlogo.api.Dump;
import org.nlogo.api.Equality;
import org.nlogo.api.ExtensionException;
import org.nlogo.api.ExtensionManager;
import org.nlogo.api.ImportErrorHandler;
import org.nlogo.api.LogoException;
import org.nlogo.api.LogoListBuilder;
import org.nlogo.api.PrimitiveManager;
import org.nlogo.core.CompilerException;
import org.nlogo.core.ExtensionObject;
import org.nlogo.core.LogoList;
import org.nlogo.core.Primitive;
import org.nlogo.core.Syntax;
import org.nlogo.core.SyntaxJ;
import org.nlogo.nvm.ExtensionContext;
import org.nlogo.nvm.FileManager;
import org.nlogo.nvm.Reporter;

public class TableExtension
extends DefaultClassManager {
    private static WeakHashMap<Table, Long> tables = new WeakHashMap();
    private static long next = 0L;

    public void load(PrimitiveManager primManager) {
        primManager.addPrimitive("clear", (Primitive)new Clear());
        primManager.addPrimitive("get", (Primitive)new Get());
        primManager.addPrimitive("get-or-default", (Primitive)new GetOrDefault());
        primManager.addPrimitive("has-key?", (Primitive)new HasKey());
        primManager.addPrimitive("keys", (Primitive)new Keys());
        primManager.addPrimitive("length", (Primitive)new Length());
        primManager.addPrimitive("make", (Primitive)new Make());
        primManager.addPrimitive("put", (Primitive)new Put());
        primManager.addPrimitive("remove", (Primitive)new Remove());
        primManager.addPrimitive("from-list", (Primitive)new FromList());
        primManager.addPrimitive("counts", (Primitive)new Counts());
        primManager.addPrimitive("to-list", (Primitive)new ToList());
        primManager.addPrimitive("values", (Primitive)new Values());
        primManager.addPrimitive("group-items", (Primitive)new GroupItems());
        primManager.addPrimitive("group-agents", (Primitive)new GroupAgents());
        primManager.addPrimitive("from-json-file", (Primitive)new FromJSONFile());
    }

    public void clearAll() {
        tables.clear();
        next = 0L;
    }

    public StringBuilder exportWorld() {
        StringBuilder buffer = new StringBuilder();
        for (Table table : tables.keySet()) {
            buffer.append(Dump.csv().encode(Dump.extensionObject((ExtensionObject)table, (boolean)true, (boolean)true, (boolean)false)) + "\n");
        }
        return buffer;
    }

    public void importWorld(List<String[]> lines, ExtensionManager reader, ImportErrorHandler handler) throws ExtensionException {
        for (String[] line : lines) {
            try {
                reader.readFromString(line[0]);
            }
            catch (CompilerException e) {
                handler.showError("Error importing arrays", e.getMessage(), "This array will be ignored");
            }
        }
    }

    public ExtensionObject readExtensionObject(ExtensionManager reader, String typeName, String value) throws ExtensionException {
        try {
            String[] s = value.split(":");
            long id = Long.parseLong(s[0]);
            Table table = this.getOrCreateTableFromId(id);
            if (s.length > 1) {
                table.addAll((LogoList)reader.readFromString(s[1]));
            }
            return table;
        }
        catch (CompilerException ex) {
            throw new ExtensionException(ex.getMessage());
        }
    }

    private Table getOrCreateTableFromId(long id) {
        for (Table table : tables.keySet()) {
            if (table.id != id) continue;
            return table;
        }
        return new Table(id);
    }

    private static boolean isValidKey(Object key) {
        return key instanceof Double || key instanceof String || key instanceof Boolean || key instanceof LogoList && TableExtension.containsOnlyValidKeys((LogoList)key);
    }

    private static void ensureKeyValidity(Object key) throws ExtensionException {
        if (!TableExtension.isValidKey(key)) {
            throw new ExtensionException(Dump.logoObject((Object)key) + " is not a valid table key (a table key may only be a number, a string, true or false, or a list whose items are valid keys)");
        }
    }

    private static boolean containsOnlyValidKeys(LogoList list) {
        Iterator it = list.javaIterator();
        while (it.hasNext()) {
            Object o = it.next();
            if (TableExtension.isValidKey(o)) continue;
            return false;
        }
        return true;
    }

    public static class GroupAgents
    implements org.nlogo.api.Reporter {
        public Syntax getSyntax() {
            return SyntaxJ.reporterSyntax((int[])new int[]{Syntax.AgentsetType(), Syntax.ReporterBlockType()}, (int)Syntax.WildcardType(), (String)"OTPL", (String)"-TPL");
        }

        public Object report(Argument[] args, Context context) throws ExtensionException, LogoException {
            AgentSet agents = (AgentSet)args[0].getAgentSet();
            Reporter classifier = ((org.nlogo.nvm.Argument)args[1]).unevaluatedArgument();
            org.nlogo.nvm.Context childContext = new org.nlogo.nvm.Context(((ExtensionContext)context).nvmContext(), agents);
            AgentIterator agentIter = agents.shufflerator(context.getRNG());
            Table result = new Table();
            while (agentIter.hasNext()) {
                Agent agent = agentIter.next();
                Object group = childContext.evaluateReporter(agent, classifier);
                TableExtension.ensureKeyValidity(group);
                ((AgentSetBuilder)result.computeIfAbsent(group, k -> new AgentSetBuilder(agents.kind()))).add(agent);
            }
            result.replaceAll((k, v) -> ((AgentSetBuilder)v).build());
            return result;
        }
    }

    public static class GroupItems
    implements org.nlogo.api.Reporter {
        public Syntax getSyntax() {
            return SyntaxJ.reporterSyntax((int[])new int[]{Syntax.ListType(), Syntax.ReporterType()}, (int)Syntax.WildcardType());
        }

        public Object report(Argument[] args, Context context) throws ExtensionException, LogoException {
            LogoList lst = args[0].getList();
            AnonymousReporter classifier = args[1].getReporter();
            Table result = new Table();
            for (Object x : lst.toJava()) {
                Object group = classifier.report(context, new Object[]{x});
                TableExtension.ensureKeyValidity(group);
                result.put(group, result.getOrDefault(group, LogoList.Empty()).lput(x));
            }
            return result;
        }
    }

    public static class Counts
    implements org.nlogo.api.Reporter {
        public Syntax getSyntax() {
            return SyntaxJ.reporterSyntax((int[])new int[]{Syntax.ListType()}, (int)Syntax.WildcardType());
        }

        public String getAgentClassString() {
            return "OTPL";
        }

        public Object report(Argument[] args, Context context) throws ExtensionException, LogoException {
            LogoList lst = args[0].getList();
            Table result = new Table();
            for (Object obj : lst.javaIterable()) {
                result.put(obj, 1.0 + result.getOrDefault(obj, 0.0));
            }
            return result;
        }
    }

    public static class FromList
    implements org.nlogo.api.Reporter {
        public Syntax getSyntax() {
            return SyntaxJ.reporterSyntax((int[])new int[]{Syntax.ListType()}, (int)Syntax.WildcardType());
        }

        public String getAgentClassString() {
            return "OTPL";
        }

        public Object report(Argument[] args, Context context) throws ExtensionException, LogoException {
            LogoList alist = args[0].getList();
            return new Table(alist);
        }
    }

    public static class Values
    implements org.nlogo.api.Reporter {
        public Syntax getSyntax() {
            return SyntaxJ.reporterSyntax((int[])new int[]{Syntax.WildcardType()}, (int)Syntax.ListType());
        }

        public String getAgentClassString() {
            return "OTPL";
        }

        public Object report(Argument[] args, Context context) throws ExtensionException, LogoException {
            Object arg0 = args[0].get();
            if (!(arg0 instanceof Table)) {
                throw new ExtensionException("not a table: " + Dump.logoObject((Object)arg0));
            }
            return ((Table)arg0).valuesList();
        }
    }

    public static class ToList
    implements org.nlogo.api.Reporter {
        public Syntax getSyntax() {
            return SyntaxJ.reporterSyntax((int[])new int[]{Syntax.WildcardType()}, (int)Syntax.ListType());
        }

        public String getAgentClassString() {
            return "OTPL";
        }

        public Object report(Argument[] args, Context context) throws ExtensionException, LogoException {
            Object arg0 = args[0].get();
            if (!(arg0 instanceof Table)) {
                throw new ExtensionException("not a table: " + Dump.logoObject((Object)arg0));
            }
            return ((Table)arg0).toList();
        }
    }

    public static class Remove
    implements Command {
        public Syntax getSyntax() {
            return SyntaxJ.commandSyntax((int[])new int[]{Syntax.WildcardType(), Syntax.WildcardType()});
        }

        public String getAgentClassString() {
            return "OTPL";
        }

        public void perform(Argument[] args, Context context) throws ExtensionException, LogoException {
            Object arg0 = args[0].get();
            if (!(arg0 instanceof Table)) {
                throw new ExtensionException("not a table: " + Dump.logoObject((Object)arg0));
            }
            ((Table)arg0).remove(args[1].get());
        }
    }

    public static class Put
    implements Command {
        public Syntax getSyntax() {
            return SyntaxJ.commandSyntax((int[])new int[]{Syntax.WildcardType(), Syntax.WildcardType(), Syntax.WildcardType()});
        }

        public String getAgentClassString() {
            return "OTPL";
        }

        public void perform(Argument[] args, Context context) throws ExtensionException, LogoException {
            Object arg0 = args[0].get();
            if (!(arg0 instanceof Table)) {
                throw new ExtensionException("not a table: " + Dump.logoObject((Object)arg0));
            }
            Object key = args[1].get();
            TableExtension.ensureKeyValidity(key);
            ((Table)arg0).put(key, args[2].get());
        }
    }

    public static class FromJSONFile
    implements org.nlogo.api.Reporter {
        public Syntax getSyntax() {
            return SyntaxJ.reporterSyntax((int[])new int[]{Syntax.StringType()}, (int)Syntax.WildcardType());
        }

        public String getAgentClassString() {
            return "OTPL";
        }

        public Object report(Argument[] args, Context context) throws ExtensionException, LogoException {
            FileManager fm = ((ExtensionContext)context).workspace().fileManager();
            try {
                String path = fm.attachPrefix(args[0].getString());
                File file = new File(path.toString());
                if (!file.exists()) {
                    throw new ExtensionException(args[0].get().toString() + " does not exist.");
                }
                Gson gson = new Gson();
                try {
                    Map map = (Map)gson.fromJson((Reader)new FileReader(path), Map.class);
                    return new Table((Map<?, ?>)map);
                }
                catch (JsonSyntaxException e) {
                    throw new ExtensionException("Error trying to read the JSON file. It is probably missing a colon or comma. See the line number on the next line: " + e.getMessage());
                }
            }
            catch (IOException e) {
                throw new ExtensionException(e.getMessage());
            }
        }
    }

    public static class Make
    implements org.nlogo.api.Reporter {
        public Syntax getSyntax() {
            return SyntaxJ.reporterSyntax((int)Syntax.WildcardType());
        }

        public String getAgentClassString() {
            return "OTPL";
        }

        public Object report(Argument[] args, Context context) throws ExtensionException, LogoException {
            return new Table();
        }
    }

    public static class Length
    implements org.nlogo.api.Reporter {
        public Syntax getSyntax() {
            return SyntaxJ.reporterSyntax((int[])new int[]{Syntax.WildcardType()}, (int)Syntax.NumberType());
        }

        public String getAgentClassString() {
            return "OTPL";
        }

        public Object report(Argument[] args, Context context) throws ExtensionException, LogoException {
            Object arg0 = args[0].get();
            if (!(arg0 instanceof Table)) {
                throw new ExtensionException("not a table: " + Dump.logoObject((Object)arg0));
            }
            return (double)((Table)arg0).size();
        }
    }

    public static class Keys
    implements org.nlogo.api.Reporter {
        public Syntax getSyntax() {
            return SyntaxJ.reporterSyntax((int[])new int[]{Syntax.WildcardType()}, (int)Syntax.ListType());
        }

        public String getAgentClassString() {
            return "OTPL";
        }

        public Object report(Argument[] args, Context context) throws ExtensionException, LogoException {
            Object arg0 = args[0].get();
            if (!(arg0 instanceof Table)) {
                throw new ExtensionException("not a table: " + Dump.logoObject((Object)arg0));
            }
            return LogoList.fromJava(((Table)arg0).keySet());
        }
    }

    public static class HasKey
    implements org.nlogo.api.Reporter {
        public Syntax getSyntax() {
            return SyntaxJ.reporterSyntax((int[])new int[]{Syntax.WildcardType(), Syntax.WildcardType()}, (int)Syntax.BooleanType());
        }

        public String getAgentClassString() {
            return "OTPL";
        }

        public Object report(Argument[] args, Context context) throws ExtensionException, LogoException {
            Object arg0 = args[0].get();
            if (!(arg0 instanceof Table)) {
                throw new ExtensionException("not a table: " + Dump.logoObject((Object)arg0));
            }
            return ((Table)arg0).containsKey(args[1].get());
        }
    }

    public static class GetOrDefault
    implements org.nlogo.api.Reporter {
        public Syntax getSyntax() {
            return SyntaxJ.reporterSyntax((int[])new int[]{Syntax.WildcardType(), Syntax.WildcardType(), Syntax.WildcardType()}, (int)Syntax.WildcardType());
        }

        public Object report(Argument[] args, Context context) throws ExtensionException {
            Object table = args[0].get();
            if (!(table instanceof Table)) {
                throw new ExtensionException("not a table: " + Dump.logoObject((Object)table));
            }
            Object key = args[1].get();
            return ((Table)table).getOrDefault(key, args[2].get());
        }
    }

    public static class Get
    implements org.nlogo.api.Reporter {
        public Syntax getSyntax() {
            return SyntaxJ.reporterSyntax((int[])new int[]{Syntax.WildcardType(), Syntax.WildcardType()}, (int)Syntax.WildcardType());
        }

        public String getAgentClassString() {
            return "OTPL";
        }

        public Object report(Argument[] args, Context context) throws ExtensionException, LogoException {
            Object arg0 = args[0].get();
            if (!(arg0 instanceof Table)) {
                throw new ExtensionException("not a table: " + Dump.logoObject((Object)arg0));
            }
            Object key = args[1].get();
            Object result = ((Table)arg0).get(key);
            if (result == null) {
                throw new ExtensionException("No value for " + Dump.logoObject((Object)key) + " in table.");
            }
            return result;
        }
    }

    public static class Clear
    implements Command {
        public Syntax getSyntax() {
            return SyntaxJ.commandSyntax((int[])new int[]{Syntax.WildcardType()});
        }

        public String getAgentClassString() {
            return "OTPL";
        }

        public void perform(Argument[] args, Context context) throws ExtensionException, LogoException {
            Object arg0 = args[0].get();
            if (!(arg0 instanceof Table)) {
                throw new ExtensionException("not a table: " + Dump.logoObject((Object)arg0));
            }
            ((Table)arg0).clear();
        }
    }

    public static class Table
    extends LinkedHashMap<Object, Object>
    implements ExtensionObject {
        private final long id;

        public Table() {
            tables.put(this, next);
            this.id = next;
            next++;
        }

        public Table(LogoList alist) throws ExtensionException {
            this();
            this.addAll(alist);
        }

        public void addAll(LogoList alist) throws ExtensionException {
            Iterator it = alist.javaIterator();
            while (it.hasNext()) {
                Object pair = it.next();
                if (pair instanceof LogoList && ((LogoList)pair).size() < 2 || !(pair instanceof LogoList)) {
                    throw new ExtensionException("expected a two-element list: " + Dump.logoObject(pair));
                }
                this.put(((LogoList)pair).first(), ((LogoList)pair).butFirst().first());
            }
        }

        public Table(long id) {
            this.id = id;
            tables.put(this, id);
            next = StrictMath.max(next, id + 1L);
        }

        public Table(Map<?, ?> map) {
            tables.put(this, next);
            this.id = next;
            next++;
            for (Map.Entry<?, ?> entry : map.entrySet()) {
                this.put(entry.getKey(), this.getTableValue(entry.getValue()));
            }
        }

        private Object getTableValue(Object value) {
            if (value instanceof LinkedTreeMap) {
                return new Table((Map<?, ?>)((Map)value));
            }
            if (value instanceof ArrayList) {
                LogoListBuilder alist = new LogoListBuilder();
                ((ArrayList)value).forEach((? super E temp) -> alist.add(this.getTableValue(temp)));
                return alist.toLogoList();
            }
            return value;
        }

        @Override
        public boolean equals(Object obj) {
            return this == obj;
        }

        public LogoList toList() {
            LogoListBuilder alist = new LogoListBuilder();
            for (Map.Entry entry : this.entrySet()) {
                LogoListBuilder pair = new LogoListBuilder();
                pair.add(entry.getKey());
                pair.add(entry.getValue());
                alist.add((Object)pair.toLogoList());
            }
            return alist.toLogoList();
        }

        public LogoList valuesList() {
            LogoListBuilder alist = new LogoListBuilder();
            for (Map.Entry entry : this.entrySet()) {
                alist.add(entry.getValue());
            }
            return alist.toLogoList();
        }

        public String dump(boolean readable, boolean exportable, boolean reference) {
            if (exportable && reference) {
                return "" + this.id;
            }
            return (exportable ? this.id + ": " : "") + Dump.logoObject((Object)this.toList(), (boolean)true, (boolean)exportable);
        }

        public String getExtensionName() {
            return "table";
        }

        public String getNLTypeName() {
            return "";
        }

        public boolean recursivelyEqual(Object o) {
            if (!(o instanceof Table)) {
                return false;
            }
            Table otherTable = (Table)o;
            if (this.size() != otherTable.size()) {
                return false;
            }
            for (Object key : this.keySet()) {
                if (otherTable.containsKey(key) && Equality.equals(this.get(key), otherTable.get(key))) continue;
                return false;
            }
            return true;
        }
    }
}

