/*
 * Decompiled with CFR 0.152.
 */
import org.nlogo.agent.Link;
import org.nlogo.agent.Patch;
import org.nlogo.agent.Turtle;
import org.nlogo.api.AgentException;
import org.nlogo.api.Argument;
import org.nlogo.api.Color;
import org.nlogo.api.Context;
import org.nlogo.api.ExtensionException;
import org.nlogo.core.AgentKindJ;
import org.nlogo.core.LogoList;

public class ColorManager {
    public static LogoList getAgentColor(Context context) {
        LogoList rgb = Color.getRGBListByARGB((int)1);
        if (context.getAgent().kind() == AgentKindJ.Link()) {
            Link link = (Link)context.getAgent();
            rgb = link.color() instanceof Double ? Color.getRGBListByARGB((int)Color.getARGBbyPremodulatedColorNumber((double)Color.modulateDouble((double)((Double)link.color())))) : (LogoList)link.color();
        } else if (context.getAgent().kind() == AgentKindJ.Patch()) {
            Patch patch = (Patch)context.getAgent();
            rgb = patch.pcolor() instanceof Double ? Color.getRGBListByARGB((int)Color.getARGBbyPremodulatedColorNumber((double)Color.modulateDouble((double)((Double)patch.pcolor())))) : (LogoList)patch.pcolor();
        } else if (context.getAgent().kind() == AgentKindJ.Turtle()) {
            Turtle turtle = (Turtle)context.getAgent();
            rgb = turtle.color() instanceof Double ? Color.getRGBListByARGB((int)Color.getARGBbyPremodulatedColorNumber((double)Color.modulateDouble((double)((Double)turtle.color())))) : (LogoList)turtle.color();
        }
        return rgb;
    }

    public static void setAgentColor(Context context, LogoList rgb) throws ExtensionException {
        if (context.getAgent().kind() == AgentKindJ.Link()) {
            Link link = (Link)context.getAgent();
            try {
                link.color(rgb);
            }
            catch (AgentException a) {
                throw new ExtensionException("Internal error when setting color of Links in ColorManager.java");
            }
        }
        if (context.getAgent().kind() == AgentKindJ.Patch()) {
            Patch patch = (Patch)context.getAgent();
            try {
                patch.pcolor(rgb);
            }
            catch (AgentException a) {
                throw new ExtensionException("Internal error when setting color of Patch in ColorManager.java");
            }
        }
        if (context.getAgent().kind() == AgentKindJ.Turtle()) {
            Turtle turtle = (Turtle)context.getAgent();
            try {
                turtle.color(rgb, 1);
            }
            catch (AgentException a) {
                throw new ExtensionException("Internal error when setting color of Turtles in ColorManager.java");
            }
        }
    }

    public static LogoList extractColorFromArg(Argument arg) throws ExtensionException {
        LogoList rgb = Color.getRGBListByARGB((int)1);
        Object val = arg.get();
        if (val instanceof Double) {
            double color = (Double)val;
            rgb = Color.getRGBListByARGB((int)Color.getARGBbyPremodulatedColorNumber((double)Color.modulateDouble((double)color)));
        } else {
            rgb = (LogoList)val;
            try {
                Color.validRGBList((LogoList)rgb, (boolean)true);
            }
            catch (AgentException a) {
                throw new ExtensionException("Color must have a valid RGB List.");
            }
        }
        return rgb;
    }
}

