/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jeuclid.elements.presentation.token;

import java.awt.Font;
import java.awt.font.TextAttribute;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import net.sourceforge.jeuclid.LayoutContext;
import net.sourceforge.jeuclid.elements.presentation.token.AbstractTokenWithTextLayout;
import net.sourceforge.jeuclid.elements.support.GraphicsSupport;
import net.sourceforge.jeuclid.elements.support.text.StringUtil;
import net.sourceforge.jeuclid.elements.support.text.TextContentModifier;
import net.sourceforge.jeuclid.font.FontFactory;
import org.apache.batik.dom.AbstractDocument;
import org.w3c.dom.Node;
import org.w3c.dom.mathml.MathMLGlyphElement;

public final class Mglyph
extends AbstractTokenWithTextLayout
implements MathMLGlyphElement,
TextContentModifier {
    public static final String ELEMENT = "mglyph";
    private static final String ATTR_ALT = "alt";
    private static final String ATTR_FONTFAMILY = "fontfamily";
    private static final String ATTR_INDEX = "index";
    private static final long serialVersionUID = 1L;

    public Mglyph(String string, AbstractDocument abstractDocument) {
        super(string, abstractDocument);
    }

    protected Node newNode() {
        return new Mglyph(this.nodeName, this.ownerDocument);
    }

    public AttributedCharacterIterator modifyTextContent(AttributedCharacterIterator attributedCharacterIterator, LayoutContext layoutContext) {
        AttributedString attributedString;
        String string = this.getFontfamily();
        String string2 = string == null ? "serif" : string.trim();
        Font font = FontFactory.getInstance().getFont(string2, 0, GraphicsSupport.getFontsizeInPoint(layoutContext));
        int n = this.getIndex();
        if (n > 0 && font.getFamily().equalsIgnoreCase(string2) && font.canDisplay(n)) {
            attributedString = new AttributedString(new String(new int[]{n}, 0, 1));
            attributedString.addAttribute(TextAttribute.FONT, font);
        } else {
            attributedString = StringUtil.convertStringtoAttributedString(this.getAlt(), this.getMathvariantAsVariant(), GraphicsSupport.getFontsizeInPoint(layoutContext), layoutContext);
        }
        return attributedString.getIterator();
    }

    public String getAlt() {
        return this.getMathAttribute(ATTR_ALT);
    }

    public String getFontfamily() {
        return this.getMathAttribute(ATTR_FONTFAMILY);
    }

    public int getIndex() {
        int n = 0;
        String string = this.getMathAttribute(ATTR_INDEX);
        try {
            if (string != null) {
                n = Integer.parseInt(string);
            }
        }
        catch (NumberFormatException numberFormatException) {
            n = 0;
        }
        return n;
    }

    public void setAlt(String string) {
        this.setAttribute(ATTR_ALT, string);
    }

    public void setFontfamily(String string) {
        this.setAttribute(ATTR_FONTFAMILY, string);
    }

    public void setIndex(int n) {
        this.setAttribute(ATTR_INDEX, Integer.toString(n));
    }
}

