/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jeuclid.context.typewrapper;

import java.awt.Color;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Locale;
import net.sourceforge.jeuclid.context.typewrapper.AbstractSimpleTypeWrapper;
import net.sourceforge.jeuclid.context.typewrapper.TypeWrapper;
import net.sourceforge.jeuclid.elements.support.attributes.AttributesHelper;

public final class ColorTypeWrapper
extends AbstractSimpleTypeWrapper {
    private static final long serialVersionUID = 1L;
    private static final TypeWrapper INSTANCE = new ColorTypeWrapper();

    private ColorTypeWrapper() {
        super(Color.class);
    }

    public static TypeWrapper getInstance() {
        return INSTANCE;
    }

    public Object fromString(String string) {
        Color color = AttributesHelper.stringToColor(string, null);
        if (color == null) {
            throw new IllegalArgumentException('<' + string + "> is not a valid color representation");
        }
        return color;
    }

    public String toString(Object object) {
        if (object == null) {
            return null;
        }
        String string = null;
        try {
            for (Field field : Color.class.getFields()) {
                if (!Modifier.isStatic(field.getModifiers()) || field.get(null) != object) continue;
                string = field.getName().toLowerCase(Locale.ENGLISH);
                break;
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            string = null;
        }
        if (string == null) {
            string = AttributesHelper.colorTOsRGBString((Color)object);
        }
        return string;
    }
}

